(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2848347,      55134]
NotebookOptionsPosition[   2844386,      55078]
NotebookOutlinePosition[   2844742,      55094]
CellTagsIndexPosition[   2844699,      55091]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"P", "/", "Q"}], "-", 
    RowBox[{"type_", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dir", "=", "\"\<E:\\\\Analysis\\\\220108\\\\\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi1", "=", "\"\<Munc13-1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi2", "=", "\"\<Cav2.1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt", "=", 
     RowBox[{"{", "\"\<1 W2\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko", "=", 
     RowBox[{"{", "\"\<1 K2\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"field", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\s\>\"", ",", 
         RowBox[{"ToString", "[", "i", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "normalization", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"wt", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm594", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm635", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm594s", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"Flatten", "[", "res3", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm635s", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"Flatten", "[", "res4", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "WT", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"wt", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res5", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res6", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res7", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res1", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res1", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res2", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res2", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res5", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res5", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res6", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res6", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res7", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res7", ",", 
          RowBox[{"Import", "[", "\"\<res_distance.dat\>\"", "]"}]}], "]"}]}],
        ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt594", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/", "norm594"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt635", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/", "norm635"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta594", "=", 
     RowBox[{"Flatten", "[", "res1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta635", "=", 
     RowBox[{"Flatten", "[", "res2", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt594s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res3", "]"}], "/", "norm594s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt635s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res4", "]"}], "/", "norm635s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtn594", "=", 
     RowBox[{"Flatten", "[", "res5", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtn635", "=", 
     RowBox[{"Flatten", "[", "res6", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtd", "=", 
     RowBox[{"Flatten", "[", "res7", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "KO", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"ko", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res5", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res6", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res7", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res1", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res1", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res2", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res2", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res5", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res5", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res6", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res6", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res7", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res7", ",", 
          RowBox[{"Import", "[", "\"\<res_distance.dat\>\"", "]"}]}], "]"}]}],
        ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko594", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/", "norm594"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko635", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/", "norm635"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa594", "=", 
     RowBox[{"Flatten", "[", "res1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa635", "=", 
     RowBox[{"Flatten", "[", "res2", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko594s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res3", "]"}], "/", "norm594s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko635s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res4", "]"}], "/", "norm635s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kon594", "=", 
     RowBox[{"Flatten", "[", "res5", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kon635", "=", 
     RowBox[{"Flatten", "[", "res6", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kod", "=", 
     RowBox[{"Flatten", "[", "res7", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "Dataset", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", "wta", "]"}]}], ",", 
         RowBox[{"\"\<area\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "wta", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt594", "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", "koa", "]"}]}], ",", 
         RowBox[{"\"\<area\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "koa", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko594", "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "wta635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "wta594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wta635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wta594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt635s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt594s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wtn635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wtn594", "]"}]}], ",", 
         RowBox[{"\"\<Distance\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "wtd", "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "koa635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "koa594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "koa635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "koa594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko635s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko594s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "kon635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "kon594", "]"}]}], ",", 
         RowBox[{"\"\<Distance\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "kod", "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "Graphics", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", "wt635", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", "ko635", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", "wt594", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", "ko594", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", "wt635s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", "ko635s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", "wt594s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", "ko594s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtn635", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kon635", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtn594", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kon594", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster number / AZ (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster number / AZ (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtd", "*", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kod", "*", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CDF", "[", 
        RowBox[{"dwt", ",", "x"}], "]"}], ",", 
       RowBox[{"CDF", "[", 
        RowBox[{"dko", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Center-to-center distance (nm)\>\"", ",", "20", ",", "Black"}], 
         "]"}], ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}],
          "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8490785744893527`*^9, 3.849078592937791*^9}, {
   3.849150057783285*^9, 3.849150088260768*^9}, {3.850625060909653*^9, 
   3.8506250653280144`*^9}, {3.85062548508819*^9, 3.850625556336025*^9}, {
   3.8506256259396224`*^9, 3.8506257831665354`*^9}, {3.850625854479589*^9, 
   3.850625862748068*^9}, {3.8506259831542807`*^9, 3.850625987361233*^9}, {
   3.8506260205554657`*^9, 3.850626027087844*^9}, {3.8506260726259556`*^9, 
   3.850626113852969*^9}, {3.850626257812451*^9, 3.850626266894292*^9}, {
   3.850626731603856*^9, 3.850626733040183*^9}, {3.850871299147781*^9, 
   3.8508713343705506`*^9}, {3.850874080726308*^9, 3.850874087125987*^9}, {
   3.852254098233091*^9, 3.8522540986875916`*^9}, {3.852254130733729*^9, 
   3.8522541377827897`*^9}, 3.855044612397657*^9, {3.8550997212315254`*^9, 
   3.8550997255243416`*^9}, {3.8551057418923025`*^9, 
   3.8551057456240997`*^9}, {3.855105806727172*^9, 3.8551058077332487`*^9}, {
   3.8580514839299955`*^9, 3.858051484992285*^9}, {3.858051949139613*^9, 
   3.8580519501080985`*^9}, {3.858052016320162*^9, 3.858052020756622*^9}, {
   3.858052306182051*^9, 3.8580523071661615`*^9}},
 CellLabel->
  "In[259]:=",ExpressionUUID->"295cd36a-6274-41e1-8078-bfcbe58394cb"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "area", "Total Munc13-1 intensity", 
            "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[8]} -> 1, {All, "n"} -> 
           1, {All, "area"} -> 1, {All, "Total Munc13-1 intensity"} -> 
           1, {All, "Total Cav2.1 intensity"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "n" -> TypeSystem`PackageScope`AtomShape[34], "area" -> 
               TypeSystem`PackageScope`AtomShape[34], 
               "Total Munc13-1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60], 
               "Total Cav2.1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60]]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[953530921], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "area", "Total Munc13-1 intensity", 
            "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[953530921]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"n\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"n\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    All, "n"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[All, "n"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    All, "area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[All, "area"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    All, "Total Munc13-1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[All, "Total Munc13-1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    All, "Total Cav2.1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[All, "Total Cav2.1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["485"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["290.01"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["587"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["272.772"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.12822"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0.95479"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 650155079]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[650155079][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {455., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.8580523141971254`*^9},
 CellLabel->
  "Out[298]=",ExpressionUUID->"02f6a039-5b33-4a5e-90f9-5fe8599145eb"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 area", "Cav2.1 area", 
            "Munc13-1 intensity", "Cav2.1 intensity", "Munc13-1 #/az", 
            "Cav2.1 #/az", "Distance"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[9]} -> 1, {All, "Munc13-1 (n)"} -> 
           1, {All, "Cav2.1 (n)"} -> 1, {All, "Munc13-1 area"} -> 
           1, {All, "Cav2.1 area"} -> 1, {All, "Munc13-1 intensity"} -> 
           1, {All, "Cav2.1 intensity"} -> 1, {All, "Munc13-1 #/az"} -> 
           1, {All, "Cav2.1 #/az"} -> 1, {All, "Distance"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "Munc13-1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 area" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 area" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 intensity" -> TypeSystem`PackageScope`AtomShape[60], 
               "Cav2.1 intensity" -> TypeSystem`PackageScope`AtomShape[60], 
               "Munc13-1 #/az" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 #/az" -> TypeSystem`PackageScope`AtomShape[34], 
               "Distance" -> TypeSystem`PackageScope`AtomShape[60]]]]], 
           2, {}]], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[211775101], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 area", "Cav2.1 area", 
            "Munc13-1 intensity", "Cav2.1 intensity", "Munc13-1 #/az", 
            "Cav2.1 #/az", "Distance"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[211775101]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Munc13-1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Munc13-1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Cav2.1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Cav2.1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Munc13-1 area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Munc13-1 area"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Cav2.1 area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Cav2.1 area"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Munc13-1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Munc13-1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 intensity\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Cav2.1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Cav2.1 intensity"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 #/az\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 #/az\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Munc13-1 #/az"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Munc13-1 #/az"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 #/az\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 #/az\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Cav2.1 #/az"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Cav2.1 #/az"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Distance\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Distance\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1324165448][{All, "Distance"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[All, "Distance"]], "Mouse"], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1324165448][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1324165448][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1759"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1156"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["37.0205"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["42.1479"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3.6268"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2.40619"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6.49928"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Distance"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1324165448][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1324165448][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2057"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1330"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["35.3131"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["40.8647"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.16235"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.03172"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3.50596"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2.29472"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6.33496"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Distance"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1324165448][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1324165448]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1324165448][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {897., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.85805231457205*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"6be33c22-9c56-4d12-81bd-b80e875d6a0f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAApPfnWmXDyT+GbfnZoZNLPzKsEQYc
CMo/eZIyLnY6Yj/JLsVgzTDKP3kCksLJ8Gg/YLF4u35Zyj95cvFWHadvP422
33Dhqso/JynYP+KJdj/owK3bpk3LP4mES7RE+4E/ntVJsTGTzD90ZArd62eP
Pwv/gVxHHs8/KhJEF50gnT+YaVdeLEbPP6k8Keww850/JNQsYBFuzz8iZw7B
xMWePz6p12Pbvc8/EF5sNXY1oD+5qZa1ty7QPw2zNt+d2qE/7VPsvEvO0D8I
Xcsy7SSlP1Wol8tzDdI//bD02Yu5qz8lUe7ow4vUP3SsI5RkcbQ/Gn9HOmeh
1D983h7Pf6q0PxCtoIsKt9Q/hhAaCpvjtD/6CFMuUeLUP5Z0EIDRVbU/0MC3
c9441T+7PP1rPjq2P3owgf745dU/AM3WQxgDuD/ODxQULkDXP4ntifPLlLs/
wz1tZdFV1z+RH4Uu5827P7hrxrZ0a9c/mVGAaQIHvD+jx3hZu5bXP6u1dt84
ebw/eH/dnkjt1z/OfWPLpV29P22tNvDrAtg/1q9eBsGWvT9i249BjxjYP97h
WUHcz70/TTdC5NVD2D/wRVC3EkK+PyLvpiljmtg/Eg49o38mvz8XHQB7BrDY
PxpAON6aX78/DEtZzKnF2D8icjMZtpi/P/emC2/w8Ng/GuuUR3YFwD/s1GTA
kwbZPx6EEuUDIsA/4gK+ETcc2T8kHZCCkT7AP8xecLR9R9k/K0+Lvax3wD/C
jMkFIV3ZPzHoCFs6lMA/t7oiV8Ry2T81gYb4x7DAP5Vq8rizhNk/pGaos3LI
wD/SBCyO
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T/zQ+yH3hbBP4xyh5xR
ydk/qkWQwx9YwT93zjk/mPTZP+tpT/hpwcE/Di615ckI2j/MdAeti/LBP6SN
MIz7HNo/q3+/Ya0jwj/RTCfZXkXaP2qVL8vwhcI/K8sUcyWW2j/pwA+ed0rD
P9/H76ayN9s/5hfQQ4XTxD9HwaUOzXrcP+HFUI+g5cc/F7QR3gEB3z/WIVIm
1wnOP1yM+1TkFt8/Cu5Y4xU/zj+iZOXLxizfP0C6X6BUdM4/LBW5uYtY3z+o
Um0a0t7OP0J2YJUVsN8/fIOIDs2zzz82nFemlC/gP49yX3vhrtA/YV6mXaje
4D801JVj11jSP4RKG5mZ6eA/UDoZwnZz0j+mNpDUivTgP2ignCAWjtI/7A56
S20K4T+ebKPdVMPSP3a/TTkyNuE/BgWxV9It0z+MIPUUvI3hP9o1zEvNAtQ/
tuJDzM884j99lwI0w6zVP9ZIgfGNR+I/EEZbR+bG1T/2rr4WTFLiP6L0s1oJ
4dU/N3s5Ychn4j/KUWWBTxXWP7gTL/bAkuI/FgzIztt91j/YeWwbf53iP6i6
IOL+l9Y/+N+pQD2o4j87aXn1IbLWPzisJIu5veI/YMYqHGjm1j+5RBogsuji
P6yAjWn0Ttc/2qpXRXDz4j9BL+Z8F2nXP/oQlWou/uI/1N0+kDqD1z863Q+1
qhPjP/g68LaAt9c/WkNN2mge4z+L6UjKo9HXP7Cb30LAKOM/pm5g6Mzq1z/n
ASPe
                "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z+lgPLQzxTYP9rbQm9h
SeM/Ay10728n2D/6QYCUH1TjP9xqTCV+ONg/Ow773ptp4z+Q5vyQmlrYP7ym
8HOUlOM/9d1daNOe2D/cDC6ZUp/jP84bNp7hr9g//HJrvhCq4z+oWQ7U78DY
Pz0/5giNv+M/W9W+Pwzj2D++19udherjP8HMHxdFJ9k/vwjHx3ZA5D+Lu+HF
tq/ZP8JqnRtZ7OQ/IZllI5rA2j/1Jj0PrW3nP97o/vfKut4/PuJCx4p45z+5
oExOC8zeP4adSH9og+c/kliapEvd3j8WFFTvI5nnP0TINVHM/94/NgFrz5rE
5z+pp2yqzUTfP3jbmI+IG+g/dmbaXNDO3z/8j/QPZMnoPwjy2uBqceA/REv6
x0HU6D/1zQEMC3rgP4wGAIAf3+g/4qkoN6uC4D8dfQvw2vToP7xhdo3rk+A/
Pmoi0FEg6T9v0RE6bLbgP4YlKIgvK+k/W604ZQy/4D/O4C1ADTbpP0iJX5Cs
x+A/Xlc5sMhL6T8hQa3m7NjgP39EUJA/d+k/1LBIk2374D/I/1VIHYLpP8KM
b74NBOE/ELtbAPuM6T+uaJbprQzhPxcCRqkmj+k/K1fUAGcO4T+9CPOR
                "]], 
               LineBox[{{0.8012755102040817, 0.5347175468125395}, {
                0.8024388112602567, 0.535353164915398}, {0.8037652381656297, 
                0.5360779136368904}, {0.8064180919763757, 
                0.5375274110798753}, {0.8170295072193599, 
                0.5433254008518151}, {0.8182677985372807, 
                0.5440019930152152}, {0.8195060898552016, 
                0.5446785851786152}, {0.8219826724910432, 
                0.5460317695054153}, {0.8269358377627265, 
                0.5487381381590155}, {0.8368421683060933, 
                0.5541508754662159}, {0.8566548293928267, 
                0.5649763500806166}, {0.8962801515662935, 
                0.586627299309418}, {0.9739717509693491, 
                0.6290773484677886}, {0.9987244897959183, 
                0.6426020408163265}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D8HziJdUprkP+v3397V
MPI/giX8cQNw5j+2Z4/CSjbyP8SbIVKgdOY/gNc+pr878j8FEkcyPXnmPxa3
nW2pRvI/if6R8naC5j9Cdlv8fFzyP5LXJ3PqlOY/mvTWGSSI8j+iiVN00bnm
P2Vkhv2YjfI/5P94VG6+5j8w1DXhDZPyPyZ2njQLw+Y/xrOUqPed8j+qYun0
RMzmP/FyUjfLs/I/sTt/dbje5j9I8c1Uct/yP8HtqnafA+c/E2F9OOfk8j8D
ZNBWPAjnP97QLBxc6vI/Rdr1NtkM5z90sIvjRfXyP8nGQPcSFuc/n29JchkL
8z/Qn9Z3hijnP2rf+FWOEPM/Ehb8VyMt5z80T6g5AxbzP1SMITjAMec/yi4H
Ae0g8z/YeGz4+TrnP5WetuRhJvM/Gu+R2JY/5z9gDmbI1ivzP1xlt7gzROc/
cmcJu/kt8z+F3fwWAkbnP7I4uOg=
                "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA9P5cq2w48z/AnZzhcE3nP8FddHM1
PPM/MXCKLaBP5z+MzSNXqkHzP9skJ6HGUuc/Iq2CHpRM8z8vjmCIE1nnP01s
QK1nYvM/1mDTVq1l5z+k6rvKDo7zPyUGufPgfuc/bpdPI2qT8z8j8y2o+IHn
PzdE43vFmPM/IeCiXBCF5z/KnQotfKPzPxy6jMU/i+c/8VBZj+m48z8TbmCX
npfnPz639lPE4/M/ANYHO1yw5z/ZgzHdeTn0P9ulVoLX4ec/Dh2n7+Tk9D+Q
RfQQzkToP0BWg93j6fQ/tznFarBH6D9yj1/L4u70P94tlsSSSug/1gEYp+D4
9D8tFjh4V1DoP57miF7cDPU/y+Z73+Bb6D8usGrN0zT1PwaIA67zcug/TUMu
q8KE9T99yhJLGaHoP358CpnBifU/o77jpPuj6D+wteaGwI71P8uytP7dpug/
FCifYr6Y9T8am1ayoqzoP9wMEBq6rPU/t2uaGSy46D9s1vGIsdT1P/MMIug+
z+g/jGm1ZqAk9j9qTzGFZP3oP+pArYgLKvY/Od7SVoUA6T9HGKWqdi/2Pwht
dCimA+k/AseU7kw69j+mirfL5wnpP3kkdHb5T/Y/48U9EmsW6T+lmjzuLGH2
P7Ixj0dZIOk/l57+Sw==
                "]], 
               LineBox[{{1.4012755102040815`, 0.7858431516936673}, {
                1.4064308709161404`, 0.7869592607138037}, {1.407753743734141, 
                0.7872456558599688}, {1.410399489370142, 
                0.7878184461522989}, {1.415690980642144, 
                0.7889640267369591}, {1.426273963186148, 
                0.7912551879062796}, {1.4686058933621644`, 
                0.8004198325835614}, {1.547629076117258, 
                0.8175279443140456}, {1.5987244897959185`, 
                0.8285898379970547}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T89KnPJp4jqP/tq1Jsp
evs/cmRuzt9z6z9UNl2RLn/7P7ANlalbdus/rAHmhjOE+z/vtruE13jrP16Y
93E9jvs/bAkJO8996z/BxRpIUaL7P2Wuo6e+h+s/hyBh9HjK+z9Y+NiAnZvr
PxPW7UzIGvw/P4xDM1vD6z9soXZCzR/8P301ag7Xxes/xGz/N9Ik/D+73pDp
UsjrP3YDESPcLvw/ODHen0rN6z/ZMDT570L8PzLWeAw61+s/n4t6pRdr/D8l
IK7lGOvrP/hWA5sccPw/Y8nUwJTt6z9QIoyQIXX8P6Fy+5sQ8Os/Armdeyt/
/D8exUhSCPXrP2XmwFE/k/w/GGrjvvf+6z++sUlHRJj8P1YTCppzAew/Fn3S
PEmd/D+UvDB17wPsP8gT5CdTp/w/Eg9+K+cI7D8rQQf+Zrv8Pwu0GJjWEuw/
sKqrJ9jA/D8jdIT+hxXsPzQUUFFJxvw/OjTwZDkY7D8MAaNUk8f8P3qEHrPc
GOw/XNLFHg==
                "]], LineBox[CompressedData["
1:eJwV0FtIk2EAh/FNyy6iiVkNysyJrDTPSpKUf6N5NpmRG0hu6vIE2WENUinK
skSZGjpLTI0ykZgiyrQyq2WmRDpFpjaTiUeM3mGT0nLfvje7eHjuf4LMy2ez
HDgcjnCr/6+sWxc5jTMonvVq/OVGoBefNDRMMliOeNsa404Q1Tu3sWuGQfyA
0GA6RJBU4ZPwc5mB8+jf/awnwfi6QZVBGCjPKU498CKQpl9rGrcymDAN53gK
CdJD+qw6hsHjxSe6aG8CpelMXeFuOw5vRiVVBRC8vqoJVufZIRGbdZ2xBDHP
BDmdfBY6hndnvYggtI4nHHRj0XZPaMu/QeBRaVucFrBo5kWolm4SbBZOZG7z
ZVHjkZ9tvE3Qnlwmk0ayUIq+xHfdJ3DlWlPsuSyC1KWul6oJZuV6UVwvi/YD
nJalFwTDKe2OsvcsWp7z3dO0BK8S6vuVAywa/QIeGdsIqsNUkQ0GFhWQlX3s
2PJwPnJidZ7FRUVf/tNuAu27qpDanRQ+2oJjaR8Irh+Ue86dp2gNtw4ZvxJk
igMlMxkUn2dVc6LpLb+73PKpbIofJX82dd8IhN+brSNXKPxHqV+tmcCoW9H3
llB0K3ialEWCwESlXNNG0a8+mj65SuB263RNVSfFYlBHYbSVYEfXnqHyHgqn
qeCanjUCM/+lf7GeIk4QPvjwN4F6wWbPN1KMdcf6Sm0EBftGgvJMFNbU4agh
hkAR15R1wUzhyhHLw1iC8I7IkdQVCkm8tJrPtUA478KVWCgKVqe1pQ4WuOxd
CE1eo6jXyD5tOFrAxOhyEzco3hyfN+dstwChk6WDmxRF3u5juU4W/ANpQEip

                "]], 
               LineBox[{{2.001275510204082, 0.9073216915632234}, {
                2.0039562426140143`, 0.9075427828960013}, {2.008820753763886, 
                0.907943979691867}, {2.0185497760636295`, 
                0.9087463732835984}, {2.0380078206631165`, 
                0.9103511604670612}, {2.0393271393937447`, 
                0.910459970259278}, {2.0406464581243724`, 
                0.9105687800514948}, {2.0432850955856283`, 
                0.9107863996359282}, {2.0485623705081406`, 
                0.9112216388047952}, {2.0591169203531647`, 
                0.9120921171425291}, {2.080226020043213, 0.913833073817997}, {
                2.122444219423309, 0.9173149871689328}, {2.1987244897959184`, 
                0.9236061434883233}}], 
               LineBox[{{2.201275510204082, 0.9238033873343153}, {
                2.2866398821120604`, 0.9299637028328293}, {
                2.3704807786936803`, 0.9360140768129461}, {2.398724489795918, 
                0.9380522827687777}}], 
               LineBox[{{2.4012755102040817`, 0.9382232274353042}, {
                2.5334854370252864`, 0.9464011610531106}, {
                2.5987244897959183`, 0.9504365663791291}}], 
               LineBox[{{2.601275510204082, 0.9505943614559227}, {
                2.6902539155813803`, 0.9560981803452401}, {2.774462852749733, 
                0.9613069805824578}, {2.798724489795918, 
                0.9628077003997476}}], 
               LineBox[{{2.8012755102040816`, 0.9629523458868083}, {
                2.9382035922548035`, 0.970010494446124}, {2.939446276666315, 
                0.9700745503436246}, {2.940688961077826, 0.970138606241125}, {
                2.943174329900849, 0.9702667180361263}, {2.9481450675468936`, 
                0.9705229416261285}, {2.9580865428389833`, 
                0.9710353888061332}, {2.9779694934231626`, 
                0.9720602831661425}, {2.998724489795918, 
                0.9731301283399958}}], 
               LineBox[{{3.001275510204082, 0.973248474647591}, {
                3.0201720432600485`, 0.9740277131241257}, {3.022608691928575, 
                0.9741281934815907}, {3.0274819892656275`, 
                0.9743291541965207}, {3.0372285839397324`, 
                0.9747310756263807}, {3.0567217732879426`, 
                0.9755349184861007}, {3.0957081519843626`, 
                0.9771426042055407}, {3.1802851297394477`, 
                0.9806303146284308}, {3.1987244897959184`, 
                0.981390700610141}}], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAe3+uVTacCUCF0oUVamjvP8bs126f
FQpAodz43HB87z+MMFEuXBgKQJp7UXPkfO8/F7hDrdUdCkCMuQKgy33vPy7H
KKvIKApAcDVl+Zl/7z9c5fKmrj4KQDgtKqw2g+8/uSGHnnpqCkDJHLQRcIrv
P35lAF43bQpAwrsMqOOK7z9EqXkd9G8KQLtaZT5Xi+8/0DBsnG11CkCtmBZr
PozvP+g/UZpggApAkhR5xAyO7z8WXhuWRpYKQFoMPnepke8/cpqvjRLCCkDq
+8fc4pjvP7f8mofCxApAgsfRV1SZ7z/8XoaBcscKQBmT29LFme8/hyNdddLM
CkBHKu/IqJrvP5ysCl2S1wpApVgWtW6c7z/FvmUsEu0KQF+1ZI36n+8/CiFR
JsLvCkD2gG4IbKDvP1CDPCBy8gpAjkx4g92g7z/aRxMU0vcKQLzji3nAoe8/
7tDA+5ECC0AZErNlhqPvPxjjG8sRGAtA1G4BPhKn7z9dRQfFwRoLQGs6C7mD
p+8/oqfyvnEdC0ACBhU09afvPyxsybLRIgtAMZ0oKtio7z9xzrSsgSULQMho
MqVJqe8/tjCgpjEoC0BfNDwgu6nvP0H1dpqRLQtAjstPFp6q7z+GV2KUQTAL
QCWXWZEPq+8/Uk0ed5YwC0A5DM2RHavvPy1P5Fs=
                "]], LineBox[CompressedData["
1:eJwVyn8sFGAcx/EjOut5oovkrK2JyeLqthvjqOfr55A02tJa2jodnfKrNORQ
1xpTxpFTHbqZUfkRYbdVxy4/OoeQNkV0azld4ZlNsmnq6Y/P3nttHzdJRrzU
msPhHGT7Xyd+JB33RbDb6wG3v4WS04Ueijh/BLZa6epvZrXJQW4ViGCi9ke7
sJUSU8jm9c6jCGoVGVdkzKnc9zJeKAJRbN7iDPNzmS5JH47gr2ir0bGNkrWR
J4lZkQhG+LclMcxFFUVxkycQSBbuzemY7/MFAcozCJRyzZSmnRKdd4kdLx3B
yrO3fckdlPh92DtWmYkgSNnepmbukDcrna4huJtTrZ5gbhgbcnXJReAVlpQj
7qSkJMNWsF+BIGlu67D9C0riuxRxAhWCjw5+9T1dlCyKCx5F9SJ4k90ot9FS
wou+6qOwx6A6diugQUeJRu+AxDwMo+a2ullmYUCbZdURg3X5jNWeXkpivb43
XeBjSP8iMhYzl24/7xbsgSHipvlsWh8lNv1RzhwxhnX9cbm/npL1QDdOoRRD
Qrhz37sBSu509c77XsJQthzibjdIiZP3Od1yKob+6oziYGaRa82NxEwMR8yG
k93MmRv4V1A+Bm5xvunhECWW7g3LZgUGrcFkJTVQkuujMnRVYVjO3Jlcz2zX
KGq+rMLgzhcbp5k9q9IvzqoxlMuqKqOHKZFkfZt/2YQhZUeEu9BIyWfBxFTe
awwuMS1hmyOUPP7JK9jWh2FyLeCTcJT9n57yLNNjKK0zpCUze6ZUjzsPYAiN
SLCuZbZ4TOdqhjD8WVlQTTK3fnU5cGgYQ09Ntjd3jJIls3aX0IhhaeDV4D7m
f/5pJ74=
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPELOfT7fjlUKoSUh6ItsraW76eyi2qWh5U8XXeeH3IpNSll
ayzV8rB5as1iejJdODVzFrvC9MCp43BOuSGc+tr8EXU9fPvjvfderhJpeJIJ
j8fzZf2/rHXqZtogB6PhdQXSD5TkV4nPjQ9z4CCrvS5nNrObUX4b52DopI/9
PLPAajHFfoaDw0+OHogcoETd5yOo/crBA2MZX8pcXSjt8FjgwHhibKiY2XnN
MrefcvBiNSW5i3nXymqLeJUDz2OFJd6DlAhn+UYZQsB975riqSixbAh5uM8G
QeohftMW5vfi26FKWwQ9laGXApgjdLhueCOCa0Rnlcl8Rr1eaHRFsFT600/D
fEW5rTQkAIHab2/RsyFKmmuJ+3Q8gvuXG72jP1GynLfMF4sRuGxyzsphDjj1
2KBLQNDQXtZyl1lhbS3XpCJo+pG77zVzb8HkwXfnEXRePCLcpaZEK8kXtRYh
0GVPi/8wm3so7hXIEDinO9fUj1ASYiq99rsZQb1l+UQn853PbpI8OYIdT9e6
aJgF1be8ctoR+M4tPlqnocTRMro9RYmAJCvacpj3GFaGQ0cQiCRRKuEoJXHP
AwROfxA8iC7nG8YoeRm9glU8DA5azyL+OCXYvIO7YYqhNKbLzJ25O/aAxbwF
huuxi2vimN2sgv622WEQxQuNA8yziWHfjnthcJL8XGrVUhJoY2f4uxNDhb5U
OshcpVDPtfpi4BI8vhuYg22jph38MRgTIg3uE5Q0dsVrpwMxaJNkM5XMJhku
Y1UHMUTMBiXKmWM26EeOBmF4m6zVDzJzZ5M+Nodg6Eix+GKhoyRrc2b/1UgM
NWmS8Tzm3h6fvt2nMAgWVqKqmLdm0zf60xiK00s0cuZcxxZlRSwGnmH7SRWz
qu98d7AIQ25Gp3qR2fOC/6tfYgxLhvAIy0lKCgvCGvsTMAhd5SJH5n81QGep

                "]], 
               LineBox[{{3.8012755102040816`, 0.9958762886597937}, {
                3.8070691712239952`, 0.9958762886597937}, {
                3.8123410159841984`, 0.9958762886597937}, {
                3.8228847055046042`, 0.9958762886597937}, {
                3.8334283950250096`, 0.9958762886597937}, {3.872782814308162, 
                0.9958762886597937}, {3.912137233591315, 
                0.9958762886597937}, {3.956068575979331, 
                0.9958762886597937}, {3.999999918367347, 
                0.9958762886597937}}]},
              Annotation[#, "Charting`Private`Tag$69502#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], LineBox[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAApPfnWmXDyT8SDKJzwOs4PzKsEQYc
CMo/0EicbA55UD/JLsVgzTDKPxTmihXmiVY/YLF4u35Zyj9Zg3m+vZpcP422
33Dhqso/3l4riDZeZD/owK3bpk3LP6pMBO3yP3A/ntVJsTGTzD8hh+E+omF8
Pwv/gVxHHs8/DP5NcYBSij+YaVdeLEbPP7fYJqnMEIs/JNQsYBFuzz9ds//g
GM+LPz6p12Pbvc8/s2ixULFLjT+5qZa1ty7QP7BpChhxIpA/7VPsvEvO0D9c
1G33oRuTP1Wol8tzDdI/tKk0tgMOmT+cXYJMZiHSPwwXIdIpbZk/4hJtzVg1
0j9fhA3uT8yZP299Qs89XdI/Cl/mJZyKmj+JUu3SB63SP2AUmJU0B5w/vfxC
2ptM0z8Mf/t0ZQCfPyVR7ujDi9Q/MirhmWN5oj8af0c6Z6HUPzl20Ov+rKI/
EK2giwq31D9Dwr89muCiP/oIUy5R4tQ/UFqe4dBHoz/QwLdz3jjVP3GKWyk+
FqQ/ejCB/vjl1T+t6tW4GLOlP29e2k+c+9U/tDbFCrTmpT9kjDOhPxHWP7uC
tFxPGqY/T+jlQ4Y81j/LGpMAhoGmPySgSokTk9Y/6UpQSPNPpz/ODxQULkDX
PyWrytfN7Kg/wz1tZdFV1z8s97kpaSCpP7hrxrZ0a9c/M0OpewRUqT+jx3hZ
u5bXP0Pbhx87u6k/eH/dnkjt1z9hC0VnqImqP22tNvDrAtg/aFc0uUO9qj9i
249BjxjYP2+jIwvf8Ko/TTdC5NVD2D9/OwKvFVirPyLvpiljmtg/nWu/9oIm
rD8XHQB7BrDYP6S3rkgeWqw/DEtZzKnF2D+rA56auY2sP/emC2/w8Ng/u5t8
PvD0rD/s1GTAkwbZP8Lna5CLKK0/4gK+ETcc2T/LM1viJlytP8xecLR9R9k/
2cs5hl3DrT/CjMkFIV3ZP+MXKdj49q0/t7oiV8Ry2T/pYxgqlCquP5Vq8riz
hNk/0tdYplpVrj8/vXF2
                "]], 
               LineBox[{{0.40127551020408164`, 0.06113539964537773}, {
                0.4029125240902338, 0.06307360177634155}, {
                0.40555387663264447`, 0.0662009271885654}, {
                0.40678641731639764`, 0.06766023856030043}, {
                0.40801895800015076`, 0.06911954993203537}, {
                0.41048403936765704`, 0.07203817267550533}, {
                0.4154142021026696, 0.07787541816244525}, {
                0.42527452757269474`, 0.0895499091363251}, {0.444995178512745,
                 0.1128988910840848}, {0.48443648039284554`, 
                0.15959685497960416`}, {0.5699233045152912, 
                0.2608120896731301}, {0.5987244897959183, 
                0.29491230052497996`}}], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAtsqGI6Y94z8sSRllswzTP/UmPQ+t
bec/5o9sAWYc2z8+4kLHinjnPxnEy+5QMds/hp1If2iD5z9K+CrcO0bbPxYU
VO8jmec/rGDpthFw2z82AWvPmsTnP24xZmy9w9s/eNuYj4gb6D/40l/XFGvc
P8CWnkdmJug/KQe/xP9/3D8IUqT/QzHoP1o7HrLqlNw/mcivb/9G6D+9o9yM
wL7cP7q1xk92cug/gnRZQmwS3T/8j/QPZMnoPwwWU63Dud0/REv6x0HU6D89
SrKars7dP4wGAIAf3+g/bn4RiJnj3T8dfQvw2vToP9Hmz2JvDd4/Pmoi0FEg
6T+Wt0wYG2HeP4YlKIgvK+k/x+urBQZ23j/O4C1ADTbpP/gfC/Pwit4/Xlc5
sMhL6T9ZiMnNxrTeP39EUJA/d+k/HllGg3II3z/I/1VIHYLpP1CNpXBdHd8/
ELtbAPuM6T+CwQReSDLfPxcCRqkmj+k/rBA9CXY23z/gtbW6
                "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T8JXiEBU1bfP+jsbCiU
rek/9jx1BAph3z8wqHLgcbjpP4ogjaxBbd8/wB5+UC3O6T+z57z8sIXfPwja
gwgL2ek/SMvUpOiR3z9QlYnA6OPpP9yu7Ewgnt8/4QuVMKT56T8Hdhydj7bf
PwL5qxAbJeo/WgR8PW7n3z8bzULzPy/qP42YsRPW8t8/NKHZ1WQ56j+/LOfp
Pf7fP2VJB5uuTeo/kiopy4YK4D/ImWIlQnbqP/dSlHdWIeA/jzoZOmnH6j/C
o2rQ9U7gPxx8hmO3aes/VkUXgjSq4D82/2C2U67sP3+IcOWxYOE/TE3AgkW4
7D/chDkYSWbhP2ObH083wuw/OYECS+Br4T+QN97nGtbsP/N5lLAOd+E/6W9b
GeL97D9ma7h7a43hP5zgVXxwTe0/TU4AEiW64T8BwkpCjeztPxkUkD6YE+I/
GBCqDn/27T92EFlxLxniPy5eCdtwAO4/0wwipMYe4j9a+sdzVBTuP4wFtAn1
KeI/tDJFpRs87j8A99fUUUDiP2ajPwiqi+4/5tkfawtt4j/MhDTOxirvP7Of
r5d+xuI/Og/LApE17z89gmVzj8ziP6iZYTdbQO8/x2QbT6DS4j+Dro6g71Xv
P9ophwbC3uI/OtjochiB7z8AtF51BffiP6hif6fii+8/ipYUURb94j8W7RXc
rJbvPxN5yiwnA+M/8QFDRUGs7z8mPjbkSA/jP6grnRdq1+8/TMgNU4wn4z8W
tjNMNOLvP9aqwy6dLeM/hEDKgP7s7z9gjXkKrjPjP31orA+N9e8/dJW4h304
4z+lwC0P
                "]], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAwcspeDkF8D858uPv1UHjPx41kqkT
DPA/l9keamNG4z+Lvyje3RbwP1DlUpyOTeM/wgR0+EIc8D8t62w1JFHjP/hJ
vxKoIfA/CfGGzrlU4z9m1FVHcizwP8P8ugDlW+M/QumCsAZC8D83FCNlO2rj
P3kuzsprR/A/FBo9/tBt4z+wcxnl0EzwP/EfV5dmceM/Hv6vGZtX8D+rK4vJ
kXjjP/kS3YIvbfA/H0PzLeiG4z+wPDdVWJjwPwZyw/aUo+M/H5Dr+anu8D/W
z2OI7tzjP75hf6my8/A/4snAukbg4z9eMxNZu/jwP+7DHe2e4+M/nNY6uMwC
8T8EuNdRT+rjPxgdinbvFvE/MqBLG7D34z8SqijzND/xP49wM65xEuQ/BcRl
7L+P8T9IEQPU9EfkP+v3397VMPI/ulKiH/uy5D9yZwm7+S3zP3xXwX8qW+U/
jb2xQQ==
                "]], 
               LineBox[{{1.2012755102040815`, 0.6681717831936864}, {
                1.3058823930203434`, 0.6984667918457554}, {
                1.3839420330101317`, 0.7210735018939054}, {
                1.3987244897959183`, 0.7253546222577618}}], 
               LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j/j6S6L3jznP4IILFOG
ifc/kYRqgG4J6D8O0KzBo5P3P+9/ID+rEOg/Jl+unt6n9z+sdoy8JB/oP1Z9
sVhU0Pc/JmRktxc86D+1ubfMPyH4Pxk/FK39deg/eh34g04m+D/IPG8MnHno
P0CBODtdK/g/dzrKazp96D/MSLmpejX4P9Y1gCp3hOg/5Ne6hrVJ+D+TLOyn
8JLoPxT2vUArcvg/DRrEouOv6D90MsS0FsP4PwH1c5jJ6eg/ZjQgoJHI+D/k
bU5jte3oP1g2fIsMzvg/x+YoLqHx6D87OjRiAtn4P43Y3cN4+eg/AkKkD+7u
+D8ZvEfvJwnpP49RhGrFGvk/MYMbRoYo6T+AU+BVQCD5PxP89RByLOk/clU8
Qbsl+T/2dNDbXTDpP1ZZ9BexMPk/vWaFcTU46T8cYWTFnEb5P0hK75zkR+k/
qnBEIHRy+T9hEcPzQmfpP5xyoAvvd/k/RIqdvi5r6T+NdPz2aX35PyYDeIka
b+k/cHi0zV+I+T/s9Cwf8nbpP2J6ELnajfk/z20H6t166T9UfGykVZP5P7Pm
4bTJfuk/2c1vIWCU+T8rCDFhiH/pP61o5dI=
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAW2XDEdOe+T86puTSI4XpPyiCgGbG
o/k/HgyNNumG6T8ahNxRQan5P49I+hvfiOk//oeUKDe0+T9zwdTmyozpP8SP
BNYiyvk/OLOJfKKU6T+2kWDBnc/5P6rv9mGYluk/qJO8rBjV+T8cLGRHjpjp
P4uXdIMO4Pk//qQ+Enqc6T9Sn+Qw+vX5P8SW86dRpOk/367Ei9Eh+j9Qel3T
ALTpP9DtBOwyJ/o/Bt5qle216T/ALEVMlCz6P7tBeFfat+k/oKrFDFc3+j8m
CZPbs7vpP2Kmxo3cTPo//JfI42bD6T/mnciP53f6P6m1M/TM0uk/7YzMk/3N
+j8B8QkVmfHpP/tq1Jspevs/sme2VjEv6j9UNl2RLn/7P4En1Aj9MOo/rAHm
hjOE+z9P5/G6yDLqP16Y93E9jvs/7WYtH2A26j/BxRpIUaL7PydmpOeOPeo/
hyBh9HjK+z+cZJJ47EvqPxPW7UzIGvw/hmFumqdo6j9soXZCzR/8P1UhjExz
auo/xGz/N9Ik/D8j4an+PmzqP3YDESPcLvw/wWDlYtZv6j/ZMDT570L8P/tf
XCsFd+o/n4t6pRdr/D9wXkq8YoXqPytBB/5mu/w/W1sm3h2i6j+wqqsn2MD8
P8PYA0YQpOo/NBRQUUnG/D8sVuGtAqbqPwwBo1STx/w/XrXlvXim6j/wSBRm

                "]], 
               LineBox[{{1.8012755102040816`, 0.833234102840455}, {
                1.8063815056019226`, 0.8339734718503637}, {
                1.8170104932192683`, 0.8355125927148858}, {
                1.8382684684539596`, 0.8385908344439296}, {
                1.8807844189233422`, 0.8447473179020174}, {
                1.9601756422651684`, 0.8562434916397605}, {
                1.9987244897959184`, 0.8618255223724927}}], 
               LineBox[{{2.001275510204082, 0.8621623266001462}, {
                2.122444219423309, 0.8766117467796112}, {2.1987244897959184`, 
                0.8857082015088832}}], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUA+DWNFZFrsP2s0u9kJ
SwJAlrkIgrK57D/A0NWsuE0CQMwmRO0ou+w/FW3wf2dQAkABlH9Yn7zsP7+l
JSbFVQJAbW72Loy/7D8TF5BygGACQEQj5Ntlxew/u/lkC/d1AkDyjL81GdHs
Pwu/Dj3koAJATmB26X/o7D9gWykQk6MCQITNsVT26ew/tfdD40GmAkC5Ou2/
bOvsP18weYmfqwJAJRVkllnu7D+zoePVWrYCQPzJUUMz9Ow/W4S4btHLAkCq
My2d5v/sP6tJYqC+9gJABgfkUE0X7T80LCE+P/kCQPreaIuqGO0/vg7g27/7
AkDutu3FBxrtP9DTXRfBAANA1Gb3OsIc7T/0XVmOwwoDQKLGCiU3Iu0/fUAY
LEQNA0CWno9flCPtPwYj18nEDwNAiXYUmvEk7T8Z6FQFxhQDQHEmHg+sJ+0/
PnJQfMgeA0A/hjH5IC3tP8dUDxpJIQNAM162M34u7T9QN863ySMDQCY2O27b
L+0/YvxL88ooA0AN5kTjlTLtP+veCpFLKwNAAL7JHfMz7T90wckuzC0DQPSV
TlhQNe0//qOIzEwwA0DobdOSrTbtP1JNHneWMANAWT18u9U27T8fpNLk
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAFBlI7881A0B1dkwjJjntP6wQQ+HP
PANAprBwrog77T/Qmj5Y0kYDQIbMvMDxPu0/WX399VJJA0B/008FzD/tP+Jf
vJPTSwNAd9riSaZA7T/0JDrP1FADQGfoCNNaQu0/Ga81RtdaA0BIBFXlw0Xt
P2LDLDTcbgNACjztCZZM7T/16xoQ5pYDQI2rHVM6Wu0/lJ3nx5yZA0DDSZ4G
J1vtPzNPtH9TnANA+OceuhNc7T9xsk3vwKEDQGIkICHtXe0/7XiAzpusA0A4
nSLvn2HtP+UF5oxRwgNA4o4niwVp7T/VH7EJve0DQDdyMcPQd+0/tVNHA5RE
BEDhOEUzZ5XtP4hLuIUcRwRAzLlTKESW7T9cQykIpUkEQLk6Yh0hl+0/AjML
DbZOBECQPH8H25jtP04SzxbYWARAQEC5206c7T/o0FYqHG0EQJ9HLYQ2o+0/
Gk5mUaSVBEBeVhXVBbHtP+1F19MsmARAStcjyuKx7T/APUhWtZoEQDZYMr+/
su0/Zi0qW8afBEAOWk+pebTtP7MM7mToqQRAvV2Jfe237T+GBF/ncKwEQKne
l3LKuO0/WvzPafmuBECVX6Znp7ntPwDssW4KtARAbWHDUWG77T9My3V4LL4E
QB1l/SXVvu0/H8Pm+rTABEAJ5gsbsr/tP/K6V309wwRA9GYaEI/A7T/Gssj/
xcUEQOHnKAVswe0/mao5gk7IBEDMaDf6SMLtP+zmtxAwygRAhTQcDe3C7T8U
uQRT
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEAgusObWcTtP7mBbg75
1ARAdB41nnzF7T+Med+QgdcEQDXSPTEBxu0/MmnBlZLcBEC2OU9XCsftP39I
hZ+05gRAuQhyoxzJ7T/SXmhcMOkEQGk1Fpqeye0/JHVLGazrBEAZYrqQIMrt
P8qhEZOj8ARAeLsCfiTL7T8U+52GkvoEQDduk1gsze0/qK22bXAOBUCz07QN
PNHtP9AS6DssNgVArZ73d1vZ7T8h3UrYo4UFQKE0fUya6e0/isI7r1WIBUAP
vHxSJ+rtP/KnLIYHiwVAfUN8WLTq7T/Ccg40a5AFQFhSe2TO6+0/ZAjSjzKb
BUAQcHl8Au7tP6gzWUfBsAVAf6t1rGry7T8uime23tsFQF0ibgw7++0/lm9Y
jZDeBUDLqW0SyPvtP/9USWRC4QVAOTFtGFX87T/QHysSpuYFQBVAbCRv/e0/
cbXubW3xBUDMXWo8o//tP7TgdSX8BgZAO5lmbAsE7j86N4SUGTIGQBkQX8zb
DO4/1mIZNp00BkCOHxpgXw3uP3OOrtcgNwZAAy/V8+IN7j+s5dgaKDwGQO1N
SxvqDu4/HpQtoTZGBkDBizdq+BDuP7q/wkK6SAZANpvy/XsR7j9X61fkPUsG
QKuqrZH/Ee4/kEKCJ0VQBkCVySO5BhPuPwLx1q1TWgZAaQcQCBUV7j+eHGxP
11wGQN4Wy5uYFe4/O0gB8VpfBkBUJoYvHBbuP9hzlpLeYQZAyTVBw58W7j+F
gFGqyWMGQCosDSgEF+4/X6UBzA==
                "]], 
               LineBox[{{2.8012755102040816`, 0.9404834335778608}, {
                2.8039259500890124`, 0.9407091950672075}, {
                2.8051535791448154`, 0.9408137631298824}, {2.806381208200619, 
                0.9409183311925573}, {2.8088364663122256`, 
                0.9411274673179071}, {2.8137469825354393`, 
                0.9415457395686068}, {2.814974611591243, 
                0.9416503076312817}, {2.816202240647046, 
                0.9417548756939566}, {2.818657498758653, 
                0.9419640118193063}, {2.8235680149818663`, 
                0.9423822840700059}, {2.833389047428293, 
                0.9432188285714052}, {2.853031112321146, 
                0.9448919175742035}, {2.9382035922548035`, 
                0.9521468136503243}, {2.998724489795918, 
                0.9573019156555299}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEB9XuuJ6KPuPxPetaIC
xAhARsFPczbf7j+ODH19t8YIQCHq/OgK4O4/CjtEWGzJCED9Eqpe3+DuPwKY
0g3WzghAs2QESoji7j/yUe94qdkIQCEIuSDa5e4/0MUoT1DvCED8TiLOfezu
P4ytm/udGglAstz0KMX57j8I3GLWUh0JQI4Fop6Z+u4/hAoqsQcgCUBpLk8U
bvvuP3tnuGZxJQlAIICp/xb97j9qIdXRRDAJQI0jXtZoAO8/SJUOqOtFCUBo
aseDDAfvPwV9gVQ5cQlAHviZ3lMU7z+08ez5v3MJQARt4CgaFe8/ZGZYn0Z2
CUDq4SZz4BXvP8RPL+pTewlAt8uzB20X7z+EIt1/boUJQE+fzTCGGu8/NJdI
JfWHCUA1FBR7TBvvP+QLtMp7iglAHIlaxRIc7z9E9YoViY8JQOhy51mfHe8/
9Gn2ug+SCUDO5y2kZR7vP6TeYWCWlAlAtFx07isf7z+5s4Td/JYJQIyJWVzo
H+8/zJG0Lw==
                "]], 
               LineBox[{{3.201275510204082, 0.9727862184055909}, {
                3.2049527235388684`, 0.9729115067645273}, {3.209886242298752, 
                0.9730795993968914}, {3.21975327981852, 0.9734157846616194}, {
                3.2209866595084913`, 0.9734578078197104}, {
                3.2222200391984623`, 0.9734998309778015}, {
                3.2246867985784045`, 0.9735838772939834}, {
                3.2296203173382887`, 0.9737519699263475}, {
                3.2394873548580567`, 0.9740881551910755}, {
                3.2592214298975932`, 0.9747605257205316}, {
                3.2605580005307244`, 0.9748060647540284}, {
                3.2618945711638556`, 0.9748516037875252}, {
                3.2645677124301176`, 0.9749426818545188}, {3.269913994962642, 
                0.975124837988506}, {3.2806065600276906`, 
                0.9754891502564804}, {3.3019916901577884`, 
                0.9762177747924292}, {3.3447619504179835`, 
                0.9776750238643268}, {3.398724489795918, 
                0.9795136112366585}}], 
               LineBox[{{3.4012755102040817`, 0.9796005284566982}, {
                3.507084223974069, 0.983205595365386}, {3.5920292423158866`, 
                0.9860998038267766}, {3.5987244897959183`, 
                0.9863279212877658}}], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArrLhiGnPDEDCw/XZtZDvPzZXp+vd
Yw1AbFMkU/Gk7z+7Dw+z12gNQDUFW+yepe8/xoDeQctyDUDJaMge+qbvP9ti
fV+yhg1A8C+jg7Cp7z8GJ7uagK4NQD6+WE0dr+8/SQNvfv2wDUAjF/QZdK/v
P4zfImJ6sw1ACHCP5sqv7z8RmIopdLgNQNIhxn94sO8/HAlauGfCDUBlhTOy
07HvPzLr+NVO1g1AjUwOF4q07z9drzYRHf4NQNvaw+D2ue8/tlr4DtAADkA/
cPEMVbrvPw4GugyDAw5AogUfObO67z/AXD0I6QgOQGowepFvu+8/IgpE/7QT
DkD5hTBC6LzvP+ZkUe1MKQ5AFzGdo9m/7z8+EBPr/ysOQHrGys83wO8/l7vU
6LIuDkDeW/j7lcDvP0gSWOQYNA5ApYZTVFLB7z+qv17b5D4OQDTcCQXLwu8/
Amsg2ZdBDkCYcTcxKcPvP1sW4tZKRA5A/AZlXYfD7z8MbWXSsEkOQMMxwLVD
xO8/bhpsyXxUDkBSh3ZmvMXvP8bFLccvVw5AthykkhrG7z8fce/E4lkOQBmy
0b54xu8/eByxwpVcDkB9R//q1sbvP9DHcsBIXw5A4dwsFzXH7z8oczS++2EO
QEVyWkOTx+8/hYBRqsljDkDID3w30sfvP9Pb7dk=
                "]], 
               LineBox[{{3.8012755102040816`, 0.993185689948893}, {
                3.8070691712239952`, 0.993185689948893}, {3.8123410159841984`,
                 0.993185689948893}, {3.8228847055046042`, 
                0.993185689948893}, {3.8334283950250096`, 
                0.993185689948893}, {3.872782814308162, 0.993185689948893}, {
                3.912137233591315, 0.993185689948893}, {3.956068575979331, 
                0.993185689948893}, {3.999999918367347, 0.993185689948893}}]},
              
              Annotation[#, 
               "Charting`Private`Tag$69502#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{0, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{{0., 3.999999918367347}, {0., 0.9958762886597937}},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], 
               Line[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAApPfnWmXDyT+GbfnZoZNLPzKsEQYc
CMo/eZIyLnY6Yj/JLsVgzTDKP3kCksLJ8Gg/YLF4u35Zyj95cvFWHadvP422
33Dhqso/JynYP+KJdj/owK3bpk3LP4mES7RE+4E/ntVJsTGTzD90ZArd62eP
Pwv/gVxHHs8/KhJEF50gnT+YaVdeLEbPP6k8Keww850/JNQsYBFuzz8iZw7B
xMWePz6p12Pbvc8/EF5sNXY1oD+5qZa1ty7QPw2zNt+d2qE/7VPsvEvO0D8I
Xcsy7SSlP1Wol8tzDdI//bD02Yu5qz8lUe7ow4vUP3SsI5RkcbQ/Gn9HOmeh
1D983h7Pf6q0PxCtoIsKt9Q/hhAaCpvjtD/6CFMuUeLUP5Z0EIDRVbU/0MC3
c9441T+7PP1rPjq2P3owgf745dU/AM3WQxgDuD/ODxQULkDXP4ntifPLlLs/
wz1tZdFV1z+RH4Uu5827P7hrxrZ0a9c/mVGAaQIHvD+jx3hZu5bXP6u1dt84
ebw/eH/dnkjt1z/OfWPLpV29P22tNvDrAtg/1q9eBsGWvT9i249BjxjYP97h
WUHcz70/TTdC5NVD2D/wRVC3EkK+PyLvpiljmtg/Eg49o38mvz8XHQB7BrDY
PxpAON6aX78/DEtZzKnF2D8icjMZtpi/P/emC2/w8Ng/GuuUR3YFwD/s1GTA
kwbZPx6EEuUDIsA/4gK+ETcc2T8kHZCCkT7AP8xecLR9R9k/K0+Lvax3wD/C
jMkFIV3ZPzHoCFs6lMA/t7oiV8Ry2T81gYb4x7DAP5Vq8rizhNk/pGaos3LI
wD/SBCyO
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T/zQ+yH3hbBP4xyh5xR
ydk/qkWQwx9YwT93zjk/mPTZP+tpT/hpwcE/Di615ckI2j/MdAeti/LBP6SN
MIz7HNo/q3+/Ya0jwj/RTCfZXkXaP2qVL8vwhcI/K8sUcyWW2j/pwA+ed0rD
P9/H76ayN9s/5hfQQ4XTxD9HwaUOzXrcP+HFUI+g5cc/F7QR3gEB3z/WIVIm
1wnOP1yM+1TkFt8/Cu5Y4xU/zj+iZOXLxizfP0C6X6BUdM4/LBW5uYtY3z+o
Um0a0t7OP0J2YJUVsN8/fIOIDs2zzz82nFemlC/gP49yX3vhrtA/YV6mXaje
4D801JVj11jSP4RKG5mZ6eA/UDoZwnZz0j+mNpDUivTgP2ignCAWjtI/7A56
S20K4T+ebKPdVMPSP3a/TTkyNuE/BgWxV9It0z+MIPUUvI3hP9o1zEvNAtQ/
tuJDzM884j99lwI0w6zVP9ZIgfGNR+I/EEZbR+bG1T/2rr4WTFLiP6L0s1oJ
4dU/N3s5Ychn4j/KUWWBTxXWP7gTL/bAkuI/FgzIztt91j/YeWwbf53iP6i6
IOL+l9Y/+N+pQD2o4j87aXn1IbLWPzisJIu5veI/YMYqHGjm1j+5RBogsuji
P6yAjWn0Ttc/2qpXRXDz4j9BL+Z8F2nXP/oQlWou/uI/1N0+kDqD1z863Q+1
qhPjP/g68LaAt9c/WkNN2mge4z+L6UjKo9HXP7Cb30LAKOM/pm5g6Mzq1z/n
ASPe
                "]], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAtsqGI6Y94z+lgPLQzxTYP9rbQm9h
SeM/Ay10728n2D/6QYCUH1TjP9xqTCV+ONg/Ow773ptp4z+Q5vyQmlrYP7ym
8HOUlOM/9d1daNOe2D/cDC6ZUp/jP84bNp7hr9g//HJrvhCq4z+oWQ7U78DY
Pz0/5giNv+M/W9W+Pwzj2D++19udherjP8HMHxdFJ9k/vwjHx3ZA5D+Lu+HF
tq/ZP8JqnRtZ7OQ/IZllI5rA2j/1Jj0PrW3nP97o/vfKut4/PuJCx4p45z+5
oExOC8zeP4adSH9og+c/kliapEvd3j8WFFTvI5nnP0TINVHM/94/NgFrz5rE
5z+pp2yqzUTfP3jbmI+IG+g/dmbaXNDO3z/8j/QPZMnoPwjy2uBqceA/REv6
x0HU6D/1zQEMC3rgP4wGAIAf3+g/4qkoN6uC4D8dfQvw2vToP7xhdo3rk+A/
Pmoi0FEg6T9v0RE6bLbgP4YlKIgvK+k/W604ZQy/4D/O4C1ADTbpP0iJX5Cs
x+A/Xlc5sMhL6T8hQa3m7NjgP39EUJA/d+k/1LBIk2374D/I/1VIHYLpP8KM
b74NBOE/ELtbAPuM6T+uaJbprQzhPxcCRqkmj+k/K1fUAGcO4T+9CPOR
                "]], 
               
               Line[{{0.8012755102040817, 0.5347175468125395}, {
                0.8024388112602567, 0.535353164915398}, {0.8037652381656297, 
                0.5360779136368904}, {0.8064180919763757, 
                0.5375274110798753}, {0.8170295072193599, 
                0.5433254008518151}, {0.8182677985372807, 
                0.5440019930152152}, {0.8195060898552016, 
                0.5446785851786152}, {0.8219826724910432, 
                0.5460317695054153}, {0.8269358377627265, 
                0.5487381381590155}, {0.8368421683060933, 
                0.5541508754662159}, {0.8566548293928267, 
                0.5649763500806166}, {0.8962801515662935, 
                0.586627299309418}, {0.9739717509693491, 
                0.6290773484677886}, {0.9987244897959183, 
                0.6426020408163265}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D8HziJdUprkP+v3397V
MPI/giX8cQNw5j+2Z4/CSjbyP8SbIVKgdOY/gNc+pr878j8FEkcyPXnmPxa3
nW2pRvI/if6R8naC5j9Cdlv8fFzyP5LXJ3PqlOY/mvTWGSSI8j+iiVN00bnm
P2Vkhv2YjfI/5P94VG6+5j8w1DXhDZPyPyZ2njQLw+Y/xrOUqPed8j+qYun0
RMzmP/FyUjfLs/I/sTt/dbje5j9I8c1Uct/yP8HtqnafA+c/E2F9OOfk8j8D
ZNBWPAjnP97QLBxc6vI/Rdr1NtkM5z90sIvjRfXyP8nGQPcSFuc/n29JchkL
8z/Qn9Z3hijnP2rf+FWOEPM/Ehb8VyMt5z80T6g5AxbzP1SMITjAMec/yi4H
Ae0g8z/YeGz4+TrnP5WetuRhJvM/Gu+R2JY/5z9gDmbI1ivzP1xlt7gzROc/
cmcJu/kt8z+F3fwWAkbnP7I4uOg=
                "]], 
               Line[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA9P5cq2w48z/AnZzhcE3nP8FddHM1
PPM/MXCKLaBP5z+MzSNXqkHzP9skJ6HGUuc/Iq2CHpRM8z8vjmCIE1nnP01s
QK1nYvM/1mDTVq1l5z+k6rvKDo7zPyUGufPgfuc/bpdPI2qT8z8j8y2o+IHn
PzdE43vFmPM/IeCiXBCF5z/KnQotfKPzPxy6jMU/i+c/8VBZj+m48z8TbmCX
npfnPz639lPE4/M/ANYHO1yw5z/ZgzHdeTn0P9ulVoLX4ec/Dh2n7+Tk9D+Q
RfQQzkToP0BWg93j6fQ/tznFarBH6D9yj1/L4u70P94tlsSSSug/1gEYp+D4
9D8tFjh4V1DoP57miF7cDPU/y+Z73+Bb6D8usGrN0zT1PwaIA67zcug/TUMu
q8KE9T99yhJLGaHoP358CpnBifU/o77jpPuj6D+wteaGwI71P8uytP7dpug/
FCifYr6Y9T8am1ayoqzoP9wMEBq6rPU/t2uaGSy46D9s1vGIsdT1P/MMIug+
z+g/jGm1ZqAk9j9qTzGFZP3oP+pArYgLKvY/Od7SVoUA6T9HGKWqdi/2Pwht
dCimA+k/AseU7kw69j+mirfL5wnpP3kkdHb5T/Y/48U9EmsW6T+lmjzuLGH2
P7Ixj0dZIOk/l57+Sw==
                "]], 
               
               Line[{{1.4012755102040815`, 0.7858431516936673}, {
                1.4064308709161404`, 0.7869592607138037}, {1.407753743734141, 
                0.7872456558599688}, {1.410399489370142, 
                0.7878184461522989}, {1.415690980642144, 
                0.7889640267369591}, {1.426273963186148, 
                0.7912551879062796}, {1.4686058933621644`, 
                0.8004198325835614}, {1.547629076117258, 
                0.8175279443140456}, {1.5987244897959185`, 
                0.8285898379970547}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T89KnPJp4jqP/tq1Jsp
evs/cmRuzt9z6z9UNl2RLn/7P7ANlalbdus/rAHmhjOE+z/vtruE13jrP16Y
93E9jvs/bAkJO8996z/BxRpIUaL7P2Wuo6e+h+s/hyBh9HjK+z9Y+NiAnZvr
PxPW7UzIGvw/P4xDM1vD6z9soXZCzR/8P301ag7Xxes/xGz/N9Ik/D+73pDp
UsjrP3YDESPcLvw/ODHen0rN6z/ZMDT570L8PzLWeAw61+s/n4t6pRdr/D8l
IK7lGOvrP/hWA5sccPw/Y8nUwJTt6z9QIoyQIXX8P6Fy+5sQ8Os/Armdeyt/
/D8exUhSCPXrP2XmwFE/k/w/GGrjvvf+6z++sUlHRJj8P1YTCppzAew/Fn3S
PEmd/D+UvDB17wPsP8gT5CdTp/w/Eg9+K+cI7D8rQQf+Zrv8Pwu0GJjWEuw/
sKqrJ9jA/D8jdIT+hxXsPzQUUFFJxvw/OjTwZDkY7D8MAaNUk8f8P3qEHrPc
GOw/XNLFHg==
                "]], 
               Line[CompressedData["
1:eJwV0FtIk2EAh/FNyy6iiVkNysyJrDTPSpKUf6N5NpmRG0hu6vIE2WENUinK
skSZGjpLTI0ykZgiyrQyq2WmRDpFpjaTiUeM3mGT0nLfvje7eHjuf4LMy2ez
HDgcjnCr/6+sWxc5jTMonvVq/OVGoBefNDRMMliOeNsa404Q1Tu3sWuGQfyA
0GA6RJBU4ZPwc5mB8+jf/awnwfi6QZVBGCjPKU498CKQpl9rGrcymDAN53gK
CdJD+qw6hsHjxSe6aG8CpelMXeFuOw5vRiVVBRC8vqoJVufZIRGbdZ2xBDHP
BDmdfBY6hndnvYggtI4nHHRj0XZPaMu/QeBRaVucFrBo5kWolm4SbBZOZG7z
ZVHjkZ9tvE3Qnlwmk0ayUIq+xHfdJ3DlWlPsuSyC1KWul6oJZuV6UVwvi/YD
nJalFwTDKe2OsvcsWp7z3dO0BK8S6vuVAywa/QIeGdsIqsNUkQ0GFhWQlX3s
2PJwPnJidZ7FRUVf/tNuAu27qpDanRQ+2oJjaR8Irh+Ue86dp2gNtw4ZvxJk
igMlMxkUn2dVc6LpLb+73PKpbIofJX82dd8IhN+brSNXKPxHqV+tmcCoW9H3
llB0K3ialEWCwESlXNNG0a8+mj65SuB263RNVSfFYlBHYbSVYEfXnqHyHgqn
qeCanjUCM/+lf7GeIk4QPvjwN4F6wWbPN1KMdcf6Sm0EBftGgvJMFNbU4agh
hkAR15R1wUzhyhHLw1iC8I7IkdQVCkm8tJrPtUA478KVWCgKVqe1pQ4WuOxd
CE1eo6jXyD5tOFrAxOhyEzco3hyfN+dstwChk6WDmxRF3u5juU4W/ANpQEip

                "]], 
               
               Line[{{2.001275510204082, 0.9073216915632234}, {
                2.0039562426140143`, 0.9075427828960013}, {2.008820753763886, 
                0.907943979691867}, {2.0185497760636295`, 
                0.9087463732835984}, {2.0380078206631165`, 
                0.9103511604670612}, {2.0393271393937447`, 0.910459970259278},
                 {2.0406464581243724`, 0.9105687800514948}, {
                2.0432850955856283`, 0.9107863996359282}, {
                2.0485623705081406`, 0.9112216388047952}, {
                2.0591169203531647`, 0.9120921171425291}, {2.080226020043213, 
                0.913833073817997}, {2.122444219423309, 0.9173149871689328}, {
                2.1987244897959184`, 0.9236061434883233}}], 
               
               Line[{{2.201275510204082, 0.9238033873343153}, {
                2.2866398821120604`, 0.9299637028328293}, {
                2.3704807786936803`, 0.9360140768129461}, {2.398724489795918, 
                0.9380522827687777}}], 
               
               Line[{{2.4012755102040817`, 0.9382232274353042}, {
                2.5334854370252864`, 0.9464011610531106}, {
                2.5987244897959183`, 0.9504365663791291}}], 
               
               Line[{{2.601275510204082, 0.9505943614559227}, {
                2.6902539155813803`, 0.9560981803452401}, {2.774462852749733, 
                0.9613069805824578}, {2.798724489795918, 
                0.9628077003997476}}], 
               
               Line[{{2.8012755102040816`, 0.9629523458868083}, {
                2.9382035922548035`, 0.970010494446124}, {2.939446276666315, 
                0.9700745503436246}, {2.940688961077826, 0.970138606241125}, {
                2.943174329900849, 0.9702667180361263}, {2.9481450675468936`, 
                0.9705229416261285}, {2.9580865428389833`, 
                0.9710353888061332}, {2.9779694934231626`, 
                0.9720602831661425}, {2.998724489795918, 
                0.9731301283399958}}], 
               
               Line[{{3.001275510204082, 0.973248474647591}, {
                3.0201720432600485`, 0.9740277131241257}, {3.022608691928575, 
                0.9741281934815907}, {3.0274819892656275`, 
                0.9743291541965207}, {3.0372285839397324`, 
                0.9747310756263807}, {3.0567217732879426`, 
                0.9755349184861007}, {3.0957081519843626`, 
                0.9771426042055407}, {3.1802851297394477`, 
                0.9806303146284308}, {3.1987244897959184`, 
                0.981390700610141}}], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAe3+uVTacCUCF0oUVamjvP8bs126f
FQpAodz43HB87z+MMFEuXBgKQJp7UXPkfO8/F7hDrdUdCkCMuQKgy33vPy7H
KKvIKApAcDVl+Zl/7z9c5fKmrj4KQDgtKqw2g+8/uSGHnnpqCkDJHLQRcIrv
P35lAF43bQpAwrsMqOOK7z9EqXkd9G8KQLtaZT5Xi+8/0DBsnG11CkCtmBZr
PozvP+g/UZpggApAkhR5xAyO7z8WXhuWRpYKQFoMPnepke8/cpqvjRLCCkDq
+8fc4pjvP7f8mofCxApAgsfRV1SZ7z/8XoaBcscKQBmT29LFme8/hyNdddLM
CkBHKu/IqJrvP5ysCl2S1wpApVgWtW6c7z/FvmUsEu0KQF+1ZI36n+8/CiFR
JsLvCkD2gG4IbKDvP1CDPCBy8gpAjkx4g92g7z/aRxMU0vcKQLzji3nAoe8/
7tDA+5ECC0AZErNlhqPvPxjjG8sRGAtA1G4BPhKn7z9dRQfFwRoLQGs6C7mD
p+8/oqfyvnEdC0ACBhU09afvPyxsybLRIgtAMZ0oKtio7z9xzrSsgSULQMho
MqVJqe8/tjCgpjEoC0BfNDwgu6nvP0H1dpqRLQtAjstPFp6q7z+GV2KUQTAL
QCWXWZEPq+8/Uk0ed5YwC0A5DM2RHavvPy1P5Fs=
                "]], 
               Line[CompressedData["
1:eJwVyn8sFGAcx/EjOut5oovkrK2JyeLqthvjqOfr55A02tJa2jodnfKrNORQ
1xpTxpFTHbqZUfkRYbdVxy4/OoeQNkV0azld4ZlNsmnq6Y/P3nttHzdJRrzU
msPhHGT7Xyd+JB33RbDb6wG3v4WS04Ueijh/BLZa6epvZrXJQW4ViGCi9ke7
sJUSU8jm9c6jCGoVGVdkzKnc9zJeKAJRbN7iDPNzmS5JH47gr2ir0bGNkrWR
J4lZkQhG+LclMcxFFUVxkycQSBbuzemY7/MFAcozCJRyzZSmnRKdd4kdLx3B
yrO3fckdlPh92DtWmYkgSNnepmbukDcrna4huJtTrZ5gbhgbcnXJReAVlpQj
7qSkJMNWsF+BIGlu67D9C0riuxRxAhWCjw5+9T1dlCyKCx5F9SJ4k90ot9FS
wou+6qOwx6A6diugQUeJRu+AxDwMo+a2ullmYUCbZdURg3X5jNWeXkpivb43
XeBjSP8iMhYzl24/7xbsgSHipvlsWh8lNv1RzhwxhnX9cbm/npL1QDdOoRRD
Qrhz37sBSu509c77XsJQthzibjdIiZP3Od1yKob+6oziYGaRa82NxEwMR8yG
k93MmRv4V1A+Bm5xvunhECWW7g3LZgUGrcFkJTVQkuujMnRVYVjO3Jlcz2zX
KGq+rMLgzhcbp5k9q9IvzqoxlMuqKqOHKZFkfZt/2YQhZUeEu9BIyWfBxFTe
awwuMS1hmyOUPP7JK9jWh2FyLeCTcJT9n57yLNNjKK0zpCUze6ZUjzsPYAiN
SLCuZbZ4TOdqhjD8WVlQTTK3fnU5cGgYQ09Ntjd3jJIls3aX0IhhaeDV4D7m
f/5pJ74=
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPELOfT7fjlUKoSUh6ItsraW76eyi2qWh5U8XXeeH3IpNSll
ayzV8rB5as1iejJdODVzFrvC9MCp43BOuSGc+tr8EXU9fPvjvfderhJpeJIJ
j8fzZf2/rHXqZtogB6PhdQXSD5TkV4nPjQ9z4CCrvS5nNrObUX4b52DopI/9
PLPAajHFfoaDw0+OHogcoETd5yOo/crBA2MZX8pcXSjt8FjgwHhibKiY2XnN
MrefcvBiNSW5i3nXymqLeJUDz2OFJd6DlAhn+UYZQsB975riqSixbAh5uM8G
QeohftMW5vfi26FKWwQ9laGXApgjdLhueCOCa0Rnlcl8Rr1eaHRFsFT600/D
fEW5rTQkAIHab2/RsyFKmmuJ+3Q8gvuXG72jP1GynLfMF4sRuGxyzsphDjj1
2KBLQNDQXtZyl1lhbS3XpCJo+pG77zVzb8HkwXfnEXRePCLcpaZEK8kXtRYh
0GVPi/8wm3so7hXIEDinO9fUj1ASYiq99rsZQb1l+UQn853PbpI8OYIdT9e6
aJgF1be8ctoR+M4tPlqnocTRMro9RYmAJCvacpj3GFaGQ0cQiCRRKuEoJXHP
AwROfxA8iC7nG8YoeRm9glU8DA5azyL+OCXYvIO7YYqhNKbLzJ25O/aAxbwF
huuxi2vimN2sgv622WEQxQuNA8yziWHfjnthcJL8XGrVUhJoY2f4uxNDhb5U
OshcpVDPtfpi4BI8vhuYg22jph38MRgTIg3uE5Q0dsVrpwMxaJNkM5XMJhku
Y1UHMUTMBiXKmWM26EeOBmF4m6zVDzJzZ5M+Nodg6Eix+GKhoyRrc2b/1UgM
NWmS8Tzm3h6fvt2nMAgWVqKqmLdm0zf60xiK00s0cuZcxxZlRSwGnmH7SRWz
qu98d7AIQ25Gp3qR2fOC/6tfYgxLhvAIy0lKCgvCGvsTMAhd5SJH5n81QGep

                "]], 
               
               Line[{{3.8012755102040816`, 0.9958762886597937}, {
                3.8070691712239952`, 0.9958762886597937}, {
                3.8123410159841984`, 0.9958762886597937}, {
                3.8228847055046042`, 0.9958762886597937}, {
                3.8334283950250096`, 0.9958762886597937}, {3.872782814308162, 
                0.9958762886597937}, {3.912137233591315, 
                0.9958762886597937}, {3.956068575979331, 
                0.9958762886597937}, {3.999999918367347, 
                0.9958762886597937}}]}, "Charting`Private`Tag$69502#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], 
               Line[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAApPfnWmXDyT8SDKJzwOs4PzKsEQYc
CMo/0EicbA55UD/JLsVgzTDKPxTmihXmiVY/YLF4u35Zyj9Zg3m+vZpcP422
33Dhqso/3l4riDZeZD/owK3bpk3LP6pMBO3yP3A/ntVJsTGTzD8hh+E+omF8
Pwv/gVxHHs8/DP5NcYBSij+YaVdeLEbPP7fYJqnMEIs/JNQsYBFuzz9ds//g
GM+LPz6p12Pbvc8/s2ixULFLjT+5qZa1ty7QP7BpChhxIpA/7VPsvEvO0D9c
1G33oRuTP1Wol8tzDdI/tKk0tgMOmT+cXYJMZiHSPwwXIdIpbZk/4hJtzVg1
0j9fhA3uT8yZP299Qs89XdI/Cl/mJZyKmj+JUu3SB63SP2AUmJU0B5w/vfxC
2ptM0z8Mf/t0ZQCfPyVR7ujDi9Q/MirhmWN5oj8af0c6Z6HUPzl20Ov+rKI/
EK2giwq31D9Dwr89muCiP/oIUy5R4tQ/UFqe4dBHoz/QwLdz3jjVP3GKWyk+
FqQ/ejCB/vjl1T+t6tW4GLOlP29e2k+c+9U/tDbFCrTmpT9kjDOhPxHWP7uC
tFxPGqY/T+jlQ4Y81j/LGpMAhoGmPySgSokTk9Y/6UpQSPNPpz/ODxQULkDX
PyWrytfN7Kg/wz1tZdFV1z8s97kpaSCpP7hrxrZ0a9c/M0OpewRUqT+jx3hZ
u5bXP0Pbhx87u6k/eH/dnkjt1z9hC0VnqImqP22tNvDrAtg/aFc0uUO9qj9i
249BjxjYP2+jIwvf8Ko/TTdC5NVD2D9/OwKvFVirPyLvpiljmtg/nWu/9oIm
rD8XHQB7BrDYP6S3rkgeWqw/DEtZzKnF2D+rA56auY2sP/emC2/w8Ng/u5t8
PvD0rD/s1GTAkwbZP8Lna5CLKK0/4gK+ETcc2T/LM1viJlytP8xecLR9R9k/
2cs5hl3DrT/CjMkFIV3ZP+MXKdj49q0/t7oiV8Ry2T/pYxgqlCquP5Vq8riz
hNk/0tdYplpVrj8/vXF2
                "]], 
               
               Line[{{0.40127551020408164`, 0.06113539964537773}, {
                0.4029125240902338, 0.06307360177634155}, {
                0.40555387663264447`, 0.0662009271885654}, {
                0.40678641731639764`, 0.06766023856030043}, {
                0.40801895800015076`, 0.06911954993203537}, {
                0.41048403936765704`, 0.07203817267550533}, {
                0.4154142021026696, 0.07787541816244525}, {
                0.42527452757269474`, 0.0895499091363251}, {0.444995178512745,
                 0.1128988910840848}, {0.48443648039284554`, 
                0.15959685497960416`}, {0.5699233045152912, 
                0.2608120896731301}, {0.5987244897959183, 
                0.29491230052497996`}}], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAtsqGI6Y94z8sSRllswzTP/UmPQ+t
bec/5o9sAWYc2z8+4kLHinjnPxnEy+5QMds/hp1If2iD5z9K+CrcO0bbPxYU
VO8jmec/rGDpthFw2z82AWvPmsTnP24xZmy9w9s/eNuYj4gb6D/40l/XFGvc
P8CWnkdmJug/KQe/xP9/3D8IUqT/QzHoP1o7HrLqlNw/mcivb/9G6D+9o9yM
wL7cP7q1xk92cug/gnRZQmwS3T/8j/QPZMnoPwwWU63Dud0/REv6x0HU6D89
SrKars7dP4wGAIAf3+g/bn4RiJnj3T8dfQvw2vToP9Hmz2JvDd4/Pmoi0FEg
6T+Wt0wYG2HeP4YlKIgvK+k/x+urBQZ23j/O4C1ADTbpP/gfC/Pwit4/Xlc5
sMhL6T9ZiMnNxrTeP39EUJA/d+k/HllGg3II3z/I/1VIHYLpP1CNpXBdHd8/
ELtbAPuM6T+CwQReSDLfPxcCRqkmj+k/rBA9CXY23z/gtbW6
                "]], 
               Line[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T8JXiEBU1bfP+jsbCiU
rek/9jx1BAph3z8wqHLgcbjpP4ogjaxBbd8/wB5+UC3O6T+z57z8sIXfPwja
gwgL2ek/SMvUpOiR3z9QlYnA6OPpP9yu7Ewgnt8/4QuVMKT56T8Hdhydj7bf
PwL5qxAbJeo/WgR8PW7n3z8bzULzPy/qP42YsRPW8t8/NKHZ1WQ56j+/LOfp
Pf7fP2VJB5uuTeo/kiopy4YK4D/ImWIlQnbqP/dSlHdWIeA/jzoZOmnH6j/C
o2rQ9U7gPxx8hmO3aes/VkUXgjSq4D82/2C2U67sP3+IcOWxYOE/TE3AgkW4
7D/chDkYSWbhP2ObH083wuw/OYECS+Br4T+QN97nGtbsP/N5lLAOd+E/6W9b
GeL97D9ma7h7a43hP5zgVXxwTe0/TU4AEiW64T8BwkpCjeztPxkUkD6YE+I/
GBCqDn/27T92EFlxLxniPy5eCdtwAO4/0wwipMYe4j9a+sdzVBTuP4wFtAn1
KeI/tDJFpRs87j8A99fUUUDiP2ajPwiqi+4/5tkfawtt4j/MhDTOxirvP7Of
r5d+xuI/Og/LApE17z89gmVzj8ziP6iZYTdbQO8/x2QbT6DS4j+Dro6g71Xv
P9ophwbC3uI/OtjochiB7z8AtF51BffiP6hif6fii+8/ipYUURb94j8W7RXc
rJbvPxN5yiwnA+M/8QFDRUGs7z8mPjbkSA/jP6grnRdq1+8/TMgNU4wn4z8W
tjNMNOLvP9aqwy6dLeM/hEDKgP7s7z9gjXkKrjPjP31orA+N9e8/dJW4h304
4z+lwC0P
                "]], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAwcspeDkF8D858uPv1UHjPx41kqkT
DPA/l9keamNG4z+Lvyje3RbwP1DlUpyOTeM/wgR0+EIc8D8t62w1JFHjP/hJ
vxKoIfA/CfGGzrlU4z9m1FVHcizwP8P8ugDlW+M/QumCsAZC8D83FCNlO2rj
P3kuzsprR/A/FBo9/tBt4z+wcxnl0EzwP/EfV5dmceM/Hv6vGZtX8D+rK4vJ
kXjjP/kS3YIvbfA/H0PzLeiG4z+wPDdVWJjwPwZyw/aUo+M/H5Dr+anu8D/W
z2OI7tzjP75hf6my8/A/4snAukbg4z9eMxNZu/jwP+7DHe2e4+M/nNY6uMwC
8T8EuNdRT+rjPxgdinbvFvE/MqBLG7D34z8SqijzND/xP49wM65xEuQ/BcRl
7L+P8T9IEQPU9EfkP+v3397VMPI/ulKiH/uy5D9yZwm7+S3zP3xXwX8qW+U/
jb2xQQ==
                "]], 
               
               Line[{{1.2012755102040815`, 0.6681717831936864}, {
                1.3058823930203434`, 0.6984667918457554}, {
                1.3839420330101317`, 0.7210735018939054}, {
                1.3987244897959183`, 0.7253546222577618}}], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j/j6S6L3jznP4IILFOG
ifc/kYRqgG4J6D8O0KzBo5P3P+9/ID+rEOg/Jl+unt6n9z+sdoy8JB/oP1Z9
sVhU0Pc/JmRktxc86D+1ubfMPyH4Pxk/FK39deg/eh34g04m+D/IPG8MnHno
P0CBODtdK/g/dzrKazp96D/MSLmpejX4P9Y1gCp3hOg/5Ne6hrVJ+D+TLOyn
8JLoPxT2vUArcvg/DRrEouOv6D90MsS0FsP4PwH1c5jJ6eg/ZjQgoJHI+D/k
bU5jte3oP1g2fIsMzvg/x+YoLqHx6D87OjRiAtn4P43Y3cN4+eg/AkKkD+7u
+D8ZvEfvJwnpP49RhGrFGvk/MYMbRoYo6T+AU+BVQCD5PxP89RByLOk/clU8
Qbsl+T/2dNDbXTDpP1ZZ9BexMPk/vWaFcTU46T8cYWTFnEb5P0hK75zkR+k/
qnBEIHRy+T9hEcPzQmfpP5xyoAvvd/k/RIqdvi5r6T+NdPz2aX35PyYDeIka
b+k/cHi0zV+I+T/s9Cwf8nbpP2J6ELnajfk/z20H6t166T9UfGykVZP5P7Pm
4bTJfuk/2c1vIWCU+T8rCDFhiH/pP61o5dI=
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAW2XDEdOe+T86puTSI4XpPyiCgGbG
o/k/HgyNNumG6T8ahNxRQan5P49I+hvfiOk//oeUKDe0+T9zwdTmyozpP8SP
BNYiyvk/OLOJfKKU6T+2kWDBnc/5P6rv9mGYluk/qJO8rBjV+T8cLGRHjpjp
P4uXdIMO4Pk//qQ+Enqc6T9Sn+Qw+vX5P8SW86dRpOk/367Ei9Eh+j9Qel3T
ALTpP9DtBOwyJ/o/Bt5qle216T/ALEVMlCz6P7tBeFfat+k/oKrFDFc3+j8m
CZPbs7vpP2Kmxo3cTPo//JfI42bD6T/mnciP53f6P6m1M/TM0uk/7YzMk/3N
+j8B8QkVmfHpP/tq1Jspevs/sme2VjEv6j9UNl2RLn/7P4En1Aj9MOo/rAHm
hjOE+z9P5/G6yDLqP16Y93E9jvs/7WYtH2A26j/BxRpIUaL7PydmpOeOPeo/
hyBh9HjK+z+cZJJ47EvqPxPW7UzIGvw/hmFumqdo6j9soXZCzR/8P1UhjExz
auo/xGz/N9Ik/D8j4an+PmzqP3YDESPcLvw/wWDlYtZv6j/ZMDT570L8P/tf
XCsFd+o/n4t6pRdr/D9wXkq8YoXqPytBB/5mu/w/W1sm3h2i6j+wqqsn2MD8
P8PYA0YQpOo/NBRQUUnG/D8sVuGtAqbqPwwBo1STx/w/XrXlvXim6j/wSBRm

                "]], 
               
               Line[{{1.8012755102040816`, 0.833234102840455}, {
                1.8063815056019226`, 0.8339734718503637}, {
                1.8170104932192683`, 0.8355125927148858}, {
                1.8382684684539596`, 0.8385908344439296}, {
                1.8807844189233422`, 0.8447473179020174}, {
                1.9601756422651684`, 0.8562434916397605}, {
                1.9987244897959184`, 0.8618255223724927}}], 
               Line[{{2.001275510204082, 0.8621623266001462}, {
                2.122444219423309, 0.8766117467796112}, {2.1987244897959184`, 
                0.8857082015088832}}], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUA+DWNFZFrsP2s0u9kJ
SwJAlrkIgrK57D/A0NWsuE0CQMwmRO0ou+w/FW3wf2dQAkABlH9Yn7zsP7+l
JSbFVQJAbW72Loy/7D8TF5BygGACQEQj5Ntlxew/u/lkC/d1AkDyjL81GdHs
Pwu/Dj3koAJATmB26X/o7D9gWykQk6MCQITNsVT26ew/tfdD40GmAkC5Ou2/
bOvsP18weYmfqwJAJRVkllnu7D+zoePVWrYCQPzJUUMz9Ow/W4S4btHLAkCq
My2d5v/sP6tJYqC+9gJABgfkUE0X7T80LCE+P/kCQPreaIuqGO0/vg7g27/7
AkDutu3FBxrtP9DTXRfBAANA1Gb3OsIc7T/0XVmOwwoDQKLGCiU3Iu0/fUAY
LEQNA0CWno9flCPtPwYj18nEDwNAiXYUmvEk7T8Z6FQFxhQDQHEmHg+sJ+0/
PnJQfMgeA0A/hjH5IC3tP8dUDxpJIQNAM162M34u7T9QN863ySMDQCY2O27b
L+0/YvxL88ooA0AN5kTjlTLtP+veCpFLKwNAAL7JHfMz7T90wckuzC0DQPSV
TlhQNe0//qOIzEwwA0DobdOSrTbtP1JNHneWMANAWT18u9U27T8fpNLk
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAFBlI7881A0B1dkwjJjntP6wQQ+HP
PANAprBwrog77T/Qmj5Y0kYDQIbMvMDxPu0/WX399VJJA0B/008FzD/tP+Jf
vJPTSwNAd9riSaZA7T/0JDrP1FADQGfoCNNaQu0/Ga81RtdaA0BIBFXlw0Xt
P2LDLDTcbgNACjztCZZM7T/16xoQ5pYDQI2rHVM6Wu0/lJ3nx5yZA0DDSZ4G
J1vtPzNPtH9TnANA+OceuhNc7T9xsk3vwKEDQGIkICHtXe0/7XiAzpusA0A4
nSLvn2HtP+UF5oxRwgNA4o4niwVp7T/VH7EJve0DQDdyMcPQd+0/tVNHA5RE
BEDhOEUzZ5XtP4hLuIUcRwRAzLlTKESW7T9cQykIpUkEQLk6Yh0hl+0/AjML
DbZOBECQPH8H25jtP04SzxbYWARAQEC5206c7T/o0FYqHG0EQJ9HLYQ2o+0/
Gk5mUaSVBEBeVhXVBbHtP+1F19MsmARAStcjyuKx7T/APUhWtZoEQDZYMr+/
su0/Zi0qW8afBEAOWk+pebTtP7MM7mToqQRAvV2Jfe237T+GBF/ncKwEQKne
l3LKuO0/WvzPafmuBECVX6Znp7ntPwDssW4KtARAbWHDUWG77T9My3V4LL4E
QB1l/SXVvu0/H8Pm+rTABEAJ5gsbsr/tP/K6V309wwRA9GYaEI/A7T/Gssj/
xcUEQOHnKAVswe0/mao5gk7IBEDMaDf6SMLtP+zmtxAwygRAhTQcDe3C7T8U
uQRT
                "]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEAgusObWcTtP7mBbg75
1ARAdB41nnzF7T+Med+QgdcEQDXSPTEBxu0/MmnBlZLcBEC2OU9XCsftP39I
hZ+05gRAuQhyoxzJ7T/SXmhcMOkEQGk1Fpqeye0/JHVLGazrBEAZYrqQIMrt
P8qhEZOj8ARAeLsCfiTL7T8U+52GkvoEQDduk1gsze0/qK22bXAOBUCz07QN
PNHtP9AS6DssNgVArZ73d1vZ7T8h3UrYo4UFQKE0fUya6e0/isI7r1WIBUAP
vHxSJ+rtP/KnLIYHiwVAfUN8WLTq7T/Ccg40a5AFQFhSe2TO6+0/ZAjSjzKb
BUAQcHl8Au7tP6gzWUfBsAVAf6t1rGry7T8uime23tsFQF0ibgw7++0/lm9Y
jZDeBUDLqW0SyPvtP/9USWRC4QVAOTFtGFX87T/QHysSpuYFQBVAbCRv/e0/
cbXubW3xBUDMXWo8o//tP7TgdSX8BgZAO5lmbAsE7j86N4SUGTIGQBkQX8zb
DO4/1mIZNp00BkCOHxpgXw3uP3OOrtcgNwZAAy/V8+IN7j+s5dgaKDwGQO1N
SxvqDu4/HpQtoTZGBkDBizdq+BDuP7q/wkK6SAZANpvy/XsR7j9X61fkPUsG
QKuqrZH/Ee4/kEKCJ0VQBkCVySO5BhPuPwLx1q1TWgZAaQcQCBUV7j+eHGxP
11wGQN4Wy5uYFe4/O0gB8VpfBkBUJoYvHBbuP9hzlpLeYQZAyTVBw58W7j+F
gFGqyWMGQCosDSgEF+4/X6UBzA==
                "]], 
               
               Line[{{2.8012755102040816`, 0.9404834335778608}, {
                2.8039259500890124`, 0.9407091950672075}, {
                2.8051535791448154`, 0.9408137631298824}, {2.806381208200619, 
                0.9409183311925573}, {2.8088364663122256`, 
                0.9411274673179071}, {2.8137469825354393`, 
                0.9415457395686068}, {2.814974611591243, 
                0.9416503076312817}, {2.816202240647046, 
                0.9417548756939566}, {2.818657498758653, 
                0.9419640118193063}, {2.8235680149818663`, 
                0.9423822840700059}, {2.833389047428293, 
                0.9432188285714052}, {2.853031112321146, 
                0.9448919175742035}, {2.9382035922548035`, 
                0.9521468136503243}, {2.998724489795918, 
                0.9573019156555299}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEB9XuuJ6KPuPxPetaIC
xAhARsFPczbf7j+ODH19t8YIQCHq/OgK4O4/CjtEWGzJCED9Eqpe3+DuPwKY
0g3WzghAs2QESoji7j/yUe94qdkIQCEIuSDa5e4/0MUoT1DvCED8TiLOfezu
P4ytm/udGglAstz0KMX57j8I3GLWUh0JQI4Fop6Z+u4/hAoqsQcgCUBpLk8U
bvvuP3tnuGZxJQlAIICp/xb97j9qIdXRRDAJQI0jXtZoAO8/SJUOqOtFCUBo
aseDDAfvPwV9gVQ5cQlAHviZ3lMU7z+08ez5v3MJQARt4CgaFe8/ZGZYn0Z2
CUDq4SZz4BXvP8RPL+pTewlAt8uzB20X7z+EIt1/boUJQE+fzTCGGu8/NJdI
JfWHCUA1FBR7TBvvP+QLtMp7iglAHIlaxRIc7z9E9YoViY8JQOhy51mfHe8/
9Gn2ug+SCUDO5y2kZR7vP6TeYWCWlAlAtFx07isf7z+5s4Td/JYJQIyJWVzo
H+8/zJG0Lw==
                "]], 
               
               Line[{{3.201275510204082, 0.9727862184055909}, {
                3.2049527235388684`, 0.9729115067645273}, {3.209886242298752, 
                0.9730795993968914}, {3.21975327981852, 0.9734157846616194}, {
                3.2209866595084913`, 0.9734578078197104}, {
                3.2222200391984623`, 0.9734998309778015}, {
                3.2246867985784045`, 0.9735838772939834}, {
                3.2296203173382887`, 0.9737519699263475}, {
                3.2394873548580567`, 0.9740881551910755}, {
                3.2592214298975932`, 0.9747605257205316}, {
                3.2605580005307244`, 0.9748060647540284}, {
                3.2618945711638556`, 0.9748516037875252}, {
                3.2645677124301176`, 0.9749426818545188}, {3.269913994962642, 
                0.975124837988506}, {3.2806065600276906`, 
                0.9754891502564804}, {3.3019916901577884`, 
                0.9762177747924292}, {3.3447619504179835`, 
                0.9776750238643268}, {3.398724489795918, 
                0.9795136112366585}}], 
               
               Line[{{3.4012755102040817`, 0.9796005284566982}, {
                3.507084223974069, 0.983205595365386}, {3.5920292423158866`, 
                0.9860998038267766}, {3.5987244897959183`, 
                0.9863279212877658}}], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArrLhiGnPDEDCw/XZtZDvPzZXp+vd
Yw1AbFMkU/Gk7z+7Dw+z12gNQDUFW+yepe8/xoDeQctyDUDJaMge+qbvP9ti
fV+yhg1A8C+jg7Cp7z8GJ7uagK4NQD6+WE0dr+8/SQNvfv2wDUAjF/QZdK/v
P4zfImJ6sw1ACHCP5sqv7z8RmIopdLgNQNIhxn94sO8/HAlauGfCDUBlhTOy
07HvPzLr+NVO1g1AjUwOF4q07z9drzYRHf4NQNvaw+D2ue8/tlr4DtAADkA/
cPEMVbrvPw4GugyDAw5AogUfObO67z/AXD0I6QgOQGowepFvu+8/IgpE/7QT
DkD5hTBC6LzvP+ZkUe1MKQ5AFzGdo9m/7z8+EBPr/ysOQHrGys83wO8/l7vU
6LIuDkDeW/j7lcDvP0gSWOQYNA5ApYZTVFLB7z+qv17b5D4OQDTcCQXLwu8/
Amsg2ZdBDkCYcTcxKcPvP1sW4tZKRA5A/AZlXYfD7z8MbWXSsEkOQMMxwLVD
xO8/bhpsyXxUDkBSh3ZmvMXvP8bFLccvVw5AthykkhrG7z8fce/E4lkOQBmy
0b54xu8/eByxwpVcDkB9R//q1sbvP9DHcsBIXw5A4dwsFzXH7z8oczS++2EO
QEVyWkOTx+8/hYBRqsljDkDID3w30sfvP9Pb7dk=
                "]], 
               
               Line[{{3.8012755102040816`, 0.993185689948893}, {
                3.8070691712239952`, 0.993185689948893}, {3.8123410159841984`,
                 0.993185689948893}, {3.8228847055046042`, 
                0.993185689948893}, {3.8334283950250096`, 
                0.993185689948893}, {3.872782814308162, 0.993185689948893}, {
                3.912137233591315, 0.993185689948893}, {3.956068575979331, 
                0.993185689948893}, {3.999999918367347, 0.993185689948893}}]},
               "Charting`Private`Tag$69502#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {0, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, 
           PlotRange -> {{0., 3.999999918367347}, {0., 0.9958762886597937}}, 
           PlotRangeClipping -> True, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT763gjG8ENgPgRDGnDf
GVQ/ss/X3TvXPT8zn5icsxlkP463FM761k0/S83Xsp0ZdD99KzNG2tZdP1dk
972SGYQ/dGVCAsrWbT/dL4dDjRmUP3ACSuDB1n0/oBVPhooZpD/u0E3PvdaN
P4EIsyeJGbQ/LLjPxrvWnT8qR5GIsnC0P1ZHvcogWJ4/0oVv6dvHtD9/1qrO
hdmePyQDLKsudrU/1PSF1k/cnz/G/aQu1NK2P70YHvPx8KA/DPOWNR+MuT9l
VdQChvaiP5jdekO1/r4/ts5AIq4Bpz9BHFmk3lW/P0uWN6RgQqc/6lo3BQit
vz/gXS4mE4OnPx7seWOtLcA/Cu0bKngEqD9vaTYlANzAP14L9zFCB6k/EmSv
qKU4wj8GSK1B1gyrP1hZoa/w8cQ/VsEZYf4Xrz/v21QKohrFP0YcUVFnVK8/
hl4IZVNDxT82d4hB0JCvP7Njbxq2lMU/ipb7ENEEsD8Obj2FezfGP2pMavGi
fbA/xYLZWgZ9xz8puEeyRm+xP1wFjbW3pcc/oWVjKnuNsT/yh0AQac7HPxgT
f6Kvq7E/II2nxcsfyD8IbraSGOixP7cPWyB9SMg/gBvSCk0Gsj9Okg57LnHI
P/jI7YKBJLI/fJd1MJHCyD/oIyVz6mCyPxMaKYtC68g/YNFA6x5/sj+qnNzl
8xPJP9h+XGNTnbI/QB+QQKU8yT9PLHjbh7uyP9ehQ5tWZck/x9mTU7zZsj+Q
O0vYzW/JP3hzHQqB4bI/JywTdg==
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8c3iHYIDuzPzKsEQYc
CMo/8Fm7DHibsz/JLsVgzTDKPyiFKNOF1LM/YLF4u35Zyj9gsJWZkw20P422
33Dhqso/zwZwJq9/tD/owK3bpk3LP62zJEDmY7U/ntVJsTGTzD9qDY5zVCy3
Pwv/gVxHHs8/5sBg2jC9uj+YaVdeLEbPPzCg7R4g9bo/JNQsYBFuzz94f3pj
Dy27Pz6p12Pbvc8/Cz6U7O2cuz+5qZa1ty7QPzK7x/6qfLw/7VPsvEvO0D9/
tS4jJTy+P1Wol8tzDdI/DVX+tYzdwD8lUe7ow4vUP6dJzP6AXMQ/Gn9HOmeh
1D87vCF213rEPxCtoIsKt9Q/0S537S2ZxD/6CFMuUeLUP/kTItza1cQ/0MC3
c9441T9N3ne5NE/FP3owgf745dU/8nIjdOhBxj/ODxQULkDXPzqceulPJ8g/
wz1tZdFV1z/ODtBgpkXIP7hrxrZ0a9c/YoEl2PxjyD+jx3hZu5bXP4xm0Map
oMg/eH/dnkjt1z/eMCakAxrJPyLvpiljmtg/gsXRXrcMyj8XHQB7BrDYPxg4
J9YNK8o/DEtZzKnF2D+sqnxNZEnKP/emC2/w8Ng/1o8nPBGGyj/MXnC0fUfZ
PyhafRlr/8o/lWryuLOE2T8YQ/xuPVXLPxZb+ms=
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAn8hAen+u2T/4+gaY45jLP6SNMIz7
HNo/qJYDUqJjzD/RTCfZXkXaP2GeUXi/rcw/K8sUcyWW2j/Ure3E+UHNP9/H
76ayN9s/uswlXm5qzj9HwaUOzXrcP0MFS8irXdA/F7QR3gEB3z8QQ7v6lK7S
P1yM+1TkFt8/cS6PYqnC0j+iZOXLxizfP9QZY8q91tI/LBW5uYtY3z+X8Aqa
5v7SP0J2YJUVsN8/IJ5aOThP0z82nFemlC/gPy75+Xfb79M/YV6mXaje4D9O
rzj1ITHVP4RKG5mZ6eA/sJoMXTZF1T+mNpDUivTgPxGG4MRKWdU/7A56S20K
4T/WXIiUc4HVP3a/TTkyNuE/XArYM8XR1T+MIPUUvI3hP25ld3JoctY/tuJD
zM884j+LG7bvrrPXP9ZIgfGNR+I/bkhWmGXH1z/2rr4WTFLiP1J19kAc29c/
N3s5Ychn4j8czzaSiQLYP7gTL/bAkuI/rIK3NGRR2D/YeWwbf53iP5CvV90a
Zdg/+N+pQD2o4j9z3PeF0XjYPzisJIu5veI/OjY41z6g2D+5RBogsujiP8rp
uHkZ79g/2qpXRXDz4j+wFlki0ALZP/oQlWou/uI/lEP5yoYW2T863Q+1qhPj
P1udORz0Pdk/WkNN2mge4z8+ytnEqlHZP7Cb30LAKOM/awVl5qRk2T8b8QmM

                "]], 
               LineBox[{{0.6012755102040817, 0.3987534188933306}, {
                0.602707593256919, 0.39966877094772146`}, {0.6040189648065841,
                 0.400506967195961}, {0.6066417079059144, 
                0.4021833596924402}, {0.6118871941045749, 
                0.40553614468539845`}, {0.61319856565424, 
                0.406374340933638}, {0.6145099372039051, 
                0.40721253718187755`}, {0.6171326803032354, 
                0.4088889296783567}, {0.6223781665018959, 
                0.412241714671315}, {0.6328691388992168, 
                0.4189472846572314}, {0.6538510836938587, 
                0.4323584246290644}, {0.732138185275487, 
                0.48239760295958967`}, {0.7987244897959184, 
                0.524957921312855}}], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T87ZjYuRtngPzb/YLZT
ruw/vljE3pyi4j9MTcCCRbjsP7Mf0tp0qOI/Y5sfTzfC7D+p5t/WTK7iP5A3
3uca1uw/lHT7zvy54j/pb1sZ4v3sP2mQMr9c0eI/nOBVfHBN7T8UyKCfHADj
PwHCSkKN7O0/ajd9YJxd4z8YEKoOf/btP2D+ilx0Y+M/Ll4J23AA7j9VxZhY
TGnjP1r6x3NUFO4/P1O0UPx04z+0MkWlGzzuPxVv60BcjOM/ZqM/CKqL7j/A
plkhHLvjP8yENM7GKu8/FhY24psY5D86D8sCkTXvP0/zBwnzHuQ/qJlhN1tA
7z+H0NkvSiXkP4OujqDvVe8/+Ip9ffgx5D862OhyGIHvP9r/xBhVS+Q/qGJ/
p+KL7z8T3ZY/rFHkPxbtFdyslu8/TLpoZgNY5D/xAUNFQazvP710DLSxZOQ/
qCudF2rX7z+f6VNPDn7kPxa2M0w04u8/2MYldmWE5D+EQMqA/uzvPxCk95y8
iuQ/fWisD4317z+LXC3Zw4/kPzvgzig=
                "]], 
               LineBox[{{1.0012755102040816`, 0.6437723543025458}, {
                1.0029484390136711`, 0.6443932350978574}, {
                1.0055826833813366`, 0.6453708928013209}, {
                1.0068998055651694`, 0.6458597216530526}, {1.008216927749002, 
                0.6463485505047843}, {1.0108511721166678`, 
                0.6473262082082478}, {1.0161196608519991`, 
                0.649281523615175}, {1.017436783035832, 0.6497703524669067}, {
                1.0187539052196648`, 0.6502591813186386}, {
                1.0213881495873305`, 0.651236839022102}, {1.0266566383226616`,
                 0.6531921544290291}, {1.0371936157933241`, 
                0.6571027852428832}, {1.0582675707346494`, 
                0.6649240468705916}, {1.1369227129030104`, 
                0.6941156460258596}, {1.1987244897959184`, 
                0.7170523879654955}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z/Mn9Z8T/nmPw4dp+/k
5PQ/BPWJgy0L6D9AVoPd4+n0P56VQ/leDug/co9fy+Lu9D83Nv1ukBHoP9YB
GKfg+PQ/andwWvMX6D+e5ohe3Az1P8/5VjG5JOg/LrBqzdM09T+a/iPfRD7o
P01DLqvChPU/Lwi+Olxx6D9+fAqZwYn1P8iod7CNdOg/sLXmhsCO9T9hSTEm
v3foPxQon2K+mPU/lIqkESJ+6D/cDBAauqz1P/oMi+jniug/bNbxiLHU9T/E
EViWc6ToP4xptWagJPY/Whvy8YrX6D/qQK2ICyr2P3f55JAB2+g/RxilqnYv
9j+S19cveN7oPwLHlO5MOvY/y5O9bWXl6D95JHR2+U/2PzwMiek/8+g/1vtr
mGRV9j9X6nuItvboPzTTY7rPWvY/dMhuJy366D+SqlvcOmD2P5CmYcaj/eg/
pZo87ixh9j8Gn/5/Pv7oPxdhwWI=
                "]], 
               LineBox[{{1.4012755102040815`, 0.7817325899431938}, {
                1.4024622524621388`, 0.7820017479811038}, {
                1.4051079980981398`, 0.7826018140016401}, {
                1.4064308709161404`, 0.7829018470119082}, {1.407753743734141, 
                0.7832018800221764}, {1.410399489370142, 
                0.7838019460427127}, {1.415690980642144, 
                0.7850020780837854}, {1.426273963186148, 
                0.7874023421659306}, {1.4686058933621644`, 
                0.7970033984945116}, {1.547629076117258, 
                0.8149261822121617}, {1.5987244897959185`, 
                0.8265148327372187}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T8FjFJNHnfqP/tq1Jsp
evs/rPcOUYgn6z9UNl2RLn/7P5v2azVlKes/rAHmhjOE+z+K9cgZQivrP16Y
93E9jvs/Z/OC4vsu6z/BxRpIUaL7PyPv9nNvNus/hyBh9HjK+z+Z5t6WVkXr
PxPW7UzIGvw/htWu3CRj6z9soXZCzR/8P3XUC8EBZes/xGz/N9Ik/D9j02il
3mbrP3YDESPcLvw/QdEibphq6z/ZMDT570L8P/zMlv8Lcus/n4t6pRdr/D9y
xH4i84DrP/hWA5sccPw/YcPbBtCC6z9QIoyQIXX8P1DCOOushOs/Armdeyt/
/D8uwPKzZojrP2XmwFE/k/w/6btmRdqP6z++sUlHRJj8P9i6wym3kes/Fn3S
PEmd/D/GuSAOlJPrP8gT5CdTp/w/pLfa1k2X6z8rQQf+Zrv8P1+zTmjBnus/
sKqrJ9jA/D9xgx91xqDrPzQUUFFJxvw/glPwgcui6z8MAaNUk8f8P7MPk/xF
o+s/E83LYQ==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D/mdCzdnKbrP8BQPc6c
1vw/6agnsNen6z9FuuH3Ddz8P6Fb9xxNqes/To0qS/Dm/D8PwZb2N6zrP3LZ
TZh5Ev0/ylYUXeO36z+5cZQyjGn9Pz+CDyo6z+s/R6IhZ7EX/j8o2QXE5/3r
PzSYDibGHP4/M49Sa0T/6z8gjvvk2iH+Pz1FnxKhAOw/+nnVYgQs/j9TsThh
WgPsP61RiV5XQP4/fYlr/swI7D8TAfFV/Wj+P9M50TiyE+w/31/AREm6/j9+
mpytfCnsP8xVrQNev/4/iFDpVNkq7D+4S5rCcsT+P5MGNvw1LOw/kjd0QJzO
/j+ocs9K7y7sP0UPKDzv4v4/00oC6GE07D+rvo8zlQv/Pyj7ZyJHP+w/dx1f
IuFc/z/TWzOXEVXsP2JQMFbcYf8/4OK/ZWdW7D9OgwGK12b/P+1pTDS9V+w/
Jumj8c1w/z8HeGXRaFrsP9S06MC6hP8/O5SXC8Bf7D8wTHJflKz/P6PM+39u
auw/HH9Dk4+x/z+wU4hOxGvsPweyFMeKtv8/vdoUHRpt7D/eF7cugcD/P9fo
LbrFb+w/jOP7/W3U/z8LBWD0HHXsP3gWzTFp2f8/GIzswnJ27D9jSZ5lZN7/
PyUTeZHId+w/Oq9AzVro/z8/IZIudHrsPybiEQFW7f8/TKge/cl77D8RFeM0
UfL/P1kvq8sffew//Ee0aEz3/z9mtjeadX7sPz801ofG+v8/cvATMWR/7D9w
syNf
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAA4eUUvJwCAEDv97i5i4HsP0sj5TUa
CABAQDEKbiGD7D8iiYedEBIAQIN7EaEBhuw/0FTMbP0lAEAKECAHwovsPyzs
VQvXTQBAFzk900KX7D+4VEy/ilAAQFIy830KmOw/Q71Ccz5TAECNK6ko0pjs
P1qOL9ulWABAAh4VfmGa7D+JMAmrdGMAQO0C7SiAnew/5nS8ShJ5AEDEzJx+
vaPsP6D9IopNpABAcGD8KTiw7D8TD/AIxPoAQMmHu4Atyew/0r2Kh0n9AEDO
gsjU58nsP5JsJQbP/wBA033VKKLK7D8SyloD2gQBQN5z79AWzOw/EoXF/e8O
AUDzXyMhAM/sPxD7mvIbIwFAHDiLwdLU7D8M50Xcc0sBQHDoWgJ44Ow/zJXg
WvlNAUB142dWMuHsP4xEe9l+UAFAet50quzh7D8LorDWiVUBQITUjlJh4+w/
Cl0b0Z9fAUCZwMKiSubsPwjT8MXLcwFAw5gqQx3s7D/IgYtEUXYBQMiTN5fX
7Ow/iDAmw9Z4AUDNjkTrke3sPweOW8DhfQFA2IRekwbv7D8GSca694cBQOxw
kuPv8ew/xvdgOX2KAUDya583qvLsP4am+7cCjQFA92asi2Tz7D8FBDG1DZIB
QAFdxjPZ9Ow/xLLLM5OUAUAGWNOHk/XsP7mzhN38lgFA65w100X27D9u2/cf

                "]], 
               LineBox[{{2.201275510204082, 0.905272985482853}, {
                2.2025743146728987`, 0.9053934931139803}, {
                2.2039086887592343`, 0.905517301018898}, {2.206577436931906, 
                0.9057649168287335}, {2.21191493327725, 0.9062601484484046}, {
                2.222589925967937, 0.9072506116877468}, {2.2439399113493117`, 
                0.909231538166431}, {2.2866398821120604`, 
                0.9131933911237994}, {2.3704807786936803`, 
                0.9209724433839497}, {2.398724489795918, 
                0.9235929938985904}}], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAFBlI7881A0DwHREfzI/tP7VTRwOU
RARAYxzc4vTd7T+IS7iFHEcEQGZ2tRWw3u0/XEMpCKVJBEBp0I5Ia9/tPwIz
Cw22TgRAb4RBruHg7T9OEs8W2FgEQHrspnnO4+0/6NBWKhxtBECSvHEQqOnt
P7vIx6ykbwRAlBZLQ2Pq7T+OwDgvLXIEQJdwJHYe6+0/NLAaND53BECdJNfb
lOztP4GP3j1ggQRAqYw8p4Hv7T8aTmZRpJUEQMBcBz5b9e0/7UXX0yyYBEDC
tuBwFvbtP8A9SFa1mgRAxRC6o9H27T9mLSpbxp8EQMvEbAlI+O0/swzuZOip
BEDXLNLUNPvtP4YEX+dwrARA2YarB/D77T9a/M9p+a4EQN3ghDqr/O0/AOyx
bgq0BEDilDegIf7tP0zLdXgsvgRA7vycaw4B7j8fw+b6tMAEQPFWdp7JAe4/
8rpXfT3DBEDzsE/RhALuP8ayyP/FxQRA9wopBEAD7j+ZqjmCTsgEQPlkAjf7
A+4/7Oa3EDDKBEDswo04hgTuP8o+wf8=
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEBv8JAtkgbuP7mBbg75
1ARAqizhmVIJ7j+Med+QgdcEQPjGVYOTCu4/MmnBlZLcBECU+z5WFQ3uP39I
hZ+05gRAzGQR/BgS7j/SXmhcMOkEQPWEmZNTE+4/JHVLGazrBEAepSErjhTu
P8qhEZOj8ARAcOUxWgMX7j8U+52GkvoEQBNmUrjtG+4/qK22bXAOBUBaZ5N0
wiXuP9AS6DssNgVA52kV7Ws57j8h3UrYo4UFQAJvGd6+YO4/isI7r1WIBUCY
GkQ7FGLuP/KnLIYHiwVALcZumGlj7j/Ccg40a5AFQFcdxFIUZu4/ZAjSjzKb
BUCsy27HaWvuP6gzWUfBsAVAVyjEsBR27j8uime23tsFQKzhboNqi+4/lm9Y
jZDeBUBBjZngv4zuP/9USWRC4QVA1zjEPRWO7j/QHysSpuYFQAKQGfi/kO4/
cbXubW3xBUBXPsRsFZbuP7TgdSX8BgZAAZsZVsCg7j86N4SUGTIGQFZUxCgW
tu4/1mIZNp00BkD9AjuoVLfuP3OOrtcgNwZApLGxJ5O47j+s5dgaKDwGQPMO
nyYQu+4/HpQtoTZGBkCPyXkkCsDuP7q/wkK6SAZANnjwo0jB7j9X61fkPUsG
QN4mZyOHwu4/kEKCJ0VQBkAshFQiBMXuPwLx1q1TWgZAyT4vIP7J7j+eHGxP
11wGQHDtpZ88y+4/O0gB8VpfBkAXnBwfe8zuP9hzlpLeYQZAvkqTnrnN7j+F
gFGqyWMGQI2dZqKszu4/vlgF/g==
                "]], LineBox[CompressedData["
1:eJwVz2kw1HEcBnDZ/H4krRzNZExLTcaR1JSOMev7rZQROjURg9w61hKlREp4
IRMhhcqbrk0yIQ2qSWoHObJWKTtD5Vjl94+tJWf/XjzzzOfNM/NYh8QcCNfV
0dFx5PO/3b2SVgqiCa4WX+4N72Aw6J1aK5UQVMbfMfH8wODSWfOA31KCz/0s
xdW8RXdls2dOESxyvRkp6mTgO9OFFxIJBunn1Wt4t8js5NmXCKqLMyJKuhhE
db+MWppOsCVVkEuUDBbq+iwqyCRYHp5aJ+Xt6pfiXXKFYJzTOeOd3QwqqEIh
u05wpuFk7ehHBvlh5/vkMoLCEZ8l8IVBwIr2vwsUBJ23rHrW389gyfK46jol
waFSh1afrwxem5rHJnwieMNg43c5bxsD/+FhFcGpz24m5d8YcJrB7vZhgq+S
IyTnBvh/TXOVt+YIerx5aGOqZvAgfq1kqz3FgD3rCt1+MTgS88FOs4aiUc2W
8hreRsfiB8qcKL4SbXtrP8YgLqg2wMqZovXYfo3xOAOX3bs8KVIczDu1V6Vh
0CYKtFUeoijteUZPTzD405z9VXqRYlqYOPH+HINeQ2XUTBpFlzaDXybzDBq8
LLnMDIrjm7sjU3jntMmmb2dRDDaMOXxIhwP7TrlZawFF8dPSTQJdDgJ7Frjb
yShq5wV/AvU4cLPwaK0qo/g4uuNEM28H/5yD+IRiuKLkuzPhYLJ3RfDhKoqK
e85diykH1/pczqa/pFjhHVlZq8/Bu6GER/2dFKOLm2OXLeagzPbF+pNKilZ6
heqLvPOiFz6f/EjxkyT06Cjv4B/XGoUqiru2z+xrNOJgij1RiYcorlI7rosT
ctDnNBHapKb4+cDUfRVvudR1xOcnxdz6dyIPYw7yx99rj49RnL8aJLRaykHS
BrPkCQ3Fmr8OmVm8Q+L9BWlaipLQyTktbyetWlg0TbF3Uy5rNeFAZPFjR+gs
v3+6xXe5KQf/AFkKXCY=
                "]], 
               LineBox[{{3.001275510204082, 0.9711340206185567}, {
                3.00530855047641, 0.9711340206185567}, {3.0077939192994325`, 
                0.9711340206185567}, {3.0127646569454773`, 
                0.9711340206185567}, {3.017735394591522, 
                0.9711340206185567}, {3.0567217732879426`, 
                0.9711340206185567}, {3.0957081519843626`, 
                0.9711340206185567}, {3.1802851297394477`, 
                0.9711340206185567}, {3.1852186484993315`, 
                0.9711340206185567}, {3.1901521672592157`, 
                0.9711340206185567}, {3.192618926639158, 
                0.9711340206185567}, {3.1950856860191, 0.9711340206185567}, {
                3.196319065709071, 0.9711340206185567}, {3.197552445399042, 
                0.9711340206185567}, {3.1987244897959184`, 
                0.9711340206185567}}], LineBox[CompressedData["
1:eJwVx30s1HEcwPFjbfb7/lab83TzFCmdhc4qra35fDyvqeXOTOXuZh5bI2OR
HuZxO2PVpoQuT8lInpokmqTrPI1MVx6mxwlR6YMxE6pff7z33ssxMlERYywS
iaRC/38loynUs5TDcoereabmBHrtLHbd5zAteIivsCDISSgcm2jkMGjitbLV
isDYbNFoh47DpW8jfz7ZELTkhtcW6jmcPWYaEm1LELnZe9ymj8P39fLaecG6
mbJi6RCHPYmGkyt2BNntQW6+YxyWrL2t5BwIjNS1p9K+c+hlMu5zcDeBqE7d
PCVmmO/8UZPnStD7c/x8hQVDn4VBY2s3gmsyubtSwnD98bP0h4Kt2n0bR+0Y
xnmXpA66E7j3Sev7pQz9lCGx2z0IlDPLNU1eDP8WDPgXHCLocMwtv3yO4YWt
J9vueBGkx4jUhxMY7tNXZ7oAgV/dJbuVRIZT+bc2OwSPyOJLE1IYyiVJK5NI
MAdybUQmQ/cDrtO2vgSWapuigCKGc2erXlUGEiRrm6+LdQxV725kPwgmeLqp
zdXpGU6Kw5WecoJNtSYruY9hmHyvp15wrpMqxTDEUDH8Yv6zgqC0galujjMM
6F8Mtgol6OmKcRUvMNzfqdipOU3AHOXOOmLY8Nt+3ewMQXDOUYfkZYYuR34Y
7gmeDDQzN6wxdGrL0TwPJ/g10r1RYMyj5FHrwoqKQPLVZtBUwqNRtWVnVCSB
yt+k56U1j+lTU7eXBFfVLncl2fG44dCcmBFF4Bo/0PJmF4+rZYFOd6MJkoZb
G7L28Jj8wWxLGkPQJqus8ZDySNZfxtoEe6+magvceJwvTss3xBJowiILvWU8
xo35RUfEEShO2F8sEtwtHZ1OEvwPwyoo0w==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbfDDJcFUeIZ7+3D6lSaAi24HYR42s8b
AvmzH/DXMFpzO/yo89TzA/IfOP0u3WjL7XDvI3dvFpCfxX4pU9CZ22Hl9Qle
i4H89Zl7kw+6cjv0ewWv3A/kfzm9IrbQg9uhdK8oxx0gv35CfeBFX24Hh8Wz
jopkvrefIqlrOTGC2+FG3hKHNiB/r3YHh2AetwMb2w6zzKz39mZXxM9OKuB2
0KtcvbYZyN9Qs3yiSDG3Q+ibeSrzgPxFZ49JSVRwOyy51Cp0GcjvyGfVlW/i
dnCcH/zOJvu9fdDmpkDdadwO1RbvlwrkvLd/blU7y3Mft8OHLDXRHbnv7QW9
inSa+Hgcbp2f8pmt8L39Hd0Llyv38DjMvqZZaVzx3v7Ns+0CBqd4HNiEN1ke
AfIBadCF9A==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOP459Tfhd8d7eLHz567vJvA5HdJ5N
lKp/b7+bn3/z9QxehzPZZyX8gfxjDfccTxfxOtx5OVttB5B/O6k2flMbr8Pf
pxZOXQ3v7dnUd89qWMfrYHevqFKv6b29J3N+3d8NvA6Hap/t8QDye+4rJVVt
5nVwk41iSAbyBWd0aZbs4HXwi3Fsnw7ky3BG7Ug/xOsQf4t/KkPze3uj1z+u
+l3jdai/tmbDJSA/dr2ZoOw/XocD5549L2t9b78t6gffBQY+Bwv/2rTJQD4f
2y6eZmY+hw3nhZ+uB/IPxNhyvOTgc5h/weHRCyBficvl/xZhPof6S7PuRLW9
t3+WEvjWR5PPwfaa30W79vf2dgLCr/9r8zlsDXvqHw3kT9995cUmPT4HnevV
58qBfA+hiCcSJnwOMjdWnN4A5K/aH3f7iR2fw++bTMeUOt7b50nlnKwJ4XPY
eXfbLrZOYHgd1T2uH87nYBjna6kM5MsXvj/yKJLPYeW9x9vtgfwKmY2Hpsbw
OSjEV5nFAPkXjhcd8Ijnc5hxX2BrBZCvUWyy73cin4NAwnLjqUB+a0PgqpPJ
fA5pU9kdVgD5AF2X1kQ=
                "]], LineBox[CompressedData["
1:eJwV0VtIE1Acx/Glhal5Di7rISovZd6yetEKqfMnLIdbokMbtUxTA7dmQ1Jc
WXhrQ+dls8zytnTzlqaZTpJaVBRaSshaN2moZJildgoT87Z1evjx4/P89U6S
C885cDgcP7b/HyHI9nGUIBDumF1aKqJE7RXWOyBDkBN7sjBSTcnE0Er3ZTkC
eZxKWcBc4ZPbOZ6BIEo0njPPvDCsarqXg2CDuCJjpJiS6GyeISEfwYr4eTq3
hJLWXS4NXCWC6dM/L/CZT10trVWoEQye4UmeMJsCK26E30RQmLQS31BKSa6y
Ic/ahmCdNCVCoqHELcsp8mwHgqzzcxk65urUNO7kfQQ/ZPl6C3MP/6CBGhEM
y+tXD2kpmXQ3v3R4iqAq09rDLaeEr+OsD7AgCM6L9TJdp2Tzw4SyzGUEJ26H
L6JKSjqmttUgAYaW/p3txlpKCuuUiaNRGFyn5p1+MacIZ307YzDInQdSguoo
2WoydR0XYdgvkGzXM6s14v6SJAz95o5yjY6S1NCq3y6XMExaQxXSekp8rnnw
nJox+M7xjno1UmI7cMXtYyuGIo8tejHzyOzE2+Z2DDMh07ZKZq2oJ/7YAwxG
RWmfWxMl9kDhRaUJQ7jNHLTMbDVrdI4WDMnOYu6HFkr6VAvJlvcYBgJ3y91b
WZ+whADDJwxBgtUhATO/aY/xyCiGubI7yhfMjxRvXud9x1Dg8fVv111KKoND
NDEzGL6F9MbNMKd/qY31phj4IlW3Xxsl/gLZ2LM/GDZW+8t0zGvXvGvULmDI
erz4aoR5vDdMmriE4bN10HdTO+spNezdt4rhsK0mP5r5lqfrvN2OQe+ZNlbM
/A9PojGu
                "]]},
              Annotation[#, "Charting`Private`Tag$69610#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT56z1YrdWljPgRDGnDf
GVQ/WN8IQ4bOQT8zn5icsxlkP6qIHnBfzlE/S83Xsp0ZdD9UXakGTM5hP1dk
972SGYQ/qcfuUULOcT/dL4dDjRmUP9N8kXc9zoE/oBVPhooZpD9o12IKO86R
P4EIsyeJGbQ/soTL0znOoT8qR5GIsnC0P4h8EV1wG6I/0oVv6dvHtD9ddFfm
pmiiPyQDLKsudrU/CWTj+BMDoz/G/aQu1NK2P15D+x3uN6Q/DPOWNR+MuT8L
AitooqGmP5jdekO1/r4/ZH+K/Ap1qz9BHFmk3lW/Pzp30IVBwqs/6lo3BQit
vz8QbxYPeA+sPx7seWOtLcA/vF6iIeWprD9vaTYlANzAPxE+uka/3q0/EmSv
qKU4wj9f/nTIOSSwP1hZoa/w8cQ/DL2kEu6Nsj/v21QKohrFPz2QvGT6sbI/
hl4IZVNDxT9vY9S2BtayP7Njbxq2lMU/0QkEWx8esz8Obj2FezfGP5dWY6NQ
rrM/xYLZWgZ9xz8i8CE0s860P1wFjbW3pcc/VMM5hr/ytD/yh0AQac7HP4WW
UdjLFrU/II2nxcsfyD/oPIF85F61P7cPWyB9SMg/GRCZzvCCtT9Okg57LnHI
P0vjsCD9prU/fJd1MJHCyD+uieDEFe+1PxMaKYtC68g/4Fz4FiITtj+qnNzl
8xPJPxEwEGkuN7Y/QB+QQKU8yT9CAyi7Olu2P9ehQ5tWZck/dNY/DUd/tj+Q
O0vYzW/JP290knuMiLY/uakNdg==
                "]], 
               LineBox[{{0.20127551020408163`, 0.08962903730487083}, {
                0.2033724813112215, 0.09134376665994261}, {
                0.20461432671651483`, 0.09235924501520804}, {
                0.20585617212180818`, 0.09337472337047346}, {
                0.20833986293239484`, 0.0954056800810043}, {
                0.2133072445535682, 0.09946759350206598}, {0.2232420077959149,
                 0.10759142034418935`}, {0.24311153428060836`, 
                0.12383907402843614`}, {0.2443290196086536, 
                0.12483463272939306`}, {0.24554650493669883`, 
                0.12583019143034996`}, {0.24798147559278932`, 
                0.12782130883226384`}, {0.2528514169049703, 
                0.13180354363609156`}, {0.2625912995293323, 
                0.13976801324374702`}, {0.28207106477805627`, 
                0.15569695245905793`}, {0.3210305952755042, 
                0.18755483088967972`}, {0.3987244897959184, 
                0.25108646525049544`}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T8bEorlZjXQPxe0Ed4B
Ad8/cUe2FmXs1D9cjPtU5BbfP+Hl8hbI/9Q/omTly8Ys3z9ThC8XKxPVPywV
ubmLWN8/NMGoF/E51T9CdmCVFbDfP/g6mxh9h9U/NpxXppQv4D9/LoAalSLW
P2Fepl2o3uA/jRVKHsVY1z+EShuZmengP/+zhh4obNc/pjaQ1Ir04D9uUsMe
i3/XP+wOekttCuE/Uo88H1Gm1z92v005MjbhPxQJLyDd89c/jCD1FLyN4T+c
/BMi9Y7YP7biQ8zPPOI/qePdJSXF2T/WSIHxjUfiP8g3KKMt2Nk/9q6+FkxS
4j/mi3IgNuvZPzd7OWHIZ+I/JTQHG0cR2j+4Ey/2wJLiP6GEMBBpXdo/uUQa
ILLo4j+XJYP6rPXaP7Cb30LAKOM/fIPR5Cln2z+kl56b
                "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z+MwYpuNIfbP9wMLplS
n+M/XDGvLaoF3D/8cmu+EKrjP14MA9iSE9w/PT/mCI2/4z9lwqosZC/cP77X
252F6uM/cS761QZn3D+/CMfHdkDkP4cGmShM1tw/wmqdG1ns5D+1ttbN1rTd
P/UmPQ+tbec/F32V2JZ54D8+4kLHinjnPwijNp6fgOA/hp1If2iD5z/5yNdj
qIfgPxYUVO8jmec/2hQa77mV4D82AWvPmsTnP52sngXdseA/eNuYj4gb6D8k
3KcyI+rgP/yP9A9kyeg/MTu6jK9a4T9ES/rHQdToPyJhW1K4YeE/jAYAgB/f
6D8Sh/wXwWjhPx19C/Da9Og/9NI+o9J24T8+aiLQUSDpP7hqw7n1kuE/hiUo
iC8r6T+pkGR//pnhP87gLUANNuk/mbYFRQeh4T9eVzmwyEvpP3sCSNAYr+E/
f0RQkD936T8+mszmO8vhP8j/VUgdguk/L8BtrETS4T8Qu1sA+4zpPyDmDnJN
2eE/FwJGqSaP6T9HBT0otdrhP9TPy1k=
                "]], 
               LineBox[{{0.8012755102040817, 0.5593383861210584}, {
                0.8024388112602567, 0.5598536472362295}, {0.8037652381656297, 
                0.5604411617087968}, {0.8064180919763757, 
                0.5616161906539313}, {0.8170295072193599, 
                0.5663163064344694}, {0.8182677985372807, 
                0.5668647829977733}, {0.8195060898552016, 
                0.5674132595610774}, {0.8219826724910432, 
                0.5685102126876852}, {0.8269358377627265, 
                0.570704118940901}, {0.8368421683060933, 
                0.5750919314473326}, {0.8566548293928267, 
                0.5838675564601957}, {0.8962801515662935, 
                0.6014188064859222}, {0.9739717509693491, 
                0.6358307585213471}, {0.9987244897959183, 
                0.6467944929249383}}], 
               LineBox[{{1.0012755102040816`, 0.6479135521329485}, {
                1.1369227129030104`, 0.7068403608011373}, {
                1.1382548904425511`, 0.7074190750644813}, {
                1.1395870679820916`, 0.7079977893278251}, {1.142251423061173, 
                0.709155217854513}, {1.147580133219336, 0.7114700749078887}, {
                1.158237553535662, 0.7160997890146401}, {1.1795523941683133`, 
                0.7253592172281429}, {1.180884571707854, 
                0.7259379314914868}, {1.1822167492473947`, 
                0.7265166457548307}, {1.1848811043264762`, 
                0.7276740742815185}, {1.190209814484639, 
                0.7299889313348942}, {1.1915419920241797`, 
                0.7305676455982382}, {1.1928741695637202`, 
                0.7311463598615819}, {1.1955385246428016`, 
                0.7323037883882698}, {1.1968707021823424`, 
                0.7328825026516138}, {1.198202879721883, 
                0.7334612169149577}, {1.1987244897959184`, 
                0.7336878107290616}}], LineBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAA9P5cq2w48z9QqsAjHYLnP8FddHM1
PPM/tn8dSG+E5z+MzSNXqkHzP+dLIfrHh+c/Iq2CHpRM8z9K5CheeY7nP01s
QK1nYvM/EBU4Jtyb5z+k6rvKDo7zP5t2Vrahtuc/bpdPI2qT8z9mGP+96rnn
PzdE43vFmPM/MLqnxTO95z/KnQotfKPzP8X9+NTFw+c/8VBZj+m48z/whJvz
6dDnPz639lPE4/M/RJPgMDLr5z/ZgzHdeTn0P+6vaqvCH+g/Dh2n7+Tk9D9C
6X6g44joP0BWg93j6fQ/OLuM+vOL6D9yj1/L4u70Py2NmlQEj+g/1gEYp+D4
9D8ZMbYIJZXoP57miF7cDPU/73jtcGah6D8usGrN0zT1P50IXEHpueg/TUMu
q8KE9T/3Jzni7uroP358CpnBifU/7PlGPP/t6D+wteaGwI71P+LLVJYP8eg/
FCifYr6Y9T/Nb3BKMPfoP9wMEBq6rPU/pLensnED6T9s1vGIsdT1P1FHFoP0
G+k/jGm1ZqAk9j+sZvMj+kzpP+pArYgLKvY/F1kl2kxQ6T9HGKWqdi/2P4JL
V5CfU+k/AseU7kw69j9YMLv8RFrpP3kkdHb5T/Y/BfqC1Y9n6T/W+2uYZFX2
P2/stIviauk/NNNjus9a9j/b3uZBNW7pP5KqW9w6YPY/RtEY+Idx6T+lmjzu
LGH2P45WeW0ccuk/REYgqA==
                "]], 
               LineBox[{{1.4012755102040815`, 0.795831450126899}, {
                1.4024622524621388`, 0.7960740550178137}, {
                1.4051079980981398`, 0.796614922950216}, {1.4064308709161404`,
                 0.796885356916417}, {1.407753743734141, 
                0.7971557908826182}, {1.410399489370142, 
                0.7976966588150205}, {1.415690980642144, 0.798778394679825}, {
                1.426273963186148, 0.800941866409434}, {1.4686058933621644`, 
                0.80959575332787}, {1.547629076117258, 0.8257504073834258}, {
                1.5987244897959185`, 0.8361958071133052}}], 
               LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T/IivV08cXqP/tq1Jsp
evs/lmo57Mxf6z9UNl2RLn/7PyAYhdZsYes/rAHmhjOE+z+qxdDADGPrP16Y
93E9jvs/vyBolUxm6z/BxRpIUaL7P+fWlj7MbOs/hyBh9HjK+z85Q/SQy3nr
PxPW7UzIGvw/3BuvNcqT6z9soXZCzR/8P2bJ+h9qles/xGz/N9Ik/D/wdkYK
CpfrP3YDESPcLvw/BdLd3kma6z/ZMDT570L8Py6IDIjJoOs/n4t6pRdr/D9/
9GnayK3rP/hWA5sccPw/CaK1xGiv6z9QIoyQIXX8P5NPAa8Ises/Armdeyt/
/D+oqpiDSLTrP2XmwFE/k/w/0WDHLMi66z8rQQf+Zrv8PyLNJH/Hx+s/sKqr
J9jA/D8HGmdvisnrPzQUUFFJxvw/7GapX03L6z8MAaNUk8f8P+lzMzG4y+s/
r4axqQ==
                "]], 
               LineBox[{{1.8012755102040816`, 0.8689766366512534}, {
                1.8023956352454178`, 0.8691102120394877}, {
                1.8037242586975861`, 0.869268650952012}, {1.8063815056019226`,
                 0.8695855287770606}, {1.8170104932192683`, 
                0.8708530400772552}, {1.8382684684539596`, 
                0.8733880626776442}, {1.8807844189233422`, 
                0.8784581078784224}, {1.9601756422651684`, 
                0.8879255450742108}, {1.9987244897959184`, 
                0.8925225115599903}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBqlCezTZLsPxMP8AjE
+gBAe0RFwAki7T/SvYqHSf0AQBlmzqF/I+0/kmwlBs//AEC4h1eD9STtPxLK
WgPaBAFA9cppRuEn7T8ShcX97w4BQHBRjsy4Le0/EPua8hsjAUBlXtfYZznt
PwznRdxzSwFAT3hp8cVQ7T/MleBa+U0BQO2Z8tI7Uu0/jER72X5QAUCMu3u0
sVPtPwuisNaJVQFAyf6Nd51W7T8KXRvRn18BQEOFsv10XO0/CNPwxctzAUA4
kvsJJGjtP8iBi0RRdgFA17OE65lp7T+IMCbD1ngBQHbVDc0Pa+0/B45bwOF9
AUCzGCCQ+23tPwZJxrr3hwFALZ9EFtNz7T/G92A5fYoBQMzAzfdIde0/hqb7
twKNAUBq4lbZvnbtPwUEMbUNkgFApyVpnKp57T/Essszk5QBQEVH8n0ge+0/
ubOE3fyWAUCHV6JAhnztP7BTqV8=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUBVgUc6BH/tP9o8REjf
ngFAbo0gcAOA7T+vuuzgmqEBQCJgPKMJge0/WrY9EhKnAUCLBXQJFoPtP7Gt
33QAsgFAXVDj1S6H7T9enCM63ccBQADmwW5gj+0/uHmrxJbzAUBGEX+gw5/t
P2s0u9kJSwJA0Wf5A4rA7T/A0NWsuE0CQOZCsm2Lwe0/FW3wf2dQAkD7HWvX
jMLtP7+lJSbFVQJAJdTcqo/E7T8TF5BygGACQHlAwFGVyO0/u/lkC/d1AkAh
GYefoNDtPwu/Dj3koAJAcMoUO7fg7T9gWykQk6MCQIWlzaS44e0/tfdD40Gm
AkCagIYOuuLtP18weYmfqwJAxDb44bzk7T+zoePVWrYCQBej24jC6O0/W4S4
btHLAkC/e6LWzfDtP6tJYqC+9gJADi0wcuQA7j80LCE+P/kCQIaBa4rUAe4/
vg7g27/7AkD+1aaixALuP9DTXRfBAANA7H4d06QE7j/0XVmOwwoDQMrQCjRl
CO4/fUAYLEQNA0BBJUZMVQnuPwYj18nEDwNAuXmBZEUK7j8Z6FQFxhQDQKgi
+JQlDO4/PnJQfMgeA0CGdOX15Q/uP8dUDxpJIQNA/cggDtYQ7j9QN863ySMD
QHQdXCbGEe4/YvxL88ooA0BjxtJWphPuP+veCpFLKwNA2xoOb5YU7j90wcku
zC0DQFJvSYeGFe4//qOIzEwwA0DKw4SfdhbuP1JNHneWMANAaNJ4O5IW7j/P
zwF+
                "]], LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAFBlI7881A0C2SPVbLBjuP6wQQ+HP
PANAcnFbvdcZ7j/Qmj5Y0kYDQFzrw+M6HO4/WX399VJJA0DWCV6t0xzuP+Jf
vJPTSwNAUSj4dmwd7j/0JDrP1FADQEZlLAqeHu4/Ga81RtdaA0Aw35QwASHu
P2LDLDTcbgNABNNlfccl7j/16xoQ5pYDQK26BxdUL+4/lJ3nx5yZA0AGw+HH
+S/uPzNPtH9TnANAXsu7eJ8w7j9xsk3vwKEDQA/cb9rqMe4/7XiAzpusA0Bx
/dedgTTuP+UF5oxRwgNANUCoJK857j/VH7EJve0DQL7FSDIKRO4/tVNHA5RE
BEDO0IlNwFjuP4hLuIUcRwRA2fcT+VpZ7j9cQykIpUkEQOUenqT1We4/AjML
DbZOBED8bLL7KlvuP04SzxbYWARAKgnbqZVd7j/o0FYqHG0EQIdBLAZrYu4/
Gk5mUaSVBEA/ss6+FWzuP+1F19MsmARAS9lYarBs7j/APUhWtZoEQFYA4xVL
be4/Zi0qW8afBEBtTvdsgG7uP7MM7mToqQRAnOofG+tw7j+GBF/ncKwEQKcR
qsaFce4/WvzPafmuBECzODRyIHLuPwDssW4KtARAyoZIyVVz7j9My3V4LL4E
QPgicXfAde4/H8Pm+rTABEAESvsiW3buP/K6V309wwRAD3GFzvV27j+ZqjmC
TsgEQCa/mSUreO4/7Oa3EDDKBEDBTaD/nXjuPzRc+ww=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAArrLhiGnPBED18Z1qr3nuP4x535CB
1wRAXFsuZxB77j8yacGVktwEQEjcPFzte+4/f0iFn7TmBEAg3llGp33uP9Je
aFww6QRACK7ikxN+7j8kdUsZrOsEQO99a+F/fu4/yqERk6PwBEC/HX18WH/u
PxT7nYaS+gRAXV2gsgmB7j+orbZtcA4FQJvc5h5shO4/0BLoOyw2BUAW23P3
MIvuPyHdStijhQVADNiNqLqY7j+KwjuvVYgFQJJzjS0wme4/8qcshgeLBUAY
D42ypZnuP8JyDjRrkAVAJEaMvJCa7j9kCNKPMpsFQD20itBmnO4/qDNZR8Gw
BUBvkIf4EqDuPy6KZ7be2wVA00iBSGun7j+Wb1iNkN4FQFnkgM3gp+4//1RJ
ZELhBUDff4BSVqjuP9AfKxKm5gVA7LZ/XEGp7j9xte5tbfEFQAUlfnAXq+4/
tOB1JfwGBkA2AXuYw67uPzo3hJQZMgZAmrl06Bu27j/WYhk2nTQGQHxGO46J
tu4/c46u1yA3BkBd0wE097buP6zl2BooPAZAIO2Of9K37j8elC2hNkYGQKYg
qRaJue4/ur/CQrpIBkCIrW+89rnuP1frV+Q9SwZAaTo2YmS67j+QQoInRVAG
QCxUw60/u+4/AvHWrVNaBkCzh91E9rzuP54cbE/XXAZAlBSk6mO97j87SAHx
Wl8GQHahapDRve4/2HOWkt5hBkBXLjE2P77uP4WAUarJYwZA/tCF35K+7j+w
YAqM
                "]], LineBox[CompressedData["
1:eJwV0H0s1HEcB/Ajvt+S0Dop7BRNTsVEtZvq99l6kodCKjpkch4qXDglPV4r
FTZ5qky1KeG6RZ4m6kTqcB6W6/RoO7Uc0a8kDxXWpz8+e+/1x3t777M8PN5f
pM/hcJzw/ucO71TbOTEEltw1yLNqZJkBn3P14jgC6cNnvnmipSnmwb/EBHhx
iR/C0DbFspnjiQQqf0S1JaMDp1/D2RME3o37FhehVTK+MlNKYCXHLuQPOrpX
Eb3wIoEGqYWX2TOWMdAPMMpLI7DL0Fhgj94cdManMIOAxGic64+uoGq1LJ/A
c66yowydG3FKq5QROMg/sjGoiWWCed2/9dQErvtXWdU1s4zJ0oSaBg0Bz4iM
/m500yLzY5K3BGYlohId2n6ecHCwj0DETQtXi+cs831soLd7kICLNtUzGS1t
m626NUtAFbs1xa2FZUqTnOIEjhRmL2t6K16wzIH4V/yx1RQeFTwsbEUvOJz0
Re5MQSRPC9eiEw7WBy9bR0HVLWBNX7KMu+d2LwoUbiy+bRiP7rIJddDspbD2
XqTbGiXLjLdnfhKfx37j5LWyVpb5OF8TPX2BQkvUi5ZGdLO39fe0SxTszHIm
NeisLtnf2+kU+sOcQvTbWMaxR8ntzKMQqi9yEKJD3+nt4Mso7NvWozBuZ5mt
ljs7q+UUar7dGbVFrxJm7YFyCub5sSsE6KmPvLD91RTUA3OvitDZWveUiwoK
uy8zexXolzrJg/4eCh4q+XC8imXkDk9dYjUUShJP8i6hc2IM6qbeUCDWHn6F
6LDh7BbTPtx/9HNtK/oPW963SUcBTCylyztYRus8eahtiMKdWl31BrRSvPlr
wAj+N7RG54PO/dkxcWSUwtNyX5+T6FRX7unJMQrWgbxzWejwJOGcCxMUUjkj
lffRHjVFV0x+U3hf+vjLE7TzxJBpwV8KAr+0JWq0jeXwlkMzFJauj5R/Qv8D
uclrpA==
                "]], LineBox[CompressedData["
1:eJwVx3tIk1EcgOG1lM6xpZFNqVjklSWlFkotL+dHqaiVq22UFZjashJLhiO1
MWwyK+3udWARiEESsjIvNRKh2Z3GN0tJ1Mlai9Jx1tRNtLJOf7y8PGGFpbKT
fB6PF876f7tz7fM7fAQXQ1dzKR8oebQrxyhHCA6rlx35yNyiaUqcDECgPlvs
EVooUf6J2O0LQmA8nhzeymzwy1PLIhEYxHqnkaNk6URoojUawVabKc7DrDRz
XulmBC8aPJXbrZTEV+8p3x+LYHopL7CH+c1f8YXMnQhShyU7TEOUzC/OVqXu
Q+DQua8MfqLkkKf2aowaQezY0S2jnykJtvW08QcRmK9vK+PbKbkh0Gr7XiHo
+ylMz2IOSErLLXmL4KF8MeQWM98wtGrEgqB+ndkk+kLJzEF3RccogoL7Cr7E
QQn3Uiw94EbA6y+/Xeqk5Fpn66+76zEku/qN4z8oQeOFIzIRhnhpmy5iihJ9
QMzjFZswRHZdkhcza049LVJFYRBUSOfnmYvDhq1p8RjGlttTg12UZDYFPphO
x1C5wc+SRSnx1+oUEhWG3uxsV+8MJd0e18JAGYZOlcB/gVlZlHsv4zyGdoNF
lDRLyaA0bkquwdDwTSYdYNaHT1Sdq8Ggqj7W9XqOkoSWzCjvZQynO0TvsZeS
ryu732nqMORzk469zGneOmHtTQw5G5VCjnnujM8UVI8hIz06do2PknZbQX5z
I4aUku8ZCuZnT/QTv5sx1HAJIQ3M/wCZOgaY
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPFzVvl9f1viOBdO1LJrobNK/+DzuZNUlIeI4q66zR/yNOeh
R0Wai9HmodMu0rLoPC4ZGjt1nYcWwkLZ2npARu7brCah+vXHe++93FSpEfF8
Ho8n4fr/K9ebo3wqGdx4U0Gzls1g0s2ioYZBvfugQb5ihrzk8ol3TQxa+n18
1LBqBr7gu8VmI4MdCVYZ2TwKrZrYunITg8dTh5ocLCio1vpCnPoZnM4o/fqE
s3GmqkIyyKBNjnPsLJ/Cjc5gz4AJBpO0UnnoBgoWyrqYi/MMur6M2eJGKPD0
ypbPtgQLnPWNJgGFvm+TKdX2BNfZ5qFEOwpF0nCvOBFB9Wqr2daegkNnQNO4
mGDsVLf0nJCCV7+kYUBC0PPuSNu6iELczFJtsz/BUcGvbh8XCs/cNPcvnye4
lQ0aeiyhcC2epzyQTPD272Bz6C4KB/WXxD9SCfLnw6yXOY9IkyqTMwkuDJwO
D9xNYQ7CdWdzCBryU8Y/eVIQKp20h7QEVXztB8e9FNS6lmJbI8H6lenFIj8K
HWs6jdFEsDB4m6W3P4U1ZX6uup9gYtUp0ThnzQ5F5tggQQ/ZsFyMFCobiaJ0
kmDzrY6KJjmFXkO8h+0iwVaHQtlwEAXiFu5upATLEkwn1YcphOX5uqqXCKZ3
/UkUHqEwFSSwG1smuO9MulZ5lIJ55PlqCZ/F9tq4BXMIBdEXp9c2Iha79u+5
Yx1BQRG4qfeFI4v3NAn1Tzk/rFsypIlZvPq+pif6BAWPpFeto9tZ9MsWzVdH
UkgbbmvM3cmi+E3E34AoCu3SB7XeEhb/uBbbzXGW/czSlXiy2GOyAGk0hfxo
VblMymK10DfyLeeIYy4XtJxtCqzK5jj/A6OOIC0=
                "]], LineBox[CompressedData["
1:eJwVzH0s1HEcB/BfHqJ9v8XldtxtknajcO2aCXfs91FpYmkoneN0Hq64GufU
5lmuNGzyFBoVWcjSyu7Uap2H6KIyD6VUphsVV+o3pWis+vrjvfdee29v5/jU
cIUZRVFuJGvN5gYxw14IPoTEvLsmYejIPL4mzAdBdmXsPR1xvdEmZ50YQc9j
R9cXxMY9K2c6/BFY/pysnSFWWo0ls/YiuBgRnbk5iqHvJOsTegMRjJ3jfdlB
vPj8piwtCIG97q00gDi/PD9s9CCCRrbET0V8iSvwrZAg0I4f/jdErHcvsmal
IJg4GlpYLGXo3a/shypVCAa3mCU0EN/Naa1gpyN48KkTOombhgw8hwwEdemO
q0biolRLgZMGQUzZvNonmqHDtZowQQ0Co6FEPks8K8qtO9CFYM7rqThQxtCs
YLWHZhOGP3bwg5IzdGOvDRKxMGxQTrQ6EAt9b5sW7DBwe1QyIXHo9rmWOC4G
0anrA8eIS9bHOgfwMWT1mzV0EVv0HeBQIgyrp5+E5MQx9G+xM5WnwEC9Dm5e
imfoQm3XlFcSBluPGalNAkOz3WP035QYtmqybV2JPXm1WTIVhoCd7dmRxKpl
/MsvG0PBhY3hncQm3bJppRyDuffIX3UiQ2d41AxoqzDYlSbpSoitb3i2nqzB
wJ+hlE3ELlUpie/rMewr2zU+Shyf9nHqYQuGwtnKW0IFQy/MFejVbRiq/d3j
gojPyp2uuLVjaK7q48iJGw5Jo+o6MBjoxYIy4knByMvMRxisLh+RfF/bv7Jy
zbsx9J2fzrI4Tv7bIlxKezHkp6Ve5RG7nKge5vRjEMeudguJTfw3GY0GDEvB
xdP7idunHba5DWLQenMsZcTzn+/bCp9hME7pFxTE/wEObCxj
                "]], LineBox[CompressedData["
1:eJwV0FtI01EcB/CZNW//c3TOQmoZiWijXJDig5HnJ0ZqSbQRmJeUTXNequUt
0zbTyUzMLBAvCJoPWWgy3SwTjTJTlySo5QUUtXRqXtYpRjDJtNPDly+fx+/3
qEIlu7aHx+P5svxvvfFbWdooB+F9yv3vUyjR1MpvzUxy0Dod0JSmpGSvcLnf
MsOBMLlY9YNZ4Lyp9FjmwKwWYVsqJRMmf0HjKgeeYR9yg9MoqdOpevzWOYhy
Sp9TM3vZWbnTlINX1a/b7NIpOWHbMsi3OCjVyy64ZFBybsVhW48Q+H0tK/O6
QUlHI/ExJyBofybXZORSYi2wOsjlCOLEUzVtzEHRzzfmkhDw2853WJh7XV07
p1MRJBgCllS3KRkqmg/9lIWAe7MvMiePklmFJtFYiiB9vMVDk08J36+3vkiP
wGf714tKDSWR9qrCvx0IxgpTBkeZKxa8FQWdCNR2s/NuhWxvXbk4pxvBF/6A
oIpZ5BTbrexHoBXU5NXeo+TUhm3y4hSCBd/gsKZiSq62BwkO7yCol2pnDDpK
umJteIyHobn46V0bM+b3cCX2GNoNQyJSSklf/BnHNUcMgwKXxBFmb+ezuy+F
GH6OVy2t3KdkJVlqiRJjCJc1bx4qpyTETbixexyDVGt6qGCu7Z34bpRgiDeu
SVqYI9yvmD0DMWS5SzKDHlDS+i5h1hyCoeFz1+9LFZTcPHh9WH0Zg1X2cUdX
yf4a9DedjMawo11/MsJ8JJMOLMZgcOrkQoWPKLkjMvRXx2PwWJIsxjCPmbL6
IhIxeAmlJU3Mx7ID3/6RYxCHZfusMuuKpK3DSRii8iviDjym5B8orhzX
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPHraES+X6n5S3LXkrPR0xLd1u+zZpflodwaG+mkh2FkN7UU
eZoz41fn4ZSHc0uHneSpOzK7TWtRKWsccTKUTVld35KmpaNPf7z33kuUlCG/
JBQIBHux/z8RkS12SCFgjAvKU5YzrtRH2vMijYCwpvhsJXrh9d/HNzMIxNsr
PrWiNeL8jvmrBNxeGuxT6NW3xc2P8ggoE95JjlQw7nR2mF5RSGD42QdTFNrg
69LooSKw28/GXUbH3bqtzSolML7sEFONNvtrqkKrCQSXHCj8ic5XNRbMPCQg
MPLTnZWMc7vudPJ8OwHHTn5sEF2XnO6x2ElgSxs//B5tDA/RMxOB7Xq+36mK
cYvbRp8LBwj4VvF1CnS4TuAssRCIyOTjqIZxnk8Ud66tEag9xE9fqWZc++ed
9SSCwkFT2XRADeNKGlSJs1EUet11iTL0RbltT0c0hZD0rsVzaC+zuSsylgL4
Tiyr0aXq+CE+iUJkjbfrMjo5qPaHyw0KyTnd0t5axomLdoQ5tVBoCJ3UHqtn
3HpwjtukgYKocUkci7baFsZa2ig02dcMGejyWGOCrJtCW69Pz330hr88U2Wm
0OeXOiLUMm5mVK1zsFCwbLXbh9B9xasXLBMUYlJo0RxaI1VI9FMUrIMil9/o
8OZA0/FZCvO5Mk9JA+P6s0ZeFSxR+PZdHViGvhtwWB39lYIy8oFJj1Z+1J4R
MQorraajZrRfRNrc0xUKa0lWmQ3tuGm8qXyVQu7AlzebdYyb75GmJv6hIPRa
l3ujzan6ffvtFFRZ7tYg9L1drr82Nig4T4gVp9D/AHjKL7A=
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$69610#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{0, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{{0., 3.999999918367347}, {0., 0.989690719966337}},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT763gjG8ENgPgRDGnDf
GVQ/ss/X3TvXPT8zn5icsxlkP463FM761k0/S83Xsp0ZdD99KzNG2tZdP1dk
972SGYQ/dGVCAsrWbT/dL4dDjRmUP3ACSuDB1n0/oBVPhooZpD/u0E3PvdaN
P4EIsyeJGbQ/LLjPxrvWnT8qR5GIsnC0P1ZHvcogWJ4/0oVv6dvHtD9/1qrO
hdmePyQDLKsudrU/1PSF1k/cnz/G/aQu1NK2P70YHvPx8KA/DPOWNR+MuT9l
VdQChvaiP5jdekO1/r4/ts5AIq4Bpz9BHFmk3lW/P0uWN6RgQqc/6lo3BQit
vz/gXS4mE4OnPx7seWOtLcA/Cu0bKngEqD9vaTYlANzAP14L9zFCB6k/EmSv
qKU4wj8GSK1B1gyrP1hZoa/w8cQ/VsEZYf4Xrz/v21QKohrFP0YcUVFnVK8/
hl4IZVNDxT82d4hB0JCvP7Njbxq2lMU/ipb7ENEEsD8Obj2FezfGP2pMavGi
fbA/xYLZWgZ9xz8puEeyRm+xP1wFjbW3pcc/oWVjKnuNsT/yh0AQac7HPxgT
f6Kvq7E/II2nxcsfyD8IbraSGOixP7cPWyB9SMg/gBvSCk0Gsj9Okg57LnHI
P/jI7YKBJLI/fJd1MJHCyD/oIyVz6mCyPxMaKYtC68g/YNFA6x5/sj+qnNzl
8xPJP9h+XGNTnbI/QB+QQKU8yT9PLHjbh7uyP9ehQ5tWZck/x9mTU7zZsj+Q
O0vYzW/JP3hzHQqB4bI/JywTdg==
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8c3iHYIDuzPzKsEQYc
CMo/8Fm7DHibsz/JLsVgzTDKPyiFKNOF1LM/YLF4u35Zyj9gsJWZkw20P422
33Dhqso/zwZwJq9/tD/owK3bpk3LP62zJEDmY7U/ntVJsTGTzD9qDY5zVCy3
Pwv/gVxHHs8/5sBg2jC9uj+YaVdeLEbPPzCg7R4g9bo/JNQsYBFuzz94f3pj
Dy27Pz6p12Pbvc8/Cz6U7O2cuz+5qZa1ty7QPzK7x/6qfLw/7VPsvEvO0D9/
tS4jJTy+P1Wol8tzDdI/DVX+tYzdwD8lUe7ow4vUP6dJzP6AXMQ/Gn9HOmeh
1D87vCF213rEPxCtoIsKt9Q/0S537S2ZxD/6CFMuUeLUP/kTItza1cQ/0MC3
c9441T9N3ne5NE/FP3owgf745dU/8nIjdOhBxj/ODxQULkDXPzqceulPJ8g/
wz1tZdFV1z/ODtBgpkXIP7hrxrZ0a9c/YoEl2PxjyD+jx3hZu5bXP4xm0Map
oMg/eH/dnkjt1z/eMCakAxrJPyLvpiljmtg/gsXRXrcMyj8XHQB7BrDYPxg4
J9YNK8o/DEtZzKnF2D+sqnxNZEnKP/emC2/w8Ng/1o8nPBGGyj/MXnC0fUfZ
PyhafRlr/8o/lWryuLOE2T8YQ/xuPVXLPxZb+ms=
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAn8hAen+u2T/4+gaY45jLP6SNMIz7
HNo/qJYDUqJjzD/RTCfZXkXaP2GeUXi/rcw/K8sUcyWW2j/Ure3E+UHNP9/H
76ayN9s/uswlXm5qzj9HwaUOzXrcP0MFS8irXdA/F7QR3gEB3z8QQ7v6lK7S
P1yM+1TkFt8/cS6PYqnC0j+iZOXLxizfP9QZY8q91tI/LBW5uYtY3z+X8Aqa
5v7SP0J2YJUVsN8/IJ5aOThP0z82nFemlC/gPy75+Xfb79M/YV6mXaje4D9O
rzj1ITHVP4RKG5mZ6eA/sJoMXTZF1T+mNpDUivTgPxGG4MRKWdU/7A56S20K
4T/WXIiUc4HVP3a/TTkyNuE/XArYM8XR1T+MIPUUvI3hP25ld3JoctY/tuJD
zM884j+LG7bvrrPXP9ZIgfGNR+I/bkhWmGXH1z/2rr4WTFLiP1J19kAc29c/
N3s5Ychn4j8czzaSiQLYP7gTL/bAkuI/rIK3NGRR2D/YeWwbf53iP5CvV90a
Zdg/+N+pQD2o4j9z3PeF0XjYPzisJIu5veI/OjY41z6g2D+5RBogsujiP8rp
uHkZ79g/2qpXRXDz4j+wFlki0ALZP/oQlWou/uI/lEP5yoYW2T863Q+1qhPj
P1udORz0Pdk/WkNN2mge4z8+ytnEqlHZP7Cb30LAKOM/awVl5qRk2T8b8QmM

                "]], 
               
               Line[{{0.6012755102040817, 0.3987534188933306}, {
                0.602707593256919, 0.39966877094772146`}, {0.6040189648065841,
                 0.400506967195961}, {0.6066417079059144, 
                0.4021833596924402}, {0.6118871941045749, 
                0.40553614468539845`}, {0.61319856565424, 
                0.406374340933638}, {0.6145099372039051, 
                0.40721253718187755`}, {0.6171326803032354, 
                0.4088889296783567}, {0.6223781665018959, 
                0.412241714671315}, {0.6328691388992168, 
                0.4189472846572314}, {0.6538510836938587, 
                0.4323584246290644}, {0.732138185275487, 
                0.48239760295958967`}, {0.7987244897959184, 
                0.524957921312855}}], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T87ZjYuRtngPzb/YLZT
ruw/vljE3pyi4j9MTcCCRbjsP7Mf0tp0qOI/Y5sfTzfC7D+p5t/WTK7iP5A3
3uca1uw/lHT7zvy54j/pb1sZ4v3sP2mQMr9c0eI/nOBVfHBN7T8UyKCfHADj
PwHCSkKN7O0/ajd9YJxd4z8YEKoOf/btP2D+ilx0Y+M/Ll4J23AA7j9VxZhY
TGnjP1r6x3NUFO4/P1O0UPx04z+0MkWlGzzuPxVv60BcjOM/ZqM/CKqL7j/A
plkhHLvjP8yENM7GKu8/FhY24psY5D86D8sCkTXvP0/zBwnzHuQ/qJlhN1tA
7z+H0NkvSiXkP4OujqDvVe8/+Ip9ffgx5D862OhyGIHvP9r/xBhVS+Q/qGJ/
p+KL7z8T3ZY/rFHkPxbtFdyslu8/TLpoZgNY5D/xAUNFQazvP710DLSxZOQ/
qCudF2rX7z+f6VNPDn7kPxa2M0w04u8/2MYldmWE5D+EQMqA/uzvPxCk95y8
iuQ/fWisD4317z+LXC3Zw4/kPzvgzig=
                "]], 
               
               Line[{{1.0012755102040816`, 0.6437723543025458}, {
                1.0029484390136711`, 0.6443932350978574}, {
                1.0055826833813366`, 0.6453708928013209}, {
                1.0068998055651694`, 0.6458597216530526}, {1.008216927749002, 
                0.6463485505047843}, {1.0108511721166678`, 
                0.6473262082082478}, {1.0161196608519991`, 
                0.649281523615175}, {1.017436783035832, 0.6497703524669067}, {
                1.0187539052196648`, 0.6502591813186386}, {
                1.0213881495873305`, 0.651236839022102}, {1.0266566383226616`,
                 0.6531921544290291}, {1.0371936157933241`, 
                0.6571027852428832}, {1.0582675707346494`, 
                0.6649240468705916}, {1.1369227129030104`, 
                0.6941156460258596}, {1.1987244897959184`, 
                0.7170523879654955}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z/Mn9Z8T/nmPw4dp+/k
5PQ/BPWJgy0L6D9AVoPd4+n0P56VQ/leDug/co9fy+Lu9D83Nv1ukBHoP9YB
GKfg+PQ/andwWvMX6D+e5ohe3Az1P8/5VjG5JOg/LrBqzdM09T+a/iPfRD7o
P01DLqvChPU/Lwi+Olxx6D9+fAqZwYn1P8iod7CNdOg/sLXmhsCO9T9hSTEm
v3foPxQon2K+mPU/lIqkESJ+6D/cDBAauqz1P/oMi+jniug/bNbxiLHU9T/E
EViWc6ToP4xptWagJPY/Whvy8YrX6D/qQK2ICyr2P3f55JAB2+g/RxilqnYv
9j+S19cveN7oPwLHlO5MOvY/y5O9bWXl6D95JHR2+U/2PzwMiek/8+g/1vtr
mGRV9j9X6nuItvboPzTTY7rPWvY/dMhuJy366D+SqlvcOmD2P5CmYcaj/eg/
pZo87ixh9j8Gn/5/Pv7oPxdhwWI=
                "]], 
               
               Line[{{1.4012755102040815`, 0.7817325899431938}, {
                1.4024622524621388`, 0.7820017479811038}, {
                1.4051079980981398`, 0.7826018140016401}, {
                1.4064308709161404`, 0.7829018470119082}, {1.407753743734141, 
                0.7832018800221764}, {1.410399489370142, 
                0.7838019460427127}, {1.415690980642144, 
                0.7850020780837854}, {1.426273963186148, 
                0.7874023421659306}, {1.4686058933621644`, 
                0.7970033984945116}, {1.547629076117258, 
                0.8149261822121617}, {1.5987244897959185`, 
                0.8265148327372187}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T8FjFJNHnfqP/tq1Jsp
evs/rPcOUYgn6z9UNl2RLn/7P5v2azVlKes/rAHmhjOE+z+K9cgZQivrP16Y
93E9jvs/Z/OC4vsu6z/BxRpIUaL7PyPv9nNvNus/hyBh9HjK+z+Z5t6WVkXr
PxPW7UzIGvw/htWu3CRj6z9soXZCzR/8P3XUC8EBZes/xGz/N9Ik/D9j02il
3mbrP3YDESPcLvw/QdEibphq6z/ZMDT570L8P/zMlv8Lcus/n4t6pRdr/D9y
xH4i84DrP/hWA5sccPw/YcPbBtCC6z9QIoyQIXX8P1DCOOushOs/Armdeyt/
/D8uwPKzZojrP2XmwFE/k/w/6btmRdqP6z++sUlHRJj8P9i6wym3kes/Fn3S
PEmd/D/GuSAOlJPrP8gT5CdTp/w/pLfa1k2X6z8rQQf+Zrv8P1+zTmjBnus/
sKqrJ9jA/D9xgx91xqDrPzQUUFFJxvw/glPwgcui6z8MAaNUk8f8P7MPk/xF
o+s/E83LYQ==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D/mdCzdnKbrP8BQPc6c
1vw/6agnsNen6z9FuuH3Ddz8P6Fb9xxNqes/To0qS/Dm/D8PwZb2N6zrP3LZ
TZh5Ev0/ylYUXeO36z+5cZQyjGn9Pz+CDyo6z+s/R6IhZ7EX/j8o2QXE5/3r
PzSYDibGHP4/M49Sa0T/6z8gjvvk2iH+Pz1FnxKhAOw/+nnVYgQs/j9TsThh
WgPsP61RiV5XQP4/fYlr/swI7D8TAfFV/Wj+P9M50TiyE+w/31/AREm6/j9+
mpytfCnsP8xVrQNev/4/iFDpVNkq7D+4S5rCcsT+P5MGNvw1LOw/kjd0QJzO
/j+ocs9K7y7sP0UPKDzv4v4/00oC6GE07D+rvo8zlQv/Pyj7ZyJHP+w/dx1f
IuFc/z/TWzOXEVXsP2JQMFbcYf8/4OK/ZWdW7D9OgwGK12b/P+1pTDS9V+w/
Jumj8c1w/z8HeGXRaFrsP9S06MC6hP8/O5SXC8Bf7D8wTHJflKz/P6PM+39u
auw/HH9Dk4+x/z+wU4hOxGvsPweyFMeKtv8/vdoUHRpt7D/eF7cugcD/P9fo
LbrFb+w/jOP7/W3U/z8LBWD0HHXsP3gWzTFp2f8/GIzswnJ27D9jSZ5lZN7/
PyUTeZHId+w/Oq9AzVro/z8/IZIudHrsPybiEQFW7f8/TKge/cl77D8RFeM0
UfL/P1kvq8sffew//Ee0aEz3/z9mtjeadX7sPz801ofG+v8/cvATMWR/7D9w
syNf
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAA4eUUvJwCAEDv97i5i4HsP0sj5TUa
CABAQDEKbiGD7D8iiYedEBIAQIN7EaEBhuw/0FTMbP0lAEAKECAHwovsPyzs
VQvXTQBAFzk900KX7D+4VEy/ilAAQFIy830KmOw/Q71Ccz5TAECNK6ko0pjs
P1qOL9ulWABAAh4VfmGa7D+JMAmrdGMAQO0C7SiAnew/5nS8ShJ5AEDEzJx+
vaPsP6D9IopNpABAcGD8KTiw7D8TD/AIxPoAQMmHu4Atyew/0r2Kh0n9AEDO
gsjU58nsP5JsJQbP/wBA033VKKLK7D8SyloD2gQBQN5z79AWzOw/EoXF/e8O
AUDzXyMhAM/sPxD7mvIbIwFAHDiLwdLU7D8M50Xcc0sBQHDoWgJ44Ow/zJXg
WvlNAUB142dWMuHsP4xEe9l+UAFAet50quzh7D8LorDWiVUBQITUjlJh4+w/
Cl0b0Z9fAUCZwMKiSubsPwjT8MXLcwFAw5gqQx3s7D/IgYtEUXYBQMiTN5fX
7Ow/iDAmw9Z4AUDNjkTrke3sPweOW8DhfQFA2IRekwbv7D8GSca694cBQOxw
kuPv8ew/xvdgOX2KAUDya583qvLsP4am+7cCjQFA92asi2Tz7D8FBDG1DZIB
QAFdxjPZ9Ow/xLLLM5OUAUAGWNOHk/XsP7mzhN38lgFA65w100X27D9u2/cf

                "]], 
               
               Line[{{2.201275510204082, 0.905272985482853}, {
                2.2025743146728987`, 0.9053934931139803}, {
                2.2039086887592343`, 0.905517301018898}, {2.206577436931906, 
                0.9057649168287335}, {2.21191493327725, 0.9062601484484046}, {
                2.222589925967937, 0.9072506116877468}, {2.2439399113493117`, 
                0.909231538166431}, {2.2866398821120604`, 
                0.9131933911237994}, {2.3704807786936803`, 
                0.9209724433839497}, {2.398724489795918, 
                0.9235929938985904}}], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAFBlI7881A0DwHREfzI/tP7VTRwOU
RARAYxzc4vTd7T+IS7iFHEcEQGZ2tRWw3u0/XEMpCKVJBEBp0I5Ia9/tPwIz
Cw22TgRAb4RBruHg7T9OEs8W2FgEQHrspnnO4+0/6NBWKhxtBECSvHEQqOnt
P7vIx6ykbwRAlBZLQ2Pq7T+OwDgvLXIEQJdwJHYe6+0/NLAaND53BECdJNfb
lOztP4GP3j1ggQRAqYw8p4Hv7T8aTmZRpJUEQMBcBz5b9e0/7UXX0yyYBEDC
tuBwFvbtP8A9SFa1mgRAxRC6o9H27T9mLSpbxp8EQMvEbAlI+O0/swzuZOip
BEDXLNLUNPvtP4YEX+dwrARA2YarB/D77T9a/M9p+a4EQN3ghDqr/O0/AOyx
bgq0BEDilDegIf7tP0zLdXgsvgRA7vycaw4B7j8fw+b6tMAEQPFWdp7JAe4/
8rpXfT3DBEDzsE/RhALuP8ayyP/FxQRA9wopBEAD7j+ZqjmCTsgEQPlkAjf7
A+4/7Oa3EDDKBEDswo04hgTuP8o+wf8=
                "]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEBv8JAtkgbuP7mBbg75
1ARAqizhmVIJ7j+Med+QgdcEQPjGVYOTCu4/MmnBlZLcBECU+z5WFQ3uP39I
hZ+05gRAzGQR/BgS7j/SXmhcMOkEQPWEmZNTE+4/JHVLGazrBEAepSErjhTu
P8qhEZOj8ARAcOUxWgMX7j8U+52GkvoEQBNmUrjtG+4/qK22bXAOBUBaZ5N0
wiXuP9AS6DssNgVA52kV7Ws57j8h3UrYo4UFQAJvGd6+YO4/isI7r1WIBUCY
GkQ7FGLuP/KnLIYHiwVALcZumGlj7j/Ccg40a5AFQFcdxFIUZu4/ZAjSjzKb
BUCsy27HaWvuP6gzWUfBsAVAVyjEsBR27j8uime23tsFQKzhboNqi+4/lm9Y
jZDeBUBBjZngv4zuP/9USWRC4QVA1zjEPRWO7j/QHysSpuYFQAKQGfi/kO4/
cbXubW3xBUBXPsRsFZbuP7TgdSX8BgZAAZsZVsCg7j86N4SUGTIGQFZUxCgW
tu4/1mIZNp00BkD9AjuoVLfuP3OOrtcgNwZApLGxJ5O47j+s5dgaKDwGQPMO
nyYQu+4/HpQtoTZGBkCPyXkkCsDuP7q/wkK6SAZANnjwo0jB7j9X61fkPUsG
QN4mZyOHwu4/kEKCJ0VQBkAshFQiBMXuPwLx1q1TWgZAyT4vIP7J7j+eHGxP
11wGQHDtpZ88y+4/O0gB8VpfBkAXnBwfe8zuP9hzlpLeYQZAvkqTnrnN7j+F
gFGqyWMGQI2dZqKszu4/vlgF/g==
                "]], 
               Line[CompressedData["
1:eJwVz2kw1HEcBnDZ/H4krRzNZExLTcaR1JSOMev7rZQROjURg9w61hKlREp4
IRMhhcqbrk0yIQ2qSWoHObJWKTtD5Vjl94+tJWf/XjzzzOfNM/NYh8QcCNfV
0dFx5PO/3b2SVgqiCa4WX+4N72Aw6J1aK5UQVMbfMfH8wODSWfOA31KCz/0s
xdW8RXdls2dOESxyvRkp6mTgO9OFFxIJBunn1Wt4t8js5NmXCKqLMyJKuhhE
db+MWppOsCVVkEuUDBbq+iwqyCRYHp5aJ+Xt6pfiXXKFYJzTOeOd3QwqqEIh
u05wpuFk7ehHBvlh5/vkMoLCEZ8l8IVBwIr2vwsUBJ23rHrW389gyfK46jol
waFSh1afrwxem5rHJnwieMNg43c5bxsD/+FhFcGpz24m5d8YcJrB7vZhgq+S
IyTnBvh/TXOVt+YIerx5aGOqZvAgfq1kqz3FgD3rCt1+MTgS88FOs4aiUc2W
8hreRsfiB8qcKL4SbXtrP8YgLqg2wMqZovXYfo3xOAOX3bs8KVIczDu1V6Vh
0CYKtFUeoijteUZPTzD405z9VXqRYlqYOPH+HINeQ2XUTBpFlzaDXybzDBq8
LLnMDIrjm7sjU3jntMmmb2dRDDaMOXxIhwP7TrlZawFF8dPSTQJdDgJ7Frjb
yShq5wV/AvU4cLPwaK0qo/g4uuNEM28H/5yD+IRiuKLkuzPhYLJ3RfDhKoqK
e85diykH1/pczqa/pFjhHVlZq8/Bu6GER/2dFKOLm2OXLeagzPbF+pNKilZ6
heqLvPOiFz6f/EjxkyT06Cjv4B/XGoUqiru2z+xrNOJgij1RiYcorlI7rosT
ctDnNBHapKb4+cDUfRVvudR1xOcnxdz6dyIPYw7yx99rj49RnL8aJLRaykHS
BrPkCQ3Fmr8OmVm8Q+L9BWlaipLQyTktbyetWlg0TbF3Uy5rNeFAZPFjR+gs
v3+6xXe5KQf/AFkKXCY=
                "]], 
               
               Line[{{3.001275510204082, 0.9711340206185567}, {
                3.00530855047641, 0.9711340206185567}, {3.0077939192994325`, 
                0.9711340206185567}, {3.0127646569454773`, 
                0.9711340206185567}, {3.017735394591522, 
                0.9711340206185567}, {3.0567217732879426`, 
                0.9711340206185567}, {3.0957081519843626`, 
                0.9711340206185567}, {3.1802851297394477`, 
                0.9711340206185567}, {3.1852186484993315`, 
                0.9711340206185567}, {3.1901521672592157`, 
                0.9711340206185567}, {3.192618926639158, 
                0.9711340206185567}, {3.1950856860191, 0.9711340206185567}, {
                3.196319065709071, 0.9711340206185567}, {3.197552445399042, 
                0.9711340206185567}, {3.1987244897959184`, 
                0.9711340206185567}}], 
               Line[CompressedData["
1:eJwVx30s1HEcwPFjbfb7/lab83TzFCmdhc4qra35fDyvqeXOTOXuZh5bI2OR
HuZxO2PVpoQuT8lInpokmqTrPI1MVx6mxwlR6YMxE6pff7z33ssxMlERYywS
iaRC/38loynUs5TDcoereabmBHrtLHbd5zAteIivsCDISSgcm2jkMGjitbLV
isDYbNFoh47DpW8jfz7ZELTkhtcW6jmcPWYaEm1LELnZe9ymj8P39fLaecG6
mbJi6RCHPYmGkyt2BNntQW6+YxyWrL2t5BwIjNS1p9K+c+hlMu5zcDeBqE7d
PCVmmO/8UZPnStD7c/x8hQVDn4VBY2s3gmsyubtSwnD98bP0h4Kt2n0bR+0Y
xnmXpA66E7j3Sev7pQz9lCGx2z0IlDPLNU1eDP8WDPgXHCLocMwtv3yO4YWt
J9vueBGkx4jUhxMY7tNXZ7oAgV/dJbuVRIZT+bc2OwSPyOJLE1IYyiVJK5NI
MAdybUQmQ/cDrtO2vgSWapuigCKGc2erXlUGEiRrm6+LdQxV725kPwgmeLqp
zdXpGU6Kw5WecoJNtSYruY9hmHyvp15wrpMqxTDEUDH8Yv6zgqC0galujjMM
6F8Mtgol6OmKcRUvMNzfqdipOU3AHOXOOmLY8Nt+3ewMQXDOUYfkZYYuR34Y
7gmeDDQzN6wxdGrL0TwPJ/g10r1RYMyj5FHrwoqKQPLVZtBUwqNRtWVnVCSB
yt+k56U1j+lTU7eXBFfVLncl2fG44dCcmBFF4Bo/0PJmF4+rZYFOd6MJkoZb
G7L28Jj8wWxLGkPQJqus8ZDySNZfxtoEe6+magvceJwvTss3xBJowiILvWU8
xo35RUfEEShO2F8sEtwtHZ1OEvwPwyoo0w==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbfDDJcFUeIZ7+3D6lSaAi24HYR42s8b
AvmzH/DXMFpzO/yo89TzA/IfOP0u3WjL7XDvI3dvFpCfxX4pU9CZ22Hl9Qle
i4H89Zl7kw+6cjv0ewWv3A/kfzm9IrbQg9uhdK8oxx0gv35CfeBFX24Hh8Wz
jopkvrefIqlrOTGC2+FG3hKHNiB/r3YHh2AetwMb2w6zzKz39mZXxM9OKuB2
0KtcvbYZyN9Qs3yiSDG3Q+ibeSrzgPxFZ49JSVRwOyy51Cp0GcjvyGfVlW/i
dnCcH/zOJvu9fdDmpkDdadwO1RbvlwrkvLd/blU7y3Mft8OHLDXRHbnv7QW9
inSa+Hgcbp2f8pmt8L39Hd0Llyv38DjMvqZZaVzx3v7Ns+0CBqd4HNiEN1ke
AfIBadCF9A==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOP459Tfhd8d7eLHz567vJvA5HdJ5N
lKp/b7+bn3/z9QxehzPZZyX8gfxjDfccTxfxOtx5OVttB5B/O6k2flMbr8Pf
pxZOXQ3v7dnUd89qWMfrYHevqFKv6b29J3N+3d8NvA6Hap/t8QDye+4rJVVt
5nVwk41iSAbyBWd0aZbs4HXwi3Fsnw7ky3BG7Ug/xOsQf4t/KkPze3uj1z+u
+l3jdai/tmbDJSA/dr2ZoOw/XocD5549L2t9b78t6gffBQY+Bwv/2rTJQD4f
2y6eZmY+hw3nhZ+uB/IPxNhyvOTgc5h/weHRCyBficvl/xZhPof6S7PuRLW9
t3+WEvjWR5PPwfaa30W79vf2dgLCr/9r8zlsDXvqHw3kT9995cUmPT4HnevV
58qBfA+hiCcSJnwOMjdWnN4A5K/aH3f7iR2fw++bTMeUOt7b50nlnKwJ4XPY
eXfbLrZOYHgd1T2uH87nYBjna6kM5MsXvj/yKJLPYeW9x9vtgfwKmY2Hpsbw
OSjEV5nFAPkXjhcd8Ijnc5hxX2BrBZCvUWyy73cin4NAwnLjqUB+a0PgqpPJ
fA5pU9kdVgD5AF2X1kQ=
                "]], 
               Line[CompressedData["
1:eJwV0VtIE1Acx/Glhal5Di7rISovZd6yetEKqfMnLIdbokMbtUxTA7dmQ1Jc
WXhrQ+dls8zytnTzlqaZTpJaVBRaSshaN2moZJildgoT87Z1evjx4/P89U6S
C885cDgcP7b/HyHI9nGUIBDumF1aKqJE7RXWOyBDkBN7sjBSTcnE0Er3ZTkC
eZxKWcBc4ZPbOZ6BIEo0njPPvDCsarqXg2CDuCJjpJiS6GyeISEfwYr4eTq3
hJLWXS4NXCWC6dM/L/CZT10trVWoEQye4UmeMJsCK26E30RQmLQS31BKSa6y
Ic/ahmCdNCVCoqHELcsp8mwHgqzzcxk65urUNO7kfQQ/ZPl6C3MP/6CBGhEM
y+tXD2kpmXQ3v3R4iqAq09rDLaeEr+OsD7AgCM6L9TJdp2Tzw4SyzGUEJ26H
L6JKSjqmttUgAYaW/p3txlpKCuuUiaNRGFyn5p1+MacIZ307YzDInQdSguoo
2WoydR0XYdgvkGzXM6s14v6SJAz95o5yjY6S1NCq3y6XMExaQxXSekp8rnnw
nJox+M7xjno1UmI7cMXtYyuGIo8tejHzyOzE2+Z2DDMh07ZKZq2oJ/7YAwxG
RWmfWxMl9kDhRaUJQ7jNHLTMbDVrdI4WDMnOYu6HFkr6VAvJlvcYBgJ3y91b
WZ+whADDJwxBgtUhATO/aY/xyCiGubI7yhfMjxRvXud9x1Dg8fVv111KKoND
NDEzGL6F9MbNMKd/qY31phj4IlW3Xxsl/gLZ2LM/GDZW+8t0zGvXvGvULmDI
erz4aoR5vDdMmriE4bN10HdTO+spNezdt4rhsK0mP5r5lqfrvN2OQe+ZNlbM
/A9PojGu
                "]]}, "Charting`Private`Tag$69610#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT56z1YrdWljPgRDGnDf
GVQ/WN8IQ4bOQT8zn5icsxlkP6qIHnBfzlE/S83Xsp0ZdD9UXakGTM5hP1dk
972SGYQ/qcfuUULOcT/dL4dDjRmUP9N8kXc9zoE/oBVPhooZpD9o12IKO86R
P4EIsyeJGbQ/soTL0znOoT8qR5GIsnC0P4h8EV1wG6I/0oVv6dvHtD9ddFfm
pmiiPyQDLKsudrU/CWTj+BMDoz/G/aQu1NK2P15D+x3uN6Q/DPOWNR+MuT8L
AitooqGmP5jdekO1/r4/ZH+K/Ap1qz9BHFmk3lW/Pzp30IVBwqs/6lo3BQit
vz8QbxYPeA+sPx7seWOtLcA/vF6iIeWprD9vaTYlANzAPxE+uka/3q0/EmSv
qKU4wj9f/nTIOSSwP1hZoa/w8cQ/DL2kEu6Nsj/v21QKohrFPz2QvGT6sbI/
hl4IZVNDxT9vY9S2BtayP7Njbxq2lMU/0QkEWx8esz8Obj2FezfGP5dWY6NQ
rrM/xYLZWgZ9xz8i8CE0s860P1wFjbW3pcc/VMM5hr/ytD/yh0AQac7HP4WW
UdjLFrU/II2nxcsfyD/oPIF85F61P7cPWyB9SMg/GRCZzvCCtT9Okg57LnHI
P0vjsCD9prU/fJd1MJHCyD+uieDEFe+1PxMaKYtC68g/4Fz4FiITtj+qnNzl
8xPJPxEwEGkuN7Y/QB+QQKU8yT9CAyi7Olu2P9ehQ5tWZck/dNY/DUd/tj+Q
O0vYzW/JP290knuMiLY/uakNdg==
                "]], 
               
               Line[{{0.20127551020408163`, 0.08962903730487083}, {
                0.2033724813112215, 0.09134376665994261}, {
                0.20461432671651483`, 0.09235924501520804}, {
                0.20585617212180818`, 0.09337472337047346}, {
                0.20833986293239484`, 0.0954056800810043}, {
                0.2133072445535682, 0.09946759350206598}, {0.2232420077959149,
                 0.10759142034418935`}, {0.24311153428060836`, 
                0.12383907402843614`}, {0.2443290196086536, 
                0.12483463272939306`}, {0.24554650493669883`, 
                0.12583019143034996`}, {0.24798147559278932`, 
                0.12782130883226384`}, {0.2528514169049703, 
                0.13180354363609156`}, {0.2625912995293323, 
                0.13976801324374702`}, {0.28207106477805627`, 
                0.15569695245905793`}, {0.3210305952755042, 
                0.18755483088967972`}, {0.3987244897959184, 
                0.25108646525049544`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T8bEorlZjXQPxe0Ed4B
Ad8/cUe2FmXs1D9cjPtU5BbfP+Hl8hbI/9Q/omTly8Ys3z9ThC8XKxPVPywV
ubmLWN8/NMGoF/E51T9CdmCVFbDfP/g6mxh9h9U/NpxXppQv4D9/LoAalSLW
P2Fepl2o3uA/jRVKHsVY1z+EShuZmengP/+zhh4obNc/pjaQ1Ir04D9uUsMe
i3/XP+wOekttCuE/Uo88H1Gm1z92v005MjbhPxQJLyDd89c/jCD1FLyN4T+c
/BMi9Y7YP7biQ8zPPOI/qePdJSXF2T/WSIHxjUfiP8g3KKMt2Nk/9q6+FkxS
4j/mi3IgNuvZPzd7OWHIZ+I/JTQHG0cR2j+4Ey/2wJLiP6GEMBBpXdo/uUQa
ILLo4j+XJYP6rPXaP7Cb30LAKOM/fIPR5Cln2z+kl56b
                "]], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z+MwYpuNIfbP9wMLplS
n+M/XDGvLaoF3D/8cmu+EKrjP14MA9iSE9w/PT/mCI2/4z9lwqosZC/cP77X
252F6uM/cS761QZn3D+/CMfHdkDkP4cGmShM1tw/wmqdG1ns5D+1ttbN1rTd
P/UmPQ+tbec/F32V2JZ54D8+4kLHinjnPwijNp6fgOA/hp1If2iD5z/5yNdj
qIfgPxYUVO8jmec/2hQa77mV4D82AWvPmsTnP52sngXdseA/eNuYj4gb6D8k
3KcyI+rgP/yP9A9kyeg/MTu6jK9a4T9ES/rHQdToPyJhW1K4YeE/jAYAgB/f
6D8Sh/wXwWjhPx19C/Da9Og/9NI+o9J24T8+aiLQUSDpP7hqw7n1kuE/hiUo
iC8r6T+pkGR//pnhP87gLUANNuk/mbYFRQeh4T9eVzmwyEvpP3sCSNAYr+E/
f0RQkD936T8+mszmO8vhP8j/VUgdguk/L8BtrETS4T8Qu1sA+4zpPyDmDnJN
2eE/FwJGqSaP6T9HBT0otdrhP9TPy1k=
                "]], 
               
               Line[{{0.8012755102040817, 0.5593383861210584}, {
                0.8024388112602567, 0.5598536472362295}, {0.8037652381656297, 
                0.5604411617087968}, {0.8064180919763757, 
                0.5616161906539313}, {0.8170295072193599, 
                0.5663163064344694}, {0.8182677985372807, 
                0.5668647829977733}, {0.8195060898552016, 
                0.5674132595610774}, {0.8219826724910432, 
                0.5685102126876852}, {0.8269358377627265, 
                0.570704118940901}, {0.8368421683060933, 
                0.5750919314473326}, {0.8566548293928267, 
                0.5838675564601957}, {0.8962801515662935, 
                0.6014188064859222}, {0.9739717509693491, 
                0.6358307585213471}, {0.9987244897959183, 
                0.6467944929249383}}], 
               
               Line[{{1.0012755102040816`, 0.6479135521329485}, {
                1.1369227129030104`, 0.7068403608011373}, {
                1.1382548904425511`, 0.7074190750644813}, {
                1.1395870679820916`, 0.7079977893278251}, {1.142251423061173, 
                0.709155217854513}, {1.147580133219336, 0.7114700749078887}, {
                1.158237553535662, 0.7160997890146401}, {1.1795523941683133`, 
                0.7253592172281429}, {1.180884571707854, 
                0.7259379314914868}, {1.1822167492473947`, 
                0.7265166457548307}, {1.1848811043264762`, 
                0.7276740742815185}, {1.190209814484639, 0.7299889313348942}, 
                {1.1915419920241797`, 0.7305676455982382}, {
                1.1928741695637202`, 0.7311463598615819}, {
                1.1955385246428016`, 0.7323037883882698}, {
                1.1968707021823424`, 0.7328825026516138}, {1.198202879721883, 
                0.7334612169149577}, {1.1987244897959184`, 
                0.7336878107290616}}], 
               Line[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAA9P5cq2w48z9QqsAjHYLnP8FddHM1
PPM/tn8dSG+E5z+MzSNXqkHzP+dLIfrHh+c/Iq2CHpRM8z9K5CheeY7nP01s
QK1nYvM/EBU4Jtyb5z+k6rvKDo7zP5t2Vrahtuc/bpdPI2qT8z9mGP+96rnn
PzdE43vFmPM/MLqnxTO95z/KnQotfKPzP8X9+NTFw+c/8VBZj+m48z/whJvz
6dDnPz639lPE4/M/RJPgMDLr5z/ZgzHdeTn0P+6vaqvCH+g/Dh2n7+Tk9D9C
6X6g44joP0BWg93j6fQ/OLuM+vOL6D9yj1/L4u70Py2NmlQEj+g/1gEYp+D4
9D8ZMbYIJZXoP57miF7cDPU/73jtcGah6D8usGrN0zT1P50IXEHpueg/TUMu
q8KE9T/3Jzni7uroP358CpnBifU/7PlGPP/t6D+wteaGwI71P+LLVJYP8eg/
FCifYr6Y9T/Nb3BKMPfoP9wMEBq6rPU/pLensnED6T9s1vGIsdT1P1FHFoP0
G+k/jGm1ZqAk9j+sZvMj+kzpP+pArYgLKvY/F1kl2kxQ6T9HGKWqdi/2P4JL
V5CfU+k/AseU7kw69j9YMLv8RFrpP3kkdHb5T/Y/BfqC1Y9n6T/W+2uYZFX2
P2/stIviauk/NNNjus9a9j/b3uZBNW7pP5KqW9w6YPY/RtEY+Idx6T+lmjzu
LGH2P45WeW0ccuk/REYgqA==
                "]], 
               
               Line[{{1.4012755102040815`, 0.795831450126899}, {
                1.4024622524621388`, 0.7960740550178137}, {
                1.4051079980981398`, 0.796614922950216}, {1.4064308709161404`,
                 0.796885356916417}, {1.407753743734141, 
                0.7971557908826182}, {1.410399489370142, 
                0.7976966588150205}, {1.415690980642144, 0.798778394679825}, {
                1.426273963186148, 0.800941866409434}, {1.4686058933621644`, 
                0.80959575332787}, {1.547629076117258, 0.8257504073834258}, {
                1.5987244897959185`, 0.8361958071133052}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T/IivV08cXqP/tq1Jsp
evs/lmo57Mxf6z9UNl2RLn/7PyAYhdZsYes/rAHmhjOE+z+qxdDADGPrP16Y
93E9jvs/vyBolUxm6z/BxRpIUaL7P+fWlj7MbOs/hyBh9HjK+z85Q/SQy3nr
PxPW7UzIGvw/3BuvNcqT6z9soXZCzR/8P2bJ+h9qles/xGz/N9Ik/D/wdkYK
CpfrP3YDESPcLvw/BdLd3kma6z/ZMDT570L8Py6IDIjJoOs/n4t6pRdr/D9/
9GnayK3rP/hWA5sccPw/CaK1xGiv6z9QIoyQIXX8P5NPAa8Ises/Armdeyt/
/D+oqpiDSLTrP2XmwFE/k/w/0WDHLMi66z8rQQf+Zrv8PyLNJH/Hx+s/sKqr
J9jA/D8HGmdvisnrPzQUUFFJxvw/7GapX03L6z8MAaNUk8f8P+lzMzG4y+s/
r4axqQ==
                "]], 
               
               Line[{{1.8012755102040816`, 0.8689766366512534}, {
                1.8023956352454178`, 0.8691102120394877}, {
                1.8037242586975861`, 0.869268650952012}, {1.8063815056019226`,
                 0.8695855287770606}, {1.8170104932192683`, 
                0.8708530400772552}, {1.8382684684539596`, 
                0.8733880626776442}, {1.8807844189233422`, 
                0.8784581078784224}, {1.9601756422651684`, 
                0.8879255450742108}, {1.9987244897959184`, 
                0.8925225115599903}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBqlCezTZLsPxMP8AjE
+gBAe0RFwAki7T/SvYqHSf0AQBlmzqF/I+0/kmwlBs//AEC4h1eD9STtPxLK
WgPaBAFA9cppRuEn7T8ShcX97w4BQHBRjsy4Le0/EPua8hsjAUBlXtfYZznt
PwznRdxzSwFAT3hp8cVQ7T/MleBa+U0BQO2Z8tI7Uu0/jER72X5QAUCMu3u0
sVPtPwuisNaJVQFAyf6Nd51W7T8KXRvRn18BQEOFsv10XO0/CNPwxctzAUA4
kvsJJGjtP8iBi0RRdgFA17OE65lp7T+IMCbD1ngBQHbVDc0Pa+0/B45bwOF9
AUCzGCCQ+23tPwZJxrr3hwFALZ9EFtNz7T/G92A5fYoBQMzAzfdIde0/hqb7
twKNAUBq4lbZvnbtPwUEMbUNkgFApyVpnKp57T/Essszk5QBQEVH8n0ge+0/
ubOE3fyWAUCHV6JAhnztP7BTqV8=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUBVgUc6BH/tP9o8REjf
ngFAbo0gcAOA7T+vuuzgmqEBQCJgPKMJge0/WrY9EhKnAUCLBXQJFoPtP7Gt
33QAsgFAXVDj1S6H7T9enCM63ccBQADmwW5gj+0/uHmrxJbzAUBGEX+gw5/t
P2s0u9kJSwJA0Wf5A4rA7T/A0NWsuE0CQOZCsm2Lwe0/FW3wf2dQAkD7HWvX
jMLtP7+lJSbFVQJAJdTcqo/E7T8TF5BygGACQHlAwFGVyO0/u/lkC/d1AkAh
GYefoNDtPwu/Dj3koAJAcMoUO7fg7T9gWykQk6MCQIWlzaS44e0/tfdD40Gm
AkCagIYOuuLtP18weYmfqwJAxDb44bzk7T+zoePVWrYCQBej24jC6O0/W4S4
btHLAkC/e6LWzfDtP6tJYqC+9gJADi0wcuQA7j80LCE+P/kCQIaBa4rUAe4/
vg7g27/7AkD+1aaixALuP9DTXRfBAANA7H4d06QE7j/0XVmOwwoDQMrQCjRl
CO4/fUAYLEQNA0BBJUZMVQnuPwYj18nEDwNAuXmBZEUK7j8Z6FQFxhQDQKgi
+JQlDO4/PnJQfMgeA0CGdOX15Q/uP8dUDxpJIQNA/cggDtYQ7j9QN863ySMD
QHQdXCbGEe4/YvxL88ooA0BjxtJWphPuP+veCpFLKwNA2xoOb5YU7j90wcku
zC0DQFJvSYeGFe4//qOIzEwwA0DKw4SfdhbuP1JNHneWMANAaNJ4O5IW7j/P
zwF+
                "]], 
               Line[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAFBlI7881A0C2SPVbLBjuP6wQQ+HP
PANAcnFbvdcZ7j/Qmj5Y0kYDQFzrw+M6HO4/WX399VJJA0DWCV6t0xzuP+Jf
vJPTSwNAUSj4dmwd7j/0JDrP1FADQEZlLAqeHu4/Ga81RtdaA0Aw35QwASHu
P2LDLDTcbgNABNNlfccl7j/16xoQ5pYDQK26BxdUL+4/lJ3nx5yZA0AGw+HH
+S/uPzNPtH9TnANAXsu7eJ8w7j9xsk3vwKEDQA/cb9rqMe4/7XiAzpusA0Bx
/dedgTTuP+UF5oxRwgNANUCoJK857j/VH7EJve0DQL7FSDIKRO4/tVNHA5RE
BEDO0IlNwFjuP4hLuIUcRwRA2fcT+VpZ7j9cQykIpUkEQOUenqT1We4/AjML
DbZOBED8bLL7KlvuP04SzxbYWARAKgnbqZVd7j/o0FYqHG0EQIdBLAZrYu4/
Gk5mUaSVBEA/ss6+FWzuP+1F19MsmARAS9lYarBs7j/APUhWtZoEQFYA4xVL
be4/Zi0qW8afBEBtTvdsgG7uP7MM7mToqQRAnOofG+tw7j+GBF/ncKwEQKcR
qsaFce4/WvzPafmuBECzODRyIHLuPwDssW4KtARAyoZIyVVz7j9My3V4LL4E
QPgicXfAde4/H8Pm+rTABEAESvsiW3buP/K6V309wwRAD3GFzvV27j+ZqjmC
TsgEQCa/mSUreO4/7Oa3EDDKBEDBTaD/nXjuPzRc+ww=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAArrLhiGnPBED18Z1qr3nuP4x535CB
1wRAXFsuZxB77j8yacGVktwEQEjcPFzte+4/f0iFn7TmBEAg3llGp33uP9Je
aFww6QRACK7ikxN+7j8kdUsZrOsEQO99a+F/fu4/yqERk6PwBEC/HX18WH/u
PxT7nYaS+gRAXV2gsgmB7j+orbZtcA4FQJvc5h5shO4/0BLoOyw2BUAW23P3
MIvuPyHdStijhQVADNiNqLqY7j+KwjuvVYgFQJJzjS0wme4/8qcshgeLBUAY
D42ypZnuP8JyDjRrkAVAJEaMvJCa7j9kCNKPMpsFQD20itBmnO4/qDNZR8Gw
BUBvkIf4EqDuPy6KZ7be2wVA00iBSGun7j+Wb1iNkN4FQFnkgM3gp+4//1RJ
ZELhBUDff4BSVqjuP9AfKxKm5gVA7LZ/XEGp7j9xte5tbfEFQAUlfnAXq+4/
tOB1JfwGBkA2AXuYw67uPzo3hJQZMgZAmrl06Bu27j/WYhk2nTQGQHxGO46J
tu4/c46u1yA3BkBd0wE097buP6zl2BooPAZAIO2Of9K37j8elC2hNkYGQKYg
qRaJue4/ur/CQrpIBkCIrW+89rnuP1frV+Q9SwZAaTo2YmS67j+QQoInRVAG
QCxUw60/u+4/AvHWrVNaBkCzh91E9rzuP54cbE/XXAZAlBSk6mO97j87SAHx
Wl8GQHahapDRve4/2HOWkt5hBkBXLjE2P77uP4WAUarJYwZA/tCF35K+7j+w
YAqM
                "]], 
               Line[CompressedData["
1:eJwV0H0s1HEcB/Ajvt+S0Dop7BRNTsVEtZvq99l6kodCKjpkch4qXDglPV4r
FTZ5qky1KeG6RZ4m6kTqcB6W6/RoO7Uc0a8kDxXWpz8+e+/1x3t777M8PN5f
pM/hcJzw/ucO71TbOTEEltw1yLNqZJkBn3P14jgC6cNnvnmipSnmwb/EBHhx
iR/C0DbFspnjiQQqf0S1JaMDp1/D2RME3o37FhehVTK+MlNKYCXHLuQPOrpX
Eb3wIoEGqYWX2TOWMdAPMMpLI7DL0Fhgj94cdManMIOAxGic64+uoGq1LJ/A
c66yowydG3FKq5QROMg/sjGoiWWCed2/9dQErvtXWdU1s4zJ0oSaBg0Bz4iM
/m500yLzY5K3BGYlohId2n6ecHCwj0DETQtXi+cs831soLd7kICLNtUzGS1t
m626NUtAFbs1xa2FZUqTnOIEjhRmL2t6K16wzIH4V/yx1RQeFTwsbEUvOJz0
Re5MQSRPC9eiEw7WBy9bR0HVLWBNX7KMu+d2LwoUbiy+bRiP7rIJddDspbD2
XqTbGiXLjLdnfhKfx37j5LWyVpb5OF8TPX2BQkvUi5ZGdLO39fe0SxTszHIm
NeisLtnf2+kU+sOcQvTbWMaxR8ntzKMQqi9yEKJD3+nt4Mso7NvWozBuZ5mt
ljs7q+UUar7dGbVFrxJm7YFyCub5sSsE6KmPvLD91RTUA3OvitDZWveUiwoK
uy8zexXolzrJg/4eCh4q+XC8imXkDk9dYjUUShJP8i6hc2IM6qbeUCDWHn6F
6LDh7BbTPtx/9HNtK/oPW963SUcBTCylyztYRus8eahtiMKdWl31BrRSvPlr
wAj+N7RG54PO/dkxcWSUwtNyX5+T6FRX7unJMQrWgbxzWejwJOGcCxMUUjkj
lffRHjVFV0x+U3hf+vjLE7TzxJBpwV8KAr+0JWq0jeXwlkMzFJauj5R/Qv8D
uclrpA==
                "]], 
               Line[CompressedData["
1:eJwVx3tIk1EcgOG1lM6xpZFNqVjklSWlFkotL+dHqaiVq22UFZjashJLhiO1
MWwyK+3udWARiEESsjIvNRKh2Z3GN0tJ1Mlai9Jx1tRNtLJOf7y8PGGFpbKT
fB6PF876f7tz7fM7fAQXQ1dzKR8oebQrxyhHCA6rlx35yNyiaUqcDECgPlvs
EVooUf6J2O0LQmA8nhzeymzwy1PLIhEYxHqnkaNk6URoojUawVabKc7DrDRz
XulmBC8aPJXbrZTEV+8p3x+LYHopL7CH+c1f8YXMnQhShyU7TEOUzC/OVqXu
Q+DQua8MfqLkkKf2aowaQezY0S2jnykJtvW08QcRmK9vK+PbKbkh0Gr7XiHo
+ylMz2IOSErLLXmL4KF8MeQWM98wtGrEgqB+ndkk+kLJzEF3RccogoL7Cr7E
QQn3Uiw94EbA6y+/Xeqk5Fpn66+76zEku/qN4z8oQeOFIzIRhnhpmy5iihJ9
QMzjFZswRHZdkhcza049LVJFYRBUSOfnmYvDhq1p8RjGlttTg12UZDYFPphO
x1C5wc+SRSnx1+oUEhWG3uxsV+8MJd0e18JAGYZOlcB/gVlZlHsv4zyGdoNF
lDRLyaA0bkquwdDwTSYdYNaHT1Sdq8Ggqj7W9XqOkoSWzCjvZQynO0TvsZeS
ryu732nqMORzk469zGneOmHtTQw5G5VCjnnujM8UVI8hIz06do2PknZbQX5z
I4aUku8ZCuZnT/QTv5sx1HAJIQ3M/wCZOgaY
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPFzVvl9f1viOBdO1LJrobNK/+DzuZNUlIeI4q66zR/yNOeh
R0Wai9HmodMu0rLoPC4ZGjt1nYcWwkLZ2npARu7brCah+vXHe++93FSpEfF8
Ho8n4fr/K9ebo3wqGdx4U0Gzls1g0s2ioYZBvfugQb5ihrzk8ol3TQxa+n18
1LBqBr7gu8VmI4MdCVYZ2TwKrZrYunITg8dTh5ocLCio1vpCnPoZnM4o/fqE
s3GmqkIyyKBNjnPsLJ/Cjc5gz4AJBpO0UnnoBgoWyrqYi/MMur6M2eJGKPD0
ypbPtgQLnPWNJgGFvm+TKdX2BNfZ5qFEOwpF0nCvOBFB9Wqr2daegkNnQNO4
mGDsVLf0nJCCV7+kYUBC0PPuSNu6iELczFJtsz/BUcGvbh8XCs/cNPcvnye4
lQ0aeiyhcC2epzyQTPD272Bz6C4KB/WXxD9SCfLnw6yXOY9IkyqTMwkuDJwO
D9xNYQ7CdWdzCBryU8Y/eVIQKp20h7QEVXztB8e9FNS6lmJbI8H6lenFIj8K
HWs6jdFEsDB4m6W3P4U1ZX6uup9gYtUp0ThnzQ5F5tggQQ/ZsFyMFCobiaJ0
kmDzrY6KJjmFXkO8h+0iwVaHQtlwEAXiFu5upATLEkwn1YcphOX5uqqXCKZ3
/UkUHqEwFSSwG1smuO9MulZ5lIJ55PlqCZ/F9tq4BXMIBdEXp9c2Iha79u+5
Yx1BQRG4qfeFI4v3NAn1Tzk/rFsypIlZvPq+pif6BAWPpFeto9tZ9MsWzVdH
UkgbbmvM3cmi+E3E34AoCu3SB7XeEhb/uBbbzXGW/czSlXiy2GOyAGk0hfxo
VblMymK10DfyLeeIYy4XtJxtCqzK5jj/A6OOIC0=
                "]], 
               Line[CompressedData["
1:eJwVzH0s1HEcB/BfHqJ9v8XldtxtknajcO2aCXfs91FpYmkoneN0Hq64GufU
5lmuNGzyFBoVWcjSyu7Uap2H6KIyD6VUphsVV+o3pWis+vrjvfdee29v5/jU
cIUZRVFuJGvN5gYxw14IPoTEvLsmYejIPL4mzAdBdmXsPR1xvdEmZ50YQc9j
R9cXxMY9K2c6/BFY/pysnSFWWo0ls/YiuBgRnbk5iqHvJOsTegMRjJ3jfdlB
vPj8piwtCIG97q00gDi/PD9s9CCCRrbET0V8iSvwrZAg0I4f/jdErHcvsmal
IJg4GlpYLGXo3a/shypVCAa3mCU0EN/Naa1gpyN48KkTOombhgw8hwwEdemO
q0biolRLgZMGQUzZvNonmqHDtZowQQ0Co6FEPks8K8qtO9CFYM7rqThQxtCs
YLWHZhOGP3bwg5IzdGOvDRKxMGxQTrQ6EAt9b5sW7DBwe1QyIXHo9rmWOC4G
0anrA8eIS9bHOgfwMWT1mzV0EVv0HeBQIgyrp5+E5MQx9G+xM5WnwEC9Dm5e
imfoQm3XlFcSBluPGalNAkOz3WP035QYtmqybV2JPXm1WTIVhoCd7dmRxKpl
/MsvG0PBhY3hncQm3bJppRyDuffIX3UiQ2d41AxoqzDYlSbpSoitb3i2nqzB
wJ+hlE3ELlUpie/rMewr2zU+Shyf9nHqYQuGwtnKW0IFQy/MFejVbRiq/d3j
gojPyp2uuLVjaK7q48iJGw5Jo+o6MBjoxYIy4knByMvMRxisLh+RfF/bv7Jy
zbsx9J2fzrI4Tv7bIlxKezHkp6Ve5RG7nKge5vRjEMeudguJTfw3GY0GDEvB
xdP7idunHba5DWLQenMsZcTzn+/bCp9hME7pFxTE/wEObCxj
                "]], 
               Line[CompressedData["
1:eJwV0FtI01EcB/CZNW//c3TOQmoZiWijXJDig5HnJ0ZqSbQRmJeUTXNequUt
0zbTyUzMLBAvCJoPWWgy3SwTjTJTlySo5QUUtXRqXtYpRjDJtNPDly+fx+/3
qEIlu7aHx+P5svxvvfFbWdooB+F9yv3vUyjR1MpvzUxy0Dod0JSmpGSvcLnf
MsOBMLlY9YNZ4Lyp9FjmwKwWYVsqJRMmf0HjKgeeYR9yg9MoqdOpevzWOYhy
Sp9TM3vZWbnTlINX1a/b7NIpOWHbMsi3OCjVyy64ZFBybsVhW48Q+H0tK/O6
QUlHI/ExJyBofybXZORSYi2wOsjlCOLEUzVtzEHRzzfmkhDw2853WJh7XV07
p1MRJBgCllS3KRkqmg/9lIWAe7MvMiePklmFJtFYiiB9vMVDk08J36+3vkiP
wGf714tKDSWR9qrCvx0IxgpTBkeZKxa8FQWdCNR2s/NuhWxvXbk4pxvBF/6A
oIpZ5BTbrexHoBXU5NXeo+TUhm3y4hSCBd/gsKZiSq62BwkO7yCol2pnDDpK
umJteIyHobn46V0bM+b3cCX2GNoNQyJSSklf/BnHNUcMgwKXxBFmb+ezuy+F
GH6OVy2t3KdkJVlqiRJjCJc1bx4qpyTETbixexyDVGt6qGCu7Z34bpRgiDeu
SVqYI9yvmD0DMWS5SzKDHlDS+i5h1hyCoeFz1+9LFZTcPHh9WH0Zg1X2cUdX
yf4a9DedjMawo11/MsJ8JJMOLMZgcOrkQoWPKLkjMvRXx2PwWJIsxjCPmbL6
IhIxeAmlJU3Mx7ID3/6RYxCHZfusMuuKpK3DSRii8iviDjym5B8orhzX
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPHraES+X6n5S3LXkrPR0xLd1u+zZpflodwaG+mkh2FkN7UU
eZoz41fn4ZSHc0uHneSpOzK7TWtRKWsccTKUTVld35KmpaNPf7z33kuUlCG/
JBQIBHux/z8RkS12SCFgjAvKU5YzrtRH2vMijYCwpvhsJXrh9d/HNzMIxNsr
PrWiNeL8jvmrBNxeGuxT6NW3xc2P8ggoE95JjlQw7nR2mF5RSGD42QdTFNrg
69LooSKw28/GXUbH3bqtzSolML7sEFONNvtrqkKrCQSXHCj8ic5XNRbMPCQg
MPLTnZWMc7vudPJ8OwHHTn5sEF2XnO6x2ElgSxs//B5tDA/RMxOB7Xq+36mK
cYvbRp8LBwj4VvF1CnS4TuAssRCIyOTjqIZxnk8Ud66tEag9xE9fqWZc++ed
9SSCwkFT2XRADeNKGlSJs1EUet11iTL0RbltT0c0hZD0rsVzaC+zuSsylgL4
Tiyr0aXq+CE+iUJkjbfrMjo5qPaHyw0KyTnd0t5axomLdoQ5tVBoCJ3UHqtn
3HpwjtukgYKocUkci7baFsZa2ig02dcMGejyWGOCrJtCW69Pz330hr88U2Wm
0OeXOiLUMm5mVK1zsFCwbLXbh9B9xasXLBMUYlJo0RxaI1VI9FMUrIMil9/o
8OZA0/FZCvO5Mk9JA+P6s0ZeFSxR+PZdHViGvhtwWB39lYIy8oFJj1Z+1J4R
MQorraajZrRfRNrc0xUKa0lWmQ3tuGm8qXyVQu7AlzebdYyb75GmJv6hIPRa
l3ujzan6ffvtFFRZ7tYg9L1drr82Nig4T4gVp9D/AHjKL7A=
                "]]}, 
              "Charting`Private`Tag$69610#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {0, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, 
           PlotRange -> {{0., 3.999999918367347}, {0., 0.989690719966337}}, 
           PlotRangeClipping -> True, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.8580523153530693`*^9},
 CellLabel->
  "Out[304]=",ExpressionUUID->"a9709692-6ea8-4c8b-bab1-3ff80617094f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6JFb0zeulJPgRDGnDf
GVQ/yYtggvHEJz8zn5icsxlkP08kbK+9xDc/S83Xsp0ZdD+S8PHFo8RHP1dk
972SGYQ/tNY00ZbEVz/dL4dDjRmUP8VJ1laQxGc/oBVPhooZpD9NA6cZjcR3
P4EIsyeJGbQ/EWAPe4vEhz8qR5GIsnC0Pxn8ItScK4g/0oVv6dvHtD8gmDYt
rpKIPyQDLKsudrU/MdBd39BgiT/G/aQu1NK2P1BArEMW/Yo/DPOWNR+MuT+Q
IEkMoTWOP5jdekO1/r4/iHDBTltTkj9BHFmk3lW/P4w+S/vjhpI/6lo3BQit
vz+QDNWnbLqSPx7seWOtLcA/majoAH4hkz9vaTYlANzAP6jgD7Og75M/EmSv
qKU4wj/IUF4X5ouVP1hZoa/w8cQ/CDH733DEmD/v21QKohrFPySE8UqP9Jg/
hl4IZVNDxT8/1+e1rSSZP7Njbxq2lMU/dn3Ui+qEmT8Obj2FezfGP+PJrTdk
RZo/pfDw3yxgxj//HKSignWaPzxzpDreiMY/GnCaDaGlmj9qeAvwQNrGP1EW
h+PdBZs/xYLZWgZ9xz+/YmCPV8abP1wFjbW3pcc/2rVW+nX2mz/yh0AQac7H
P/UITWWUJpw/II2nxcsfyD8srzk70YacP7cPWyB9SMg/SAIwpu+2nD9Okg57
LnHIP2NVJhEO55w/fJd1MJHCyD+b+xLnSkedPxMaKYtC68g/tk4JUml3nT+q
nNzl8xPJP9Kh/7yHp50/QB+QQKU8yT/s9PUnptedP9ehQ5tWZck/CEjsksQH
nj+QO0vYzW/JP1SWJb8kFJ4/fHYsKw==
                "]], 
               LineBox[{{0.20127551020408163`, 0.030642700513974767`}, {
                0.2033724813112215, 0.03241898644327459}, {
                0.20461432671651483`, 0.03347091916293751}, {
                0.20585617212180818`, 0.03452285188260044}, {
                0.20833986293239484`, 0.036626717321926267`}, {
                0.2133072445535682, 0.04083444820057794}, {0.2232420077959149,
                 0.0492499099578813}, {0.24311153428060836`, 
                0.06608083347248803}, {0.2443290196086536, 
                0.06711213144792147}, {0.24554650493669883`, 
                0.06814342942335488}, {0.24798147559278932`, 
                0.07020602537422177}, {0.2528514169049703, 
                0.07433121727595551}, {0.2625912995293323, 
                0.08258160107942303}, {0.28207106477805627`, 
                0.09908236868635806}, {0.3210305952755042, 
                0.13208390390022812`}, {0.3987244897959184, 
                0.19789624206703718`}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T/Z7IDfUp7JPxe0Ed4B
Ad8/nDvjvkGu0T9cjPtU5BbfP8RpFqRJwtE/omTly8Ys3z/sl0mJUdbRPywV
ubmLWN8/PPSvU2H+0T9CdmCVFbDfP9ysfOiATtI/NpxXppQv4D8aHhYSwO7S
P2Fepl2o3uA/mQBJZT4v1D+EShuZmengP8IufEpGQ9Q/pjaQ1Ir04D/oXK8v
TlfUP+wOekttCuE/ObkV+l1/1D92v005MjbhP9hx4o59z9Q/jCD1FLyN4T8Y
43u4vG/VP7biQ8zPPOI/lcWuCzuw1j/WSIHxjUfiP4BvFmzlw9Y/9q6+FkxS
4j9sGX7Mj9fWPzd7OWHIZ+I/Rm1NjeT+1j+4Ey/2wJLiP/YU7A6OTdc/uUQa
ILLo4j9WZCkS4erXP7Cb30LAKOM/nMn3QiNg2D9JrqZG
                "]], 
               LineBox[{{0.6012755102040817, 0.382887279414324}, {
                0.61319856565424, 0.39085179911525414`}, {0.6145099372039051, 
                0.39172778636417765`}, {0.6171326803032354, 
                0.3934797608620248}, {0.6223781665018959, 
                0.39698370985771897`}, {0.6328691388992168, 
                0.4039916078491073}, {0.6538510836938587, 
                0.418007403831884}, {0.732138185275487, 
                0.47030265360926504`}, {0.7987244897959184, 
                0.5147818507732825}}], 
               LineBox[{{0.8012755102040817, 0.5163445139283683}, {
                0.8962801515662935, 0.5692748996787763}, {0.9739717509693491, 
                0.6125595883740546}, {0.9987244897959183, 
                0.6263501989766912}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D9r7D9yohXkP+v3397V
MPI/vpjMxgUP5j+2Z4/CSjbyP15Q4GX8E+Y/gNc+pr878j/9B/QE8xjmPxa3
nW2pRvI/PXcbQ+Ai5j9Cdlv8fFzyP71Var+6NuY/mvTWGSSI8j++Egi4b17m
P2Vkhv2YjfI/XsobV2Zj5j8w1DXhDZPyP/6BL/ZcaOY/xrOUqPed8j8+8VY0
SnLmP/FyUjfLs/I/vc+lsCSG5j9I8c1Uct/yP7yMQ6nZreY/E2F9OOfk8j9d
RFdI0LLmP97QLBxc6vI//ftq58a35j90sIvjRfXyPz1rkiW0weY/n29JchkL
8z+8SeGhjtXmP2rf+FWOEPM/XAH1QIXa5j80T6g5AxbzP/u4COB73+Y/yi4H
Ae0g8z87KDAeaenmP5WetuRhJvM/3N9DvV/u5j9gDmbI1ivzP3yXV1xW8+Y/
cmcJu/kt8z/mv2DeR/XmP3HkvWE=
                "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA9P5cq2w48z/kXw1nCP3mP8FddHM1
PPM/99/JqjT/5j+MzSNXqkHzP664NL9WAuc/Iq2CHpRM8z8bagromgjnP01s
QK1nYvM/9cy1OSMV5z+k6rvKDo7zP6qSDN0zLuc/bpdPI2qT8z9KzsZGRzHn
PzdE43vFmPM/6gmBsFo05z/KnQotfKPzPyuB9YOBOuc/8VBZj+m48z+tb94q
z0bnPz639lPE4/M/sUyweGpf5z/ZgzHdeTn0P7kGVBShkOc/Dh2n7+Tk9D/I
eptLDvPnP0BWg93j6fQ/8ji9pOz15z9yj1/L4u70Px333v3K+Oc/1gEYp+D4
9D9ycyKwh/7nP57miF7cDPU/HWypFAEK6D8usGrN0zT1P3Ndt93zIOg/TUMu
q8KE9T8dQNNv2U7oP358CpnBifU/R/70yLdR6D+wteaGwI71P3K8FiKWVOg/
FCifYr6Y9T/HOFrUUlroP9wMEBq6rPU/cjHhOMxl6D9s1vGIsdT1P8ci7wG/
fOg/jGm1ZqAk9j9yBQuUpKroP+pArYgLKvY/RudLDsGt6D9HGKWqdi/2PxrJ
jIjdsOg/AseU7kw69j/CjA59FrfoP3kkdHb5T/Y/EhQSZojD6D+lmjzuLGH2
P2PlTtNozeg/tAj+mQ==
                "]], 
               LineBox[{{1.4012755102040815`, 0.7757197677251686}, {
                1.4064308709161404`, 0.7768481440038171}, {1.407753743734141, 
                0.7771376869457899}, {1.410399489370142, 
                0.7777167728297355}, {1.415690980642144, 
                0.7788749445976269}, {1.426273963186148, 
                0.7811912881334094}, {1.4686058933621644`, 
                0.7904566622765398}, {1.547629076117258, 
                0.8077528108613669}, {1.5987244897959185`, 
                0.8189362868512955}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T/0LsBxejnqP/tq1Jsp
evs/2fibVcUZ6z9UNl2RLn/7PxRBaacjHOs/rAHmhjOE+z9OiTb5gR7rP16Y
93E9jvs/wxnRnD4j6z/BxRpIUaL7P606BuS3LOs/hyBh9HjK+z+AfHByqj/r
PxPW7UzIGvw/KABFj49l6z9soXZCzR/8P2NIEuHtZ+s/xGz/N9Ik/D+dkN8y
TGrrP3YDESPcLvw/EiF61ghv6z/ZMDT570L8P/xBrx2CeOs/n4t6pRdr/D/Q
gxmsdIvrP/hWA5sccPw/Cszm/dKN6z9QIoyQIXX8P0QUtE8xkOs/Armdeyt/
/D+5pE7z7ZTrP2XmwFE/k/w/o8WDOmee6z8rQQf+Zrv8P3cH7shZses/sKqr
J9jA/D/f9UYp67PrPzQUUFFJxvw/R+SfiXy26z8MAaNUk8f8P6ic10EYt+s/
scGs6w==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D8HYy1hbrvrP8BQPc6c
1vw/q1yYDBO96z9FuuH3Ddz8P0GWiAUGv+s/To0qS/Dm/D9sCWn368LrP3LZ
TZh5Ev0/G9bqvoPS6z+5cZQyjGn9P3dv7k2z8es/R6IhZ7EX/j8uovVrEjDs
PzSYDibGHP4/HZVWS+Qx7D8gjvvk2iH+PwuItyq2M+w/+nnVYgQs/j/obXnp
WTfsP61RiV5XQP4/ojn9ZqE+7D8TAfFV/Wj+PxbRBGIwTew/31/AREm6/j/+
/xNYTmrsP8xVrQNev/4/7PJ0NyBs7D+4S5rCcsT+P9vl1Rbybew/kjd0QJzO
/j+4y5fVlXHsP0UPKDzv4v4/cpcbU9147D+rvo8zlQv/P+YuI05sh+w/dx1f
IuFc/z/NXTJEiqTsP2JQMFbcYf8/XYmK/VKm7D9OgwGK12b/P+y04rYbqOw/
Jumj8c1w/z8MDJMpravsP9S06MC6hP8/SrrzDtCy7D8wTHJflKz/P8cWtdkV
wew/HH9Dk4+x/z9XQg2T3sLsPweyFMeKtv8/5m1lTKfE7D/eF7cugcD/PwXF
Fb84yOw/jOP7/W3U/z9Ec3akW8/sP3gWzTFp2f8/057OXSTR7D9jSZ5lZN7/
P2PKJhft0uw/Oq9AzVro/z+CIdeJftbsPybiEQFW7f8/Ek0vQ0fY7D8RFeM0
UfL/P6F4h/wP2uw//Ee0aEz3/z8wpN+12NvsPz801ofG+v8/TLbAgxfd7D8n
bypd
                "]], 
               LineBox[{{2.001275510204082, 0.902340441577427}, {
                2.0039562426140143`, 0.9025995231633784}, {2.008820753763886, 
                0.9030696578396025}, {2.0185497760636295`, 
                0.9040099271920506}, {2.0380078206631165`, 
                0.9058904658969471}, {2.0393271393937447`, 
                0.9060179725394751}, {2.0406464581243724`, 
                0.906145479182003}, {2.0432850955856283`, 
                0.9064004924670591}, {2.0485623705081406`, 
                0.9069105190371711}, {2.0591169203531647`, 
                0.9079305721773951}, {2.080226020043213, 
                0.9099706784578433}, {2.122444219423309, 
                0.9140508910187395}, {2.1987244897959184`, 
                0.9214230604123401}}], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUD8vGoRaH7tP2s0u9kJ
SwJAgAcQbfTH7T/A0NWsuE0CQH1NZV4Vye0/FW3wf2dQAkB7k7pPNsrtP7+l
JSbFVQJAdR9lMnjM7T8TF5BygGACQGk3uvf70O0/u/lkC/d1AkBRZ2SCA9rt
Pwu/Dj3koAJAIse4lxLs7T9gWykQk6MCQB8NDokz7e0/tfdD40GmAkAcU2N6
VO7tP18weYmfqwJAFt8NXZbw7T+zoePVWrYCQAr3YiIa9e0/W4S4btHLAkDz
Jg2tIf7tP6tJYqC+9gJAxIZhwjAQ7j80LCE+P/kCQAXULUM+Ee4/vg7g27/7
AkBHIfrDSxLuP9DTXRfBAANAybuSxWYU7j/0XVmOwwoDQM/ww8icGO4/fUAY
LEQNA0AQPpBJqhnuPwYj18nEDwNAUYtcyrca7j8Z6FQFxhQDQNUl9cvSHO4/
PnJQfMgeA0DaWibPCCHuP8dUDxpJIQNAHKjyTxYi7j9QN863ySMDQF31vtAj
I+4/YvxL88ooA0Dgj1fSPiXuP+veCpFLKwNAId0jU0wm7j90wckuzC0DQGIq
8NNZJ+4//qOIzEwwA0Ckd7xUZyjuP1JNHneWMANA4+1rUoYo7j+J688V
                "]], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAFBlI7881A0A8r+UjViruP6wQQ+HP
PANAY55hIT8s7j/Qmj5Y0kYDQF/juGH6Lu4/WX399VJJA0CetM4xqS/uP+Jf
vJPTSwNA3YXkAVgw7j/0JDrP1FADQFwoEKK1Me4/Ga81RtdaA0BZbWficDTu
P2LDLDTcbgNAUvcVY+c57j/16xoQ5pYDQEULc2TURO4/lJ3nx5yZA0B/Lvj3
kUXuPzNPtH9TnANAuVF9i09G7j9xsk3vwKEDQCyYh7LKR+4/7XiAzpusA0AU
JZwAwUruP+UF5oxRwgNA4j7FnK1Q7j/VH7EJve0DQH9yF9WGXO4/tVNHA5RE
BEC42btFOXTuP4hLuIUcRwRALCs7Pep07j9cQykIpUkEQKB8ujSbde4/AjML
DbZOBECIH7kj/XbuP04SzxbYWARAWGW2AcF57j/o0FYqHG0EQPjwsL1If+4/
Gk5mUaSVBEA3CKY1WIruP+zmtxAwygRA9M4d9K6Y7j+NE6fW
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArrLhiGnPBECL3U3o9ZnuPyR1Sxms
6wRAHkW5zRCg7j/KoRGTo/AEQLQFm3sjoe4/FPudhpL6BEDfhl7XSKPuP6it
tm1wDgVANonljpOn7j/QEug7LDYFQOSN8/0osO4/Id1K2KOFBUBAlw/cU8Hu
P4rCO69ViAVAx+0N4+jB7j/ypyyGB4sFQE5EDOp9wu4/wnIONGuQBUBb8Qj4
p8PuP2QI0o8ymwVAdUsCFPzF7j+oM1lHwbAFQKv/9Eukyu4/Lopntt7bBUAU
aNq79NPuP5ZvWI2Q3gVAm77YwonU7j//VElkQuEFQCIV18ke1e4/0B8rEqbm
BUAvwtPXSNbuP3G17m1t8QVASRzN85zY7j+04HUl/AYGQH7QvytF3e4/OjeE
lBkyBkDoOKWblebuP9ZiGTadNAZAB/QepyDn7j9zjq7XIDcGQCevmLKr5+4/
rOXYGig8BkBlJYzJwejuPx6ULaE2RgZA4xFz9+3q7j+6v8JCukgGQALN7AJ5
6+4/V+tX5D1LBkAhiGYOBOzuP5BCgidFUAZAYP5ZJRrt7j8C8datU1oGQN3q
QFNG7+4/nhxsT9dcBkD9pbpe0e/uPztIAfFaXwZAHGE0alzw7j/Yc5aS3mEG
QDscrnXn8O4/hYBRqsljBkCo9iSNUfHuP7df9G4=
                "]], LineBox[CompressedData["
1:eJwVx2tIk1EcgPF56RwrSCxHauHmpdqyEAusED1/MBuWZph0UQvRVRumrTRM
NGcO24c0bKmEiuAHiV4XC1xkwVZINCqXoW0hbTCTkjl7D7qLy2l1+vDw8Euq
vFZ8KVwgECSz/l9W0JQcoUSgnEvJzV7myc/C1leqWgQ+5z7HKnNbo7Dcp0KQ
cUT7tNjLE9Ewt95Qh6Cme7aFYz639gXUtxD8ON6bVOrjyUdOaulsQ2B/8ffy
Sz9PFHazIqYdwdZtpYdjAjyJDC/Z1KNFUFRr3KhkzjnfUjjQgcCSqtTHrfDk
GZ6e5noRjD2YWmoI8qRb3uyycAj6qoebM0M8KU+c/B02jeCC6IRuVECJ/0Pn
d9UdDK/3T5xpjaPEsdmmWNNgEOZ/y5phHi/YSbV3MVyVL4gPxFPS9YkLDd7D
EN8f5Zlj3jtlibX2YKiPylPLdlBycSZMJuUwSOZMj7ckUnI0Id9q1GNQ/5no
uMKcVtZ1GgwY7PGO62+Yg47EirNGDJpTq1k3RJToXFmN7WYMTlPmZ5uYknfz
N0dmpzDoHhmCAymU6CWmjBobBveo2elnfqiMHAt+xUAmreMnUymp8OjeRjsx
/Nqw2CHYRckqb3Bmz2OQ1UmS5LspcaWvVL13Yxi8fwiZmC2qnIWSRQy+J8c8
wj2UdC9PBKqXMAy55M8tzE0HY2+veDEEQ3V9YgkllfVlEZoAhqLtGnUjc3rA
Hd0XwrBWOJSfJqVElODJrVrHkOclI0rmf2eUCB8=
                "]], LineBox[CompressedData["
1:eJwVx1tMElAcgHGi2zmU+pDNra0ZmgVU4Eo2Fcf5l6iUFYWNbG1mitIVYlE2
mXM1m4rNloXSMtu0B2y1YkmZtS4T08oc4mJrCXmp1sp2ZgYEWnR6+Pbtxy8x
qMu4HA4nifX/45/jn7RyEUiexiRHhJTcy9x5twAhWJQbbtKLKGkxW6UfeQg6
nk8db2fW/kneEoxD4HeOJPPWUWJbUGRSr0bQbzHM2tdT8rc0QTq8BgFfIPR8
YNb2ugMqIQJz34Q9dgMlqeeyK3aIEYg5Go2JeSAqqFSmI7CeynIQMSWhyEy1
fDuC0mKs80oo0UzXN4hMCKLSDs/8TZQs8zvbuS4E6ePezqIMShqXVlU9fInA
nf9lyMrMkykKj71CcOhBYGaQmWvzxHiHENga4uWyTEp+7qZnOt8jCEvVngQZ
Je4+gWoXRfDY8jbizqLkwp1rs9dXYJCnufKzgRI0WuJVr8TgbRs5UclcwxM5
Fq/CoMeTVgezWdddbkzB0OafN5a4mZIj/HfDilQM0TpimmNWWmPt33MwvPD1
tDqzKVlYdXZPhhGDotbxY20eJV3TU+FnJzHsJaRsP7O2vPBG7mkMR0ODo43M
LpXkW4EZw2Xd1zcB5pokX7X+PIaJvMRbvUpK0lqUKYFaDMHobX6I+dOSrtdm
CwZed+ZV0VZKFAHL8vqLGDYKNHWXmH8dDvbENWHIGZuMuphv+g8WN1/BsM9m
rPjN/Oh+jW+uGYOhf+CAcBsl/wBo+vyj
                "]], LineBox[CompressedData["
1:eJwVx3lIk2EcwPG5EnmfFwu1zFKjKdUgtYl0QOXzE7XQtdwm2uE2xFhOc4qz
eS2vpA2yCcpasLxQUrxtXYo03VCXtMSkVCYo5G3ZU6KdBr398eXLh5OSJZaz
WSwWl+n/NSVdCSdrKLhabZzqiyV4yLQEliYKBsIt84N8gsuVhsnpTgoCc+Vj
HAHBbK+vLrtsFKwuPG2ajyPYrEtqMQxRYDNLZ88ICU7ZHrnoa6fgUanbfgNj
22LtQ66DAoFfUmWUiOA7vfzgyEkKeuLZBY/FBLvIWq7kr1GQZxNeSk0gmNUq
6/7oiWBnw/rPtWsEj3yeyqzfi8DpHfcgNong+zxRiMQHwRN9T2gb4329kZ0f
/BFINTnpaRKCQ+zc9tdcBM8Tf80sSwmWLG40d4UjSHV3HVhIJriPo6srTEcw
Wuh3d/YGwcVyluyUEkH9tyJOeCrBUa0F/ptZCNSKuVe1jMd5GTVKNQJOYuN3
iYLgFSwyJZciKAzlKmbSCPaW+RrPGxEcWwnjT2cQrDJ16z1tCCoT+B4TKoJf
bpt0tiEEDks1OZ5D8LZMW6ayI0Bc51s9Y12gVD3hQKD9rbgXc4vgmg4krZ5C
UFyv3WFVEzxskQd5riNQrlq3uvMJRhzRERtB0C6m3rsXECwsP3tItYFgtV9o
vsnYecFrz8QPBPLKucyjhQR/GR/8U8WmQRr2d7lOQ7DPvO8bDx8aBEWnnfpi
gqXRbsPWAzRULJX0fmLc2LJhyfanYTTObowpITgoY9T8LoCG6IDEeNdSgrPH
nnWUHaahvKI29DrjF7yG5lAuDdbNhd1WxhFbuaaqYBrO2XMct8sI1l5OMUTw
aNDw+tucjMWCg3lGxicazXiJ8T8Ebiw3
                "]], LineBox[CompressedData["
1:eJwVz30sFHAcx/GjlPn9xF2Xp7WcpstwS5OE7PdNs1xL61RmDRt1k7M4qk11
aBdFWIfruPM4tfOwWuxO7Ba61eiSpyhWZirhevqtQjf6o19/fPbZ68+3T2pW
nNSew+HsZvv/fM8YOhqC4M+pv9uzlJTE5/sqJQcQCGpMH3TMtXMuCrsIBP3H
ZscszHNR65c7IxEk29k/tTHLNr9O5x5GUCcTN8TfoORReu9ZczSCCO8L5UXM
y0OtSdkxCN5NqBRG5gJVgWQ8FoFH5PQZXiElak9RWEUCArVLmvsIc29AsSM3
E0GZsVAVfZOS/ZPuw5VyBKZlfUI2c4eipYJ/EcHiPougnrl5eMDLIxdBVJdz
5zJzcZaDyFuJwNalGb93i5I4g1Ii0iCQdrfy7EsoWQzP04n7EESaXqn7Sinh
Hs0JVG7B8KOfrw2toKTJ7ILCuRh0kzxeGnNQ2EPrz60YjlhdSzXMx/2W9Cme
GBp5znkrzLc3Jfsc8sVwQuqQYqikZOMzsRsnHEOn06rfHjUlqxE+nHwphkun
p3qE1ZQUGfpmQ85jEMje7I1n5gck9n6XYRjOn2gvYg72qr6aJMewq3W0bp5Z
bsMrB69heLs2eL25hhKr0WZdV2EIbeqJ2aGjJDdQ88JQheGT8bE5ltnxfnBL
hgaDymJkpZQIqzLPva/FsPSrI3CGOTV7ftakx6CNbnPV1VIyIxqbuPIEw9oX
7fS2ekoav3LzNvRjCCnV+Ecxp7adFJabMcgDqhSZzMK0u6NuzzG0D90Z0TFb
fadymwYwfM4oEwwyP/josdPfwvpwSc5v5m8L3a5BLzEsJDpJHBoo+QdYZiGf

                "]], 
               LineBox[{{3.601275510204082, 0.9880722755276076}, {
                3.6044205455572738`, 0.9880990950445477}, {
                3.6068988062055514`, 0.9881202285918611}, {3.611855327502106, 
                0.9881624956864878}, {3.6130944578262447`, 
                0.9881730624601445}, {3.6143335881503837`, 
                0.9881836292338011}, {3.616811848798661, 
                0.9882047627811145}, {3.621768370095216, 
                0.9882470298757411}, {3.6316814126883257`, 
                0.9883315640649945}, {3.6329205430124643`, 
                0.9883421308386512}, {3.634159673336603, 
                0.9883526976123078}, {3.6366379339848804`, 
                0.9883738311596212}, {3.641594455281435, 
                0.9884160982542478}, {3.651507497874545, 
                0.9885006324435012}, {3.6713335830607647`, 
                0.9886697008220079}, {3.749078878861765, 
                0.9893326794672694}, {3.798724489795918, 
                0.9897560360130411}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyecQ8DhI2GvNe/u1L2Rn8/nwOyTZru2d
u+29fcfc1oR7fvwOPs+/eO4D8lOC3qquC+R3MJ9ow3YfyJfZs2eDbzi/A+/T
03UK29/bd/VHH+tJ4nfY0fMqfzGQn2E28yNXJb8D/x31oJU73tsrtYh4sC/j
d9hbtUhs66739v8sanivr+B3WKHy6tJVIP/m28eXlq3md5h0zrD/G5A/IXxz
rNtGfocMpYPsFrvf2//XCipu3cPvIHzq/o9dQP6di/3zmC/zO2RJyt4+sOe9
/Y6278mXr/I7hB5Omf4QyJ9iHa+5+Aa/g0PummCmve/tvZfqbXG6x+8gdtD6
jDOQv6vi7MnGl/wOBzOi9h4D8qfpmvYHvuF3WCO0qPI5kF/4aE6I4nt+h+l7
Xppy7Htvr+GTc//AF36HHIHKdZ5APgvjlSUTvvM7hO86kJUF5D/Yap2V8Ivf
wSmFQ70byN+TtVjf4C+/gy5fwOPVQP50ee6v///zO0jsmD7/DJAPAKaAveY=

                "]]},
              Annotation[#, "Charting`Private`Tag$69811#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT5OMWgA2/ksPgRDGnDf
GVQ/P+RuvHWUCj8zn5icsxlkP2/juMg7lBo/S83Xsp0ZdD8H493OHpQqP1dk
972SGYQ/02LwURCUOj/dL4dDjRmUP7mieRMJlEo/oBVPhooZpD+sQj50BZRa
P4EIsyeJGbQ/pZKgpAOUaj8qR5GIsnC0P/kk0+9EB2s/0oVv6dvHtD9MtwU7
hnprPyQDLKsudrU/89tq0QhhbD/G/aQu1NK2P0AlNf4NLm4/DPOWNR+MuT/u
2+QrDORwP5jdekO1/r4/im55hRZ+dD9BHFmk3lW/P7S3Eiu3t3Q/6lo3BQit
vz/eAKzQV/F0Px7seWOtLcA/MZPeG5lkdT9vaTYlANzAP9i3Q7IbS3Y/EmSv
qKU4wj8mAQ7fIBh4P1hZoa/w8cQ/wpOiOCuyez/v21QKohrFP4H4NDz653s/
hl4IZVNDxT9AXcc/yR18P7Njbxq2lMU/vSbsRmeJfD8Obj2FezfGP7i5NVWj
YH0/pfDw3yxgxj94HshYcpZ9PzxzpDreiMY/N4NaXEHMfT9qeAvwQNrGP7VM
f2PfN34/xYLZWgZ9xz+x38hxGw9/P1wFjbW3pcc/cERbdepEfz/yh0AQac7H
Py6p7Xi5en8/II2nxcsfyD+schKAV+Z/P7cPWyB9SMg/tmvSQRMOgD9Okg57
LnHIPxWem8P6KIA/fJd1MJHCyD/VAi7HyV6APxMaKYtC68g/NDX3SLF5gD+q
nNzl8xPJP5RnwMqYlIA/QB+QQKU8yT/zmYlMgK+AP9ehQ5tWZck/UsxSzmfK
gD+QO0vYzW/JPzJtBzRT0YA/THQhcw==
                "]], 
               LineBox[{{0.20127551020408163`, 0.009210088994275386}, {
                0.2033724813112215, 0.0107647224110903}, {
                0.20461432671651483`, 0.011685390492311667`}, {
                0.20585617212180818`, 0.012606058573533033`}, {
                0.20833986293239484`, 0.014447394735975748`}, {
                0.2133072445535682, 0.018130067060861198`}, {
                0.2232420077959149, 0.02549541171063209}, {
                0.24311153428060836`, 0.040226101010173904`}, {
                0.2443290196086536, 0.041128709238306624`}, {
                0.24554650493669883`, 0.04203131746643932}, {
                0.24798147559278932`, 0.043836533922704764`}, {
                0.2528514169049703, 0.04744696683523564}, {0.2625912995293323,
                 0.054667832660297386`}, {0.28207106477805627`, 
                0.0691095643104209}, {0.3210305952755042, 
                0.0979930276106679}, {0.3987244897959184, 
                0.1555930223329001}}], 
               LineBox[{{0.40127551020408164`, 0.15754008214856188`}, {
                0.48443648039284554`, 0.22283175295792196`}, {
                0.5699233045152912, 0.28994950743422226`}, {
                0.5987244897959183, 0.3125620082743841}}], 
               LineBox[{{0.6012755102040817, 0.31436644905896244`}, {
                0.732138185275487, 0.3967520417752822}, {0.7987244897959184, 
                0.4386719563858601}}], 
               LineBox[{{0.8012755102040817, 0.44017565703967537`}, {
                0.8962801515662935, 0.4923658586630586}, {0.9739717509693491, 
                0.5350452496817523}, {0.9987244897959183, 
                0.5486430109233775}}], 
               LineBox[{{1.0012755102040816`, 0.5499110801345332}, {
                1.1369227129030104`, 0.61025001570552}, {1.1987244897959184`, 
                0.637740840137708}}], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA9P5cq2w48z9RAmer+3DkPw4dp+/k
5PQ/D0ket+215T9AVoPd4+n0P8CCI6O3ueU/co9fy+Lu9D9wvCiPgb3lP9YB
GKfg+PQ/0C8zZxXF5T+e5ohe3Az1P5EWSBc91OU/LrBqzdM09T8S5HF3jPLl
P01DLqvChPU/FX/FNysv5j9+fAqZwYn1P8S4yiP1MuY/sLXmhsCO9T908s8P
vzbmPxQon2K+mPU/1WXa51I+5j/cDBAauqz1P5VM75d6TeY/bNbxiLHU9T8X
Ghn4yWvmP4xptWagJPY/GrVsuGio5j/qQK2ICyr2P5Cs0bOErOY/RxilqnYv
9j8GpDavoLDmPwLHlO5MOvY/8ZIApti45j95JHR2+U/2P8lwlJNIyeY/pZo8
7ixh9j+Y9NkaVNbmP+czpQk=
                "]], 
               LineBox[{{1.4012755102040815`, 0.7145126645699601}, {
                1.4064308709161404`, 0.7159913533497922}, {1.407753743734141, 
                0.7163707869728454}, {1.410399489370142, 
                0.7171296542189517}, {1.415690980642144, 
                0.7186473887111643}, {1.426273963186148, 
                0.7216828576955893}, {1.4686058933621644`, 
                0.7338247336332897}, {1.547629076117258, 
                0.7564905954833164}, {1.5987244897959185`, 
                0.7711460617304773}}], 
               LineBox[{{1.6012755102040817`, 0.7718064498526682}, {
                1.717324837408056, 0.7986044228336541}, {1.795752517984577, 
                0.8167148498019805}, {1.7987244897959185`, 
                0.817401134007322}}], 
               LineBox[{{1.8012755102040816`, 0.8179499072356214}, {
                1.9601756422651684`, 0.8496217857699169}, {
                1.9987244897959184`, 0.8573053188217435}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBWsVJiCHPrPxMP8AjE
+gBAK6lBl/0n7D/SvYqHSf0AQEGv8EvUKew/kmwlBs//AEBYtZ8AqyvsPxLK
WgPaBAFAhsH9aVgv7D8ShcX97w4BQOHZuTyzNuw/EPua8hsjAUCWCjLiaEXs
PwznRdxzSwFA/2siLdRi7D/MleBa+U0BQBZy0eGqZOw/jER72X5QAUAteICW
gWbsPwuisNaJVQFAWYTe/y5q7D8KXRvRn18BQLScmtKJcew/CNPwxctzAUBo
zRJ4P4DsP8iBi0RRdgFAf9PBLBaC7D+IMCbD1ngBQJbZcOHsg+w/B45bwOF9
AUDD5c5KmofsPwZJxrr3hwFAHf6KHfWO7D/G92A5fYoBQDQEOtLLkOw/hqb7
twKNAUBLCumGopLsPwUEMbUNkgFAeBZH8E+W7D/Essszk5QBQI4c9qQmmOw/
ubOE3fyWAUDk4A4O6ZnsP51qqI8=
                "]], 
               LineBox[{{2.201275510204082, 0.8941661375293919}, {
                2.2025743146728987`, 0.8943145182052169}, {
                2.2039086887592343`, 0.8944669624980165}, {2.206577436931906, 
                0.8947718510836159}, {2.21191493327725, 0.8953816282548146}, {
                2.222589925967937, 0.896601182597212}, {2.2439399113493117`, 
                0.8990402912820069}, {2.2866398821120604`, 
                0.9039185086515966}, {2.3704807786936803`, 
                0.9134968317904788}, {2.398724489795918, 
                0.9167235075848521}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAFBlI7881A0CQOl604VftP7VTRwOU
RARAAItMEAa07T+IS7iFHEcEQIjOm8DitO0/XEMpCKVJBEAREutwv7XtPwIz
Cw22TgRAIpmJ0Xi37T9OEs8W2FgEQEWnxpLruu0/6NBWKhxtBECLw0AV0cHt
PxpOZlGklQRAFvw0GpzP7T/tRdfTLJgEQJ4/hMp40O0/wD1IVrWaBEAng9N6
VdHtP2YtKlvGnwRAOApy2w7T7T+zDO5k6KkEQFsYr5yB1u0/hgRf53CsBEDk
W/5MXtftP1r8z2n5rgRAbZ9N/TrY7T8A7LFuCrQEQH4m7F302e0/TMt1eCy+
BEChNCkfZ93tPx/D5vq0wARAKXh4z0Pe7T/yuld9PcMEQLK7x38g3+0/mao5
gk7IBEDEQmbg2eDtP+zmtxAwygRABpU+wH3h7T/O65gp
                "]], 
               LineBox[{{2.601275510204082, 0.9339618078636414}, {
                2.6052275961112112`, 0.9342019686504139}, {2.607701463665898, 
                0.9343523009033725}, {2.6126491987752725`, 
                0.9346529654092898}, {2.613861772475368, 
                0.9347266512199421}, {2.6150743461754633`, 
                0.9348003370305945}, {2.6174994935756546`, 
                0.9349477086518992}, {2.6223497883760363`, 
                0.9352424518945087}, {2.6320503779767996`, 
                0.9358319383797278}, {2.6514515571783264`, 
                0.9370109113501657}, {2.6902539155813803`, 
                0.9393688572910416}, {2.774462852749733, 
                0.9444860751549424}, {2.798724489795918, 
                0.9459604089569712}}], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkA1mobchkbuP/XKjeJw
gQdAnMFN9jyF7j/cC9Vo/IMHQMqqDanOhe4/wkwc74eGB0D3k81bYIbuP5DO
qvueiwdAUmZNwYOH7j8q0scUzZUHQAgLTYzKie4/XtkBRymqB0B0VEwiWI7u
P0QaSc20rAdAoT0M1emO7j8rW5BTQK8HQM8mzId7j+4/+NweYFe0B0Aq+Uvt
npDuP5LgO3mFvgdA351LuOWS7j/G53Wr4dIHQEvnSk5zl+4/rCi9MW3VB0B4
0AoBBZjuP5NpBLj41wdAprnKs5aY7j9g65LED90HQAGMShm6me4/+u6v3T3n
B0C2MErkAJzuP+Av92PJ6QdA5BkKl5Kc7j/HcD7qVOwHQBEDykkkne4/lPLM
9mvxB0Bs1UmvR57uP3szFH338wdAmr4JYtme7j9idFsDg/YHQMenyRRrn+4/
L/bpD5r7B0Aiekl6jqDuPx8a60Nj/QdAVs5xuPSg7j+YzLZv
                "]], 
               LineBox[{{3.001275510204082, 0.9572502554740905}, {
                3.0040658660648987`, 0.9573180813336145}, {3.00530855047641, 
                0.9573482875662715}, {3.0077939192994325`, 
                0.9574087000315856}, {3.0090366037109435`, 
                0.9574389062642428}, {3.010279288122455, 
                0.9574691124968998}, {3.0127646569454773`, 
                0.9575295249622139}, {3.017735394591522, 
                0.9576503498928421}, {3.0189537189257853`, 
                0.9576799639991684}, {3.0201720432600485`, 
                0.9577095781054946}, {3.022608691928575, 
                0.9577688063181472}, {3.0274819892656275`, 
                0.9578872627434524}, {3.0372285839397324`, 
                0.9581241755940626}, {3.0567217732879426`, 
                0.958598001295283}, {3.0957081519843626`, 
                0.959545652697724}, {3.1802851297394477`, 
                0.9616014858954655}, {3.1987244897959184`, 
                0.9620496959114224}}], 
               LineBox[{{3.201275510204082, 0.9621148045995258}, {
                3.3447619504179835`, 0.9659513404341221}, {3.398724489795918, 
                0.9673941890805909}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLSLp8f68KbfD1sB+k6qv7+wFvYp0mvh4HBiSrZYd
4ntvv+AgP7eVII9D0f+f14T539sbWK59+VGYx+Hp7J3sqUC+n8aLZYmSPA6n
r1hksgu8t+9ii1N0VOFxmOZmruMj+N6e5bCnGIMVj4OOlsmmq8Lv7b9ZKzLU
pfI4RHzU3fdC4r196+Z990wzgPp7376zlHxvL6Ids/dtFo+DndZa+W4g31hq
elVsAY+DcrJOo67Ue/uCHzxfbap5HN5d0XIpkn5v/3LLj5e/J/A4tO5QP/Vb
9r19hc60E5sn8zh8D3n+y0fuvT3HEuPl2dN4HLI+LtOeB+SrTc5LuT2bxyFA
S63XQf69fVLhk3u7lvE4SM9RCWhVeG9/R/fC5co9PA4b6xWv8Sm/t5//WrCW
eT+PQ6bQxkVRQH7SymC13oM8DopLHfKXAflq6VPPix3hcbhpfsH6E5D/UuV6
xYJjPA4TTsVz2Km8t1/zSEJJ6ySPg0fs+yudQP6bZ9sFDE7xOHBVtKSsAPIB
FMWl9Q==
                "]], LineBox[CompressedData["
1:eJwV0Hss1WEcx3GcyqXf83Bcm7nkfifhsIzn25KoZpHlkttxmcuJI2lrxJjQ
bUZNrNDoIlZyy8xZ2JFOlkV2aBhFLjmyp6KlVHr647P3Xv9+zOLFIUkqSkpK
zmz/29I+dzl1hAPZRsKavhUleVXCzKlxDtQzi/STmXfoLErXpjj4obsFD5n5
Gp+TdRc5kMcoKi2tKZHLnPh1yxwcc7V28GOuLhb32Cg4GODF9ycwmyivc96U
g7ZHk4oGZsfNn23CnxyUfXtFzGwo8V9S/d2CEASUNK4Y21Kifj/wgZcWgv7w
j/k+zMPCa0FSbQSeDqa60cwnZ3D9uAECq9FbvjXMcXI9/99mCFQMS24a2lGS
K7UoDxQgeP4k0cfAnpLWOmK5EIPAddysQsuRkvWcdVWhEIHeblGpC7MgrHF1
JgHBL+jMC2KWaGp2vEtBMPDYP+0688uC2YOvsxCcuiQ6pOZEyXR8Xmx7CYJc
t2fft5l32UhuF7QgGKwIiKQulATyxPl/WhE0ySpO4H2UXH9vHp/TgaDsz5S/
EzO/+qpddjeCsNR0NxGzkXpkd7IUgQJucMvM+1c3x4MmEGh+me6ddaUk+qmA
b/wXQUSQ2OKNGyVdkZt4VAlDfZeahDLjXT1cEQ+DwqQhhO9OSX+Uj9qKGoZc
Ki8MZTbX8Nvu1MFQW37gwxTzUmLw2nE7DHNjO2uXPSjx1dJZ3XbAYO99111d
QEmVRP6p3RlD1j2vYXvmAO3whT3uGHjZoq105ua+mOkFXwxWem8jNphVRHsn
qw5iyMhL+6rnSclp/fmJo34YuhZ5VzyZufSksdZADEe6BN05zBmGZ4YuhmJI
DavRV/Zi/w46yVzCMLT3ebSYM5uepS/mIzD8shk57Md8wahNWhmF4VB5ykwS
86gsqz8gFsO1TeXzpcy259x7t4QY5HF3uCbm4oLg5qEEDGni2MI+5n91r0K9

                "]], LineBox[CompressedData["
1:eJwV0X8s1HEcx/GLROTz2Zmppha35fyoWEuLqz5vx2QOcQz5sbtDm8RuTe0u
JFpn103ORr8km50zKdcPjPhu/GHR6mrXpWOJk2VZ9CmRreT69Mdrrz3+fvrn
KaWnnXg8npDt/59IKBc4n0EQmfTsmjCCEp2fqHe0GIF4o6S7jnnu5frTMiUC
7/japgnmRkGVyX4ewcDsWGFxJCVrb2qMDy8jcOGLXRpFlCSXxxlkVxDYcuSL
H5k7AtxbvTQIOjsqrcKjlGRdut6s1iFIhsHWQWYuuLEh5gaCJuWh43PHKKnS
tFZPdSIIex2gOgiUeKpc4xVdCLbzd5aomJsKS7zmHyFwpHrkc8zdkggD7UFg
nqRJsVGUzPMtI05DCM5+7g/IElMiaeG5BVkRtK/Hv6+OocSnT1Z34Q8C3xBl
uCWOkq4vu++iBAxbtH0/lSmUaO9p5NNJGLQmyzeOuUC6tNeUgsFj/OvCVikl
uzjucWIGBizwsxuYdfrs57V5GHZw2le2VEoKD9/54X4RQ8j3U0aSTongqnec
azuGk5nr6Tibko0jFZ62DgyWSh9pDvPk0tzb9gcY0oxhifeZ6zO6c2OfYMhc
LoiOzqHEESwt1XAYFLXmUFUuJVMWfYuzFUPpcIvbjIyS/pq1fOs4hl/z/c77
5KyPSBZkmMCg9rRuqJklxgM94mkMFVmuq14KSgbU5hfVCxhqVpSzsXmU3Nwf
rk9ZxODmq5tqYD73qTnNn2LQRbXZ7MyBCcUzwysY9HUT5rJ8SjZvetdWv4aB
37s8Nsps7xUVyX9jaPiwbcS7gPUsMoSG/cXg4yQcUjDf2uOx6nBguB0YNWBi
/gfCByIS
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$69811#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 cluster intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6JFb0zeulJPgRDGnDf
GVQ/yYtggvHEJz8zn5icsxlkP08kbK+9xDc/S83Xsp0ZdD+S8PHFo8RHP1dk
972SGYQ/tNY00ZbEVz/dL4dDjRmUP8VJ1laQxGc/oBVPhooZpD9NA6cZjcR3
P4EIsyeJGbQ/EWAPe4vEhz8qR5GIsnC0Pxn8ItScK4g/0oVv6dvHtD8gmDYt
rpKIPyQDLKsudrU/MdBd39BgiT/G/aQu1NK2P1BArEMW/Yo/DPOWNR+MuT+Q
IEkMoTWOP5jdekO1/r4/iHDBTltTkj9BHFmk3lW/P4w+S/vjhpI/6lo3BQit
vz+QDNWnbLqSPx7seWOtLcA/majoAH4hkz9vaTYlANzAP6jgD7Og75M/EmSv
qKU4wj/IUF4X5ouVP1hZoa/w8cQ/CDH733DEmD/v21QKohrFPySE8UqP9Jg/
hl4IZVNDxT8/1+e1rSSZP7Njbxq2lMU/dn3Ui+qEmT8Obj2FezfGP+PJrTdk
RZo/pfDw3yxgxj//HKSignWaPzxzpDreiMY/GnCaDaGlmj9qeAvwQNrGP1EW
h+PdBZs/xYLZWgZ9xz+/YmCPV8abP1wFjbW3pcc/2rVW+nX2mz/yh0AQac7H
P/UITWWUJpw/II2nxcsfyD8srzk70YacP7cPWyB9SMg/SAIwpu+2nD9Okg57
LnHIP2NVJhEO55w/fJd1MJHCyD+b+xLnSkedPxMaKYtC68g/tk4JUml3nT+q
nNzl8xPJP9Kh/7yHp50/QB+QQKU8yT/s9PUnptedP9ehQ5tWZck/CEjsksQH
nj+QO0vYzW/JP1SWJb8kFJ4/fHYsKw==
                "]], 
               
               Line[{{0.20127551020408163`, 0.030642700513974767`}, {
                0.2033724813112215, 0.03241898644327459}, {
                0.20461432671651483`, 0.03347091916293751}, {
                0.20585617212180818`, 0.03452285188260044}, {
                0.20833986293239484`, 0.036626717321926267`}, {
                0.2133072445535682, 0.04083444820057794}, {0.2232420077959149,
                 0.0492499099578813}, {0.24311153428060836`, 
                0.06608083347248803}, {0.2443290196086536, 
                0.06711213144792147}, {0.24554650493669883`, 
                0.06814342942335488}, {0.24798147559278932`, 
                0.07020602537422177}, {0.2528514169049703, 
                0.07433121727595551}, {0.2625912995293323, 
                0.08258160107942303}, {0.28207106477805627`, 
                0.09908236868635806}, {0.3210305952755042, 
                0.13208390390022812`}, {0.3987244897959184, 
                0.19789624206703718`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T/Z7IDfUp7JPxe0Ed4B
Ad8/nDvjvkGu0T9cjPtU5BbfP8RpFqRJwtE/omTly8Ys3z/sl0mJUdbRPywV
ubmLWN8/PPSvU2H+0T9CdmCVFbDfP9ysfOiATtI/NpxXppQv4D8aHhYSwO7S
P2Fepl2o3uA/mQBJZT4v1D+EShuZmengP8IufEpGQ9Q/pjaQ1Ir04D/oXK8v
TlfUP+wOekttCuE/ObkV+l1/1D92v005MjbhP9hx4o59z9Q/jCD1FLyN4T8Y
43u4vG/VP7biQ8zPPOI/lcWuCzuw1j/WSIHxjUfiP4BvFmzlw9Y/9q6+FkxS
4j9sGX7Mj9fWPzd7OWHIZ+I/Rm1NjeT+1j+4Ey/2wJLiP/YU7A6OTdc/uUQa
ILLo4j9WZCkS4erXP7Cb30LAKOM/nMn3QiNg2D9JrqZG
                "]], 
               
               Line[{{0.6012755102040817, 0.382887279414324}, {
                0.61319856565424, 0.39085179911525414`}, {0.6145099372039051, 
                0.39172778636417765`}, {0.6171326803032354, 
                0.3934797608620248}, {0.6223781665018959, 
                0.39698370985771897`}, {0.6328691388992168, 
                0.4039916078491073}, {0.6538510836938587, 
                0.418007403831884}, {0.732138185275487, 
                0.47030265360926504`}, {0.7987244897959184, 
                0.5147818507732825}}], 
               
               Line[{{0.8012755102040817, 0.5163445139283683}, {
                0.8962801515662935, 0.5692748996787763}, {0.9739717509693491, 
                0.6125595883740546}, {0.9987244897959183, 
                0.6263501989766912}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D9r7D9yohXkP+v3397V
MPI/vpjMxgUP5j+2Z4/CSjbyP15Q4GX8E+Y/gNc+pr878j/9B/QE8xjmPxa3
nW2pRvI/PXcbQ+Ai5j9Cdlv8fFzyP71Var+6NuY/mvTWGSSI8j++Egi4b17m
P2Vkhv2YjfI/XsobV2Zj5j8w1DXhDZPyP/6BL/ZcaOY/xrOUqPed8j8+8VY0
SnLmP/FyUjfLs/I/vc+lsCSG5j9I8c1Uct/yP7yMQ6nZreY/E2F9OOfk8j9d
RFdI0LLmP97QLBxc6vI//ftq58a35j90sIvjRfXyPz1rkiW0weY/n29JchkL
8z+8SeGhjtXmP2rf+FWOEPM/XAH1QIXa5j80T6g5AxbzP/u4COB73+Y/yi4H
Ae0g8z87KDAeaenmP5WetuRhJvM/3N9DvV/u5j9gDmbI1ivzP3yXV1xW8+Y/
cmcJu/kt8z/mv2DeR/XmP3HkvWE=
                "]], 
               Line[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA9P5cq2w48z/kXw1nCP3mP8FddHM1
PPM/99/JqjT/5j+MzSNXqkHzP664NL9WAuc/Iq2CHpRM8z8bagromgjnP01s
QK1nYvM/9cy1OSMV5z+k6rvKDo7zP6qSDN0zLuc/bpdPI2qT8z9KzsZGRzHn
PzdE43vFmPM/6gmBsFo05z/KnQotfKPzPyuB9YOBOuc/8VBZj+m48z+tb94q
z0bnPz639lPE4/M/sUyweGpf5z/ZgzHdeTn0P7kGVBShkOc/Dh2n7+Tk9D/I
eptLDvPnP0BWg93j6fQ/8ji9pOz15z9yj1/L4u70Px333v3K+Oc/1gEYp+D4
9D9ycyKwh/7nP57miF7cDPU/HWypFAEK6D8usGrN0zT1P3Ndt93zIOg/TUMu
q8KE9T8dQNNv2U7oP358CpnBifU/R/70yLdR6D+wteaGwI71P3K8FiKWVOg/
FCifYr6Y9T/HOFrUUlroP9wMEBq6rPU/cjHhOMxl6D9s1vGIsdT1P8ci7wG/
fOg/jGm1ZqAk9j9yBQuUpKroP+pArYgLKvY/RudLDsGt6D9HGKWqdi/2PxrJ
jIjdsOg/AseU7kw69j/CjA59FrfoP3kkdHb5T/Y/EhQSZojD6D+lmjzuLGH2
P2PlTtNozeg/tAj+mQ==
                "]], 
               
               Line[{{1.4012755102040815`, 0.7757197677251686}, {
                1.4064308709161404`, 0.7768481440038171}, {1.407753743734141, 
                0.7771376869457899}, {1.410399489370142, 
                0.7777167728297355}, {1.415690980642144, 
                0.7788749445976269}, {1.426273963186148, 
                0.7811912881334094}, {1.4686058933621644`, 
                0.7904566622765398}, {1.547629076117258, 
                0.8077528108613669}, {1.5987244897959185`, 
                0.8189362868512955}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T/0LsBxejnqP/tq1Jsp
evs/2fibVcUZ6z9UNl2RLn/7PxRBaacjHOs/rAHmhjOE+z9OiTb5gR7rP16Y
93E9jvs/wxnRnD4j6z/BxRpIUaL7P606BuS3LOs/hyBh9HjK+z+AfHByqj/r
PxPW7UzIGvw/KABFj49l6z9soXZCzR/8P2NIEuHtZ+s/xGz/N9Ik/D+dkN8y
TGrrP3YDESPcLvw/EiF61ghv6z/ZMDT570L8P/xBrx2CeOs/n4t6pRdr/D/Q
gxmsdIvrP/hWA5sccPw/Cszm/dKN6z9QIoyQIXX8P0QUtE8xkOs/Armdeyt/
/D+5pE7z7ZTrP2XmwFE/k/w/o8WDOmee6z8rQQf+Zrv8P3cH7shZses/sKqr
J9jA/D/f9UYp67PrPzQUUFFJxvw/R+SfiXy26z8MAaNUk8f8P6ic10EYt+s/
scGs6w==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D8HYy1hbrvrP8BQPc6c
1vw/q1yYDBO96z9FuuH3Ddz8P0GWiAUGv+s/To0qS/Dm/D9sCWn368LrP3LZ
TZh5Ev0/G9bqvoPS6z+5cZQyjGn9P3dv7k2z8es/R6IhZ7EX/j8uovVrEjDs
PzSYDibGHP4/HZVWS+Qx7D8gjvvk2iH+PwuItyq2M+w/+nnVYgQs/j/obXnp
WTfsP61RiV5XQP4/ojn9ZqE+7D8TAfFV/Wj+PxbRBGIwTew/31/AREm6/j/+
/xNYTmrsP8xVrQNev/4/7PJ0NyBs7D+4S5rCcsT+P9vl1Rbybew/kjd0QJzO
/j+4y5fVlXHsP0UPKDzv4v4/cpcbU9147D+rvo8zlQv/P+YuI05sh+w/dx1f
IuFc/z/NXTJEiqTsP2JQMFbcYf8/XYmK/VKm7D9OgwGK12b/P+y04rYbqOw/
Jumj8c1w/z8MDJMpravsP9S06MC6hP8/SrrzDtCy7D8wTHJflKz/P8cWtdkV
wew/HH9Dk4+x/z9XQg2T3sLsPweyFMeKtv8/5m1lTKfE7D/eF7cugcD/PwXF
Fb84yOw/jOP7/W3U/z9Ec3akW8/sP3gWzTFp2f8/057OXSTR7D9jSZ5lZN7/
P2PKJhft0uw/Oq9AzVro/z+CIdeJftbsPybiEQFW7f8/Ek0vQ0fY7D8RFeM0
UfL/P6F4h/wP2uw//Ee0aEz3/z8wpN+12NvsPz801ofG+v8/TLbAgxfd7D8n
bypd
                "]], 
               
               Line[{{2.001275510204082, 0.902340441577427}, {
                2.0039562426140143`, 0.9025995231633784}, {2.008820753763886, 
                0.9030696578396025}, {2.0185497760636295`, 
                0.9040099271920506}, {2.0380078206631165`, 
                0.9058904658969471}, {2.0393271393937447`, 
                0.9060179725394751}, {2.0406464581243724`, 
                0.906145479182003}, {2.0432850955856283`, 
                0.9064004924670591}, {2.0485623705081406`, 
                0.9069105190371711}, {2.0591169203531647`, 
                0.9079305721773951}, {2.080226020043213, 
                0.9099706784578433}, {2.122444219423309, 
                0.9140508910187395}, {2.1987244897959184`, 
                0.9214230604123401}}], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUD8vGoRaH7tP2s0u9kJ
SwJAgAcQbfTH7T/A0NWsuE0CQH1NZV4Vye0/FW3wf2dQAkB7k7pPNsrtP7+l
JSbFVQJAdR9lMnjM7T8TF5BygGACQGk3uvf70O0/u/lkC/d1AkBRZ2SCA9rt
Pwu/Dj3koAJAIse4lxLs7T9gWykQk6MCQB8NDokz7e0/tfdD40GmAkAcU2N6
VO7tP18weYmfqwJAFt8NXZbw7T+zoePVWrYCQAr3YiIa9e0/W4S4btHLAkDz
Jg2tIf7tP6tJYqC+9gJAxIZhwjAQ7j80LCE+P/kCQAXULUM+Ee4/vg7g27/7
AkBHIfrDSxLuP9DTXRfBAANAybuSxWYU7j/0XVmOwwoDQM/ww8icGO4/fUAY
LEQNA0AQPpBJqhnuPwYj18nEDwNAUYtcyrca7j8Z6FQFxhQDQNUl9cvSHO4/
PnJQfMgeA0DaWibPCCHuP8dUDxpJIQNAHKjyTxYi7j9QN863ySMDQF31vtAj
I+4/YvxL88ooA0Dgj1fSPiXuP+veCpFLKwNAId0jU0wm7j90wckuzC0DQGIq
8NNZJ+4//qOIzEwwA0Ckd7xUZyjuP1JNHneWMANA4+1rUoYo7j+J688V
                "]], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAFBlI7881A0A8r+UjViruP6wQQ+HP
PANAY55hIT8s7j/Qmj5Y0kYDQF/juGH6Lu4/WX399VJJA0CetM4xqS/uP+Jf
vJPTSwNA3YXkAVgw7j/0JDrP1FADQFwoEKK1Me4/Ga81RtdaA0BZbWficDTu
P2LDLDTcbgNAUvcVY+c57j/16xoQ5pYDQEULc2TURO4/lJ3nx5yZA0B/Lvj3
kUXuPzNPtH9TnANAuVF9i09G7j9xsk3vwKEDQCyYh7LKR+4/7XiAzpusA0AU
JZwAwUruP+UF5oxRwgNA4j7FnK1Q7j/VH7EJve0DQH9yF9WGXO4/tVNHA5RE
BEC42btFOXTuP4hLuIUcRwRALCs7Pep07j9cQykIpUkEQKB8ujSbde4/AjML
DbZOBECIH7kj/XbuP04SzxbYWARAWGW2AcF57j/o0FYqHG0EQPjwsL1If+4/
Gk5mUaSVBEA3CKY1WIruP+zmtxAwygRA9M4d9K6Y7j+NE6fW
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAArrLhiGnPBECL3U3o9ZnuPyR1Sxms
6wRAHkW5zRCg7j/KoRGTo/AEQLQFm3sjoe4/FPudhpL6BEDfhl7XSKPuP6it
tm1wDgVANonljpOn7j/QEug7LDYFQOSN8/0osO4/Id1K2KOFBUBAlw/cU8Hu
P4rCO69ViAVAx+0N4+jB7j/ypyyGB4sFQE5EDOp9wu4/wnIONGuQBUBb8Qj4
p8PuP2QI0o8ymwVAdUsCFPzF7j+oM1lHwbAFQKv/9Eukyu4/Lopntt7bBUAU
aNq79NPuP5ZvWI2Q3gVAm77YwonU7j//VElkQuEFQCIV18ke1e4/0B8rEqbm
BUAvwtPXSNbuP3G17m1t8QVASRzN85zY7j+04HUl/AYGQH7QvytF3e4/OjeE
lBkyBkDoOKWblebuP9ZiGTadNAZAB/QepyDn7j9zjq7XIDcGQCevmLKr5+4/
rOXYGig8BkBlJYzJwejuPx6ULaE2RgZA4xFz9+3q7j+6v8JCukgGQALN7AJ5
6+4/V+tX5D1LBkAhiGYOBOzuP5BCgidFUAZAYP5ZJRrt7j8C8datU1oGQN3q
QFNG7+4/nhxsT9dcBkD9pbpe0e/uPztIAfFaXwZAHGE0alzw7j/Yc5aS3mEG
QDscrnXn8O4/hYBRqsljBkCo9iSNUfHuP7df9G4=
                "]], 
               Line[CompressedData["
1:eJwVx2tIk1EcgPF56RwrSCxHauHmpdqyEAusED1/MBuWZph0UQvRVRumrTRM
NGcO24c0bKmEiuAHiV4XC1xkwVZINCqXoW0hbTCTkjl7D7qLy2l1+vDw8Euq
vFZ8KVwgECSz/l9W0JQcoUSgnEvJzV7myc/C1leqWgQ+5z7HKnNbo7Dcp0KQ
cUT7tNjLE9Ewt95Qh6Cme7aFYz639gXUtxD8ON6bVOrjyUdOaulsQ2B/8ffy
Sz9PFHazIqYdwdZtpYdjAjyJDC/Z1KNFUFRr3KhkzjnfUjjQgcCSqtTHrfDk
GZ6e5noRjD2YWmoI8qRb3uyycAj6qoebM0M8KU+c/B02jeCC6IRuVECJ/0Pn
d9UdDK/3T5xpjaPEsdmmWNNgEOZ/y5phHi/YSbV3MVyVL4gPxFPS9YkLDd7D
EN8f5Zlj3jtlibX2YKiPylPLdlBycSZMJuUwSOZMj7ckUnI0Id9q1GNQ/5no
uMKcVtZ1GgwY7PGO62+Yg47EirNGDJpTq1k3RJToXFmN7WYMTlPmZ5uYknfz
N0dmpzDoHhmCAymU6CWmjBobBveo2elnfqiMHAt+xUAmreMnUymp8OjeRjsx
/Nqw2CHYRckqb3Bmz2OQ1UmS5LspcaWvVL13Yxi8fwiZmC2qnIWSRQy+J8c8
wj2UdC9PBKqXMAy55M8tzE0HY2+veDEEQ3V9YgkllfVlEZoAhqLtGnUjc3rA
Hd0XwrBWOJSfJqVElODJrVrHkOclI0rmf2eUCB8=
                "]], 
               Line[CompressedData["
1:eJwVx1tMElAcgHGi2zmU+pDNra0ZmgVU4Eo2Fcf5l6iUFYWNbG1mitIVYlE2
mXM1m4rNloXSMtu0B2y1YkmZtS4T08oc4mJrCXmp1sp2ZgYEWnR6+Pbtxy8x
qMu4HA4nifX/45/jn7RyEUiexiRHhJTcy9x5twAhWJQbbtKLKGkxW6UfeQg6
nk8db2fW/kneEoxD4HeOJPPWUWJbUGRSr0bQbzHM2tdT8rc0QTq8BgFfIPR8
YNb2ugMqIQJz34Q9dgMlqeeyK3aIEYg5Go2JeSAqqFSmI7CeynIQMSWhyEy1
fDuC0mKs80oo0UzXN4hMCKLSDs/8TZQs8zvbuS4E6ePezqIMShqXVlU9fInA
nf9lyMrMkykKj71CcOhBYGaQmWvzxHiHENga4uWyTEp+7qZnOt8jCEvVngQZ
Je4+gWoXRfDY8jbizqLkwp1rs9dXYJCnufKzgRI0WuJVr8TgbRs5UclcwxM5
Fq/CoMeTVgezWdddbkzB0OafN5a4mZIj/HfDilQM0TpimmNWWmPt33MwvPD1
tDqzKVlYdXZPhhGDotbxY20eJV3TU+FnJzHsJaRsP7O2vPBG7mkMR0ODo43M
LpXkW4EZw2Xd1zcB5pokX7X+PIaJvMRbvUpK0lqUKYFaDMHobX6I+dOSrtdm
CwZed+ZV0VZKFAHL8vqLGDYKNHWXmH8dDvbENWHIGZuMuphv+g8WN1/BsM9m
rPjN/Oh+jW+uGYOhf+CAcBsl/wBo+vyj
                "]], 
               Line[CompressedData["
1:eJwVx3lIk2EcwPG5EnmfFwu1zFKjKdUgtYl0QOXzE7XQtdwm2uE2xFhOc4qz
eS2vpA2yCcpasLxQUrxtXYo03VCXtMSkVCYo5G3ZU6KdBr398eXLh5OSJZaz
WSwWl+n/NSVdCSdrKLhabZzqiyV4yLQEliYKBsIt84N8gsuVhsnpTgoCc+Vj
HAHBbK+vLrtsFKwuPG2ajyPYrEtqMQxRYDNLZ88ICU7ZHrnoa6fgUanbfgNj
22LtQ66DAoFfUmWUiOA7vfzgyEkKeuLZBY/FBLvIWq7kr1GQZxNeSk0gmNUq
6/7oiWBnw/rPtWsEj3yeyqzfi8DpHfcgNong+zxRiMQHwRN9T2gb4329kZ0f
/BFINTnpaRKCQ+zc9tdcBM8Tf80sSwmWLG40d4UjSHV3HVhIJriPo6srTEcw
Wuh3d/YGwcVyluyUEkH9tyJOeCrBUa0F/ptZCNSKuVe1jMd5GTVKNQJOYuN3
iYLgFSwyJZciKAzlKmbSCPaW+RrPGxEcWwnjT2cQrDJ16z1tCCoT+B4TKoJf
bpt0tiEEDks1OZ5D8LZMW6ayI0Bc51s9Y12gVD3hQKD9rbgXc4vgmg4krZ5C
UFyv3WFVEzxskQd5riNQrlq3uvMJRhzRERtB0C6m3rsXECwsP3tItYFgtV9o
vsnYecFrz8QPBPLKucyjhQR/GR/8U8WmQRr2d7lOQ7DPvO8bDx8aBEWnnfpi
gqXRbsPWAzRULJX0fmLc2LJhyfanYTTObowpITgoY9T8LoCG6IDEeNdSgrPH
nnWUHaahvKI29DrjF7yG5lAuDdbNhd1WxhFbuaaqYBrO2XMct8sI1l5OMUTw
aNDw+tucjMWCg3lGxicazXiJ8T8Ebiw3
                "]], 
               Line[CompressedData["
1:eJwVz30sFHAcx/GjlPn9xF2Xp7WcpstwS5OE7PdNs1xL61RmDRt1k7M4qk11
aBdFWIfruPM4tfOwWuxO7Ba61eiSpyhWZirhevqtQjf6o19/fPbZ68+3T2pW
nNSew+HsZvv/fM8YOhqC4M+pv9uzlJTE5/sqJQcQCGpMH3TMtXMuCrsIBP3H
ZscszHNR65c7IxEk29k/tTHLNr9O5x5GUCcTN8TfoORReu9ZczSCCO8L5UXM
y0OtSdkxCN5NqBRG5gJVgWQ8FoFH5PQZXiElak9RWEUCArVLmvsIc29AsSM3
E0GZsVAVfZOS/ZPuw5VyBKZlfUI2c4eipYJ/EcHiPougnrl5eMDLIxdBVJdz
5zJzcZaDyFuJwNalGb93i5I4g1Ii0iCQdrfy7EsoWQzP04n7EESaXqn7Sinh
Hs0JVG7B8KOfrw2toKTJ7ILCuRh0kzxeGnNQ2EPrz60YjlhdSzXMx/2W9Cme
GBp5znkrzLc3Jfsc8sVwQuqQYqikZOMzsRsnHEOn06rfHjUlqxE+nHwphkun
p3qE1ZQUGfpmQ85jEMje7I1n5gck9n6XYRjOn2gvYg72qr6aJMewq3W0bp5Z
bsMrB69heLs2eL25hhKr0WZdV2EIbeqJ2aGjJDdQ88JQheGT8bE5ltnxfnBL
hgaDymJkpZQIqzLPva/FsPSrI3CGOTV7ftakx6CNbnPV1VIyIxqbuPIEw9oX
7fS2ekoav3LzNvRjCCnV+Ecxp7adFJabMcgDqhSZzMK0u6NuzzG0D90Z0TFb
fadymwYwfM4oEwwyP/josdPfwvpwSc5v5m8L3a5BLzEsJDpJHBoo+QdYZiGf

                "]], 
               
               Line[{{3.601275510204082, 0.9880722755276076}, {
                3.6044205455572738`, 0.9880990950445477}, {
                3.6068988062055514`, 0.9881202285918611}, {3.611855327502106, 
                0.9881624956864878}, {3.6130944578262447`, 
                0.9881730624601445}, {3.6143335881503837`, 
                0.9881836292338011}, {3.616811848798661, 
                0.9882047627811145}, {3.621768370095216, 
                0.9882470298757411}, {3.6316814126883257`, 
                0.9883315640649945}, {3.6329205430124643`, 
                0.9883421308386512}, {3.634159673336603, 
                0.9883526976123078}, {3.6366379339848804`, 
                0.9883738311596212}, {3.641594455281435, 
                0.9884160982542478}, {3.651507497874545, 
                0.9885006324435012}, {3.6713335830607647`, 
                0.9886697008220079}, {3.749078878861765, 
                0.9893326794672694}, {3.798724489795918, 
                0.9897560360130411}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyecQ8DhI2GvNe/u1L2Rn8/nwOyTZru2d
u+29fcfc1oR7fvwOPs+/eO4D8lOC3qquC+R3MJ9ow3YfyJfZs2eDbzi/A+/T
03UK29/bd/VHH+tJ4nfY0fMqfzGQn2E28yNXJb8D/x31oJU73tsrtYh4sC/j
d9hbtUhs66739v8sanivr+B3WKHy6tJVIP/m28eXlq3md5h0zrD/G5A/IXxz
rNtGfocMpYPsFrvf2//XCipu3cPvIHzq/o9dQP6di/3zmC/zO2RJyt4+sOe9
/Y6278mXr/I7hB5Omf4QyJ9iHa+5+Aa/g0PummCmve/tvZfqbXG6x+8gdtD6
jDOQv6vi7MnGl/wOBzOi9h4D8qfpmvYHvuF3WCO0qPI5kF/4aE6I4nt+h+l7
Xppy7Htvr+GTc//AF36HHIHKdZ5APgvjlSUTvvM7hO86kJUF5D/Yap2V8Ivf
wSmFQ70byN+TtVjf4C+/gy5fwOPVQP50ee6v///zO0jsmD7/DJAPAKaAveY=

                "]]}, "Charting`Private`Tag$69811#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT5OMWgA2/ksPgRDGnDf
GVQ/P+RuvHWUCj8zn5icsxlkP2/juMg7lBo/S83Xsp0ZdD8H493OHpQqP1dk
972SGYQ/02LwURCUOj/dL4dDjRmUP7mieRMJlEo/oBVPhooZpD+sQj50BZRa
P4EIsyeJGbQ/pZKgpAOUaj8qR5GIsnC0P/kk0+9EB2s/0oVv6dvHtD9MtwU7
hnprPyQDLKsudrU/89tq0QhhbD/G/aQu1NK2P0AlNf4NLm4/DPOWNR+MuT/u
2+QrDORwP5jdekO1/r4/im55hRZ+dD9BHFmk3lW/P7S3Eiu3t3Q/6lo3BQit
vz/eAKzQV/F0Px7seWOtLcA/MZPeG5lkdT9vaTYlANzAP9i3Q7IbS3Y/EmSv
qKU4wj8mAQ7fIBh4P1hZoa/w8cQ/wpOiOCuyez/v21QKohrFP4H4NDz653s/
hl4IZVNDxT9AXcc/yR18P7Njbxq2lMU/vSbsRmeJfD8Obj2FezfGP7i5NVWj
YH0/pfDw3yxgxj94HshYcpZ9PzxzpDreiMY/N4NaXEHMfT9qeAvwQNrGP7VM
f2PfN34/xYLZWgZ9xz+x38hxGw9/P1wFjbW3pcc/cERbdepEfz/yh0AQac7H
Py6p7Xi5en8/II2nxcsfyD+schKAV+Z/P7cPWyB9SMg/tmvSQRMOgD9Okg57
LnHIPxWem8P6KIA/fJd1MJHCyD/VAi7HyV6APxMaKYtC68g/NDX3SLF5gD+q
nNzl8xPJP5RnwMqYlIA/QB+QQKU8yT/zmYlMgK+AP9ehQ5tWZck/UsxSzmfK
gD+QO0vYzW/JPzJtBzRT0YA/THQhcw==
                "]], 
               
               Line[{{0.20127551020408163`, 0.009210088994275386}, {
                0.2033724813112215, 0.0107647224110903}, {
                0.20461432671651483`, 0.011685390492311667`}, {
                0.20585617212180818`, 0.012606058573533033`}, {
                0.20833986293239484`, 0.014447394735975748`}, {
                0.2133072445535682, 0.018130067060861198`}, {
                0.2232420077959149, 0.02549541171063209}, {
                0.24311153428060836`, 0.040226101010173904`}, {
                0.2443290196086536, 0.041128709238306624`}, {
                0.24554650493669883`, 0.04203131746643932}, {
                0.24798147559278932`, 0.043836533922704764`}, {
                0.2528514169049703, 0.04744696683523564}, {0.2625912995293323,
                 0.054667832660297386`}, {0.28207106477805627`, 
                0.0691095643104209}, {0.3210305952755042, 
                0.0979930276106679}, {0.3987244897959184, 
                0.1555930223329001}}], 
               
               Line[{{0.40127551020408164`, 0.15754008214856188`}, {
                0.48443648039284554`, 0.22283175295792196`}, {
                0.5699233045152912, 0.28994950743422226`}, {
                0.5987244897959183, 0.3125620082743841}}], 
               
               Line[{{0.6012755102040817, 0.31436644905896244`}, {
                0.732138185275487, 0.3967520417752822}, {0.7987244897959184, 
                0.4386719563858601}}], 
               
               Line[{{0.8012755102040817, 0.44017565703967537`}, {
                0.8962801515662935, 0.4923658586630586}, {0.9739717509693491, 
                0.5350452496817523}, {0.9987244897959183, 
                0.5486430109233775}}], 
               
               Line[{{1.0012755102040816`, 0.5499110801345332}, {
                1.1369227129030104`, 0.61025001570552}, {1.1987244897959184`, 
                0.637740840137708}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA9P5cq2w48z9RAmer+3DkPw4dp+/k
5PQ/D0ket+215T9AVoPd4+n0P8CCI6O3ueU/co9fy+Lu9D9wvCiPgb3lP9YB
GKfg+PQ/0C8zZxXF5T+e5ohe3Az1P5EWSBc91OU/LrBqzdM09T8S5HF3jPLl
P01DLqvChPU/FX/FNysv5j9+fAqZwYn1P8S4yiP1MuY/sLXmhsCO9T908s8P
vzbmPxQon2K+mPU/1WXa51I+5j/cDBAauqz1P5VM75d6TeY/bNbxiLHU9T8X
Ghn4yWvmP4xptWagJPY/GrVsuGio5j/qQK2ICyr2P5Cs0bOErOY/RxilqnYv
9j8GpDavoLDmPwLHlO5MOvY/8ZIApti45j95JHR2+U/2P8lwlJNIyeY/pZo8
7ixh9j+Y9NkaVNbmP+czpQk=
                "]], 
               
               Line[{{1.4012755102040815`, 0.7145126645699601}, {
                1.4064308709161404`, 0.7159913533497922}, {1.407753743734141, 
                0.7163707869728454}, {1.410399489370142, 
                0.7171296542189517}, {1.415690980642144, 
                0.7186473887111643}, {1.426273963186148, 
                0.7216828576955893}, {1.4686058933621644`, 
                0.7338247336332897}, {1.547629076117258, 
                0.7564905954833164}, {1.5987244897959185`, 
                0.7711460617304773}}], 
               
               Line[{{1.6012755102040817`, 0.7718064498526682}, {
                1.717324837408056, 0.7986044228336541}, {1.795752517984577, 
                0.8167148498019805}, {1.7987244897959185`, 
                0.817401134007322}}], 
               
               Line[{{1.8012755102040816`, 0.8179499072356214}, {
                1.9601756422651684`, 0.8496217857699169}, {
                1.9987244897959184`, 0.8573053188217435}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBWsVJiCHPrPxMP8AjE
+gBAK6lBl/0n7D/SvYqHSf0AQEGv8EvUKew/kmwlBs//AEBYtZ8AqyvsPxLK
WgPaBAFAhsH9aVgv7D8ShcX97w4BQOHZuTyzNuw/EPua8hsjAUCWCjLiaEXs
PwznRdxzSwFA/2siLdRi7D/MleBa+U0BQBZy0eGqZOw/jER72X5QAUAteICW
gWbsPwuisNaJVQFAWYTe/y5q7D8KXRvRn18BQLScmtKJcew/CNPwxctzAUBo
zRJ4P4DsP8iBi0RRdgFAf9PBLBaC7D+IMCbD1ngBQJbZcOHsg+w/B45bwOF9
AUDD5c5KmofsPwZJxrr3hwFAHf6KHfWO7D/G92A5fYoBQDQEOtLLkOw/hqb7
twKNAUBLCumGopLsPwUEMbUNkgFAeBZH8E+W7D/Essszk5QBQI4c9qQmmOw/
ubOE3fyWAUDk4A4O6ZnsP51qqI8=
                "]], 
               
               Line[{{2.201275510204082, 0.8941661375293919}, {
                2.2025743146728987`, 0.8943145182052169}, {
                2.2039086887592343`, 0.8944669624980165}, {2.206577436931906, 
                0.8947718510836159}, {2.21191493327725, 0.8953816282548146}, {
                2.222589925967937, 0.896601182597212}, {2.2439399113493117`, 
                0.8990402912820069}, {2.2866398821120604`, 
                0.9039185086515966}, {2.3704807786936803`, 
                0.9134968317904788}, {2.398724489795918, 
                0.9167235075848521}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAFBlI7881A0CQOl604VftP7VTRwOU
RARAAItMEAa07T+IS7iFHEcEQIjOm8DitO0/XEMpCKVJBEAREutwv7XtPwIz
Cw22TgRAIpmJ0Xi37T9OEs8W2FgEQEWnxpLruu0/6NBWKhxtBECLw0AV0cHt
PxpOZlGklQRAFvw0GpzP7T/tRdfTLJgEQJ4/hMp40O0/wD1IVrWaBEAng9N6
VdHtP2YtKlvGnwRAOApy2w7T7T+zDO5k6KkEQFsYr5yB1u0/hgRf53CsBEDk
W/5MXtftP1r8z2n5rgRAbZ9N/TrY7T8A7LFuCrQEQH4m7F302e0/TMt1eCy+
BEChNCkfZ93tPx/D5vq0wARAKXh4z0Pe7T/yuld9PcMEQLK7x38g3+0/mao5
gk7IBEDEQmbg2eDtP+zmtxAwygRABpU+wH3h7T/O65gp
                "]], 
               
               Line[{{2.601275510204082, 0.9339618078636414}, {
                2.6052275961112112`, 0.9342019686504139}, {2.607701463665898, 
                0.9343523009033725}, {2.6126491987752725`, 
                0.9346529654092898}, {2.613861772475368, 
                0.9347266512199421}, {2.6150743461754633`, 
                0.9348003370305945}, {2.6174994935756546`, 
                0.9349477086518992}, {2.6223497883760363`, 
                0.9352424518945087}, {2.6320503779767996`, 
                0.9358319383797278}, {2.6514515571783264`, 
                0.9370109113501657}, {2.6902539155813803`, 
                0.9393688572910416}, {2.774462852749733, 
                0.9444860751549424}, {2.798724489795918, 
                0.9459604089569712}}], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkA1mobchkbuP/XKjeJw
gQdAnMFN9jyF7j/cC9Vo/IMHQMqqDanOhe4/wkwc74eGB0D3k81bYIbuP5DO
qvueiwdAUmZNwYOH7j8q0scUzZUHQAgLTYzKie4/XtkBRymqB0B0VEwiWI7u
P0QaSc20rAdAoT0M1emO7j8rW5BTQK8HQM8mzId7j+4/+NweYFe0B0Aq+Uvt
npDuP5LgO3mFvgdA351LuOWS7j/G53Wr4dIHQEvnSk5zl+4/rCi9MW3VB0B4
0AoBBZjuP5NpBLj41wdAprnKs5aY7j9g65LED90HQAGMShm6me4/+u6v3T3n
B0C2MErkAJzuP+Av92PJ6QdA5BkKl5Kc7j/HcD7qVOwHQBEDykkkne4/lPLM
9mvxB0Bs1UmvR57uP3szFH338wdAmr4JYtme7j9idFsDg/YHQMenyRRrn+4/
L/bpD5r7B0Aiekl6jqDuPx8a60Nj/QdAVs5xuPSg7j+YzLZv
                "]], 
               
               Line[{{3.001275510204082, 0.9572502554740905}, {
                3.0040658660648987`, 0.9573180813336145}, {3.00530855047641, 
                0.9573482875662715}, {3.0077939192994325`, 
                0.9574087000315856}, {3.0090366037109435`, 
                0.9574389062642428}, {3.010279288122455, 
                0.9574691124968998}, {3.0127646569454773`, 
                0.9575295249622139}, {3.017735394591522, 
                0.9576503498928421}, {3.0189537189257853`, 
                0.9576799639991684}, {3.0201720432600485`, 
                0.9577095781054946}, {3.022608691928575, 
                0.9577688063181472}, {3.0274819892656275`, 
                0.9578872627434524}, {3.0372285839397324`, 
                0.9581241755940626}, {3.0567217732879426`, 
                0.958598001295283}, {3.0957081519843626`, 
                0.959545652697724}, {3.1802851297394477`, 
                0.9616014858954655}, {3.1987244897959184`, 
                0.9620496959114224}}], 
               
               Line[{{3.201275510204082, 0.9621148045995258}, {
                3.3447619504179835`, 0.9659513404341221}, {3.398724489795918, 
                0.9673941890805909}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLSLp8f68KbfD1sB+k6qv7+wFvYp0mvh4HBiSrZYd
4ntvv+AgP7eVII9D0f+f14T539sbWK59+VGYx+Hp7J3sqUC+n8aLZYmSPA6n
r1hksgu8t+9ii1N0VOFxmOZmruMj+N6e5bCnGIMVj4OOlsmmq8Lv7b9ZKzLU
pfI4RHzU3fdC4r196+Z990wzgPp7376zlHxvL6Ids/dtFo+DndZa+W4g31hq
elVsAY+DcrJOo67Ue/uCHzxfbap5HN5d0XIpkn5v/3LLj5e/J/A4tO5QP/Vb
9r19hc60E5sn8zh8D3n+y0fuvT3HEuPl2dN4HLI+LtOeB+SrTc5LuT2bxyFA
S63XQf69fVLhk3u7lvE4SM9RCWhVeG9/R/fC5co9PA4b6xWv8Sm/t5//WrCW
eT+PQ6bQxkVRQH7SymC13oM8DopLHfKXAflq6VPPix3hcbhpfsH6E5D/UuV6
xYJjPA4TTsVz2Km8t1/zSEJJ6ySPg0fs+yudQP6bZ9sFDE7xOHBVtKSsAPIB
FMWl9Q==
                "]], 
               Line[CompressedData["
1:eJwV0Hss1WEcx3GcyqXf83Bcm7nkfifhsIzn25KoZpHlkttxmcuJI2lrxJjQ
bUZNrNDoIlZyy8xZ2JFOlkV2aBhFLjmyp6KlVHr647P3Xv9+zOLFIUkqSkpK
zmz/29I+dzl1hAPZRsKavhUleVXCzKlxDtQzi/STmXfoLErXpjj4obsFD5n5
Gp+TdRc5kMcoKi2tKZHLnPh1yxwcc7V28GOuLhb32Cg4GODF9ycwmyivc96U
g7ZHk4oGZsfNn23CnxyUfXtFzGwo8V9S/d2CEASUNK4Y21Kifj/wgZcWgv7w
j/k+zMPCa0FSbQSeDqa60cwnZ3D9uAECq9FbvjXMcXI9/99mCFQMS24a2lGS
K7UoDxQgeP4k0cfAnpLWOmK5EIPAddysQsuRkvWcdVWhEIHeblGpC7MgrHF1
JgHBL+jMC2KWaGp2vEtBMPDYP+0688uC2YOvsxCcuiQ6pOZEyXR8Xmx7CYJc
t2fft5l32UhuF7QgGKwIiKQulATyxPl/WhE0ySpO4H2UXH9vHp/TgaDsz5S/
EzO/+qpddjeCsNR0NxGzkXpkd7IUgQJucMvM+1c3x4MmEGh+me6ddaUk+qmA
b/wXQUSQ2OKNGyVdkZt4VAlDfZeahDLjXT1cEQ+DwqQhhO9OSX+Uj9qKGoZc
Ki8MZTbX8Nvu1MFQW37gwxTzUmLw2nE7DHNjO2uXPSjx1dJZ3XbAYO99111d
QEmVRP6p3RlD1j2vYXvmAO3whT3uGHjZoq105ua+mOkFXwxWem8jNphVRHsn
qw5iyMhL+6rnSclp/fmJo34YuhZ5VzyZufSksdZADEe6BN05zBmGZ4YuhmJI
DavRV/Zi/w46yVzCMLT3ebSYM5uepS/mIzD8shk57Md8wahNWhmF4VB5ykwS
86gsqz8gFsO1TeXzpcy259x7t4QY5HF3uCbm4oLg5qEEDGni2MI+5n91r0K9

                "]], 
               Line[CompressedData["
1:eJwV0X8s1HEcx/GLROTz2Zmppha35fyoWEuLqz5vx2QOcQz5sbtDm8RuTe0u
JFpn103ORr8km50zKdcPjPhu/GHR6mrXpWOJk2VZ9CmRreT69Mdrrz3+fvrn
KaWnnXg8npDt/59IKBc4n0EQmfTsmjCCEp2fqHe0GIF4o6S7jnnu5frTMiUC
7/japgnmRkGVyX4ewcDsWGFxJCVrb2qMDy8jcOGLXRpFlCSXxxlkVxDYcuSL
H5k7AtxbvTQIOjsqrcKjlGRdut6s1iFIhsHWQWYuuLEh5gaCJuWh43PHKKnS
tFZPdSIIex2gOgiUeKpc4xVdCLbzd5aomJsKS7zmHyFwpHrkc8zdkggD7UFg
nqRJsVGUzPMtI05DCM5+7g/IElMiaeG5BVkRtK/Hv6+OocSnT1Z34Q8C3xBl
uCWOkq4vu++iBAxbtH0/lSmUaO9p5NNJGLQmyzeOuUC6tNeUgsFj/OvCVikl
uzjucWIGBizwsxuYdfrs57V5GHZw2le2VEoKD9/54X4RQ8j3U0aSTongqnec
azuGk5nr6Tibko0jFZ62DgyWSh9pDvPk0tzb9gcY0oxhifeZ6zO6c2OfYMhc
LoiOzqHEESwt1XAYFLXmUFUuJVMWfYuzFUPpcIvbjIyS/pq1fOs4hl/z/c77
5KyPSBZkmMCg9rRuqJklxgM94mkMFVmuq14KSgbU5hfVCxhqVpSzsXmU3Nwf
rk9ZxODmq5tqYD73qTnNn2LQRbXZ7MyBCcUzwysY9HUT5rJ8SjZvetdWv4aB
37s8Nsps7xUVyX9jaPiwbcS7gPUsMoSG/cXg4yQcUjDf2uOx6nBguB0YNWBi
/gfCByIS
                "]]}, 
              "Charting`Private`Tag$69811#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 cluster intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT4G4b557d5gPgRDGnDf
GVQ/Z+m/ZZPzPj8zn5icsxlkP2sCCupP804/S83Xsp0ZdD/uDi8sLvNeP1dk
972SGYQ/L5VBTR3zbj/dL4dDjRmUP1DYyt0U834/oBVPhooZpD/geQ+mEPOO
P4EIsyeJGbQ/qMoxig7znj8qR5GIsnC0P4j5j4JEeZ8/0oVv6dvHtD9oKO56
ev+fPyQDLKsudrU/FUPVNfOFoD/G/aQu1NK2P9WgkSZfkqE/DPOWNR+MuT9W
XAoIN6ujP5jdekO1/r4/WdP7yubcpz9BHFmk3lW/P8rqKscBIKg/6lo3BQit
vz86AlrDHGOoPx7seWOtLcA/GzG4u1LpqD9vaTYlANzAP9uOdKy+9ak/EmSv
qKU4wj9cSu2Nlg6sP1hZoa/w8cQ/sGBvKCMgsD/v21QKohrFPxrpenB3P7A/
hl4IZVNDxT+FcYa4y16wP7Njbxq2lMU/WYKdSHSdsD8Obj2FezfGPwKky2jF
GrE/pfDw3yxgxj9tLNewGTqxPzxzpDreiMY/17Ti+G1ZsT9qeAvwQNrGP6zF
+YgWmLE/xYLZWgZ9xz9W5yepZxWyP1wFjbW3pcc/wG8z8bs0sj/yh0AQac7H
Pyr4PjkQVLI/II2nxcsfyD//CFbJuJKyP7cPWyB9SMg/aZFhEQ2ysj9Okg57
LnHIP9QZbVlh0bI/fJd1MJHCyD+pKoTpCRCzPxMaKYtC68g/E7OPMV4vsz+q
nNzl8xPJP347m3myTrM/QB+QQKU8yT/ow6bBBm6zP9ehQ5tWZck/UkyyCVuN
sz+QO0vYzW/JPwRf+MVplbM/f+kqYQ==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT8Ur7vSRwu0PzKsEQYc
CMo/qim4vCeYtD/JLsVgzTDKP5r5pR2V67Q/YLF4u35Zyj+LyZN+Aj+1P422
33Dhqso/amlvQN3ltT/owK3bpk3LPyqpJsSSM7c/ntVJsTGTzD+pKJXL/c65
Pwv/gVxHHs8/qidy2tMFvz+YaVdeLEbPP3oa8kieV78/JNQsYBFuzz9GDXK3
aKm/Pz6p12Pbvc8/cvk4yn4mwD+5qZa1ty7QPw/fOKcTysA/7VPsvEvO0D9K
qjhhPRHCP1Wol8tzDdI/v0A41ZCfxD8lUe7ow4vUP6ptN703vMk/Gn9HOmeh
1D8AS4VMlOjJPxCtoIsKt9Q/WCjT2/AUyj/6CFMuUeLUPwLjbvqpbco/0MC3
c9441T9cWKY3HB/LP3owgf745dU/DEMVsgCCzD/ODxQULkDXP2wY86bJR88/
wz1tZdFV1z/C9UA2JnTPP7hrxrZ0a9c/GNOOxYKgzz+jx3hZu5bXP8aNKuQ7
+c8/eH/dnkjt1z+PAbEQV1XQPyLvpiljmtg/53boTckG0T8XHQB7BrDYP5Fl
j5X3HNE/DEtZzKnF2D88VDbdJTPRP/emC2/w8Ng/kzGEbIJf0T/s1GTAkwbZ
Pz0gK7SwddE/4gK+ETcc2T/pDtL73ovRP8xecLR9R9k/P+wfizu40T/CjMkF
IV3ZP+vaxtJpztE/t7oiV8Ry2T+VyW0amOTRP5Vq8rizhNk/U1nDqvr20T+7
jB3E
                "]], 
               LineBox[{{0.40127551020408164`, 0.2828841095261634}, {
                0.4029125240902338, 0.2840099105983874}, {
                0.40555387663264447`, 0.28582641169805567`}, {
                0.40678641731639764`, 0.286674049971052}, {
                0.40801895800015076`, 0.2875216882440483}, {
                0.41048403936765704`, 0.28921696479004094`}, {
                0.4154142021026696, 0.2926075178820262}, {
                0.42527452757269474`, 0.2993886240659968}, {0.444995178512745,
                 0.31295083643393795`}, {0.48443648039284554`, 
                0.34007526116982023`}, {0.5699233045152912, 
                0.39886594038897616`}, {0.5987244897959183, 
                0.4186729838994421}}], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z85RZuDkObaP/UmPQ+t
bec/jCQy/d343z8+4kLHinjnPxH1JG0DA+A/hp1If2iD5z/b17DblwngPxYU
VO8jmec/cJ3IuMAW4D82AWvPmsTnP5go+HISMeA/eNuYj4gb6D/rPlfntWXg
P/yP9A9kyeg/kGsV0PzO4D9ES/rHQdToP1pOoT6R1eA/jAYAgB/f6D8kMS2t
JdzgPx19C/Da9Og/ufZEik7p4D8+aiLQUSDpP+KBdESgA+E/hiUoiC8r6T+s
ZACzNArhP87gLUANNuk/dkeMIckQ4T9eVzmwyEvpPwsNpP7xHeE/f0RQkD93
6T80mNO4QzjhP8j/VUgdguk//3pfJ9g+4T8Qu1sA+4zpP8ld65VsReE/FwJG
qSaP6T+WRM4OvUbhP0inl4k=
                "]], 
               LineBox[{{0.8012755102040817, 0.5411484446719864}, {
                0.8024388112602567, 0.5415962551996663}, {0.8037652381656297, 
                0.5421068607125478}, {0.8064180919763757, 
                0.5431280717383107}, {0.8077445188817487, 
                0.5436386772511922}, {0.8090709457871217, 
                0.5441492827640737}, {0.8117237995978678, 
                0.5451704937898366}, {0.8170295072193599, 
                0.5472129158413626}, {0.8182677985372807, 
                0.5476895937275864}, {0.8195060898552016, 
                0.5481662716138103}, {0.8219826724910432, 
                0.549119627386258}, {0.8269358377627265, 
                0.5510263389311534}, {0.8368421683060933, 
                0.5548397620209442}, {0.8566548293928267, 
                0.5624666082005259}, {0.8962801515662935, 
                0.5777203005596891}, {0.9739717509693491, 
                0.6076275338939103}, {0.9987244897959183, 
                0.6171560535979097}}], 
               LineBox[{{1.0012755102040816`, 0.6181049625732646}, {
                1.1369227129030104`, 0.6668018389746967}, {
                1.1987244897959184`, 0.6889884630322718}}], 
               LineBox[{{1.2012755102040815`, 0.689821516842031}, {
                1.3058823930203434`, 0.720588247082108}, {1.3839420330101317`,
                 0.7435469647261634}, {1.3987244897959183`, 
                0.7478947461337477}}], 
               LineBox[{{1.4012755102040815`, 0.7486064278652638}, {
                1.547629076117258, 0.7872204742350898}, {1.5987244897959185`, 
                0.800701530612245}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T+awMJ7oqTpP/tq1Jsp
evs/xCTh+uaK6j9UNl2RLn/7P45WmHNVjeo/rAHmhjOE+z9XiE/sw4/qP16Y
93E9jvs/6+u93aCU6j/BxRpIUaL7PxGzmsBanuo/hyBh9HjK+z9dQVSGzrHq
PxPW7UzIGvw/9l3HEbbY6j9soXZCzR/8P8CPfook2+o/xGz/N9Ik/D+JwTUD
k93qP3YDESPcLvw/HCWk9G/i6j/ZMDT570L8P0PsgNcp7Oo/n4t6pRdr/D+P
ejqdnf/qP/hWA5sccPw/WazxFQwC6z9QIoyQIXX8PyLeqI56BOs/Armdeyt/
/D+1QReAVwnrP2XmwFE/k/w/2wj0YhET6z++sUlHRJj8P6U6q9t/Fes/Fn3S
PEmd/D9ubGJU7hfrP8gT5CdTp/w/AtDQRcsc6z8rQQf+Zrv8PyiXrSiFJus/
sKqrJ9jA/D8KjiEMKCnrPzQUUFFJxvw/64SV78or6z8MAaNUk8f8P2UBw81q
LOs/an3GhQ==
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D9dkWfvtTDrP8BQPc6c
1vw/n85RMEIy6z9FuuH3Ddz8P/y1SzMYNOs/To0qS/Dm/D+2hD85xDfrP3LZ
TZh5Ev0/nr8OUXRG6z+5cZQyjGn9P201rYDUY+s/R6IhZ7EX/j8MIerflJ7r
PzSYDibGHP4/I9AktUug6z8gjvvk2iH+Pzt/X4oCous/+nnVYgQs/j9q3dQ0
cKXrP61RiV5XQP4/yZm/iUus6z8TAfFV/Wj+P4YSlTMCuus/31/AREm6/j8A
BECHb9XrP8xVrQNev/4/F7N6XCbX6z+4S5rCcsT+Py9itTHd2Os/kjd0QJzO
/j9ewCrcStzrP0UPKDzv4v4/vXwVMSbj6z+rvo8zlQv/P3r16trc8Os/dx1f
IuFc/z/05pUuSgzsP2JQMFbcYf8/JNW2ZfgN7D9OgwGK12b/P1XD15ymD+w/
Jumj8c1w/z+2nxkLAxPsP9S06MC6hP8/eFid57sZ7D8wTHJflKz/P/vJpKAt
J+w/HH9Dk4+x/z8suMXX2yjsPweyFMeKtv8/XKbmDooq7D/eF7cugcD/P72C
KH3mLew/jOP7/W3U/z9/O6xZnzTsP3gWzTFp2f8/rynNkE027D9jSZ5lZN7/
P+AX7sf7N+w/Oq9AzVro/z9A9C82WDvsPybiEQFW7f8/ceJQbQY97D8RFeM0
UfL/P6HQcaS0Puw//Ee0aEz3/z/SvpLbYkDsPz801ofG+v8/NCyDKI9B7D+W
LCTY
                "]], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCAEBlUFEOaETsP0sj5TUa
CABAEpf+pK9G7D8iiYedEBIAQOx+2aLSSuw/0FTMbP0lAECfTo+eGFPsPyzs
VQvXTQBABu76laRj7D+4VEy/ilAAQOLXVMzDZOw/Q71Ccz5TAEC+wa4C42Xs
P1qOL9ulWABAdpVibyFo7D+JMAmrdGMAQOc8ykiebOw/5nS8ShJ5AEDHi5n7
l3XsP6D9IopNpABAiSk4YYuH7D8TD/AIxPoAQAtldSxyq+w/0r2Kh0n9AEBG
LPcyfqzsP5JsJQbP/wBAgfN4OYqt7D8SyloD2gQBQPiBfEair+w/EoXF/e8O
AUDlnoNg0rPsPxD7mvIbIwFAv9iRlDK87D8M50Xcc0sBQHNMrvzyzOw/zJXg
WvlNAUCuEzAD/83sP4xEe9l+UAFA6tqxCQvP7D8LorDWiVUBQGBptRYj0ew/
Cl0b0Z9fAUBNhrwwU9XsPwjT8MXLcwFAJ8DKZLPd7D+5s4Td/JYBQHL+dTFQ
7Ow/3Jy3Cg==
                "]], 
               LineBox[{{2.201275510204082, 0.9040895770072735}, {
                2.2025743146728987`, 0.9042019303350258}, {
                2.2039086887592343`, 0.9043173606193109}, {2.206577436931906, 
                0.9045482211878811}, {2.21191493327725, 0.9050099423250216}, {
                2.222589925967937, 0.9059333845993025}, {2.2439399113493117`, 
                0.9077802691478644}, {2.2866398821120604`, 
                0.911474038244988}, {2.3704807786936803`, 
                0.918726710959661}, {2.398724489795918, 0.9211699385636608}}],
                LineBox[{{2.4012755102040817`, 0.9213850981569099}, {
                2.5334854370252864`, 0.9322501007936006}, {
                2.5987244897959183`, 0.9376114416354778}}], 
               LineBox[{{2.601275510204082, 0.9378266012287269}, {
                2.6902539155813803`, 0.9455236951194966}, {2.774462852749733, 
                0.9528082052551673}, {2.798724489795918, 
                0.9549069627851141}}], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkCiVsjWZ5DuP/XKjeJw
gQdAy+RBlXDx7j/cC9Vo/IMHQL0OKAZS8u4/wkwc74eGB0CuOA53M/PuP5DO
qvueiwdAkozaWPb07j8q0scUzZUHQFo0cxx8+O4/XtkBRymqB0Dpg6Sjh//u
P0QaSc20rAdA2q2KFGkA7z8rW5BTQK8HQMzXcIVKAe8/+NweYFe0B0CwKz1n
DQPvP5LgO3mFvgdAeNPVKpMG7z/G53Wr4dIHQAYjB7KeDe8/rCi9MW3VB0D4
TO0igA7vP5NpBLj41wdA6nbTk2EP7z9g65LED90HQM7Kn3UkEe8/+u6v3T3n
B0CVcjg5qhTvP+Av92PJ6QdAh5weqosV7z/HcD7qVOwHQHnGBBttFu8/lPLM
9mvxB0BdGtH8LxjvP3szFH338wdAT0S3bREZ7z9idFsDg/YHQEFund7yGe8/
L/bpD5r7B0AlwmnAtRvvPx8a60Nj/QdAWJIR9FMc7z++K7B4
                "]], LineBox[CompressedData["
1:eJwV0HlIE2AUAPAxkr7PI8kDQ5jOYzGlUsOBzeN76pSlzqUzXRlSVhMrqpWY
OZaoC9NCIdRJml0KJpSVmgdBg2xYmGjHKkhjpeIFD8sZZlpffzwePx68KyD/
TOZxoUAgkPD4n+3TXs9ahAScplJL74mQPZKnd2kIAfv7saQqP2RmQ4PsqzMB
6Whr/yL3sfWghBV3Ar0WeWufP7KUuJPD5R4E1gbIVpEYWUTZk3Q3bwLx3bbK
Cu4NQXxusC+B0fZzhaoAZE2b8ooygwnM1nRGfg/k9aM+svHtBCrteZ3JQbz/
izGHOoSAX5SnuJM7vCLxgmoXgaxpg4s+GNnwX2mpMoqAham+bUiQ/fr9sywu
jYB5Get8Q5BlL1VfDS0ikJwnW8gIQ+Y52XtXOESgLcJyxxKNrNbVaOyzEpAN
UtOOGGTO0QrtqVcErAkaXRO3sOmtm22UwJxmJvRsLLIfGVhy/zOBncWuPf4M
2dhLqXof8vsHtdZLCciuPWheu+lLwZq4NB+zFxn5km/LFFHIGZG/6eA2OYc+
3iymMJdl6vJKQWYo6NfpJRRcdD5Fi9wnAj6MK8IpqK/ErjenIVM2bOlYSKLw
caTafU2NzMlYnrVHT2F2f2DkQDaynqXF1efnKRjHS6dEOfxfOu2t5GIKHqp3
9RXcQ+qweY2BQrTC5EjV8vmBE2WnL1Oo3T3zdPIAskizUuKoohD0MK4g8SCy
KZee14YaCv0hZp8OboWjxru6joJdrCzR5yJbLlwZdL9OobjlttTG3TZ55HBj
Pd9/2+on+SFkA92miT+NFFLaL1bd4P4H/vYJbg==
                "]], LineBox[CompressedData["
1:eJwVx2tIU3EYgPG5IXn+B6Q2S/OWK5Ihbkzs8kHxvKYVmEozvFDbstkoL1M0
p6bg1IWTyA/KWjS2lC4uSSdI2YwSPTgtvAt5ie5plJgnJUtrXd4+PDz8xJqi
NC2fx+NJsP+vMjjTD9goyDhJj+5Uccyg9SP03aLA59JYrRJt1Jln5jopcEcE
83vQfNFXL1+WAqail5+r5phu0ymHeZCCFfGYxoDWeIaSg4YpsI+8Za+i2UX7
NckoBZ5QHyOLrnMdkybMUNDrzhAEn+YYL7Ujq2KJgmjRN8EEmteu7novJCBx
yrz3n+GYoeXZwpbtBCJWDYkp6CtyhUwZQEC6b8qoRfu7EjqfhxCIenSBb0HL
hiX3nkoIxAy5/n5HKxfX2pxxBFJfH/rp0nBMr9h0ozKPgN43k4s9yzHVWp76
oI5AueKuLB2d2H4x5FsRgUrzpk6HnpQX2HR6AoZA27Id/YlRWLNrCDSEv/v8
B71DHWQ5YiFgi8tf6NdyTIm1q1HIEmALDfOJ5zjmocdqYgcJtDQ6HUq0R11f
WzJMoKrjlb4Ubdqj0k+PEoheihHeRts6iKp5lsAd7UaS4DzHuPu0kcIvBEzK
4scDaCJWhLMcgZyq1svz6OPG2LCSNQJgnchaRb84KvKb/kFgY1a6HpbLMSuT
/b+a+DTknViS1qADPgSNbAugITkppyUuj2NUh7e4BwJpkOQ26zLQNx1rfcUh
NHg3DMQUoiMLnnVP7abhiXvXnB1dPH6/o3YvDdcXUtseoHvkrW1REhrKBNWl
Y+j49TJrk5QGWfzLrb/R9Zkac7ycBjqbfuOXzzFpKaHlFnSdaHPcH/0PM5Aj
0A==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbeD2G/+MxnZ7+3D6lSaAi24HQwV3ngv
APJnP+CvYbTmdoh4m3j+NpD/wOl36UZbbof6XdeDxHPe22exX8oUdOZ2OBNy
OLIPyF+fuTf5oCu3w2dFy7sngfwvp1fEFnpwO0i9X5fAmvvevn5CfeBFX26H
9M5Z6TVA/hRJXcuJEdwOTPsKS7Py3tvv1e7gEMzjdrBQV5joVvDe3uyK+NlJ
BdwOGm89ROuA/A01yyeKFHM7SGwunLkVyF909piURAW3ww+7wwtVCt/bd+Sz
6so3cTvsCEvbxFT03j5oc1Og7jRuB/O2NZf3Fb+3f25VO8tzH7eD2VMLMfPy
9/aCXkU6TXw8DsaLA2er1723v6N74XLlHh4Hlc9MOia97+3fPNsuYHCKx4HF
K+lyct97ewBp24So
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOAv8/iz/ue29vFr789d1kXofy4Dp9
n3nv7Xfz82++nsHrwLcyNfMCkH+s4Z7j6SJeB9sQk7s35r+3v51UG7+pjddh
5qqLR14ufG/Ppr57VsM6XoegcJ4p3Mve23sy59f93cDrIMfEsNEXyO+5r5RU
tZnX4dWaz2f7gXzBGV2aJTt4HRqZbrOLLH9vL8MZtSP9EK/D+rUrq2VWvLc3
ev3jqt81XgceFvdk3VXv7WPXmwnK/uN1OLqh0ch/3Xv7bVE/+C4w8Dl0qeu9
nQbk87Ht4mlm5nPwn3dr+T0g/0CMLcdLDj6Hm93Gsnnr39srcbn83yLM5/A2
7Sl774b39s9SAt/6aPI5iMp63j216b29nYDw6//aQPWTv04X2vzefvruKy82
6fE5zOdaFBQF5HsIRTyRMOFz0Pjx6/hLIH/V/rjbT+z4HGwur9nEsfW9fZ5U
zsmaED6HlE6BDrftwPA6qntcP5zPQZNhr1MfkC9f+P7Io0g+h3dlmX+vAvkV
MhsPTY3hc9j8VnSH7I739heOFx3wiOdzqEg5VJQK5GsUm+z7ncjnYHs7T3ct
kN/aELjqZDKfwxStvQp3gXwAG8zU1A==
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPELo5TvNyZtluTsCksPiiVbv0+tuHEZlrGU08mSkZWap8zJ
/dRMHXOYSOki0SEPFW5FeUiWdo6JblKWasV3WXKV6NMf7733cpIlhsSYCASC
Ldj/+0nShaanCfA9TQ3ebYzL3eTT2hdPQKIzXRuBnhpYbEpLJDBl/GQ8h1YJ
5fWT5wlYixtf3kYvvM6pup9JIGEazpi0My4oXayWXiJgRkRh9uiazZaVNjyB
Ms9V4IE+mnG1PCWXQL9CZy1Da91UhQeLCIicZa1daDlfmWWoJWCQZi/KOxhn
lWzhf0JDoECxTlKCvh6bYDPdQODQvbtlGnRzgLeatRConxvYO46ettZ1mzwl
kMnbpu7SMi6gQrDSVU/Aqa5q/iPa7pH02oU/BGJ+9s36P2Gc5rNDGZFQmMlb
8962i3FXbvBRE4EU1gdOvnBHnwyZEdUHU9hPWxp90Ru02sbDYRSKCyLkKehc
ZURvnozCvuJaRwM61qv0u2UqBeVNcaT6GeOECluxRTUFjybF253djFvac9Fq
tIbCsaTw5/7osZmpoeo6Cjm7t9ZFo/PDmo/7PqAw/lCfVoRedgtJ4rUUsjuE
9r/QBp2ywlRPYbi7M7yzh3GPcxai9SMUlngVjKFVPlJX9RsKLn6xLnPogKpt
LQcmKGT0U6NzL+PaU171Z32hIBqMLLmMLnb3VAZ/oxCk9Mi8hT77ofyIE6OQ
FmR+qg3tIol/1/mDwuCQxusr2mzF8J38BQrGwqyNZn2Mm2z1iYv6TUEYGmru
gNbGqbfv+EtBYuc664kucVw9v7xMIXl0cSQQ/Q/LkjHr
                "]]},
              Annotation[#, "Charting`Private`Tag$69897#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT75jXfEpfZfPgRDGnDf
GVQ/k5lrjAJSPT8zn5icsxlkP6MQIJ/CUU0/S83Xsp0ZdD8sTHqoolFdP1dk
972SGYQ/8WknrZJRbT/dL4dDjRmUP9P4fa+KUX0/oBVPhooZpD9EQKmwhlGN
P4EIsyeJGbQ//OM+sYRRnT8qR5GIsnC0Pz32uAao0J0/0oVv6dvHtD9+CDNc
y0+ePyQDLKsudrU/AS0nBxJOnz/G/aQu1NK2PwK7h65PpaA/DPOWNR+MuT8H
BHAE3aGiP5jdekO1/r4/EZZAsPeapj9BHFmk3lW/PzGf/VqJ2qY/6lo3BQit
vz9SqLoFGxqnPx7seWOtLcA/lLo0Wz6Zpz9vaTYlANzAPxbfKAaFl6g/EmSv
qKU4wj8aKBFcEpSqP1hZoa/w8cQ/JLrhBy2Nrj/v21QKohrFP6r39kSIyK4/
hl4IZVNDxT8vNQyC4wOvP7Njbxq2lMU/ObA2/Jl6rz8Obj2FezfGPyfTRXgD
NLA/pfDw3yxgxj/qcdAWsVGwPzxzpDreiMY/rRBbtV5vsD9qeAvwQNrGPzJO
cPK5qrA/xYLZWgZ9xz89yZpscCGxP1wFjbW3pcc/AGglCx4/sT/yh0AQac7H
P8IGsKnLXLE/II2nxcsfyD9IRMXmJpixP7cPWyB9SMg/CuNPhdS1sT9Okg57
LnHIP82B2iOC07E/fJd1MJHCyD9Tv+9g3Q6yPxMaKYtC68g/Fl56/4ossj+q
nNzl8xPJP9j8BJ44SrI/QB+QQKU8yT+bm4885meyP9ehQ5tWZck/XToa25OF
sj+QO0vYzW/JPyiZCuM1jbI/logjAg==
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8eBk0UqP6yPzKsEQYc
CMo/0GQq5QyHsz/JLsVgzTDKPzmWq/PS17M/YLF4u35Zyj+ixywCmSi0P422
33Dhqso/cyovHyXKtD/owK3bpk3LPxbwM1k9DbY/ntVJsTGTzD9dez3NbZO4
Pwv/gVxHHs8/7JFQtc6fvT+YaVdeLEbPP+VyviT/7r0/JNQsYBFuzz/cUyyU
Lz6+Pz6p12Pbvc8/zhUIc5Dcvj+5qZa1ty7QP9nMXxipDMA/7VPsvEvO0D++
UBfWaknBP1Wol8tzDdI/hliGUe7Cwz8lUe7ow4vUPxhoZEj1tcg/Gn9HOmeh
1D8gSMye6ODIPxCtoIsKt9Q/LCg09dsLyT/6CFMuUeLUPz7oA6LCYck/0MC3
c9441T9maKP7jw3KP3owgf745dU/sGjiriplyz/ODxQULkDXP0hpYBVgFM4/
wz1tZdFV1z9SSchrUz/OP7hrxrZ0a9c/WikwwkZqzj+jx3hZu5bXP27p/24t
wM4/eH/dnkjt1z+UaZ/I+mvPPyLvpiljmtg/8DTvvcph0D8XHQB7BrDYP/Qk
I2lEd9A/DEtZzKnF2D/5FFcUvozQP/emC2/w8Ng/A/W+arG30D/MXnC0fUfZ
Pxa1jheYDdE/lWryuLOE2T8ZHzpKWErRP2GP+ag=
                "]], 
               LineBox[{{0.40127551020408164`, 0.2723348549946294}, {
                0.40801895800015076`, 0.27712625211288905`}, {
                0.41048403936765704`, 0.27887775729506453`}, {
                0.4154142021026696, 0.2823807676594156}, {
                0.42527452757269474`, 0.28938678838811766`}, {
                0.444995178512745, 0.3033988298455218}, {0.48443648039284554`,
                 0.3314229127603301}, {0.5699233045152912, 
                0.3921635509525941}, {0.5987244897959183, 
                0.4126275510204081}}], 
               LineBox[{{0.6012755102040817, 0.41422913150222496`}, {
                0.732138185275487, 0.48556404836445716`}, {0.7987244897959184,
                 0.5218610940616848}}], 
               LineBox[{{0.8012755102040817, 0.5231941460794844}, {
                0.8962801515662935, 0.5706964667605903}, {0.9739717509693491, 
                0.6095422664621181}, {0.9987244897959183, 
                0.6219186358754027}}], 
               LineBox[{{1.0012755102040816`, 0.6230502915451894}, {
                1.1369227129030104`, 0.6755753361992859}, {
                1.1382548904425511`, 0.67609117938189}, {1.1395870679820916`, 
                0.676607022564494}, {1.142251423061173, 0.6776387089297023}, {
                1.147580133219336, 0.6797020816601188}, {1.158237553535662, 
                0.6838288271209517}, {1.1795523941683133`, 
                0.6920823180426174}, {1.1987244897959184`, 
                0.6995060994322541}}], 
               LineBox[{{1.2012755102040815`, 0.7003548411845941}, {
                1.2234898928959086`, 0.7065347822342001}, {1.224797710358201, 
                0.7068986111522815}, {1.2274133452827862`, 
                0.7076262689884443}, {1.2326446151319568`, 
                0.7090815846607699}, {1.2431071548302977`, 
                0.7119922160054212}, {1.2640322342269796`, 
                0.7178134786947237}, {1.3058823930203434`, 
                0.7294560040733286}, {1.3839420330101317`, 
                0.7511718437697359}, {1.3987244897959183`, 
                0.7552842565597667}}], 
               LineBox[{{1.4012755102040815`, 0.7559939389289551}, {
                1.547629076117258, 0.7967088407243499}, {1.5489670042909665`, 
                0.7970810463065094}, {1.550304932464675, 
                0.7974532518886689}, {1.5529807888120917`, 
                0.7981976630529879}, {1.5583325015069254`, 
                0.7996864853816258}, {1.5690359268965925`, 
                0.8026641300389017}, {1.5703738550703008`, 
                0.8030363356210611}, {1.5717117832440093`, 
                0.8034085412032206}, {1.5743876395914262`, 
                0.8041529523675396}, {1.5797393522862597`, 
                0.8056417746961775}, {1.5904427776759271`, 
                0.8086194193534534}, {1.5917807058496356`, 
                0.8089916249356128}, {1.5931186340233439`, 
                0.8093638305177723}, {1.5957944903707606`, 
                0.8101082416820913}, {1.597132418544469, 
                0.8104804472642507}, {1.5984703467181776`, 
                0.8108526528464103}, {1.5987244897959185`, 
                0.8109233543041277}}], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAW2XDEdOe+T+geU+cCPjpPyiCgGbG
o/k/utXBG/j56T8ahNxRQan5P2IMRp4c/Ok//oeUKDe0+T+xeU6jZQDqP8SP
BNYiyvk/UFRfrfcI6j/frsSL0SH6P8q+otU/K+o/0O0E7DIn+j+eHoJbWi3q
P8AsRUyULPo/cX5h4XQv6j+gqsUMVzf6Pxc+IO2pM+o/YqbGjdxM+j9lvZ0E
FDzqP+adyI/nd/o/AbyYM+hM6j/tjMyT/c36Pze5jpGQbuo/+2rUmyl6+z+l
s3pN4bHqP1Q2XZEuf/s/VMtTsdez6j+sAeaGM4T7PwPjLBXOteo/Xpj3cT2O
+z9iEt/curnqP8HFGkhRovs/HnFDbJTB6j+HIGH0eMr7P5guDItH0eo/E9bt
TMga/D+MqZ3IrfDqP2yhdkLNH/w/O8F2LKTy6j/EbP830iT8P+rYT5Ca9Oo/
dgMRI9wu/D9ICAJYh/jqP9kwNPnvQvw/BWdm52AA6z+fi3qlF2v8P38kLwYU
EOs/+FYDmxxw/D8uPAhqChLrP1AijJAhdfw/3VPhzQAU6z8CuZ17K3/8PzyD
k5XtF+s/ZebAUT+T/D/54fckxx/rP76xSUdEmPw/qPnQiL0h6z8WfdI8SZ38
P1cRquyzI+s/yBPkJ1On/D+1QFy0oCfrPytBB/5mu/w/cp/AQ3ov6z+wqqsn
2MD8P+7Ct/WaMes/NBRQUUnG/D9o5q6nuzPrPwwBo1STx/w/JdnBrjw06z+4
ryLS
                "]], 
               LineBox[{{1.8012755102040816`, 0.850548565290778}, {
                1.8023956352454178`, 0.8507001611610341}, {
                1.8037242586975861`, 0.8508799748613275}, {
                1.8063815056019226`, 0.8512396022619144}, {
                1.8170104932192683`, 0.8526781118642619}, {
                1.8382684684539596`, 0.855555131068957}, {1.8807844189233422`,
                 0.8613091694783471}, {1.9601756422651684`, 
                0.8720538463216018}, {1.9987244897959184`, 
                0.8772709835814025}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDFLM6VZBXsPxMP8AjE
+gBAqdafAQCY7D/SvYqHSf0AQAB2hb1Tmew/kmwlBs//AEBYFWt5p5rsPxLK
WgPaBAFAB1Q28U6d7D8ShcX97w4BQGXRzOCdouw/EPua8hsjAUAhzPm/O63s
PwznRdxzSwFAmMFTfnfC7D/MleBa+U0BQPBgOTrLw+w/jER72X5QAUBHAB/2
HsXsPwuisNaJVQFA9j7qbcbH7D8KXRvRn18BQFS8gF0Vzew/CNPwxctzAUAP
t608s9fsP8iBi0RRdgFAZ1aT+AbZ7D+IMCbD1ngBQL71eLRa2uw/B45bwOF9
AUBtNEQsAt3sPwZJxrr3hwFAy7HaG1Hi7D/G92A5fYoBQCJRwNek4+w/hqb7
twKNAUB68KWT+OTsPwUEMbUNkgFAKC9xC6Dn7D/Essszk5QBQIDOVsfz6Ow/
ubOE3fyWAUA2Y0zdOOrsPxtbq8w=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUCuA8wQduzsP9o8REjf
ngFAATFtV1ft7D+vuuzgmqEBQEzjcsk+7uw/WrY9EhKnAUDhR36tDfDsP7Gt
33QAsgFACxGVdavz7D9enCM63ccBQF+jwgXn+uw/uHmrxJbzAUAHyB0mXgnt
P2s0u9kJSwJAWBHUZkwm7T/A0NWsuE0CQCGQMZ8vJ+0/FW3wf2dQAkDqDo/X
EijtP7+lJSbFVQJAfQxKSNkp7T8TF5BygGACQKMHwClmLe0/u/lkC/d1AkDt
/avsfzTtPwu/Dj3koAJAg+qDcrNC7T9gWykQk6MCQExp4aqWQ+0/tfdD40Gm
AkAW6D7jeUTtP18weYmfqwJAqeX5U0BG7T+zoePVWrYCQM7gbzXNSe0/W4S4
btHLAkAZ11v45lDtP6tJYqC+9gJArsMzfhpf7T80LCE+P/kCQLdyGG3uX+0/
vg7g27/7AkDAIf1bwmDtP9DTXRfBAANA0n/GOWpi7T/0XVmOwwoDQPU7WfW5
Ze0/fUAYLEQNA0D+6j3kjWbtPwYj18nEDwNABpoi02Fn7T8Z6FQFxhQDQBj4
67AJae0/PnJQfMgeA0A8tH5sWWztP8dUDxpJIQNARGNjWy1t7T9QN863ySMD
QE0SSEoBbu0/YvxL88ooA0BfcBEoqW/tP+veCpFLKwNAZx/2Fn1w7T90wcku
zC0DQHDO2gVRce0//qOIzEwwA0B5fb/0JHLtP1JNHneWMANAPqKtUz1y7T9K
qv5d
                "]], LineBox[CompressedData["
1:eJwVz30s1HEcB/Dj+20rsUlqY5qFrVVntY4tcb6fpjx3HJKOdZKTLHdKuB4Q
W3cqD7OUx8sswnXL08lD2LnzcNV0pNLTajQ/Kl/MUpNKv/54773Xf+/39jhZ
mMScw+HsYPO/be38F0zuCPRWk4GqVEo01j6TJi8ESXi1bPUCJaMV3lEvfBEk
do0pF9MpOZ75ZzksAEF9gtKQnEHJlLjn1ngQAmYzf+0r6+8uB0wvQxFIpA3p
03JK7JrcfSdECE45Z0veXaIkzsB1+yBFcKKA6zOQRcnyN3tr5g6CiJPKv6UK
SkpUM8NV5QgUxQMjjkpKeCHa7PAqBF39Zqp61udajyzoahBsc7ri2ZFHCZVf
fV6pQTAzlSJ/fYOS6XVMvlCP4GK8aMm2iJJXji0beimC6tOuTHEpJe3hfqjk
EIYvyeMjNxsoyQvqvObgh8HGsqjEopGSGJ+d6+sCMHipA6OvszbnbbR6JMBQ
yPTPKtSUCGxMW99EYeCJm1GuhpLZ0chdDskYskILPOTNlDw2DmtqZRjq5/05
P1kX6vbvcT2PYTQfD6e1UOLWbO/mnYHB+cnliNRWSnKKPvJjczAYDybJpFpK
7AUJwtrb7B6eX118J/vv8MQ4twyD55j52c+sdXz/yPYKDBJZ3764LkoSXHdF
D1Vj6HjgrhN3U9JmOR8/24ghxsXlvaiHEgUWz6RoMCj0n2reshb9Np1ZeYih
KbYyMaqXEs5ci9RCi8FMZfPjaB8lwc/S5Nw+DPe3mG0S6ihxNDC/tDp2f1vP
hIn1UvexTL4Bw4pQflfQT8lQq3FtcBCD0yJPMsK6XO2RKzBiCC5c2B2sp2SO
6bDe+xTDvbrMEDXrf3rjLSM=
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEA9LXJjHsTtP7mBbg75
1ARAymIBJCDG7T+Med+QgdcEQBZzbzAKx+0/MmnBlZLcBECuk0tJ3sjtP39I
hZ+05gRA39QDe4bM7T/SXmhcMOkEQLaVdOtrze0/JHVLGazrBECMVuVbUc7t
P8qhEZOj8ARAOtjGPBzQ7T8U+52GkvoEQJTbif6x0+0/qK22bXAOBUBI4g+C
3drtP9AS6DssNgVAse8biTTp7T8h3UrYo4UFQIMKNJfiBe4/isI7r1WIBUDM
0CiO2wbuP/KnLIYHiwVAFJcdhdQH7j/Ccg40a5AFQKUjB3PGCe4/ZAjSjzKb
BUDGPNpOqg3uP6gzWUfBsAVACW+ABnIV7j8uime23tsFQI7TzHUBJe4/lm9Y
jZDeBUDWmcFs+iXuP/9USWRC4QVAH2C2Y/Mm7j/QHysSpuYFQK/sn1HlKO4/
cbXubW3xBUDQBXMtySzuP7TgdSX8BgZAEzgZ5ZA07j86N4SUGTIGQJicZVQg
RO4/1mIZNp00BkD3aByeCEXuP3OOrtcgNwZAVjXT5/BF7j+s5dgaKDwGQBTO
QHvBR+4/HpQtoTZGBkCQ/xuiYkvuP7q/wkK6SAZA78vS60pM7j9X61fkPUsG
QE6YiTUzTe4/kEKCJ0VQBkAMMffIA0/uPwLx1q1TWgZAiGLS76RS7j+eHGxP
11wGQOcuiTmNU+4/O0gB8VpfBkBG+z+DdVTuP9hzlpLeYQZApcf2zF1V7j+F
gFGqyWMGQGaUfwkPVu4/uRwKFw==
                "]], LineBox[CompressedData["
1:eJwV0n0s1HEcB/Dz0Pc72VyG2yhCZrhKMutp+X5WHpY8VEcezvPluTg6ixzC
5I/QJQ+FiNWWO49ha4xVqy50mGcbTWyc5Ct5DGf9+uO9915/vre3WXjCjQh1
FotlxeR/u7qnmWvEIOCcdThf5kvJvMeDDmE8gvvXY2WDfpRkpxoErgsRODwR
T4b5U3L0tVR17y6C34OFeI2x394IZKYgiLrWKjDgU9IntZYXZCPw8do7HBBE
SfRYd7RuLoJDj3XclhhrqnsfLMlD0NdvmiIOpsTRP8OjMh/BJU/nkaoQSprx
8LC0FMEpj8L8uTBKim+JZ+RSBNpXTVW3IykJNBn4qzaM4L2L0/fMBEp0DJPa
O0cRzGnFgLGQkg96BonJEwgOKApqOxhbavGVymkEbrzxyI1ESlbW5scGlAhG
QmJXYkXMvp791hf7CJQpEtbNVEreiE7Gn7PBwJZNmR/PoWSjt2BWmIUhmJ0c
NVFKyZT2aPReDgYvDi8oroySj+5HVvIeYiDGdrx9xpJ+6W7VIwxm3GVHi+eU
2AzJ9RUlGOZcIjjCCkqCJ9VcraUYojN8PuOXlDgZXVG01WPwz7XvLGfM5Ut4
0ITBLV+35UQNJdtTJqG+bRi45YpKXi0lRTMXUnO7MSy3O4uqX1HyZSFZ9mMI
Q9Kyw7EzdZTUW3XZ3RnFIFjXM+xl/DRG8932OAbv3VWdICkloUtFn9jTGBy0
GneyZZTs0KbpiwsYtiwsh/obKJmx3RL0LGJQcjW/hjVSIhc6/vT+hWHy9GzX
OuPiP98241YxdEBVnVEzJWn2+ulbaxhkruLqBsbhIr5GziaGCs+AEmihxHZz
kV2+iyE9kJMV+Zb5j9HSZYEKg+SZqkbB+B/G1DNd
                "]], LineBox[CompressedData["
1:eJwV0GtI01EYBvA1FM/xskUqlqBt5cxGlJVKFnjeTGtIupyWkiG15iItUxpa
jbksKy9dwNwUTASRVChNNzVLyZzWtLL/BkqCF4KESjmyaitdWacPLw8/Hng+
vGLlBUUOn8fjSdj9z4/zAf0P+AjOd5a/NJooebI3pSMNIYh6XT3oYaakVmuI
nvNGMBW6ayCaWfVnc7xLiCBsvKCnljkpLs9aug7BmGStycq8U9+V4heIoEDX
0bHMvMrbnxUWjOD5Ntqa1U1JnUe2RhGGILUqr35jD+tPB0XbwhH4h8Q0yZlV
Fs4p34pgsp3XpmeOvHagOHk7guN2Q88cs/VvxBXZHgSqDYO2xl5Kfq5818cd
RlDcEoBEfZQcc1RUSTUIGiwDGlE/Jf6z3U38YQSf3cIU8RAld311ut5XCN4J
YtRHmb33JWSeG0XQJT5RUsHMr7P7TY4j0B5qbXcwf0tdutQ2hUBwH4RDFkq4
kQj5kSX2H2khpxyh5PbjendDMIarmXZFs5USNK2cVIRgyMn7lfuBucxb2ukl
wpBUEnrdd5QS7Zmn6kIJBv/mXJOGOVc8YUuIxPBwiR+QOEaJzCBoXUjE8Pbm
7on5N5R46krTYwsxrO+uydjynhKzY3H5xUUMxtlkVwazSp3ZeLAIQyDyMpQz
D8t3fE3Tsv2sy/YvzGWbZvT5NzAI1mQnP+IoiaqVSZy3MNyRBi1OM3/yMY9p
KzH4pHOVfjZKEpyVgRX3MOCWeGs+84+zrmfCagzlnFvdyNw8e+qksQaD14rZ
k2PuM5XN/DZiWAgvil1l/gf8QRaU
                "]], 
               LineBox[{{3.201275510204082, 0.9631914607948443}, {
                3.2049527235388684`, 0.9632882295668124}, {3.209886242298752, 
                0.9634180590078619}, {3.21975327981852, 0.963677717889961}, {
                3.2592214298975932`, 0.9647163534183577}, {
                3.3447619504179835`, 0.9669674197478416}, {3.398724489795918, 
                0.9683874865735768}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQLSLp8f68KbeD8qXYril/39kLehXpNPHxOBx5Ivc+
WeS9/YKD/NxWgjwOnJN/6q0F8g0s1778KMzj4Od4Je8bkO+n8WJZoiSPw425
ne86RN/bd7HFKTqq8Di8Cfvydq3Ye3uWw55iDFY8DsInT775LvHe/pu1IkNd
Ko9D8tqSV92y7+1bN++7Z5rB47Ai2l/rKpAvoh2z920Wj8NbTq0sObn39sZS
06tiC3gcytPuv9wA5Bf84PlqU83j0C3v9fKq/Hv7l1t+vPw9gcdh00T5F/JK
7+0rdKad2DyZx+G7/S/1TCCfY4nx8uxpPA42766kbwLy1SbnpdyezeNwzKvr
uYvye/ukwif3di3jcbjF/PVZpsp7+zu6Fy5X7uFxYCo79XSz2nv7+a8Fa5n3
8zjsECj2+AHkJ60MVus9yOOQt1p6tY060H6V6xULjvE43H6QU3AUyF/zSEJJ
6ySPw8Rq0cucGu/t3zzbLmBwisfBUqA8VRXIBwBux6c1
                "]], 
               LineBox[{{3.601275510204082, 0.9737081862820316}, {
                3.6044205455572738`, 0.9737673034879187}, {
                3.6068988062055514`, 0.9738138873346909}, {3.611855327502106, 
                0.9739070550282352}, {3.6316814126883257`, 
                0.9742797258024122}, {3.6713335830607647`, 
                0.9750250673507663}, {3.749078878861765, 
                0.9764864450913866}, {3.798724489795918, 
                0.9774196332668406}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyeewQCeAO8H9vf3aF7Kz+Xz4HSTOxRpy
hL6375jbmnDPj9/hTvShGmMgPyXoreq6QH6HBS/VTsQB+TJ79mzwDed30GD9
ELcVyO/qjz7Wk8TvYGnT1JMU9t4+w2zmR65KfofIVcue7wl/b6/UIuLBvozf
YVbb+7mFUe/t/1nU8F5fwe8QJxLycg6Qf/Pt40vLVvM7KC3aYXICyJ8QvjnW
bSO/w6q9jaflot/b/9cKKm7dw++w+4vwz9NA/p2L/fOYL/M73E6yCFGLfW+/
o+178uWr/A7zP8yZHwjkT7GO11x8g98huY7xdQ2Q771Ub4vTPX6HNzNPNV4G
8ndVnD3Z+JLf4c+FmPUNce/tp+ma9ge+4Xc4EHfw12ogv/DRnBDF9/wOLW9U
3a4D+Ro+OfcPfOF34OF4f0c3/r09C+OVJRO+8ztcmBqsEQnkP9hqnZXwi99h
ivKO4hYgf0/WYn2Dv/wOERtl9q8H8qfLc3/9/5/fQca+kes2kA8A83y3Pg==

                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$69897#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 cluster intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT4G4b557d5gPgRDGnDf
GVQ/Z+m/ZZPzPj8zn5icsxlkP2sCCupP804/S83Xsp0ZdD/uDi8sLvNeP1dk
972SGYQ/L5VBTR3zbj/dL4dDjRmUP1DYyt0U834/oBVPhooZpD/geQ+mEPOO
P4EIsyeJGbQ/qMoxig7znj8qR5GIsnC0P4j5j4JEeZ8/0oVv6dvHtD9oKO56
ev+fPyQDLKsudrU/FUPVNfOFoD/G/aQu1NK2P9WgkSZfkqE/DPOWNR+MuT9W
XAoIN6ujP5jdekO1/r4/WdP7yubcpz9BHFmk3lW/P8rqKscBIKg/6lo3BQit
vz86AlrDHGOoPx7seWOtLcA/GzG4u1LpqD9vaTYlANzAP9uOdKy+9ak/EmSv
qKU4wj9cSu2Nlg6sP1hZoa/w8cQ/sGBvKCMgsD/v21QKohrFPxrpenB3P7A/
hl4IZVNDxT+FcYa4y16wP7Njbxq2lMU/WYKdSHSdsD8Obj2FezfGPwKky2jF
GrE/pfDw3yxgxj9tLNewGTqxPzxzpDreiMY/17Ti+G1ZsT9qeAvwQNrGP6zF
+YgWmLE/xYLZWgZ9xz9W5yepZxWyP1wFjbW3pcc/wG8z8bs0sj/yh0AQac7H
Pyr4PjkQVLI/II2nxcsfyD//CFbJuJKyP7cPWyB9SMg/aZFhEQ2ysj9Okg57
LnHIP9QZbVlh0bI/fJd1MJHCyD+pKoTpCRCzPxMaKYtC68g/E7OPMV4vsz+q
nNzl8xPJP347m3myTrM/QB+QQKU8yT/ow6bBBm6zP9ehQ5tWZck/UkyyCVuN
sz+QO0vYzW/JPwRf+MVplbM/f+kqYQ==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT8Ur7vSRwu0PzKsEQYc
CMo/qim4vCeYtD/JLsVgzTDKP5r5pR2V67Q/YLF4u35Zyj+LyZN+Aj+1P422
33Dhqso/amlvQN3ltT/owK3bpk3LPyqpJsSSM7c/ntVJsTGTzD+pKJXL/c65
Pwv/gVxHHs8/qidy2tMFvz+YaVdeLEbPP3oa8kieV78/JNQsYBFuzz9GDXK3
aKm/Pz6p12Pbvc8/cvk4yn4mwD+5qZa1ty7QPw/fOKcTysA/7VPsvEvO0D9K
qjhhPRHCP1Wol8tzDdI/v0A41ZCfxD8lUe7ow4vUP6ptN703vMk/Gn9HOmeh
1D8AS4VMlOjJPxCtoIsKt9Q/WCjT2/AUyj/6CFMuUeLUPwLjbvqpbco/0MC3
c9441T9cWKY3HB/LP3owgf745dU/DEMVsgCCzD/ODxQULkDXP2wY86bJR88/
wz1tZdFV1z/C9UA2JnTPP7hrxrZ0a9c/GNOOxYKgzz+jx3hZu5bXP8aNKuQ7
+c8/eH/dnkjt1z+PAbEQV1XQPyLvpiljmtg/53boTckG0T8XHQB7BrDYP5Fl
j5X3HNE/DEtZzKnF2D88VDbdJTPRP/emC2/w8Ng/kzGEbIJf0T/s1GTAkwbZ
Pz0gK7SwddE/4gK+ETcc2T/pDtL73ovRP8xecLR9R9k/P+wfizu40T/CjMkF
IV3ZP+vaxtJpztE/t7oiV8Ry2T+VyW0amOTRP5Vq8rizhNk/U1nDqvr20T+7
jB3E
                "]], 
               
               Line[{{0.40127551020408164`, 0.2828841095261634}, {
                0.4029125240902338, 0.2840099105983874}, {
                0.40555387663264447`, 0.28582641169805567`}, {
                0.40678641731639764`, 0.286674049971052}, {
                0.40801895800015076`, 0.2875216882440483}, {
                0.41048403936765704`, 0.28921696479004094`}, {
                0.4154142021026696, 0.2926075178820262}, {
                0.42527452757269474`, 0.2993886240659968}, {0.444995178512745,
                 0.31295083643393795`}, {0.48443648039284554`, 
                0.34007526116982023`}, {0.5699233045152912, 
                0.39886594038897616`}, {0.5987244897959183, 
                0.4186729838994421}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z85RZuDkObaP/UmPQ+t
bec/jCQy/d343z8+4kLHinjnPxH1JG0DA+A/hp1If2iD5z/b17DblwngPxYU
VO8jmec/cJ3IuMAW4D82AWvPmsTnP5go+HISMeA/eNuYj4gb6D/rPlfntWXg
P/yP9A9kyeg/kGsV0PzO4D9ES/rHQdToP1pOoT6R1eA/jAYAgB/f6D8kMS2t
JdzgPx19C/Da9Og/ufZEik7p4D8+aiLQUSDpP+KBdESgA+E/hiUoiC8r6T+s
ZACzNArhP87gLUANNuk/dkeMIckQ4T9eVzmwyEvpPwsNpP7xHeE/f0RQkD93
6T80mNO4QzjhP8j/VUgdguk//3pfJ9g+4T8Qu1sA+4zpP8ld65VsReE/FwJG
qSaP6T+WRM4OvUbhP0inl4k=
                "]], 
               
               Line[{{0.8012755102040817, 0.5411484446719864}, {
                0.8024388112602567, 0.5415962551996663}, {0.8037652381656297, 
                0.5421068607125478}, {0.8064180919763757, 
                0.5431280717383107}, {0.8077445188817487, 
                0.5436386772511922}, {0.8090709457871217, 
                0.5441492827640737}, {0.8117237995978678, 
                0.5451704937898366}, {0.8170295072193599, 
                0.5472129158413626}, {0.8182677985372807, 
                0.5476895937275864}, {0.8195060898552016, 
                0.5481662716138103}, {0.8219826724910432, 
                0.549119627386258}, {0.8269358377627265, 
                0.5510263389311534}, {0.8368421683060933, 
                0.5548397620209442}, {0.8566548293928267, 
                0.5624666082005259}, {0.8962801515662935, 
                0.5777203005596891}, {0.9739717509693491, 
                0.6076275338939103}, {0.9987244897959183, 
                0.6171560535979097}}], 
               
               Line[{{1.0012755102040816`, 0.6181049625732646}, {
                1.1369227129030104`, 0.6668018389746967}, {
                1.1987244897959184`, 0.6889884630322718}}], 
               
               Line[{{1.2012755102040815`, 0.689821516842031}, {
                1.3058823930203434`, 0.720588247082108}, {1.3839420330101317`,
                 0.7435469647261634}, {1.3987244897959183`, 
                0.7478947461337477}}], 
               
               Line[{{1.4012755102040815`, 0.7486064278652638}, {
                1.547629076117258, 0.7872204742350898}, {1.5987244897959185`, 
                0.800701530612245}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T+awMJ7oqTpP/tq1Jsp
evs/xCTh+uaK6j9UNl2RLn/7P45WmHNVjeo/rAHmhjOE+z9XiE/sw4/qP16Y
93E9jvs/6+u93aCU6j/BxRpIUaL7PxGzmsBanuo/hyBh9HjK+z9dQVSGzrHq
PxPW7UzIGvw/9l3HEbbY6j9soXZCzR/8P8CPfook2+o/xGz/N9Ik/D+JwTUD
k93qP3YDESPcLvw/HCWk9G/i6j/ZMDT570L8P0PsgNcp7Oo/n4t6pRdr/D+P
ejqdnf/qP/hWA5sccPw/WazxFQwC6z9QIoyQIXX8PyLeqI56BOs/Armdeyt/
/D+1QReAVwnrP2XmwFE/k/w/2wj0YhET6z++sUlHRJj8P6U6q9t/Fes/Fn3S
PEmd/D9ubGJU7hfrP8gT5CdTp/w/AtDQRcsc6z8rQQf+Zrv8PyiXrSiFJus/
sKqrJ9jA/D8KjiEMKCnrPzQUUFFJxvw/64SV78or6z8MAaNUk8f8P2UBw81q
LOs/an3GhQ==
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAjpj2RAbS/D9dkWfvtTDrP8BQPc6c
1vw/n85RMEIy6z9FuuH3Ddz8P/y1SzMYNOs/To0qS/Dm/D+2hD85xDfrP3LZ
TZh5Ev0/nr8OUXRG6z+5cZQyjGn9P201rYDUY+s/R6IhZ7EX/j8MIerflJ7r
PzSYDibGHP4/I9AktUug6z8gjvvk2iH+Pzt/X4oCous/+nnVYgQs/j9q3dQ0
cKXrP61RiV5XQP4/yZm/iUus6z8TAfFV/Wj+P4YSlTMCuus/31/AREm6/j8A
BECHb9XrP8xVrQNev/4/F7N6XCbX6z+4S5rCcsT+Py9itTHd2Os/kjd0QJzO
/j9ewCrcStzrP0UPKDzv4v4/vXwVMSbj6z+rvo8zlQv/P3r16trc8Os/dx1f
IuFc/z/05pUuSgzsP2JQMFbcYf8/JNW2ZfgN7D9OgwGK12b/P1XD15ymD+w/
Jumj8c1w/z+2nxkLAxPsP9S06MC6hP8/eFid57sZ7D8wTHJflKz/P/vJpKAt
J+w/HH9Dk4+x/z8suMXX2yjsPweyFMeKtv8/XKbmDooq7D/eF7cugcD/P72C
KH3mLew/jOP7/W3U/z9/O6xZnzTsP3gWzTFp2f8/rynNkE027D9jSZ5lZN7/
P+AX7sf7N+w/Oq9AzVro/z9A9C82WDvsPybiEQFW7f8/ceJQbQY97D8RFeM0
UfL/P6HQcaS0Puw//Ee0aEz3/z/SvpLbYkDsPz801ofG+v8/NCyDKI9B7D+W
LCTY
                "]], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCAEBlUFEOaETsP0sj5TUa
CABAEpf+pK9G7D8iiYedEBIAQOx+2aLSSuw/0FTMbP0lAECfTo+eGFPsPyzs
VQvXTQBABu76laRj7D+4VEy/ilAAQOLXVMzDZOw/Q71Ccz5TAEC+wa4C42Xs
P1qOL9ulWABAdpVibyFo7D+JMAmrdGMAQOc8ykiebOw/5nS8ShJ5AEDHi5n7
l3XsP6D9IopNpABAiSk4YYuH7D8TD/AIxPoAQAtldSxyq+w/0r2Kh0n9AEBG
LPcyfqzsP5JsJQbP/wBAgfN4OYqt7D8SyloD2gQBQPiBfEair+w/EoXF/e8O
AUDlnoNg0rPsPxD7mvIbIwFAv9iRlDK87D8M50Xcc0sBQHNMrvzyzOw/zJXg
WvlNAUCuEzAD/83sP4xEe9l+UAFA6tqxCQvP7D8LorDWiVUBQGBptRYj0ew/
Cl0b0Z9fAUBNhrwwU9XsPwjT8MXLcwFAJ8DKZLPd7D+5s4Td/JYBQHL+dTFQ
7Ow/3Jy3Cg==
                "]], 
               
               Line[{{2.201275510204082, 0.9040895770072735}, {
                2.2025743146728987`, 0.9042019303350258}, {
                2.2039086887592343`, 0.9043173606193109}, {2.206577436931906, 
                0.9045482211878811}, {2.21191493327725, 0.9050099423250216}, {
                2.222589925967937, 0.9059333845993025}, {2.2439399113493117`, 
                0.9077802691478644}, {2.2866398821120604`, 
                0.911474038244988}, {2.3704807786936803`, 
                0.918726710959661}, {2.398724489795918, 0.9211699385636608}}], 
               
               Line[{{2.4012755102040817`, 0.9213850981569099}, {
                2.5334854370252864`, 0.9322501007936006}, {
                2.5987244897959183`, 0.9376114416354778}}], 
               
               Line[{{2.601275510204082, 0.9378266012287269}, {
                2.6902539155813803`, 0.9455236951194966}, {2.774462852749733, 
                0.9528082052551673}, {2.798724489795918, 
                0.9549069627851141}}], 
               Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAR0x7IgNpBkCiVsjWZ5DuP/XKjeJw
gQdAy+RBlXDx7j/cC9Vo/IMHQL0OKAZS8u4/wkwc74eGB0CuOA53M/PuP5DO
qvueiwdAkozaWPb07j8q0scUzZUHQFo0cxx8+O4/XtkBRymqB0Dpg6Sjh//u
P0QaSc20rAdA2q2KFGkA7z8rW5BTQK8HQMzXcIVKAe8/+NweYFe0B0CwKz1n
DQPvP5LgO3mFvgdAeNPVKpMG7z/G53Wr4dIHQAYjB7KeDe8/rCi9MW3VB0D4
TO0igA7vP5NpBLj41wdA6nbTk2EP7z9g65LED90HQM7Kn3UkEe8/+u6v3T3n
B0CVcjg5qhTvP+Av92PJ6QdAh5weqosV7z/HcD7qVOwHQHnGBBttFu8/lPLM
9mvxB0BdGtH8LxjvP3szFH338wdAT0S3bREZ7z9idFsDg/YHQEFund7yGe8/
L/bpD5r7B0AlwmnAtRvvPx8a60Nj/QdAWJIR9FMc7z++K7B4
                "]], 
               Line[CompressedData["
1:eJwV0HlIE2AUAPAxkr7PI8kDQ5jOYzGlUsOBzeN76pSlzqUzXRlSVhMrqpWY
OZaoC9NCIdRJml0KJpSVmgdBg2xYmGjHKkhjpeIFD8sZZlpffzwePx68KyD/
TOZxoUAgkPD4n+3TXs9ahAScplJL74mQPZKnd2kIAfv7saQqP2RmQ4PsqzMB
6Whr/yL3sfWghBV3Ar0WeWufP7KUuJPD5R4E1gbIVpEYWUTZk3Q3bwLx3bbK
Cu4NQXxusC+B0fZzhaoAZE2b8ooygwnM1nRGfg/k9aM+svHtBCrteZ3JQbz/
izGHOoSAX5SnuJM7vCLxgmoXgaxpg4s+GNnwX2mpMoqAham+bUiQ/fr9sywu
jYB5Get8Q5BlL1VfDS0ikJwnW8gIQ+Y52XtXOESgLcJyxxKNrNbVaOyzEpAN
UtOOGGTO0QrtqVcErAkaXRO3sOmtm22UwJxmJvRsLLIfGVhy/zOBncWuPf4M
2dhLqXof8vsHtdZLCciuPWheu+lLwZq4NB+zFxn5km/LFFHIGZG/6eA2OYc+
3iymMJdl6vJKQWYo6NfpJRRcdD5Fi9wnAj6MK8IpqK/ErjenIVM2bOlYSKLw
caTafU2NzMlYnrVHT2F2f2DkQDaynqXF1efnKRjHS6dEOfxfOu2t5GIKHqp3
9RXcQ+qweY2BQrTC5EjV8vmBE2WnL1Oo3T3zdPIAskizUuKoohD0MK4g8SCy
KZee14YaCv0hZp8OboWjxru6joJdrCzR5yJbLlwZdL9OobjlttTG3TZ55HBj
Pd9/2+on+SFkA92miT+NFFLaL1bd4P4H/vYJbg==
                "]], 
               Line[CompressedData["
1:eJwVx2tIU3EYgPG5IXn+B6Q2S/OWK5Ihbkzs8kHxvKYVmEozvFDbstkoL1M0
p6bg1IWTyA/KWjS2lC4uSSdI2YwSPTgtvAt5ie5plJgnJUtrXd4+PDz8xJqi
NC2fx+NJsP+vMjjTD9goyDhJj+5Uccyg9SP03aLA59JYrRJt1Jln5jopcEcE
83vQfNFXL1+WAqail5+r5phu0ymHeZCCFfGYxoDWeIaSg4YpsI+8Za+i2UX7
NckoBZ5QHyOLrnMdkybMUNDrzhAEn+YYL7Ujq2KJgmjRN8EEmteu7novJCBx
yrz3n+GYoeXZwpbtBCJWDYkp6CtyhUwZQEC6b8qoRfu7EjqfhxCIenSBb0HL
hiX3nkoIxAy5/n5HKxfX2pxxBFJfH/rp0nBMr9h0ozKPgN43k4s9yzHVWp76
oI5AueKuLB2d2H4x5FsRgUrzpk6HnpQX2HR6AoZA27Id/YlRWLNrCDSEv/v8
B71DHWQ5YiFgi8tf6NdyTIm1q1HIEmALDfOJ5zjmocdqYgcJtDQ6HUq0R11f
WzJMoKrjlb4Ubdqj0k+PEoheihHeRts6iKp5lsAd7UaS4DzHuPu0kcIvBEzK
4scDaCJWhLMcgZyq1svz6OPG2LCSNQJgnchaRb84KvKb/kFgY1a6HpbLMSuT
/b+a+DTknViS1qADPgSNbAugITkppyUuj2NUh7e4BwJpkOQ26zLQNx1rfcUh
NHg3DMQUoiMLnnVP7abhiXvXnB1dPH6/o3YvDdcXUtseoHvkrW1REhrKBNWl
Y+j49TJrk5QGWfzLrb/R9Zkac7ycBjqbfuOXzzFpKaHlFnSdaHPcH/0PM5Aj
0A==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQLSLp8f68KbeD2G/+MxnZ7+3D6lSaAi24HQwV3ngv
APJnP+CvYbTmdoh4m3j+NpD/wOl36UZbbof6XdeDxHPe22exX8oUdOZ2OBNy
OLIPyF+fuTf5oCu3w2dFy7sngfwvp1fEFnpwO0i9X5fAmvvevn5CfeBFX26H
9M5Z6TVA/hRJXcuJEdwOTPsKS7Py3tvv1e7gEMzjdrBQV5joVvDe3uyK+NlJ
BdwOGm89ROuA/A01yyeKFHM7SGwunLkVyF909piURAW3ww+7wwtVCt/bd+Sz
6so3cTvsCEvbxFT03j5oc1Og7jRuB/O2NZf3Fb+3f25VO8tzH7eD2VMLMfPy
9/aCXkU6TXw8DsaLA2er1723v6N74XLlHh4Hlc9MOia97+3fPNsuYHCKx4HF
K+lyct97ewBp24So
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAWIQvW7Tw47M8zwOAv8/iz/ue29vFr789d1kXofy4Dp9
n3nv7Xfz82++nsHrwLcyNfMCkH+s4Z7j6SJeB9sQk7s35r+3v51UG7+pjddh
5qqLR14ufG/Ppr57VsM6XoegcJ4p3Mve23sy59f93cDrIMfEsNEXyO+5r5RU
tZnX4dWaz2f7gXzBGV2aJTt4HRqZbrOLLH9vL8MZtSP9EK/D+rUrq2VWvLc3
ev3jqt81XgceFvdk3VXv7WPXmwnK/uN1OLqh0ch/3Xv7bVE/+C4w8Dl0qeu9
nQbk87Ht4mlm5nPwn3dr+T0g/0CMLcdLDj6Hm93Gsnnr39srcbn83yLM5/A2
7Sl774b39s9SAt/6aPI5iMp63j216b29nYDw6//aQPWTv04X2vzefvruKy82
6fE5zOdaFBQF5HsIRTyRMOFz0Pjx6/hLIH/V/rjbT+z4HGwur9nEsfW9fZ5U
zsmaED6HlE6BDrftwPA6qntcP5zPQZNhr1MfkC9f+P7Io0g+h3dlmX+vAvkV
MhsPTY3hc9j8VnSH7I739heOFx3wiOdzqEg5VJQK5GsUm+z7ncjnYHs7T3ct
kN/aELjqZDKfwxStvQp3gXwAG8zU1A==
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPELo5TvNyZtluTsCksPiiVbv0+tuHEZlrGU08mSkZWap8zJ
/dRMHXOYSOki0SEPFW5FeUiWdo6JblKWasV3WXKV6NMf7733cpIlhsSYCASC
Ldj/+0nShaanCfA9TQ3ebYzL3eTT2hdPQKIzXRuBnhpYbEpLJDBl/GQ8h1YJ
5fWT5wlYixtf3kYvvM6pup9JIGEazpi0My4oXayWXiJgRkRh9uiazZaVNjyB
Ms9V4IE+mnG1PCWXQL9CZy1Da91UhQeLCIicZa1daDlfmWWoJWCQZi/KOxhn
lWzhf0JDoECxTlKCvh6bYDPdQODQvbtlGnRzgLeatRConxvYO46ettZ1mzwl
kMnbpu7SMi6gQrDSVU/Aqa5q/iPa7pH02oU/BGJ+9s36P2Gc5rNDGZFQmMlb
8962i3FXbvBRE4EU1gdOvnBHnwyZEdUHU9hPWxp90Ru02sbDYRSKCyLkKehc
ZURvnozCvuJaRwM61qv0u2UqBeVNcaT6GeOECluxRTUFjybF253djFvac9Fq
tIbCsaTw5/7osZmpoeo6Cjm7t9ZFo/PDmo/7PqAw/lCfVoRedgtJ4rUUsjuE
9r/QBp2ywlRPYbi7M7yzh3GPcxai9SMUlngVjKFVPlJX9RsKLn6xLnPogKpt
LQcmKGT0U6NzL+PaU171Z32hIBqMLLmMLnb3VAZ/oxCk9Mi8hT77ofyIE6OQ
FmR+qg3tIol/1/mDwuCQxusr2mzF8J38BQrGwqyNZn2Mm2z1iYv6TUEYGmru
gNbGqbfv+EtBYuc664kucVw9v7xMIXl0cSQQ/Q/LkjHr
                "]]}, "Charting`Private`Tag$69897#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT75jXfEpfZfPgRDGnDf
GVQ/k5lrjAJSPT8zn5icsxlkP6MQIJ/CUU0/S83Xsp0ZdD8sTHqoolFdP1dk
972SGYQ/8WknrZJRbT/dL4dDjRmUP9P4fa+KUX0/oBVPhooZpD9EQKmwhlGN
P4EIsyeJGbQ//OM+sYRRnT8qR5GIsnC0Pz32uAao0J0/0oVv6dvHtD9+CDNc
y0+ePyQDLKsudrU/AS0nBxJOnz/G/aQu1NK2PwK7h65PpaA/DPOWNR+MuT8H
BHAE3aGiP5jdekO1/r4/EZZAsPeapj9BHFmk3lW/PzGf/VqJ2qY/6lo3BQit
vz9SqLoFGxqnPx7seWOtLcA/lLo0Wz6Zpz9vaTYlANzAPxbfKAaFl6g/EmSv
qKU4wj8aKBFcEpSqP1hZoa/w8cQ/JLrhBy2Nrj/v21QKohrFP6r39kSIyK4/
hl4IZVNDxT8vNQyC4wOvP7Njbxq2lMU/ObA2/Jl6rz8Obj2FezfGPyfTRXgD
NLA/pfDw3yxgxj/qcdAWsVGwPzxzpDreiMY/rRBbtV5vsD9qeAvwQNrGPzJO
cPK5qrA/xYLZWgZ9xz89yZpscCGxP1wFjbW3pcc/AGglCx4/sT/yh0AQac7H
P8IGsKnLXLE/II2nxcsfyD9IRMXmJpixP7cPWyB9SMg/CuNPhdS1sT9Okg57
LnHIP82B2iOC07E/fJd1MJHCyD9Tv+9g3Q6yPxMaKYtC68g/Fl56/4ossj+q
nNzl8xPJP9j8BJ44SrI/QB+QQKU8yT+bm4885meyP9ehQ5tWZck/XToa25OF
sj+QO0vYzW/JPyiZCuM1jbI/logjAg==
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAApPfnWmXDyT8eBk0UqP6yPzKsEQYc
CMo/0GQq5QyHsz/JLsVgzTDKPzmWq/PS17M/YLF4u35Zyj+ixywCmSi0P422
33Dhqso/cyovHyXKtD/owK3bpk3LPxbwM1k9DbY/ntVJsTGTzD9dez3NbZO4
Pwv/gVxHHs8/7JFQtc6fvT+YaVdeLEbPP+VyviT/7r0/JNQsYBFuzz/cUyyU
Lz6+Pz6p12Pbvc8/zhUIc5Dcvj+5qZa1ty7QP9nMXxipDMA/7VPsvEvO0D++
UBfWaknBP1Wol8tzDdI/hliGUe7Cwz8lUe7ow4vUPxhoZEj1tcg/Gn9HOmeh
1D8gSMye6ODIPxCtoIsKt9Q/LCg09dsLyT/6CFMuUeLUPz7oA6LCYck/0MC3
c9441T9maKP7jw3KP3owgf745dU/sGjiriplyz/ODxQULkDXP0hpYBVgFM4/
wz1tZdFV1z9SSchrUz/OP7hrxrZ0a9c/WikwwkZqzj+jx3hZu5bXP27p/24t
wM4/eH/dnkjt1z+UaZ/I+mvPPyLvpiljmtg/8DTvvcph0D8XHQB7BrDYP/Qk
I2lEd9A/DEtZzKnF2D/5FFcUvozQP/emC2/w8Ng/A/W+arG30D/MXnC0fUfZ
Pxa1jheYDdE/lWryuLOE2T8ZHzpKWErRP2GP+ag=
                "]], 
               
               Line[{{0.40127551020408164`, 0.2723348549946294}, {
                0.40801895800015076`, 0.27712625211288905`}, {
                0.41048403936765704`, 0.27887775729506453`}, {
                0.4154142021026696, 0.2823807676594156}, {
                0.42527452757269474`, 0.28938678838811766`}, {
                0.444995178512745, 0.3033988298455218}, {0.48443648039284554`,
                 0.3314229127603301}, {0.5699233045152912, 
                0.3921635509525941}, {0.5987244897959183, 
                0.4126275510204081}}], 
               
               Line[{{0.6012755102040817, 0.41422913150222496`}, {
                0.732138185275487, 0.48556404836445716`}, {0.7987244897959184,
                 0.5218610940616848}}], 
               
               Line[{{0.8012755102040817, 0.5231941460794844}, {
                0.8962801515662935, 0.5706964667605903}, {0.9739717509693491, 
                0.6095422664621181}, {0.9987244897959183, 
                0.6219186358754027}}], 
               
               Line[{{1.0012755102040816`, 0.6230502915451894}, {
                1.1369227129030104`, 0.6755753361992859}, {
                1.1382548904425511`, 0.67609117938189}, {1.1395870679820916`, 
                0.676607022564494}, {1.142251423061173, 0.6776387089297023}, {
                1.147580133219336, 0.6797020816601188}, {1.158237553535662, 
                0.6838288271209517}, {1.1795523941683133`, 
                0.6920823180426174}, {1.1987244897959184`, 
                0.6995060994322541}}], 
               
               Line[{{1.2012755102040815`, 0.7003548411845941}, {
                1.2234898928959086`, 0.7065347822342001}, {1.224797710358201, 
                0.7068986111522815}, {1.2274133452827862`, 
                0.7076262689884443}, {1.2326446151319568`, 
                0.7090815846607699}, {1.2431071548302977`, 
                0.7119922160054212}, {1.2640322342269796`, 
                0.7178134786947237}, {1.3058823930203434`, 
                0.7294560040733286}, {1.3839420330101317`, 
                0.7511718437697359}, {1.3987244897959183`, 
                0.7552842565597667}}], 
               
               Line[{{1.4012755102040815`, 0.7559939389289551}, {
                1.547629076117258, 0.7967088407243499}, {1.5489670042909665`, 
                0.7970810463065094}, {1.550304932464675, 
                0.7974532518886689}, {1.5529807888120917`, 
                0.7981976630529879}, {1.5583325015069254`, 
                0.7996864853816258}, {1.5690359268965925`, 
                0.8026641300389017}, {1.5703738550703008`, 
                0.8030363356210611}, {1.5717117832440093`, 
                0.8034085412032206}, {1.5743876395914262`, 
                0.8041529523675396}, {1.5797393522862597`, 
                0.8056417746961775}, {1.5904427776759271`, 
                0.8086194193534534}, {1.5917807058496356`, 
                0.8089916249356128}, {1.5931186340233439`, 
                0.8093638305177723}, {1.5957944903707606`, 
                0.8101082416820913}, {1.597132418544469, 
                0.8104804472642507}, {1.5984703467181776`, 
                0.8108526528464103}, {1.5987244897959185`, 
                0.8109233543041277}}], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAW2XDEdOe+T+geU+cCPjpPyiCgGbG
o/k/utXBG/j56T8ahNxRQan5P2IMRp4c/Ok//oeUKDe0+T+xeU6jZQDqP8SP
BNYiyvk/UFRfrfcI6j/frsSL0SH6P8q+otU/K+o/0O0E7DIn+j+eHoJbWi3q
P8AsRUyULPo/cX5h4XQv6j+gqsUMVzf6Pxc+IO2pM+o/YqbGjdxM+j9lvZ0E
FDzqP+adyI/nd/o/AbyYM+hM6j/tjMyT/c36Pze5jpGQbuo/+2rUmyl6+z+l
s3pN4bHqP1Q2XZEuf/s/VMtTsdez6j+sAeaGM4T7PwPjLBXOteo/Xpj3cT2O
+z9iEt/curnqP8HFGkhRovs/HnFDbJTB6j+HIGH0eMr7P5guDItH0eo/E9bt
TMga/D+MqZ3IrfDqP2yhdkLNH/w/O8F2LKTy6j/EbP830iT8P+rYT5Ca9Oo/
dgMRI9wu/D9ICAJYh/jqP9kwNPnvQvw/BWdm52AA6z+fi3qlF2v8P38kLwYU
EOs/+FYDmxxw/D8uPAhqChLrP1AijJAhdfw/3VPhzQAU6z8CuZ17K3/8PzyD
k5XtF+s/ZebAUT+T/D/54fckxx/rP76xSUdEmPw/qPnQiL0h6z8WfdI8SZ38
P1cRquyzI+s/yBPkJ1On/D+1QFy0oCfrPytBB/5mu/w/cp/AQ3ov6z+wqqsn
2MD8P+7Ct/WaMes/NBRQUUnG/D9o5q6nuzPrPwwBo1STx/w/JdnBrjw06z+4
ryLS
                "]], 
               
               Line[{{1.8012755102040816`, 0.850548565290778}, {
                1.8023956352454178`, 0.8507001611610341}, {
                1.8037242586975861`, 0.8508799748613275}, {
                1.8063815056019226`, 0.8512396022619144}, {
                1.8170104932192683`, 0.8526781118642619}, {
                1.8382684684539596`, 0.855555131068957}, {1.8807844189233422`,
                 0.8613091694783471}, {1.9601756422651684`, 
                0.8720538463216018}, {1.9987244897959184`, 
                0.8772709835814025}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDFLM6VZBXsPxMP8AjE
+gBAqdafAQCY7D/SvYqHSf0AQAB2hb1Tmew/kmwlBs//AEBYFWt5p5rsPxLK
WgPaBAFAB1Q28U6d7D8ShcX97w4BQGXRzOCdouw/EPua8hsjAUAhzPm/O63s
PwznRdxzSwFAmMFTfnfC7D/MleBa+U0BQPBgOTrLw+w/jER72X5QAUBHAB/2
HsXsPwuisNaJVQFA9j7qbcbH7D8KXRvRn18BQFS8gF0Vzew/CNPwxctzAUAP
t608s9fsP8iBi0RRdgFAZ1aT+AbZ7D+IMCbD1ngBQL71eLRa2uw/B45bwOF9
AUBtNEQsAt3sPwZJxrr3hwFAy7HaG1Hi7D/G92A5fYoBQCJRwNek4+w/hqb7
twKNAUB68KWT+OTsPwUEMbUNkgFAKC9xC6Dn7D/Essszk5QBQIDOVsfz6Ow/
ubOE3fyWAUA2Y0zdOOrsPxtbq8w=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUCuA8wQduzsP9o8REjf
ngFAATFtV1ft7D+vuuzgmqEBQEzjcsk+7uw/WrY9EhKnAUDhR36tDfDsP7Gt
33QAsgFACxGVdavz7D9enCM63ccBQF+jwgXn+uw/uHmrxJbzAUAHyB0mXgnt
P2s0u9kJSwJAWBHUZkwm7T/A0NWsuE0CQCGQMZ8vJ+0/FW3wf2dQAkDqDo/X
EijtP7+lJSbFVQJAfQxKSNkp7T8TF5BygGACQKMHwClmLe0/u/lkC/d1AkDt
/avsfzTtPwu/Dj3koAJAg+qDcrNC7T9gWykQk6MCQExp4aqWQ+0/tfdD40Gm
AkAW6D7jeUTtP18weYmfqwJAqeX5U0BG7T+zoePVWrYCQM7gbzXNSe0/W4S4
btHLAkAZ11v45lDtP6tJYqC+9gJArsMzfhpf7T80LCE+P/kCQLdyGG3uX+0/
vg7g27/7AkDAIf1bwmDtP9DTXRfBAANA0n/GOWpi7T/0XVmOwwoDQPU7WfW5
Ze0/fUAYLEQNA0D+6j3kjWbtPwYj18nEDwNABpoi02Fn7T8Z6FQFxhQDQBj4
67AJae0/PnJQfMgeA0A8tH5sWWztP8dUDxpJIQNARGNjWy1t7T9QN863ySMD
QE0SSEoBbu0/YvxL88ooA0BfcBEoqW/tP+veCpFLKwNAZx/2Fn1w7T90wcku
zC0DQHDO2gVRce0//qOIzEwwA0B5fb/0JHLtP1JNHneWMANAPqKtUz1y7T9K
qv5d
                "]], 
               Line[CompressedData["
1:eJwVz30s1HEcB/Dj+20rsUlqY5qFrVVntY4tcb6fpjx3HJKOdZKTLHdKuB4Q
W3cqD7OUx8sswnXL08lD2LnzcNV0pNLTajQ/Kl/MUpNKv/54773Xf+/39jhZ
mMScw+HsYPO/be38F0zuCPRWk4GqVEo01j6TJi8ESXi1bPUCJaMV3lEvfBEk
do0pF9MpOZ75ZzksAEF9gtKQnEHJlLjn1ngQAmYzf+0r6+8uB0wvQxFIpA3p
03JK7JrcfSdECE45Z0veXaIkzsB1+yBFcKKA6zOQRcnyN3tr5g6CiJPKv6UK
SkpUM8NV5QgUxQMjjkpKeCHa7PAqBF39Zqp61udajyzoahBsc7ri2ZFHCZVf
fV6pQTAzlSJ/fYOS6XVMvlCP4GK8aMm2iJJXji0beimC6tOuTHEpJe3hfqjk
EIYvyeMjNxsoyQvqvObgh8HGsqjEopGSGJ+d6+sCMHipA6OvszbnbbR6JMBQ
yPTPKtSUCGxMW99EYeCJm1GuhpLZ0chdDskYskILPOTNlDw2DmtqZRjq5/05
P1kX6vbvcT2PYTQfD6e1UOLWbO/mnYHB+cnliNRWSnKKPvJjczAYDybJpFpK
7AUJwtrb7B6eX118J/vv8MQ4twyD55j52c+sdXz/yPYKDBJZ3764LkoSXHdF
D1Vj6HjgrhN3U9JmOR8/24ghxsXlvaiHEgUWz6RoMCj0n2reshb9Np1ZeYih
KbYyMaqXEs5ci9RCi8FMZfPjaB8lwc/S5Nw+DPe3mG0S6ihxNDC/tDp2f1vP
hIn1UvexTL4Bw4pQflfQT8lQq3FtcBCD0yJPMsK6XO2RKzBiCC5c2B2sp2SO
6bDe+xTDvbrMEDXrf3rjLSM=
                "]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEA9LXJjHsTtP7mBbg75
1ARAymIBJCDG7T+Med+QgdcEQBZzbzAKx+0/MmnBlZLcBECuk0tJ3sjtP39I
hZ+05gRA39QDe4bM7T/SXmhcMOkEQLaVdOtrze0/JHVLGazrBECMVuVbUc7t
P8qhEZOj8ARAOtjGPBzQ7T8U+52GkvoEQJTbif6x0+0/qK22bXAOBUBI4g+C
3drtP9AS6DssNgVAse8biTTp7T8h3UrYo4UFQIMKNJfiBe4/isI7r1WIBUDM
0CiO2wbuP/KnLIYHiwVAFJcdhdQH7j/Ccg40a5AFQKUjB3PGCe4/ZAjSjzKb
BUDGPNpOqg3uP6gzWUfBsAVACW+ABnIV7j8uime23tsFQI7TzHUBJe4/lm9Y
jZDeBUDWmcFs+iXuP/9USWRC4QVAH2C2Y/Mm7j/QHysSpuYFQK/sn1HlKO4/
cbXubW3xBUDQBXMtySzuP7TgdSX8BgZAEzgZ5ZA07j86N4SUGTIGQJicZVQg
RO4/1mIZNp00BkD3aByeCEXuP3OOrtcgNwZAVjXT5/BF7j+s5dgaKDwGQBTO
QHvBR+4/HpQtoTZGBkCQ/xuiYkvuP7q/wkK6SAZA78vS60pM7j9X61fkPUsG
QE6YiTUzTe4/kEKCJ0VQBkAMMffIA0/uPwLx1q1TWgZAiGLS76RS7j+eHGxP
11wGQOcuiTmNU+4/O0gB8VpfBkBG+z+DdVTuP9hzlpLeYQZApcf2zF1V7j+F
gFGqyWMGQGaUfwkPVu4/uRwKFw==
                "]], 
               Line[CompressedData["
1:eJwV0n0s1HEcB/Dz0Pc72VyG2yhCZrhKMutp+X5WHpY8VEcezvPluTg6ixzC
5I/QJQ+FiNWWO49ha4xVqy50mGcbTWyc5Ct5DGf9+uO9915/vre3WXjCjQh1
FotlxeR/u7qnmWvEIOCcdThf5kvJvMeDDmE8gvvXY2WDfpRkpxoErgsRODwR
T4b5U3L0tVR17y6C34OFeI2x394IZKYgiLrWKjDgU9IntZYXZCPw8do7HBBE
SfRYd7RuLoJDj3XclhhrqnsfLMlD0NdvmiIOpsTRP8OjMh/BJU/nkaoQSprx
8LC0FMEpj8L8uTBKim+JZ+RSBNpXTVW3IykJNBn4qzaM4L2L0/fMBEp0DJPa
O0cRzGnFgLGQkg96BonJEwgOKApqOxhbavGVymkEbrzxyI1ESlbW5scGlAhG
QmJXYkXMvp791hf7CJQpEtbNVEreiE7Gn7PBwJZNmR/PoWSjt2BWmIUhmJ0c
NVFKyZT2aPReDgYvDi8oroySj+5HVvIeYiDGdrx9xpJ+6W7VIwxm3GVHi+eU
2AzJ9RUlGOZcIjjCCkqCJ9VcraUYojN8PuOXlDgZXVG01WPwz7XvLGfM5Ut4
0ITBLV+35UQNJdtTJqG+bRi45YpKXi0lRTMXUnO7MSy3O4uqX1HyZSFZ9mMI
Q9Kyw7EzdZTUW3XZ3RnFIFjXM+xl/DRG8932OAbv3VWdICkloUtFn9jTGBy0
GneyZZTs0KbpiwsYtiwsh/obKJmx3RL0LGJQcjW/hjVSIhc6/vT+hWHy9GzX
OuPiP98241YxdEBVnVEzJWn2+ulbaxhkruLqBsbhIr5GziaGCs+AEmihxHZz
kV2+iyE9kJMV+Zb5j9HSZYEKg+SZqkbB+B/G1DNd
                "]], 
               Line[CompressedData["
1:eJwV0GtI01EYBvA1FM/xskUqlqBt5cxGlJVKFnjeTGtIupyWkiG15iItUxpa
jbksKy9dwNwUTASRVChNNzVLyZzWtLL/BkqCF4KESjmyaitdWacPLw8/Hng+
vGLlBUUOn8fjSdj9z4/zAf0P+AjOd5a/NJooebI3pSMNIYh6XT3oYaakVmuI
nvNGMBW6ayCaWfVnc7xLiCBsvKCnljkpLs9aug7BmGStycq8U9+V4heIoEDX
0bHMvMrbnxUWjOD5Ntqa1U1JnUe2RhGGILUqr35jD+tPB0XbwhH4h8Q0yZlV
Fs4p34pgsp3XpmeOvHagOHk7guN2Q88cs/VvxBXZHgSqDYO2xl5Kfq5818cd
RlDcEoBEfZQcc1RUSTUIGiwDGlE/Jf6z3U38YQSf3cIU8RAld311ut5XCN4J
YtRHmb33JWSeG0XQJT5RUsHMr7P7TY4j0B5qbXcwf0tdutQ2hUBwH4RDFkq4
kQj5kSX2H2khpxyh5PbjendDMIarmXZFs5USNK2cVIRgyMn7lfuBucxb2ukl
wpBUEnrdd5QS7Zmn6kIJBv/mXJOGOVc8YUuIxPBwiR+QOEaJzCBoXUjE8Pbm
7on5N5R46krTYwsxrO+uydjynhKzY3H5xUUMxtlkVwazSp3ZeLAIQyDyMpQz
D8t3fE3Tsv2sy/YvzGWbZvT5NzAI1mQnP+IoiaqVSZy3MNyRBi1OM3/yMY9p
KzH4pHOVfjZKEpyVgRX3MOCWeGs+84+zrmfCagzlnFvdyNw8e+qksQaD14rZ
k2PuM5XN/DZiWAgvil1l/gf8QRaU
                "]], 
               
               Line[{{3.201275510204082, 0.9631914607948443}, {
                3.2049527235388684`, 0.9632882295668124}, {3.209886242298752, 
                0.9634180590078619}, {3.21975327981852, 0.963677717889961}, {
                3.2592214298975932`, 0.9647163534183577}, {
                3.3447619504179835`, 0.9669674197478416}, {3.398724489795918, 
                0.9683874865735768}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQB2IQLSLp8f68KbeD8qXYril/39kLehXpNPHxOBx5Ivc+
WeS9/YKD/NxWgjwOnJN/6q0F8g0s1778KMzj4Od4Je8bkO+n8WJZoiSPw425
ne86RN/bd7HFKTqq8Di8Cfvydq3Ye3uWw55iDFY8DsInT775LvHe/pu1IkNd
Ko9D8tqSV92y7+1bN++7Z5rB47Ai2l/rKpAvoh2z920Wj8NbTq0sObn39sZS
06tiC3gcytPuv9wA5Bf84PlqU83j0C3v9fKq/Hv7l1t+vPw9gcdh00T5F/JK
7+0rdKad2DyZx+G7/S/1TCCfY4nx8uxpPA42766kbwLy1SbnpdyezeNwzKvr
uYvye/ukwif3di3jcbjF/PVZpsp7+zu6Fy5X7uFxYCo79XSz2nv7+a8Fa5n3
8zjsECj2+AHkJ60MVus9yOOQt1p6tY060H6V6xULjvE43H6QU3AUyF/zSEJJ
6ySPw8Rq0cucGu/t3zzbLmBwisfBUqA8VRXIBwBux6c1
                "]], 
               
               Line[{{3.601275510204082, 0.9737081862820316}, {
                3.6044205455572738`, 0.9737673034879187}, {
                3.6068988062055514`, 0.9738138873346909}, {3.611855327502106, 
                0.9739070550282352}, {3.6316814126883257`, 
                0.9742797258024122}, {3.6713335830607647`, 
                0.9750250673507663}, {3.749078878861765, 
                0.9764864450913866}, {3.798724489795918, 
                0.9774196332668406}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyeewQCeAO8H9vf3aF7Kz+Xz4HSTOxRpy
hL6375jbmnDPj9/hTvShGmMgPyXoreq6QH6HBS/VTsQB+TJ79mzwDed30GD9
ELcVyO/qjz7Wk8TvYGnT1JMU9t4+w2zmR65KfofIVcue7wl/b6/UIuLBvozf
YVbb+7mFUe/t/1nU8F5fwe8QJxLycg6Qf/Pt40vLVvM7KC3aYXICyJ8QvjnW
bSO/w6q9jaflot/b/9cKKm7dw++w+4vwz9NA/p2L/fOYL/M73E6yCFGLfW+/
o+178uWr/A7zP8yZHwjkT7GO11x8g98huY7xdQ2Q771Ub4vTPX6HNzNPNV4G
8ndVnD3Z+JLf4c+FmPUNce/tp+ma9ge+4Xc4EHfw12ogv/DRnBDF9/wOLW9U
3a4D+Ro+OfcPfOF34OF4f0c3/r09C+OVJRO+8ztcmBqsEQnkP9hqnZXwi99h
ivKO4hYgf0/WYn2Dv/wOERtl9q8H8qfLc3/9/5/fQca+kes2kA8A83y3Pg==

                "]]}, 
              "Charting`Private`Tag$69897#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 cluster intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.8580523161810007`*^9},
 CellLabel->
  "Out[309]=",ExpressionUUID->"03684d05-0e1d-48f4-ada9-5b0a2787530e"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D9G5DsoRTxxP5in1AHT
HfA/+aBJzoetgz8KIYQn3zjwP6KhZB4Fw5I/yDyRL35F8D/rxQ5i7eyWP4ZY
njcdUvA/NOq4pdUWmz8CkLhHW2vwP2OZhhZTtaE/+v7sZ9ed8D/04dqdIwmq
P7ga+m92qvA/GfSvvxcerD92Ngd4FbfwPz0GheELM64/8m0hiFPQ8D9DlZcS
ei6xP+vcVajPAvE/oblBVmJYtT+q+GKwbg/xP8hCLGfcYrY/aBRwuA0c8T/b
yxZ4Vm23P+RLishLNfE//93rmUqCuT+iZ5fQ6kHxPxFn1qrEjLo/YIOk2IlO
8T8k8MC7Ppe7P9y6vujHZ/E/SAKW3TKsvT+a1svwZnTxP1qLgO6str4/WPLY
+AWB8T9sFGv/JsG/PzccMe2JjPE/74BALCRawD+w86N3
                "]], 
               LineBox[{{1.2031887755102042`, 0.13195876288659794`}, {
                1.296811224489796, 0.13195876288659794`}}], 
               LineBox[{{1.403188775510204, 0.13195876288659794`}, {
                1.4968112244898326`, 0.13195876288659794`}}], 
               LineBox[{{1.6031887755102041`, 0.13195876288659794`}, {
                1.6968112244897962`, 0.13195876288659794`}}], 
               LineBox[{{1.803188775510204, 0.13195876288659794`}, {
                1.883402539403638, 0.13195876288659794`}, {
                1.8968112244897959`, 0.13195876288659794`}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAEApkMaD287BPxEURJl8
DABAs8qLEQilwj8eqUcsRxMAQJzkcAw9mcM/ONNOUtwgAEBsGDsCp4HFP0Vo
UuWmJwBAVTIg/dt1xj9S/VV4cS4AQD1MBfgQasc/bCddngY8AEAOgM/telLJ
P6F7a+owVwBA0+dj2U4jzT8wwAn4h10AQGAvj9VJB84/wASoBd9jAEAQd7rR
ROvOP+CN5CCNcABAOYMIZZ1Z0D8eoF1X6YkAQHYSX12TIdI/ruT7ZECQAEBO
tnTbkJPSPz0pmnKXlgBAFVqKWY4F0z9cstaNRaMAQLShtVWJ6dM/7PZ0m5yp
AECMRcvThlvUP3s7E6nzrwBAUungUYTN1D+axE/EobwAQPEwDE5/sdU/Kgnu
0fjCAEDJ1CHMfCPWPxqOmPZExgBAuR1w+MVe1j8KRI94
                "]], 
               LineBox[{{2.2031887755102044`, 0.3567010309278351}, {
                2.2968112244897956`, 0.3567010309278351}}], 
               LineBox[{{2.403188775510204, 0.3567010309278351}, {
                2.4968112244897127`, 0.3567010309278351}}], 
               LineBox[{{2.6031887755102043`, 0.3567010309278351}, {
                2.6968112244897955`, 0.3567010309278351}}], 
               LineBox[{{2.8031887755102045`, 0.3567010309278351}, {
                2.8955938838391537`, 0.3567010309278351}, {
                2.8968112244897957`, 0.3567010309278351}}], 
               LineBox[{{3.0031887755102042`, 0.3633415737428996}, {
                3.005498530851262, 0.36815157971087525`}, {
                3.0088289747001133`, 0.3750871431899268}, {3.015489862397817, 
                0.3889582701480309}, {3.028811637793224, 0.41670052406424}, {
                3.0554551885840384`, 0.4721850318966573}, {3.05872473223977, 
                0.4789937722931291}, {3.0619942758955014`, 
                0.4858025126896009}, {3.0685333632069645`, 
                0.4994199934825445}, {3.071802906862696, 
                0.5062287338790163}, {3.0750724505184275`, 
                0.5130374742754881}, {3.0816115378298905`, 
                0.5266549550684316}, {3.084881081485622, 
                0.5334636954649035}, {3.0881506251413535`, 
                0.5402724358613753}, {3.091420168797085, 
                0.5470811762578471}, {3.0946897124528165`, 
                0.5538899166543189}, {3.0968112244897954`, 
                0.5583079107931821}}], 
               LineBox[{{3.2031887755102044`, 0.5649484536082475}, {
                3.264705982550857, 0.5649484536082475}, {3.296811224489796, 
                0.5649484536082475}}], 
               LineBox[{{3.403188775510204, 0.5649484536082475}, {
                3.4968112244897442`, 0.5649484536082475}}], 
               LineBox[{{3.6031887755102043`, 0.5649484536082475}, {
                3.6968112244897955`, 0.5649484536082475}}], 
               LineBox[{{3.8031887755102045`, 0.5649484536082475}, {
                3.8968112244897957`, 0.5649484536082475}}], 
               LineBox[{{4.003188775510204, 0.5700767936040398}, {
                4.006210328098253, 0.5749361977662624}, {4.009555148532524, 
                0.5803154966090074}, {4.016244789401066, 
                0.5910740942944975}, {4.02962407113815, 0.6125912896654777}, {
                4.032968891572421, 0.6179705885082227}, {4.036313712006692, 
                0.6233498873509677}, {4.043003352875234, 
                0.6341084850364579}, {4.0563826346123175`, 
                0.6556256804074381}, {4.0597274550465885`, 
                0.6610049792501832}, {4.0630722754808595`, 
                0.6663842780929282}, {4.069761916349401, 
                0.6771428757784184}, {4.083141198086486, 0.6986600711494}, {
                4.086425118327638, 0.7039414274135197}, {4.089709038568788, 
                0.7092227836776381}, {4.092992958809939, 
                0.7145041399417564}, {4.096276879051089, 
                0.7197854962058748}, {4.096811224489796, 
                0.7206448558804964}}], 
               LineBox[{{4.2031887755102035`, 0.7257731958762887}, {
                4.293312093520136, 0.7257731958762887}, {4.2968112244897965`, 
                0.7257731958762887}}], 
               LineBox[{{4.403188775510205, 0.7257731958762887}, {
                4.496811224489796, 0.7257731958762887}}], 
               LineBox[{{5.003188775510204, 0.7293893330528081}, {
                5.009890606535029, 0.7369893476170422}, {5.0129309260036985`, 
                0.7404371325815129}, {5.015971245472368, 
                0.7438849175459836}, {5.0220518844097075`, 
                0.7507804874749252}, {5.046374440159067, 
                0.7783627671906934}, {5.049414759627736, 
                0.7818105521551642}, {5.052455079096406, 0.785258337119635}, {
                5.058535718033746, 0.7921539070485775}, {5.070696995908426, 
                0.8059450469064616}, {5.0737373153770955`, 
                0.8093928318709324}, {5.076777634845765, 
                0.8128406168354032}, {5.0828582737831045`, 
                0.8197361867643447}, {5.085898593251774, 
                0.8231839717288155}, {5.088938912720444, 
                0.8266317566932863}, {5.091979232189114, 
                0.8300795416577581}, {5.095019551657784, 
                0.8335273266222288}, {5.096811224489796, 
                0.8355591205554386}}], 
               LineBox[{{5.303188775510205, 0.8391752577319589}, {
                5.396811224489795, 0.8391752577319589}}], 
               LineBox[{{5.503188775510205, 0.8391752577319589}, {
                5.596811224489844, 0.8391752577319589}}], 
               LineBox[{{5.703188775510205, 0.8391752577319589}, {
                5.796811224489689, 0.8391752577319589}}], 
               LineBox[{{5.903188775510205, 0.8391752577319589}, {
                5.950639515166904, 0.8391752577319589}, {5.975077083599616, 
                0.8391752577319589}, {5.987295867815972, 
                0.8391752577319589}, {5.996811224489797, 
                0.8391752577319589}}], 
               LineBox[{{6.103188775510205, 0.9051546391752578}, {
                6.109483709979536, 0.9051546391752578}, {6.115593102087713, 
                0.9051546391752578}, {6.121702494195891, 
                0.9051546391752578}, {6.196811224489796, 
                0.9051546391752578}}], 
               LineBox[{{6.303188775510205, 0.9051546391752578}, {
                6.396811224489711, 0.9051546391752578}}], 
               LineBox[{{6.503188775510206, 0.9051546391752578}, {
                6.596811224489708, 0.9051546391752578}}], 
               LineBox[{{6.703188775510205, 0.9051546391752578}, {
                6.796811224489702, 0.9051546391752578}}], 
               LineBox[{{6.903188775510205, 0.9051546391752578}, {
                6.9607097129903845`, 0.9051546391752578}, {6.985262294106451, 
                0.9051546391752578}, {6.991400439385467, 
                0.9051546391752578}, {6.996811224489796, 
                0.9051546391752578}}], 
               LineBox[{{7.103188775510205, 0.9278350515463919}, {
                7.120301490244817, 0.9278350515463919}, {7.13257778080285, 
                0.9278350515463919}, {7.196811224489797, 
                0.9278350515463919}}], 
               LineBox[{{7.303188775510205, 0.9278350515463919}, {
                7.396811224489726, 0.9278350515463919}}], 
               LineBox[{{7.503188775510206, 0.9278350515463919}, {
                7.596811224489726, 0.9278350515463919}}], 
               LineBox[{{7.703188775510205, 0.9278350515463919}, {
                7.796811224489718, 0.9278350515463919}}], 
               LineBox[{{7.903188775510205, 0.9278350515463919}, {
                7.9630466212483135`, 0.9278350515463919}, {7.975380418148024, 
                0.9278350515463919}, {7.981547316597879, 
                0.9278350515463919}, {7.987714215047735, 
                0.9278350515463919}, {7.990797664272662, 
                0.9278350515463919}, {7.99388111349759, 0.9278350515463919}, {
                7.996811224489796, 0.9278350515463919}}], 
               LineBox[{{8.103188775510203, 0.9608247422680414}, {
                8.111052184044837, 0.9608247422680414}, {8.117219082494692, 
                0.9608247422680414}, {8.123385980944548, 
                0.9608247422680414}, {8.135719777844258, 
                0.9608247422680414}, {8.148053574743969, 
                0.9608247422680414}, {8.196811224489798, 
                0.9608247422680414}}], 
               LineBox[{{8.303188775510204, 0.9608247422680414}, {
                8.396811224489747, 0.9608247422680414}}], 
               LineBox[{{8.503188775510203, 0.9608247422680414}, {
                8.596811224489795, 0.9608247422680414}}], 
               LineBox[{{8.703188775510204, 0.9608247422680414}, {
                8.796811224489796, 0.9608247422680414}}], 
               LineBox[{{8.903188775510204, 0.9608247422680414}, {
                8.986268757410393, 0.9608247422680414}, {8.992464409031086, 
                0.9608247422680414}, {8.995562234841433, 
                0.9608247422680414}, {8.996811224489797, 
                0.9608247422680414}}], 
               LineBox[{{9.103188775510205, 0.9814432989690723}, {
                9.116377441444957, 0.9814432989690723}, {9.128768744686345, 
                0.9814432989690723}, {9.15355135116912, 0.9814432989690723}, {
                9.178333957651894, 0.9814432989690723}, {9.196811224489796, 
                0.9814432989690723}}], 
               LineBox[{{9.303188775510204, 0.9814432989690723}, {
                9.396811224489795, 0.9814432989690723}}], 
               LineBox[{{9.5031887755102, 0.9814432989690723}, {
                9.596811224489798, 0.9814432989690723}}], 
               LineBox[{{9.7031887755102, 0.9814432989690723}, {
                9.796811224489797, 0.9814432989690723}}], 
               LineBox[{{1.1031887755102041`, 0.13195876288659794`}, {
                1.1124879462818624`, 0.13195876288659794`}, {
                1.161789573631988, 0.13195876288659794`}, {
                1.1968112244897962`, 0.13195876288659794`}}], 
               LineBox[{{1.303188775510204, 0.13195876288659794`}, {
                1.3968112244897959`, 0.13195876288659794`}}], 
               LineBox[{{1.7031887755102042`, 0.13195876288659794`}, {
                1.796811224489796, 0.13195876288659794`}}], 
               LineBox[{{1.903188775510204, 0.13195876288659794`}, {
                1.9629881537260188`, 0.13195876288659794`}, {
                1.989516691833479, 0.13195876288659794`}, {
                1.9928327590969115`, 0.13195876288659794`}, {
                1.9961488263603442`, 0.13195876288659794`}, {
                1.996811224489796, 0.13195876288659794`}}], 
               LineBox[{{2.103188775510204, 0.3567010309278351}, {
                2.110679790534046, 0.3567010309278351}, {2.11687124712365, 
                0.3567010309278351}, {2.1292541603028585`, 
                0.3567010309278351}, {2.141637073482067, 
                0.3567010309278351}, {2.1911687261989004`, 
                0.3567010309278351}, {2.196811224489796, 
                0.3567010309278351}}], 
               LineBox[{{2.303188775510204, 0.3567010309278351}, {
                2.3968112244897957`, 0.3567010309278351}}], 
               LineBox[{{2.703188775510204, 0.3567010309278351}, {
                2.796811224489796, 0.3567010309278351}}], 
               LineBox[{{2.903188775510204, 0.3567010309278351}, {
                2.962202760816189, 0.3567010309278351}, {2.975524536211596, 
                0.3567010309278351}, {2.9821854239092995`, 
                0.3567010309278351}, {2.988846311607003, 
                0.3567010309278351}, {2.992176755455855, 
                0.3567010309278351}, {2.9955071993047064`, 
                0.3567010309278351}, {2.9968112244897958`, 
                0.3567010309278351}}], 
               LineBox[{{3.103188775510204, 0.5649484536082475}, {
                3.107767887075743, 0.5649484536082475}, {3.1339242363215956`, 
                0.5649484536082475}, {3.1600805855674476`, 
                0.5649484536082475}, {3.196811224489796, 
                0.5649484536082475}}], 
               LineBox[{{3.3031887755102045`, 0.5649484536082475}, {
                3.3968112244897957`, 0.5649484536082475}}], 
               LineBox[{{3.703188775510204, 0.5649484536082475}, {
                3.796811224489796, 0.5649484536082475}}], 
               LineBox[{{3.903188775510204, 0.5649484536082475}, {
                3.976106944189814, 0.5649484536082475}, {3.982796585058356, 
                0.5649484536082475}, {3.989486225926898, 
                0.5649484536082475}, {3.992831046361169, 
                0.5649484536082475}, {3.99617586679544, 0.5649484536082475}, {
                3.9968112244897958`, 0.5649484536082475}}], 
               LineBox[{{4.103188775510205, 0.7257731958762887}, {
                4.106128639774543, 0.7257731958762887}, {4.109412560015693, 
                0.7257731958762887}, {4.122548240980296, 
                0.7257731958762887}, {4.135683921944899, 
                0.7257731958762887}, {4.161955283874105, 
                0.7257731958762887}, {4.1882266458033115`, 
                0.7257731958762887}, {4.196811224489795, 
                0.7257731958762887}}], 
               LineBox[{{4.303188775510205, 0.7257731958762887}, {
                4.396811224489796, 0.7257731958762887}}], 
               LineBox[{{5.403188775510204, 0.8391752577319589}, {
                5.496811224489797, 0.8391752577319589}}], 
               LineBox[{{6.003188775510205, 0.8412791920892071}, {
                6.011733436248685, 0.8469169063908843}, {6.023952220465041, 
                0.8549787846367278}, {6.027006916519131, 
                0.8569942541981891}, {6.03006161257322, 0.8590097237596497}, {
                6.036171004681398, 0.8630406628825714}, {6.048389788897754, 
                0.8711025411284143}, {6.051444484951842, 
                0.8731180106898749}, {6.054499181005932, 
                0.8751334802513362}, {6.060608573114109, 
                0.8791644193742574}, {6.072827357330466, 
                0.8872262976201009}, {6.0758820533845554`, 
                0.8892417671815621}, {6.078936749438644, 
                0.8912572367430227}, {6.085046141546822, 
                0.8952881758659444}, {6.088100837600912, 
                0.8973036454274056}, {6.091155533655001, 
                0.8993191149888662}, {6.094210229709089, 
                0.9013345845503268}, {6.096811224489796, 
                0.9030507048180096}}], 
               LineBox[{{6.203188775510204, 0.9051546391752578}, {
                6.2968112244897965`, 0.9051546391752578}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEBTZ2iU8/zsP1BhIOkM
ChxA9KRePEMJ7T/U1xpzMQ0cQB3wkwT3Du0/WE4V/VUQHEBHO8nMqhTtP187
ChGfFhxAmNEzXRIg7T9uFfQ4MSMcQD3+CH7hNu0/8ovuwlUmHEBmST5GlTzt
P3UC6Ux6KRxAjpRzDklC7T98791gwy8cQOAq3p6wTe0/i8nHiFU8HECEV7O/
f2TtPw5AwhJ6PxxArKLohzNq7T+StrycnkIcQNXtHVDnb+0/mqOxsOdIHEAp
hIjgTnvtP6h9m9h5VRxAy7BdAR6S7T8s9JVinlgcQPX7ksnRl+0/sGqQ7MJb
HEAeR8iRhZ3tPzThinbnXhxASJL9WTmj7T+3V4UADGIcQHDdMiLtqO0/DkdM
eyJjHEBIWIlq5qrtPx+6ikE=
                "]], 
               LineBox[{{7.203188775510205, 0.9278350515463919}, {
                7.2968112244897965`, 0.9278350515463919}}], 
               LineBox[{{8.003188775510203, 0.9288870187250157}, {
                8.012381808847156, 0.9319197719908144}, {8.024715605746866, 
                0.9359886534422655}, {8.049383199546286, 
                0.9441264163451667}, {8.052466648771212, 
                0.9451436367080288}, {8.05555009799614, 0.9461608570708916}, {
                8.061716996445995, 0.948195297796617}, {8.074050793345705, 
                0.9522641792480679}, {8.077134242570633, 
                0.9532813996109307}, {8.08021769179556, 0.9542986199737934}, {
                8.086384590245416, 0.9563330606995188}, {8.089468039470344, 
                0.9573502810623816}, {8.092551488695271, 
                0.9583675014252444}, {8.095634937920199, 
                0.9593847217881071}, {8.096811224489796, 
                0.9597727750894176}}], 
               LineBox[{{8.203188775510204, 0.9608247422680414}, {
                8.296811224489797, 0.9608247422680414}}], 
               LineBox[{{9.003188775510203, 0.9614822217546812}, {
                9.011051363893166, 0.9631033739985911}, {9.01724701551386, 
                0.9643808279410021}, {9.029638318755246, 0.966935735825824}, {
                9.032736144565593, 0.9675744627970295}, {9.03583397037594, 
                0.968213189768235}, {9.042029621996633, 0.9694906437106461}, {
                9.054420925238022, 0.9720455515954683}, {9.079203531720797, 
                0.9771553673651127}, {9.082301357531144, 
                0.9777940943363181}, {9.08539918334149, 0.9784328213075236}, {
                9.088497009151837, 0.9790715482787291}, {9.091594834962184, 
                0.9797102752499346}, {9.09469266077253, 0.9803490022211401}, {
                9.096811224489798, 0.9807858194824325}}], 
               LineBox[{{9.203188775510203, 0.9814432989690723}, {
                9.296811224489797, 0.9814432989690723}}], 
               LineBox[{{9.803188775510204, 0.9814432989690723}, {
                9.896811224489785, 0.9814432989690723}}], 
               LineBox[{{4.903188775510205, 0.7257731958762887}, {
                4.996811224489796, 0.7257731958762887}}], 
               LineBox[{{5.103188775510205, 0.8391752577319589}, {
                5.108212738964064, 0.8391752577319589}, {5.114809332617204, 
                0.8391752577319589}, {5.121405926270344, 
                0.8391752577319589}, {5.134599113576624, 
                0.8391752577319589}, {5.147792300882904, 
                0.8391752577319589}, {5.174178675495464, 
                0.8391752577319589}, {5.196811224489796, 
                0.8391752577319589}}], 
               LineBox[{{5.203188775510204, 0.8391752577319589}, {
                5.2968112244897965`, 0.8391752577319589}}]},
              Annotation[#, "Charting`Private`Tag$70072#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D+lDAnFcrNqP5in1AHT
HfA/5pqbjBh8fj8KIYQn3zjwP5YqQl3LEI0/yDyRL35F8D93WXBIC8KRP4ZY
njcdUvA/pJ0/4rD7lD8CkLhHW2vwP/0l3hX8bps/+v7sZ9ed8D9Xm40+ySqk
P7ga+m92qvA/bj11C5zHpT92Ngd4FbfwP4TfXNhuZKc/8m0hiFPQ8D+wIyxy
FJ6qP+vcVajPAvE/FVbl0q+IsD+q+GKwbg/xPzEnWTkZV7E/aBRwuA0c8T88
+MyfgiWyP+RLishLNfE/Upq0bFXCsz+iZ5fQ6kHxP11rKNO+kLQ/YIOk2IlO
8T9oPJw5KF+1P9y6vujHZ/E/ft6DBvv7tj+a1svwZnTxP4mv92xkyrc/WPLY
+AWB8T+VgGvTzZi4PzccMe2JjPE/9aoOsCFVuT9AOqKX
                "]], 
               LineBox[{{1.2031887755102042`, 0.10221465076660988`}, {
                1.296811224489796, 0.10221465076660988`}}], 
               LineBox[{{1.403188775510204, 0.10221465076660988`}, {
                1.4968112244898326`, 0.10221465076660988`}}], 
               LineBox[{{1.6031887755102041`, 0.10221465076660988`}, {
                1.6968112244897962`, 0.10221465076660988`}}], 
               LineBox[{{1.803188775510204, 0.10221465076660988`}, {
                1.883402539403638, 0.10221465076660988`}, {
                1.8968112244897959`, 0.10221465076660988`}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAECAqJs9wkC8PxEURJl8
DABA6mtRpswnvj8eqUcsRxMAQPbSAW6RKcA/ONNOUtwgAED5DLSj51TCP0Vo
UuWmJwBA+imNvpJqwz9S/VV4cS4AQPxGZtk9gMQ/bCddngY8AED+gBgPlKvG
P6F7a+owVwBALPV8ekACyz8wwAn4h10AQCDAm2d4Bcw/wASoBd9jAEA+i7pU
sAjNP+CN5CCNcABAdyH4LiAPzz8eoF1X6YkAQMymufH/jdE/ruT7ZECQAEBb
DEnomw/SPz0pmnKXlgBA1XHY3jeR0j9cstaNRaMAQN4898tvlNM/7PZ0m5yp
AEBsoobCCxbUP3s7E6nzrwBA5gcWuaeX1D+axE/EobwAQO7SNKbfmtU/Kgnu
0fjCAEB9OMScexzWPxqOmPZExgBAkOeWX+Rf1j8RTpOn
                "]], 
               LineBox[{{2.2031887755102044`, 0.3577512776831345}, {
                2.2968112244897956`, 0.3577512776831345}}], 
               LineBox[{{2.403188775510204, 0.3577512776831345}, {
                2.4968112244897127`, 0.3577512776831345}}], 
               LineBox[{{2.6031887755102043`, 0.3577512776831345}, {
                2.6968112244897955`, 0.3577512776831345}}], 
               LineBox[{{2.8031887755102045`, 0.3577512776831345}, {
                2.8955938838391537`, 0.3577512776831345}, {
                2.8968112244897957`, 0.3577512776831345}}], 
               LineBox[{{3.0031887755102042`, 0.36622570663699927`}, {
                3.005498530851262, 0.37236406836110464`}, {
                3.0088289747001133`, 0.3812149923887168}, {3.015489862397817, 
                0.3989168404439423}, {3.028811637793224, 
                0.43432053655439457`}, {3.0554551885840384`, 
                0.5051279287752979}, {3.05872473223977, 0.5138170056116541}, {
                3.0619942758955014`, 0.5225060824480104}, {
                3.0685333632069645`, 0.539884236120723}, {3.071802906862696, 
                0.5485733129570793}, {3.0750724505184275`, 
                0.5572623897934357}, {3.0816115378298905`, 
                0.5746405434661482}, {3.084881081485622, 
                0.5833296203025046}, {3.0881506251413535`, 
                0.5920186971388609}, {3.091420168797085, 
                0.6007077739752171}, {3.0946897124528165`, 
                0.6093968508115735}, {3.0968112244897954`, 
                0.6150349407224542}}], 
               LineBox[{{3.2031887755102044`, 0.6235093696763202}, {
                3.264705982550857, 0.6235093696763202}, {3.296811224489796, 
                0.6235093696763202}}], 
               LineBox[{{3.403188775510204, 0.6235093696763202}, {
                3.4968112244897442`, 0.6235093696763202}}], 
               LineBox[{{3.6031887755102043`, 0.6235093696763202}, {
                3.6968112244897955`, 0.6235093696763202}}], 
               LineBox[{{3.8031887755102045`, 0.6235093696763202}, {
                3.8968112244897957`, 0.6235093696763202}}], 
               LineBox[{{4.003188775510204, 0.6278552306783021}, {
                4.006210328098253, 0.6319731899124399}, {4.009555148532524, 
                0.6365317186133203}, {4.016244789401066, 0.645648776015081}, {
                4.02962407113815, 0.6638828908186023}, {4.032968891572421, 
                0.6684414195194827}, {4.036313712006692, 0.672999948220363}, {
                4.043003352875234, 0.6821170056221237}, {4.0563826346123175`, 
                0.7003511204256452}, {4.0597274550465885`, 
                0.7049096491265255}, {4.0630722754808595`, 
                0.7094681778274059}, {4.069761916349401, 
                0.7185852352291666}, {4.083141198086486, 
                0.7368193500326893}, {4.086425118327638, 
                0.7412948801739518}, {4.089709038568788, 
                0.7457704103152132}, {4.092992958809939, 
                0.7502459404564745}, {4.096276879051089, 
                0.7547214705977359}, {4.096811224489796, 
                0.7554497096964847}}], 
               LineBox[{{4.2031887755102035`, 0.7597955706984667}, {
                4.293312093520136, 0.7597955706984667}, {4.2968112244897965`, 
                0.7597955706984667}}], 
               LineBox[{{4.403188775510205, 0.7597955706984667}, {
                4.496811224489796, 0.7597955706984667}}], 
               LineBox[{{5.003188775510204, 0.762891996662378}, {
                5.009890606535029, 0.7693997371805211}, {5.0129309260036985`, 
                0.7723520065112566}, {5.015971245472368, 0.775304275841992}, {
                5.0220518844097075`, 0.781208814503463}, {5.046374440159067, 
                0.8048269691493485}, {5.049414759627736, 
                0.8077792384800839}, {5.052455079096406, 
                0.8107315078108194}, {5.058535718033746, 
                0.8166360464722912}, {5.070696995908426, 
                0.8284451237952339}, {5.0737373153770955`, 
                0.8313973931259694}, {5.076777634845765, 
                0.8343496624567048}, {5.0828582737831045`, 
                0.8402542011181758}, {5.085898593251774, 
                0.8432064704489113}, {5.088938912720444, 
                0.8461587397796467}, {5.091979232189114, 
                0.8491110091103831}, {5.095019551657784, 
                0.8520632784411185}, {5.096811224489796, 
                0.8538030629628339}}], 
               LineBox[{{5.303188775510205, 0.8568994889267461}, {
                5.396811224489795, 0.8568994889267461}}], 
               LineBox[{{5.503188775510205, 0.8568994889267461}, {
                5.596811224489844, 0.8568994889267461}}], 
               LineBox[{{5.703188775510205, 0.8568994889267461}, {
                5.796811224489689, 0.8568994889267461}}], 
               LineBox[{{5.903188775510205, 0.8568994889267461}, {
                5.950639515166904, 0.8568994889267461}, {5.975077083599616, 
                0.8568994889267461}, {5.987295867815972, 
                0.8568994889267461}, {5.996811224489797, 
                0.8568994889267461}}], 
               LineBox[{{6.103188775510205, 0.9114139693356047}, {
                6.109483709979536, 0.9114139693356047}, {6.115593102087713, 
                0.9114139693356047}, {6.121702494195891, 
                0.9114139693356047}, {6.196811224489796, 
                0.9114139693356047}}], 
               LineBox[{{6.303188775510205, 0.9114139693356047}, {
                6.396811224489711, 0.9114139693356047}}], 
               LineBox[{{6.503188775510206, 0.9114139693356047}, {
                6.596811224489708, 0.9114139693356047}}], 
               LineBox[{{6.703188775510205, 0.9114139693356047}, {
                6.796811224489702, 0.9114139693356047}}], 
               LineBox[{{6.903188775510205, 0.9114139693356047}, {
                6.9607097129903845`, 0.9114139693356047}, {6.985262294106451, 
                0.9114139693356047}, {6.991400439385467, 
                0.9114139693356047}, {6.996811224489796, 
                0.9114139693356047}}], 
               LineBox[{{7.103188775510205, 0.9540034071550255}, {
                7.120301490244817, 0.9540034071550255}, {7.13257778080285, 
                0.9540034071550255}, {7.196811224489797, 
                0.9540034071550255}}], 
               LineBox[{{7.303188775510205, 0.9540034071550255}, {
                7.396811224489726, 0.9540034071550255}}], 
               LineBox[{{7.503188775510206, 0.9540034071550255}, {
                7.596811224489726, 0.9540034071550255}}], 
               LineBox[{{7.703188775510205, 0.9540034071550255}, {
                7.796811224489718, 0.9540034071550255}}], 
               LineBox[{{7.903188775510205, 0.9540034071550255}, {
                7.9630466212483135`, 0.9540034071550255}, {7.975380418148024, 
                0.9540034071550255}, {7.981547316597879, 
                0.9540034071550255}, {7.987714215047735, 
                0.9540034071550255}, {7.990797664272662, 
                0.9540034071550255}, {7.99388111349759, 0.9540034071550255}, {
                7.996811224489796, 0.9540034071550255}}], 
               LineBox[{{8.103188775510203, 0.9761499148211243}, {
                8.111052184044837, 0.9761499148211243}, {8.117219082494692, 
                0.9761499148211243}, {8.123385980944548, 
                0.9761499148211243}, {8.135719777844258, 
                0.9761499148211243}, {8.148053574743969, 
                0.9761499148211243}, {8.196811224489798, 
                0.9761499148211243}}], 
               LineBox[{{8.303188775510204, 0.9761499148211243}, {
                8.396811224489747, 0.9761499148211243}}], 
               LineBox[{{8.503188775510203, 0.9761499148211243}, {
                8.596811224489795, 0.9761499148211243}}], 
               LineBox[{{8.703188775510204, 0.9761499148211243}, {
                8.796811224489796, 0.9761499148211243}}], 
               LineBox[{{8.903188775510204, 0.9761499148211243}, {
                8.986268757410393, 0.9761499148211243}, {8.992464409031086, 
                0.9761499148211243}, {8.995562234841433, 
                0.9761499148211243}, {8.996811224489797, 
                0.9761499148211243}}], 
               LineBox[{{9.103188775510205, 0.9863713798977853}, {
                9.116377441444957, 0.9863713798977853}, {9.128768744686345, 
                0.9863713798977853}, {9.15355135116912, 0.9863713798977853}, {
                9.178333957651894, 0.9863713798977853}, {9.196811224489796, 
                0.9863713798977853}}], 
               LineBox[{{9.303188775510204, 0.9863713798977853}, {
                9.396811224489795, 0.9863713798977853}}], 
               LineBox[{{9.5031887755102, 0.9863713798977853}, {
                9.596811224489798, 0.9863713798977853}}], 
               LineBox[{{9.7031887755102, 0.9863713798977853}, {
                9.796811224489797, 0.9863713798977853}}], 
               LineBox[{{1.1031887755102041`, 0.10221465076660988`}, {
                1.1124879462818624`, 0.10221465076660988`}, {
                1.161789573631988, 0.10221465076660988`}, {
                1.1968112244897962`, 0.10221465076660988`}}], 
               LineBox[{{1.303188775510204, 0.10221465076660988`}, {
                1.3968112244897959`, 0.10221465076660988`}}], 
               LineBox[{{1.7031887755102042`, 0.10221465076660988`}, {
                1.796811224489796, 0.10221465076660988`}}], 
               LineBox[{{1.903188775510204, 0.10221465076660988`}, {
                1.9629881537260188`, 0.10221465076660988`}, {
                1.989516691833479, 0.10221465076660988`}, {
                1.9928327590969115`, 0.10221465076660988`}, {
                1.9961488263603442`, 0.10221465076660988`}, {
                1.996811224489796, 0.10221465076660988`}}], 
               LineBox[{{2.103188775510204, 0.3577512776831345}, {
                2.110679790534046, 0.3577512776831345}, {2.11687124712365, 
                0.3577512776831345}, {2.1292541603028585`, 
                0.3577512776831345}, {2.141637073482067, 
                0.3577512776831345}, {2.1911687261989004`, 
                0.3577512776831345}, {2.196811224489796, 
                0.3577512776831345}}], 
               LineBox[{{2.303188775510204, 0.3577512776831345}, {
                2.3968112244897957`, 0.3577512776831345}}], 
               LineBox[{{2.703188775510204, 0.3577512776831345}, {
                2.796811224489796, 0.3577512776831345}}], 
               LineBox[{{2.903188775510204, 0.3577512776831345}, {
                2.962202760816189, 0.3577512776831345}, {2.975524536211596, 
                0.3577512776831345}, {2.9821854239092995`, 
                0.3577512776831345}, {2.988846311607003, 
                0.3577512776831345}, {2.992176755455855, 
                0.3577512776831345}, {2.9955071993047064`, 
                0.3577512776831345}, {2.9968112244897958`, 
                0.3577512776831345}}], 
               LineBox[{{3.103188775510204, 0.6235093696763202}, {
                3.104498343420011, 0.6235093696763202}, {3.107767887075743, 
                0.6235093696763202}, {3.1339242363215956`, 
                0.6235093696763202}, {3.1600805855674476`, 
                0.6235093696763202}, {3.196811224489796, 
                0.6235093696763202}}], 
               LineBox[{{3.3031887755102045`, 0.6235093696763202}, {
                3.3968112244897957`, 0.6235093696763202}}], 
               LineBox[{{3.703188775510204, 0.6235093696763202}, {
                3.796811224489796, 0.6235093696763202}}], 
               LineBox[{{3.903188775510204, 0.6235093696763202}, {
                3.976106944189814, 0.6235093696763202}, {3.982796585058356, 
                0.6235093696763202}, {3.989486225926898, 
                0.6235093696763202}, {3.992831046361169, 
                0.6235093696763202}, {3.99617586679544, 0.6235093696763202}, {
                3.9968112244897958`, 0.6235093696763202}}], 
               LineBox[{{4.103188775510205, 0.7597955706984667}, {
                4.106128639774543, 0.7597955706984667}, {4.109412560015693, 
                0.7597955706984667}, {4.122548240980296, 
                0.7597955706984667}, {4.135683921944899, 
                0.7597955706984667}, {4.161955283874105, 
                0.7597955706984667}, {4.1882266458033115`, 
                0.7597955706984667}, {4.196811224489795, 
                0.7597955706984667}}], 
               LineBox[{{4.303188775510205, 0.7597955706984667}, {
                4.396811224489796, 0.7597955706984667}}], 
               LineBox[{{5.403188775510204, 0.8568994889267461}, {
                5.496811224489797, 0.8568994889267461}}], 
               LineBox[{{6.003188775510205, 0.8586378333275388}, {
                6.011733436248685, 0.8632959107318208}, {6.023952220465041, 
                0.8699569174596472}, {6.027006916519131, 
                0.8716221691416041}, {6.03006161257322, 0.8732874208235604}, {
                6.036171004681398, 0.8766179241874736}, {6.048389788897754, 
                0.8832789309152996}, {6.051444484951842, 
                0.8849441825972559}, {6.054499181005932, 
                0.8866094342792128}, {6.060608573114109, 
                0.8899399376431255}, {6.072827357330466, 0.896600944370952}, {
                6.0758820533845554`, 0.8982661960529088}, {6.078936749438644, 
                0.8999314477348652}, {6.085046141546822, 
                0.9032619510987784}, {6.088100837600912, 
                0.9049272027807352}, {6.091155533655001, 
                0.9065924544626917}, {6.094210229709089, 0.908257706144648}, {
                6.096811224489796, 0.9096756249348119}}], 
               LineBox[{{6.203188775510204, 0.9114139693356047}, {
                6.2968112244897965`, 0.9114139693356047}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHED/Amq7bTXtP1BhIOkM
ChxAGGMf74tM7T/U1xpzMQ0cQCAlgx9BV+0/WE4V/VUQHEAn5+ZP9mHtP187
ChGfFhxAM2uusGB37T9uFfQ4MSMcQE5zPXI1ou0/8ovuwlUmHEBVNaGi6qzt
P3UC6Ux6KRxAWfcE05+37T98791gwy8cQGV7zDMKze0/i8nHiFU8HECAg1v1
3vftPw5AwhJ6PxxAhEW/JZQC7j+StrycnkIcQIwHI1ZJDe4/mqOxsOdIHECb
i+q2syLuP6h9m9h5VRxAspN5eIhN7j8s9JVinlgcQLpV3ag9WO4/sGqQ7MJb
HEDCF0HZ8mLuPzThinbnXhxAydmkCaht7j+3V4UADGIcQM2bCDpdeO4/DkdM
eyJjHEAjWMMMEnzuPz2JhxM=
                "]], 
               LineBox[{{7.203188775510205, 0.9540034071550255}, {
                7.2968112244897965`, 0.9540034071550255}}], 
               LineBox[{{8.003188775510203, 0.9547096095678473}, {
                8.012381808847156, 0.9567455454005626}, {8.024715605746866, 
                0.959477050676478}, {8.049383199546286, 0.9649400612283087}, {
                8.052466648771212, 0.9656229375472871}, {8.05555009799614, 
                0.966305813866266}, {8.061716996445995, 0.9676715665042237}, {
                8.074050793345705, 0.9704030717801392}, {8.077134242570633, 
                0.9710859480991181}, {8.08021769179556, 0.9717688244180969}, {
                8.086384590245416, 0.9731345770560547}, {8.089468039470344, 
                0.9738174533750336}, {8.092551488695271, 
                0.9745003296940123}, {8.095634937920199, 
                0.9751832060129912}, {8.096811224489796, 
                0.9754437124083024}}], 
               LineBox[{{8.203188775510204, 0.9761499148211243}, {
                8.296811224489797, 0.9761499148211243}}], 
               LineBox[{{9.003188775510203, 0.9764758543962729}, {
                9.011051363893166, 0.977279526121959}, {9.01724701551386, 
                0.9779128124886398}, {9.029638318755246, 
                0.9791793852220013}, {9.032736144565593, 
                0.9794960284053417}, {9.03583397037594, 0.979812671588682}, {
                9.042029621996633, 0.9804459579553627}, {9.054420925238022, 
                0.9817125306887244}, {9.079203531720797, 
                0.9842456761554476}, {9.082301357531144, 
                0.9845623193387879}, {9.08539918334149, 0.9848789625221284}, {
                9.088497009151837, 0.9851956057054687}, {9.091594834962184, 
                0.9855122488888091}, {9.09469266077253, 0.9858288920721494}, {
                9.096811224489798, 0.9860454403226367}}], 
               LineBox[{{9.203188775510203, 0.9863713798977853}, {
                9.296811224489797, 0.9863713798977853}}], 
               LineBox[{{9.803188775510204, 0.9863713798977853}, {
                9.896811224489785, 0.9863713798977853}}], 
               LineBox[{{4.903188775510205, 0.7597955706984667}, {
                4.996811224489796, 0.7597955706984667}}], 
               LineBox[{{5.103188775510205, 0.8568994889267461}, {
                5.108212738964064, 0.8568994889267461}, {5.114809332617204, 
                0.8568994889267461}, {5.121405926270344, 
                0.8568994889267461}, {5.134599113576624, 
                0.8568994889267461}, {5.147792300882904, 
                0.8568994889267461}, {5.174178675495464, 
                0.8568994889267461}, {5.196811224489796, 
                0.8568994889267461}}], 
               LineBox[{{5.203188775510204, 0.8568994889267461}, {
                5.2968112244897965`, 0.8568994889267461}}]},
              
              Annotation[#, 
               "Charting`Private`Tag$70072#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 cluster number / AZ (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {12., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D9G5DsoRTxxP5in1AHT
HfA/+aBJzoetgz8KIYQn3zjwP6KhZB4Fw5I/yDyRL35F8D/rxQ5i7eyWP4ZY
njcdUvA/NOq4pdUWmz8CkLhHW2vwP2OZhhZTtaE/+v7sZ9ed8D/04dqdIwmq
P7ga+m92qvA/GfSvvxcerD92Ngd4FbfwPz0GheELM64/8m0hiFPQ8D9DlZcS
ei6xP+vcVajPAvE/oblBVmJYtT+q+GKwbg/xP8hCLGfcYrY/aBRwuA0c8T/b
yxZ4Vm23P+RLishLNfE//93rmUqCuT+iZ5fQ6kHxPxFn1qrEjLo/YIOk2IlO
8T8k8MC7Ppe7P9y6vujHZ/E/SAKW3TKsvT+a1svwZnTxP1qLgO6str4/WPLY
+AWB8T9sFGv/JsG/PzccMe2JjPE/74BALCRawD+w86N3
                "]], 
               
               Line[{{1.2031887755102042`, 0.13195876288659794`}, {
                1.296811224489796, 0.13195876288659794`}}], 
               
               Line[{{1.403188775510204, 0.13195876288659794`}, {
                1.4968112244898326`, 0.13195876288659794`}}], 
               
               Line[{{1.6031887755102041`, 0.13195876288659794`}, {
                1.6968112244897962`, 0.13195876288659794`}}], 
               
               Line[{{1.803188775510204, 0.13195876288659794`}, {
                1.883402539403638, 0.13195876288659794`}, {
                1.8968112244897959`, 0.13195876288659794`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAEApkMaD287BPxEURJl8
DABAs8qLEQilwj8eqUcsRxMAQJzkcAw9mcM/ONNOUtwgAEBsGDsCp4HFP0Vo
UuWmJwBAVTIg/dt1xj9S/VV4cS4AQD1MBfgQasc/bCddngY8AEAOgM/telLJ
P6F7a+owVwBA0+dj2U4jzT8wwAn4h10AQGAvj9VJB84/wASoBd9jAEAQd7rR
ROvOP+CN5CCNcABAOYMIZZ1Z0D8eoF1X6YkAQHYSX12TIdI/ruT7ZECQAEBO
tnTbkJPSPz0pmnKXlgBAFVqKWY4F0z9cstaNRaMAQLShtVWJ6dM/7PZ0m5yp
AECMRcvThlvUP3s7E6nzrwBAUungUYTN1D+axE/EobwAQPEwDE5/sdU/Kgnu
0fjCAEDJ1CHMfCPWPxqOmPZExgBAuR1w+MVe1j8KRI94
                "]], 
               
               Line[{{2.2031887755102044`, 0.3567010309278351}, {
                2.2968112244897956`, 0.3567010309278351}}], 
               
               Line[{{2.403188775510204, 0.3567010309278351}, {
                2.4968112244897127`, 0.3567010309278351}}], 
               
               Line[{{2.6031887755102043`, 0.3567010309278351}, {
                2.6968112244897955`, 0.3567010309278351}}], 
               
               Line[{{2.8031887755102045`, 0.3567010309278351}, {
                2.8955938838391537`, 0.3567010309278351}, {
                2.8968112244897957`, 0.3567010309278351}}], 
               
               Line[{{3.0031887755102042`, 0.3633415737428996}, {
                3.005498530851262, 0.36815157971087525`}, {
                3.0088289747001133`, 0.3750871431899268}, {3.015489862397817, 
                0.3889582701480309}, {3.028811637793224, 0.41670052406424}, {
                3.0554551885840384`, 0.4721850318966573}, {3.05872473223977, 
                0.4789937722931291}, {3.0619942758955014`, 
                0.4858025126896009}, {3.0685333632069645`, 
                0.4994199934825445}, {3.071802906862696, 
                0.5062287338790163}, {3.0750724505184275`, 
                0.5130374742754881}, {3.0816115378298905`, 
                0.5266549550684316}, {3.084881081485622, 
                0.5334636954649035}, {3.0881506251413535`, 
                0.5402724358613753}, {3.091420168797085, 
                0.5470811762578471}, {3.0946897124528165`, 
                0.5538899166543189}, {3.0968112244897954`, 
                0.5583079107931821}}], 
               
               Line[{{3.2031887755102044`, 0.5649484536082475}, {
                3.264705982550857, 0.5649484536082475}, {3.296811224489796, 
                0.5649484536082475}}], 
               Line[{{3.403188775510204, 0.5649484536082475}, {
                3.4968112244897442`, 0.5649484536082475}}], 
               
               Line[{{3.6031887755102043`, 0.5649484536082475}, {
                3.6968112244897955`, 0.5649484536082475}}], 
               
               Line[{{3.8031887755102045`, 0.5649484536082475}, {
                3.8968112244897957`, 0.5649484536082475}}], 
               
               Line[{{4.003188775510204, 0.5700767936040398}, {
                4.006210328098253, 0.5749361977662624}, {4.009555148532524, 
                0.5803154966090074}, {4.016244789401066, 
                0.5910740942944975}, {4.02962407113815, 0.6125912896654777}, {
                4.032968891572421, 0.6179705885082227}, {4.036313712006692, 
                0.6233498873509677}, {4.043003352875234, 
                0.6341084850364579}, {4.0563826346123175`, 
                0.6556256804074381}, {4.0597274550465885`, 
                0.6610049792501832}, {4.0630722754808595`, 
                0.6663842780929282}, {4.069761916349401, 
                0.6771428757784184}, {4.083141198086486, 0.6986600711494}, {
                4.086425118327638, 0.7039414274135197}, {4.089709038568788, 
                0.7092227836776381}, {4.092992958809939, 
                0.7145041399417564}, {4.096276879051089, 
                0.7197854962058748}, {4.096811224489796, 
                0.7206448558804964}}], 
               
               Line[{{4.2031887755102035`, 0.7257731958762887}, {
                4.293312093520136, 0.7257731958762887}, {4.2968112244897965`, 
                0.7257731958762887}}], 
               
               Line[{{4.403188775510205, 0.7257731958762887}, {
                4.496811224489796, 0.7257731958762887}}], 
               
               Line[{{5.003188775510204, 0.7293893330528081}, {
                5.009890606535029, 0.7369893476170422}, {5.0129309260036985`, 
                0.7404371325815129}, {5.015971245472368, 
                0.7438849175459836}, {5.0220518844097075`, 
                0.7507804874749252}, {5.046374440159067, 
                0.7783627671906934}, {5.049414759627736, 
                0.7818105521551642}, {5.052455079096406, 0.785258337119635}, {
                5.058535718033746, 0.7921539070485775}, {5.070696995908426, 
                0.8059450469064616}, {5.0737373153770955`, 
                0.8093928318709324}, {5.076777634845765, 
                0.8128406168354032}, {5.0828582737831045`, 
                0.8197361867643447}, {5.085898593251774, 
                0.8231839717288155}, {5.088938912720444, 
                0.8266317566932863}, {5.091979232189114, 
                0.8300795416577581}, {5.095019551657784, 
                0.8335273266222288}, {5.096811224489796, 
                0.8355591205554386}}], 
               
               Line[{{5.303188775510205, 0.8391752577319589}, {
                5.396811224489795, 0.8391752577319589}}], 
               
               Line[{{5.503188775510205, 0.8391752577319589}, {
                5.596811224489844, 0.8391752577319589}}], 
               
               Line[{{5.703188775510205, 0.8391752577319589}, {
                5.796811224489689, 0.8391752577319589}}], 
               
               Line[{{5.903188775510205, 0.8391752577319589}, {
                5.950639515166904, 0.8391752577319589}, {5.975077083599616, 
                0.8391752577319589}, {5.987295867815972, 
                0.8391752577319589}, {5.996811224489797, 
                0.8391752577319589}}], 
               
               Line[{{6.103188775510205, 0.9051546391752578}, {
                6.109483709979536, 0.9051546391752578}, {6.115593102087713, 
                0.9051546391752578}, {6.121702494195891, 
                0.9051546391752578}, {6.196811224489796, 
                0.9051546391752578}}], 
               
               Line[{{6.303188775510205, 0.9051546391752578}, {
                6.396811224489711, 0.9051546391752578}}], 
               
               Line[{{6.503188775510206, 0.9051546391752578}, {
                6.596811224489708, 0.9051546391752578}}], 
               
               Line[{{6.703188775510205, 0.9051546391752578}, {
                6.796811224489702, 0.9051546391752578}}], 
               
               Line[{{6.903188775510205, 0.9051546391752578}, {
                6.9607097129903845`, 0.9051546391752578}, {6.985262294106451, 
                0.9051546391752578}, {6.991400439385467, 
                0.9051546391752578}, {6.996811224489796, 
                0.9051546391752578}}], 
               
               Line[{{7.103188775510205, 0.9278350515463919}, {
                7.120301490244817, 0.9278350515463919}, {7.13257778080285, 
                0.9278350515463919}, {7.196811224489797, 
                0.9278350515463919}}], 
               
               Line[{{7.303188775510205, 0.9278350515463919}, {
                7.396811224489726, 0.9278350515463919}}], 
               Line[{{7.503188775510206, 0.9278350515463919}, {
                7.596811224489726, 0.9278350515463919}}], 
               
               Line[{{7.703188775510205, 0.9278350515463919}, {
                7.796811224489718, 0.9278350515463919}}], 
               
               Line[{{7.903188775510205, 0.9278350515463919}, {
                7.9630466212483135`, 0.9278350515463919}, {7.975380418148024, 
                0.9278350515463919}, {7.981547316597879, 
                0.9278350515463919}, {7.987714215047735, 
                0.9278350515463919}, {7.990797664272662, 
                0.9278350515463919}, {7.99388111349759, 0.9278350515463919}, {
                7.996811224489796, 0.9278350515463919}}], 
               
               Line[{{8.103188775510203, 0.9608247422680414}, {
                8.111052184044837, 0.9608247422680414}, {8.117219082494692, 
                0.9608247422680414}, {8.123385980944548, 
                0.9608247422680414}, {8.135719777844258, 
                0.9608247422680414}, {8.148053574743969, 
                0.9608247422680414}, {8.196811224489798, 
                0.9608247422680414}}], 
               
               Line[{{8.303188775510204, 0.9608247422680414}, {
                8.396811224489747, 0.9608247422680414}}], 
               
               Line[{{8.503188775510203, 0.9608247422680414}, {
                8.596811224489795, 0.9608247422680414}}], 
               
               Line[{{8.703188775510204, 0.9608247422680414}, {
                8.796811224489796, 0.9608247422680414}}], 
               
               Line[{{8.903188775510204, 0.9608247422680414}, {
                8.986268757410393, 0.9608247422680414}, {8.992464409031086, 
                0.9608247422680414}, {8.995562234841433, 
                0.9608247422680414}, {8.996811224489797, 
                0.9608247422680414}}], 
               
               Line[{{9.103188775510205, 0.9814432989690723}, {
                9.116377441444957, 0.9814432989690723}, {9.128768744686345, 
                0.9814432989690723}, {9.15355135116912, 0.9814432989690723}, {
                9.178333957651894, 0.9814432989690723}, {9.196811224489796, 
                0.9814432989690723}}], 
               
               Line[{{9.303188775510204, 0.9814432989690723}, {
                9.396811224489795, 0.9814432989690723}}], 
               
               Line[{{9.5031887755102, 0.9814432989690723}, {
                9.596811224489798, 0.9814432989690723}}], 
               
               Line[{{9.7031887755102, 0.9814432989690723}, {
                9.796811224489797, 0.9814432989690723}}], 
               
               Line[{{1.1031887755102041`, 0.13195876288659794`}, {
                1.1124879462818624`, 0.13195876288659794`}, {
                1.161789573631988, 0.13195876288659794`}, {
                1.1968112244897962`, 0.13195876288659794`}}], 
               
               Line[{{1.303188775510204, 0.13195876288659794`}, {
                1.3968112244897959`, 0.13195876288659794`}}], 
               
               Line[{{1.7031887755102042`, 0.13195876288659794`}, {
                1.796811224489796, 0.13195876288659794`}}], 
               
               Line[{{1.903188775510204, 0.13195876288659794`}, {
                1.9629881537260188`, 0.13195876288659794`}, {
                1.989516691833479, 0.13195876288659794`}, {
                1.9928327590969115`, 0.13195876288659794`}, {
                1.9961488263603442`, 0.13195876288659794`}, {
                1.996811224489796, 0.13195876288659794`}}], 
               
               Line[{{2.103188775510204, 0.3567010309278351}, {
                2.110679790534046, 0.3567010309278351}, {2.11687124712365, 
                0.3567010309278351}, {2.1292541603028585`, 
                0.3567010309278351}, {2.141637073482067, 
                0.3567010309278351}, {2.1911687261989004`, 
                0.3567010309278351}, {2.196811224489796, 
                0.3567010309278351}}], 
               
               Line[{{2.303188775510204, 0.3567010309278351}, {
                2.3968112244897957`, 0.3567010309278351}}], 
               
               Line[{{2.703188775510204, 0.3567010309278351}, {
                2.796811224489796, 0.3567010309278351}}], 
               
               Line[{{2.903188775510204, 0.3567010309278351}, {
                2.962202760816189, 0.3567010309278351}, {2.975524536211596, 
                0.3567010309278351}, {2.9821854239092995`, 
                0.3567010309278351}, {2.988846311607003, 
                0.3567010309278351}, {2.992176755455855, 
                0.3567010309278351}, {2.9955071993047064`, 
                0.3567010309278351}, {2.9968112244897958`, 
                0.3567010309278351}}], 
               
               Line[{{3.103188775510204, 0.5649484536082475}, {
                3.107767887075743, 0.5649484536082475}, {3.1339242363215956`, 
                0.5649484536082475}, {3.1600805855674476`, 
                0.5649484536082475}, {3.196811224489796, 
                0.5649484536082475}}], 
               
               Line[{{3.3031887755102045`, 0.5649484536082475}, {
                3.3968112244897957`, 0.5649484536082475}}], 
               
               Line[{{3.703188775510204, 0.5649484536082475}, {
                3.796811224489796, 0.5649484536082475}}], 
               
               Line[{{3.903188775510204, 0.5649484536082475}, {
                3.976106944189814, 0.5649484536082475}, {3.982796585058356, 
                0.5649484536082475}, {3.989486225926898, 
                0.5649484536082475}, {3.992831046361169, 
                0.5649484536082475}, {3.99617586679544, 0.5649484536082475}, {
                3.9968112244897958`, 0.5649484536082475}}], 
               
               Line[{{4.103188775510205, 0.7257731958762887}, {
                4.106128639774543, 0.7257731958762887}, {4.109412560015693, 
                0.7257731958762887}, {4.122548240980296, 
                0.7257731958762887}, {4.135683921944899, 
                0.7257731958762887}, {4.161955283874105, 
                0.7257731958762887}, {4.1882266458033115`, 
                0.7257731958762887}, {4.196811224489795, 
                0.7257731958762887}}], 
               
               Line[{{4.303188775510205, 0.7257731958762887}, {
                4.396811224489796, 0.7257731958762887}}], 
               
               Line[{{5.403188775510204, 0.8391752577319589}, {
                5.496811224489797, 0.8391752577319589}}], 
               
               Line[{{6.003188775510205, 0.8412791920892071}, {
                6.011733436248685, 0.8469169063908843}, {6.023952220465041, 
                0.8549787846367278}, {6.027006916519131, 
                0.8569942541981891}, {6.03006161257322, 0.8590097237596497}, {
                6.036171004681398, 0.8630406628825714}, {6.048389788897754, 
                0.8711025411284143}, {6.051444484951842, 
                0.8731180106898749}, {6.054499181005932, 
                0.8751334802513362}, {6.060608573114109, 
                0.8791644193742574}, {6.072827357330466, 
                0.8872262976201009}, {6.0758820533845554`, 
                0.8892417671815621}, {6.078936749438644, 
                0.8912572367430227}, {6.085046141546822, 
                0.8952881758659444}, {6.088100837600912, 
                0.8973036454274056}, {6.091155533655001, 
                0.8993191149888662}, {6.094210229709089, 
                0.9013345845503268}, {6.096811224489796, 
                0.9030507048180096}}], 
               
               Line[{{6.203188775510204, 0.9051546391752578}, {
                6.2968112244897965`, 0.9051546391752578}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEBTZ2iU8/zsP1BhIOkM
ChxA9KRePEMJ7T/U1xpzMQ0cQB3wkwT3Du0/WE4V/VUQHEBHO8nMqhTtP187
ChGfFhxAmNEzXRIg7T9uFfQ4MSMcQD3+CH7hNu0/8ovuwlUmHEBmST5GlTzt
P3UC6Ux6KRxAjpRzDklC7T98791gwy8cQOAq3p6wTe0/i8nHiFU8HECEV7O/
f2TtPw5AwhJ6PxxArKLohzNq7T+StrycnkIcQNXtHVDnb+0/mqOxsOdIHEAp
hIjgTnvtP6h9m9h5VRxAy7BdAR6S7T8s9JVinlgcQPX7ksnRl+0/sGqQ7MJb
HEAeR8iRhZ3tPzThinbnXhxASJL9WTmj7T+3V4UADGIcQHDdMiLtqO0/DkdM
eyJjHEBIWIlq5qrtPx+6ikE=
                "]], 
               
               Line[{{7.203188775510205, 0.9278350515463919}, {
                7.2968112244897965`, 0.9278350515463919}}], 
               
               Line[{{8.003188775510203, 0.9288870187250157}, {
                8.012381808847156, 0.9319197719908144}, {8.024715605746866, 
                0.9359886534422655}, {8.049383199546286, 
                0.9441264163451667}, {8.052466648771212, 
                0.9451436367080288}, {8.05555009799614, 0.9461608570708916}, {
                8.061716996445995, 0.948195297796617}, {8.074050793345705, 
                0.9522641792480679}, {8.077134242570633, 
                0.9532813996109307}, {8.08021769179556, 0.9542986199737934}, {
                8.086384590245416, 0.9563330606995188}, {8.089468039470344, 
                0.9573502810623816}, {8.092551488695271, 
                0.9583675014252444}, {8.095634937920199, 
                0.9593847217881071}, {8.096811224489796, 
                0.9597727750894176}}], 
               
               Line[{{8.203188775510204, 0.9608247422680414}, {
                8.296811224489797, 0.9608247422680414}}], 
               
               Line[{{9.003188775510203, 0.9614822217546812}, {
                9.011051363893166, 0.9631033739985911}, {9.01724701551386, 
                0.9643808279410021}, {9.029638318755246, 0.966935735825824}, {
                9.032736144565593, 0.9675744627970295}, {9.03583397037594, 
                0.968213189768235}, {9.042029621996633, 0.9694906437106461}, {
                9.054420925238022, 0.9720455515954683}, {9.079203531720797, 
                0.9771553673651127}, {9.082301357531144, 
                0.9777940943363181}, {9.08539918334149, 0.9784328213075236}, {
                9.088497009151837, 0.9790715482787291}, {9.091594834962184, 
                0.9797102752499346}, {9.09469266077253, 0.9803490022211401}, {
                9.096811224489798, 0.9807858194824325}}], 
               
               Line[{{9.203188775510203, 0.9814432989690723}, {
                9.296811224489797, 0.9814432989690723}}], 
               
               Line[{{9.803188775510204, 0.9814432989690723}, {
                9.896811224489785, 0.9814432989690723}}], 
               
               Line[{{4.903188775510205, 0.7257731958762887}, {
                4.996811224489796, 0.7257731958762887}}], 
               
               Line[{{5.103188775510205, 0.8391752577319589}, {
                5.108212738964064, 0.8391752577319589}, {5.114809332617204, 
                0.8391752577319589}, {5.121405926270344, 
                0.8391752577319589}, {5.134599113576624, 
                0.8391752577319589}, {5.147792300882904, 
                0.8391752577319589}, {5.174178675495464, 
                0.8391752577319589}, {5.196811224489796, 
                0.8391752577319589}}], 
               
               Line[{{5.203188775510204, 0.8391752577319589}, {
                5.2968112244897965`, 0.8391752577319589}}]}, 
              "Charting`Private`Tag$70072#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQBWIQPbcuic0wpduOAQqOXFbwCVfItIfx/x/b16ygUAnn
zz3QK8+q0Ann59iW5n6XnwnnX/6dMeWD/Eo4n/32I/W38jvh/IWn5he+lj8J
569b33k7R+8WnJ9uf3Hmm6LHcH7eU83HW9a9hPMfxN3kOHgSwQ++0aF39gmC
b3H6eeVTqVdwPvPGpQJi7Qj+jBpFu/L413D+QWHJmZYCb+F8k94T+1y1Efxl
bBVPAt0Q/J6f1/SzahD8sPtTjs16geC/WiXw5feBd3B+jMoBSY47CP75ufn2
It8R/C0TznXp6L6H8+vLehRjZyL4n95bu2duQfBTMl/nlJ5H8C1Z9Zc/eIrg
AwB1yHkP
                "]], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D+lDAnFcrNqP5in1AHT
HfA/5pqbjBh8fj8KIYQn3zjwP5YqQl3LEI0/yDyRL35F8D93WXBIC8KRP4ZY
njcdUvA/pJ0/4rD7lD8CkLhHW2vwP/0l3hX8bps/+v7sZ9ed8D9Xm40+ySqk
P7ga+m92qvA/bj11C5zHpT92Ngd4FbfwP4TfXNhuZKc/8m0hiFPQ8D+wIyxy
FJ6qP+vcVajPAvE/FVbl0q+IsD+q+GKwbg/xPzEnWTkZV7E/aBRwuA0c8T88
+MyfgiWyP+RLishLNfE/Upq0bFXCsz+iZ5fQ6kHxP11rKNO+kLQ/YIOk2IlO
8T9oPJw5KF+1P9y6vujHZ/E/ft6DBvv7tj+a1svwZnTxP4mv92xkyrc/WPLY
+AWB8T+VgGvTzZi4PzccMe2JjPE/9aoOsCFVuT9AOqKX
                "]], 
               
               Line[{{1.2031887755102042`, 0.10221465076660988`}, {
                1.296811224489796, 0.10221465076660988`}}], 
               
               Line[{{1.403188775510204, 0.10221465076660988`}, {
                1.4968112244898326`, 0.10221465076660988`}}], 
               
               Line[{{1.6031887755102041`, 0.10221465076660988`}, {
                1.6968112244897962`, 0.10221465076660988`}}], 
               
               Line[{{1.803188775510204, 0.10221465076660988`}, {
                1.883402539403638, 0.10221465076660988`}, {
                1.8968112244897959`, 0.10221465076660988`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAECAqJs9wkC8PxEURJl8
DABA6mtRpswnvj8eqUcsRxMAQPbSAW6RKcA/ONNOUtwgAED5DLSj51TCP0Vo
UuWmJwBA+imNvpJqwz9S/VV4cS4AQPxGZtk9gMQ/bCddngY8AED+gBgPlKvG
P6F7a+owVwBALPV8ekACyz8wwAn4h10AQCDAm2d4Bcw/wASoBd9jAEA+i7pU
sAjNP+CN5CCNcABAdyH4LiAPzz8eoF1X6YkAQMymufH/jdE/ruT7ZECQAEBb
DEnomw/SPz0pmnKXlgBA1XHY3jeR0j9cstaNRaMAQN4898tvlNM/7PZ0m5yp
AEBsoobCCxbUP3s7E6nzrwBA5gcWuaeX1D+axE/EobwAQO7SNKbfmtU/Kgnu
0fjCAEB9OMScexzWPxqOmPZExgBAkOeWX+Rf1j8RTpOn
                "]], 
               
               Line[{{2.2031887755102044`, 0.3577512776831345}, {
                2.2968112244897956`, 0.3577512776831345}}], 
               
               Line[{{2.403188775510204, 0.3577512776831345}, {
                2.4968112244897127`, 0.3577512776831345}}], 
               
               Line[{{2.6031887755102043`, 0.3577512776831345}, {
                2.6968112244897955`, 0.3577512776831345}}], 
               
               Line[{{2.8031887755102045`, 0.3577512776831345}, {
                2.8955938838391537`, 0.3577512776831345}, {
                2.8968112244897957`, 0.3577512776831345}}], 
               
               Line[{{3.0031887755102042`, 0.36622570663699927`}, {
                3.005498530851262, 0.37236406836110464`}, {
                3.0088289747001133`, 0.3812149923887168}, {3.015489862397817, 
                0.3989168404439423}, {3.028811637793224, 
                0.43432053655439457`}, {3.0554551885840384`, 
                0.5051279287752979}, {3.05872473223977, 0.5138170056116541}, {
                3.0619942758955014`, 0.5225060824480104}, {
                3.0685333632069645`, 0.539884236120723}, {3.071802906862696, 
                0.5485733129570793}, {3.0750724505184275`, 
                0.5572623897934357}, {3.0816115378298905`, 
                0.5746405434661482}, {3.084881081485622, 
                0.5833296203025046}, {3.0881506251413535`, 
                0.5920186971388609}, {3.091420168797085, 
                0.6007077739752171}, {3.0946897124528165`, 
                0.6093968508115735}, {3.0968112244897954`, 
                0.6150349407224542}}], 
               
               Line[{{3.2031887755102044`, 0.6235093696763202}, {
                3.264705982550857, 0.6235093696763202}, {3.296811224489796, 
                0.6235093696763202}}], 
               
               Line[{{3.403188775510204, 0.6235093696763202}, {
                3.4968112244897442`, 0.6235093696763202}}], 
               
               Line[{{3.6031887755102043`, 0.6235093696763202}, {
                3.6968112244897955`, 0.6235093696763202}}], 
               
               Line[{{3.8031887755102045`, 0.6235093696763202}, {
                3.8968112244897957`, 0.6235093696763202}}], 
               
               Line[{{4.003188775510204, 0.6278552306783021}, {
                4.006210328098253, 0.6319731899124399}, {4.009555148532524, 
                0.6365317186133203}, {4.016244789401066, 0.645648776015081}, {
                4.02962407113815, 0.6638828908186023}, {4.032968891572421, 
                0.6684414195194827}, {4.036313712006692, 0.672999948220363}, {
                4.043003352875234, 0.6821170056221237}, {4.0563826346123175`, 
                0.7003511204256452}, {4.0597274550465885`, 
                0.7049096491265255}, {4.0630722754808595`, 
                0.7094681778274059}, {4.069761916349401, 
                0.7185852352291666}, {4.083141198086486, 
                0.7368193500326893}, {4.086425118327638, 
                0.7412948801739518}, {4.089709038568788, 
                0.7457704103152132}, {4.092992958809939, 
                0.7502459404564745}, {4.096276879051089, 
                0.7547214705977359}, {4.096811224489796, 
                0.7554497096964847}}], 
               
               Line[{{4.2031887755102035`, 0.7597955706984667}, {
                4.293312093520136, 0.7597955706984667}, {4.2968112244897965`, 
                0.7597955706984667}}], 
               
               Line[{{4.403188775510205, 0.7597955706984667}, {
                4.496811224489796, 0.7597955706984667}}], 
               
               Line[{{5.003188775510204, 0.762891996662378}, {
                5.009890606535029, 0.7693997371805211}, {5.0129309260036985`, 
                0.7723520065112566}, {5.015971245472368, 0.775304275841992}, {
                5.0220518844097075`, 0.781208814503463}, {5.046374440159067, 
                0.8048269691493485}, {5.049414759627736, 
                0.8077792384800839}, {5.052455079096406, 
                0.8107315078108194}, {5.058535718033746, 
                0.8166360464722912}, {5.070696995908426, 
                0.8284451237952339}, {5.0737373153770955`, 
                0.8313973931259694}, {5.076777634845765, 
                0.8343496624567048}, {5.0828582737831045`, 
                0.8402542011181758}, {5.085898593251774, 
                0.8432064704489113}, {5.088938912720444, 
                0.8461587397796467}, {5.091979232189114, 
                0.8491110091103831}, {5.095019551657784, 
                0.8520632784411185}, {5.096811224489796, 
                0.8538030629628339}}], 
               
               Line[{{5.303188775510205, 0.8568994889267461}, {
                5.396811224489795, 0.8568994889267461}}], 
               
               Line[{{5.503188775510205, 0.8568994889267461}, {
                5.596811224489844, 0.8568994889267461}}], 
               
               Line[{{5.703188775510205, 0.8568994889267461}, {
                5.796811224489689, 0.8568994889267461}}], 
               
               Line[{{5.903188775510205, 0.8568994889267461}, {
                5.950639515166904, 0.8568994889267461}, {5.975077083599616, 
                0.8568994889267461}, {5.987295867815972, 
                0.8568994889267461}, {5.996811224489797, 
                0.8568994889267461}}], 
               
               Line[{{6.103188775510205, 0.9114139693356047}, {
                6.109483709979536, 0.9114139693356047}, {6.115593102087713, 
                0.9114139693356047}, {6.121702494195891, 
                0.9114139693356047}, {6.196811224489796, 
                0.9114139693356047}}], 
               
               Line[{{6.303188775510205, 0.9114139693356047}, {
                6.396811224489711, 0.9114139693356047}}], 
               
               Line[{{6.503188775510206, 0.9114139693356047}, {
                6.596811224489708, 0.9114139693356047}}], 
               
               Line[{{6.703188775510205, 0.9114139693356047}, {
                6.796811224489702, 0.9114139693356047}}], 
               
               Line[{{6.903188775510205, 0.9114139693356047}, {
                6.9607097129903845`, 0.9114139693356047}, {6.985262294106451, 
                0.9114139693356047}, {6.991400439385467, 
                0.9114139693356047}, {6.996811224489796, 
                0.9114139693356047}}], 
               
               Line[{{7.103188775510205, 0.9540034071550255}, {
                7.120301490244817, 0.9540034071550255}, {7.13257778080285, 
                0.9540034071550255}, {7.196811224489797, 
                0.9540034071550255}}], 
               
               Line[{{7.303188775510205, 0.9540034071550255}, {
                7.396811224489726, 0.9540034071550255}}], 
               
               Line[{{7.503188775510206, 0.9540034071550255}, {
                7.596811224489726, 0.9540034071550255}}], 
               
               Line[{{7.703188775510205, 0.9540034071550255}, {
                7.796811224489718, 0.9540034071550255}}], 
               
               Line[{{7.903188775510205, 0.9540034071550255}, {
                7.9630466212483135`, 0.9540034071550255}, {7.975380418148024, 
                0.9540034071550255}, {7.981547316597879, 
                0.9540034071550255}, {7.987714215047735, 
                0.9540034071550255}, {7.990797664272662, 
                0.9540034071550255}, {7.99388111349759, 0.9540034071550255}, {
                7.996811224489796, 0.9540034071550255}}], 
               
               Line[{{8.103188775510203, 0.9761499148211243}, {
                8.111052184044837, 0.9761499148211243}, {8.117219082494692, 
                0.9761499148211243}, {8.123385980944548, 
                0.9761499148211243}, {8.135719777844258, 
                0.9761499148211243}, {8.148053574743969, 
                0.9761499148211243}, {8.196811224489798, 
                0.9761499148211243}}], 
               
               Line[{{8.303188775510204, 0.9761499148211243}, {
                8.396811224489747, 0.9761499148211243}}], 
               
               Line[{{8.503188775510203, 0.9761499148211243}, {
                8.596811224489795, 0.9761499148211243}}], 
               
               Line[{{8.703188775510204, 0.9761499148211243}, {
                8.796811224489796, 0.9761499148211243}}], 
               
               Line[{{8.903188775510204, 0.9761499148211243}, {
                8.986268757410393, 0.9761499148211243}, {8.992464409031086, 
                0.9761499148211243}, {8.995562234841433, 
                0.9761499148211243}, {8.996811224489797, 
                0.9761499148211243}}], 
               
               Line[{{9.103188775510205, 0.9863713798977853}, {
                9.116377441444957, 0.9863713798977853}, {9.128768744686345, 
                0.9863713798977853}, {9.15355135116912, 0.9863713798977853}, {
                9.178333957651894, 0.9863713798977853}, {9.196811224489796, 
                0.9863713798977853}}], 
               
               Line[{{9.303188775510204, 0.9863713798977853}, {
                9.396811224489795, 0.9863713798977853}}], 
               
               Line[{{9.5031887755102, 0.9863713798977853}, {
                9.596811224489798, 0.9863713798977853}}], 
               
               Line[{{9.7031887755102, 0.9863713798977853}, {
                9.796811224489797, 0.9863713798977853}}], 
               
               Line[{{1.1031887755102041`, 0.10221465076660988`}, {
                1.1124879462818624`, 0.10221465076660988`}, {
                1.161789573631988, 0.10221465076660988`}, {
                1.1968112244897962`, 0.10221465076660988`}}], 
               
               Line[{{1.303188775510204, 0.10221465076660988`}, {
                1.3968112244897959`, 0.10221465076660988`}}], 
               
               Line[{{1.7031887755102042`, 0.10221465076660988`}, {
                1.796811224489796, 0.10221465076660988`}}], 
               
               Line[{{1.903188775510204, 0.10221465076660988`}, {
                1.9629881537260188`, 0.10221465076660988`}, {
                1.989516691833479, 0.10221465076660988`}, {
                1.9928327590969115`, 0.10221465076660988`}, {
                1.9961488263603442`, 0.10221465076660988`}, {
                1.996811224489796, 0.10221465076660988`}}], 
               Line[{{2.103188775510204, 0.3577512776831345}, {
                2.110679790534046, 0.3577512776831345}, {2.11687124712365, 
                0.3577512776831345}, {2.1292541603028585`, 
                0.3577512776831345}, {2.141637073482067, 
                0.3577512776831345}, {2.1911687261989004`, 
                0.3577512776831345}, {2.196811224489796, 
                0.3577512776831345}}], 
               
               Line[{{2.303188775510204, 0.3577512776831345}, {
                2.3968112244897957`, 0.3577512776831345}}], 
               
               Line[{{2.703188775510204, 0.3577512776831345}, {
                2.796811224489796, 0.3577512776831345}}], 
               
               Line[{{2.903188775510204, 0.3577512776831345}, {
                2.962202760816189, 0.3577512776831345}, {2.975524536211596, 
                0.3577512776831345}, {2.9821854239092995`, 
                0.3577512776831345}, {2.988846311607003, 
                0.3577512776831345}, {2.992176755455855, 
                0.3577512776831345}, {2.9955071993047064`, 
                0.3577512776831345}, {2.9968112244897958`, 
                0.3577512776831345}}], 
               
               Line[{{3.103188775510204, 0.6235093696763202}, {
                3.104498343420011, 0.6235093696763202}, {3.107767887075743, 
                0.6235093696763202}, {3.1339242363215956`, 
                0.6235093696763202}, {3.1600805855674476`, 
                0.6235093696763202}, {3.196811224489796, 
                0.6235093696763202}}], 
               
               Line[{{3.3031887755102045`, 0.6235093696763202}, {
                3.3968112244897957`, 0.6235093696763202}}], 
               
               Line[{{3.703188775510204, 0.6235093696763202}, {
                3.796811224489796, 0.6235093696763202}}], 
               
               Line[{{3.903188775510204, 0.6235093696763202}, {
                3.976106944189814, 0.6235093696763202}, {3.982796585058356, 
                0.6235093696763202}, {3.989486225926898, 
                0.6235093696763202}, {3.992831046361169, 
                0.6235093696763202}, {3.99617586679544, 0.6235093696763202}, {
                3.9968112244897958`, 0.6235093696763202}}], 
               
               Line[{{4.103188775510205, 0.7597955706984667}, {
                4.106128639774543, 0.7597955706984667}, {4.109412560015693, 
                0.7597955706984667}, {4.122548240980296, 
                0.7597955706984667}, {4.135683921944899, 
                0.7597955706984667}, {4.161955283874105, 
                0.7597955706984667}, {4.1882266458033115`, 
                0.7597955706984667}, {4.196811224489795, 
                0.7597955706984667}}], 
               
               Line[{{4.303188775510205, 0.7597955706984667}, {
                4.396811224489796, 0.7597955706984667}}], 
               
               Line[{{5.403188775510204, 0.8568994889267461}, {
                5.496811224489797, 0.8568994889267461}}], 
               
               Line[{{6.003188775510205, 0.8586378333275388}, {
                6.011733436248685, 0.8632959107318208}, {6.023952220465041, 
                0.8699569174596472}, {6.027006916519131, 
                0.8716221691416041}, {6.03006161257322, 0.8732874208235604}, {
                6.036171004681398, 0.8766179241874736}, {6.048389788897754, 
                0.8832789309152996}, {6.051444484951842, 
                0.8849441825972559}, {6.054499181005932, 
                0.8866094342792128}, {6.060608573114109, 
                0.8899399376431255}, {6.072827357330466, 0.896600944370952}, {
                6.0758820533845554`, 0.8982661960529088}, {6.078936749438644, 
                0.8999314477348652}, {6.085046141546822, 
                0.9032619510987784}, {6.088100837600912, 
                0.9049272027807352}, {6.091155533655001, 
                0.9065924544626917}, {6.094210229709089, 0.908257706144648}, {
                6.096811224489796, 0.9096756249348119}}], 
               
               Line[{{6.203188775510204, 0.9114139693356047}, {
                6.2968112244897965`, 0.9114139693356047}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHED/Amq7bTXtP1BhIOkM
ChxAGGMf74tM7T/U1xpzMQ0cQCAlgx9BV+0/WE4V/VUQHEAn5+ZP9mHtP187
ChGfFhxAM2uusGB37T9uFfQ4MSMcQE5zPXI1ou0/8ovuwlUmHEBVNaGi6qzt
P3UC6Ux6KRxAWfcE05+37T98791gwy8cQGV7zDMKze0/i8nHiFU8HECAg1v1
3vftPw5AwhJ6PxxAhEW/JZQC7j+StrycnkIcQIwHI1ZJDe4/mqOxsOdIHECb
i+q2syLuP6h9m9h5VRxAspN5eIhN7j8s9JVinlgcQLpV3ag9WO4/sGqQ7MJb
HEDCF0HZ8mLuPzThinbnXhxAydmkCaht7j+3V4UADGIcQM2bCDpdeO4/DkdM
eyJjHEAjWMMMEnzuPz2JhxM=
                "]], 
               
               Line[{{7.203188775510205, 0.9540034071550255}, {
                7.2968112244897965`, 0.9540034071550255}}], 
               Line[{{8.003188775510203, 0.9547096095678473}, {
                8.012381808847156, 0.9567455454005626}, {8.024715605746866, 
                0.959477050676478}, {8.049383199546286, 0.9649400612283087}, {
                8.052466648771212, 0.9656229375472871}, {8.05555009799614, 
                0.966305813866266}, {8.061716996445995, 0.9676715665042237}, {
                8.074050793345705, 0.9704030717801392}, {8.077134242570633, 
                0.9710859480991181}, {8.08021769179556, 0.9717688244180969}, {
                8.086384590245416, 0.9731345770560547}, {8.089468039470344, 
                0.9738174533750336}, {8.092551488695271, 
                0.9745003296940123}, {8.095634937920199, 
                0.9751832060129912}, {8.096811224489796, 
                0.9754437124083024}}], 
               
               Line[{{8.203188775510204, 0.9761499148211243}, {
                8.296811224489797, 0.9761499148211243}}], 
               
               Line[{{9.003188775510203, 0.9764758543962729}, {
                9.011051363893166, 0.977279526121959}, {9.01724701551386, 
                0.9779128124886398}, {9.029638318755246, 
                0.9791793852220013}, {9.032736144565593, 
                0.9794960284053417}, {9.03583397037594, 0.979812671588682}, {
                9.042029621996633, 0.9804459579553627}, {9.054420925238022, 
                0.9817125306887244}, {9.079203531720797, 
                0.9842456761554476}, {9.082301357531144, 
                0.9845623193387879}, {9.08539918334149, 0.9848789625221284}, {
                9.088497009151837, 0.9851956057054687}, {9.091594834962184, 
                0.9855122488888091}, {9.09469266077253, 0.9858288920721494}, {
                9.096811224489798, 0.9860454403226367}}], 
               
               Line[{{9.203188775510203, 0.9863713798977853}, {
                9.296811224489797, 0.9863713798977853}}], 
               
               Line[{{9.803188775510204, 0.9863713798977853}, {
                9.896811224489785, 0.9863713798977853}}], 
               
               Line[{{4.903188775510205, 0.7597955706984667}, {
                4.996811224489796, 0.7597955706984667}}], 
               
               Line[{{5.103188775510205, 0.8568994889267461}, {
                5.108212738964064, 0.8568994889267461}, {5.114809332617204, 
                0.8568994889267461}, {5.121405926270344, 
                0.8568994889267461}, {5.134599113576624, 0.8568994889267461}, 
                {5.147792300882904, 0.8568994889267461}, {5.174178675495464, 
                0.8568994889267461}, {5.196811224489796, 
                0.8568994889267461}}], 
               
               Line[{{5.203188775510204, 0.8568994889267461}, {
                5.2968112244897965`, 0.8568994889267461}}]}, 
              "Charting`Private`Tag$70072#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 cluster number / AZ (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[{{2.0408163265306121`*^-7, 6.311803071744162*^-8}, {
                0.003067179205596267, 0.0009486121254421446}, {
                0.006134154329559881, 0.0018971611328535715`}, {
                0.01226810457748711, 0.003794259147676426}, {
                0.02453600507334157, 0.007588455177322135}, {
                0.04907180606505048, 0.015176847236613552`}, {
                0.05213878118901409, 0.016125396244024977`}, {
                0.05520575631297771, 0.017073945251436407`}, {
                0.06133970656090494, 0.01897104326625926}, {
                0.0736076070567594, 0.022765239295904967`}, {
                0.07667458218072301, 0.023713788303316396`}, {
                0.07974155730468663, 0.024662337310727825`}, {
                0.08587550755261386, 0.02655943532555068}, {
                0.08894248267657748, 0.02750798433296211}, {
                0.0920094578005411, 0.028456533340373534`}, {
                0.09507643292450471, 0.029405082347784963`}, {
                0.09681122448979593, 0.02994161582158637}}], 
               LineBox[{{0.10318877551020408`, 0.030927835051546393`}, {
                0.11041130854432277`, 0.030927835051546393`}, {
                0.11654525879225, 0.030927835051546393`}, {
                0.12267920904017723`, 0.030927835051546393`}, {
                0.13494710953603167`, 0.030927835051546393`}, {
                0.14721501003188614`, 0.030927835051546393`}, {
                0.17175081102359507`, 0.030927835051546393`}, {
                0.19628661201530398`, 0.030927835051546393`}, {
                0.196811224489796, 0.030927835051546393`}}], 
               LineBox[{{0.4031887755102041, 0.030927835051546393`}, {
                0.4968112244896796, 0.030927835051546393`}}], 
               LineBox[{{0.6031887755102042, 0.030927835051546393`}, {
                0.6968112244898423, 0.030927835051546393`}}], 
               LineBox[{{0.8031887755102042, 0.030927835051546393`}, {
                0.8554035390369732, 0.030927835051546393`}, {
                0.8968112244897959, 0.030927835051546393`}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D/cyB3n7U+kP5in1AHT
HfA/snpWfu0Oqj8KIYQn3zjwPwFl36A0qrE/yDyRL35F8D/byQZM+tOzP4ZY
njcdUvA/tS4u97/9tT8CkLhHW2vwP2n4fE1LUbo/+v7sZ9ed8D/oRQ39MHzB
P7ga+m92qvA/Vfig0hORwj92Ngd4FbfwP8KqNKj2pcM/8m0hiFPQ8D+cD1xT
vM/FP+vcVajPAvE/ZtmqqUcjyj+q+GKwbg/xP+mLPn8qOMs/aBRwuA0c8T9W
PtJUDU3MP+RLishLNfE/MKP5/9J2zj+iZ5fQ6kHxP5xVjdW1i88/YIOk2IlO
8T8EhJBVTFDQP9y6vujHZ/E/cjYkKy9l0T+a1svwZnTxP6gP7pWg79E/WPLY
+AWB8T/f6LcAEnrSPzccMe2JjPE/Ok0AVGL40j+20Ka9
                "]], 
               LineBox[{{1.203188775510204, 0.30515463917525776`}, {
                1.296811224489796, 0.30515463917525776`}}], 
               LineBox[{{1.403188775510204, 0.30515463917525776`}, {
                1.4968112244898326`, 0.30515463917525776`}}], 
               LineBox[{{1.6031887755102041`, 0.30515463917525776`}, {
                1.696811224489796, 0.30515463917525776`}}], 
               LineBox[{{1.803188775510204, 0.30515463917525776`}, {
                1.883402539403638, 0.30515463917525776`}, {
                1.8968112244897959`, 0.30515463917525776`}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAECj4e1J7STUPxEURJl8
DABALnBTVF201D8eqUcsRxMAQD0h4X/qV9U/ONNOUtwgAEBag/zWBJ/WP0Vo
UuWmJwBAaTSKApJC1z9S/VV4cS4AQHjlFy4f5tc/bCddngY8AECVRzOFOS3Z
P6F7a+owVwBA6AtqM2672z8wwAn4h10AQG4ybVYdVNw/wASoBd9jAEAMWXB5
zOzcP+CN5CCNcABASKZ2vyoe3j8eoF1X6YkAQEmgwaVzQOA/ruT7ZECQAECY
M0M3y4zgPz0pmnKXlgBA28bEyCLZ4D9cstaNRaMAQG3tx+vRceE/7PZ0m5yp
AEC8gEl9Kb7hP3s7E6nzrwBA/xPLDoEK4j+axE/EobwAQJI6zjEwo+I/Kgnu
0fjCAEDgzU/Dh+/iPxqOmPZExgBAACmsSjwX4z/i64/B
                "]], 
               LineBox[{{2.2031887755102044`, 0.6061855670103093}, {
                2.2968112244897956`, 0.6061855670103093}}], 
               LineBox[{{2.403188775510204, 0.6061855670103093}, {
                2.4968112244897127`, 0.6061855670103093}}], 
               LineBox[{{2.6031887755102043`, 0.6061855670103093}, {
                2.6968112244897955`, 0.6061855670103093}}], 
               LineBox[{{2.8031887755102045`, 0.6061855670103093}, {
                2.8955938838391537`, 0.6061855670103093}, {
                2.8968112244897957`, 0.6061855670103093}}], 
               LineBox[{{3.0031887755102042`, 0.6126288659793818}, {
                3.005498530851262, 0.6172960004829622}, {3.0088289747001133`, 
                0.6240255571260023}, {3.015489862397817, 
                0.6374846704120835}, {3.028811637793224, 
                0.6644028969842468}, {3.0554551885840384`, 
                0.7182393501285724}, {3.05872473223977, 0.7248458507112876}, {
                3.0619942758955014`, 0.7314523512940029}, {
                3.0685333632069645`, 0.7446653524594333}, {3.071802906862696, 
                0.7512718530421485}, {3.0750724505184275`, 
                0.7578783536248637}, {3.0816115378298905`, 
                0.7710913547902941}, {3.084881081485622, 
                0.7776978553730094}, {3.0881506251413535`, 
                0.7843043559557246}, {3.091420168797085, 
                0.7909108565384397}, {3.0946897124528165`, 
                0.7975173571211549}, {3.0968112244897954`, 
                0.801804123711339}}], 
               LineBox[{{3.2031887755102044`, 0.8082474226804124}, {
                3.264705982550857, 0.8082474226804124}, {3.296811224489796, 
                0.8082474226804124}}], 
               LineBox[{{3.403188775510204, 0.8082474226804124}, {
                3.4968112244897442`, 0.8082474226804124}}], 
               LineBox[{{3.6031887755102043`, 0.8082474226804124}, {
                3.696811224489795, 0.8082474226804124}}], 
               LineBox[{{3.8031887755102045`, 0.8082474226804124}, {
                3.8968112244897957`, 0.8082474226804124}}], 
               LineBox[{{4.003188775510205, 0.8116005680622767}, {
                4.006210328098253, 0.8147778707837289}, {4.009555148532524, 
                0.8182951046424468}, {4.016244789401066, 
                0.8253295723598827}, {4.02962407113815, 0.8393985077947546}, {
                4.032968891572421, 0.8429157416534725}, {4.036313712006692, 
                0.8464329755121904}, {4.043003352875234, 
                0.8534674432296263}, {4.0563826346123175`, 
                0.8675363786644981}, {4.0597274550465885`, 
                0.871053612523216}, {4.0630722754808595`, 
                0.874570846381934}, {4.069761916349401, 0.8816053140993699}, {
                4.083141198086486, 0.8956742495342427}, {4.086425118327638, 
                0.8991274440146286}, {4.089709038568788, 
                0.9025806384950138}, {4.092992958809939, 0.906033832975399}, {
                4.096276879051089, 0.909487027455784}, {4.096811224489796, 
                0.9100489164738058}}], 
               LineBox[{{4.2031887755102035`, 0.9134020618556701}, {
                4.293312093520136, 0.9134020618556701}, {4.2968112244897965`, 
                0.9134020618556701}}], 
               LineBox[{{4.403188775510205, 0.9134020618556701}, {
                4.496811224489797, 0.9134020618556701}}], 
               LineBox[{{5.003188775510204, 0.9148485167262778}, {
                5.009890606535029, 0.9178885225519714}, {5.0129309260036985`, 
                0.9192676365377598}, {5.015971245472368, 0.920646750523548}, {
                5.0220518844097075`, 0.9234049784951247}, {5.046374440159067, 
                0.934437890381432}, {5.049414759627736, 0.9358170043672203}, {
                5.052455079096406, 0.9371961183530085}, {5.058535718033746, 
                0.9399543463245856}, {5.070696995908426, 
                0.9454708022677393}, {5.0737373153770955`, 
                0.9468499162535275}, {5.076777634845765, 
                0.9482290302393158}, {5.0828582737831045`, 
                0.9509872582108925}, {5.085898593251774, 
                0.9523663721966807}, {5.088938912720444, 
                0.9537454861824691}, {5.091979232189114, 
                0.9551246001682578}, {5.095019551657784, 
                0.9565037141540461}, {5.096811224489796, 0.95731643172733}}], 
               LineBox[{{5.303188775510205, 0.9587628865979381}, {
                5.396811224489795, 0.9587628865979381}}], 
               LineBox[{{5.503188775510205, 0.9587628865979381}, {
                5.596811224489844, 0.9587628865979381}}], 
               LineBox[{{5.703188775510205, 0.9587628865979381}, {
                5.796811224489689, 0.9587628865979381}}], 
               LineBox[{{5.903188775510205, 0.9587628865979381}, {
                5.950639515166904, 0.9587628865979381}, {5.975077083599616, 
                0.9587628865979381}, {5.987295867815972, 
                0.9587628865979381}, {5.996811224489797, 
                0.9587628865979381}}], 
               LineBox[{{6.103188775510205, 0.979381443298969}, {
                6.109483709979536, 0.979381443298969}, {6.115593102087713, 
                0.979381443298969}, {6.121702494195891, 0.979381443298969}, {
                6.196811224489796, 0.979381443298969}}], 
               LineBox[{{6.303188775510205, 0.979381443298969}, {
                6.396811224489711, 0.979381443298969}}], 
               LineBox[{{6.503188775510206, 0.979381443298969}, {
                6.596811224489708, 0.979381443298969}}], 
               LineBox[{{6.703188775510205, 0.979381443298969}, {
                6.796811224489702, 0.979381443298969}}], 
               LineBox[{{6.903188775510205, 0.979381443298969}, {
                6.9607097129903845`, 0.979381443298969}, {6.985262294106451, 
                0.979381443298969}, {6.991400439385467, 0.979381443298969}, {
                6.996811224489796, 0.979381443298969}}], 
               LineBox[{{7.103188775510205, 0.9938144329896906}, {
                7.120301490244817, 0.9938144329896906}, {7.13257778080285, 
                0.9938144329896906}, {7.196811224489797, 
                0.9938144329896906}}], 
               LineBox[{{7.303188775510205, 0.9938144329896906}, {
                7.396811224489726, 0.9938144329896906}}], 
               LineBox[{{7.503188775510206, 0.9938144329896906}, {
                7.596811224489726, 0.9938144329896906}}], 
               LineBox[{{7.703188775510205, 0.9938144329896906}, {
                7.796811224489718, 0.9938144329896906}}], 
               LineBox[{{7.903188775510205, 0.9938144329896906}, {
                7.9630466212483135`, 0.9938144329896906}, {7.975380418148024, 
                0.9938144329896906}, {7.981547316597879, 
                0.9938144329896906}, {7.987714215047735, 
                0.9938144329896906}, {7.990797664272662, 
                0.9938144329896906}, {7.99388111349759, 0.9938144329896906}, {
                7.996811224489796, 0.9938144329896906}}], 
               LineBox[{{8.103188775510205, 0.9979381443298968}, {
                8.111052184044837, 0.9979381443298968}, {8.117219082494692, 
                0.9979381443298968}, {8.123385980944548, 
                0.9979381443298968}, {8.135719777844258, 
                0.9979381443298968}, {8.148053574743969, 
                0.9979381443298968}, {8.196811224489798, 
                0.9979381443298968}}], 
               LineBox[{{8.303188775510204, 0.9979381443298968}, {
                8.396811224489747, 0.9979381443298968}}], 
               LineBox[{{8.503188775510203, 0.9979381443298968}, {
                8.596811224489796, 0.9979381443298968}}], 
               LineBox[{{8.703188775510204, 0.9979381443298968}, {
                8.796811224489796, 0.9979381443298968}}], 
               LineBox[{{8.903188775510204, 0.9979381443298968}, {
                8.986268757410393, 0.9979381443298968}, {8.992464409031086, 
                0.9979381443298968}, {8.995562234841433, 
                0.9979381443298968}, {8.996811224489797, 
                0.9979381443298968}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfd/pgMZVEyUHBjD4YC/1/+OlqdYIfnOk2K+3jgh+
CF+8xzw/BF/l8PJpftEIfhoYIPhRP7YkCPQi+LNmggCCP0H3kNalfQj+2TMg
gOAzgmllhPmfWS6e1ELwTYxBAMFPB9uP4Cdt/KTQ2Y/gQ+xH8Cdc4uk9chzB
h9iP4O/7rPbz/38EHwBYUFnS
                "]], 
               LineBox[{{0.3031887755102041, 0.030927835051546393`}, {
                0.39681122448979594`, 0.030927835051546393`}}], 
               LineBox[{{0.9031887755102042, 0.030927835051546393`}, {
                0.9346441153092921, 0.030927835051546393`}, {
                0.9610576407333984, 0.030927835051546393`}, {
                0.9742644034454515, 0.030927835051546393`}, {
                0.9874711661575047, 0.030927835051546393`}, {
                0.9907728568355181, 0.030927835051546393`}, {
                0.9940745475135313, 0.030927835051546393`}, {
                0.9968112244897959, 0.030927835051546393`}}], 
               LineBox[{{1.1031887755102041`, 0.30515463917525776`}, {
                1.1124879462818624`, 0.30515463917525776`}, {
                1.161789573631988, 0.30515463917525776`}, {1.196811224489796, 
                0.30515463917525776`}}], 
               LineBox[{{1.303188775510204, 0.30515463917525776`}, {
                1.3968112244897959`, 0.30515463917525776`}}], 
               LineBox[{{1.703188775510204, 0.30515463917525776`}, {
                1.796811224489796, 0.30515463917525776`}}], 
               LineBox[{{1.903188775510204, 0.30515463917525776`}, {
                1.9629881537260188`, 0.30515463917525776`}, {
                1.989516691833479, 0.30515463917525776`}, {
                1.9928327590969115`, 0.30515463917525776`}, {
                1.9961488263603442`, 0.30515463917525776`}, {
                1.996811224489796, 0.30515463917525776`}}], 
               LineBox[{{2.103188775510204, 0.6061855670103093}, {
                2.110679790534046, 0.6061855670103093}, {2.11687124712365, 
                0.6061855670103093}, {2.1292541603028585`, 
                0.6061855670103093}, {2.141637073482067, 
                0.6061855670103093}, {2.1911687261989004`, 
                0.6061855670103093}, {2.196811224489796, 
                0.6061855670103093}}], 
               LineBox[{{2.303188775510204, 0.6061855670103093}, {
                2.3968112244897957`, 0.6061855670103093}}], 
               LineBox[{{2.703188775510204, 0.6061855670103093}, {
                2.796811224489796, 0.6061855670103093}}], 
               LineBox[{{2.903188775510204, 0.6061855670103093}, {
                2.962202760816189, 0.6061855670103093}, {2.975524536211596, 
                0.6061855670103093}, {2.9821854239092995`, 
                0.6061855670103093}, {2.988846311607003, 
                0.6061855670103093}, {2.992176755455855, 
                0.6061855670103093}, {2.9955071993047064`, 
                0.6061855670103093}, {2.9968112244897958`, 
                0.6061855670103093}}], 
               LineBox[{{3.103188775510204, 0.8082474226804124}, {
                3.107767887075743, 0.8082474226804124}, {3.1339242363215956`, 
                0.8082474226804124}, {3.1600805855674476`, 
                0.8082474226804124}, {3.196811224489796, 
                0.8082474226804124}}], 
               LineBox[{{3.3031887755102045`, 0.8082474226804124}, {
                3.3968112244897957`, 0.8082474226804124}}], 
               LineBox[{{3.903188775510204, 0.8082474226804124}, {
                3.976106944189814, 0.8082474226804124}, {3.982796585058356, 
                0.8082474226804124}, {3.989486225926898, 
                0.8082474226804124}, {3.992831046361169, 
                0.8082474226804124}, {3.99617586679544, 0.8082474226804124}, {
                3.9968112244897966`, 0.8082474226804124}}], 
               LineBox[{{4.103188775510205, 0.9134020618556701}, {
                4.106128639774543, 0.9134020618556701}, {4.109412560015693, 
                0.9134020618556701}, {4.122548240980296, 
                0.9134020618556701}, {4.135683921944899, 
                0.9134020618556701}, {4.161955283874105, 
                0.9134020618556701}, {4.1882266458033115`, 
                0.9134020618556701}, {4.196811224489795, 
                0.9134020618556701}}], 
               LineBox[{{4.303188775510205, 0.9134020618556701}, {
                4.396811224489796, 0.9134020618556701}}], 
               LineBox[{{5.403188775510204, 0.9587628865979381}, {
                5.496811224489797, 0.9587628865979381}}], 
               LineBox[{{6.003188775510205, 0.9594203660845781}, {
                6.011733436248685, 0.9611821518038522}, {6.023952220465041, 
                0.9637014887556784}, {6.027006916519131, 0.964331322993635}, {
                6.03006161257322, 0.9649611572315915}, {6.036171004681398, 
                0.9662208257075044}, {6.048389788897754, 
                0.9687401626593304}, {6.051444484951842, 
                0.9693699968972869}, {6.054499181005932, 
                0.9699998311352435}, {6.060608573114109, 
                0.9712594996111563}, {6.072827357330466, 
                0.9737788365629825}, {6.0758820533845554`, 
                0.9744086708009391}, {6.078936749438644, 
                0.9750385050388956}, {6.085046141546822, 
                0.9762981735148085}, {6.088100837600912, 
                0.9769280077527652}, {6.091155533655001, 
                0.9775578419907216}, {6.094210229709089, 
                0.9781876762286781}, {6.096811224489796, 0.978723963812329}}],
                LineBox[{{6.203188775510204, 0.979381443298969}, {
                6.2968112244897965`, 0.979381443298969}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEBYtcnv3FrvP1BhIOkM
ChxAkNw3ibJi7z/U1xpzMQ0cQE2v/HxTZu8/WE4V/VUQHEAKgsFw9GnvP187
ChGfFhxAhCdLWDZx7z9uFfQ4MSMcQHhyXie6f+8/8ovuwlUmHEA2RSMbW4Pv
P3UC6Ux6KRxA8hfoDvyG7z98791gwy8cQGy9cfY9ju8/i8nHiFU8HEBgCIXF
wZzvPw5AwhJ6PxxAHNtJuWKg7z+StrycnkIcQNqtDq0DpO8/mqOxsOdIHEBU
U5iURavvP6h9m9h5VRxAR56rY8m57z8s9JVinlgcQAVxcFdqve8/sGqQ7MJb
HEDCQzVLC8HvPzThinbnXhxAgBb6PqzE7z+3V4UADGIcQDzpvjJNyO8/DkdM
eyJjHEDFq969jsnvP1f7it0=
                "]], 
               LineBox[{{7.203188775510205, 0.9938144329896906}, {
                7.2968112244897965`, 0.9938144329896906}}], 
               LineBox[{{8.003188775510203, 0.9939459288870186}, {
                8.012381808847156, 0.9943250230452434}, {8.024715605746866, 
                0.9948336332266748}, {8.049383199546286, 
                0.9958508535895374}, {8.052466648771212, 
                0.9959780061348952}, {8.05555009799614, 0.9961051586802531}, {
                8.061716996445995, 0.9963594637709687}, {8.074050793345705, 
                0.9968680739524001}, {8.077134242570633, 0.996995226497758}, {
                8.08021769179556, 0.9971223790431157}, {8.086384590245416, 
                0.9973766841338314}, {8.089468039470344, 
                0.9975038366791893}, {8.092551488695271, 
                0.9976309892245471}, {8.095634937920199, 0.997758141769905}, {
                8.096811224489798, 0.9978066484325688}}], 
               LineBox[{{8.203188775510204, 0.9979381443298968}, {
                8.296811224489797, 0.9979381443298968}}], 
               LineBox[{{9.003188775510203, 0.9980038922785608}, {
                9.011051363893166, 0.9981660075029518}, {9.01724701551386, 
                0.9982937528971929}, {9.029638318755246, 
                0.9985492436856751}, {9.032736144565593, 
                0.9986131163827956}, {9.03583397037594, 0.9986769890799162}, {
                9.042029621996633, 0.9988047344741573}, {9.054420925238022, 
                0.9990602252626395}, {9.079203531720797, 0.999571206839604}, {
                9.082301357531144, 0.9996350795367245}, {9.08539918334149, 
                0.9996989522338451}, {9.088497009151837, 
                0.9997628249309656}, {9.091594834962184, 
                0.9998266976280862}, {9.09469266077253, 0.9998905703252067}, {
                9.096811224489796, 0.9999342520513359}}], 
               LineBox[{{4.903188775510205, 0.9134020618556701}, {
                4.996811224489796, 0.9134020618556701}}], 
               LineBox[{{5.103188775510205, 0.9587628865979381}, {
                5.108212738964064, 0.9587628865979381}, {5.114809332617204, 
                0.9587628865979381}, {5.121405926270344, 
                0.9587628865979381}, {5.134599113576624, 
                0.9587628865979381}, {5.147792300882904, 
                0.9587628865979381}, {5.174178675495464, 
                0.9587628865979381}, {5.196811224489797, 
                0.9587628865979381}}], 
               LineBox[{{5.203188775510205, 0.9587628865979381}, {
                5.2968112244897965`, 0.9587628865979381}}]},
              Annotation[#, "Charting`Private`Tag$70147#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[{{2.0408163265306121`*^-7, 1.2168410805548795`*^-7}, {
                0.003067179205596267, 0.0018288121328086772`}, {
                0.006134154329559881, 0.003657502581509299}, {
                0.01226810457748711, 0.007314883478910543}, {
                0.02453600507334157, 0.014629645273713032`}, {
                0.04907180606505048, 0.029259168863318006`}, {
                0.05213878118901409, 0.031087859312018625`}, {
                0.05520575631297771, 0.03291654976071925}, {
                0.06133970656090494, 0.03657393065812049}, {
                0.0736076070567594, 0.04388869245292298}, {
                0.07667458218072301, 0.0457173829016236}, {
                0.07974155730468663, 0.04754607335032423}, {
                0.08587550755261386, 0.051203454247725474`}, {
                0.08894248267657748, 0.053032144696426094`}, {
                0.0920094578005411, 0.05486083514512672}, {
                0.09507643292450471, 0.05668952559382734}, {
                0.09681122448979593, 0.057723898758822105`}}], 
               LineBox[{{0.10318877551020408`, 0.0596252129471891}, {
                0.11041130854432277`, 0.0596252129471891}, {0.11654525879225, 
                0.0596252129471891}, {0.12267920904017723`, 
                0.0596252129471891}, {0.13494710953603167`, 
                0.0596252129471891}, {0.14721501003188614`, 
                0.0596252129471891}, {0.17175081102359507`, 
                0.0596252129471891}, {0.19628661201530398`, 
                0.0596252129471891}, {0.196811224489796, 
                0.0596252129471891}}], 
               LineBox[{{0.4031887755102041, 0.0596252129471891}, {
                0.4968112244896796, 0.0596252129471891}}], 
               LineBox[{{0.6031887755102042, 0.0596252129471891}, {
                0.6968112244898423, 0.0596252129471891}}], 
               LineBox[{{0.8031887755102042, 0.0596252129471891}, {
                0.8554035390369732, 0.0596252129471891}, {0.8968112244897959, 
                0.0596252129471891}}], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D/vJr9Bf1KxP5in1AHT
HfA/knFeurr2sz8KIYQn3zjwP/S42MfXObg/yDyRL35F8D//IrLm/Ta6P4ZY
njcdUvA/Co2LBSQ0vD8CkLhHW2vwP5AwnyE4F8A/+v7sZ9ed8D+kBFJfhBHE
P7ga+m92qvA/qrm+bhcQxT92Ngd4FbfwP65uK36qDsY/8m0hiFPQ8D+62ASd
0AvIP+vcVajPAvE/4qy32hwGzD+q+GKwbg/xP/xhJOqvBM0/aBRwuA0c8T8A
F5H5QgPOP+RLishLNfE/hkA1jDQA0D+iZ5fQ6kHxPwib6xN+f9A/YIOk2IlO
8T+L9aGbx/7QP9y6vujHZ/E/kKoOq1r90T+a1svwZnTxPxMFxTKkfNI/WPLY
+AWB8T+VX3u67fvSPzccMe2JjPE/hIZoYBBw0z9gWqOT
                "]], 
               LineBox[{{1.203188775510204, 0.31175468483816016`}, {
                1.296811224489796, 0.31175468483816016`}}], 
               LineBox[{{1.403188775510204, 0.31175468483816016`}, {
                1.4968112244898326`, 0.31175468483816016`}}], 
               LineBox[{{1.6031887755102041`, 0.31175468483816016`}, {
                1.696811224489796, 0.31175468483816016`}}], 
               LineBox[{{1.803188775510204, 0.31175468483816016`}, {
                1.883402539403638, 0.31175468483816016`}, {
                1.8968112244897959`, 0.31175468483816016`}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAEChoJ+jkJ/UPxEURJl8
DABAlApm0Do81T8eqUcsRxMAQIhb4vHc7tU/ONNOUtwgAEBw/do0IVTXP0Vo
UuWmJwBAZE5XVsMG2D9S/VV4cS4AQFif03dludg/bCddngY8AEBAQcy6qR7a
P6F7a+owVwBAK4W9QDLp3D8wwAn4h10AQMPBMc71j90/wASoBd9jAEB1/qVb
uTbeP+CN5CCNcABA2neOdkCE3z8eoF1X6YkAQDe1L1anD+E/ruT7ZECQAECQ
0+kcCWPhPz0pmnKXlgBA3PGj42q24T9cstaNRaMAQIEuGHEuXeI/7PZ0m5yp
AEDaTNI3kLDiP3s7E6nzrwBAJmuM/vED4z+axE/EobwAQMunAIy1quM/Kgnu
0fjCAEAkxrpSF/7jPxqOmPZExgBA18c5LHUp5D/3B5TR
                "]], 
               LineBox[{{2.2031887755102044`, 0.6405451448040886}, {
                2.2968112244897956`, 0.6405451448040886}}], 
               LineBox[{{2.403188775510204, 0.6405451448040886}, {
                2.4968112244897127`, 0.6405451448040886}}], 
               LineBox[{{2.6031887755102043`, 0.6405451448040886}, {
                2.6968112244897955`, 0.6405451448040886}}], 
               LineBox[{{2.8031887755102045`, 0.6405451448040886}, {
                2.8955938838391537`, 0.6405451448040886}, {
                2.8968112244897957`, 0.6405451448040886}}], 
               LineBox[{{3.0031887755102042`, 0.6466836734693882}, {
                3.005498530851262, 0.6511300508721055}, {3.0088289747001133`, 
                0.6575412971228758}, {3.015489862397817, 
                0.6703637896244173}, {3.028811637793224, 
                0.6960087746275013}, {3.0554551885840384`, 
                0.7472987446336684}, {3.05872473223977, 0.7535927554189779}, {
                3.0619942758955014`, 0.7598867662042872}, {
                3.0685333632069645`, 0.772474787774906}, {3.071802906862696, 
                0.7787687985602153}, {3.0750724505184275`, 
                0.7850628093455247}, {3.0816115378298905`, 
                0.7976508309161434}, {3.084881081485622, 
                0.8039448417014529}, {3.0881506251413535`, 
                0.8102388524867622}, {3.091420168797085, 
                0.8165328632720716}, {3.0946897124528165`, 
                0.822826874057381}, {3.0968112244897954`, 
                0.8269108750825702}}], 
               LineBox[{{3.2031887755102044`, 0.8330494037478706}, {
                3.264705982550857, 0.8330494037478706}, {3.296811224489796, 
                0.8330494037478706}}], 
               LineBox[{{3.403188775510204, 0.8330494037478706}, {
                3.4968112244897442`, 0.8330494037478706}}], 
               LineBox[{{3.6031887755102043`, 0.8330494037478706}, {
                3.696811224489795, 0.8330494037478706}}], 
               LineBox[{{3.8031887755102045`, 0.8330494037478706}, {
                3.8968112244897957`, 0.8330494037478706}}], 
               LineBox[{{4.003188775510205, 0.8359828599242084}, {
                4.006210328098253, 0.8387624824072506}, {4.009555148532524, 
                0.8418394892803449}, {4.016244789401066, 
                0.8479935030265334}, {4.02962407113815, 0.8603015305189105}, {
                4.032968891572421, 0.8633785373920048}, {4.036313712006692, 
                0.8664555442650991}, {4.043003352875234, 
                0.8726095580112876}, {4.0563826346123175`, 
                0.8849175855036646}, {4.0597274550465885`, 
                0.8879945923767589}, {4.0630722754808595`, 
                0.8910715992498531}, {4.069761916349401, 
                0.8972256129960416}, {4.083141198086486, 
                0.9095336404884196}, {4.086425118327638, 
                0.9125546233337718}, {4.089709038568788, 
                0.9155756061791233}, {4.092992958809939, 
                0.9185965890244747}, {4.096276879051089, 
                0.9216175718698262}, {4.096811224489796, 
                0.9221091332614817}}], 
               LineBox[{{4.2031887755102035`, 0.9250425894378195}, {
                4.293312093520136, 0.9250425894378195}, {4.2968112244897965`, 
                0.9250425894378195}}], 
               LineBox[{{4.403188775510205, 0.9250425894378195}, {
                4.496811224489797, 0.9250425894378195}}], 
               LineBox[{{5.003188775510204, 0.9262377012133641}, {
                5.009890606535029, 0.9287494607115948}, {5.0129309260036985`, 
                0.9298889330848612}, {5.015971245472368, 
                0.9310284054581275}, {5.0220518844097075`, 
                0.9333073502046602}, {5.046374440159067, 
                0.9424231291907914}, {5.049414759627736, 
                0.9435626015640577}, {5.052455079096406, 0.944702073937324}, {
                5.058535718033746, 0.946981018683857}, {5.070696995908426, 
                0.9515389081769227}, {5.0737373153770955`, 
                0.9526783805501889}, {5.076777634845765, 
                0.9538178529234552}, {5.0828582737831045`, 
                0.9560967976699879}, {5.085898593251774, 
                0.9572362700432542}, {5.088938912720444, 
                0.9583757424165206}, {5.091979232189114, 
                0.9595152147897872}, {5.095019551657784, 
                0.9606546871630535}, {5.096811224489796, 
                0.9613261829433647}}], 
               LineBox[{{5.303188775510205, 0.9625212947189098}, {
                5.396811224489795, 0.9625212947189098}}], 
               LineBox[{{5.503188775510205, 0.9625212947189098}, {
                5.596811224489844, 0.9625212947189098}}], 
               LineBox[{{5.703188775510205, 0.9625212947189098}, {
                5.796811224489689, 0.9625212947189098}}], 
               LineBox[{{5.903188775510205, 0.9625212947189098}, {
                5.950639515166904, 0.9625212947189098}, {5.975077083599616, 
                0.9625212947189098}, {5.987295867815972, 
                0.9625212947189098}, {5.996811224489797, 
                0.9625212947189098}}], 
               LineBox[{{6.103188775510205, 0.9880749574105623}, {
                6.109483709979536, 0.9880749574105623}, {6.115593102087713, 
                0.9880749574105623}, {6.121702494195891, 
                0.9880749574105623}, {6.196811224489796, 
                0.9880749574105623}}], 
               LineBox[{{6.303188775510205, 0.9880749574105623}, {
                6.396811224489711, 0.9880749574105623}}], 
               LineBox[{{6.503188775510206, 0.9880749574105623}, {
                6.596811224489708, 0.9880749574105623}}], 
               LineBox[{{6.703188775510205, 0.9880749574105623}, {
                6.796811224489702, 0.9880749574105623}}], 
               LineBox[{{6.903188775510205, 0.9880749574105623}, {
                6.9607097129903845`, 0.9880749574105623}, {6.985262294106451, 
                0.9880749574105623}, {6.991400439385467, 
                0.9880749574105623}, {6.996811224489796, 
                0.9880749574105623}}], 
               LineBox[{{7.103188775510205, 0.9965928449744464}, {
                7.120301490244817, 0.9965928449744464}, {7.13257778080285, 
                0.9965928449744464}, {7.196811224489797, 
                0.9965928449744464}}], 
               LineBox[{{7.303188775510205, 0.9965928449744464}, {
                7.396811224489726, 0.9965928449744464}}], 
               LineBox[{{7.503188775510206, 0.9965928449744464}, {
                7.596811224489726, 0.9965928449744464}}], 
               LineBox[{{7.703188775510205, 0.9965928449744464}, {
                7.796811224489718, 0.9965928449744464}}], 
               LineBox[{{7.903188775510205, 0.9965928449744464}, {
                7.996811224489733, 0.9965928449744464}}], 
               LineBox[{{8.103188775510205, 0.9965928449744464}, {
                8.196811224489732, 0.9965928449744464}}], 
               LineBox[{{8.303188775510204, 0.9965928449744464}, {
                8.396811224489747, 0.9965928449744464}}], 
               LineBox[{{8.503188775510203, 0.9965928449744464}, {
                8.596811224489796, 0.9965928449744464}}], 
               LineBox[{{8.703188775510204, 0.9965928449744464}, {
                8.796811224489796, 0.9965928449744464}}], 
               LineBox[{{8.903188775510204, 0.9965928449744464}, {
                8.996811224489797, 0.9965928449744464}}], 
               LineBox[{{9.103188775510205, 0.9965928449744464}, {
                9.196811224489796, 0.9965928449744464}}], 
               LineBox[{{9.303188775510204, 0.9965928449744464}, {
                9.396811224489795, 0.9965928449744464}}], 
               LineBox[{{9.503188775510202, 0.9965928449744464}, {
                9.596811224489798, 0.9965928449744464}}], 
               LineBox[{{9.7031887755102, 0.9965928449744464}, {
                9.796811224489797, 0.9965928449744464}}], 
               LineBox[{{0.3031887755102041, 0.0596252129471891}, {
                0.39681122448979594`, 0.0596252129471891}}], 
               LineBox[{{0.9031887755102042, 0.0596252129471891}, {
                0.9346441153092921, 0.0596252129471891}, {0.9610576407333984, 
                0.0596252129471891}, {0.9742644034454515, 
                0.0596252129471891}, {0.9874711661575047, 
                0.0596252129471891}, {0.9907728568355181, 
                0.0596252129471891}, {0.9940745475135313, 
                0.0596252129471891}, {0.9968112244897959, 
                0.0596252129471891}}], 
               LineBox[{{1.1031887755102041`, 0.31175468483816016`}, {
                1.1124879462818624`, 0.31175468483816016`}, {
                1.161789573631988, 0.31175468483816016`}, {1.196811224489796, 
                0.31175468483816016`}}], 
               LineBox[{{1.303188775510204, 0.31175468483816016`}, {
                1.3968112244897959`, 0.31175468483816016`}}], 
               LineBox[{{1.703188775510204, 0.31175468483816016`}, {
                1.796811224489796, 0.31175468483816016`}}], 
               LineBox[{{1.903188775510204, 0.31175468483816016`}, {
                1.9629881537260188`, 0.31175468483816016`}, {
                1.989516691833479, 0.31175468483816016`}, {
                1.9928327590969115`, 0.31175468483816016`}, {
                1.9961488263603442`, 0.31175468483816016`}, {
                1.996811224489796, 0.31175468483816016`}}], 
               LineBox[{{2.103188775510204, 0.6405451448040886}, {
                2.110679790534046, 0.6405451448040886}, {2.11687124712365, 
                0.6405451448040886}, {2.1292541603028585`, 
                0.6405451448040886}, {2.141637073482067, 
                0.6405451448040886}, {2.1911687261989004`, 
                0.6405451448040886}, {2.196811224489796, 
                0.6405451448040886}}], 
               LineBox[{{2.303188775510204, 0.6405451448040886}, {
                2.3968112244897957`, 0.6405451448040886}}], 
               LineBox[{{2.703188775510204, 0.6405451448040886}, {
                2.796811224489796, 0.6405451448040886}}], 
               LineBox[{{2.903188775510204, 0.6405451448040886}, {
                2.962202760816189, 0.6405451448040886}, {2.975524536211596, 
                0.6405451448040886}, {2.9821854239092995`, 
                0.6405451448040886}, {2.988846311607003, 
                0.6405451448040886}, {2.992176755455855, 
                0.6405451448040886}, {2.9955071993047064`, 
                0.6405451448040886}, {2.9968112244897958`, 
                0.6405451448040886}}], 
               LineBox[{{3.103188775510204, 0.8330494037478706}, {
                3.107767887075743, 0.8330494037478706}, {3.1339242363215956`, 
                0.8330494037478706}, {3.1600805855674476`, 
                0.8330494037478706}, {3.196811224489796, 
                0.8330494037478706}}], 
               LineBox[{{3.3031887755102045`, 0.8330494037478706}, {
                3.3968112244897957`, 0.8330494037478706}}], 
               LineBox[{{3.903188775510204, 0.8330494037478706}, {
                3.976106944189814, 0.8330494037478706}, {3.982796585058356, 
                0.8330494037478706}, {3.989486225926898, 
                0.8330494037478706}, {3.992831046361169, 
                0.8330494037478706}, {3.99617586679544, 0.8330494037478706}, {
                3.9968112244897966`, 0.8330494037478706}}], 
               LineBox[{{4.103188775510205, 0.9250425894378195}, {
                4.106128639774543, 0.9250425894378195}, {4.109412560015693, 
                0.9250425894378195}, {4.122548240980296, 
                0.9250425894378195}, {4.135683921944899, 
                0.9250425894378195}, {4.161955283874105, 
                0.9250425894378195}, {4.1882266458033115`, 
                0.9250425894378195}, {4.196811224489795, 
                0.9250425894378195}}], 
               LineBox[{{4.303188775510205, 0.9250425894378195}, {
                4.396811224489796, 0.9250425894378195}}], 
               LineBox[{{5.403188775510204, 0.9625212947189098}, {
                5.496811224489797, 0.9625212947189098}}], 
               LineBox[{{6.003188775510205, 0.9633361436567814}, {
                6.011733436248685, 0.9655196174400386}, {6.023952220465041, 
                0.9686419643437072}, {6.027006916519131, 
                0.9694225510696245}, {6.03006161257322, 0.9702031377955416}, {
                6.036171004681398, 0.9717643112473758}, {6.048389788897754, 
                0.9748866581510442}, {6.051444484951842, 
                0.9756672448769613}, {6.054499181005932, 
                0.9764478316028786}, {6.060608573114109, 
                0.9780090050547127}, {6.072827357330466, 
                0.9811313519583813}, {6.0758820533845554`, 
                0.9819119386842986}, {6.078936749438644, 
                0.9826925254102157}, {6.085046141546822, 
                0.9842536988620499}, {6.088100837600912, 
                0.9850342855879672}, {6.091155533655001, 
                0.9858148723138843}, {6.094210229709089, 
                0.9865954590398013}, {6.096811224489796, 
                0.9872601084726906}}], 
               LineBox[{{6.203188775510204, 0.9880749574105623}, {
                6.2968112244897965`, 0.9880749574105623}}], 
               LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEDPJmj+iKDvP1BhIOkM
ChxABzpZoiil7z/U1xpzMQ0cQG/6Od9Mp+8/WE4V/VUQHEDXuhoccanvP187
ChGfFhxApjvclbmt7z9uFfQ4MSMcQEU9X4lKtu8/8ovuwlUmHECt/T/Gbrjv
P3UC6Ux6KRxAFL4gA5O67z98791gwy8cQOM+4nzbvu8/i8nHiFU8HECCQGVw
bMfvPw5AwhJ6PxxA6QBGrZDJ7z+StrycnkIcQFHBJuq0y+8/mqOxsOdIHEAh
Quhj/c/vP6h9m9h5VRxAv0NrV47Y7z8s9JVinlgcQCcETJSy2u8/sGqQ7MJb
HECPxCzR1tzvPzThinbnXhxA94QNDvve7z+3V4UADGIcQF5F7kof4e8/DkdM
eyJjHEDWN60O3eHvPxfFjoA=
                "]], 
               LineBox[{{7.203188775510205, 0.9965928449744464}, {
                7.2968112244897965`, 0.9965928449744464}}], 
               LineBox[{{9.803188775510204, 0.9965928449744464}, {
                9.896811224489785, 0.9965928449744464}}], 
               LineBox[{{4.903188775510205, 0.9250425894378195}, {
                4.996811224489796, 0.9250425894378195}}], 
               LineBox[{{5.103188775510205, 0.9625212947189098}, {
                5.108212738964064, 0.9625212947189098}, {5.114809332617204, 
                0.9625212947189098}, {5.121405926270344, 
                0.9625212947189098}, {5.134599113576624, 
                0.9625212947189098}, {5.147792300882904, 
                0.9625212947189098}, {5.174178675495464, 
                0.9625212947189098}, {5.196811224489797, 
                0.9625212947189098}}], 
               LineBox[{{5.203188775510205, 0.9625212947189098}, {
                5.2968112244897965`, 0.9625212947189098}}]},
              
              Annotation[#, 
               "Charting`Private`Tag$70147#2"]& ], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{Automatic, Automatic},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 cluster number / AZ (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {6.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {7.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {8.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {9.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {10.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {11.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {12., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{All, All},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               
               Line[{{2.0408163265306121`*^-7, 6.311803071744162*^-8}, {
                0.003067179205596267, 0.0009486121254421446}, {
                0.006134154329559881, 0.0018971611328535715`}, {
                0.01226810457748711, 0.003794259147676426}, {
                0.02453600507334157, 0.007588455177322135}, {
                0.04907180606505048, 0.015176847236613552`}, {
                0.05213878118901409, 0.016125396244024977`}, {
                0.05520575631297771, 0.017073945251436407`}, {
                0.06133970656090494, 0.01897104326625926}, {
                0.0736076070567594, 0.022765239295904967`}, {
                0.07667458218072301, 0.023713788303316396`}, {
                0.07974155730468663, 0.024662337310727825`}, {
                0.08587550755261386, 0.02655943532555068}, {
                0.08894248267657748, 0.02750798433296211}, {
                0.0920094578005411, 0.028456533340373534`}, {
                0.09507643292450471, 0.029405082347784963`}, {
                0.09681122448979593, 0.02994161582158637}}], 
               
               Line[{{0.10318877551020408`, 0.030927835051546393`}, {
                0.11041130854432277`, 0.030927835051546393`}, {
                0.11654525879225, 0.030927835051546393`}, {
                0.12267920904017723`, 0.030927835051546393`}, {
                0.13494710953603167`, 0.030927835051546393`}, {
                0.14721501003188614`, 0.030927835051546393`}, {
                0.17175081102359507`, 0.030927835051546393`}, {
                0.19628661201530398`, 0.030927835051546393`}, {
                0.196811224489796, 0.030927835051546393`}}], 
               
               Line[{{0.4031887755102041, 0.030927835051546393`}, {
                0.4968112244896796, 0.030927835051546393`}}], 
               
               Line[{{0.6031887755102042, 0.030927835051546393`}, {
                0.6968112244898423, 0.030927835051546393`}}], 
               
               Line[{{0.8031887755102042, 0.030927835051546393`}, {
                0.8554035390369732, 0.030927835051546393`}, {
                0.8968112244897959, 0.030927835051546393`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D/cyB3n7U+kP5in1AHT
HfA/snpWfu0Oqj8KIYQn3zjwPwFl36A0qrE/yDyRL35F8D/byQZM+tOzP4ZY
njcdUvA/tS4u97/9tT8CkLhHW2vwP2n4fE1LUbo/+v7sZ9ed8D/oRQ39MHzB
P7ga+m92qvA/Vfig0hORwj92Ngd4FbfwP8KqNKj2pcM/8m0hiFPQ8D+cD1xT
vM/FP+vcVajPAvE/ZtmqqUcjyj+q+GKwbg/xP+mLPn8qOMs/aBRwuA0c8T9W
PtJUDU3MP+RLishLNfE/MKP5/9J2zj+iZ5fQ6kHxP5xVjdW1i88/YIOk2IlO
8T8EhJBVTFDQP9y6vujHZ/E/cjYkKy9l0T+a1svwZnTxP6gP7pWg79E/WPLY
+AWB8T/f6LcAEnrSPzccMe2JjPE/Ok0AVGL40j+20Ka9
                "]], 
               
               Line[{{1.203188775510204, 0.30515463917525776`}, {
                1.296811224489796, 0.30515463917525776`}}], 
               
               Line[{{1.403188775510204, 0.30515463917525776`}, {
                1.4968112244898326`, 0.30515463917525776`}}], 
               
               Line[{{1.6031887755102041`, 0.30515463917525776`}, {
                1.696811224489796, 0.30515463917525776`}}], 
               
               Line[{{1.803188775510204, 0.30515463917525776`}, {
                1.883402539403638, 0.30515463917525776`}, {
                1.8968112244897959`, 0.30515463917525776`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAECj4e1J7STUPxEURJl8
DABALnBTVF201D8eqUcsRxMAQD0h4X/qV9U/ONNOUtwgAEBag/zWBJ/WP0Vo
UuWmJwBAaTSKApJC1z9S/VV4cS4AQHjlFy4f5tc/bCddngY8AECVRzOFOS3Z
P6F7a+owVwBA6AtqM2672z8wwAn4h10AQG4ybVYdVNw/wASoBd9jAEAMWXB5
zOzcP+CN5CCNcABASKZ2vyoe3j8eoF1X6YkAQEmgwaVzQOA/ruT7ZECQAECY
M0M3y4zgPz0pmnKXlgBA28bEyCLZ4D9cstaNRaMAQG3tx+vRceE/7PZ0m5yp
AEC8gEl9Kb7hP3s7E6nzrwBA/xPLDoEK4j+axE/EobwAQJI6zjEwo+I/Kgnu
0fjCAEDgzU/Dh+/iPxqOmPZExgBAACmsSjwX4z/i64/B
                "]], 
               
               Line[{{2.2031887755102044`, 0.6061855670103093}, {
                2.2968112244897956`, 0.6061855670103093}}], 
               
               Line[{{2.403188775510204, 0.6061855670103093}, {
                2.4968112244897127`, 0.6061855670103093}}], 
               
               Line[{{2.6031887755102043`, 0.6061855670103093}, {
                2.6968112244897955`, 0.6061855670103093}}], 
               
               Line[{{2.8031887755102045`, 0.6061855670103093}, {
                2.8955938838391537`, 0.6061855670103093}, {
                2.8968112244897957`, 0.6061855670103093}}], 
               Line[{{3.0031887755102042`, 0.6126288659793818}, {
                3.005498530851262, 0.6172960004829622}, {3.0088289747001133`, 
                0.6240255571260023}, {3.015489862397817, 
                0.6374846704120835}, {3.028811637793224, 
                0.6644028969842468}, {3.0554551885840384`, 
                0.7182393501285724}, {3.05872473223977, 0.7248458507112876}, {
                3.0619942758955014`, 0.7314523512940029}, {
                3.0685333632069645`, 0.7446653524594333}, {3.071802906862696, 
                0.7512718530421485}, {3.0750724505184275`, 
                0.7578783536248637}, {3.0816115378298905`, 
                0.7710913547902941}, {3.084881081485622, 
                0.7776978553730094}, {3.0881506251413535`, 
                0.7843043559557246}, {3.091420168797085, 
                0.7909108565384397}, {3.0946897124528165`, 
                0.7975173571211549}, {3.0968112244897954`, 
                0.801804123711339}}], 
               
               Line[{{3.2031887755102044`, 0.8082474226804124}, {
                3.264705982550857, 0.8082474226804124}, {3.296811224489796, 
                0.8082474226804124}}], 
               
               Line[{{3.403188775510204, 0.8082474226804124}, {
                3.4968112244897442`, 0.8082474226804124}}], 
               
               Line[{{3.6031887755102043`, 0.8082474226804124}, {
                3.696811224489795, 0.8082474226804124}}], 
               
               Line[{{3.8031887755102045`, 0.8082474226804124}, {
                3.8968112244897957`, 0.8082474226804124}}], 
               
               Line[{{4.003188775510205, 0.8116005680622767}, {
                4.006210328098253, 0.8147778707837289}, {4.009555148532524, 
                0.8182951046424468}, {4.016244789401066, 
                0.8253295723598827}, {4.02962407113815, 0.8393985077947546}, {
                4.032968891572421, 0.8429157416534725}, {4.036313712006692, 
                0.8464329755121904}, {4.043003352875234, 
                0.8534674432296263}, {4.0563826346123175`, 
                0.8675363786644981}, {4.0597274550465885`, 
                0.871053612523216}, {4.0630722754808595`, 
                0.874570846381934}, {4.069761916349401, 0.8816053140993699}, {
                4.083141198086486, 0.8956742495342427}, {4.086425118327638, 
                0.8991274440146286}, {4.089709038568788, 
                0.9025806384950138}, {4.092992958809939, 0.906033832975399}, {
                4.096276879051089, 0.909487027455784}, {4.096811224489796, 
                0.9100489164738058}}], 
               
               Line[{{4.2031887755102035`, 0.9134020618556701}, {
                4.293312093520136, 0.9134020618556701}, {4.2968112244897965`, 
                0.9134020618556701}}], 
               
               Line[{{4.403188775510205, 0.9134020618556701}, {
                4.496811224489797, 0.9134020618556701}}], 
               
               Line[{{5.003188775510204, 0.9148485167262778}, {
                5.009890606535029, 0.9178885225519714}, {5.0129309260036985`, 
                0.9192676365377598}, {5.015971245472368, 0.920646750523548}, {
                5.0220518844097075`, 0.9234049784951247}, {5.046374440159067, 
                0.934437890381432}, {5.049414759627736, 0.9358170043672203}, {
                5.052455079096406, 0.9371961183530085}, {5.058535718033746, 
                0.9399543463245856}, {5.070696995908426, 
                0.9454708022677393}, {5.0737373153770955`, 
                0.9468499162535275}, {5.076777634845765, 
                0.9482290302393158}, {5.0828582737831045`, 
                0.9509872582108925}, {5.085898593251774, 
                0.9523663721966807}, {5.088938912720444, 
                0.9537454861824691}, {5.091979232189114, 
                0.9551246001682578}, {5.095019551657784, 
                0.9565037141540461}, {5.096811224489796, 0.95731643172733}}], 
               
               Line[{{5.303188775510205, 0.9587628865979381}, {
                5.396811224489795, 0.9587628865979381}}], 
               
               Line[{{5.503188775510205, 0.9587628865979381}, {
                5.596811224489844, 0.9587628865979381}}], 
               
               Line[{{5.703188775510205, 0.9587628865979381}, {
                5.796811224489689, 0.9587628865979381}}], 
               
               Line[{{5.903188775510205, 0.9587628865979381}, {
                5.950639515166904, 0.9587628865979381}, {5.975077083599616, 
                0.9587628865979381}, {5.987295867815972, 
                0.9587628865979381}, {5.996811224489797, 
                0.9587628865979381}}], 
               
               Line[{{6.103188775510205, 0.979381443298969}, {
                6.109483709979536, 0.979381443298969}, {6.115593102087713, 
                0.979381443298969}, {6.121702494195891, 0.979381443298969}, {
                6.196811224489796, 0.979381443298969}}], 
               Line[{{6.303188775510205, 0.979381443298969}, {
                6.396811224489711, 0.979381443298969}}], 
               
               Line[{{6.503188775510206, 0.979381443298969}, {
                6.596811224489708, 0.979381443298969}}], 
               
               Line[{{6.703188775510205, 0.979381443298969}, {
                6.796811224489702, 0.979381443298969}}], 
               
               Line[{{6.903188775510205, 0.979381443298969}, {
                6.9607097129903845`, 0.979381443298969}, {6.985262294106451, 
                0.979381443298969}, {6.991400439385467, 0.979381443298969}, {
                6.996811224489796, 0.979381443298969}}], 
               
               Line[{{7.103188775510205, 0.9938144329896906}, {
                7.120301490244817, 0.9938144329896906}, {7.13257778080285, 
                0.9938144329896906}, {7.196811224489797, 
                0.9938144329896906}}], 
               
               Line[{{7.303188775510205, 0.9938144329896906}, {
                7.396811224489726, 0.9938144329896906}}], 
               
               Line[{{7.503188775510206, 0.9938144329896906}, {
                7.596811224489726, 0.9938144329896906}}], 
               
               Line[{{7.703188775510205, 0.9938144329896906}, {
                7.796811224489718, 0.9938144329896906}}], 
               
               Line[{{7.903188775510205, 0.9938144329896906}, {
                7.9630466212483135`, 0.9938144329896906}, {7.975380418148024, 
                0.9938144329896906}, {7.981547316597879, 
                0.9938144329896906}, {7.987714215047735, 
                0.9938144329896906}, {7.990797664272662, 
                0.9938144329896906}, {7.99388111349759, 0.9938144329896906}, {
                7.996811224489796, 0.9938144329896906}}], 
               
               Line[{{8.103188775510205, 0.9979381443298968}, {
                8.111052184044837, 0.9979381443298968}, {8.117219082494692, 
                0.9979381443298968}, {8.123385980944548, 
                0.9979381443298968}, {8.135719777844258, 
                0.9979381443298968}, {8.148053574743969, 
                0.9979381443298968}, {8.196811224489798, 
                0.9979381443298968}}], 
               
               Line[{{8.303188775510204, 0.9979381443298968}, {
                8.396811224489747, 0.9979381443298968}}], 
               
               Line[{{8.503188775510203, 0.9979381443298968}, {
                8.596811224489796, 0.9979381443298968}}], 
               
               Line[{{8.703188775510204, 0.9979381443298968}, {
                8.796811224489796, 0.9979381443298968}}], 
               
               Line[{{8.903188775510204, 0.9979381443298968}, {
                8.986268757410393, 0.9979381443298968}, {8.992464409031086, 
                0.9979381443298968}, {8.995562234841433, 
                0.9979381443298968}, {8.996811224489797, 
                0.9979381443298968}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQBmIQfd/pgMZVEyUHBjD4YC/1/+OlqdYIfnOk2K+3jgh+
CF+8xzw/BF/l8PJpftEIfhoYIPhRP7YkCPQi+LNmggCCP0H3kNalfQj+2TMg
gOAzgmllhPmfWS6e1ELwTYxBAMFPB9uP4Cdt/KTQ2Y/gQ+xH8Cdc4uk9chzB
h9iP4O/7rPbz/38EHwBYUFnS
                "]], 
               
               Line[{{0.3031887755102041, 0.030927835051546393`}, {
                0.39681122448979594`, 0.030927835051546393`}}], 
               
               Line[{{0.9031887755102042, 0.030927835051546393`}, {
                0.9346441153092921, 0.030927835051546393`}, {
                0.9610576407333984, 0.030927835051546393`}, {
                0.9742644034454515, 0.030927835051546393`}, {
                0.9874711661575047, 0.030927835051546393`}, {
                0.9907728568355181, 0.030927835051546393`}, {
                0.9940745475135313, 0.030927835051546393`}, {
                0.9968112244897959, 0.030927835051546393`}}], 
               
               Line[{{1.1031887755102041`, 0.30515463917525776`}, {
                1.1124879462818624`, 0.30515463917525776`}, {
                1.161789573631988, 0.30515463917525776`}, {1.196811224489796, 
                0.30515463917525776`}}], 
               
               Line[{{1.303188775510204, 0.30515463917525776`}, {
                1.3968112244897959`, 0.30515463917525776`}}], 
               
               Line[{{1.703188775510204, 0.30515463917525776`}, {
                1.796811224489796, 0.30515463917525776`}}], 
               
               Line[{{1.903188775510204, 0.30515463917525776`}, {
                1.9629881537260188`, 0.30515463917525776`}, {
                1.989516691833479, 0.30515463917525776`}, {
                1.9928327590969115`, 0.30515463917525776`}, {
                1.9961488263603442`, 0.30515463917525776`}, {
                1.996811224489796, 0.30515463917525776`}}], 
               Line[{{2.103188775510204, 0.6061855670103093}, {
                2.110679790534046, 0.6061855670103093}, {2.11687124712365, 
                0.6061855670103093}, {2.1292541603028585`, 
                0.6061855670103093}, {2.141637073482067, 
                0.6061855670103093}, {2.1911687261989004`, 
                0.6061855670103093}, {2.196811224489796, 
                0.6061855670103093}}], 
               
               Line[{{2.303188775510204, 0.6061855670103093}, {
                2.3968112244897957`, 0.6061855670103093}}], 
               
               Line[{{2.703188775510204, 0.6061855670103093}, {
                2.796811224489796, 0.6061855670103093}}], 
               
               Line[{{2.903188775510204, 0.6061855670103093}, {
                2.962202760816189, 0.6061855670103093}, {2.975524536211596, 
                0.6061855670103093}, {2.9821854239092995`, 
                0.6061855670103093}, {2.988846311607003, 
                0.6061855670103093}, {2.992176755455855, 
                0.6061855670103093}, {2.9955071993047064`, 
                0.6061855670103093}, {2.9968112244897958`, 
                0.6061855670103093}}], 
               
               Line[{{3.103188775510204, 0.8082474226804124}, {
                3.107767887075743, 0.8082474226804124}, {3.1339242363215956`, 
                0.8082474226804124}, {3.1600805855674476`, 
                0.8082474226804124}, {3.196811224489796, 
                0.8082474226804124}}], 
               
               Line[{{3.3031887755102045`, 0.8082474226804124}, {
                3.3968112244897957`, 0.8082474226804124}}], 
               
               Line[{{3.903188775510204, 0.8082474226804124}, {
                3.976106944189814, 0.8082474226804124}, {3.982796585058356, 
                0.8082474226804124}, {3.989486225926898, 
                0.8082474226804124}, {3.992831046361169, 
                0.8082474226804124}, {3.99617586679544, 0.8082474226804124}, {
                3.9968112244897966`, 0.8082474226804124}}], 
               
               Line[{{4.103188775510205, 0.9134020618556701}, {
                4.106128639774543, 0.9134020618556701}, {4.109412560015693, 
                0.9134020618556701}, {4.122548240980296, 
                0.9134020618556701}, {4.135683921944899, 
                0.9134020618556701}, {4.161955283874105, 
                0.9134020618556701}, {4.1882266458033115`, 
                0.9134020618556701}, {4.196811224489795, 
                0.9134020618556701}}], 
               
               Line[{{4.303188775510205, 0.9134020618556701}, {
                4.396811224489796, 0.9134020618556701}}], 
               
               Line[{{5.403188775510204, 0.9587628865979381}, {
                5.496811224489797, 0.9587628865979381}}], 
               
               Line[{{6.003188775510205, 0.9594203660845781}, {
                6.011733436248685, 0.9611821518038522}, {6.023952220465041, 
                0.9637014887556784}, {6.027006916519131, 0.964331322993635}, {
                6.03006161257322, 0.9649611572315915}, {6.036171004681398, 
                0.9662208257075044}, {6.048389788897754, 
                0.9687401626593304}, {6.051444484951842, 
                0.9693699968972869}, {6.054499181005932, 
                0.9699998311352435}, {6.060608573114109, 
                0.9712594996111563}, {6.072827357330466, 
                0.9737788365629825}, {6.0758820533845554`, 
                0.9744086708009391}, {6.078936749438644, 
                0.9750385050388956}, {6.085046141546822, 
                0.9762981735148085}, {6.088100837600912, 
                0.9769280077527652}, {6.091155533655001, 
                0.9775578419907216}, {6.094210229709089, 
                0.9781876762286781}, {6.096811224489796, 0.978723963812329}}], 
               
               Line[{{6.203188775510204, 0.979381443298969}, {
                6.2968112244897965`, 0.979381443298969}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEBYtcnv3FrvP1BhIOkM
ChxAkNw3ibJi7z/U1xpzMQ0cQE2v/HxTZu8/WE4V/VUQHEAKgsFw9GnvP187
ChGfFhxAhCdLWDZx7z9uFfQ4MSMcQHhyXie6f+8/8ovuwlUmHEA2RSMbW4Pv
P3UC6Ux6KRxA8hfoDvyG7z98791gwy8cQGy9cfY9ju8/i8nHiFU8HEBgCIXF
wZzvPw5AwhJ6PxxAHNtJuWKg7z+StrycnkIcQNqtDq0DpO8/mqOxsOdIHEBU
U5iURavvP6h9m9h5VRxAR56rY8m57z8s9JVinlgcQAVxcFdqve8/sGqQ7MJb
HEDCQzVLC8HvPzThinbnXhxAgBb6PqzE7z+3V4UADGIcQDzpvjJNyO8/DkdM
eyJjHEDFq969jsnvP1f7it0=
                "]], 
               
               Line[{{7.203188775510205, 0.9938144329896906}, {
                7.2968112244897965`, 0.9938144329896906}}], 
               
               Line[{{8.003188775510203, 0.9939459288870186}, {
                8.012381808847156, 0.9943250230452434}, {8.024715605746866, 
                0.9948336332266748}, {8.049383199546286, 
                0.9958508535895374}, {8.052466648771212, 
                0.9959780061348952}, {8.05555009799614, 0.9961051586802531}, {
                8.061716996445995, 0.9963594637709687}, {8.074050793345705, 
                0.9968680739524001}, {8.077134242570633, 0.996995226497758}, {
                8.08021769179556, 0.9971223790431157}, {8.086384590245416, 
                0.9973766841338314}, {8.089468039470344, 
                0.9975038366791893}, {8.092551488695271, 
                0.9976309892245471}, {8.095634937920199, 0.997758141769905}, {
                8.096811224489798, 0.9978066484325688}}], 
               
               Line[{{8.203188775510204, 0.9979381443298968}, {
                8.296811224489797, 0.9979381443298968}}], 
               
               Line[{{9.003188775510203, 0.9980038922785608}, {
                9.011051363893166, 0.9981660075029518}, {9.01724701551386, 
                0.9982937528971929}, {9.029638318755246, 
                0.9985492436856751}, {9.032736144565593, 
                0.9986131163827956}, {9.03583397037594, 0.9986769890799162}, {
                9.042029621996633, 0.9988047344741573}, {9.054420925238022, 
                0.9990602252626395}, {9.079203531720797, 0.999571206839604}, {
                9.082301357531144, 0.9996350795367245}, {9.08539918334149, 
                0.9996989522338451}, {9.088497009151837, 
                0.9997628249309656}, {9.091594834962184, 
                0.9998266976280862}, {9.09469266077253, 0.9998905703252067}, {
                9.096811224489796, 0.9999342520513359}}], 
               
               Line[{{4.903188775510205, 0.9134020618556701}, {
                4.996811224489796, 0.9134020618556701}}], 
               
               Line[{{5.103188775510205, 0.9587628865979381}, {
                5.108212738964064, 0.9587628865979381}, {5.114809332617204, 
                0.9587628865979381}, {5.121405926270344, 
                0.9587628865979381}, {5.134599113576624, 
                0.9587628865979381}, {5.147792300882904, 
                0.9587628865979381}, {5.174178675495464, 
                0.9587628865979381}, {5.196811224489797, 
                0.9587628865979381}}], 
               
               Line[{{5.203188775510205, 0.9587628865979381}, {
                5.2968112244897965`, 0.9587628865979381}}]}, 
              "Charting`Private`Tag$70147#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               
               Line[{{2.0408163265306121`*^-7, 1.2168410805548795`*^-7}, {
                0.003067179205596267, 0.0018288121328086772`}, {
                0.006134154329559881, 0.003657502581509299}, {
                0.01226810457748711, 0.007314883478910543}, {
                0.02453600507334157, 0.014629645273713032`}, {
                0.04907180606505048, 0.029259168863318006`}, {
                0.05213878118901409, 0.031087859312018625`}, {
                0.05520575631297771, 0.03291654976071925}, {
                0.06133970656090494, 0.03657393065812049}, {
                0.0736076070567594, 0.04388869245292298}, {
                0.07667458218072301, 0.0457173829016236}, {
                0.07974155730468663, 0.04754607335032423}, {
                0.08587550755261386, 0.051203454247725474`}, {
                0.08894248267657748, 0.053032144696426094`}, {
                0.0920094578005411, 0.05486083514512672}, {
                0.09507643292450471, 0.05668952559382734}, {
                0.09681122448979593, 0.057723898758822105`}}], 
               
               Line[{{0.10318877551020408`, 0.0596252129471891}, {
                0.11041130854432277`, 0.0596252129471891}, {0.11654525879225, 
                0.0596252129471891}, {0.12267920904017723`, 
                0.0596252129471891}, {0.13494710953603167`, 
                0.0596252129471891}, {0.14721501003188614`, 
                0.0596252129471891}, {0.17175081102359507`, 
                0.0596252129471891}, {0.19628661201530398`, 
                0.0596252129471891}, {0.196811224489796, 
                0.0596252129471891}}], 
               
               Line[{{0.4031887755102041, 0.0596252129471891}, {
                0.4968112244896796, 0.0596252129471891}}], 
               
               Line[{{0.6031887755102042, 0.0596252129471891}, {
                0.6968112244898423, 0.0596252129471891}}], 
               
               Line[{{0.8031887755102042, 0.0596252129471891}, {
                0.8554035390369732, 0.0596252129471891}, {0.8968112244897959, 
                0.0596252129471891}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAY31orA8N8D/vJr9Bf1KxP5in1AHT
HfA/knFeurr2sz8KIYQn3zjwP/S42MfXObg/yDyRL35F8D//IrLm/Ta6P4ZY
njcdUvA/Co2LBSQ0vD8CkLhHW2vwP5AwnyE4F8A/+v7sZ9ed8D+kBFJfhBHE
P7ga+m92qvA/qrm+bhcQxT92Ngd4FbfwP65uK36qDsY/8m0hiFPQ8D+62ASd
0AvIP+vcVajPAvE/4qy32hwGzD+q+GKwbg/xP/xhJOqvBM0/aBRwuA0c8T8A
F5H5QgPOP+RLishLNfE/hkA1jDQA0D+iZ5fQ6kHxPwib6xN+f9A/YIOk2IlO
8T+L9aGbx/7QP9y6vujHZ/E/kKoOq1r90T+a1svwZnTxPxMFxTKkfNI/WPLY
+AWB8T+VX3u67fvSPzccMe2JjPE/hIZoYBBw0z9gWqOT
                "]], 
               
               Line[{{1.203188775510204, 0.31175468483816016`}, {
                1.296811224489796, 0.31175468483816016`}}], 
               
               Line[{{1.403188775510204, 0.31175468483816016`}, {
                1.4968112244898326`, 0.31175468483816016`}}], 
               
               Line[{{1.6031887755102041`, 0.31175468483816016`}, {
                1.696811224489796, 0.31175468483816016`}}], 
               
               Line[{{1.803188775510204, 0.31175468483816016`}, {
                1.883402539403638, 0.31175468483816016`}, {
                1.8968112244897959`, 0.31175468483816016`}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAsj401ocGAEChoJ+jkJ/UPxEURJl8
DABAlApm0Do81T8eqUcsRxMAQIhb4vHc7tU/ONNOUtwgAEBw/do0IVTXP0Vo
UuWmJwBAZE5XVsMG2D9S/VV4cS4AQFif03dludg/bCddngY8AEBAQcy6qR7a
P6F7a+owVwBAK4W9QDLp3D8wwAn4h10AQMPBMc71j90/wASoBd9jAEB1/qVb
uTbeP+CN5CCNcABA2neOdkCE3z8eoF1X6YkAQDe1L1anD+E/ruT7ZECQAECQ
0+kcCWPhPz0pmnKXlgBA3PGj42q24T9cstaNRaMAQIEuGHEuXeI/7PZ0m5yp
AEDaTNI3kLDiP3s7E6nzrwBAJmuM/vED4z+axE/EobwAQMunAIy1quM/Kgnu
0fjCAEAkxrpSF/7jPxqOmPZExgBA18c5LHUp5D/3B5TR
                "]], 
               
               Line[{{2.2031887755102044`, 0.6405451448040886}, {
                2.2968112244897956`, 0.6405451448040886}}], 
               
               Line[{{2.403188775510204, 0.6405451448040886}, {
                2.4968112244897127`, 0.6405451448040886}}], 
               
               Line[{{2.6031887755102043`, 0.6405451448040886}, {
                2.6968112244897955`, 0.6405451448040886}}], 
               
               Line[{{2.8031887755102045`, 0.6405451448040886}, {
                2.8955938838391537`, 0.6405451448040886}, {
                2.8968112244897957`, 0.6405451448040886}}], 
               Line[{{3.0031887755102042`, 0.6466836734693882}, {
                3.005498530851262, 0.6511300508721055}, {3.0088289747001133`, 
                0.6575412971228758}, {3.015489862397817, 
                0.6703637896244173}, {3.028811637793224, 
                0.6960087746275013}, {3.0554551885840384`, 
                0.7472987446336684}, {3.05872473223977, 0.7535927554189779}, {
                3.0619942758955014`, 0.7598867662042872}, {
                3.0685333632069645`, 0.772474787774906}, {3.071802906862696, 
                0.7787687985602153}, {3.0750724505184275`, 
                0.7850628093455247}, {3.0816115378298905`, 
                0.7976508309161434}, {3.084881081485622, 
                0.8039448417014529}, {3.0881506251413535`, 
                0.8102388524867622}, {3.091420168797085, 
                0.8165328632720716}, {3.0946897124528165`, 
                0.822826874057381}, {3.0968112244897954`, 
                0.8269108750825702}}], 
               
               Line[{{3.2031887755102044`, 0.8330494037478706}, {
                3.264705982550857, 0.8330494037478706}, {3.296811224489796, 
                0.8330494037478706}}], 
               
               Line[{{3.403188775510204, 0.8330494037478706}, {
                3.4968112244897442`, 0.8330494037478706}}], 
               
               Line[{{3.6031887755102043`, 0.8330494037478706}, {
                3.696811224489795, 0.8330494037478706}}], 
               
               Line[{{3.8031887755102045`, 0.8330494037478706}, {
                3.8968112244897957`, 0.8330494037478706}}], 
               
               Line[{{4.003188775510205, 0.8359828599242084}, {
                4.006210328098253, 0.8387624824072506}, {4.009555148532524, 
                0.8418394892803449}, {4.016244789401066, 
                0.8479935030265334}, {4.02962407113815, 0.8603015305189105}, {
                4.032968891572421, 0.8633785373920048}, {4.036313712006692, 
                0.8664555442650991}, {4.043003352875234, 
                0.8726095580112876}, {4.0563826346123175`, 
                0.8849175855036646}, {4.0597274550465885`, 
                0.8879945923767589}, {4.0630722754808595`, 
                0.8910715992498531}, {4.069761916349401, 
                0.8972256129960416}, {4.083141198086486, 
                0.9095336404884196}, {4.086425118327638, 
                0.9125546233337718}, {4.089709038568788, 
                0.9155756061791233}, {4.092992958809939, 
                0.9185965890244747}, {4.096276879051089, 
                0.9216175718698262}, {4.096811224489796, 
                0.9221091332614817}}], 
               
               Line[{{4.2031887755102035`, 0.9250425894378195}, {
                4.293312093520136, 0.9250425894378195}, {4.2968112244897965`, 
                0.9250425894378195}}], 
               
               Line[{{4.403188775510205, 0.9250425894378195}, {
                4.496811224489797, 0.9250425894378195}}], 
               
               Line[{{5.003188775510204, 0.9262377012133641}, {
                5.009890606535029, 0.9287494607115948}, {5.0129309260036985`, 
                0.9298889330848612}, {5.015971245472368, 
                0.9310284054581275}, {5.0220518844097075`, 
                0.9333073502046602}, {5.046374440159067, 
                0.9424231291907914}, {5.049414759627736, 
                0.9435626015640577}, {5.052455079096406, 0.944702073937324}, {
                5.058535718033746, 0.946981018683857}, {5.070696995908426, 
                0.9515389081769227}, {5.0737373153770955`, 
                0.9526783805501889}, {5.076777634845765, 
                0.9538178529234552}, {5.0828582737831045`, 
                0.9560967976699879}, {5.085898593251774, 
                0.9572362700432542}, {5.088938912720444, 
                0.9583757424165206}, {5.091979232189114, 
                0.9595152147897872}, {5.095019551657784, 
                0.9606546871630535}, {5.096811224489796, 
                0.9613261829433647}}], 
               
               Line[{{5.303188775510205, 0.9625212947189098}, {
                5.396811224489795, 0.9625212947189098}}], 
               
               Line[{{5.503188775510205, 0.9625212947189098}, {
                5.596811224489844, 0.9625212947189098}}], 
               
               Line[{{5.703188775510205, 0.9625212947189098}, {
                5.796811224489689, 0.9625212947189098}}], 
               
               Line[{{5.903188775510205, 0.9625212947189098}, {
                5.950639515166904, 0.9625212947189098}, {5.975077083599616, 
                0.9625212947189098}, {5.987295867815972, 
                0.9625212947189098}, {5.996811224489797, 
                0.9625212947189098}}], 
               
               Line[{{6.103188775510205, 0.9880749574105623}, {
                6.109483709979536, 0.9880749574105623}, {6.115593102087713, 
                0.9880749574105623}, {6.121702494195891, 
                0.9880749574105623}, {6.196811224489796, 
                0.9880749574105623}}], 
               
               Line[{{6.303188775510205, 0.9880749574105623}, {
                6.396811224489711, 0.9880749574105623}}], 
               
               Line[{{6.503188775510206, 0.9880749574105623}, {
                6.596811224489708, 0.9880749574105623}}], 
               
               Line[{{6.703188775510205, 0.9880749574105623}, {
                6.796811224489702, 0.9880749574105623}}], 
               
               Line[{{6.903188775510205, 0.9880749574105623}, {
                6.9607097129903845`, 0.9880749574105623}, {6.985262294106451, 
                0.9880749574105623}, {6.991400439385467, 
                0.9880749574105623}, {6.996811224489796, 
                0.9880749574105623}}], 
               
               Line[{{7.103188775510205, 0.9965928449744464}, {
                7.120301490244817, 0.9965928449744464}, {7.13257778080285, 
                0.9965928449744464}, {7.196811224489797, 
                0.9965928449744464}}], 
               
               Line[{{7.303188775510205, 0.9965928449744464}, {
                7.396811224489726, 0.9965928449744464}}], 
               
               Line[{{7.503188775510206, 0.9965928449744464}, {
                7.596811224489726, 0.9965928449744464}}], 
               
               Line[{{7.703188775510205, 0.9965928449744464}, {
                7.796811224489718, 0.9965928449744464}}], 
               
               Line[{{7.903188775510205, 0.9965928449744464}, {
                7.996811224489733, 0.9965928449744464}}], 
               
               Line[{{8.103188775510205, 0.9965928449744464}, {
                8.196811224489732, 0.9965928449744464}}], 
               
               Line[{{8.303188775510204, 0.9965928449744464}, {
                8.396811224489747, 0.9965928449744464}}], 
               
               Line[{{8.503188775510203, 0.9965928449744464}, {
                8.596811224489796, 0.9965928449744464}}], 
               
               Line[{{8.703188775510204, 0.9965928449744464}, {
                8.796811224489796, 0.9965928449744464}}], 
               
               Line[{{8.903188775510204, 0.9965928449744464}, {
                8.996811224489797, 0.9965928449744464}}], 
               
               Line[{{9.103188775510205, 0.9965928449744464}, {
                9.196811224489796, 0.9965928449744464}}], 
               Line[{{9.303188775510204, 0.9965928449744464}, {
                9.396811224489795, 0.9965928449744464}}], 
               
               Line[{{9.503188775510202, 0.9965928449744464}, {
                9.596811224489798, 0.9965928449744464}}], 
               
               Line[{{9.7031887755102, 0.9965928449744464}, {
                9.796811224489797, 0.9965928449744464}}], 
               
               Line[{{0.3031887755102041, 0.0596252129471891}, {
                0.39681122448979594`, 0.0596252129471891}}], 
               
               Line[{{0.9031887755102042, 0.0596252129471891}, {
                0.9346441153092921, 0.0596252129471891}, {0.9610576407333984, 
                0.0596252129471891}, {0.9742644034454515, 
                0.0596252129471891}, {0.9874711661575047, 
                0.0596252129471891}, {0.9907728568355181, 
                0.0596252129471891}, {0.9940745475135313, 
                0.0596252129471891}, {0.9968112244897959, 
                0.0596252129471891}}], 
               
               Line[{{1.1031887755102041`, 0.31175468483816016`}, {
                1.1124879462818624`, 0.31175468483816016`}, {
                1.161789573631988, 0.31175468483816016`}, {1.196811224489796, 
                0.31175468483816016`}}], 
               
               Line[{{1.303188775510204, 0.31175468483816016`}, {
                1.3968112244897959`, 0.31175468483816016`}}], 
               
               Line[{{1.703188775510204, 0.31175468483816016`}, {
                1.796811224489796, 0.31175468483816016`}}], 
               
               Line[{{1.903188775510204, 0.31175468483816016`}, {
                1.9629881537260188`, 0.31175468483816016`}, {
                1.989516691833479, 0.31175468483816016`}, {
                1.9928327590969115`, 0.31175468483816016`}, {
                1.9961488263603442`, 0.31175468483816016`}, {
                1.996811224489796, 0.31175468483816016`}}], 
               
               Line[{{2.103188775510204, 0.6405451448040886}, {
                2.110679790534046, 0.6405451448040886}, {2.11687124712365, 
                0.6405451448040886}, {2.1292541603028585`, 
                0.6405451448040886}, {2.141637073482067, 
                0.6405451448040886}, {2.1911687261989004`, 
                0.6405451448040886}, {2.196811224489796, 
                0.6405451448040886}}], 
               
               Line[{{2.303188775510204, 0.6405451448040886}, {
                2.3968112244897957`, 0.6405451448040886}}], 
               
               Line[{{2.703188775510204, 0.6405451448040886}, {
                2.796811224489796, 0.6405451448040886}}], 
               
               Line[{{2.903188775510204, 0.6405451448040886}, {
                2.962202760816189, 0.6405451448040886}, {2.975524536211596, 
                0.6405451448040886}, {2.9821854239092995`, 
                0.6405451448040886}, {2.988846311607003, 
                0.6405451448040886}, {2.992176755455855, 
                0.6405451448040886}, {2.9955071993047064`, 
                0.6405451448040886}, {2.9968112244897958`, 
                0.6405451448040886}}], 
               
               Line[{{3.103188775510204, 0.8330494037478706}, {
                3.107767887075743, 0.8330494037478706}, {3.1339242363215956`, 
                0.8330494037478706}, {3.1600805855674476`, 
                0.8330494037478706}, {3.196811224489796, 
                0.8330494037478706}}], 
               
               Line[{{3.3031887755102045`, 0.8330494037478706}, {
                3.3968112244897957`, 0.8330494037478706}}], 
               
               Line[{{3.903188775510204, 0.8330494037478706}, {
                3.976106944189814, 0.8330494037478706}, {3.982796585058356, 
                0.8330494037478706}, {3.989486225926898, 
                0.8330494037478706}, {3.992831046361169, 
                0.8330494037478706}, {3.99617586679544, 0.8330494037478706}, {
                3.9968112244897966`, 0.8330494037478706}}], 
               
               Line[{{4.103188775510205, 0.9250425894378195}, {
                4.106128639774543, 0.9250425894378195}, {4.109412560015693, 
                0.9250425894378195}, {4.122548240980296, 
                0.9250425894378195}, {4.135683921944899, 
                0.9250425894378195}, {4.161955283874105, 
                0.9250425894378195}, {4.1882266458033115`, 
                0.9250425894378195}, {4.196811224489795, 
                0.9250425894378195}}], 
               
               Line[{{4.303188775510205, 0.9250425894378195}, {
                4.396811224489796, 0.9250425894378195}}], 
               
               Line[{{5.403188775510204, 0.9625212947189098}, {
                5.496811224489797, 0.9625212947189098}}], 
               
               Line[{{6.003188775510205, 0.9633361436567814}, {
                6.011733436248685, 0.9655196174400386}, {6.023952220465041, 
                0.9686419643437072}, {6.027006916519131, 
                0.9694225510696245}, {6.03006161257322, 0.9702031377955416}, {
                6.036171004681398, 0.9717643112473758}, {6.048389788897754, 
                0.9748866581510442}, {6.051444484951842, 
                0.9756672448769613}, {6.054499181005932, 
                0.9764478316028786}, {6.060608573114109, 
                0.9780090050547127}, {6.072827357330466, 
                0.9811313519583813}, {6.0758820533845554`, 
                0.9819119386842986}, {6.078936749438644, 
                0.9826925254102157}, {6.085046141546822, 
                0.9842536988620499}, {6.088100837600912, 
                0.9850342855879672}, {6.091155533655001, 
                0.9858148723138843}, {6.094210229709089, 
                0.9865954590398013}, {6.096811224489796, 
                0.9872601084726906}}], 
               
               Line[{{6.203188775510204, 0.9880749574105623}, {
                6.2968112244897965`, 0.9880749574105623}}], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAWR8a60MDHEDPJmj+iKDvP1BhIOkM
ChxABzpZoiil7z/U1xpzMQ0cQG/6Od9Mp+8/WE4V/VUQHEDXuhoccanvP187
ChGfFhxApjvclbmt7z9uFfQ4MSMcQEU9X4lKtu8/8ovuwlUmHECt/T/Gbrjv
P3UC6Ux6KRxAFL4gA5O67z98791gwy8cQOM+4nzbvu8/i8nHiFU8HECCQGVw
bMfvPw5AwhJ6PxxA6QBGrZDJ7z+StrycnkIcQFHBJuq0y+8/mqOxsOdIHEAh
Quhj/c/vP6h9m9h5VRxAv0NrV47Y7z8s9JVinlgcQCcETJSy2u8/sGqQ7MJb
HECPxCzR1tzvPzThinbnXhxA94QNDvve7z+3V4UADGIcQF5F7kof4e8/DkdM
eyJjHEDWN60O3eHvPxfFjoA=
                "]], 
               
               Line[{{7.203188775510205, 0.9965928449744464}, {
                7.2968112244897965`, 0.9965928449744464}}], 
               
               Line[{{9.803188775510204, 0.9965928449744464}, {
                9.896811224489785, 0.9965928449744464}}], 
               
               Line[{{4.903188775510205, 0.9250425894378195}, {
                4.996811224489796, 0.9250425894378195}}], 
               
               Line[{{5.103188775510205, 0.9625212947189098}, {
                5.108212738964064, 0.9625212947189098}, {5.114809332617204, 
                0.9625212947189098}, {5.121405926270344, 
                0.9625212947189098}, {5.134599113576624, 
                0.9625212947189098}, {5.147792300882904, 
                0.9625212947189098}, {5.174178675495464, 
                0.9625212947189098}, {5.196811224489797, 
                0.9625212947189098}}], 
               
               Line[{{5.203188775510205, 0.9625212947189098}, {
                5.2968112244897965`, 0.9625212947189098}}]}, 
              "Charting`Private`Tag$70147#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 cluster number / AZ (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, PlotRange -> {All, All}, 
           PlotRangeClipping -> True, 
           PlotRangePadding -> {{Automatic, Automatic}, {
             Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.858052318336782*^9},
 CellLabel->
  "Out[314]=",ExpressionUUID->"9248fa4d-cddb-45cb-96cb-da814c6a15bd"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{{}, {}, 
       TagBox[
        {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAIo/9o54e0T5wuol8E+xGPrcIKR9t
aK8/qXuQpNUGJT/BeK6kKGi/P5aCacynBjU/xjBxZwZozz8MBlbgkAZFP8iM
0kj1Z98/x0dMaoUGVT/JOoO57GfvP6VoR69/BmU/ypHbcehn/z8U+cTRfAZ1
P0q9B07mZw9AS8EDY3sGhT8x/2L1FvAPQNtogUWoYYU/jCBfziM8EEBsEP8n
1byFP3RiunVUxBBAjl/67C5zhj9E5nDEtdQRQNP98Hbi34c/4u3dYXj1E0Ba
Ot6KSbmKPyD9t5z9NhhAtVlc2Qs2kD8UnmXwFXsYQH0tm0qiY5A/CD8TRC6/
GEBGAdq7OJGQP++AbuteRxlA1qhXnmXskD++BCU6wFcaQPj3UmO/opE/XQyS
14J4HEA8lkntcg+TP80NNgkEXSBAw9I2AdrolT/SSxKYznwgQNG5EBFrE5Y/
2InuJpmcIEDfoOog/D2WP+QFp0Qu3CBA/W6eQB6Tlj/8/ReAWFshQDcLBoBi
PZc/Ajz0DiN7IUBG8t+P82eXPwh60J3tmiFAVNm5n4SSlz8T9oi7gtohQHCn
bb+m55c/Ku759qxZIkCqQ9X+6pGYPzAs1oV3eSJAuCqvDny8mD82arIUQpki
QMcRiR4N55g/QuZqMtfYIkDk3zw+LzyZP0gkR8Gh+CJA88YWTsBmmT9OYiNQ
bBgjQAGu8F1RkZk/Wd7bbQFYI0AdfKR9c+aZP14cuPzLdyNAK2N+jQQRmj9k
WpSLlpcjQDlKWJ2VO5o/aphwGmG3I0BIMTKtJmaaP3DWTKkr1yNAVxgMvbeQ
mj+IxvrQWN8jQCN7Ulqqm5o/SPcbPw==
          "]], LineBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAeDkFL6cgJEBSBgGJf0ubP4jOveRV
ViRAgNUHprEknD+ODJpzIHYkQFhHGrpRpZw/lEp2AuuVJEAxuSzO8SWdP5/G
LiCA1SRA35xR9jEnnj+2vp9bqlQlQB+yTSPZFKA/5a6B0v5SJkCAeZdzWRei
P0KPRcCnTyhAQAgrFFocpj+ASrSp0m4oQFYUrShnW6Y/vgUjk/2NKEBuIC89
dJqmPzp8AGZTzChAmzgzZo4Ypz8zabsL/0gpQPhoO7jCFKg/JEMxV1ZCKkCy
yUtcKw2qPwb3HO4ENSxAJItspPz9rT9lL/oNMQ0wQAMHV5rP77I/TNuHpRge
MEAUjmguAhKzPzSHFT0ALzBAJhV6wjQ0sz8E3zBsz1AwQEwjneqZeLM/oo5n
ym2UMECSP+M6ZAG0P9/t1IaqGzFAIXhv2/gStT9ZrK//IyoyQD7phxwiNrc/
QFg9lws7MkBOcJmwVFi3PygEyy7zSzJAYfeqRId6tz/4W+Zdwm0yQIYFzmzs
vrc/lgsdvGCxMkDNIRS9tke4P9NqinidODNAW1qgXUtZuT9EY31orO8zQFT/
vZGdy7o/squ0yg==
          "]], 
         LineBox[{{20.06377551020408, 0.1058151373113202}, {
          20.400947900007537`, 0.10920794646397577`}, {20.524201968382854`, 
          0.11044819490641075`}, {20.77071010513348, 0.11292869179128062`}, {
          21.263726378634736`, 0.11788968556102036`}, {22.249758925637252`, 
          0.1278116731004999}, {24.221824019642277`, 0.14765564817945895`}, {
          28.496165225764553`, 0.19066635844004126`}, {29.93622448979592, 
          0.2051570059518975}}], 
         LineBox[{{30.06377551020408, 0.20648037498114655`}, {
          36.60690926377435, 0.2764126743370994}, {39.93622448979592, 
          0.3119960320683134}}], 
         LineBox[{{40.06377551020408, 0.3134245454861877}, {44.81400757831468,
           0.36905546112182064`}, {48.698587548467465`, 0.4145485523015519}, {
          49.93622448979592, 0.42904276548595566`}}], 
         LineBox[{{50.06377551020408, 0.4304676532352566}, {
          56.846135645150525`, 0.5025711975919925}, {59.93622448979592, 
          0.535422056827279}}], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAXk7ByykITkAOOjpU5izhP7OOOtvS
UlBA59eyyb3U4j9imw4FulZQQNPsDeeu2eI/EqjiLqFaUEDAAWkEoN7iP3DB
ioJvYlBAlysfP4Lo4j8s9NopDHJQQEZ/i7RG/OI/pFl7eEWRUECjJmSfzyPj
P5QkvBW4z1BAXnUVdeFy4z9DMZA/n9NQQEmKcJLSd+M/8j1kaYbXUEA1n8uv
w3zjP1BXDL1U31BADMmB6qWG4z8Milxk8e5QQLsc7l9qmuM/hO/8sioOUUAY
xMZK88HjP3S6PVCdTFFA0xJ4IAUR5D+1WscC2VBRQBc6ukZhFuQ/9vpQtRRV
UUBcYfxsvRvkP3k7ZBqMXVFA5q+AuXUm5D9+vIrkem5RQPlMiVLmO+Q/0Vgf
Gut7UUAIINE56kzkP5c9khs=
          "]], 
         LineBox[{{70.06377551020408, 0.6355166142636701}, {70.321543545807, 
          0.6375242447854211}, {70.38768718670704, 0.6380394056042561}, {
          70.51997446850709, 0.6390697272419256}, {70.78454903210718, 
          0.6411303705172645}, {71.31369815930739, 0.6452516570679427}, {
          73.4302946681082, 0.6617368032706551}, {77.38145380586288, 
          0.6925104702332696}, {79.93622448979592, 0.7124083430984673}}], 
         LineBox[{{80.06377551020408, 0.7132893805617755}, {85.86624187040276,
           0.7482559203105567}, {89.7876258992288, 0.7718867734689171}, {
          89.93622448979592, 0.772782251047093}}], 
         LineBox[{{90.06377551020408, 0.7735218874360431}, {98.00878211325836,
           0.8177862789709676}, {98.06958850263175, 0.8181250524876583}, {
          98.13039489200514, 0.8184638260043493}, {98.25200767075194, 
          0.819141373037731}, {98.49523322824552, 0.8204964671044946}, {
          98.9816843432327, 0.8232066552380218}, {99.0424907326061, 
          0.8235454287547127}, {99.1032971219795, 0.8238842022714036}, {
          99.22490990072629, 0.8245617493047854}, {99.46813545821988, 
          0.825916843371549}, {99.52894184759327, 0.8262556168882399}, {
          99.58974823696667, 0.8265943904049308}, {99.71136101571346, 
          0.8272719374383126}, {99.77216740508686, 0.8276107109550035}, {
          99.83297379446026, 0.8279494844716944}, {99.89378018383366, 
          0.8282882579883853}, {99.93622448979592, 0.8285247299602047}}], 
         LineBox[{{100.06377551020408`, 0.8291193396062233}, {
          100.19781213070064`, 0.8296222626848346}, {100.44103768819423`, 
          0.8305348770563284}, {100.9274888031814, 0.8323601057993162}, {
          101.90039103315576`, 0.8360105632852916}, {101.96635696968715`, 
          0.8362580761796107}, {102.03232290621855`, 0.8365055890739297}, {
          102.16425477928135`, 0.8370006148625678}, {102.42811852540696`, 
          0.8379906664398441}, {102.95584601765816`, 0.8399707695943966}, {
          104.01130100216056`, 0.8439309759035017}, {106.12221097116537`, 
          0.8518513885217119}, {109.93622448979592`, 0.8661620702857606}}], 
         LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAL6fg5RSEW0Aue7H7dbvrP+GBNGQ/
lVxAA1Yp9K067D8mFg6OcJlcQGazHb+hPOw/aqrnt6GdXEDIEBKKlT7sP/TS
mgsEplxAjsv6H31C7D8IJAGzyLZcQBlBzEtMSuw/LsbNAVLYXEAuLG+j6lns
P3oKZ59kG11AWAK1Uid57D+/nkDJlR9dQLtfqR0be+w/BDMa88YjXUAevZ3o
Dn3sP41bzUYpLF1A43eGfvaA7D+grDPu7TxdQG3tV6rFiOw/x04APXdeXUCD
2PoBZJjsPxSTmdqJoV1Arq5AsaC37D8K1RPRcqVdQFaHJdxyuew/ABeOx1up
XUD+XwoHRbvsP+2agrQtsV1AUBHUXOm+7D/GomuO0cBdQPJzZwgyxuw/vOTl
hLrEXUCaTEwzBMjsP7ImYHujyF1AQiUxXtbJ7D+fqlRoddBdQJPW+rN6zew/
eLI9QhngXUA1OY5fw9TsP270tzgC5F1A3hFzipXW7D9kNjIv6+ddQIbqV7Vn
2Ow/UbomHL3vXUDXmyELDNzsP0j8oBKm811AgHQGNt7d7D8+PhsJj/ddQChN
62Cw3+w/NICV/3f7XUDRJdCLguHsP9FYHxrr+11Axc/xJrjh7D+xS+Ro
          "]], 
         LineBox[{{120.06377551020408`, 0.9029053207411446}, {
          120.2346687249738, 0.9032259276818723}, {120.47904440930093`, 
          0.9036843925814059}, {120.54013833038272`, 0.9037990088062893}, {
          120.6012322514645, 0.9039136250311727}, {120.72342009362805`, 
          0.9041428574809394}, {120.96779577795519`, 0.904601322380473}, {
          121.45654714660944`, 0.9055182521795401}, {122.43404988391794`, 
          0.9073521117776743}, {122.50030335215772`, 0.9074764076532804}, {
          122.56655682039751`, 0.9076007035288867}, {122.69906375687708`, 
          0.9078492952800991}, {122.96407762983623`, 0.9083464787825238}, {
          123.4941053757545, 0.9093408457873733}, {124.55416086759107`, 
          0.9113295797970724}, {126.67427185126418`, 0.9153070478164705}, {
          129.9362244897959, 0.9214266860809132}}], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgpCYEBdXFqnSX7tP718+gBo
0GBAKRgkd6nC7T/2r+bwgtJgQH6TZE2sw+0/MOPS4J3UYEDUDqUjr8TtP6RJ
q8DT2GBAgAUm0LTG7T+KFlyAP+FgQNbyJynAyu0/VrC9/xbyYECDzSvb1tLt
P+/jgP7FE2FA3IIzPwTj7T8oF23u4BVhQDL+cxUH5O0/YkpZ3vsXYUCHebTr
CeXtP9awMb4xHGFAM3A1mA/n7T+8feJ9nSRhQIldN/Ea6+0/iBdE/XQ1YUA2
ODujMfPtPyFLB/wjV2FAj+1CB18D7j801UPSGllhQHVo+4ZQBO4/Rl+AqBFb
YUBb47MGQgXuP2pz+VT/XmFAJtkkBiUH7j+0m+ut2mZhQLzEBgXrCu4/xiUo
hNFoYUCiP7+E3AvuP9ivZFrIamFAh7p3BM4M7j/9w90Gtm5hQFOw6AOxDu4/
RuzPX5F2YUDpm8oCdxLuP1h2DDaIeGFAzhaDgmgT7j9qAEkMf3phQLSROwJa
FO4/fIqF4nV8YUCZDPSBSxXuP2isD431fWFA+oenxQMW7j9ogcji
          "]], 
         LineBox[{{140.0637755102041, 0.9403976343237692}, {140.1962975044505,
           0.940585982809054}, {140.25767895724067`, 0.9406732219403647}, {
          140.31906041003083`, 0.9407604610716753}, {140.44182331561117`, 
          0.9409349393342966}, {140.68734912677184`, 0.9412838958595392}, {
          140.748730579562, 0.9413711349908498}, {140.81011203235215`, 
          0.9414583741221604}, {140.9328749379325, 0.9416328523847817}, {
          141.17840074909316`, 0.9419818089100243}, {141.6694523714145, 
          0.9426797219605094}, {142.65155561605718`, 0.9440755480614796}, {
          146.91017961274008`, 0.950128168864042}, {149.9362244897959, 
          0.9544289717023818}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAmFPwcgrCYkD1eDZkDIzuP3wVHg8i
WWNAD+KR+Dm67j/NsQlaP1tjQNghwGffuu4/Hk71pFxdY0ChYe7WhLvuP7+G
zDqXYWNAMuFKtc+87j8C+HpmDGpjQFTgA3Jlv+4/h9rXvfZ6Y0CY3nXrkMTu
P5KfkWzLnGNAIdtZ3ufO7j/jO3236J5jQOoaiE2Nz+4/NNhoAgahY0CyWra8
MtDuP9UQQJhApWNAQ9oSm33R7j8Ygu7Dta1jQGbZy1cT1O4/nmRLG6C+Y0Cq
1z3RPtnuP6kpBcp04GNAM9QhxJXj7j/SHEH7beJjQG/8yiow5O4//A99LGfk
Y0CqJHSRyuTuP0729I5Z6GNAIXXGXv/l7j/0wuRTPvBjQA8Wa/lo6O4/HrYg
hTfyY0BKPhRgA+nuP0epXLYw9GNAhma9xp3p7j+aj9QYI/hjQP22D5TS6u4/
xIIQShz6Y0A437j6bOvuP+11THsV/GNAdAdiYQfs7j9orA+N9f1jQLaUZxqa
7O4/tkHI4Q==
          "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAmFPwcgoCZEDFsW4Fle3uP+YotKLs
B2RAK16WEZzu7j+M9aNn0Q9kQI6VPfz87+4/2I6D8ZofZEBVBIzRvvLuPwKC
vyKUIWRALtI1DBfz7j8rdftTjSNkQAeg30Zv8+4/fltztn8nZEC4OzO8H/Tu
PyQoY3tkL2RAHHPapoD17j9vwUIFLj9kQOLhKHxC+O4/BvQBGcFeZEBwv8Um
xv3uP6cwsX6e52RA+XQjP60V7z9uFfH5t+lkQDfeah0LFu8/NPowddHrZEB1
R7L7aBbvP8DDsGsE8GRA8RlBuCQX7z/YVrBYavhkQOm+XjGcGO8/CH2vMjYJ
ZUDZCJojixvvP85h761PC2VAF3LhAekb7z+URi8paQ1lQFXbKOBGHO8/IBCv
H5wRZUDRrbecAh3vPzijrgwCGmVAyVLVFXoe7z9oya3mzSplQLicEAhpIe8/
Lq7tYecsZUD2BVjmxiHvP/SSLd0AL2VANG+fxCQi7z+AXK3TMzNlQLBBLoHg
Iu8/RkHtTk01ZUDuqnVfPiPvPwwmLcpmN2VALBS9PZwj7z+Y76zAmTtlQKjm
S/pXJO8/XtTsO7M9ZUDmT5PYtSTvP2isD431PWVAocGKbcEk7z+uo9pX
          "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQPSP4QxGXU6rDzT0JUomq7+03NK1Z+9851WGaYt3B
RUD+CdE1s1J9Uh0CYkNi9qi9t+/79Vq03i/Vwf4N52Em9ff2Ife1J84ISHXQ
rd6v6QnkP1ixuv10SKoD10yt71eB/B/Wq0sMY1MdjlxhmPRe4729ZtIqv7+5
qQ4WPmuPK2kDzZ9rteFTfqpDzZoHxSlAftrNU4IvClMdDvCIKCwD8pcEvL5y
qTTVwfNsVYWmznt7BXud6BW1qQ5Rfh6aBrrv7cVk1qUH96Y61AY87rLVf2/P
dG1jw8o1qQ6HQiT9Iozf29/23Lkp9HWqg3ds65Ve6/f2Tv5LIkrfpjr41jBx
XQXyV4X0/5vyHui/2fX2Mjbv7aviU72ufE51CLlZuWoVkC9VKvgo6E+qQ2xo
XsNx2/f2EQsyBQN40xwKfMN1GB3e21/7JlngpZ/mMMVWs6XE5b293R8WsSzD
NIdpMct27gbylzF+2N1pnOYws1r5PZPre/synmPsJ83THObulI2aCOSLKhXN
d3dIc1hmKmSwzg0Ynr6nzrkEpjns1P19+7nHe/tLi6t07YvTHO7KnjWO9n1v
L8SwbadVaZqDKd+JdXOB/OCYj65m5WkOvf8OaT4A8q+IZMTpVqc52N7fIZ/q
994+Yw1/79faNId9J0ozDgH5AA3f44g=
          "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAGIQPSP4QxFXU5rD+dXHq6L839vfSTf4+H1SmkPAuYnW
AkHv7Z9qP9uyYVOaA/dVPW+V8Pf2PzYH2ih9SnNoeJSR5ZP43p7Hwuyc8Jc0
h9PVpUJzgHyFPVIJrN/SHMREm3a9BvI9jjxufvEzzWGN+2yu7qT39jOvlJ5e
x5jucH3N2VUnk9/bW32dGWUtmO6gV2702i3tvX2N2aOKEIN0hzvcf7Ids9/b
T9h1jMvNKN1BfSmHyEQgf4nd6jnmJukOhXaiex4A+WfcSg5IWaQ7sBfq8TTk
vLeXDWfjeGif7mB8LWHNvtz39vvKtabn+qc7dC04+sa64L39/x1FW9vy0h3M
TftzzUqB/mXb1L2oIN1hf93Nmz1A/q6Qj4n7itIdPE4ouz0G8ks+5PN9K0t3
iIzeITeh7L39C/Xc9NT6dIeqxofnX5a/t780LV3SZUK6w96zxkZzq97br3+y
7H38pHQHN/G6eZ+B/B6jZ0erp6Q7nEs4weVV/d7e/VxK0eYZ6Q73P8c8/gbk
72FNOq20MN2BQaptSkDte/ulJTG1jJvSHZzTbnxjbnhv33RodrDslnSHM+uV
kqOA/ASB25qW29IdQn7mnN8A5NvGSTGE7kh3uOu03Zq98b291JrIawW70h1S
exhXxAL533/OWNOzJ93h7VVvkS1AfsYa/t6ve9MdInaZ3XoL5AMAK+T6tw==

          "]], LineBox[CompressedData["
1:eJwV0WtIkwEYBeA5kdBcYUqWLUHpSpQu15QRfG9XDXPmdJhJgpp9r5hoXsrh
FTOb140ML9mYYUlZiRkmYszazBFOMmUYKtSicKX5DVHXLLO3H4fD8+/ACUjJ
kqfxeTzeXsr/bo6153gYWCjxzI46X84xGaJGtz9DLLDBMWIlOaLUMu1rYiFp
VjKsIbvuiFNFj7AQqeD/GCQXyGOs+gkWdotaRP43OEbRpumbsrAgtJUYj5AP
L7yvW5lkwVt3SRFF/lklkx6aYYEnCFYWkVPeRDZov7IwbRt+PUWODD59qmiZ
BU3bUnRTBcfwLBaXPAcLMm2C7Bn5pTJNn+FkwfOu/qyRHGisCE1cY0HVoDrD
kVcVxv1SN4TSSuGJ8Jsc01kIm375IGRdOSlxkN1N0slcMUJU2B1h/C2OMV0M
Ss/IRdg4FvJ9azXHbEnFAW0+QqE6/VoQOQnvC8auI8zJdK4R5JUc7x5xEYJ5
1MNfSd6lcqyuVSDUjljl0+SynsFaTSOCwKR+pavhGOmGc929/Qib9XPqfXUc
U+lZxbcN0L7igJ3HyB+8DHF+egT70fjOBDIKxc4SA8LYgGGomtwk2nY8YgRB
09/inCcvJX6emJpB8OoNT31ezzGQvH2P4BNCeV6x/R255rK8gLEiLIa8KP5C
Drw6JHzwDWG8x7/ZW80xMZWP0jIXEG53L5vzyfdqrH06O4Jr9oEL9WSbxs9j
fBEhNyh5toNc1lrbJXEgxHaZXT6SzW1veelOBGMmX20n+3b8lbf+Rgg5GCZ0
19CfT0Ifjq4htM9nPg4gd3VnO9bXEXyetkuk5H/CjTcF
          "]]},
        Annotation[#, "Charting`Private`Tag$70304#1"]& ], 
       TagBox[
        {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAIo/9o54e0T7K1hoTDAdEPrcIKR9t
aK8/HngfJBVfIj/BeK6kKGi/P+lRBxbtXjI/xjBxZwZozz/OPvsO2V5CP8iM
0kj1Z98/QDV1C89eUj/JOoO57GfvP3kwsgnKXmI/ypHbcehn/z8WrtCIx15y
P0q9B07mZw9A5OxfSMZegj8x/2L1FvAPQBbhwqVvroI/jCBfziM8EEBI1SUD
Gf6CP3RiunVUxBBArb3rvWudgz9E5nDEtdQRQHaOdzMR3IQ/4u3dYXj1E0AH
MI8eXFmHPyD9t5z9NhhAK3O+9PFTjD8UnmXwFXsYQF1nIVKbo4w/CD8TRC6/
GECPW4SvRPOMP++AbuteRxlA80NKapeSjT++BCU6wFcaQLsU1t880Y4/XQyS
14J4HEAn23blQ6eQP80NNgkEXSBAuHyO0I4kkz/SSxKYznwgQEozu8e/SZM/
2InuJpmcIEDd6ee+8G6TP+QFp0Qu3CBABFdBrVK5kz/8/ReAWFshQFEx9IkW
TpQ/Ajz0DiN7IUDk5yCBR3OUPwh60J3tmiFAd55NeHiYlD8T9oi7gtohQJ0L
p2ba4pQ/Ku759qxZIkDo5VlDnneVPzAs1oV3eSJAfJyGOs+clT82arIUQpki
QA9TszEAwpU/QuZqMtfYIkA1wAwgYgyWP0gkR8Gh+CJAyXY5F5Mxlj9OYiNQ
bBgjQFwtZg7EVpY/Wd7bbQFYI0CBmr/8JaGWP14cuPzLdyNAE1Hs81bGlj9k
WpSLlpcjQKcHGeuH65Y/aphwGmG3I0A6vkXiuBCXP3DWTKkr1yNAzXRy2ek1
lz+IxvrQWN8jQMbpr4t6P5c/Rroaxw==
          "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAeDkFL6cgJEBzDxyYB+KXP4jOveRV
ViRA9Ru8d3eumD+ODJpzIHYkQKR+xT+JJ5k/lEp2AuuVJEBS4c4Hm6CZP5/G
LiCA1SRAq6bhl76Smj+2vp9bqlQlQGAxB7gFd5w/5a6B0v5SJkBoIyn8yR+g
P0KPRcCnTyhA1Dh0PFjooz+ASrSp0m4oQCB4rSOxI6Q/vgUjk/2NKEBtt+YK
Cl+kPzp8AGZTzChABTZZ2bvVpD8zabsL/0gpQDgzPnYfw6U/JEMxV1ZCKkCb
LQiw5p2nPwb3HO4ENSxAYiKcI3VTqz9lL/oNMQ0wQPcFYgVJX7E/TNuHpRge
MECEOxVUeX+xPzSHFT0ALzBAFHHIoqmfsT8E3zBsz1AwQDPcLkAK4LE/oo5n
ym2UMEBtsvt6y2CyP9/t1IaqGzFA416V8E1isz9ZrK//IyoyQM63yNtSZbU/
QFg9lws7MkBc7Xsqg4W1PygEyy7zSzJA7CIvebOltT/4W+Zdwm0yQAqOlRYU
5rU/lgsdvGCxMkBEZGJR1Wa2P9NqinidODNAuhD8xldotz+6FhgQhUkzQEhG
rxWIiLc/osKlp2xaM0DYe2JkuKi3P3IawdY7fDNA9ubIARnptz8Qyvc02r8z
QDC9lTzaabg/RGN9aKzvM0BsSbQB6cS4P+472ZQ=
          "]], 
         LineBox[{{20.06377551020408, 0.09787075987419762}, {
          20.400947900007537`, 0.10126379267387264`}, {20.524201968382854`, 
          0.10250412287094074`}, {20.77071010513348, 0.10498478326507685`}, {
          21.263726378634736`, 0.10994610405334908`}, {22.249758925637252`, 
          0.11986874562989361`}, {24.221824019642277`, 
          0.13971402878298256`}, {28.496165225764553`, 
          0.18272757422135455`}, {29.93622448979592, 0.19721917692696916`}}], 
         LineBox[{{30.06377551020408, 0.1986329655829274}, {36.60690926377435,
           0.2778376473835592}, {39.93622448979592, 0.31813903247249314`}}], 
         LineBox[{{40.06377551020408, 0.31960862857539707`}, {
          44.81400757831468, 0.37156790010310176`}, {48.698587548467465`, 
          0.41405844425888083`}, {49.93622448979592, 0.42759603841536614`}}], 
         LineBox[{{50.06377551020408, 0.429019128312482}, {
          56.846135645150525`, 0.5061738328130881}, {59.93622448979592, 
          0.5413260345460498}}], 
         LineBox[{{60.06377551020408, 0.5426871161687816}, {65.29411965101717,
           0.5948125682284161}, {69.19710165050657, 0.6337095691956173}, {
          69.93622448979592, 0.6410756451340867}}], 
         LineBox[{{70.06377551020408, 0.6422631035885429}, {77.38145380586288,
           0.7055857451358091}, {77.4483502145483, 0.7061646250942926}, {
          77.51524662323371, 0.7067435050527759}, {77.64903944060455, 
          0.7079012649697429}, {77.91662507534625, 0.7102167848036768}, {
          78.4517963448296, 0.7148478244715445}, {78.51869275351503, 
          0.715426704430028}, {78.58558916220045, 0.7160055843885115}, {
          78.71938197957128, 0.7171633443054782}, {78.98696761431296, 
          0.7194788641394121}, {79.52213888379632, 0.7241099038072798}, {
          79.58903529248174, 0.7246887837657632}, {79.65593170116716, 
          0.7252676637242468}, {79.789724518538, 0.7264254236412135}, {
          79.85662092722342, 0.727004303599697}, {79.92351733590883, 
          0.7275831835581804}, {79.93622448979592, 0.7276931433730517}}], 
         LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAL6fg5RQEVEAtzNxDKVHnP61lFADz
B1RA7y/Lr1xU5z8yR/QHOwxUQJT1qcbnV+c/PAq0F8sUVEDegGf0/V7nP0+Q
MzfrJVRAcZfiTypt5z+cqDG1a2pUQL/xzr3bpec/yNljyJ9uVECNcqtQVqnn
P/QKltvTclRAXPOH49Cs5z9LbfoBPHtUQPn0QAnGs+c/+jHDTgyMVEA0+LJU
sMHnP1m7VOisrVRAqv6W64Td5z8Wzncb7vBUQJULXxkuFeg/kfO9gXB3VUBt
Je90gIToP27SkGFce1VAYzq3Rr+H6D9MsWNBSH9VQFtPfxj+iug/Bm8JASCH
VUBIeQ+8e5HoP3zqVIDPllVAJM0vA3ee6D9m4et+LrZVQNl0cJFtuOg/PM8Z
fOz0VUBHxPGtWuzoPxmu7FvY+FVAPdm5f5nv6D/2jL87xPxVQDTugVHY8ug/
sUpl+5sEVkAiGBL1VfnoPybGsHpLFFZA/GsyPFEG6T8RvUd5qjNWQLMTc8pH
IOk/7psaWZY3VkCqKDuchiPpP8x67TiCO1ZAoT0DbsUm6T+GOJP4WUNWQI5n
kxFDLek//LPedwlTVkBqu7NYPjrpP+aqdXZoclZAIGP05jRU6T9WHf7eqHZW
QESB3q65V+k/xY+GR+l6VkBon8h2PlvpP9FYHxrre1ZAUopk1xNc6T8tLPuc

          "]], 
         LineBox[{{90.06377551020408, 0.7932278283214113}, {90.11978176227086,
           0.7935137134194672}, {90.18621293487926, 0.793852812744887}, {
          90.31907528009609, 0.7945310113957262}, {90.85052466096337, 
          0.7972438059990838}, {91.91342342269793, 0.8026693952057989}, {
          94.03922094616706, 0.8135205736192291}, {98.00878211325836, 
          0.8337832825421551}, {99.93622448979592, 0.8436219529133968}}], 
         LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAL6fg5RQEWUDV3XTb0wPrP4gX903S
h1pAT/3bGL3V6z+UyMjjwotaQF8Epx3f1+s/n3maebOPWkBvC3IiAdrrP7bb
PaWUl1pAjxkILEXe6z/ln4T8VqdaQM81ND/N5us/QigSq9vGWkBPboxl3ffr
P/w4LQjlBVtATt88sv0Z7D8I6v6d1QlbQF/mB7cfHOw/E5vQM8YNW0Bu7dK7
QR7sPyr9c1+nFVtAjvtoxYUi7D9Zwbq2aSVbQM4XldgNK+w/tklIZe5EW0BO
UO3+HTzsP8L6GfveSFtAXle4A0A+7D/Nq+uQz0xbQG5egwhiQOw/5A2PvLBU
W0CObBkSpkTsPxPS1RNzZFtAzohFJS5N7D8eg6epY2hbQN2PECpQT+w/KjR5
P1RsW0DultsuclHsP0KWHGs1dFtADqVxOLZV7D9OR+4AJnhbQB6sPD3YV+w/
0VgfGut7W0C4Mya34lnsP2zKp2I=
          "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAL6fg5RSEW0DT4t+Dnl3sPw6f6uA8
iFtAmnscwytf7D+s43H/gYxbQCjdauPDYOw/52yAPAyVW0BDoAck9GPsP15/
nbYgpltAeCZBpVRq7D9MpNeqSchbQOMytKcVd+w/KO5Lk5sMXEC6S5qsl5Ds
P+GBNGQ/lVxAZ31mtpvD7D8mFg6OcJlcQBWIVWMsxew/aqrnt6GdXEDDkkQQ
vcbsP/TSmgsEplxAH6giat7J7D8IJAGzyLZcQNbS3h0h0Ow/LsbNAVLYXEBE
KFeFptzsP3oKZ59kG11AINNHVLH17D+/nkDJlR9dQM7dNgFC9+w/BDMa88Yj
XUB86CWu0vjsP41bzUYpLF1A2P0DCPT77D+grDPu7TxdQI8owLs2Au0/x04A
PXdeXUD9fTgjvA7tPxSTmdqJoV1A2igp8sYn7T8K1RPRcqVdQOECKKo8Ke0/
ABeOx1upXUDo3CZisirtP+2agrQtsV1A9pAk0p0t7T/GomuO0cBdQBL5H7J0
M+0/vOTlhLrEXUAZ0x5q6jTtP7ImYHujyF1AIK0dImA27T+fqlRoddBdQC5h
G5JLOe0/eLI9QhngXUBLyRZyIj/tP270tzgC5F1AUqMVKphA7T9kNjIv6+dd
QFl9FOINQu0/UbomHL3vXUBnMRJS+UTtP0j8oBKm811AbgsRCm9G7T8+PhsJ
j/ddQHXlD8LkR+0/NICV/3f7XUB8vw56WkntP9FYHxrr+11AeKKpc4VJ7T/U
/AsI
          "]], 
         LineBox[{{120.06377551020408`, 0.9155255077237506}, {
          120.2346687249738, 0.9158328995053004}, {120.47904440930093`, 
          0.9162724668519268}, {120.54013833038272`, 0.9163823586885834}, {
          120.6012322514645, 0.91649225052524}, {120.72342009362805`, 
          0.9167120341985531}, {120.96779577795519`, 0.9171516015451795}, {
          121.45654714660944`, 0.9180307362384321}, {122.43404988391794`, 
          0.9197890056249375}, {122.50030335215772`, 0.9199081781249312}, {
          122.56655682039751`, 0.920027350624925}, {122.69906375687708`, 
          0.9202656956249126}, {122.96407762983623`, 0.9207423856248876}, {
          123.4941053757545, 0.9216957656248379}, {124.55416086759107`, 
          0.9236025256247384}, {126.67427185126418`, 0.9274160456245394}, {
          129.9362244897959, 0.9332834373418788}}], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgpCYEAp59NhY9/tP718+gBo
0GBAEctq2nwk7j/2r+bwgtJgQMjSf2+CJe4/MOPS4J3UYEB+2pQEiCbuP6RJ
q8DT2GBA7Om+LpMo7j+KFlyAP+FgQMYIE4OpLO4/VrC9/xbyYEB7Rrsr1jTu
P+/jgP7FE2FA5MELfS9F7j8oF23u4BVhQJrJIBI1Ru4/YkpZ3vsXYUBR0TWn
OkfuP9awMb4xHGFAv+Bf0UVJ7j+8feJ9nSRhQJn/syVcTe4/iBdE/XQ1YUBN
PVzOiFXuPyFLB/wjV2FAt7isH+Jl7j801UPSGllhQM6gJS/WZu4/Rl+AqBFb
YUDliJ4+ymfuP2pz+VT/XmFAE1mQXbJp7j+0m+ut2mZhQG/5c5uCbe4/xiUo
hNFoYUCG4eyqdm7uP9ivZFrIamFAncllumpv7j/9w90Gtm5hQMuZV9lSce4/
RuzPX5F2YUAnOjsXI3XuP1h2DDaIeGFAPiK0Jhd27j9qAEkMf3phQFUKLTYL
d+4/fIqF4nV8YUBs8qVF/3fuP2isD431fWFAu6Owfbl47j9Ge810
          "]], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgqCYUAQgZIeU3ruP9g8tBFI
hmFAtXxoYZd77j/qxvDnPohhQP5tUJItfO4//FAtvjWKYUBHXzjDw3zuPyFl
pmojjmFA2kEIJfB97j9qjZjD/pVhQP8GqOhIgO4/fBfVmfWXYUBI+I8Z34Du
P46hEXDsmWFAkel3SnWB7j+ztYoc2p1hQCPMR6yhgu4//N18dbWlYUBIkedv
+oTuP48uYSdstWFAkhsn96uJ7j+0zymL2dRhQCYwpgUPk+4/kCPBpfrWYUC2
eXXWsZPuP2t3WMAb2WFARcNEp1SU7j8iH4f1Xd1hQGNW40iale4/j27kX+Ll
YUCffCCMJZjuP2oNnzTr9mFAF8maEjyd7j8gSxTe/BhiQAhijx9pp+4/jMb+
MCBdYkDqk3g5w7vuP0Bx5jEdX2JAA8rnQVu87j/0G84yGmFiQBwAV0rzvO4/
XHGdNBRlYkBPbDVbI77uPy0cPDgIbWJAtETyfIPA7j/OcXk/8HxiQH31a8BD
xe4/EB30TcCcYkAQV19HxM7uP2isD431vWJAuM18fq/Y7j9uLc1D
          "]], 
         LineBox[{{150.0637755102041, 0.9640810869802467}, {151.0086021630023,
           0.9649078677167741}, {151.13043459642864`, 0.9650144784995487}, {
          151.37409946328125`, 0.9652277000650978}, {151.86142919698653`, 
          0.9656541431961964}, {152.83608866439704`, 0.9665070294583932}, {
          154.78540759921805`, 0.9682128019827869}, {159.0142564869723, 
          0.9719133017387216}, {159.9362244897959, 0.9727200797674442}}], 
         LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAmFPwcgoCZEBcQ6hvdiHvP/iwmI7k
YGRAeS9WNOQ37z/rbS8ECGNkQFnOOqhlOO8/0Odc705nZEAaDASQaDnvP5rb
t8Xcb2RAnIeWX2477z8uw21y+IBkQKB+u/55P+8/VpLZyy+jZECnbAU9kUfv
P0hPcEFTpWRAhwvqsBJI7z87DAe3dqdkQGiqziSUSO8/IIY0or2rZEAp6JcM
l0nvP+p5j3hLtGRAq2Mq3JxL7z9+YUUlZ8VkQK5aT3uoT+8/pzCxfp7nZEC2
SJm5v1fvP24V8fm36WRAnZR90T5Y7z80+jB10etkQIPgYem9WO8/wMOwawTw
ZEBQeCoZvFnvP9hWsFhq+GRA6qe7eLhb7z8Ifa8yNgllQB0H3jexX+8/zmHv
rU8LZUAEU8JPMGDvP5RGLylpDWVA6p6mZ69g7z8gEK8fnBFlQLc2b5etYe8/
OKOuDAIaZUBRZgD3qWPvP2jJrebNKmVAhMUitqJn7z8uru1h5yxlQGsRB84h
aO8/9JIt3QAvZUBRXevloGjvP4BcrdMzM2VAHvWzFZ9p7z9GQe1OTTVlQARB
mC0eau8/DCYtymY3ZUDrjHxFnWrvP5jvrMCZO2VAuCRFdZtr7z9e1Ow7sz1l
QJ5wKY0abO8/aKwPjfU9ZUBhFZc7KmzvPwt86Kc=
          "]], LineBox[CompressedData["
1:eJwVzmlIE2AcBvApHhBZbOSZUonlkVJLLfDo/aeVR6Zrm7HIiqb/V63mMd00
TUtZqZGFB6JBZanNdJYJSbOQsJK8+jBl0CGNQshWvh4lFbZ6+/Dw8Pvy8GxS
5krRXiAQ+PP872bZvHpVDELBhsCEyTOM9FYaev7GIgwUNyzZuLWZXwM89yM0
jZYOh6gYiUoKbt8Rj6D2zmhJ437lariOSQiBz8LIAPfV31bX88kIjiIf0Sy3
/MPWumYJgiXdccY9hxFLZ3fVmByh2dl8WcP9M7K7UHwMwSmlyLw9l5FAZVfy
HxXCp2mjSp/H929E9C7mIoiCLq2f5KZvRoWf8xFAKx2xcbdLrFMmDcLNNVa/
w/mMbCTBRzvLEBTE+72DmhE37/uZslqEidbyRGUBI/bmhxfuGRD602P9fbSM
vEsw9qVaEWpmxy31pYzEpLQrNN8QtA+iooe4u+TXbI0MIUNjaFngLjmBiVNL
CMTuilRyjhEvjfCjdAVh2ePAC5cyRhSt2UKJC4X0+BF9dTkj5mXPvMRtFKL1
L3PKKxjZveLgdkpMIUgVPtbDfddu/klNKAWP0A7/aW7t6mHnkV0UlgZ1lshK
Rlx91bfigEKXOVb6i1t+cPT13kMU3J2Gwgt1jDyVPirMkFFwGBfXt3H7KVq9
dKkUFutuz5m4vyu19PkRChM+FXrxRUYain1te5QUdOHgybhNbSUhpIDCQsbg
SnYVIyJBvzFCQ0G8WRTWxC1LW9i3s4iCegZPD3E3Pg42ic9S6Osw3pnjnlqX
dTyklP9Fl7de1fxvftuXgDIKoVtOCuO4swxra39w+435zii4/wEWBygv
          "]], LineBox[CompressedData["
1:eJwV0H8s1HEcx3E0hkpSEzeabpyhH+bHoeTznhr1R6ucrURzWT5vMbndLl1D
GZvkx7pMuiPKhStdquPEdWRNyu6mzsyauyylm7bqQ/Jr/aFvf7z23OPf166s
gpRsJwcHhyBu/6sUzUvdyygYyzcXTFQycjrBrPG6TiFN/spSf4ORqeXEIbdq
CqPN07m7qxixYfjCSh2Fh3N+zenVjPgN55Us1lMQF2kvaDifDdC4sQYKPh7x
wkXO0x/9+fZGCpWR6e+rahj5fHSjaEJNAa+qHA21jHwLs/c801EI2u5NfRSM
rHafjOf/phCQ57p6S8XIpljh2LY/FLwqdibbOAcYeWLnZQobWqMaBI2MHBn+
Wj63RsE+KY56yVk1ccnU5YigTeyXzDYxsn9JdebAVoRYXu53YQsjxcIv8tRw
hBOjpimrmhGFYcQ9KQIhcXYmRPCAkbaEx3djohAi11fkEs7mJNkQLxbBOzpw
h3MbI/6nXFxnCILtfrFobzsjg5dD7+QfR8iR7zGXahhZ75PqKy4ilAbfHAjS
cn+56KrVEoTbv5QZhZwNqQvnBqUIj/TqvyOcZfMFHsuFCOOHeuNynjAyF5yP
2dcQAsWf9J1djIw3oO9hBcJbZVjXvueMPJ3tYJl1CNbM6GOlnGsi7G+K6hHm
BeTHB87JY+el3UoEX31KqFTHiNE5y8RvRci1XOno6WakXZZR4qhD8HB/1xLX
y0jZ6yaRfw8C32I5WMVZ7GkNietFiFFabVOcedq0SYkBIVPAeMUvGFlZU2pr
jAiyn6v9Zs452i21SwMInp1O95z6GPkHaG4oqw==
          "]], LineBox[CompressedData["
1:eJwVz38sFGAcx/HD1A5XI42OtUg/VJLya2fzfLMVxeTO2Yw0XeN5uElcypVV
YiLXdqumHzqnlXJZZjYuP7pbh13t4kKX7WjRKKu5R1auI+npj8/ee/35CZAU
inKcORzODrb/vZs6X+xmwNAsmdt56QVF0rA61z/9GMYVfLOeOeGyZdzHiOHp
9+sfbMwufuLqYyYMSCOdSeqiqFQknNKNYigMCnHhdlOU1qjUWi0YYipUbtHM
+23mG4tjGNZ85nlh5rmaZMHeCQwNatuWAWbJq8RbqmkMQ/y22PIeihL3HT5U
9gtDiOeBC45eijgWi9NZO4ak/GvHt72kqFOeo5M6MEj7xmOFzIF9lVGZKxg0
JZUuGualtL5ggSuBIKtFka6j6NlFWPfbm4Dfo1K1Vk8R1ygYk4UT4Ebo+ksM
FBmzQvOkMgLT6UfWLxgp8jpFelQlBHKLdntsfU3RCfKQ9+48ga81PK6YebF4
Q3t4GYFv3cPOncxB1fallUoC8/4Zi/I3FF1p1yuUdQSWJ/M/OpkoEqxNaevo
IuCVp2jxHKKoyqPGebaHwO3y081xzMOeBjFfR2Dj/ZQmGTPxD3dcMhDwNXmr
Lcx3wnzjEkwENoeobt4zU/Qzc3LUOkFg14/n8oBhiuDkpu28TwRauMpzIuba
XFEpmiKwJ7BYVsEcWNTv/3iGQGhqZMEMs7CqOafARiCiQ5etGaHoQe2UVj1P
QDvYmGVlnlXy3UYWCER/uZrhPsr+1CtaI+0EYnzixQXMbxsHOHkOAr2hwcIG
Zp8nf0X1ywRiE9yTzcySlqimwRUC+uy5o5z3FLW2nbGvrhI4KDfHhzH/Az8f
PB8=
          "]]},
        Annotation[#, 
         "Charting`Private`Tag$70304#2"]& ], {}}, {{}, {}, {}, {}, {}}, {{}, \
{}, {}, {}, {}}}, {}}, InsetBox[
     TemplateBox[{
      StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
       "\"KO\"", 20, StripOnInput -> False]},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->0.6,
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{Automatic, Automatic},
   DisplayFunction->Identity,
   Frame->{{True, False}, {True, False}},
   FrameLabel->{{
      FormBox[
       StyleBox["\"Cumulative distribution\"", 20, 
        GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
      FormBox[
       StyleBox["\"Center-to-center distance (nm)\"", 20, 
        GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
   FrameStyle->Directive[
     GrayLevel[0], FontSize -> 20, 
     AbsoluteThickness[2]],
   FrameTicks->FrontEndValueCache[{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{Automatic, {{0., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {0.2, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {0.4, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {0.6, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {0.8, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {1., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-0.2, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-0.15, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-0.1, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-0.05, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.05, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.1, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.15, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.25, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.3, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.35, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.45, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.5, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.55, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.65, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.7, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.75, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.85, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.9, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {0.95, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {1.05, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {1.1, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {1.15, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {1.2, 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {50., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {100., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {150., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {200., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 0.}, {
          AbsoluteThickness[0.1]}}, {-50., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-40., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-30., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-20., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {-10., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {10., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {20., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {30., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {40., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {60., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {70., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {80., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {90., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {110., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {120., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {130., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {140., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {160., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {170., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {180., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {190., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {210., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {220., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {230., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {240., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}, {250., 
         FormBox[
          TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
          AbsoluteThickness[0.1]}}}}}],
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImagePadding->All,
   ImageSize->500,
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           GrayLevel[0], 
           AbsoluteThickness[2]], 
          Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAIo/9o54e0T5wuol8E+xGPrcIKR9t
aK8/qXuQpNUGJT/BeK6kKGi/P5aCacynBjU/xjBxZwZozz8MBlbgkAZFP8iM
0kj1Z98/x0dMaoUGVT/JOoO57GfvP6VoR69/BmU/ypHbcehn/z8U+cTRfAZ1
P0q9B07mZw9AS8EDY3sGhT8x/2L1FvAPQNtogUWoYYU/jCBfziM8EEBsEP8n
1byFP3RiunVUxBBAjl/67C5zhj9E5nDEtdQRQNP98Hbi34c/4u3dYXj1E0Ba
Ot6KSbmKPyD9t5z9NhhAtVlc2Qs2kD8UnmXwFXsYQH0tm0qiY5A/CD8TRC6/
GEBGAdq7OJGQP++AbuteRxlA1qhXnmXskD++BCU6wFcaQPj3UmO/opE/XQyS
14J4HEA8lkntcg+TP80NNgkEXSBAw9I2AdrolT/SSxKYznwgQNG5EBFrE5Y/
2InuJpmcIEDfoOog/D2WP+QFp0Qu3CBA/W6eQB6Tlj/8/ReAWFshQDcLBoBi
PZc/Ajz0DiN7IUBG8t+P82eXPwh60J3tmiFAVNm5n4SSlz8T9oi7gtohQHCn
bb+m55c/Ku759qxZIkCqQ9X+6pGYPzAs1oV3eSJAuCqvDny8mD82arIUQpki
QMcRiR4N55g/QuZqMtfYIkDk3zw+LzyZP0gkR8Gh+CJA88YWTsBmmT9OYiNQ
bBgjQAGu8F1RkZk/Wd7bbQFYI0AdfKR9c+aZP14cuPzLdyNAK2N+jQQRmj9k
WpSLlpcjQDlKWJ2VO5o/aphwGmG3I0BIMTKtJmaaP3DWTKkr1yNAVxgMvbeQ
mj+IxvrQWN8jQCN7Ulqqm5o/SPcbPw==
           "]], 
          Line[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAeDkFL6cgJEBSBgGJf0ubP4jOveRV
ViRAgNUHprEknD+ODJpzIHYkQFhHGrpRpZw/lEp2AuuVJEAxuSzO8SWdP5/G
LiCA1SRA35xR9jEnnj+2vp9bqlQlQB+yTSPZFKA/5a6B0v5SJkCAeZdzWRei
P0KPRcCnTyhAQAgrFFocpj+ASrSp0m4oQFYUrShnW6Y/vgUjk/2NKEBuIC89
dJqmPzp8AGZTzChAmzgzZo4Ypz8zabsL/0gpQPhoO7jCFKg/JEMxV1ZCKkCy
yUtcKw2qPwb3HO4ENSxAJItspPz9rT9lL/oNMQ0wQAMHV5rP77I/TNuHpRge
MEAUjmguAhKzPzSHFT0ALzBAJhV6wjQ0sz8E3zBsz1AwQEwjneqZeLM/oo5n
ym2UMECSP+M6ZAG0P9/t1IaqGzFAIXhv2/gStT9ZrK//IyoyQD7phxwiNrc/
QFg9lws7MkBOcJmwVFi3PygEyy7zSzJAYfeqRId6tz/4W+Zdwm0yQIYFzmzs
vrc/lgsdvGCxMkDNIRS9tke4P9NqinidODNAW1qgXUtZuT9EY31orO8zQFT/
vZGdy7o/squ0yg==
           "]], 
          
          Line[{{20.06377551020408, 0.1058151373113202}, {20.400947900007537`,
            0.10920794646397577`}, {20.524201968382854`, 
           0.11044819490641075`}, {20.77071010513348, 0.11292869179128062`}, {
           21.263726378634736`, 0.11788968556102036`}, {22.249758925637252`, 
           0.1278116731004999}, {24.221824019642277`, 0.14765564817945895`}, {
           28.496165225764553`, 0.19066635844004126`}, {29.93622448979592, 
           0.2051570059518975}}], 
          
          Line[{{30.06377551020408, 0.20648037498114655`}, {36.60690926377435,
            0.2764126743370994}, {39.93622448979592, 0.3119960320683134}}], 
          
          Line[{{40.06377551020408, 0.3134245454861877}, {44.81400757831468, 
           0.36905546112182064`}, {48.698587548467465`, 0.4145485523015519}, {
           49.93622448979592, 0.42904276548595566`}}], 
          
          Line[{{50.06377551020408, 0.4304676532352566}, {56.846135645150525`,
            0.5025711975919925}, {59.93622448979592, 0.535422056827279}}], 
          Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAXk7ByykITkAOOjpU5izhP7OOOtvS
UlBA59eyyb3U4j9imw4FulZQQNPsDeeu2eI/EqjiLqFaUEDAAWkEoN7iP3DB
ioJvYlBAlysfP4Lo4j8s9NopDHJQQEZ/i7RG/OI/pFl7eEWRUECjJmSfzyPj
P5QkvBW4z1BAXnUVdeFy4z9DMZA/n9NQQEmKcJLSd+M/8j1kaYbXUEA1n8uv
w3zjP1BXDL1U31BADMmB6qWG4z8Milxk8e5QQLsc7l9qmuM/hO/8sioOUUAY
xMZK88HjP3S6PVCdTFFA0xJ4IAUR5D+1WscC2VBRQBc6ukZhFuQ/9vpQtRRV
UUBcYfxsvRvkP3k7ZBqMXVFA5q+AuXUm5D9+vIrkem5RQPlMiVLmO+Q/0Vgf
Gut7UUAIINE56kzkP5c9khs=
           "]], 
          
          Line[{{70.06377551020408, 0.6355166142636701}, {70.321543545807, 
           0.6375242447854211}, {70.38768718670704, 0.6380394056042561}, {
           70.51997446850709, 0.6390697272419256}, {70.78454903210718, 
           0.6411303705172645}, {71.31369815930739, 0.6452516570679427}, {
           73.4302946681082, 0.6617368032706551}, {77.38145380586288, 
           0.6925104702332696}, {79.93622448979592, 0.7124083430984673}}], 
          
          Line[{{80.06377551020408, 0.7132893805617755}, {85.86624187040276, 
           0.7482559203105567}, {89.7876258992288, 0.7718867734689171}, {
           89.93622448979592, 0.772782251047093}}], 
          
          Line[{{90.06377551020408, 0.7735218874360431}, {98.00878211325836, 
           0.8177862789709676}, {98.06958850263175, 0.8181250524876583}, {
           98.13039489200514, 0.8184638260043493}, {98.25200767075194, 
           0.819141373037731}, {98.49523322824552, 0.8204964671044946}, {
           98.9816843432327, 0.8232066552380218}, {99.0424907326061, 
           0.8235454287547127}, {99.1032971219795, 0.8238842022714036}, {
           99.22490990072629, 0.8245617493047854}, {99.46813545821988, 
           0.825916843371549}, {99.52894184759327, 0.8262556168882399}, {
           99.58974823696667, 0.8265943904049308}, {99.71136101571346, 
           0.8272719374383126}, {99.77216740508686, 0.8276107109550035}, {
           99.83297379446026, 0.8279494844716944}, {99.89378018383366, 
           0.8282882579883853}, {99.93622448979592, 0.8285247299602047}}], 
          
          Line[{{100.06377551020408`, 0.8291193396062233}, {
           100.19781213070064`, 0.8296222626848346}, {100.44103768819423`, 
           0.8305348770563284}, {100.9274888031814, 0.8323601057993162}, {
           101.90039103315576`, 0.8360105632852916}, {101.96635696968715`, 
           0.8362580761796107}, {102.03232290621855`, 0.8365055890739297}, {
           102.16425477928135`, 0.8370006148625678}, {102.42811852540696`, 
           0.8379906664398441}, {102.95584601765816`, 0.8399707695943966}, {
           104.01130100216056`, 0.8439309759035017}, {106.12221097116537`, 
           0.8518513885217119}, {109.93622448979592`, 0.8661620702857606}}], 
          Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAL6fg5RSEW0Aue7H7dbvrP+GBNGQ/
lVxAA1Yp9K067D8mFg6OcJlcQGazHb+hPOw/aqrnt6GdXEDIEBKKlT7sP/TS
mgsEplxAjsv6H31C7D8IJAGzyLZcQBlBzEtMSuw/LsbNAVLYXEAuLG+j6lns
P3oKZ59kG11AWAK1Uid57D+/nkDJlR9dQLtfqR0be+w/BDMa88YjXUAevZ3o
Dn3sP41bzUYpLF1A43eGfvaA7D+grDPu7TxdQG3tV6rFiOw/x04APXdeXUCD
2PoBZJjsPxSTmdqJoV1Arq5AsaC37D8K1RPRcqVdQFaHJdxyuew/ABeOx1up
XUD+XwoHRbvsP+2agrQtsV1AUBHUXOm+7D/GomuO0cBdQPJzZwgyxuw/vOTl
hLrEXUCaTEwzBMjsP7ImYHujyF1AQiUxXtbJ7D+fqlRoddBdQJPW+rN6zew/
eLI9QhngXUA1OY5fw9TsP270tzgC5F1A3hFzipXW7D9kNjIv6+ddQIbqV7Vn
2Ow/UbomHL3vXUDXmyELDNzsP0j8oBKm811AgHQGNt7d7D8+PhsJj/ddQChN
62Cw3+w/NICV/3f7XUDRJdCLguHsP9FYHxrr+11Axc/xJrjh7D+xS+Ro
           "]], 
          
          Line[{{120.06377551020408`, 0.9029053207411446}, {120.2346687249738,
            0.9032259276818723}, {120.47904440930093`, 0.9036843925814059}, {
           120.54013833038272`, 0.9037990088062893}, {120.6012322514645, 
           0.9039136250311727}, {120.72342009362805`, 0.9041428574809394}, {
           120.96779577795519`, 0.904601322380473}, {121.45654714660944`, 
           0.9055182521795401}, {122.43404988391794`, 0.9073521117776743}, {
           122.50030335215772`, 0.9074764076532804}, {122.56655682039751`, 
           0.9076007035288867}, {122.69906375687708`, 0.9078492952800991}, {
           122.96407762983623`, 0.9083464787825238}, {123.4941053757545, 
           0.9093408457873733}, {124.55416086759107`, 0.9113295797970724}, {
           126.67427185126418`, 0.9153070478164705}, {129.9362244897959, 
           0.9214266860809132}}], 
          Line[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgpCYEBdXFqnSX7tP718+gBo
0GBAKRgkd6nC7T/2r+bwgtJgQH6TZE2sw+0/MOPS4J3UYEDUDqUjr8TtP6RJ
q8DT2GBAgAUm0LTG7T+KFlyAP+FgQNbyJynAyu0/VrC9/xbyYECDzSvb1tLt
P+/jgP7FE2FA3IIzPwTj7T8oF23u4BVhQDL+cxUH5O0/YkpZ3vsXYUCHebTr
CeXtP9awMb4xHGFAM3A1mA/n7T+8feJ9nSRhQIldN/Ea6+0/iBdE/XQ1YUA2
ODujMfPtPyFLB/wjV2FAj+1CB18D7j801UPSGllhQHVo+4ZQBO4/Rl+AqBFb
YUBb47MGQgXuP2pz+VT/XmFAJtkkBiUH7j+0m+ut2mZhQLzEBgXrCu4/xiUo
hNFoYUCiP7+E3AvuP9ivZFrIamFAh7p3BM4M7j/9w90Gtm5hQFOw6AOxDu4/
RuzPX5F2YUDpm8oCdxLuP1h2DDaIeGFAzhaDgmgT7j9qAEkMf3phQLSROwJa
FO4/fIqF4nV8YUCZDPSBSxXuP2isD431fWFA+oenxQMW7j9ogcji
           "]], 
          
          Line[{{140.0637755102041, 0.9403976343237692}, {140.1962975044505, 
           0.940585982809054}, {140.25767895724067`, 0.9406732219403647}, {
           140.31906041003083`, 0.9407604610716753}, {140.44182331561117`, 
           0.9409349393342966}, {140.68734912677184`, 0.9412838958595392}, {
           140.748730579562, 0.9413711349908498}, {140.81011203235215`, 
           0.9414583741221604}, {140.9328749379325, 0.9416328523847817}, {
           141.17840074909316`, 0.9419818089100243}, {141.6694523714145, 
           0.9426797219605094}, {142.65155561605718`, 0.9440755480614796}, {
           146.91017961274008`, 0.950128168864042}, {149.9362244897959, 
           0.9544289717023818}}], 
          Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAmFPwcgrCYkD1eDZkDIzuP3wVHg8i
WWNAD+KR+Dm67j/NsQlaP1tjQNghwGffuu4/Hk71pFxdY0ChYe7WhLvuP7+G
zDqXYWNAMuFKtc+87j8C+HpmDGpjQFTgA3Jlv+4/h9rXvfZ6Y0CY3nXrkMTu
P5KfkWzLnGNAIdtZ3ufO7j/jO3236J5jQOoaiE2Nz+4/NNhoAgahY0CyWra8
MtDuP9UQQJhApWNAQ9oSm33R7j8Ygu7Dta1jQGbZy1cT1O4/nmRLG6C+Y0Cq
1z3RPtnuP6kpBcp04GNAM9QhxJXj7j/SHEH7beJjQG/8yiow5O4//A99LGfk
Y0CqJHSRyuTuP0729I5Z6GNAIXXGXv/l7j/0wuRTPvBjQA8Wa/lo6O4/HrYg
hTfyY0BKPhRgA+nuP0epXLYw9GNAhma9xp3p7j+aj9QYI/hjQP22D5TS6u4/
xIIQShz6Y0A437j6bOvuP+11THsV/GNAdAdiYQfs7j9orA+N9f1jQLaUZxqa
7O4/tkHI4Q==
           "]], 
          Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAmFPwcgoCZEDFsW4Fle3uP+YotKLs
B2RAK16WEZzu7j+M9aNn0Q9kQI6VPfz87+4/2I6D8ZofZEBVBIzRvvLuPwKC
vyKUIWRALtI1DBfz7j8rdftTjSNkQAeg30Zv8+4/fltztn8nZEC4OzO8H/Tu
PyQoY3tkL2RAHHPapoD17j9vwUIFLj9kQOLhKHxC+O4/BvQBGcFeZEBwv8Um
xv3uP6cwsX6e52RA+XQjP60V7z9uFfH5t+lkQDfeah0LFu8/NPowddHrZEB1
R7L7aBbvP8DDsGsE8GRA8RlBuCQX7z/YVrBYavhkQOm+XjGcGO8/CH2vMjYJ
ZUDZCJojixvvP85h761PC2VAF3LhAekb7z+URi8paQ1lQFXbKOBGHO8/IBCv
H5wRZUDRrbecAh3vPzijrgwCGmVAyVLVFXoe7z9oya3mzSplQLicEAhpIe8/
Lq7tYecsZUD2BVjmxiHvP/SSLd0AL2VANG+fxCQi7z+AXK3TMzNlQLBBLoHg
Iu8/RkHtTk01ZUDuqnVfPiPvPwwmLcpmN2VALBS9PZwj7z+Y76zAmTtlQKjm
S/pXJO8/XtTsO7M9ZUDmT5PYtSTvP2isD431PWVAocGKbcEk7z+uo9pX
           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGCQB2IQPSP4QxGXU6rDzT0JUomq7+03NK1Z+9851WGaYt3B
RUD+CdE1s1J9Uh0CYkNi9qi9t+/79Vq03i/Vwf4N52Em9ff2Ife1J84ISHXQ
rd6v6QnkP1ixuv10SKoD10yt71eB/B/Wq0sMY1MdjlxhmPRe4729ZtIqv7+5
qQ4WPmuPK2kDzZ9rteFTfqpDzZoHxSlAftrNU4IvClMdDvCIKCwD8pcEvL5y
qTTVwfNsVYWmznt7BXud6BW1qQ5Rfh6aBrrv7cVk1qUH96Y61AY87rLVf2/P
dG1jw8o1qQ6HQiT9Iozf29/23Lkp9HWqg3ds65Ve6/f2Tv5LIkrfpjr41jBx
XQXyV4X0/5vyHui/2fX2Mjbv7aviU72ufE51CLlZuWoVkC9VKvgo6E+qQ2xo
XsNx2/f2EQsyBQN40xwKfMN1GB3e21/7JlngpZ/mMMVWs6XE5b293R8WsSzD
NIdpMct27gbylzF+2N1pnOYws1r5PZPre/synmPsJ83THObulI2aCOSLKhXN
d3dIc1hmKmSwzg0Ynr6nzrkEpjns1P19+7nHe/tLi6t07YvTHO7KnjWO9n1v
L8SwbadVaZqDKd+JdXOB/OCYj65m5WkOvf8OaT4A8q+IZMTpVqc52N7fIZ/q
994+Yw1/79faNId9J0ozDgH5AA3f44g=
           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGBQAGIQPSP4QxFXU5rD+dXHq6L839vfSTf4+H1SmkPAuYnW
AkHv7Z9qP9uyYVOaA/dVPW+V8Pf2PzYH2ih9SnNoeJSR5ZP43p7Hwuyc8Jc0
h9PVpUJzgHyFPVIJrN/SHMREm3a9BvI9jjxufvEzzWGN+2yu7qT39jOvlJ5e
x5jucH3N2VUnk9/bW32dGWUtmO6gV2702i3tvX2N2aOKEIN0hzvcf7Ids9/b
T9h1jMvNKN1BfSmHyEQgf4nd6jnmJukOhXaiex4A+WfcSg5IWaQ7sBfq8TTk
vLeXDWfjeGif7mB8LWHNvtz39vvKtabn+qc7dC04+sa64L39/x1FW9vy0h3M
TftzzUqB/mXb1L2oIN1hf93Nmz1A/q6Qj4n7itIdPE4ouz0G8ks+5PN9K0t3
iIzeITeh7L39C/Xc9NT6dIeqxofnX5a/t780LV3SZUK6w96zxkZzq97br3+y
7H38pHQHN/G6eZ+B/B6jZ0erp6Q7nEs4weVV/d7e/VxK0eYZ6Q73P8c8/gbk
72FNOq20MN2BQaptSkDte/ulJTG1jJvSHZzTbnxjbnhv33RodrDslnSHM+uV
kqOA/ASB25qW29IdQn7mnN8A5NvGSTGE7kh3uOu03Zq98b291JrIawW70h1S
exhXxAL533/OWNOzJ93h7VVvkS1AfsYa/t6ve9MdInaZ3XoL5AMAK+T6tw==

           "]], 
          Line[CompressedData["
1:eJwV0WtIkwEYBeA5kdBcYUqWLUHpSpQu15QRfG9XDXPmdJhJgpp9r5hoXsrh
FTOb140ML9mYYUlZiRkmYszazBFOMmUYKtSicKX5DVHXLLO3H4fD8+/ACUjJ
kqfxeTzeXsr/bo6153gYWCjxzI46X84xGaJGtz9DLLDBMWIlOaLUMu1rYiFp
VjKsIbvuiFNFj7AQqeD/GCQXyGOs+gkWdotaRP43OEbRpumbsrAgtJUYj5AP
L7yvW5lkwVt3SRFF/lklkx6aYYEnCFYWkVPeRDZov7IwbRt+PUWODD59qmiZ
BU3bUnRTBcfwLBaXPAcLMm2C7Bn5pTJNn+FkwfOu/qyRHGisCE1cY0HVoDrD
kVcVxv1SN4TSSuGJ8Jsc01kIm375IGRdOSlxkN1N0slcMUJU2B1h/C2OMV0M
Ss/IRdg4FvJ9azXHbEnFAW0+QqE6/VoQOQnvC8auI8zJdK4R5JUc7x5xEYJ5
1MNfSd6lcqyuVSDUjljl0+SynsFaTSOCwKR+pavhGOmGc929/Qib9XPqfXUc
U+lZxbcN0L7igJ3HyB+8DHF+egT70fjOBDIKxc4SA8LYgGGomtwk2nY8YgRB
09/inCcvJX6emJpB8OoNT31ezzGQvH2P4BNCeV6x/R255rK8gLEiLIa8KP5C
Drw6JHzwDWG8x7/ZW80xMZWP0jIXEG53L5vzyfdqrH06O4Jr9oEL9WSbxs9j
fBEhNyh5toNc1lrbJXEgxHaZXT6SzW1veelOBGMmX20n+3b8lbf+Rgg5GCZ0
19CfT0Ifjq4htM9nPg4gd3VnO9bXEXyetkuk5H/CjTcF
           "]]}, "Charting`Private`Tag$70304#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[1, 0, 0], 
           AbsoluteThickness[2]], 
          Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAIo/9o54e0T7K1hoTDAdEPrcIKR9t
aK8/HngfJBVfIj/BeK6kKGi/P+lRBxbtXjI/xjBxZwZozz/OPvsO2V5CP8iM
0kj1Z98/QDV1C89eUj/JOoO57GfvP3kwsgnKXmI/ypHbcehn/z8WrtCIx15y
P0q9B07mZw9A5OxfSMZegj8x/2L1FvAPQBbhwqVvroI/jCBfziM8EEBI1SUD
Gf6CP3RiunVUxBBArb3rvWudgz9E5nDEtdQRQHaOdzMR3IQ/4u3dYXj1E0AH
MI8eXFmHPyD9t5z9NhhAK3O+9PFTjD8UnmXwFXsYQF1nIVKbo4w/CD8TRC6/
GECPW4SvRPOMP++AbuteRxlA80NKapeSjT++BCU6wFcaQLsU1t880Y4/XQyS
14J4HEAn23blQ6eQP80NNgkEXSBAuHyO0I4kkz/SSxKYznwgQEozu8e/SZM/
2InuJpmcIEDd6ee+8G6TP+QFp0Qu3CBABFdBrVK5kz/8/ReAWFshQFEx9IkW
TpQ/Ajz0DiN7IUDk5yCBR3OUPwh60J3tmiFAd55NeHiYlD8T9oi7gtohQJ0L
p2ba4pQ/Ku759qxZIkDo5VlDnneVPzAs1oV3eSJAfJyGOs+clT82arIUQpki
QA9TszEAwpU/QuZqMtfYIkA1wAwgYgyWP0gkR8Gh+CJAyXY5F5Mxlj9OYiNQ
bBgjQFwtZg7EVpY/Wd7bbQFYI0CBmr/8JaGWP14cuPzLdyNAE1Hs81bGlj9k
WpSLlpcjQKcHGeuH65Y/aphwGmG3I0A6vkXiuBCXP3DWTKkr1yNAzXRy2ek1
lz+IxvrQWN8jQMbpr4t6P5c/Rroaxw==
           "]], 
          Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAeDkFL6cgJEBzDxyYB+KXP4jOveRV
ViRA9Ru8d3eumD+ODJpzIHYkQKR+xT+JJ5k/lEp2AuuVJEBS4c4Hm6CZP5/G
LiCA1SRAq6bhl76Smj+2vp9bqlQlQGAxB7gFd5w/5a6B0v5SJkBoIyn8yR+g
P0KPRcCnTyhA1Dh0PFjooz+ASrSp0m4oQCB4rSOxI6Q/vgUjk/2NKEBtt+YK
Cl+kPzp8AGZTzChABTZZ2bvVpD8zabsL/0gpQDgzPnYfw6U/JEMxV1ZCKkCb
LQiw5p2nPwb3HO4ENSxAYiKcI3VTqz9lL/oNMQ0wQPcFYgVJX7E/TNuHpRge
MECEOxVUeX+xPzSHFT0ALzBAFHHIoqmfsT8E3zBsz1AwQDPcLkAK4LE/oo5n
ym2UMEBtsvt6y2CyP9/t1IaqGzFA416V8E1isz9ZrK//IyoyQM63yNtSZbU/
QFg9lws7MkBc7Xsqg4W1PygEyy7zSzJA7CIvebOltT/4W+Zdwm0yQAqOlRYU
5rU/lgsdvGCxMkBEZGJR1Wa2P9NqinidODNAuhD8xldotz+6FhgQhUkzQEhG
rxWIiLc/osKlp2xaM0DYe2JkuKi3P3IawdY7fDNA9ubIARnptz8Qyvc02r8z
QDC9lTzaabg/RGN9aKzvM0BsSbQB6cS4P+472ZQ=
           "]], 
          
          Line[{{20.06377551020408, 0.09787075987419762}, {
           20.400947900007537`, 0.10126379267387264`}, {20.524201968382854`, 
           0.10250412287094074`}, {20.77071010513348, 0.10498478326507685`}, {
           21.263726378634736`, 0.10994610405334908`}, {22.249758925637252`, 
           0.11986874562989361`}, {24.221824019642277`, 
           0.13971402878298256`}, {28.496165225764553`, 
           0.18272757422135455`}, {29.93622448979592, 0.19721917692696916`}}], 
          
          Line[{{30.06377551020408, 0.1986329655829274}, {36.60690926377435, 
           0.2778376473835592}, {39.93622448979592, 0.31813903247249314`}}], 
          
          Line[{{40.06377551020408, 0.31960862857539707`}, {44.81400757831468,
            0.37156790010310176`}, {48.698587548467465`, 
           0.41405844425888083`}, {49.93622448979592, 0.42759603841536614`}}], 
          
          Line[{{50.06377551020408, 0.429019128312482}, {56.846135645150525`, 
           0.5061738328130881}, {59.93622448979592, 0.5413260345460498}}], 
          
          Line[{{60.06377551020408, 0.5426871161687816}, {65.29411965101717, 
           0.5948125682284161}, {69.19710165050657, 0.6337095691956173}, {
           69.93622448979592, 0.6410756451340867}}], 
          
          Line[{{70.06377551020408, 0.6422631035885429}, {77.38145380586288, 
           0.7055857451358091}, {77.4483502145483, 0.7061646250942926}, {
           77.51524662323371, 0.7067435050527759}, {77.64903944060455, 
           0.7079012649697429}, {77.91662507534625, 0.7102167848036768}, {
           78.4517963448296, 0.7148478244715445}, {78.51869275351503, 
           0.715426704430028}, {78.58558916220045, 0.7160055843885115}, {
           78.71938197957128, 0.7171633443054782}, {78.98696761431296, 
           0.7194788641394121}, {79.52213888379632, 0.7241099038072798}, {
           79.58903529248174, 0.7246887837657632}, {79.65593170116716, 
           0.7252676637242468}, {79.789724518538, 0.7264254236412135}, {
           79.85662092722342, 0.727004303599697}, {79.92351733590883, 
           0.7275831835581804}, {79.93622448979592, 0.7276931433730517}}], 
          Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAL6fg5RQEVEAtzNxDKVHnP61lFADz
B1RA7y/Lr1xU5z8yR/QHOwxUQJT1qcbnV+c/PAq0F8sUVEDegGf0/V7nP0+Q
MzfrJVRAcZfiTypt5z+cqDG1a2pUQL/xzr3bpec/yNljyJ9uVECNcqtQVqnn
P/QKltvTclRAXPOH49Cs5z9LbfoBPHtUQPn0QAnGs+c/+jHDTgyMVEA0+LJU
sMHnP1m7VOisrVRAqv6W64Td5z8Wzncb7vBUQJULXxkuFeg/kfO9gXB3VUBt
Je90gIToP27SkGFce1VAYzq3Rr+H6D9MsWNBSH9VQFtPfxj+iug/Bm8JASCH
VUBIeQ+8e5HoP3zqVIDPllVAJM0vA3ee6D9m4et+LrZVQNl0cJFtuOg/PM8Z
fOz0VUBHxPGtWuzoPxmu7FvY+FVAPdm5f5nv6D/2jL87xPxVQDTugVHY8ug/
sUpl+5sEVkAiGBL1VfnoPybGsHpLFFZA/GsyPFEG6T8RvUd5qjNWQLMTc8pH
IOk/7psaWZY3VkCqKDuchiPpP8x67TiCO1ZAoT0DbsUm6T+GOJP4WUNWQI5n
kxFDLek//LPedwlTVkBqu7NYPjrpP+aqdXZoclZAIGP05jRU6T9WHf7eqHZW
QESB3q65V+k/xY+GR+l6VkBon8h2PlvpP9FYHxrre1ZAUopk1xNc6T8tLPuc

           "]], 
          
          Line[{{90.06377551020408, 0.7932278283214113}, {90.11978176227086, 
           0.7935137134194672}, {90.18621293487926, 0.793852812744887}, {
           90.31907528009609, 0.7945310113957262}, {90.85052466096337, 
           0.7972438059990838}, {91.91342342269793, 0.8026693952057989}, {
           94.03922094616706, 0.8135205736192291}, {98.00878211325836, 
           0.8337832825421551}, {99.93622448979592, 0.8436219529133968}}], 
          Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAL6fg5RQEWUDV3XTb0wPrP4gX903S
h1pAT/3bGL3V6z+UyMjjwotaQF8Epx3f1+s/n3maebOPWkBvC3IiAdrrP7bb
PaWUl1pAjxkILEXe6z/ln4T8VqdaQM81ND/N5us/QigSq9vGWkBPboxl3ffr
P/w4LQjlBVtATt88sv0Z7D8I6v6d1QlbQF/mB7cfHOw/E5vQM8YNW0Bu7dK7
QR7sPyr9c1+nFVtAjvtoxYUi7D9Zwbq2aSVbQM4XldgNK+w/tklIZe5EW0BO
UO3+HTzsP8L6GfveSFtAXle4A0A+7D/Nq+uQz0xbQG5egwhiQOw/5A2PvLBU
W0CObBkSpkTsPxPS1RNzZFtAzohFJS5N7D8eg6epY2hbQN2PECpQT+w/KjR5
P1RsW0DultsuclHsP0KWHGs1dFtADqVxOLZV7D9OR+4AJnhbQB6sPD3YV+w/
0VgfGut7W0C4Mya34lnsP2zKp2I=
           "]], 
          Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAL6fg5RSEW0DT4t+Dnl3sPw6f6uA8
iFtAmnscwytf7D+s43H/gYxbQCjdauPDYOw/52yAPAyVW0BDoAck9GPsP15/
nbYgpltAeCZBpVRq7D9MpNeqSchbQOMytKcVd+w/KO5Lk5sMXEC6S5qsl5Ds
P+GBNGQ/lVxAZ31mtpvD7D8mFg6OcJlcQBWIVWMsxew/aqrnt6GdXEDDkkQQ
vcbsP/TSmgsEplxAH6giat7J7D8IJAGzyLZcQNbS3h0h0Ow/LsbNAVLYXEBE
KFeFptzsP3oKZ59kG11AINNHVLH17D+/nkDJlR9dQM7dNgFC9+w/BDMa88Yj
XUB86CWu0vjsP41bzUYpLF1A2P0DCPT77D+grDPu7TxdQI8owLs2Au0/x04A
PXdeXUD9fTgjvA7tPxSTmdqJoV1A2igp8sYn7T8K1RPRcqVdQOECKKo8Ke0/
ABeOx1upXUDo3CZisirtP+2agrQtsV1A9pAk0p0t7T/GomuO0cBdQBL5H7J0
M+0/vOTlhLrEXUAZ0x5q6jTtP7ImYHujyF1AIK0dImA27T+fqlRoddBdQC5h
G5JLOe0/eLI9QhngXUBLyRZyIj/tP270tzgC5F1AUqMVKphA7T9kNjIv6+dd
QFl9FOINQu0/UbomHL3vXUBnMRJS+UTtP0j8oBKm811AbgsRCm9G7T8+PhsJ
j/ddQHXlD8LkR+0/NICV/3f7XUB8vw56WkntP9FYHxrr+11AeKKpc4VJ7T/U
/AsI
           "]], 
          
          Line[{{120.06377551020408`, 0.9155255077237506}, {120.2346687249738,
            0.9158328995053004}, {120.47904440930093`, 0.9162724668519268}, {
           120.54013833038272`, 0.9163823586885834}, {120.6012322514645, 
           0.91649225052524}, {120.72342009362805`, 0.9167120341985531}, {
           120.96779577795519`, 0.9171516015451795}, {121.45654714660944`, 
           0.9180307362384321}, {122.43404988391794`, 0.9197890056249375}, {
           122.50030335215772`, 0.9199081781249312}, {122.56655682039751`, 
           0.920027350624925}, {122.69906375687708`, 0.9202656956249126}, {
           122.96407762983623`, 0.9207423856248876}, {123.4941053757545, 
           0.9216957656248379}, {124.55416086759107`, 0.9236025256247384}, {
           126.67427185126418`, 0.9274160456245394}, {129.9362244897959, 
           0.9332834373418788}}], 
          Line[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgpCYEAp59NhY9/tP718+gBo
0GBAEctq2nwk7j/2r+bwgtJgQMjSf2+CJe4/MOPS4J3UYEB+2pQEiCbuP6RJ
q8DT2GBA7Om+LpMo7j+KFlyAP+FgQMYIE4OpLO4/VrC9/xbyYEB7Rrsr1jTu
P+/jgP7FE2FA5MELfS9F7j8oF23u4BVhQJrJIBI1Ru4/YkpZ3vsXYUBR0TWn
OkfuP9awMb4xHGFAv+Bf0UVJ7j+8feJ9nSRhQJn/syVcTe4/iBdE/XQ1YUBN
PVzOiFXuPyFLB/wjV2FAt7isH+Jl7j801UPSGllhQM6gJS/WZu4/Rl+AqBFb
YUDliJ4+ymfuP2pz+VT/XmFAE1mQXbJp7j+0m+ut2mZhQG/5c5uCbe4/xiUo
hNFoYUCG4eyqdm7uP9ivZFrIamFAncllumpv7j/9w90Gtm5hQMuZV9lSce4/
RuzPX5F2YUAnOjsXI3XuP1h2DDaIeGFAPiK0Jhd27j9qAEkMf3phQFUKLTYL
d+4/fIqF4nV8YUBs8qVF/3fuP2isD431fWFAu6Owfbl47j9Ge810
           "]], 
          Line[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAAmFPwcgqCYUAQgZIeU3ruP9g8tBFI
hmFAtXxoYZd77j/qxvDnPohhQP5tUJItfO4//FAtvjWKYUBHXzjDw3zuPyFl
pmojjmFA2kEIJfB97j9qjZjD/pVhQP8GqOhIgO4/fBfVmfWXYUBI+I8Z34Du
P46hEXDsmWFAkel3SnWB7j+ztYoc2p1hQCPMR6yhgu4//N18dbWlYUBIkedv
+oTuP48uYSdstWFAkhsn96uJ7j+0zymL2dRhQCYwpgUPk+4/kCPBpfrWYUC2
eXXWsZPuP2t3WMAb2WFARcNEp1SU7j8iH4f1Xd1hQGNW40iale4/j27kX+Ll
YUCffCCMJZjuP2oNnzTr9mFAF8maEjyd7j8gSxTe/BhiQAhijx9pp+4/jMb+
MCBdYkDqk3g5w7vuP0Bx5jEdX2JAA8rnQVu87j/0G84yGmFiQBwAV0rzvO4/
XHGdNBRlYkBPbDVbI77uPy0cPDgIbWJAtETyfIPA7j/OcXk/8HxiQH31a8BD
xe4/EB30TcCcYkAQV19HxM7uP2isD431vWJAuM18fq/Y7j9uLc1D
           "]], 
          
          Line[{{150.0637755102041, 0.9640810869802467}, {151.0086021630023, 
           0.9649078677167741}, {151.13043459642864`, 0.9650144784995487}, {
           151.37409946328125`, 0.9652277000650978}, {151.86142919698653`, 
           0.9656541431961964}, {152.83608866439704`, 0.9665070294583932}, {
           154.78540759921805`, 0.9682128019827869}, {159.0142564869723, 
           0.9719133017387216}, {159.9362244897959, 0.9727200797674442}}], 
          Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAmFPwcgoCZEBcQ6hvdiHvP/iwmI7k
YGRAeS9WNOQ37z/rbS8ECGNkQFnOOqhlOO8/0Odc705nZEAaDASQaDnvP5rb
t8Xcb2RAnIeWX2477z8uw21y+IBkQKB+u/55P+8/VpLZyy+jZECnbAU9kUfv
P0hPcEFTpWRAhwvqsBJI7z87DAe3dqdkQGiqziSUSO8/IIY0or2rZEAp6JcM
l0nvP+p5j3hLtGRAq2Mq3JxL7z9+YUUlZ8VkQK5aT3uoT+8/pzCxfp7nZEC2
SJm5v1fvP24V8fm36WRAnZR90T5Y7z80+jB10etkQIPgYem9WO8/wMOwawTw
ZEBQeCoZvFnvP9hWsFhq+GRA6qe7eLhb7z8Ifa8yNgllQB0H3jexX+8/zmHv
rU8LZUAEU8JPMGDvP5RGLylpDWVA6p6mZ69g7z8gEK8fnBFlQLc2b5etYe8/
OKOuDAIaZUBRZgD3qWPvP2jJrebNKmVAhMUitqJn7z8uru1h5yxlQGsRB84h
aO8/9JIt3QAvZUBRXevloGjvP4BcrdMzM2VAHvWzFZ9p7z9GQe1OTTVlQARB
mC0eau8/DCYtymY3ZUDrjHxFnWrvP5jvrMCZO2VAuCRFdZtr7z9e1Ow7sz1l
QJ5wKY0abO8/aKwPjfU9ZUBhFZc7KmzvPwt86Kc=
           "]], 
          Line[CompressedData["
1:eJwVzmlIE2AcBvApHhBZbOSZUonlkVJLLfDo/aeVR6Zrm7HIiqb/V63mMd00
TUtZqZGFB6JBZanNdJYJSbOQsJK8+jBl0CGNQshWvh4lFbZ6+/Dw8Pvy8GxS
5krRXiAQ+PP872bZvHpVDELBhsCEyTOM9FYaev7GIgwUNyzZuLWZXwM89yM0
jZYOh6gYiUoKbt8Rj6D2zmhJ437lariOSQiBz8LIAPfV31bX88kIjiIf0Sy3
/MPWumYJgiXdccY9hxFLZ3fVmByh2dl8WcP9M7K7UHwMwSmlyLw9l5FAZVfy
HxXCp2mjSp/H929E9C7mIoiCLq2f5KZvRoWf8xFAKx2xcbdLrFMmDcLNNVa/
w/mMbCTBRzvLEBTE+72DmhE37/uZslqEidbyRGUBI/bmhxfuGRD602P9fbSM
vEsw9qVaEWpmxy31pYzEpLQrNN8QtA+iooe4u+TXbI0MIUNjaFngLjmBiVNL
CMTuilRyjhEvjfCjdAVh2ePAC5cyRhSt2UKJC4X0+BF9dTkj5mXPvMRtFKL1
L3PKKxjZveLgdkpMIUgVPtbDfddu/klNKAWP0A7/aW7t6mHnkV0UlgZ1lshK
Rlx91bfigEKXOVb6i1t+cPT13kMU3J2Gwgt1jDyVPirMkFFwGBfXt3H7KVq9
dKkUFutuz5m4vyu19PkRChM+FXrxRUYain1te5QUdOHgybhNbSUhpIDCQsbg
SnYVIyJBvzFCQ0G8WRTWxC1LW9i3s4iCegZPD3E3Pg42ic9S6Osw3pnjnlqX
dTyklP9Fl7de1fxvftuXgDIKoVtOCuO4swxra39w+435zii4/wEWBygv
           "]], 
          Line[CompressedData["
1:eJwV0H8s1HEcx3E0hkpSEzeabpyhH+bHoeTznhr1R6ucrURzWT5vMbndLl1D
GZvkx7pMuiPKhStdquPEdWRNyu6mzsyauyylm7bqQ/Jr/aFvf7z23OPf166s
gpRsJwcHhyBu/6sUzUvdyygYyzcXTFQycjrBrPG6TiFN/spSf4ORqeXEIbdq
CqPN07m7qxixYfjCSh2Fh3N+zenVjPgN55Us1lMQF2kvaDifDdC4sQYKPh7x
wkXO0x/9+fZGCpWR6e+rahj5fHSjaEJNAa+qHA21jHwLs/c801EI2u5NfRSM
rHafjOf/phCQ57p6S8XIpljh2LY/FLwqdibbOAcYeWLnZQobWqMaBI2MHBn+
Wj63RsE+KY56yVk1ccnU5YigTeyXzDYxsn9JdebAVoRYXu53YQsjxcIv8tRw
hBOjpimrmhGFYcQ9KQIhcXYmRPCAkbaEx3djohAi11fkEs7mJNkQLxbBOzpw
h3MbI/6nXFxnCILtfrFobzsjg5dD7+QfR8iR7zGXahhZ75PqKy4ilAbfHAjS
cn+56KrVEoTbv5QZhZwNqQvnBqUIj/TqvyOcZfMFHsuFCOOHeuNynjAyF5yP
2dcQAsWf9J1djIw3oO9hBcJbZVjXvueMPJ3tYJl1CNbM6GOlnGsi7G+K6hHm
BeTHB87JY+el3UoEX31KqFTHiNE5y8RvRci1XOno6WakXZZR4qhD8HB/1xLX
y0jZ6yaRfw8C32I5WMVZ7GkNietFiFFabVOcedq0SYkBIVPAeMUvGFlZU2pr
jAiyn6v9Zs452i21SwMInp1O95z6GPkHaG4oqw==
           "]], 
          Line[CompressedData["
1:eJwVz38sFGAcx/HD1A5XI42OtUg/VJLya2fzfLMVxeTO2Yw0XeN5uElcypVV
YiLXdqumHzqnlXJZZjYuP7pbh13t4kKX7WjRKKu5R1auI+npj8/ee/35CZAU
inKcORzODrb/vZs6X+xmwNAsmdt56QVF0rA61z/9GMYVfLOeOeGyZdzHiOHp
9+sfbMwufuLqYyYMSCOdSeqiqFQknNKNYigMCnHhdlOU1qjUWi0YYipUbtHM
+23mG4tjGNZ85nlh5rmaZMHeCQwNatuWAWbJq8RbqmkMQ/y22PIeihL3HT5U
9gtDiOeBC45eijgWi9NZO4ak/GvHt72kqFOeo5M6MEj7xmOFzIF9lVGZKxg0
JZUuGualtL5ggSuBIKtFka6j6NlFWPfbm4Dfo1K1Vk8R1ygYk4UT4Ebo+ksM
FBmzQvOkMgLT6UfWLxgp8jpFelQlBHKLdntsfU3RCfKQ9+48ga81PK6YebF4
Q3t4GYFv3cPOncxB1fallUoC8/4Zi/I3FF1p1yuUdQSWJ/M/OpkoEqxNaevo
IuCVp2jxHKKoyqPGebaHwO3y081xzMOeBjFfR2Dj/ZQmGTPxD3dcMhDwNXmr
Lcx3wnzjEkwENoeobt4zU/Qzc3LUOkFg14/n8oBhiuDkpu28TwRauMpzIuba
XFEpmiKwJ7BYVsEcWNTv/3iGQGhqZMEMs7CqOafARiCiQ5etGaHoQe2UVj1P
QDvYmGVlnlXy3UYWCER/uZrhPsr+1CtaI+0EYnzixQXMbxsHOHkOAr2hwcIG
Zp8nf0X1ywRiE9yTzcySlqimwRUC+uy5o5z3FLW2nbGvrhI4KDfHhzH/Az8f
PB8=
           "]]}, 
         "Charting`Private`Tag$70304#2"], {}}, {{}, {}, {}, {}, {}}, {{}, {}, \
{}, {}, {}}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
         Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
      GridLines -> {None, None}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> 0.6, Axes -> {True, True}, 
      AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
      Identity, Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
         Style["Cumulative distribution", 20, 
          GrayLevel[0]], None}, {
         Style["Center-to-center distance (nm)", 20, 
          GrayLevel[0]], None}}, FrameStyle -> Directive[
        GrayLevel[0], FontSize -> 20, 
        AbsoluteThickness[2]], 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImageSize -> 500, 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         GrayLevel[0], 
         AbsoluteThickness[2]], 
        Directive[
         Opacity[1.], 
         RGBColor[1, 0, 0], 
         AbsoluteThickness[2]]}, {
        Style["WT", 20], 
        Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
       LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.849078580718093*^9, 3.8490785980565443`*^9}, {
   3.8491500738202505`*^9, 3.849150090279048*^9}, 3.8506250698322277`*^9, 
   3.8506257930245667`*^9, 3.850625864859544*^9, 3.850626028928406*^9, {
   3.8506260932628527`*^9, 3.850626116247344*^9}, 3.850626284558384*^9, 
   3.8506267529435077`*^9, 3.8506293893660755`*^9, 3.8506318973955727`*^9, 
   3.8508713379216633`*^9, 3.8508740945705795`*^9, 3.8509808144622087`*^9, 
   3.8509813532800865`*^9, 3.8509827661178575`*^9, 3.850982976974203*^9, 
   3.8522541414367123`*^9, 3.852255102951196*^9, 3.8550446176700277`*^9, 
   3.855099751547579*^9, 3.8551057507604923`*^9, 3.855105811535363*^9, 
   3.8580517694267397`*^9, 3.858051972227914*^9, 3.8580520491102066`*^9, 
   3.858052277673073*^9, 3.858052318742939*^9},
 CellLabel->
  "Out[317]=",ExpressionUUID->"c69f4e82-f9b0-419e-b184-a9ff6bb9cfc4"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"StringJoin", "[", "\"\<E:\\\\220323\\\\az\>\"", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<220108_PQ_wt2.mx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "wt635", ",", "wt594", ",", "wt635s", ",", "wt594s", ",", "wtn635", ",", 
      "wtn594", ",", "wtd"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<220108_PQ_ko2.mx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "ko635", ",", "ko594", ",", "ko635s", ",", "ko594s", ",", "kon635", ",", 
      "kon594", ",", "kod"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8506263216651926`*^9, 3.850626326897073*^9}, {
   3.850626370994032*^9, 3.850626458240716*^9}, {3.850626804322858*^9, 
   3.8506268107051687`*^9}, {3.850630720799167*^9, 3.8506307234071445`*^9}, {
   3.8508713589596586`*^9, 3.850871364494605*^9}, {3.852254167703303*^9, 
   3.852254175863792*^9}, 3.85225498527185*^9, {3.8550446309575453`*^9, 
   3.8550446374351726`*^9}, {3.85805153279625*^9, 3.858051541734194*^9}, {
   3.8580517073520317`*^9, 3.8580517292446423`*^9}, {3.8580519631050553`*^9, 
   3.8580519643703804`*^9}, {3.858052028801762*^9, 3.8580520392219677`*^9}, {
   3.8580522961843615`*^9, 3.8580522972467813`*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"5f1e457c-1330-43a9-b2eb-af9087d59dc0"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.852254108236294*^9},ExpressionUUID->"a6096ea2-d7dd-4251-8004-\
10fce6ec7f41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"P", "/", "Q"}], "-", 
    RowBox[{"type_", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "dir", "=", 
     "\"\<F:\\\\Analysis\\\\Leica TCS \
SP8\\\\Collaboration\\\\MF\\\\220108\\\\\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi1", "=", "\"\<Munc13-1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Poi2", "=", "\"\<Cav2.1\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt", "=", 
     RowBox[{"{", "\"\<1 W2\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko", "=", 
     RowBox[{"{", "\"\<1 K2\>\"", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"field", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{"\"\<\\\\s\>\"", ",", 
         RowBox[{"ToString", "[", "i", "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "normalization", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"wt", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";"}], 
      "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm594", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm635", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm594s", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"Flatten", "[", "res3", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm635s", "=", 
     RowBox[{"Mean", "[", 
      RowBox[{"Flatten", "[", "res4", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "WT", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"wt", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res5", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res6", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res7", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res1", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res1", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res2", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res2", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res5", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res5", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res6", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res6", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res7", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res7", ",", 
          RowBox[{"Import", "[", "\"\<res_distance.dat\>\"", "]"}]}], "]"}]}],
        ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt594", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/", "norm594"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt635", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/", "norm635"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta594", "=", 
     RowBox[{"Flatten", "[", "res1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wta635", "=", 
     RowBox[{"Flatten", "[", "res2", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt594s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res3", "]"}], "/", "norm594s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wt635s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res4", "]"}], "/", "norm635s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtn594", "=", 
     RowBox[{"Flatten", "[", "res5", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtn635", "=", 
     RowBox[{"Flatten", "[", "res6", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wtd", "=", 
     RowBox[{"Flatten", "[", "res7", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    StyleBox[
     RowBox[{"(", 
      StyleBox["*",
       Background->RGBColor[0.88, 1, 0.88]]}]], "KO", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"folder", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
            RowBox[{"ko", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"field", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res1", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res2", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res3", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res4", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res5", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res6", "=", 
     RowBox[{"{", "}"}]}], ";", 
    RowBox[{"res7", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SetDirectory", "[", 
        RowBox[{"StringJoin", "[", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"dir", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"folder", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}], ",", 
          "\"\<\\\\az\\\\\>\""}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"list", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"list", ",", 
          RowBox[{"Transpose", "[", 
           RowBox[{"Import", "[", "\"\<res.dat\>\"", "]"}], "]"}]}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"res1", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res1", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res2", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res2", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res3", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res3", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res4", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res4", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res5", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res5", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res6", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res6", ",", 
          RowBox[{
           RowBox[{"Import", "[", "\"\<res_#subaz.dat\>\"", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"res7", "=", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"res7", ",", 
          RowBox[{"Import", "[", "\"\<res_distance.dat\>\"", "]"}]}], "]"}]}],
        ";"}], "\[IndentingNewLine]", ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Length", "[", "folder", "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"Flatten", "[", 
        RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko594", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "/", "norm594"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko635", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"list", ",", "1"}], "]"}], "]"}], "[", 
       RowBox[{"[", "3", "]"}], "]"}], "/", "norm635"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa594", "=", 
     RowBox[{"Flatten", "[", "res1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"koa635", "=", 
     RowBox[{"Flatten", "[", "res2", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko594s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res3", "]"}], "/", "norm594s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ko635s", "=", 
     RowBox[{
      RowBox[{"Flatten", "[", "res4", "]"}], "/", "norm635s"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kon594", "=", 
     RowBox[{"Flatten", "[", "res5", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kon635", "=", 
     RowBox[{"Flatten", "[", "res6", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kod", "=", 
     RowBox[{"Flatten", "[", "res7", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "Dataset", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", "wta", "]"}]}], ",", 
         RowBox[{"\"\<area\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "wta", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt594", "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{"\"\<n\>\"", "\[Rule]", 
          RowBox[{"Length", "[", "koa", "]"}]}], ",", 
         RowBox[{"\"\<area\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "koa", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi1", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{
           "\"\<Total \>\"", ",", "Poi2", ",", " ", "\"\< intensity\>\""}], 
           "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko594", "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Dataset", "[", 
    RowBox[{"<|", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\"\<WT\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "wta635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "wta594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wta635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wta594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt635s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wt594s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wtn635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "wtn594", "]"}]}], ",", 
         RowBox[{"\"\<Distance\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "wtd", "]"}]}]}], "|>"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"\"\<KO\>\"", "\[Rule]", 
       RowBox[{"<|", 
        RowBox[{
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "koa635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< (n)\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Length", "[", "koa594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "koa635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< area\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "koa594", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko635s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< intensity\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "ko594s", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi1", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "kon635", "]"}]}], ",", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"Poi2", ",", "\"\< #/az\>\""}], "]"}], "\[Rule]", 
          RowBox[{"Mean", "[", "kon594", "]"}]}], ",", 
         RowBox[{"\"\<Distance\>\"", "\[Rule]", 
          RowBox[{"Mean", "[", "kod", "]"}]}]}], "|>"}]}]}], "|>"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "Graphics", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", "wt635", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", "ko635", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", "wt594", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", "ko594", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< intensity (A.U.)\>\""}], "]"}], ",",
               "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", "wt635s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", "ko635s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", "wt594s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", "ko594s", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "4.0"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster intensity (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtn635", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko635", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kon635", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtn594", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko594", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kon594", ",", 
       RowBox[{"{", "0.1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsRow", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt635", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko635", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi1", ",", "\"\< cluster number / AZ (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"CDF", "[", 
            RowBox[{"dwt594", ",", "x"}], "]"}], ",", 
           RowBox[{"CDF", "[", 
            RowBox[{"dko594", ",", "x"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Black", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], 
           "}"}]}], ",", 
         RowBox[{"Frame", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
            RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"StringJoin", "[", 
               RowBox[{"Poi2", ",", "\"\< cluster number / AZ (A.U.)\>\""}], 
               "]"}], ",", "20", ",", "Black"}], "]"}], ",", " ", 
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}], 
             "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotLegends", "\[Rule]", 
          RowBox[{"Placed", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dwt", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"wtd", "*", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dko", "=", 
     RowBox[{"HistogramDistribution", "[", 
      RowBox[{"kod", "*", "10"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CDF", "[", 
        RowBox[{"dwt", ",", "x"}], "]"}], ",", 
       RowBox[{"CDF", "[", 
        RowBox[{"dko", ",", "x"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "}"}]}], "}"}]}], 
     ",", 
     RowBox[{"Frame", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "20"}], ",", 
        RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<Center-to-center distance (nm)\>\"", ",", "20", ",", "Black"}], 
         "]"}], ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Cumulative distribution\>\"", ",", "20", ",", "Black"}],
          "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<WT\>\"", ",", "20"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<KO\>\"", ",", "20"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9", ",", "0.2"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.6"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852254115530883*^9, {3.8522542140936728`*^9, 3.8522542239380903`*^9}, 
   3.855044659834834*^9},
 CellLabel->
  "In[1017]:=",ExpressionUUID->"a0900a78-6de6-410e-8f7f-dce1422734f5"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "area", "Total Munc13-1 intensity", 
            "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[32]} -> 1, {All, "n"} -> 
           1, {All, "area"} -> 1, {All, "Total Munc13-1 intensity"} -> 
           1, {All, "Total Cav2.1 intensity"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "n" -> TypeSystem`PackageScope`AtomShape[34], "area" -> 
               TypeSystem`PackageScope`AtomShape[34], 
               "Total Munc13-1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60], 
               "Total Cav2.1 intensity" -> 
               TypeSystem`PackageScope`AtomShape[60]]]]], 2, {}]], 
        "InitialData" -> TypeSystem`PackageScope`CacheHandle[2133074194], 
        "Type" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "n", "area", "Total Munc13-1 intensity", 
            "Total Cav2.1 intensity"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[2133074194]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"n\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"n\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    All, "n"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[All, "n"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    All, "area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[All, "area"]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Munc13-1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    All, "Total Munc13-1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[All, "Total Munc13-1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Total Cav2.1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    All, "Total Cav2.1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[All, "Total Cav2.1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["617"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["294.055"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["677"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["n"]]], "Mouse"], ImageSize -> {{34, Full}, Automatic},
                 Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["274.66"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.10794"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["0.947142"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Total Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 278380313]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[278380313][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {455., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{3.852254226812677*^9, 3.8522551110382366`*^9, 
  3.8550446651261616`*^9},
 CellLabel->
  "Out[1056]=",ExpressionUUID->"415eb915-3f33-4753-9833-cba8e42de325"],

Cell[BoxData[
 TemplateBox[{TagBox[
    DynamicModuleBox[{
     TypeSystem`NestedGrid`PackagePrivate`$state$$ = 
      Data`UnorderedAssociation[
       "RowCount" -> 2, "Length" -> 2, "InitialType" -> TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 area", "Cav2.1 area", 
            "Munc13-1 intensity", "Cav2.1 intensity", "Munc13-1 #/az", 
            "Cav2.1 #/az", "Distance"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real]}], 2], "Shape" -> 
        TypeSystem`PackageScope`HeaderShape[
          Association[{All, 
             TypeSystem`PackageScope`KeyDummy[33]} -> 
           1, {All, "Munc13-1 (n)"} -> 1, {All, "Cav2.1 (n)"} -> 
           1, {All, "Munc13-1 area"} -> 1, {All, "Cav2.1 area"} -> 
           1, {All, "Munc13-1 intensity"} -> 1, {All, "Cav2.1 intensity"} -> 
           1, {All, "Munc13-1 #/az"} -> 1, {All, "Cav2.1 #/az"} -> 
           1, {All, "Distance"} -> 1], 
          TypeSystem`PackageScope`Limited[
           TypeSystem`PackageScope`ColumnShape[
            TypeSystem`PackageScope`KeyValueShape[
             TypeSystem`PackageScope`AtomShape[28.800000000000004`], 
             TypeSystem`PackageScope`RowShape[
              Association[
              "Munc13-1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 (n)" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 area" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 area" -> TypeSystem`PackageScope`AtomShape[34], 
               "Munc13-1 intensity" -> TypeSystem`PackageScope`AtomShape[60], 
               "Cav2.1 intensity" -> TypeSystem`PackageScope`AtomShape[60], 
               "Munc13-1 #/az" -> TypeSystem`PackageScope`AtomShape[34], 
               "Cav2.1 #/az" -> TypeSystem`PackageScope`AtomShape[34], 
               "Distance" -> TypeSystem`PackageScope`AtomShape[60]]]]], 
           2, {}]], "InitialData" -> 
        TypeSystem`PackageScope`CacheHandle[1392537572], "Type" -> 
        TypeSystem`Assoc[
          TypeSystem`Atom[String], 
          
          TypeSystem`Struct[{
           "Munc13-1 (n)", "Cav2.1 (n)", "Munc13-1 area", "Cav2.1 area", 
            "Munc13-1 intensity", "Cav2.1 intensity", "Munc13-1 #/az", 
            "Cav2.1 #/az", "Distance"}, {
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Integer], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Real], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Rational], 
            TypeSystem`Atom[Real]}], 2], "HandleQ" -> True, "RowTarget" -> 20,
         "Data" -> TypeSystem`PackageScope`CacheHandle[1392537572]], 
      TypeSystem`NestedGrid`PackagePrivate`$path$$ = {}, 
      TypeSystem`NestedGrid`PackagePrivate`$pos$$ = 1, 
      TypeSystem`NestedGrid`PackagePrivate`$grid$$ = 
      DynamicModule[{
        TypeSystem`NestedGrid`PackagePrivate`renderedGrid = Deploy[
           Style[
            Grid[{{
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox["\"\"", FontColor -> GrayLevel[0.4]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    Style[
                    RawBoxes[
                    StyleBox[
                    "\"\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], Italic, 
                    GrayLevel[0.7]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, Keys}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, Keys]], "Mouse"], Background -> 
                GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Munc13-1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Munc13-1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 (n)\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Cav2.1 (n)"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Cav2.1 (n)"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Munc13-1 area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Munc13-1 area"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 area\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 area\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Cav2.1 area"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Cav2.1 area"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 intensity\"", FontColor -> 
                    GrayLevel[0.4]]], {{20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Munc13-1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Munc13-1 intensity"]], 
                 "Mouse"], Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 intensity\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 intensity\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Cav2.1 intensity"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Cav2.1 intensity"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 #/az\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Munc13-1 #/az\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Munc13-1 #/az"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Munc13-1 #/az"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 #/az\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Cav2.1 #/az\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Cav2.1 #/az"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Cav2.1 #/az"]], "Mouse"], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Item[
                Annotation[
                 EventHandler[
                  MouseAppearance[
                   Mouseover[
                    Pane[
                    RawBoxes[
                    StyleBox["\"Distance\"", FontColor -> GrayLevel[0.4]]], {{
                    20, Full}, 15}], 
                    Style[
                    Pane[
                    RawBoxes[
                    StyleBox[
                    "\"Distance\"", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], {{20, Full}, 15}], FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                  TypeSystem`NestedGrid`PackagePrivate`updateState[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
                    1895391721][{All, "Distance"}]], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[All, "Distance"]], "Mouse"], 
                Background -> GrayLevel[0.95], 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["WT", 
                    Style[
                    "WT", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1895391721][{
                    Key["WT"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1895391721][
                   GeneralUtilities`Slice[
                    Key["WT"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2245"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1464"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["37.0174"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["41.5881"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.0"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3.63857"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Munc13-1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2.39708"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Cav2.1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6.54905"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["WT"], 
                   Key["Distance"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}, {
               Item[
                Pane[
                 Annotation[
                  EventHandler[
                   MouseAppearance[
                    Mouseover["KO", 
                    Style[
                    "KO", FontColor -> 
                    RGBColor[
                    0.27450980392156865`, 0.5372549019607843, 
                    0.792156862745098]]], "LinkHand"], {"MouseClicked", 1} :> 
                   TypeSystem`NestedGrid`PackagePrivate`updateState[
                    TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                    TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1895391721][{
                    Key["KO"]}]], 
                  TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[
                  1895391721][
                   GeneralUtilities`Slice[
                    Key["KO"]]], "Mouse"], 
                 ImageSize -> {{28.800000000000004`, Full}, Automatic}], 
                Background -> GrayLevel[0.95], Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2388"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1539"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 (n)"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["35.2688"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["40.7102"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 area"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.14433"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["1.03813"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 intensity"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["3.5288"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Munc13-1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["2.29985"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Cav2.1 #/az"]]], "Mouse"], 
                ImageSize -> {{34, Full}, Automatic}, 
                Alignment -> {Left, Baseline}], 
               Pane[
                Annotation[
                 RawBoxes["6.36409"], 
                 TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
                  GeneralUtilities`Slice[
                   Key["KO"], 
                   Key["Distance"]]], "Mouse"], 
                ImageSize -> {{60, Full}, Automatic}, 
                Alignment -> {Left, Baseline}]}}, BaseStyle -> {ContextMenu -> {
                 MenuItem["Copy position to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Copy data to clipboard", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`copyClip]], 
                  MenuEvaluator -> Automatic], Delimiter, 
                 MenuItem["Paste position in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentPosition[
                   TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic], 
                 MenuItem["Paste data in new cell", 
                  KernelExecute[
                   TypeSystem`NestedGrid`PackagePrivate`toCurrentData[
                   TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                    TypeSystem`NestedGrid`PackagePrivate`cellPaste]], 
                  MenuEvaluator -> Automatic]}, FontFamily -> "Verdana", 
               FontSize -> 12}, Alignment -> Left, RowMinHeight -> 1.5, 
             Dividers -> All, FrameStyle -> GrayLevel[0.85], 
             BaseStyle -> {FontFamily -> "Verdana", FontSize -> 12}], 
            LineBreakWithin -> False, ContextMenu -> {}, NumberMarks -> False,
             ShowAutoStyles -> False]], 
         TypeSystem`NestedGrid`PackagePrivate`initialQ = True, 
         TypeSystem`NestedGrid`PackagePrivate`self = $Failed}, 
        Dynamic[
         TypeSystem`NestedGrid`PackagePrivate`setupViewPath[
         TypeSystem`NestedGrid`PackagePrivate`$path$$, If[
            Not[TypeSystem`NestedGrid`PackagePrivate`initialQ], 
            
            Module[{TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = $Failed, 
              TypeSystem`NestedGrid`PackagePrivate`tmpData$ = 
              TypeSystem`NestedGrid`PackagePrivate`LookupCacheValue[
                TypeSystem`NestedGrid`PackagePrivate`$state$$["Data"]]}, 
             TypeSystem`NestedGrid`PackagePrivate`tmpGrid$ = 
              If[TypeSystem`NestedGrid`PackagePrivate`tmpData$ === 
                TypeSystem`NestedGrid`PackagePrivate`$NotCached, 
                TypeSystem`NestedGrid`PackagePrivate`renderedGrid, 
                TypeSystem`NestedGrid`PackagePrivate`renderGrid[
                TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
                 TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1895391721][
                TypeSystem`NestedGrid`PackagePrivate`tmpData$]]; If[
               Not[
                FailureQ[TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]], 
               TypeSystem`NestedGrid`PackagePrivate`renderedGrid = 
               TypeSystem`NestedGrid`PackagePrivate`tmpGrid$]; Null]]; 
          TypeSystem`NestedGrid`PackagePrivate`initialQ = False; 
          TypeSystem`NestedGrid`PackagePrivate`$pos$$; If[
            FailureQ[TypeSystem`NestedGrid`PackagePrivate`renderedGrid], 
            TypeSystem`SparseGrid[
             TypeSystem`H["(data no longer present)"]], 
            If[GeneralUtilities`$DebugMode, 
             Row[{TypeSystem`NestedGrid`PackagePrivate`renderedGrid, "  ", 
               TypeSystem`NestedGrid`PackagePrivate`formatState[
               TypeSystem`NestedGrid`PackagePrivate`$state$$, 
                TypeSystem`NestedGrid`PackagePrivate`$path$$, 
                TypeSystem`NestedGrid`PackagePrivate`$pos$$]}], 
             TypeSystem`NestedGrid`PackagePrivate`renderedGrid]]], 
         TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$pos$$}], 
        DynamicModuleValues :> {}], 
      TypeSystem`NestedGrid`PackagePrivate`$posCell$$, 
      TypeSystem`NestedGrid`PackagePrivate`$topBar$$ = Dynamic[
        TypeSystem`NestedGrid`PackagePrivate`alignBar[
        TypeSystem`NestedGrid`PackagePrivate`$state$$][
         TypeSystem`NestedGrid`PackagePrivate`makeFramedBar[
          TypeSystem`PackageScope`Pathbar[
          TypeSystem`NestedGrid`PackagePrivate`$path$$, 
           TypeSystem`NestedGrid`PackagePrivate`updateState[
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
            TypeSystem`NestedGrid`PackagePrivate`$path$$, 
            TypeSystem`NestedGrid`PackagePrivate`$pos$$, 
            TypeSystem`NestedGrid`PackagePrivate`$grid$$, 1895391721]]]], 
        TrackedSymbols :> {TypeSystem`NestedGrid`PackagePrivate`$path$$}], 
      TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$ = Framed[
        Dynamic[
         Replace[
          MouseAnnotation[Null], {
          TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][Null] -> 
           "", TypeSystem`NestedGrid`PackagePrivate`$SliceMarker[1895391721][
             Pattern[TypeSystem`NestedGrid`PackagePrivate`path, 
              Blank[]]] :> (
            TypeSystem`NestedGrid`PackagePrivate`$lastPath = 
             TypeSystem`NestedGrid`PackagePrivate`path; 
            TypeSystem`NestedGrid`PackagePrivate`makePathTrail[
             TypeSystem`NestedGrid`PackagePrivate`path, 
              TypeSystem`NestedGrid`PackagePrivate`makePathElements]), Null :> 
           Spacer[10], Blank[] :> Spacer[10]}], TrackedSymbols :> {}], 
        FrameStyle -> None, ImageMargins -> 0, FrameMargins -> 0, Alignment -> 
        Top, ImageSize -> {Automatic, 14}]}, 
     DynamicBox[
      ToBoxes[
       Column[
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, {
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}, {
         TypeSystem`NestedGrid`PackagePrivate`$topBar$$, 
          TypeSystem`NestedGrid`PackagePrivate`displayScrollBar[
          TypeSystem`NestedGrid`PackagePrivate`$grid$$, 
           TypeSystem`NestedGrid`PackagePrivate`$state$$, 
           TypeSystem`NestedGrid`PackagePrivate`$pos$$], 
          TypeSystem`NestedGrid`PackagePrivate`onDesktopShow[
           TypeSystem`NestedGrid`PackagePrivate`alignBar[
           TypeSystem`NestedGrid`PackagePrivate`$state$$][
           TypeSystem`NestedGrid`PackagePrivate`$bottomBar$$]]}], Spacings -> 
        If[TypeSystem`NestedGrid`PackagePrivate`$path$$ == {}, 
          0, {{}, {0, 0.05, 0}}]], StandardForm], 
      ImageSizeCache -> {897., {42., 48.}}, 
      TrackedSymbols :> {
       TypeSystem`NestedGrid`PackagePrivate`$state$$, 
        TypeSystem`NestedGrid`PackagePrivate`$grid$$}], 
     BaseStyle -> {LineBreakWithin -> False}, Deinitialization :> 
     TypeSystem`NestedGrid`PackagePrivate`deleteState[
      TypeSystem`NestedGrid`PackagePrivate`$state$$], 
     DynamicModuleValues :> {}, Initialization :> 
     Block[{$ContextPath = $ContextPath}, 
       Needs["TypeSystem`"]]], Deploy, DefaultBaseStyle -> "Deploy"]},
  "CopyTag",
  DisplayFunction->(#& ),
  InterpretationFunction->("Dataset[<>]"& )]], "Output",
 CellChangeTimes->{3.852254226812677*^9, 3.8522551110382366`*^9, 
  3.8550446653750486`*^9},
 CellLabel->
  "Out[1057]=",ExpressionUUID->"0df715ab-94cc-4a46-9184-30afebecc2af"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT97d8qBIClPPzKsEQYc
CMo/1S/Pde6YZD/JLsVgzTDKP/dhWOeTLmw/YLF4u35Zyj8NynCsHOJxP422
33Dhqso/F/z5HcJ3eT/owK3bpk3LPyIwhoCGUYQ/ntVJsTGTzD8oSsyxaL6R
Pwv/gVxHHs8/LVdvytl0oD+YaVdeLEbPPxqUkrvS66A/JNQsYBFuzz8D0bWs
y2KhPz6p12Pbvc8/20r8jr1Qoj+5qZa1ty7QP4w+iVOhLKQ/7VPsvEvO0D/v
JaPcaOSnP1Wol8tzDdI/s/TW7vdTrz8lUe7ow4vUPx5JnwmLGbc/Gn9HOmeh
1D+Q/hw8Elq3PxCtoIsKt9Q/BrSabpmatz/6CFMuUeLUP+seltOnG7g/0MC3
c9441T+79IydxB25P3owgf745dU/VKB6Mf4huz/ODxQULkDXP4j3VVlxKr8/
wz1tZdFV1z/7rNOL+Gq/P7hrxrZ0a9c/bWJRvn+rvz+jx3hZu5bXP6tmphFH
FsA/eH/dnkjt1z+R0aF2VZfAPyLvpiljmtg/XqeYQHKZwT8XHQB7BrDYPxeC
19m1ucE/DEtZzKnF2D/QXBZz+dnBP/emC2/w8Ng/RBKUpYAawj/s1GTAkwbZ
P/7s0j7EOsI/4gK+ETcc2T+4xxHYB1vCP8xecLR9R9k/K32PCo+bwj/CjMkF
IV3ZP+ZXzqPSu8I/t7oiV8Ry2T+fMg09FtzCP5Vq8rizhNk/7J4wYtT2wj9O
2SAq
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T//mT3dcEfDP4xyh5xR
ydk/d4QqHuiGwz93zjk/mPTZP+f3mF1P7cM/Di615ckI2j/l9eo/GB3EP6SN
MIz7HNo/4fM8IuFMxD/RTCfZXkXaP9rv4OZyrMQ/K8sUcyWW2j/O5yhwlmvF
P9/H76ayN9s/tNe4gt3pxj9HwaUOzXrcP4K32Kdr5sk/F7QR3gEB3z8cdxjy
h9/PP1yM+1TkFt8/7tkZf6gJ0D+iZOXLxizfP094JwWNI9A/LBW5uYtY3z8O
tUIRVlfQP0J2YJUVsN8/kC55Kei+0D82nFemlC/gP5Ah5lkMjtE/YV6mXaje
4D+TB8C6VCzTP4RKG5mZ6eA/9KXNQDlG0z+mNpDUivTgP1JE28YdYNM/7A56
S20K4T8UgfbS5pPTP3a/TTkyNuE/lPos63j70z+MIPUUvI3hP5btmRudytQ/
tuJDzM884j+X03N85WjWP9ZIgfGNR+I/hOirH1GC1j/2rr4WTFLiP3D948K8
m9Y/N3s5Ychn4j9MJ1QJlM7WP7gTL/bAkuI/Ans0lkI01z/YeWwbf53iP+6P
bDmuTdc/+N+pQD2o4j/bpKTcGWfXPzisJIu5veI/tM4UI/GZ1z+5RBogsuji
P2oi9a+f/9c/2qpXRXDz4j9YNy1TCxnYP/oQlWou/uI/Rkxl9nYy2D863Q+1
qhPjPx521TxOZdg/WkNN2mge4z8Miw3guX7YP7Cb30LAKOM/yrJNaDKX2D9+
TSNv
                "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z8cEGI7077YP9rbQm9h
SeM/oLVus47P2D/6QYCUH1TjP24k0xzh3tg/Ow773ptp4z8LApzvhf3YP7ym
8HOUlOM/RL0tlc862T/cDC6ZUp/jPxIskv4hStk//HJrvhCq4z/fmvZndFnZ
Pz0/5giNv+M/fHi/Ohl42T++19udherjP7UzUeBitdk/vwjHx3ZA5D8lqnQr
9i/aP8JqnRtZ7OQ/Bpe7wRwl2z+z6WtrXvbkP3IvWYxnM9s/pGg6u2MA5T/e
x/ZWskHbP4Vm11puFOU/tPgx7Ede2z9IYhGagzzlP2NaqBZzl9s/z1mFGK6M
5T/CHZVryQncP9xIbRUDLeY/f6RuFXbu3D/1Jj0PrW3nP/axIWnPt94/FwJG
qSaP6T+NywEM5uDgP8Ivm9U=
                "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T8bUOxccu7gPzb/YLZT
ruw/NHa6H4y04j9MTcCCRbjsP39ZTYRZuuI/Y5sfTzfC7D/KPODoJsDiP5A3
3uca1uw/YAMGssHL4j/pb1sZ4v3sP4uQUUT34uI/nOBVfHBN7T/iquhoYhHj
PwHCSkKN7O0/kN8Wsjhu4z8YEKoOf/btP9vCqRYGdOM/Ll4J23AA7j8lpjx7
03njP1r6x3NUFO4/u2xiRG6F4z+0MkWlGzzuP+b5rdajnOM/ZqM/CKqL7j89
FEX7DsvjP8yENM7GKu8/60hzROUn5D86D8sCkTXvP6KSTO0wLuQ/qJlhN1tA
7z9a3CWWfDTkP4OujqDvVe8/x2/Y5xNB5D862OhyGIHvP6SWPYtCWuQ/qGJ/
p+KL7z9b4BY0jmDkPxbtFdyslu8/Eirw3Nlm5D/xAUNFQazvP4C9oi5xc+Q/
qCudF2rX7z9d5AfSn4zkPxa2M0w04u8/FC7heuuS5D+EQMqA/uzvP8t3uiM3
meQ/fWisD4317z8lTdFCNZ7kP2sRzas=
                "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAwcspeDkF8D+0hAjiyqjkPx41kqkT
DPA/Pjnoua2u5D+Lvyje3RbwP/1zfXLyt+Q/QumCsAZC8D/7XtJUBd3kP3ku
zsprR/A/Wvwcsafh5D+wcxnl0EzwP7qZZw1K5uQ/Hv6vGZtX8D961PzFju/k
P/kS3YIvbfA/+EknNxgC5T+wPDdVWJjwP/Y0fBkrJ+U/H5Dr+anu8D/xCibe
UHHlP+v3397VMPI/pm2PQg+G5j+2Z4/CSjbyP5YeYy6/iuY/gNc+pr878j+F
zzYab4/mPxa3nW2pRvI/ZTHe8c6Y5j9Cdlv8fFzyPyT1LKGOq+Y/mvTWGSSI
8j+kfMr/DdHmP2Vkhv2YjfI/lC2e673V5j8w1DXhDZPyP4Tecddt2uY/xrOU
qPed8j9kQBmvzePmP/FyUjfLs/I/IgRoXo325j9I8c1Uct/yP6GLBb0MHOc/
E2F9OOfk8j+RPNmovCDnP97QLBxc6vI/ge2slGwl5z90sIvjRfXyP2FPVGzM
Luc/n29JchkL8z8gE6MbjEHnP2rf+FWOEPM/EMR2BzxG5z80T6g5AxbzP/90
SvPrSuc/yi4HAe0g8z/e1vHKS1TnP5WetuRhJvM/zofFtvtY5z9gDmbI1ivz
P744maKrXec/cmcJu/kt8z8Whu11gV/nP5i+B9E=
                "]], 
               LineBox[{{1.2012755102040815`, 0.7312766678794694}, {
                1.2021994123405053`, 0.7315087664712776}, {1.203531589880046, 
                0.73184343019677}, {1.2061959449591275`, 
                0.7325127576477548}, {1.2115246551172902`, 
                0.7338514125497244}, {1.222182075433616, 
                0.7365287223536636}, {1.2234898928959086`, 
                0.7368572664487291}, {1.224797710358201, 
                0.7371858105437944}, {1.2274133452827862`, 
                0.7378428987339252}, {1.2326446151319568`, 
                0.7391570751141868}, {1.2431071548302977`, 
                0.74178542787471}, {1.2640322342269796`, 
                0.7470421333957566}, {1.3058823930203434`, 
                0.7575555444378496}, {1.3839420330101317`, 
                0.777165340545495}, {1.3987244897959183`, 
                0.7808789236926537}}], 
               LineBox[{{1.4012755102040815`, 0.7815197797109119}, {
                1.547629076117258, 0.8182860726064424}, {1.5489670042909665`, 
                0.8186221809807127}, {1.550304932464675, 
                0.8189582893549832}, {1.5529807888120917`, 
                0.8196305061035238}, {1.5583325015069254`, 
                0.8209749396006052}, {1.5690359268965925`, 
                0.8236638065947679}, {1.5703738550703008`, 
                0.8239999149690382}, {1.5717117832440093`, 
                0.8243360233433086}, {1.5743876395914262`, 
                0.8250082400918494}, {1.5797393522862597`, 
                0.8263526735889307}, {1.5904427776759271`, 
                0.8290415405830934}, {1.5917807058496356`, 
                0.8293776489573639}, {1.5931186340233439`, 
                0.8297137573316341}, {1.5957944903707606`, 
                0.8303859740801748}, {1.597132418544469, 
                0.8307220824544452}, {1.5984703467181776`, 
                0.8310581908287156}, {1.5987244897959185`, 
                0.8311220355240961}}], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAW2XDEdOe+T/ITLTLH53qPyiCgGbG
o/k/2UR3OPie6j8ahNxRQan5P4NUWzADoeo//oeUKDe0+T/VcyMgGaXqP8SP
BNYiyvk/e7Kz/0St6j/frsSL0SH6PxCt9H30zeo/0O0E7DIn+j9h50Dw9c/q
P8AsRUyULPo/sSGNYvfR6j+gqsUMVzf6P1KWJUf61eo/YqbGjdxM+j+Uf1YQ
AN7qP+adyI/nd/o/GFK4ogvu6j/tjMyT/c36PyD3e8ciDus/+2rUmyl6+z8w
QQMRUU7rP1Q2XZEuf/s/HwsEEDBQ6z+sAeaGM4T7Pw7VBA8PUus/Xpj3cT2O
+z/taAYNzVXrP8HFGkhRovs/qpAJCUld6z+HIGH0eMr7PyXgDwFBbOs/E9bt
TMga/D8ZfxzxMIrrP2yhdkLNH/w/CUkd8A+M6z/EbP830iT8P/gSHu/ujes/
dgMRI9wu/D/Xph/trJHrP9kwNPnvQvw/lM4i6SiZ6z+fi3qlF2v8Pw4eKeEg
qOs/K0EH/ma7/D8DvTXREMbrP7CqqyfYwPw/qucFJhjI6z80FFBRScb8P1ES
1nofyus/DAGjVJPH/D8QOs9/msrrP8Zj43M=
                "]], 
               LineBox[{{1.8012755102040816`, 0.8689160023815036}, {
                1.8063815056019226`, 0.869702176713424}, {1.8170104932192683`,
                 0.8713387307225777}, {1.8382684684539596`, 
                0.8746118387408851}, {1.8807844189233422`, 0.8811580547775}, {
                1.9601756422651684`, 0.8933819870586563}, {
                1.9987244897959184`, 0.8993173849766811}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDcI72XAMrsPxMP8AjE
+gBAjHNq1p067T/SvYqHSf0AQKpkxcTCO+0/kmwlBs//AEDIVSCz5zztPxLK
WgPaBAFABDjWjzE/7T8ShcX97w4BQH78QUnFQ+0/EPua8hsjAUBvhRm87Ezt
PwznRdxzSwFAUpfIoTtf7T/MleBa+U0BQHCII5BgYO0/jER72X5QAUCOeX5+
hWHtPwuisNaJVQFAyls0W89j7T8KXRvRn18BQEMgoBRjaO0/CNPwxctzAUA1
qXeHinHtP8iBi0RRdgFAU5rSda9y7T+IMCbD1ngBQHGLLWTUc+0/B45bwOF9
AUCtbeNAHnbtPwZJxrr3hwFAJjJP+rF67T/G92A5fYoBQEQjqujWe+0/hqb7
twKNAUBjFAXX+3ztPwUEMbUNkgFAn/a6s0V/7T/Essszk5QBQLznFaJqgO0/
ubOE3fyWAUCCcRvvgoHtP8EjplM=
                "]], 
               LineBox[{{2.201275510204082, 0.9223075778123243}, {
                2.2025743146728987`, 0.9224128293900242}, {
                2.2039086887592343`, 0.922520963432677}, {2.206577436931906, 
                0.9227372315179827}, {2.21191493327725, 0.9231697676885939}, {
                2.222589925967937, 0.9240348400298166}, {2.2439399113493117`, 
                0.9257649847122619}, {2.2866398821120604`, 
                0.9292252740771524}, {2.3704807786936803`, 
                0.936019512049731}, {2.398724489795918, 0.9383083054939966}}],
                LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0DLftKtUAjuP7VTRwOU
RARAElGGbBVg7j+IS7iFHEcEQAYiQaPnYO4/XEMpCKVJBED78vvZuWHuPwIz
Cw22TgRA5JRxR15j7j9OEs8W2FgEQLXYXCKnZu4/6NBWKhxtBEBYYDPYOG3u
PxpOZlGklQRAnm/gQ1x67j/tRdfTLJgEQJJAm3oue+4/wD1IVrWaBECHEVax
AHzuP2YtKlvGnwRAb7PLHqV97j+zDO5k6KkEQEH3tvntgO4/hgRf53CsBEA1
yHEwwIHuP1r8z2n5rgRAKpksZ5KC7j8A7LFuCrQEQBI7otQ2hO4/TMt1eCy+
BEDkfo2vf4fuPx/D5vq0wARA2E9I5lGI7j/yuld9PcMEQMwgAx0kie4/xrLI
/8XFBEDB8b1T9onuP5mqOYJOyARAtcJ4isiK7j/s5rcQMMoEQNPaFaNki+4/
A9udvA==
                "]], 
               LineBox[{{2.601275510204082, 0.954670806734363}, {
                2.603990662333868, 0.9547808210021825}, {2.6052275961112112`, 
                0.9548309398748465}, {2.607701463665898, 
                0.9549311776201741}, {2.6126491987752725`, 
                0.9551316531108295}, {2.613861772475368, 
                0.9551807849463276}, {2.6150743461754633`, 
                0.9552299167818258}, {2.6174994935756546`, 
                0.9553281804528222}, {2.6223497883760363`, 
                0.955524707794815}, {2.6320503779767996`, 
                0.9559177624788006}, {2.6514515571783264`, 
                0.9567038718467716}, {2.6902539155813803`, 
                0.9582760905827139}, {2.774462852749733, 
                0.9616881220725175}, {2.798724489795918, 
                0.9626711705751992}}], 
               LineBox[{{2.8012755102040816`, 0.9627848708365031}, {
                2.9382035922548035`, 0.969442638197154}, {2.998724489795918, 
                0.9723853074455064}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ/fCpyJ45TBwOASf0bbfJvbcXvrd1EdMRDge3s3s6
+Oze2/fx1NZuP8bhUPGX7UodkM9l7RKRc5LDYZVuoPx7IJ9pxiXea+c4HPj6
nm49b//e/lPg+4qVNzkcrvrxPZ7g+N7+wlEN/4D3HA6pF+JthV3f2/esnf17
rhSnQ8tlpk/iPu/tOe4kXQuS5XTYxuxr2wHkt3BpbWRX4HR4YTy94weQX52+
I61QldPBZ4q2/E3f9/ZZilcvuhhwOgiHhvjM8n9v7zGVb8VrV06HxdeWLpMJ
fm/PWtsYYlnI6XDopke0YtR7+y0f3/zcX8zpwC0XptkF5KekRcx3K+N0CElK
/v4JyD/ir/8quJrT4fmr2slHooH2K92tz2vldOD5s+l0eux7e5PpHqpf2zkd
whwOzLwA5D/h3nKquovTYX7L2XTLuPf2Ll+7RDv7OR2MeF8wc8e/t/+S+W0X
/yROh+rArxeLgfwl9xITpk3hdDgylWnBHSB/5+aWu3+mcTqEll00d0h4bw8A
cd+wVA==
                "]], LineBox[CompressedData["
1:eJwVzFtIk3EYx/Ephbz/twPTrJHMWmZ4WDaJ6iZ8HskSkjIFlcDNXOzC2BwK
ppWH1kSNMpqYFy+SpbYUNxUXqctGDefZmANdGWooitDhsWGF5EVvFz++fG5+
Cq0xUxcskUiixP3vnarurNPNHNqs5Tkp+QTDwhq62ji86Lo3uaUlMBsa5z7a
Oazkph0pOoLgsI2gPW4O11ryq+cLCCSdmp7lUIZ1W46RxHKCkW/+wpZwhmlz
BaNe0Q9VGQm5Moa7HYfGjBUEBwbO2WflDC36B+P2SoKE0ZiusRiGwpJ2KtZE
kLsasHYnMbR5pD5FDcGgovbp7RsMvRbjgvQxQaVOojljYNhQGL3YKzql85Z8
08gwK+3zYrqFwKvSNxtKGH7akfqlvoFgHTKEa3cZLpdGrnBPCPZrIpouNDHc
VE+vBwkExUJPfaiboSwufvNnG0H/tlDrHmY44ZTsfdROsK2pMRWPMqxIm4uN
e0FQG6Uu8U2Jf3pTntZK0Gxj6gY/w64e/4Svg8Dj0ilDvzNMOlX93GEnYIqM
Y25iuOG5OpTeTXDFfPZwcYBha/YJ/1fR86lh+3x/GIaUze862kvww/vuryWY
R69TVdbYRyBbiZiUyni8jguXS/oJ1OdDPO8P8hg+01cgHSBofRlwFcl5HMuv
q7aLVurH+2aO8Kg0n3SuDhIUfXhlM0XzuBTGzZqcBK9Vz6yJMTxa2hdJ/oYg
+ddNwXKcx9+e+9HZQwQ1OdrGZBWPHdl5GBCdeSmytEl01XS8eedbgn+L0Au1

                "]], LineBox[CompressedData["
1:eJwVz30s1HEcB/CjPMz3W9fFhOXh7GaebrOZiiu/TzWFjYZql4eGKDTc6Uk6
1HmcavOQ0zgjmYdG6NqkudOVzlMoDyUa1koe4jcPNbG1Pv3x2Xuv7b299+FH
JwfH6nM4HGe8/2lm6csOexDoWK5cfqZmmbMZAnnQIQITU/kdPeiKWa5MT0Rg
bUBuOI2ePbZ9re0IAdIpC9lAJxiNxPOOE/BWSpbtNCzTEq++oPUhIL6X4HUQ
vTHQECH1JSCVxeQFoDMLM4M+BBCoDRfz09APLIWeRWICJtZwZhStdsk35iUR
+FjJVed0scyBsX2DxRICYZuKgnJ0q6y+yOwKgZlgG3ELumZQZ2WRSmDeSLg+
gc5PNhDayglsSf2dXF+xTLBKHiRUELA9kVM6gv7hlV7upyEQt7KVaPuaZXj+
Ka7y3RS2vOdsOrpZplrLJV48Couhkc3DaDfP5oVVUwpT1ydFc+hAx/m6KEsK
nU+HxKZvWabA8Dz/qIBCpk17cSJ65xs/c44XBYO/eYb2Opb5LeJzMmIp8NRO
KwU9LJOj0kx7xFHQ+/xY9ght5hKuXk6gsLZhTV6g3a3K0iIkFMZc9zp+R0s2
6a/DtyiUKbeimF6WWXi+ubBdSGG/bGB8HZ3qquhVlVDY9dAnxqSPZYxr3esv
Kyj8VXWt2aEdSpJipioozCypuIHoaOm36Zd1FGrClH4N6NX5O+qURgolN8wn
NOjbkbZK5yYK2SWFF8fRVadCz5W3UYgdyM7S72eZL8L3ozc7KTiKEtXh6Kol
XvqOLuxrr76ToqMbQxzua3HvpGwqF+1wqXTYvJuCaChrsQK9IPiUWq3Df07f
/dOKbvpqYe/cR2F9sthYh/45177HrZ8C/4kgdwj9DwlNRBw=
                "]], 
               LineBox[{{3.601275510204082, 0.9935170178282009}, {
                3.6068988062055514`, 0.9935170178282009}, {3.611855327502106, 
                0.9935170178282009}, {3.621768370095216, 
                0.9935170178282009}, {3.6316814126883257`, 
                0.9935170178282009}, {3.651507497874545, 
                0.9935170178282009}, {3.6713335830607647`, 
                0.9935170178282009}, {3.7102062309612647`, 
                0.9935170178282009}, {3.749078878861765, 
                0.9935170178282009}, {3.7701662579025763`, 
                0.9935170178282009}, {3.791253636943387, 
                0.9935170178282009}, {3.7938895593234885`, 
                0.9935170178282009}, {3.79652548170359, 0.9935170178282009}, {
                3.7978434428936403`, 0.9935170178282009}, {3.798724489795918, 
                0.9935170178282009}}], LineBox[CompressedData["
1:eJwVz30s1HEcB/ALTdN8v0XZLAnJU6G0a9pVv8+asBzjhtukEWnc2NV6IDSP
p7o8bVTkaXaYVZSHG9n1pJblHOMIm3EjpOHbLQ/z3Kc/Pvvs9cf7/dnHNkoq
ijHg8XiOOP+3jzDFzjCOgLvHZ91aN+PkNgJlVzyBJrdte0s146bUm83JUgLT
W5tyd3SxXXqj7g4BYfl6aDh6tS+n9nUaAcvR5UUlOjDFVxGRScC/fim4B13v
YFJtJiOQnvi3YxId9iCvPElOYPagPof2ME7lUlzk9ZSAUjRvHYdOl1VnjL0k
ENgzGWClYZxpovHlaw0EFndL+afQL2ITzGbeEMjjNg55o1v8zipYK4HuZvM5
KXpmf/9Xg48EvEq9sr6g/Sp5e5y1BDxv1LVJehln0RaRf3eDgA1PYvOuj3EN
vw6XESEFdlqvDxlg3KMKWeR4AIVz4Z3eCejrooVjjUEUHmcXlWWjrVSqt/5i
CkeH+Jda0PKCK99yoyiE3ksu2adlXOyZUr3JfQrv2w05Ndou+4CvcR0F+XmL
XBhi3LZnqulwPYXhmFmdGD26MDVQ9wr78tv5UnShuOWqdxPmx8MmKtA7LqLb
MhWFP2lVHhvosf6CSkMtBXGn06jyB+Pac1ajtUMUan6vuWrQxYIIZ8UIBb2Z
OvMn2q/WrfXiON6PTjhhPsy4jiTN94w5Ch+MmtNuop+58guC5imYuGYNPkTf
miwPtmXYHxLsXIV2EsZPfFrCvtqVAQ3aaNdgTeEqhQu9XY7TaJ1SIIlcp/Bk
pSR1E62SKNxPbuF/1pJ+8xHGPT+yd3lnh4K9j8DhOPof/II6ZA==
                "]]},
              Annotation[#, "Charting`Private`Tag$317447#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], LineBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAApPfnWmXDyT9VAYiIVN4+PzKsEQYc
CMo/msY7h31nVD/JLsVgzTDKP/NWilLu6ls/YLF4u35Zyj+mc+yOL7dhP422
33Dhqso/5wM7WqA6aT/owK3bpk3LP0ASbPjAIHQ/ntVJsTGTzD9tmYRH0ZOB
Pwv/gVxHHs8/Bt0Qb1lNkD+YaVdeLEbPP+TXlsw0w5A/JNQsYBFuzz/A0hwq
EDmRPz6p12Pbvc8/fMgo5cYkkj+5qZa1ty7QP/WzQFs0/JM/7VPsvEvO0D/m
inBHD6uXP1Wol8tzDdI/yTjQH8UInz8lUe7ow4vUP0fKR2gY4qY/Gn9HOmeh
1D880sG2BCKnPxCtoIsKt9Q/M9o7BfFhpz/6CFMuUeLUPx3qL6LJ4ac/0MC3
c9441T/1CRjceuGoP3owgf745dU/oEnoT93gqj9vXtpPnPvVP5VRYp7JIKs/
ZIwzoT8R1j+KWdzstWCrP0/o5UOGPNY/dmnQiY7gqz8koEqJE5PWP0yJuMM/
4Kw/zg8UFC5A1z/3yIg3ot+uP8M9bWXRVdc/7NACho4frz+4a8a2dGvXP+DY
fNR6X68/o8d4WbuW1z/N6HBxU9+vP3h/3Z5I7dc/UYSsVYJvsD9trTbw6wLY
P0yI6Xx4j7A/YtuPQY8Y2D9GjCakbq+wP003QuTVQ9g/PJSg8lrvsD8i76Yp
Y5rYPyeklI8zb7E/Fx0Aewaw2D8hqNG2KY+xPwxLWcypxdg/G6wO3h+vsT/3
pgtv8PDYPxK0iCwM77E/7NRkwJMG2T8MuMVTAg+yP+ICvhE3HNk/CLwCe/gu
sj/MXnC0fUfZP/zDfMnkbrI/wozJBSFd2T/4x7nw2o6yP7e6IlfEctk/88v2
F9Gusj+VavK4s4TZP2pf5AtPybI/8TlVqA==
                "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAn8hAen+u2T/WQfwQC06zP4xyh5xR
ydk/ffRyqsfQsz93zjk/mPTZP/ZBn+C5o7Q/Di615ckI2j8bhicPKQa1P6SN
MIz7HNo/O8qvPZhotT/RTCfZXkXaP4FSwJp2LbY/K8sUcyWW2j8MY+FUM7e3
P9/H76ayN9s/I4QjyazKuj9HwaUOzXrcPyjj09jPeMA/F7QR3gEB3z9VJVjB
wp/GP1yM+1TkFt8/FbD5NRnVxj+iZOXLxizfP9c6m6pvCsc/LBW5uYtY3z9W
UN6THHXHP0J2YJUVsN8/WntkZnZKyD82nFemlC/gP1zRcAsq9ck/YV6mXaje
4D9kfYlVkUrNP4RKG5mZ6eA/Jggryud/zT+mNpDUivTgP+SSzD4+tc0/7A56
S20K4T9oqA8o6x/OP3a/TTkyNuE/ZtOV+kT1zj+MIPUUvI3hP7YU0U/8T9A/
tuJDzM884j+4at30r/rRP9ZIgfGNR+I/xhumrN4U0j/2rr4WTFLiP9TMbmQN
L9I/N3s5Ychn4j/zLgDUamPSP7gTL/bAkuI/LvMisyXM0j+5RBogsujiP6F7
aHGbndM/sJvfQsAo4z/3boRbuTnUP3dN5OI=
                "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z9hypMttmXUP9wMLplS
n+M/loWfOtcS1T/8cmu+EKrjP3Jj1O7hJdU/PT/mCI2/4z8rHz5X90vVP77X
252F6uM/m5YRKCKY1T+/CMfHdkDkP3uFuMl3MNY/wmqdG1ns5D87YwYNI2HX
P/UmPQ+tbec/NXZWQujR2z8+4kLHinjnP6o5fO0q5ds/hp1If2iD5z8e/aGY
bfjbPxYUVO8jmec/BoTt7vIe3D82AWvPmsTnP9aRhJv9a9w/eNuYj4gb6D94
rbL0EgbdP/yP9A9kyeg/vuQOpz063j9ES/rHQdToPzKoNFKATd4/jAYAgB/f
6D+ma1r9wmDePx19C/Da9Og/kPKlU0iH3j8+aiLQUSDpP2AAPQBT1N4/hiUo
iC8r6T/Uw2KrlefeP87gLUANNuk/SIeIVtj63j9eVzmwyEvpPzAO1KxdId8/
f0RQkD936T8CHGtZaG7fP8j/VUgdguk/eN+QBKuB3z8Qu1sA+4zpP+uitq/t
lN8/FwJGqSaP6T8GspebxpjfP5Luypc=
                "]], LineBox[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T/qiS1nLrffP+jsbCiU
rek/oueMJwXC3z8wqHLgcbjpPy5nCQBhzt8/wB5+UC3O6T9HZgKxGOffPwja
gwgL2ek/1OV+iXTz3z9QlYnA6OPpP2Bl+2HQ/98/4QuVMKT56T89MnoJRAzg
PwL5qxAbJeo/VzFzuvsk4D8bzULzPy/qPxn39YnAKuA/NKHZ1WQ56j/bvHhZ
hTDgP2VJB5uuTeo/Xkh++A484D/ImWIlQnbqP2RfiTYiU+A/jzoZOmnH6j9z
jZ+ySIHgPxx8hmO3aes/junLqpXd4D82/2C2U67sP8ahJJsvluE/TE3AgkW4
7D/JYkNd15vhP2ObH083wuw/ziNiH3+h4T+QN97nGtbsP9aln6POrOE/6W9b
GeL97D/mqRqsbcPhP5zgVXxwTe0/BrIQvavw4T8BwkpCjeztP0bC/N4nS+I/
GBCqDn/27T9Kgxuhz1DiPy5eCdtwAO4/TkQ6Y3dW4j9a+sdzVBTuP1bGd+fG
YeI/tDJFpRs87j9myvLvZXjiP2ajPwiqi+4/htLoAKSl4j/MhDTOxirvP8bi
1CIgAOM/Og/LApE17z+aiT72QgbjP6iZYTdbQO8/bzCoyWUM4z+Dro6g71Xv
Pxd+e3CrGOM/OtjochiB7z9oGSK+NjHjP6hif6fii+8/PMCLkVk34z8W7RXc
rJbvPxBn9WR8PeM/8QFDRUGs7z+4tMgLwknjP6grnRdq1+8/CVBvWU1i4z8W
tjNMNOLvP9322CxwaOM/hEDKgP7s7z+xnUIAk27jP31orA+N9e8/vhZJvXBz
4z8cRzPd
                "]], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAwcspeDkF8D9DiTH5KX3jPx41kqkT
DPA/HA0roB+C4z+Lvyje3RbwPynKyNvuieM/wgR0+EIc8D+wqJd51o3jP/hJ
vxKoIfA/NodmF76R4z9m1FVHcizwP0VEBFONmeM/QumCsAZC8D9hvj/KK6nj
P3kuzsprR/A/6JwOaBOt4z+wcxnl0EzwP2973QX7sOM/Hv6vGZtX8D99OHtB
yrjjP/kS3YIvbfA/mbK2uGjI4z+wPDdVWJjwP9GmLael5+M/H5Dr+anu8D9C
jxuEHybkP+v3397VMPI/dWqLCE4P5T+2Z4/CSjbyPyC8bxNBE+U/gNc+pr87
8j/LDVQeNBflPxa3nW2pRvI/IrEcNBof5T9Cdlv8fFzyP9D3rV/mLuU/mvTW
GSSI8j8shdC2fk7lP0jxzVRy3/I/458VZa+N5T9yZwm7+S3zP353dNyFxuU/
L8SrYQ==
                "]], 
               LineBox[{{1.2012755102040815`, 0.6813033189642178}, {
                1.2234898928959086`, 0.6875377838260304}, {1.224797710358201, 
                0.6879048227002336}, {1.2274133452827862`, 
                0.6886389004486401}, {1.2326446151319568`, 
                0.6901070559454531}, {1.2431071548302977`, 
                0.693043366939079}, {1.2640322342269796`, 
                0.698915988926331}, {1.3058823930203434`, 
                0.7106612329008348}, {1.3839420330101317`, 
                0.7325686650988552}, {1.3987244897959183`, 
                0.7367173605040243}}], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j9qZYJDhJnnP4IILFOG
ifc/BVB/p1RT6D8O0KzBo5P3P6JP95fnWeg/Jl+unt6n9z/aTud4DWfoP1Z9
sVhU0Pc/TE3HOlmB6D+1ubfMPyH4Py9Kh77wteg/eh34g04m+D/8ScM2Orno
P0CBODtdK/g/ykn/roO86D/MSLmpejX4P2dJd58Ww+g/5Ne6hrVJ+D+gSGeA
PNDoPxT2vUArcvg/EUdHQojq6D90MsS0FsP4P/RDB8YfH+k/ZjQgoJHI+D/x
fUmRryLpP1g2fIsMzvg/7beLXD8m6T87OjRiAtn4P+QrEPNeLek/AkKkD+7u
+D/VExkgnjvpP49RhGrFGvk/tOMqehxY6T+AU+BVQCD5P7AdbUWsW+k/clU8
Qbsl+T+sV68QPF/pP1ZZ9BexMPk/pMszp1tm6T8cYWTFnEb5P5SzPNSadOk/
qnBEIHRy+T90g04uGZHpP5xyoAvvd/k/cL2Q+aiU6T+NdPz2aX35P2z30sQ4
mOk/cHi0zV+I+T9ka1dbWJ/pP2J6ELnajfk/YKWZJuii6T9UfGykVZP5P1zf
2/F3puk/2c1vIWCU+T8nlHokJafpP5Xw5EA=
                "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAW2XDEdOe+T90XWpFKazpPyiCgGbG
o/k/nqAaY7Kt6T8ahNxRQan5P78NwI9lr+k//oeUKDe0+T8C6Arpy7LpP8SP
BNYiyvk/hZygm5i56T+2kWDBnc/5P6YJRshLu+k/qJO8rBjV+T/Iduv0/rzp
P4uXdIMO4Pk/CVE2TmXA6T9Sn+Qw+vX5P40FzAAyx+k/367Ei9Eh+j+Vbvdl
y9TpP9DtBOwyJ/o/JsM7pnbW6T/ALEVMlCz6P7YXgOYh2Ok/oKrFDFc3+j/W
wAhneNvpP2Kmxo3cTPo/FhMaaCXi6T/mnciP53f6P5i3PGp/7+k/7YzMk/3N
+j+aAIJuMwrqP/tq1Jspevs/oJIMd5s/6j8rQQf+Zrv8P7aqcNhAo+o/DAGj
VJPH/D8f6D2CB6fqP3dXpWQ=
                "]], 
               LineBox[{{1.8012755102040816`, 0.833284975733277}, {
                1.9601756422651684`, 0.8579297524931205}, {
                1.9987244897959184`, 0.8639085250052753}}], 
               LineBox[{{2.001275510204082, 0.8642759171615468}, {
                2.122444219423309, 0.8803840173531724}, {2.1987244897959184`, 
                0.8905246736804026}}], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUCpMWxMzYHsP2s0u9kJ
SwJA9ZgpDHDU7D/A0NWsuE0CQAZS/LC01ew/FW3wf2dQAkAYC89V+dbsP7+l
JSbFVQJAOn10n4LZ7D8TF5BygGACQH5hvzKV3uw/u/lkC/d1AkAHKlVZuujs
Pwu/Dj3koAJAGbuApgT97D9gWykQk6MCQCp0U0tJ/uw/tfdD40GmAkA7LSbw
jf/sP18weYmfqwJAXZ/LORcC7T+zoePVWrYCQKKDFs0pB+0/W4S4btHLAkAr
TKzzThHtP6tJYqC+9gJAPN3XQJkl7T80LCE+P/kCQBHQPQ7IJu0/vg7g27/7
AkDlwqPb9iftP9DTXRfBAANAjqhvdlQq7T/0XVmOwwoDQN9zB6wPL+0/fUAY
LEQNA0CzZm15PjDtPwYj18nEDwNAh1nTRm0x7T8Z6FQFxhQDQDA/n+HKM+0/
PnJQfMgeA0CCCjcXhjjtP8dUDxpJIQNAVv2c5LQ57T9QN863ySMDQCrwArLj
Ou0/YvxL88ooA0DT1c5MQT3tP+veCpFLKwNAp8g0GnA+7T90wckuzC0DQHu7
mueeP+0//qOIzEwwA0BQrgC1zUDtP1JNHneWMANA1vz0hvBA7T80V9JE
                "]], 
               LineBox[{{2.4012755102040817`, 0.9144221203991195}, {
                2.4046933744994785`, 0.9146745475996658}, {2.409580888186021, 
                0.9150355161141815}, {2.4108027666076564`, 
                0.9151257582428104}, {2.412024645029292, 
                0.9152160003714394}, {2.414468401872563, 
                0.9153964846286972}, {2.419355915559106, 
                0.9157574531432129}, {2.429130942932191, 
                0.9164793901722443}, {2.4486809976783612`, 
                0.9179232642303071}, {2.450006067043157, 0.918021127551193}, {
                2.4513311364079526`, 0.918118990872079}, {2.453981275137544, 
                0.9183147175138509}, {2.459281552596727, 
                0.9187061707973947}, {2.4698821075150925`, 
                0.9194890773644823}, {2.491083217351824, 
                0.9210548904986574}, {2.5334854370252864`, 
                0.9241865167670076}, {2.5987244897959183`, 
                0.9290047629095949}}], 
               LineBox[{{2.601275510204082, 0.9291931691435804}, {
                2.6902539155813803`, 0.9357646909587428}, {2.774462852749733, 
                0.9419839625369077}, {2.798724489795918, 
                0.9437758116540558}}], 
               LineBox[{{2.8012755102040816`, 0.943954797576342}, {
                2.9382035922548035`, 0.9530563687613974}, {2.998724489795918, 
                0.9570791758357698}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEDHjlLe26HuPxPetaIC
xAhAM+SyIf7a7j+ODH19t8YIQAY5v9DK2+4/CjtEWGzJCEDYjct/l9zuPwKY
0g3WzghAfTfk3TDe7j/yUe94qdkIQMiKFZpj4e4/0MUoT1DvCEBcMXgSyefu
P4ytm/udGglAhH49A5T07j8I3GLWUh0JQFbTSbJg9e4/hAoqsQcgCUApKFZh
LfbuP3tnuGZxJQlAztFuv8b37j9qIdXRRDAJQBgloHv5+u4/SJUOqOtFCUCs
ywL0XgHvPwV9gVQ5cQlA1BjI5CkO7z+08ez5v3MJQMBxMO3oDu8/ZGZYn0Z2
CUCtypj1pw/vP8RPL+pTewlAhnxpBiYR7z+EIt1/boUJQDjgCigiFO8/NJdI
JfWHCUAlOXMw4RTvP+QLtMp7iglAEZLbOKAV7z9E9YoViY8JQOpDrEkeF+8/
9Gn2ug+SCUDXnBRS3RfvP6TeYWCWlAlAw/V8WpwY7z+5s4Td/JYJQMMN6OJR
Ge8/USm25Q==
                "]], 
               LineBox[{{3.201275510204082, 0.9719821089440207}, {
                3.2049527235388684`, 0.9721178996875505}, {3.209886242298752, 
                0.9723000828027604}, {3.21975327981852, 0.9726644490331802}, {
                3.2209866595084913`, 0.9727099948119826}, {
                3.2222200391984623`, 0.9727555405907851}, {
                3.2246867985784045`, 0.9728466321483901}, {
                3.2296203173382887`, 0.9730288152636}, {3.2394873548580567`, 
                0.9733931814940198}, {3.2592214298975932`, 
                0.9741219139548594}, {3.2605580005307244`, 
                0.9741712703297903}, {3.2618945711638556`, 
                0.9742206267047213}, {3.2645677124301176`, 
                0.9743193394545833}, {3.269913994962642, 
                0.9745167649543073}, {3.2806065600276906`, 
                0.9749116159537551}, {3.3019916901577884`, 
                0.9757013179526509}, {3.3447619504179835`, 
                0.9772807219504425}, {3.398724489795918, 
                0.9792734301992584}}], 
               LineBox[{{3.4012755102040817`, 0.9793582130045518}, {
                3.507084223974069, 0.9824840243419222}, {3.5084114898856598`, 
                0.9825232345608761}, {3.509738755797251, 0.98256244477983}, {
                3.5123932876204327`, 0.982640865217738}, {3.517702351266796, 
                0.9827977060935537}, {3.5283204785595235`, 
                0.9831113878451853}, {3.5495567331449775`, 
                0.9837387513484482}, {3.5508839990565684`, 
                0.9837779615674022}, {3.552211264968159, 
                0.9838171717863562}, {3.5548657967913413`, 
                0.983895592224264}, {3.560174860437705, 0.9840524331000798}, {
                3.570792987730432, 0.9843661148517113}, {3.5920292423158866`, 
                0.9849934783549744}, {3.593268372640025, 
                0.9850300848638116}, {3.5945075029641638`, 
                0.9850666913726487}, {3.5969857636124414`, 
                0.9851399043903231}, {3.5987244897959183`, 
                0.985191270008742}}], LineBox[CompressedData["
1:eJwV0H0s1HEcB/DbyUPn9/2eozCxpBKzhF1XNnw+msTNapToPO1OUktddG1l
eWhSMrWMdtYDW1sJ23WOZI5zXQ+YNWYoZ2XZMQ37iv7QiH798d57r//ee+9S
qZNyhAKBYC+f/60z/Ki4MMRhR7/zC+VdBkVa5RXrGIeRc+XS5AoGW9xmLItW
Dnuql32332MgES3kbpvh0GQb/FNbySB21nFdRwhaQkIzah8y0NfDHlsmwf7+
td01TxmsFK44KpUEtdVw6BdvWUrj/LdsgjmKMvmJZwyMYnHbl/MEhQuifOd6
Bp9Kv0cPFhCMEHuZyhoYTKqKsgx3COqTD6dqnjNw2Gd8XKojWDetqUp+xSDe
Tl38V0/wXEtnQxvvqik/VWEbwYOadYOkid9bVxmo6SQ4Yn974jNv762KzlwL
QS6wxj+2hUHY/OrY8XGCJepWs0zHIOO1TOKzQTB3ffG3RzuDDsUqHRZQPOaz
YV/Mmzp0cWV2FP2jqIeNtzk90umnE8WZkuBw/RsGfqKYzXY3iio7dVHcWwaz
ZxMXEwIppouW7G90MYhycZvfDKIYESTwmOKtNY7OGYIp7khwCThqZBDnmmrz
lFK03g+RS7oZNPdmTtqiKKZI8h809TAQXvSd0EZTlIXdahCbGKS5T4/LYyi6
n6zWX+PNXcoZ0cdTHK1tHYnuZXDZK2/g5imKSZ7L7lYz/+/H/X0HUiiGhgsD
8B2Dnfnsw/QZii4K1/CXvK97t1oepVNcKvSTcxYGw30F5rgsikNPwtIKeAdc
lZrWlBR13UfyvvIuL01sHsimKK043ej9nsE/6IYO/Q==
                "]], 
               LineBox[{{3.8012755102040816`, 0.9926144756277694}, {
                3.8070691712239952`, 0.9926144756277694}, {
                3.8123410159841984`, 0.9926144756277694}, {
                3.8228847055046042`, 0.9926144756277694}, {
                3.8334283950250096`, 0.9926144756277694}, {3.872782814308162, 
                0.9926144756277694}, {3.912137233591315, 
                0.9926144756277694}, {3.956068575979331, 
                0.9926144756277694}, {3.999999918367347, 
                0.9926144756277694}}]},
              
              Annotation[#, 
               
               "Charting`Private`Tag$317447#2"]& ], {}}, {{}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{0, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Munc13-1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{{0., 3.999999918367347}, {0., 0.9951377627096218}},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAApPfnWmXDyT97d8qBIClPPzKsEQYc
CMo/1S/Pde6YZD/JLsVgzTDKP/dhWOeTLmw/YLF4u35Zyj8NynCsHOJxP422
33Dhqso/F/z5HcJ3eT/owK3bpk3LPyIwhoCGUYQ/ntVJsTGTzD8oSsyxaL6R
Pwv/gVxHHs8/LVdvytl0oD+YaVdeLEbPPxqUkrvS66A/JNQsYBFuzz8D0bWs
y2KhPz6p12Pbvc8/20r8jr1Qoj+5qZa1ty7QP4w+iVOhLKQ/7VPsvEvO0D/v
JaPcaOSnP1Wol8tzDdI/s/TW7vdTrz8lUe7ow4vUPx5JnwmLGbc/Gn9HOmeh
1D+Q/hw8Elq3PxCtoIsKt9Q/BrSabpmatz/6CFMuUeLUP+seltOnG7g/0MC3
c9441T+79IydxB25P3owgf745dU/VKB6Mf4huz/ODxQULkDXP4j3VVlxKr8/
wz1tZdFV1z/7rNOL+Gq/P7hrxrZ0a9c/bWJRvn+rvz+jx3hZu5bXP6tmphFH
FsA/eH/dnkjt1z+R0aF2VZfAPyLvpiljmtg/XqeYQHKZwT8XHQB7BrDYPxeC
19m1ucE/DEtZzKnF2D/QXBZz+dnBP/emC2/w8Ng/RBKUpYAawj/s1GTAkwbZ
P/7s0j7EOsI/4gK+ETcc2T+4xxHYB1vCP8xecLR9R9k/K32PCo+bwj/CjMkF
IV3ZP+ZXzqPSu8I/t7oiV8Ry2T+fMg09FtzCP5Vq8rizhNk/7J4wYtT2wj9O
2SAq
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAn8hAen+u2T//mT3dcEfDP4xyh5xR
ydk/d4QqHuiGwz93zjk/mPTZP+f3mF1P7cM/Di615ckI2j/l9eo/GB3EP6SN
MIz7HNo/4fM8IuFMxD/RTCfZXkXaP9rv4OZyrMQ/K8sUcyWW2j/O5yhwlmvF
P9/H76ayN9s/tNe4gt3pxj9HwaUOzXrcP4K32Kdr5sk/F7QR3gEB3z8cdxjy
h9/PP1yM+1TkFt8/7tkZf6gJ0D+iZOXLxizfP094JwWNI9A/LBW5uYtY3z8O
tUIRVlfQP0J2YJUVsN8/kC55Kei+0D82nFemlC/gP5Ah5lkMjtE/YV6mXaje
4D+TB8C6VCzTP4RKG5mZ6eA/9KXNQDlG0z+mNpDUivTgP1JE28YdYNM/7A56
S20K4T8UgfbS5pPTP3a/TTkyNuE/lPos63j70z+MIPUUvI3hP5btmRudytQ/
tuJDzM884j+X03N85WjWP9ZIgfGNR+I/hOirH1GC1j/2rr4WTFLiP3D948K8
m9Y/N3s5Ychn4j9MJ1QJlM7WP7gTL/bAkuI/Ans0lkI01z/YeWwbf53iP+6P
bDmuTdc/+N+pQD2o4j/bpKTcGWfXPzisJIu5veI/tM4UI/GZ1z+5RBogsuji
P2oi9a+f/9c/2qpXRXDz4j9YNy1TCxnYP/oQlWou/uI/Rkxl9nYy2D863Q+1
qhPjPx521TxOZdg/WkNN2mge4z8Miw3guX7YP7Cb30LAKOM/yrJNaDKX2D9+
TSNv
                "]], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAtsqGI6Y94z8cEGI7077YP9rbQm9h
SeM/oLVus47P2D/6QYCUH1TjP24k0xzh3tg/Ow773ptp4z8LApzvhf3YP7ym
8HOUlOM/RL0tlc862T/cDC6ZUp/jPxIskv4hStk//HJrvhCq4z/fmvZndFnZ
Pz0/5giNv+M/fHi/Ohl42T++19udherjP7UzUeBitdk/vwjHx3ZA5D8lqnQr
9i/aP8JqnRtZ7OQ/Bpe7wRwl2z+z6WtrXvbkP3IvWYxnM9s/pGg6u2MA5T/e
x/ZWskHbP4Vm11puFOU/tPgx7Ede2z9IYhGagzzlP2NaqBZzl9s/z1mFGK6M
5T/CHZVryQncP9xIbRUDLeY/f6RuFXbu3D/1Jj0PrW3nP/axIWnPt94/FwJG
qSaP6T+NywEM5uDgP8Ivm9U=
                "]], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T8bUOxccu7gPzb/YLZT
ruw/NHa6H4y04j9MTcCCRbjsP39ZTYRZuuI/Y5sfTzfC7D/KPODoJsDiP5A3
3uca1uw/YAMGssHL4j/pb1sZ4v3sP4uQUUT34uI/nOBVfHBN7T/iquhoYhHj
PwHCSkKN7O0/kN8Wsjhu4z8YEKoOf/btP9vCqRYGdOM/Ll4J23AA7j8lpjx7
03njP1r6x3NUFO4/u2xiRG6F4z+0MkWlGzzuP+b5rdajnOM/ZqM/CKqL7j89
FEX7DsvjP8yENM7GKu8/60hzROUn5D86D8sCkTXvP6KSTO0wLuQ/qJlhN1tA
7z9a3CWWfDTkP4OujqDvVe8/x2/Y5xNB5D862OhyGIHvP6SWPYtCWuQ/qGJ/
p+KL7z9b4BY0jmDkPxbtFdyslu8/Eirw3Nlm5D/xAUNFQazvP4C9oi5xc+Q/
qCudF2rX7z9d5AfSn4zkPxa2M0w04u8/FC7heuuS5D+EQMqA/uzvP8t3uiM3
meQ/fWisD4317z8lTdFCNZ7kP2sRzas=
                "]], 
               Line[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAwcspeDkF8D+0hAjiyqjkPx41kqkT
DPA/Pjnoua2u5D+Lvyje3RbwP/1zfXLyt+Q/QumCsAZC8D/7XtJUBd3kP3ku
zsprR/A/Wvwcsafh5D+wcxnl0EzwP7qZZw1K5uQ/Hv6vGZtX8D961PzFju/k
P/kS3YIvbfA/+EknNxgC5T+wPDdVWJjwP/Y0fBkrJ+U/H5Dr+anu8D/xCibe
UHHlP+v3397VMPI/pm2PQg+G5j+2Z4/CSjbyP5YeYy6/iuY/gNc+pr878j+F
zzYab4/mPxa3nW2pRvI/ZTHe8c6Y5j9Cdlv8fFzyPyT1LKGOq+Y/mvTWGSSI
8j+kfMr/DdHmP2Vkhv2YjfI/lC2e673V5j8w1DXhDZPyP4Tecddt2uY/xrOU
qPed8j9kQBmvzePmP/FyUjfLs/I/IgRoXo325j9I8c1Uct/yP6GLBb0MHOc/
E2F9OOfk8j+RPNmovCDnP97QLBxc6vI/ge2slGwl5z90sIvjRfXyP2FPVGzM
Luc/n29JchkL8z8gE6MbjEHnP2rf+FWOEPM/EMR2BzxG5z80T6g5AxbzP/90
SvPrSuc/yi4HAe0g8z/e1vHKS1TnP5WetuRhJvM/zofFtvtY5z9gDmbI1ivz
P744maKrXec/cmcJu/kt8z8Whu11gV/nP5i+B9E=
                "]], 
               
               Line[{{1.2012755102040815`, 0.7312766678794694}, {
                1.2021994123405053`, 0.7315087664712776}, {1.203531589880046, 
                0.73184343019677}, {1.2061959449591275`, 
                0.7325127576477548}, {1.2115246551172902`, 
                0.7338514125497244}, {1.222182075433616, 
                0.7365287223536636}, {1.2234898928959086`, 
                0.7368572664487291}, {1.224797710358201, 
                0.7371858105437944}, {1.2274133452827862`, 
                0.7378428987339252}, {1.2326446151319568`, 
                0.7391570751141868}, {1.2431071548302977`, 
                0.74178542787471}, {1.2640322342269796`, 
                0.7470421333957566}, {1.3058823930203434`, 
                0.7575555444378496}, {1.3839420330101317`, 
                0.777165340545495}, {1.3987244897959183`, 
                0.7808789236926537}}], 
               
               Line[{{1.4012755102040815`, 0.7815197797109119}, {
                1.547629076117258, 0.8182860726064424}, {1.5489670042909665`, 
                0.8186221809807127}, {1.550304932464675, 
                0.8189582893549832}, {1.5529807888120917`, 
                0.8196305061035238}, {1.5583325015069254`, 
                0.8209749396006052}, {1.5690359268965925`, 
                0.8236638065947679}, {1.5703738550703008`, 
                0.8239999149690382}, {1.5717117832440093`, 
                0.8243360233433086}, {1.5743876395914262`, 
                0.8250082400918494}, {1.5797393522862597`, 
                0.8263526735889307}, {1.5904427776759271`, 
                0.8290415405830934}, {1.5917807058496356`, 
                0.8293776489573639}, {1.5931186340233439`, 
                0.8297137573316341}, {1.5957944903707606`, 
                0.8303859740801748}, {1.597132418544469, 
                0.8307220824544452}, {1.5984703467181776`, 
                0.8310581908287156}, {1.5987244897959185`, 
                0.8311220355240961}}], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAW2XDEdOe+T/ITLTLH53qPyiCgGbG
o/k/2UR3OPie6j8ahNxRQan5P4NUWzADoeo//oeUKDe0+T/VcyMgGaXqP8SP
BNYiyvk/e7Kz/0St6j/frsSL0SH6PxCt9H30zeo/0O0E7DIn+j9h50Dw9c/q
P8AsRUyULPo/sSGNYvfR6j+gqsUMVzf6P1KWJUf61eo/YqbGjdxM+j+Uf1YQ
AN7qP+adyI/nd/o/GFK4ogvu6j/tjMyT/c36PyD3e8ciDus/+2rUmyl6+z8w
QQMRUU7rP1Q2XZEuf/s/HwsEEDBQ6z+sAeaGM4T7Pw7VBA8PUus/Xpj3cT2O
+z/taAYNzVXrP8HFGkhRovs/qpAJCUld6z+HIGH0eMr7PyXgDwFBbOs/E9bt
TMga/D8ZfxzxMIrrP2yhdkLNH/w/CUkd8A+M6z/EbP830iT8P/gSHu/ujes/
dgMRI9wu/D/Xph/trJHrP9kwNPnvQvw/lM4i6SiZ6z+fi3qlF2v8Pw4eKeEg
qOs/K0EH/ma7/D8DvTXREMbrP7CqqyfYwPw/qucFJhjI6z80FFBRScb8P1ES
1nofyus/DAGjVJPH/D8QOs9/msrrP8Zj43M=
                "]], 
               
               Line[{{1.8012755102040816`, 0.8689160023815036}, {
                1.8063815056019226`, 0.869702176713424}, {1.8170104932192683`,
                 0.8713387307225777}, {1.8382684684539596`, 
                0.8746118387408851}, {1.8807844189233422`, 0.8811580547775}, {
                1.9601756422651684`, 0.8933819870586563}, {
                1.9987244897959184`, 0.8993173849766811}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDcI72XAMrsPxMP8AjE
+gBAjHNq1p067T/SvYqHSf0AQKpkxcTCO+0/kmwlBs//AEDIVSCz5zztPxLK
WgPaBAFABDjWjzE/7T8ShcX97w4BQH78QUnFQ+0/EPua8hsjAUBvhRm87Ezt
PwznRdxzSwFAUpfIoTtf7T/MleBa+U0BQHCII5BgYO0/jER72X5QAUCOeX5+
hWHtPwuisNaJVQFAyls0W89j7T8KXRvRn18BQEMgoBRjaO0/CNPwxctzAUA1
qXeHinHtP8iBi0RRdgFAU5rSda9y7T+IMCbD1ngBQHGLLWTUc+0/B45bwOF9
AUCtbeNAHnbtPwZJxrr3hwFAJjJP+rF67T/G92A5fYoBQEQjqujWe+0/hqb7
twKNAUBjFAXX+3ztPwUEMbUNkgFAn/a6s0V/7T/Essszk5QBQLznFaJqgO0/
ubOE3fyWAUCCcRvvgoHtP8EjplM=
                "]], 
               
               Line[{{2.201275510204082, 0.9223075778123243}, {
                2.2025743146728987`, 0.9224128293900242}, {
                2.2039086887592343`, 0.922520963432677}, {2.206577436931906, 
                0.9227372315179827}, {2.21191493327725, 0.9231697676885939}, {
                2.222589925967937, 0.9240348400298166}, {2.2439399113493117`, 
                0.9257649847122619}, {2.2866398821120604`, 
                0.9292252740771524}, {2.3704807786936803`, 
                0.936019512049731}, {2.398724489795918, 0.9383083054939966}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0DLftKtUAjuP7VTRwOU
RARAElGGbBVg7j+IS7iFHEcEQAYiQaPnYO4/XEMpCKVJBED78vvZuWHuPwIz
Cw22TgRA5JRxR15j7j9OEs8W2FgEQLXYXCKnZu4/6NBWKhxtBEBYYDPYOG3u
PxpOZlGklQRAnm/gQ1x67j/tRdfTLJgEQJJAm3oue+4/wD1IVrWaBECHEVax
AHzuP2YtKlvGnwRAb7PLHqV97j+zDO5k6KkEQEH3tvntgO4/hgRf53CsBEA1
yHEwwIHuP1r8z2n5rgRAKpksZ5KC7j8A7LFuCrQEQBI7otQ2hO4/TMt1eCy+
BEDkfo2vf4fuPx/D5vq0wARA2E9I5lGI7j/yuld9PcMEQMwgAx0kie4/xrLI
/8XFBEDB8b1T9onuP5mqOYJOyARAtcJ4isiK7j/s5rcQMMoEQNPaFaNki+4/
A9udvA==
                "]], 
               
               Line[{{2.601275510204082, 0.954670806734363}, {
                2.603990662333868, 0.9547808210021825}, {2.6052275961112112`, 
                0.9548309398748465}, {2.607701463665898, 
                0.9549311776201741}, {2.6126491987752725`, 
                0.9551316531108295}, {2.613861772475368, 
                0.9551807849463276}, {2.6150743461754633`, 
                0.9552299167818258}, {2.6174994935756546`, 
                0.9553281804528222}, {2.6223497883760363`, 
                0.955524707794815}, {2.6320503779767996`, 
                0.9559177624788006}, {2.6514515571783264`, 
                0.9567038718467716}, {2.6902539155813803`, 
                0.9582760905827139}, {2.774462852749733, 
                0.9616881220725175}, {2.798724489795918, 
                0.9626711705751992}}], 
               
               Line[{{2.8012755102040816`, 0.9627848708365031}, {
                2.9382035922548035`, 0.969442638197154}, {2.998724489795918, 
                0.9723853074455064}}], 
               Line[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ/fCpyJ45TBwOASf0bbfJvbcXvrd1EdMRDge3s3s6
+Oze2/fx1NZuP8bhUPGX7UodkM9l7RKRc5LDYZVuoPx7IJ9pxiXea+c4HPj6
nm49b//e/lPg+4qVNzkcrvrxPZ7g+N7+wlEN/4D3HA6pF+JthV3f2/esnf17
rhSnQ8tlpk/iPu/tOe4kXQuS5XTYxuxr2wHkt3BpbWRX4HR4YTy94weQX52+
I61QldPBZ4q2/E3f9/ZZilcvuhhwOgiHhvjM8n9v7zGVb8VrV06HxdeWLpMJ
fm/PWtsYYlnI6XDopke0YtR7+y0f3/zcX8zpwC0XptkF5KekRcx3K+N0CElK
/v4JyD/ir/8quJrT4fmr2slHooH2K92tz2vldOD5s+l0eux7e5PpHqpf2zkd
whwOzLwA5D/h3nKquovTYX7L2XTLuPf2Ll+7RDv7OR2MeF8wc8e/t/+S+W0X
/yROh+rArxeLgfwl9xITpk3hdDgylWnBHSB/5+aWu3+mcTqEll00d0h4bw8A
cd+wVA==
                "]], 
               Line[CompressedData["
1:eJwVzFtIk3EYx/Ephbz/twPTrJHMWmZ4WDaJ6iZ8HskSkjIFlcDNXOzC2BwK
ppWH1kSNMpqYFy+SpbYUNxUXqctGDefZmANdGWooitDhsWGF5EVvFz++fG5+
Cq0xUxcskUiixP3vnarurNPNHNqs5Tkp+QTDwhq62ji86Lo3uaUlMBsa5z7a
Oazkph0pOoLgsI2gPW4O11ryq+cLCCSdmp7lUIZ1W46RxHKCkW/+wpZwhmlz
BaNe0Q9VGQm5Moa7HYfGjBUEBwbO2WflDC36B+P2SoKE0ZiusRiGwpJ2KtZE
kLsasHYnMbR5pD5FDcGgovbp7RsMvRbjgvQxQaVOojljYNhQGL3YKzql85Z8
08gwK+3zYrqFwKvSNxtKGH7akfqlvoFgHTKEa3cZLpdGrnBPCPZrIpouNDHc
VE+vBwkExUJPfaiboSwufvNnG0H/tlDrHmY44ZTsfdROsK2pMRWPMqxIm4uN
e0FQG6Uu8U2Jf3pTntZK0Gxj6gY/w64e/4Svg8Dj0ilDvzNMOlX93GEnYIqM
Y25iuOG5OpTeTXDFfPZwcYBha/YJ/1fR86lh+3x/GIaUze862kvww/vuryWY
R69TVdbYRyBbiZiUyni8jguXS/oJ1OdDPO8P8hg+01cgHSBofRlwFcl5HMuv
q7aLVurH+2aO8Kg0n3SuDhIUfXhlM0XzuBTGzZqcBK9Vz6yJMTxa2hdJ/oYg
+ddNwXKcx9+e+9HZQwQ1OdrGZBWPHdl5GBCdeSmytEl01XS8eedbgn+L0Au1

                "]], 
               Line[CompressedData["
1:eJwVz30s1HEcB/CjPMz3W9fFhOXh7GaebrOZiiu/TzWFjYZql4eGKDTc6Uk6
1HmcavOQ0zgjmYdG6NqkudOVzlMoDyUa1koe4jcPNbG1Pv3x2Xuv7b299+FH
JwfH6nM4HGe8/2lm6csOexDoWK5cfqZmmbMZAnnQIQITU/kdPeiKWa5MT0Rg
bUBuOI2ePbZ9re0IAdIpC9lAJxiNxPOOE/BWSpbtNCzTEq++oPUhIL6X4HUQ
vTHQECH1JSCVxeQFoDMLM4M+BBCoDRfz09APLIWeRWICJtZwZhStdsk35iUR
+FjJVed0scyBsX2DxRICYZuKgnJ0q6y+yOwKgZlgG3ELumZQZ2WRSmDeSLg+
gc5PNhDayglsSf2dXF+xTLBKHiRUELA9kVM6gv7hlV7upyEQt7KVaPuaZXj+
Ka7y3RS2vOdsOrpZplrLJV48Couhkc3DaDfP5oVVUwpT1ydFc+hAx/m6KEsK
nU+HxKZvWabA8Dz/qIBCpk17cSJ65xs/c44XBYO/eYb2Opb5LeJzMmIp8NRO
KwU9LJOj0kx7xFHQ+/xY9ght5hKuXk6gsLZhTV6g3a3K0iIkFMZc9zp+R0s2
6a/DtyiUKbeimF6WWXi+ubBdSGG/bGB8HZ3qquhVlVDY9dAnxqSPZYxr3esv
Kyj8VXWt2aEdSpJipioozCypuIHoaOm36Zd1FGrClH4N6NX5O+qURgolN8wn
NOjbkbZK5yYK2SWFF8fRVadCz5W3UYgdyM7S72eZL8L3ozc7KTiKEtXh6Kol
XvqOLuxrr76ToqMbQxzua3HvpGwqF+1wqXTYvJuCaChrsQK9IPiUWq3Df07f
/dOKbvpqYe/cR2F9sthYh/45177HrZ8C/4kgdwj9DwlNRBw=
                "]], 
               
               Line[{{3.601275510204082, 0.9935170178282009}, {
                3.6068988062055514`, 0.9935170178282009}, {3.611855327502106, 
                0.9935170178282009}, {3.621768370095216, 
                0.9935170178282009}, {3.6316814126883257`, 
                0.9935170178282009}, {3.651507497874545, 
                0.9935170178282009}, {3.6713335830607647`, 
                0.9935170178282009}, {3.7102062309612647`, 
                0.9935170178282009}, {3.749078878861765, 
                0.9935170178282009}, {3.7701662579025763`, 
                0.9935170178282009}, {3.791253636943387, 
                0.9935170178282009}, {3.7938895593234885`, 
                0.9935170178282009}, {3.79652548170359, 0.9935170178282009}, {
                3.7978434428936403`, 0.9935170178282009}, {3.798724489795918, 
                0.9935170178282009}}], 
               Line[CompressedData["
1:eJwVz30s1HEcB/ALTdN8v0XZLAnJU6G0a9pVv8+asBzjhtukEWnc2NV6IDSP
p7o8bVTkaXaYVZSHG9n1pJblHOMIm3EjpOHbLQ/z3Kc/Pvvs9cf7/dnHNkoq
ijHg8XiOOP+3jzDFzjCOgLvHZ91aN+PkNgJlVzyBJrdte0s146bUm83JUgLT
W5tyd3SxXXqj7g4BYfl6aDh6tS+n9nUaAcvR5UUlOjDFVxGRScC/fim4B13v
YFJtJiOQnvi3YxId9iCvPElOYPagPof2ME7lUlzk9ZSAUjRvHYdOl1VnjL0k
ENgzGWClYZxpovHlaw0EFndL+afQL2ITzGbeEMjjNg55o1v8zipYK4HuZvM5
KXpmf/9Xg48EvEq9sr6g/Sp5e5y1BDxv1LVJehln0RaRf3eDgA1PYvOuj3EN
vw6XESEFdlqvDxlg3KMKWeR4AIVz4Z3eCejrooVjjUEUHmcXlWWjrVSqt/5i
CkeH+Jda0PKCK99yoyiE3ksu2adlXOyZUr3JfQrv2w05Ndou+4CvcR0F+XmL
XBhi3LZnqulwPYXhmFmdGD26MDVQ9wr78tv5UnShuOWqdxPmx8MmKtA7LqLb
MhWFP2lVHhvosf6CSkMtBXGn06jyB+Pac1ajtUMUan6vuWrQxYIIZ8UIBb2Z
OvMn2q/WrfXiON6PTjhhPsy4jiTN94w5Ch+MmtNuop+58guC5imYuGYNPkTf
miwPtmXYHxLsXIV2EsZPfFrCvtqVAQ3aaNdgTeEqhQu9XY7TaJ1SIIlcp/Bk
pSR1E62SKNxPbuF/1pJ+8xHGPT+yd3lnh4K9j8DhOPof/II6ZA==
                "]]}, "Charting`Private`Tag$317447#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7ZX64uKBl6V2DFDA4ixVcF8yxB7GN54/Y85myRQ4
3/vs9U1zJUvg/PCU73snSbbA+Xf12517JafA+QtE/du6JJfA+Y0cm9U7JbfA
+RGRC9d/+HgEzn9/O4RrkdRROL8tjiM12BnB35ycL7VtCoLPl2fbWm1+DM4/
2nQziq32OJwfw9q7dftSBP9Tu4NA5jkEX6F3+dHT8ifg/JrppQYTDyH4wlKa
3U6vEfxVc+48/Sx8Es6/vtB5dlgqgj/B2vvG2XwEHwBneVTQ
                "]], 
               Line[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAApPfnWmXDyT9VAYiIVN4+PzKsEQYc
CMo/msY7h31nVD/JLsVgzTDKP/NWilLu6ls/YLF4u35Zyj+mc+yOL7dhP422
33Dhqso/5wM7WqA6aT/owK3bpk3LP0ASbPjAIHQ/ntVJsTGTzD9tmYRH0ZOB
Pwv/gVxHHs8/Bt0Qb1lNkD+YaVdeLEbPP+TXlsw0w5A/JNQsYBFuzz/A0hwq
EDmRPz6p12Pbvc8/fMgo5cYkkj+5qZa1ty7QP/WzQFs0/JM/7VPsvEvO0D/m
inBHD6uXP1Wol8tzDdI/yTjQH8UInz8lUe7ow4vUP0fKR2gY4qY/Gn9HOmeh
1D880sG2BCKnPxCtoIsKt9Q/M9o7BfFhpz/6CFMuUeLUPx3qL6LJ4ac/0MC3
c9441T/1CRjceuGoP3owgf745dU/oEnoT93gqj9vXtpPnPvVP5VRYp7JIKs/
ZIwzoT8R1j+KWdzstWCrP0/o5UOGPNY/dmnQiY7gqz8koEqJE5PWP0yJuMM/
4Kw/zg8UFC5A1z/3yIg3ot+uP8M9bWXRVdc/7NACho4frz+4a8a2dGvXP+DY
fNR6X68/o8d4WbuW1z/N6HBxU9+vP3h/3Z5I7dc/UYSsVYJvsD9trTbw6wLY
P0yI6Xx4j7A/YtuPQY8Y2D9GjCakbq+wP003QuTVQ9g/PJSg8lrvsD8i76Yp
Y5rYPyeklI8zb7E/Fx0Aewaw2D8hqNG2KY+xPwxLWcypxdg/G6wO3h+vsT/3
pgtv8PDYPxK0iCwM77E/7NRkwJMG2T8MuMVTAg+yP+ICvhE3HNk/CLwCe/gu
sj/MXnC0fUfZP/zDfMnkbrI/wozJBSFd2T/4x7nw2o6yP7e6IlfEctk/88v2
F9Gusj+VavK4s4TZP2pf5AtPybI/8TlVqA==
                "]], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAn8hAen+u2T/WQfwQC06zP4xyh5xR
ydk/ffRyqsfQsz93zjk/mPTZP/ZBn+C5o7Q/Di615ckI2j8bhicPKQa1P6SN
MIz7HNo/O8qvPZhotT/RTCfZXkXaP4FSwJp2LbY/K8sUcyWW2j8MY+FUM7e3
P9/H76ayN9s/I4QjyazKuj9HwaUOzXrcPyjj09jPeMA/F7QR3gEB3z9VJVjB
wp/GP1yM+1TkFt8/FbD5NRnVxj+iZOXLxizfP9c6m6pvCsc/LBW5uYtY3z9W
UN6THHXHP0J2YJUVsN8/WntkZnZKyD82nFemlC/gP1zRcAsq9ck/YV6mXaje
4D9kfYlVkUrNP4RKG5mZ6eA/Jggryud/zT+mNpDUivTgP+SSzD4+tc0/7A56
S20K4T9oqA8o6x/OP3a/TTkyNuE/ZtOV+kT1zj+MIPUUvI3hP7YU0U/8T9A/
tuJDzM884j+4at30r/rRP9ZIgfGNR+I/xhumrN4U0j/2rr4WTFLiP9TMbmQN
L9I/N3s5Ychn4j/zLgDUamPSP7gTL/bAkuI/LvMisyXM0j+5RBogsujiP6F7
aHGbndM/sJvfQsAo4z/3boRbuTnUP3dN5OI=
                "]], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z9hypMttmXUP9wMLplS
n+M/loWfOtcS1T/8cmu+EKrjP3Jj1O7hJdU/PT/mCI2/4z8rHz5X90vVP77X
252F6uM/m5YRKCKY1T+/CMfHdkDkP3uFuMl3MNY/wmqdG1ns5D87YwYNI2HX
P/UmPQ+tbec/NXZWQujR2z8+4kLHinjnP6o5fO0q5ds/hp1If2iD5z8e/aGY
bfjbPxYUVO8jmec/BoTt7vIe3D82AWvPmsTnP9aRhJv9a9w/eNuYj4gb6D94
rbL0EgbdP/yP9A9kyeg/vuQOpz063j9ES/rHQdToPzKoNFKATd4/jAYAgB/f
6D+ma1r9wmDePx19C/Da9Og/kPKlU0iH3j8+aiLQUSDpP2AAPQBT1N4/hiUo
iC8r6T/Uw2KrlefeP87gLUANNuk/SIeIVtj63j9eVzmwyEvpPzAO1KxdId8/
f0RQkD936T8CHGtZaG7fP8j/VUgdguk/eN+QBKuB3z8Qu1sA+4zpP+uitq/t
lN8/FwJGqSaP6T8GspebxpjfP5Luypc=
                "]], 
               Line[CompressedData["
1:eJwBcQKO/SFib1JlAgAAACYAAAACAAAAHTHtiQyk6T/qiS1nLrffP+jsbCiU
rek/oueMJwXC3z8wqHLgcbjpPy5nCQBhzt8/wB5+UC3O6T9HZgKxGOffPwja
gwgL2ek/1OV+iXTz3z9QlYnA6OPpP2Bl+2HQ/98/4QuVMKT56T89MnoJRAzg
PwL5qxAbJeo/VzFzuvsk4D8bzULzPy/qPxn39YnAKuA/NKHZ1WQ56j/bvHhZ
hTDgP2VJB5uuTeo/Xkh++A484D/ImWIlQnbqP2RfiTYiU+A/jzoZOmnH6j9z
jZ+ySIHgPxx8hmO3aes/junLqpXd4D82/2C2U67sP8ahJJsvluE/TE3AgkW4
7D/JYkNd15vhP2ObH083wuw/ziNiH3+h4T+QN97nGtbsP9aln6POrOE/6W9b
GeL97D/mqRqsbcPhP5zgVXxwTe0/BrIQvavw4T8BwkpCjeztP0bC/N4nS+I/
GBCqDn/27T9Kgxuhz1DiPy5eCdtwAO4/TkQ6Y3dW4j9a+sdzVBTuP1bGd+fG
YeI/tDJFpRs87j9myvLvZXjiP2ajPwiqi+4/htLoAKSl4j/MhDTOxirvP8bi
1CIgAOM/Og/LApE17z+aiT72QgbjP6iZYTdbQO8/bzCoyWUM4z+Dro6g71Xv
Pxd+e3CrGOM/OtjochiB7z9oGSK+NjHjP6hif6fii+8/PMCLkVk34z8W7RXc
rJbvPxBn9WR8PeM/8QFDRUGs7z+4tMgLwknjP6grnRdq1+8/CVBvWU1i4z8W
tjNMNOLvP9322CxwaOM/hEDKgP7s7z+xnUIAk27jP31orA+N9e8/vhZJvXBz
4z8cRzPd
                "]], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAwcspeDkF8D9DiTH5KX3jPx41kqkT
DPA/HA0roB+C4z+Lvyje3RbwPynKyNvuieM/wgR0+EIc8D+wqJd51o3jP/hJ
vxKoIfA/NodmF76R4z9m1FVHcizwP0VEBFONmeM/QumCsAZC8D9hvj/KK6nj
P3kuzsprR/A/6JwOaBOt4z+wcxnl0EzwP2973QX7sOM/Hv6vGZtX8D99OHtB
yrjjP/kS3YIvbfA/mbK2uGjI4z+wPDdVWJjwP9GmLael5+M/H5Dr+anu8D9C
jxuEHybkP+v3397VMPI/dWqLCE4P5T+2Z4/CSjbyPyC8bxNBE+U/gNc+pr87
8j/LDVQeNBflPxa3nW2pRvI/IrEcNBof5T9Cdlv8fFzyP9D3rV/mLuU/mvTW
GSSI8j8shdC2fk7lP0jxzVRy3/I/458VZa+N5T9yZwm7+S3zP353dNyFxuU/
L8SrYQ==
                "]], 
               
               Line[{{1.2012755102040815`, 0.6813033189642178}, {
                1.2234898928959086`, 0.6875377838260304}, {1.224797710358201, 
                0.6879048227002336}, {1.2274133452827862`, 
                0.6886389004486401}, {1.2326446151319568`, 
                0.6901070559454531}, {1.2431071548302977`, 
                0.693043366939079}, {1.2640322342269796`, 
                0.698915988926331}, {1.3058823930203434`, 
                0.7106612329008348}, {1.3839420330101317`, 
                0.7325686650988552}, {1.3987244897959183`, 
                0.7367173605040243}}], 
               Line[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAJzKQ3p9r9j9qZYJDhJnnP4IILFOG
ifc/BVB/p1RT6D8O0KzBo5P3P6JP95fnWeg/Jl+unt6n9z/aTud4DWfoP1Z9
sVhU0Pc/TE3HOlmB6D+1ubfMPyH4Py9Kh77wteg/eh34g04m+D/8ScM2Orno
P0CBODtdK/g/ykn/roO86D/MSLmpejX4P2dJd58Ww+g/5Ne6hrVJ+D+gSGeA
PNDoPxT2vUArcvg/EUdHQojq6D90MsS0FsP4P/RDB8YfH+k/ZjQgoJHI+D/x
fUmRryLpP1g2fIsMzvg/7beLXD8m6T87OjRiAtn4P+QrEPNeLek/AkKkD+7u
+D/VExkgnjvpP49RhGrFGvk/tOMqehxY6T+AU+BVQCD5P7AdbUWsW+k/clU8
Qbsl+T+sV68QPF/pP1ZZ9BexMPk/pMszp1tm6T8cYWTFnEb5P5SzPNSadOk/
qnBEIHRy+T90g04uGZHpP5xyoAvvd/k/cL2Q+aiU6T+NdPz2aX35P2z30sQ4
mOk/cHi0zV+I+T9ka1dbWJ/pP2J6ELnajfk/YKWZJuii6T9UfGykVZP5P1zf
2/F3puk/2c1vIWCU+T8nlHokJafpP5Xw5EA=
                "]], 
               Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAW2XDEdOe+T90XWpFKazpPyiCgGbG
o/k/nqAaY7Kt6T8ahNxRQan5P78NwI9lr+k//oeUKDe0+T8C6Arpy7LpP8SP
BNYiyvk/hZygm5i56T+2kWDBnc/5P6YJRshLu+k/qJO8rBjV+T/Iduv0/rzp
P4uXdIMO4Pk/CVE2TmXA6T9Sn+Qw+vX5P40FzAAyx+k/367Ei9Eh+j+Vbvdl
y9TpP9DtBOwyJ/o/JsM7pnbW6T/ALEVMlCz6P7YXgOYh2Ok/oKrFDFc3+j/W
wAhneNvpP2Kmxo3cTPo/FhMaaCXi6T/mnciP53f6P5i3PGp/7+k/7YzMk/3N
+j+aAIJuMwrqP/tq1Jspevs/oJIMd5s/6j8rQQf+Zrv8P7aqcNhAo+o/DAGj
VJPH/D8f6D2CB6fqP3dXpWQ=
                "]], 
               
               Line[{{1.8012755102040816`, 0.833284975733277}, {
                1.9601756422651684`, 0.8579297524931205}, {
                1.9987244897959184`, 0.8639085250052753}}], 
               
               Line[{{2.001275510204082, 0.8642759171615468}, {
                2.122444219423309, 0.8803840173531724}, {2.1987244897959184`, 
                0.8905246736804026}}], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAe3+uVTacAUCpMWxMzYHsP2s0u9kJ
SwJA9ZgpDHDU7D/A0NWsuE0CQAZS/LC01ew/FW3wf2dQAkAYC89V+dbsP7+l
JSbFVQJAOn10n4LZ7D8TF5BygGACQH5hvzKV3uw/u/lkC/d1AkAHKlVZuujs
Pwu/Dj3koAJAGbuApgT97D9gWykQk6MCQCp0U0tJ/uw/tfdD40GmAkA7LSbw
jf/sP18weYmfqwJAXZ/LORcC7T+zoePVWrYCQKKDFs0pB+0/W4S4btHLAkAr
TKzzThHtP6tJYqC+9gJAPN3XQJkl7T80LCE+P/kCQBHQPQ7IJu0/vg7g27/7
AkDlwqPb9iftP9DTXRfBAANAjqhvdlQq7T/0XVmOwwoDQN9zB6wPL+0/fUAY
LEQNA0CzZm15PjDtPwYj18nEDwNAh1nTRm0x7T8Z6FQFxhQDQDA/n+HKM+0/
PnJQfMgeA0CCCjcXhjjtP8dUDxpJIQNAVv2c5LQ57T9QN863ySMDQCrwArLj
Ou0/YvxL88ooA0DT1c5MQT3tP+veCpFLKwNAp8g0GnA+7T90wckuzC0DQHu7
mueeP+0//qOIzEwwA0BQrgC1zUDtP1JNHneWMANA1vz0hvBA7T80V9JE
                "]], 
               
               Line[{{2.4012755102040817`, 0.9144221203991195}, {
                2.4046933744994785`, 0.9146745475996658}, {2.409580888186021, 
                0.9150355161141815}, {2.4108027666076564`, 
                0.9151257582428104}, {2.412024645029292, 
                0.9152160003714394}, {2.414468401872563, 
                0.9153964846286972}, {2.419355915559106, 
                0.9157574531432129}, {2.429130942932191, 
                0.9164793901722443}, {2.4486809976783612`, 
                0.9179232642303071}, {2.450006067043157, 0.918021127551193}, {
                2.4513311364079526`, 0.918118990872079}, {2.453981275137544, 
                0.9183147175138509}, {2.459281552596727, 
                0.9187061707973947}, {2.4698821075150925`, 
                0.9194890773644823}, {2.491083217351824, 
                0.9210548904986574}, {2.5334854370252864`, 
                0.9241865167670076}, {2.5987244897959183`, 
                0.9290047629095949}}], 
               
               Line[{{2.601275510204082, 0.9291931691435804}, {
                2.6902539155813803`, 0.9357646909587428}, {2.774462852749733, 
                0.9419839625369077}, {2.798724489795918, 
                0.9437758116540558}}], 
               
               Line[{{2.8012755102040816`, 0.943954797576342}, {
                2.9382035922548035`, 0.9530563687613974}, {2.998724489795918, 
                0.9570791758357698}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAA4eUUvJwCCEDHjlLe26HuPxPetaIC
xAhAM+SyIf7a7j+ODH19t8YIQAY5v9DK2+4/CjtEWGzJCEDYjct/l9zuPwKY
0g3WzghAfTfk3TDe7j/yUe94qdkIQMiKFZpj4e4/0MUoT1DvCEBcMXgSyefu
P4ytm/udGglAhH49A5T07j8I3GLWUh0JQFbTSbJg9e4/hAoqsQcgCUApKFZh
LfbuP3tnuGZxJQlAztFuv8b37j9qIdXRRDAJQBgloHv5+u4/SJUOqOtFCUCs
ywL0XgHvPwV9gVQ5cQlA1BjI5CkO7z+08ez5v3MJQMBxMO3oDu8/ZGZYn0Z2
CUCtypj1pw/vP8RPL+pTewlAhnxpBiYR7z+EIt1/boUJQDjgCigiFO8/NJdI
JfWHCUAlOXMw4RTvP+QLtMp7iglAEZLbOKAV7z9E9YoViY8JQOpDrEkeF+8/
9Gn2ug+SCUDXnBRS3RfvP6TeYWCWlAlAw/V8WpwY7z+5s4Td/JYJQMMN6OJR
Ge8/USm25Q==
                "]], 
               
               Line[{{3.201275510204082, 0.9719821089440207}, {
                3.2049527235388684`, 0.9721178996875505}, {3.209886242298752, 
                0.9723000828027604}, {3.21975327981852, 0.9726644490331802}, {
                3.2209866595084913`, 0.9727099948119826}, {
                3.2222200391984623`, 0.9727555405907851}, {
                3.2246867985784045`, 0.9728466321483901}, {
                3.2296203173382887`, 0.9730288152636}, {3.2394873548580567`, 
                0.9733931814940198}, {3.2592214298975932`, 
                0.9741219139548594}, {3.2605580005307244`, 
                0.9741712703297903}, {3.2618945711638556`, 
                0.9742206267047213}, {3.2645677124301176`, 
                0.9743193394545833}, {3.269913994962642, 
                0.9745167649543073}, {3.2806065600276906`, 
                0.9749116159537551}, {3.3019916901577884`, 
                0.9757013179526509}, {3.3447619504179835`, 
                0.9772807219504425}, {3.398724489795918, 
                0.9792734301992584}}], 
               
               Line[{{3.4012755102040817`, 0.9793582130045518}, {
                3.507084223974069, 0.9824840243419222}, {3.5084114898856598`, 
                0.9825232345608761}, {3.509738755797251, 0.98256244477983}, {
                3.5123932876204327`, 0.982640865217738}, {3.517702351266796, 
                0.9827977060935537}, {3.5283204785595235`, 
                0.9831113878451853}, {3.5495567331449775`, 
                0.9837387513484482}, {3.5508839990565684`, 
                0.9837779615674022}, {3.552211264968159, 
                0.9838171717863562}, {3.5548657967913413`, 
                0.983895592224264}, {3.560174860437705, 0.9840524331000798}, {
                3.570792987730432, 0.9843661148517113}, {3.5920292423158866`, 
                0.9849934783549744}, {3.593268372640025, 
                0.9850300848638116}, {3.5945075029641638`, 
                0.9850666913726487}, {3.5969857636124414`, 
                0.9851399043903231}, {3.5987244897959183`, 
                0.985191270008742}}], 
               Line[CompressedData["
1:eJwV0H0s1HEcB/DbyUPn9/2eozCxpBKzhF1XNnw+msTNapToPO1OUktddG1l
eWhSMrWMdtYDW1sJ23WOZI5zXQ+YNWYoZ2XZMQ37iv7QiH798d57r//ee+9S
qZNyhAKBYC+f/60z/Ki4MMRhR7/zC+VdBkVa5RXrGIeRc+XS5AoGW9xmLItW
Dnuql32332MgES3kbpvh0GQb/FNbySB21nFdRwhaQkIzah8y0NfDHlsmwf7+
td01TxmsFK44KpUEtdVw6BdvWUrj/LdsgjmKMvmJZwyMYnHbl/MEhQuifOd6
Bp9Kv0cPFhCMEHuZyhoYTKqKsgx3COqTD6dqnjNw2Gd8XKojWDetqUp+xSDe
Tl38V0/wXEtnQxvvqik/VWEbwYOadYOkid9bVxmo6SQ4Yn974jNv762KzlwL
QS6wxj+2hUHY/OrY8XGCJepWs0zHIOO1TOKzQTB3ffG3RzuDDsUqHRZQPOaz
YV/Mmzp0cWV2FP2jqIeNtzk90umnE8WZkuBw/RsGfqKYzXY3iio7dVHcWwaz
ZxMXEwIppouW7G90MYhycZvfDKIYESTwmOKtNY7OGYIp7khwCThqZBDnmmrz
lFK03g+RS7oZNPdmTtqiKKZI8h809TAQXvSd0EZTlIXdahCbGKS5T4/LYyi6
n6zWX+PNXcoZ0cdTHK1tHYnuZXDZK2/g5imKSZ7L7lYz/+/H/X0HUiiGhgsD
8B2Dnfnsw/QZii4K1/CXvK97t1oepVNcKvSTcxYGw30F5rgsikNPwtIKeAdc
lZrWlBR13UfyvvIuL01sHsimKK043ej9nsE/6IYO/Q==
                "]], 
               
               Line[{{3.8012755102040816`, 0.9926144756277694}, {
                3.8070691712239952`, 0.9926144756277694}, {
                3.8123410159841984`, 0.9926144756277694}, {
                3.8228847055046042`, 0.9926144756277694}, {
                3.8334283950250096`, 0.9926144756277694}, {3.872782814308162, 
                0.9926144756277694}, {3.912137233591315, 
                0.9926144756277694}, {3.956068575979331, 
                0.9926144756277694}, {3.999999918367347, 
                0.9926144756277694}}]}, 
              "Charting`Private`Tag$317447#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {0, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Munc13-1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, 
           PlotRange -> {{0., 3.999999918367347}, {0., 0.9951377627096218}}, 
           PlotRangeClipping -> True, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {192., -189.}, {Center, Center}, {360., 360.}], 
    InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT4FvXqHBY5aPwRDGnDf
GVQ/0Y37xV3cYD8zn5icsxlkPx+9Oci4cWQ/S83Xsp0ZdD+8G7bMbpxrP1dk
972SGYQ/fGzXau34dD/dL4dDjRmUP9sU6Lksp4E/oBVPhooZpD8W0uDCmPyP
P4EIsyeJGbQ/RSZparhTnj8qR5GIsnC0Px6/2AEJ0J4/0oVv6dvHtD/3V0iZ
WUyfPyQDLKsudrU/1cQTZH0ioD/G/aQu1NK2P4f28pIeG6E/DPOWNR+MuT/t
WbHwYAyjP5jdekO1/r4/uCAurOXupj9BHFmk3lW/PyXt5fcNLac/6lo3BQit
vz+SuZ1DNmunPx7seWOtLcA/bFIN24bnpz9vaTYlANzAPx6E7Ako4Kg/EmSv
qKU4wj+E56pnatGqP1hZoa/w8cQ/T64nI++zrj/v21QKohrFPzMhxPP47a4/
hl4IZVNDxT8XlGDEAiivP7Njbxq2lMU/3XmZZRacrz8Obj2FezfGP7aiBdQe
QrA/xYLZWgZ9xz9EbncWRiqxP1wFjbW3pcc/tqfF/kpHsT/yh0AQac7HPyjh
E+dPZLE/II2nxcsfyD8LVLC3WZ6xP7cPWyB9SMg/fY3+n167sT9Okg57LnHI
P+/GTIhj2LE/fJd1MJHCyD/TOelYbRKyPxMaKYtC68g/RXM3QXIvsj+qnNzl
8xPJP7eshSl3TLI/QB+QQKU8yT8o5tMRfGmyP9ehQ5tWZck/mh8i+oCGsj+Q
O0vYzW/JP7K7+p33jbI/3O4Weg==
                "]], 
               LineBox[{{0.20127551020408163`, 0.07388449707273509}, {
                0.2033724813112215, 0.07544787909750711}, {
                0.20461432671651483`, 0.07637372818411155}, {
                0.20585617212180818`, 0.07729957727071599}, {
                0.20833986293239484`, 0.07915127544392483}, {
                0.2133072445535682, 0.08285467179034257}, {0.2232420077959149,
                 0.09026146448317805}, {0.24311153428060836`, 
                0.10507504986884902`}, {0.2443290196086536, 
                0.10598273747160561`}, {0.24554650493669883`, 
                0.10689042507436217`}, {0.24798147559278932`, 
                0.10870580027987534`}, {0.2528514169049703, 
                0.11233655069090169`}, {0.2625912995293323, 
                0.11959805151295438`}, {0.28207106477805627`, 
                0.13412105315705977`}, {0.3210305952755042, 
                0.16316705644527058`}, {0.3987244897959184, 
                0.22109119174412067`}}], 
               LineBox[{{0.40127551020408164`, 0.22312746006019912`}, {
                0.48443648039284554`, 0.2938884152451279}, {
                0.5699233045152912, 0.36662841956325426`}, {
                0.5987244897959183, 0.3911351007177587}}], 
               LineBox[{{0.6012755102040817, 0.39305766877253334`}, {
                0.732138185275487, 0.4789561832035206}, {0.7987244897959184, 
                0.5226635629940792}}], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T+5goKDncbgPzb/YLZT
ruw/0qhQRreM4j9MTcCCRbjsPx2M46qEkuI/Y5sfTzfC7D9ob3YPUpjiP5A3
3uca1uw//jWc2Oyj4j/pb1sZ4v3sPynD52oiu+I/nOBVfHBN7T+A3X6Pjeni
PwHCSkKN7O0/LhKt2GNG4z8YEKoOf/btP3n1Pz0xTOM/Ll4J23AA7j/D2NKh
/lHjP1r6x3NUFO4/WZ/4apld4z+0MkWlGzzuP4QsRP3OdOM/ZqM/CKqL7j/b
RtshOqPjP8yENM7GKu8/iXsJaxAA5D86D8sCkTXvP0DF4hNcBuQ/qJlhN1tA
7z/4Dry8pwzkP4OujqDvVe8/ZaJuDj8Z5D862OhyGIHvP0LJ07FtMuQ/qGJ/
p+KL7z/5Eq1auTjkPxbtFdyslu8/sFyGAwU/5D/xAUNFQazvPx7wOFWcS+Q/
qCudF2rX7z/7Fp74ymTkPxa2M0w04u8/smB3oRZr5D+EQMqA/uzvP2mqUEpi
ceQ/fWisD4317z/Df2dpYHbkP6eDzMo=
                "]], 
               LineBox[{{1.0012755102040816`, 0.6406906360599344}, {
                1.0029484390136711`, 0.6413413701187699}, {
                1.0055826833813366`, 0.6423660356750741}, {
                1.0068998055651694`, 0.6428783684532263}, {1.008216927749002, 
                0.6433907012313783}, {1.0108511721166678`, 
                0.6444153667876826}, {1.0161196608519991`, 
                0.6464646979002913}, {1.017436783035832, 
                0.6469770306784435}, {1.0187539052196648`, 
                0.6474893634565956}, {1.0213881495873305`, 
                0.6485140290128999}, {1.0266566383226616`, 
                0.6505633601255085}, {1.0371936157933241`, 
                0.6546620223507257}, {1.0582675707346494`, 
                0.6628593468011601}, {1.1369227129030104`, 
                0.6934545398650283}, {1.1987244897959184`, 
                0.7174941289319617}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z8E1fMkFP3mPw4dp+/k
5PQ/qH6dFekL6D9AVoPd4+n0P7m21XsRD+g/co9fy+Lu9D/L7g3iORLoP9YB
GKfg+PQ/7l5+rooY6D+e5ohe3Az1PzQ/X0csJeg/LrBqzdM09T/A/yB5bz7o
P01DLqvChPU/14Ck3PVw6D9+fAqZwYn1P+i43EIedOg/sLXmhsCO9T/58BSp
RnfoPxQon2K+mPU/HGGFdZd96D/cDBAauqz1P2JBZg45iug/bNbxiLHU9T/u
AShAfKPoP4xptWagJPY/BoOrowLW6D/qQK2ICyr2P5My325v2eg/RxilqnYv
9j8e4hI63NzoPwLHlO5MOvY/NkF60LXj6D95JHR2+U/2P2f/SP1o8eg/1vtr
mGRV9j/zrnzI1fToPzTTY7rPWvY/f16wk0L46D+SqlvcOmD2PwsO5F6v++g/
pZo87ixh9j/AiHphSPzoPwD0v14=
                "]], 
               LineBox[{{1.4012755102040815`, 0.7814680977739555}, {
                1.4024622524621388`, 0.7817181407132545}, {
                1.4051079980981398`, 0.7822755911714071}, {
                1.4064308709161404`, 0.7825543164004833}, {1.407753743734141, 
                0.7828330416295597}, {1.410399489370142, 
                0.7833904920877122}, {1.415690980642144, 
                0.7845053930040173}, {1.426273963186148, 
                0.7867351948366276}, {1.4686058933621644`, 
                0.7956544021670686}, {1.547629076117258, 
                0.8123043434282715}, {1.5987244897959185`, 
                0.8230699897463037}}], LineBox[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T979gMMvVrqP/tq1Jsp
evs/4+pSUe4L6z9UNl2RLn/7P9K0U1DNDes/rAHmhjOE+z/BflRPrA/rP16Y
93E9jvs/oBJWTWoT6z/BxRpIUaL7P106WUnmGus/hyBh9HjK+z/YiV9B3inr
PxPW7UzIGvw/zChsMc5H6z9soXZCzR/8P7zybDCtSes/xGz/N9Ik/D+rvG0v
jEvrP3YDESPcLvw/ilBvLUpP6z/ZMDT570L8P0d4cinGVus/n4t6pRdr/D/B
x3ghvmXrP/hWA5sccPw/sZF5IJ1n6z9QIoyQIXX8P6Bbeh98aes/Armdeyt/
/D9+73sdOm3rP2XmwFE/k/w/PBd/GbZ06z++sUlHRJj8PyvhfxiVdus/Fn3S
PEmd/D8aq4AXdHjrP8gT5CdTp/w/+T6CFTJ86z8rQQf+Zrv8P7ZmhRGug+s/
sKqrJ9jA/D9dkVVmtYXrPzQUUFFJxvw/BLwlu7yH6z8MAaNUk8f8P8PjHsA3
iOs/4xm+yQ==
                "]], 
               LineBox[{{1.8012755102040816`, 0.860781265504581}, {
                1.8023956352454178`, 0.8609265005180444}, {
                1.8037242586975861`, 0.8610987693611133}, {
                1.8063815056019226`, 0.8614433070472509}, {
                1.8170104932192683`, 0.8628214577918014}, {
                1.8382684684539596`, 0.8655777592809023}, {
                1.8807844189233422`, 0.8710903622591043}, {
                1.9601756422651684`, 0.8813841999695518}, {
                1.9987244897959184`, 0.8863824297952568}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEAmvFRRs1/sPxMP8AjE
+gBAJIasVEXI7D/SvYqHSf0AQHdBk1ZVyew/kmwlBs//AEDK/HlYZcrsPxLK
WgPaBAFAcHNHXIXM7D8ShcX97w4BQLxg4mPF0Ow/EPua8hsjAUBTOxhzRdns
PwznRdxzSwFAgfCDkUXq7D/MleBa+U0BQNSrapNV6+w/jER72X5QAUAnZ1GV
ZezsPwuisNaJVQFAzN0emYXu7D8KXRvRn18BQBjLuaDF8uw/CNPwxctzAUCv
pe+vRfvsP8iBi0RRdgFAAmHWsVX87D+IMCbD1ngBQFUcvbNl/ew/B45bwOF9
AUD6koq3hf/sPwZJxrr3hwFARoAlv8UD7T/G92A5fYoBQJk7DMHVBO0/hqb7
twKNAUDs9vLC5QXtPwUEMbUNkgFAkW3AxgUI7T/Essszk5QBQOQop8gVCe0/
ubOE3fyWAUBkTSwQGgrtP03YqwU=
                "]], 
               LineBox[{{2.201275510204082, 0.9077208679257764}, {
                2.2025743146728987`, 0.9078261195034764}, {
                2.2039086887592343`, 0.9079342535461291}, {2.206577436931906, 
                0.9081505216314348}, {2.21191493327725, 0.9085830578020461}, {
                2.222589925967937, 0.9094481301432688}, {2.2439399113493117`, 
                0.911178274825714}, {2.2866398821120604`, 
                0.9146385641906045}, {2.3704807786936803`, 
                0.9214328021631831}, {2.398724489795918, 
                0.9237215956074487}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0Cf0kZ0vJDtP7VTRwOU
RARArNwbU7rf7T+IS7iFHEcEQLuYXYR34O0/XEMpCKVJBEDKVJ+1NOHtPwIz
Cw22TgRA6MwiGK/i7T9OEs8W2FgEQCS9Kd2j5e0/6NBWKhxtBECenTdnjevt
PxpOZlGklQRAkF5Te2D37T/tRdfTLJgEQJ8alawd+O0/wD1IVrWaBECu1tbd
2vjtP2YtKlvGnwRAzE5aQFX67T+zDO5k6KkEQAk/YQVK/e0/hgRf53CsBEAY
+6I2B/7tP1r8z2n5rgRAJ7fkZ8T+7T8A7LFuCrQEQEUvaMo+AO4/TMt1eCy+
BECCH2+PMwPuPx/D5vq0wARAkduwwPAD7j/yuld9PcMEQKCX8vGtBO4/xrLI
/8XFBECvUzQjawXuP5mqOYJOyARAvg92VCgG7j/s5rcQMMoEQEByA9G0Bu4/
HGGeuA==
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEDojgtjpwjuP7mBbg75
1ARAOua7ZC0L7j+Med+QgdcEQMMKW7FTDO4/MmnBlZLcBEDWU5lKoA7uP39I
hZ+05gRA++UVfTkT7j/SXmhcMOkEQGVy9P1ZFO4/JHVLGazrBEDO/tJ+ehXu
P8qhEZOj8ARAoReQgLsX7j8U+52GkvoEQEdJCoQ9HO4/qK22bXAOBUCTrP6K
QSXuP9AS6DssNgVAK3PnmEk37j8h3UrYo4UFQFsAubRZW+4/isI7r1WIBUCv
IN7CklzuP/KnLIYHiwVAA0ED0ctd7j/Ccg40a5AFQKqBTe09YO4/ZAjSjzKb
BUD6AuIlImXuP6gzWUfBsAVAmgULl+pu7j8uime23tsFQNgKXXl7gu4/lm9Y
jZDeBUArK4KHtIPuP/9USWRC4QVAgEunle2E7j/QHysSpuYFQCeM8bFfh+4/
cbXubW3xBUB3DYbqQ4zuP7TgdSX8BgZAFhCvWwyW7j86N4SUGTIGQFQVAT6d
qe4/1mIZNp00BkCDB+JTwaruP3OOrtcgNwZAsvnCaeWr7j+s5dgaKDwGQBDe
hJUtru4/HpQtoTZGBkDMpgjtvbLuP7q/wkK6SAZA+pjpAuKz7j9X61fkPUsG
QCmLyhgGte4/kEKCJ0VQBkCHb4xETrfuPwLx1q1TWgZAQzgQnN677j+eHGxP
11wGQHIq8bECve4/O0gB8VpfBkChHNLHJr7uP9hzlpLeYQZA0A6z3Uq/7j+F
gFGqyWMGQI7cabopwO4/Y/8KZA==
                "]], LineBox[CompressedData["
1:eJwVz30s1HEcB/A78f1KzmnVWiYPrdQpFHqQ8vlMjZWHIkqdyehELSexmIfE
xIQkslms2mztmLNFK5Ut5EphkYcKU4o7176/5XTOc7/+eO+913/vt32UPFhm
JBAInPj8b1//tC2r4gjaOeUd/faGwURAVnNCPMHSWnmeppVBduqG8JkEgtnh
UU0xbQxsaxRL168RTBSFjo/zDlv8jDdSCAbJD8JoO4MPComqKJug2M1ktreD
QexAS+zaXIIr47NbT6oYGBuFmJXnEWRlU8FdvL3OZgY8KCTYre+pV71j0ED7
+hT3CRY2V8a86mRQdiF9TKUgaOq9e6Cmm0G4Tc+csI+gMEjalDLAwGJTYtPL
foKpBcuxgkEGb9ZtuJo8RHC67ZF1Pm+H1VK1eoTg+D51TsUQA043MdCjJthh
nRz87Cv/7/3y06plggXqYk43yuBJknO8hyPFdVmtEvkkg3PyTxLdLoqFL2Qj
et6iS0m/6lwomuhM72aqGSSebw6320tRLzthKNIw8Dzu40eR4pDfcEedlkG3
bcSO/lCKVRv10VMcg7+dRT8SblJ0UEqqZQYGw2v6YxdzKNpf3Bz6k3ervzWX
d4uite1a8+g5BiXdioXq2/yeO4bUyHkGjr2q9V3lFFfiVaHSRQYRX4S+EgXF
QWeZKEjAwVGrY12NdRR7J8Lae3jvlJacQiXFrmr/tEAhB4Zhm8gzjRTbLNw1
fkYclI55pua2UFQyo7c+xhx0TCbXfu+lmF//MP2QKQd1O17vudJPMSemzO0l
73txxs8NgxQzbfKnPFZzEKktbRePUEwqloftN+NgnilHDk9SjIz3cnc152DM
ZTb6vYai1MFV28BbleA1FfKb4unRbY9dRByUTX/UX/5D0T9QZOlkwUGa2/qM
WR1FXyJU1fKOSpKuytFT9G6ZyXAUc+Ci14grFygecB7WbrfkwNZKeyR6ieLt
CuVgFu9/BeJccw==
                "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQ/fCpyJ45TBwO+4ovT5EQfG+/wcpvfTAHh4Oc3BYG
DyB/evVU0/tcHA6yQkbysUB+yl9lp2/8HA7Sv3Rj2oF8L7vsE41CHA5S71ZX
zQHyDes3+fGKAvmPNGduBPL/MThGq0hxOEicUr12G8ifwRJXEqTC4SA6SzbA
QAgonyxuelGNw6FedAGLK5CfcvjCV39NDodXE5R2RgL5Bk3O5b56HA7729WV
moH8E/81qjwsOByySg2/XAXyv//6XG/nA5QPcJ1RLfzePuxjZ7dWCYdDBnvu
g2Mi7+2F721dxHSEw2FPyZ6CWPH39n08tbXbj3E4TN5o+KwYyOeydonIOQk0
792y6C4gn2nGJd5r5zgcxDMmum0H8j8Fvq9YeZPDoSg6TUZQ4r39haMa/gHv
ORw0nQROHAHye9bO/j1XitNhKn+KvI7Ue3uOO0nXgmQ5HXJ8bk5xAvJbuLQ2
sitwOjh3+nFFAvnV6TvSClU5HT4yWX5tBfKzFK9edDHgdPD5xnv6PpDvMZVv
xWtXTgemu9vLJku/t2etbQyxLOR0yF/Ffe6XzHv7LR/f/NxfzOmwIZDvCL8s
MLzSIua7lXE6fPohsEsFyD/ir/8quJrTocxdbJkfkN+idLc+r5XTofaJQt0i
IN9kuofq13ZOh/3dyiXbgfwn3FtOVXdxOjAaq2WdAfJdvnaJdvZzOrQ2aod9
A/K/ZH7bxT+J0+G4hp4Pt9x7+yX3EhOmTeF04Lxg4KQA5O/c3HL3zzROBzWD
KF0TIB8AYDX2MA==
                "]], LineBox[CompressedData["
1:eJwVx28s1HEcwPFztdnv+5MtIWV3ukLXOA6T2eL7+UWsTpdTh83dZeweZLi5
5U/ZSDa3tWppnO1G+VPs5jCSztaunOOEmlOHelIYyw1fjmrNPejXg/feewkK
NFlqLofDEbL9f3Vtv/x8KwWyqeikET7BNsM6WLooEH/tGN4OIbi+pGlhqY8C
uWths1FAMPfYjpevlYJ2H0a5FErwkC6vp8lGwUamNIIJI7jAM5kRbKcgtjnv
r5G1da2tRThLwQSvork6nOD7ZokoZYECV1TvR76QYC9VT26Vi4J4WUCyOoJg
jlE1sOKHYLp5g++OIXhyc7H0eQACccfwYGEswQ/FsihFEIIWU22qk/Vxc0qf
k4egcDygyBxHcJRd2DslRODZYV7XxBOsWHN39ycjEGUYJHQiwaMC3bO7RQie
cCVVoUBwjZqjSihB8PtIIK1nnWq8w9vXIFCcWG7zZgieExe3lpQjOCeuHHex
/ollhvx7CMaUXb6DKQQHqoL1aXoEe+aDF0npBGsNA4/8rAjkGpMjW0rwG49B
Z7UhcIY8zppk7VE11GntCG7MaT7HXyNYd0ZZPj+L4HpMnNM/k+BWE1I+XUQg
2xtdmpcRPGFRR/ptIciotH+XyglGAlm4lSCYOWvMt7DOrL9wSutGIFl6sCzK
Jvhb+jH/+T8ILidKV31yCN6ee3/QyKUh/eDL+nQuwUGrwTNHg2i4WLuylaYg
WHnJe2LsJA1j0bbSEdadPW5LGY8G5sdLEqYkOLL4w5DjNA2YubV7WEVw2adh
U10YDe92r2hvsx4Rt3fHCGlI7ozcW2XN/KowNIpoSDq0s2+9SXBDTkETI6bh
7StHeWw+wVlX+ZV61tkVjgRg/Q9PviOU
                "]], LineBox[CompressedData["
1:eJwVymtIE1AYxvGpZcY5aWvmjSIXY5puayCWU+u8pUEGWmppmZbOW7PYZiot
rzDQLPLWzEI/JBIuwVI3K4imzczSJa5aGJQXRLRVdjKcmEZ1+vDw5wcPX65K
yHbmcDgBbP/r6XuYjoUiuJrgWBpPpySpXKCND0PwUmK57pRBScu0R6lTBIJV
936hhHn64FpRzz4EYmp4lsKct+GtghuFQNfVvGRk7lKYMs2HEAzV1dZOMy9Z
7qXlH0bwS6UN3CSnpKK+Iv5NLIKz0rzUHOZGX7Gs4SSCoB7ZoE8mJabgajeu
EsGA4YOuLIuSPTbv0RtqBJbceYmeubtU3+BZgMC2bXnYytw2OuTno0EwV8Xj
CLIpqVatF+/QIkCn4y6MMCcYtfHiJgTHXQajvXMpmQ8va47pY//ELke3ghLu
kYsirTuGjY7K5FklJa1mDxTOxfBFVFzIVVEild23L/IwvM5SNuxnjgv83J7h
i6HOlmS5zXzN9Qz/gADD1t4AEqumZN3zGC9OOAb/gmHho3xKliP4nPJsDHsX
8fKVQkoqjX2Toecw+O5y4j1k9gxONS3kYVhNd+yeYQ7xu1WcpsZgsk4oIoso
Ua9gR2QJhqjuBxM/mO29K/a1egxHVcdenLpEiUbU9MqowyDVR89UMbvdDdGf
b8KwZSrsr5FZqFNmfWzBYIvjy9w1lMjzZyeftGNIkfzsHGD+JLa+u/wUQ86C
rjG4mJI7X7llLv0Ytq+2GU4wyzsShTVmDO9dDdYKZmHuzTGvQQw1PPP3Dma7
YFzTOoQh2t+KbcydMz47g4Yx/BZNBf1h/jb3eLN0BEOyxVnoUULJP0OwGzY=

                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPFD4fT7fsVFXaNQm6xOaiKR3+e2UtdMhYXiuPOULuSpeabs
sGrr4VanlGrLRM1zzbJkNzHFqJzGhWpHD9ivda2Io09/vPfey1meGhxvyuPx
3LH/r2/+VJ40wECyelZ0JI9jC9SyM6NaBhYn9PeU6BWCSc3sKAOtM4aOBrSN
1UzimkkGNpnbLpjlc+xQj8im6gsDRZeEVkJ0hTL1met3BnS2zkJ39AYTA+PL
MXBto4d3OHrb3HyTbJ4BE5+gjMfogCmLxXpC4KPiwnRoAcfyH0iqd68m4Pfz
6t8kdJ/sYpDGloA6+ya/CB0yRu9r1xI4rHzoWouOGbILWHQm0FHVHWtE52k2
XZF4EbjzxvRDdSHHNlaxm/VSAhHeeX2/izjWkGuwkMkIOO8vS1tVzLFeYTXT
Y7EEvgar7J3Q7dbWLe9PEjib8ihGgu4uHhe/Tiegqtb9qkTr5AXRzaUE+gV+
juJzHGvu2n6ruJ6A+Mdi8sXzHCsxSy00NhLgL1kK7qEvTbjIc1sIDK6ya2tF
21RccMtsIyB1FZmOox34x9sSNQTypFE3PEo4duf0nDZomMCTvucdWnRUg5eN
4xIBt9pCayclxz49PkcHeRSisguyvNDU/BlTYkbhyoF8XSC6M3Kv5TdLCn8m
c2py0C5W+5ZbBRS6XLLYd+ipuKOzgW4UYm4rUktLOdZ/tWB6eSsFleKU9jZa
3T70tdmdQs+eJN8W9EHbcP06TwqikQSLj+i6F1Kd3p/Cgp38rk8Zx5oqnEbU
YgrukzErj6BP2H8ePrSPgrw1WpGAZpLj3zZKKPQGR3mr0CnrT/fmh1K4cTl8
YAbd/VLUsz2Mwitp2C6zco7dmMZ1fY6gYBQdqxSisx2aNNcjKewwhpp4oAd7
0jsPRlOI6wtJDEBvyfDsWJBRUFcG90eilcVH63pjKWhDMrsV6H+oYlFU
                "]], LineBox[CompressedData["
1:eJwV0XlI02EcBvDpREPx99qwQFLUYdYEDyynZvZ+CcnhttRhnpjHTJxYIRnq
VDxyYkuboSmeofOY6ea8KmJgdkzKLMwOJVFRE43spctFh+vtj4eHDzz/Pe7p
FyXnLFks1iGa/x0uKuKyZQx8lWqLHlYTrHQLGZ/KYaAgIUPgdpXgtek/I/KL
DHCmUuVS6gZumW4lj4HwroSlLWrTy6qewVIG9PHC3h0lwVFFAnVKBQMRxvD5
4GsEazxtOzkKBtaPhNmWUCeW1LYVKBlwQqEX2DUEG7wa6sNuMlDxxIfvUEtw
maKzfPE2AzH+HCNPRbB9vk1EmpYB3+U7hVnULVnnORtDDNjVJHn3UY8Kg9Vk
jIHJD90NHnUEb+ydfWw5QffNgVLXGwQLO1h7eHN0z0pm7asneP/dlOuXfzPw
aKbvGKuJYO2mSysjQuAvCx1620Fwdbsidek0AqdVvdb5FsEZku2DumgE5kSP
wXRqZ4NBL45D8Fxk1/+ZWqlKMtakI8j0W+iy7iQ4i9/8xbYQQYspr5GvJphb
6Siw6UVgUTVY0thH8G5Qsf07DYLNXdfiReqF7bVXvQMIXuTXy7kaguviRpNP
DSNolcnzddRmL8klhQFBgFiQa+wneHFW1cGeQyBzXM/YGSD4XpVJOvcGQWRt
nPT4IP0nJIWnnkfAt55Oq6AW9viMnVxCwP45fJbREny/YOZp+RaC9vel8Z46
ghu9A1TRnxBcifkWm0Odu9oW404QZM9knhmhPizKWX7wHUHghFhyYohgK4vX
3XUmBC5Bk1GV1CvjIdmpvxBYDR+NfEZtyFb7+v1F8JGnETvoCW5ytfthNiOY
7TogiqX+B+RbJCo=
                "]]},
              Annotation[#, "Charting`Private`Tag$317522#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT6pfRWucBFkPgRDGnDf
GVQ/wGqAvJ1oQj8zn5icsxlkP5UOn5l1aFI/S83Xsp0ZdD+AYC6IYWhiP1dk
972SGYQ/dQl2f1docj/dL4dDjRmUP/DdGXtSaII/oBVPhooZpD8tyOv4T2iS
P4EIsyeJGbQ/S73Ut05ooj8qR5GIsnC0P++NDWwhuKI/0oVv6dvHtD+SXkYg
9AejPyQDLKsudrU/2v+3iJmnoz/G/aQu1NK2P2dCm1nk5qQ/DPOWNR+MuT+E
x2H7eWWnP5jdekO1/r4/vtHuPqVirD9BHFmk3lW/P2KiJ/N3sqw/6lo3BQit
vz8Gc2CnSgKtPx7seWOtLcA/ThTSD/ChrT9vaTYlANzAP9tWteA64a4/EmSv
qKU4wj/87T1B6K+wP1hZoa/w8cQ/GXME430usz/v21QKohrFPw7a9CbCU7M/
hl4IZVNDxT8DQeVqBnmzP7Njbxq2lMU/7A7G8o7Dsz8Obj2FezfGP7+qhwKg
WLQ/xYLZWgZ9xz9l4goiwoK1P1wFjbW3pcc/Wkn7ZQaotT/yh0AQac7HP06w
66lKzbU/II2nxcsfyD84fswx0xe2P7cPWyB9SMg/LeW8dRc9tj9Okg57LnHI
PyJMrblbYrY/fJd1MJHCyD8LGo5B5Ky2PxMaKYtC68g/AIF+hSjStj+qnNzl
8xPJP/Xnbsls97Y/QB+QQKU8yT/pTl8NsRy3P9ehQ5tWZck/3rVPUfVBtz+Q
O0vYzW/JP2YkRPqKS7c/8PAT6w==
                "]], 
               LineBox[{{0.20127551020408163`, 0.09262615681427668}, {
                0.2033724813112215, 0.0943452394796572}, {
                0.20461432671651483`, 0.09536329590497154}, {
                0.20585617212180818`, 0.09638135233028587}, {
                0.20833986293239484`, 0.09841746518091453}, {
                0.2133072445535682, 0.10248969088217186`}, {
                0.2232420077959149, 0.11063414228468652`}, {
                0.24311153428060836`, 0.12692304508971586`}, {
                0.2443290196086536, 0.1279211312892212}, {
                0.24554650493669883`, 0.1289192174887265}, {
                0.24798147559278932`, 0.13091538988773718`}, {
                0.2528514169049703, 0.13490773468575853`}, {
                0.2625912995293323, 0.1428924242818012}, {
                0.28207106477805627`, 0.1588618034738866}, {
                0.3210305952755042, 0.19080056185805735`}, {
                0.3987244897959184, 0.2544934886805535}}], 
               LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T9i7LXCbW3QPxe0Ed4B
Ad8/moeweQgv1T9cjPtU5BbfPwLD6xuXQtU/omTly8Ys3z9s/ia+JVbVPywV
ubmLWN8/PHWdAkN91T9CdmCVFbDfP+Biiot9y9U/NpxXppQv4D8kPmSd8mfW
P2Fepl2o3uA/sPQXwdyg1z+EShuZmengPxowU2NrtNc/pjaQ1Ir04D+Ba44F
+sfXP+wOekttCuE/VOIEShfv1z92v005MjbhP/XP8dJRPdg/jCD1FLyN4T88
q8vkxtnYP7biQ8zPPOI/xmF/CLES2j/WSIHxjUfiP0iOElzkJdo/9q6+FkxS
4j/KuqWvFznaPzd7OWHIZ+I/zxPMVn5f2j+4Ey/2wJLiP9jFGKVLrNo/uUQa
ILLo4j/oKbJB5kXbP7Cb30LAKOM/bO0KmGK42z+X56Ve
                "]], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z/VFWcKzNjbP9wMLplS
n+M/ApacfDNZ3D/8cmu+EKrjP8HtZeRSZ9w/PT/mCI2/4z8/nfizkYPcP77X
252F6uM/O/wdUw+83D+/CMfHdkDkPzK6aJEKLd0/wmqdG1ns5D8hNv4NAQ/e
P/UmPQ+tbec/Xmbm7A2t4D8+4kLHinjnP1FWs2EytOA/hp1If2iD5z9ERoDW
VrvgPxYUVO8jmec/KCYawJ/J4D82AWvPmsTnP/LlTZMx5uA/eNuYj4gb6D+H
ZbU5VR/hP/yP9A9kyeg/sWSEhpyR4T9ES/rHQdToP6NUUfvAmOE/jAYAgB/f
6D+WRB5w5Z/hPx19C/Da9Og/eyS4WS6u4T8+aiLQUSDpP0bk6yzAyuE/hiUo
iC8r6T841Lih5NHhP87gLUANNuk/KsSFFgnZ4T9eVzmwyEvpPxCkHwBS5+E/
f0RQkD936T/aY1PT4wPiP8j/VUgdguk/zVMgSAgL4j8Qu1sA+4zpP79D7bws
EuI/FwJGqSaP6T8Vdcz6mRPiPwNRyC8=
                "]], 
               LineBox[{{0.8012755102040817, 0.5662775449914086}, {
                0.8024388112602567, 0.5667758571129607}, {0.8037652381656297, 
                0.5673440458907424}, {0.8064180919763757, 
                0.5684804234463056}, {0.8077445188817487, 
                0.5690486122240872}, {0.8090709457871217, 
                0.5696168010018688}, {0.8117237995978678, 
                0.5707531785574322}, {0.8170295072193599, 
                0.5730259336685588}, {0.8182677985372807, 
                0.5735563686496475}, {0.8195060898552016, 
                0.5740868036307362}, {0.8219826724910432, 
                0.5751476735929135}, {0.8269358377627265, 
                0.5772694135172682}, {0.8368421683060933, 
                0.5815128933659778}, {0.8566548293928267, 
                0.5899998530633969}, {0.8962801515662935, 
                0.6069737724582349}, {0.9739717509693491, 
                0.6402537781109471}, {0.9987244897959183, 
                0.6508568715521659}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D/hmrI42dzkP+v3397V
MPI/ms7vFg/B5j+2Z4/CSjbyP1SupHfQxeY/gNc+pr878j8NjlnYkcrmPxa3
nW2pRvI/gE3DmRTU5j9Cdlv8fFzyP2bMlhwa5+Y/mvTWGSSI8j8zyj0iJQ3n
P2Vkhv2YjfI/7anyguYR5z8w1DXhDZPyP6aJp+OnFuc/xrOUqPed8j8aSRGl
KiDnP/FyUjfLs/I//8fkJzAz5z9I8c1Uct/yP8vFiy07Wec/E2F9OOfk8j+F
pUCO/F3nP97QLBxc6vI/PoX17r1i5z90sIvjRfXyP7JEX7BAbOc/n29JchkL
8z+XwzIzRn/nP2rf+FWOEPM/UaPnkweE5z80T6g5AxbzPwqDnPTIiOc/yi4H
Ae0g8z99Qga2S5LnP5WetuRhJvM/NiK7Fg2X5z9gDmbI1ivzP/ABcHfOm+c/
cmcJu/kt8z8YCIsgq53nPzxVuO8=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAA9P5cq2w48z8TYi/0TqXnP8FddHM1
PPM/cPHEWYun5z+MzSNXqkHzP6gpB7HEquc/Iq2CHpRM8z8ZmotfN7HnP01s
QK1nYvM/+nqUvBy+5z+k6rvKDo7zP708pnbn1+c/bpdPI2qT8z9nFVS2Edvn
PzdE43vFmPM/Eu4B9jve5z/KnQotfKPzP2efXXWQ5Oc/8VBZj+m48z8RAhV0
OfHnPz639lPE4/M/ZceDcYsK6D/ZgzHdeTn0Pw9SYWwvPeg/Dh2n7+Tk9D9h
Zxxid6LoP0BWg93j6fQ/dFA6B2ul6D9yj1/L4u70P4Y5WKxeqOg/1gEYp+D4
9D+sC5T2Ra7oP57miF7cDPU/9q8LixS66D8usGrN0zT1P4v4+rOx0eg/TUMu
q8KE9T+zidkF7ADpP358CpnBifU/xXL3qt8D6T+wteaGwI71P9hbFVDTBuk/
FCifYr6Y9T/9LVGaugzpP9wMEBq6rPU/R9LILokY6T9s1vGIsdT1P9wauFcm
MOk/jGm1ZqAk9j8FrJapYF/pP+pArYgLKvY/n1UXPZRi6T9HGKWqdi/2Pzf/
l9DHZek/AseU7kw69j9qUpn3LmzpP2CejBC4P/Y/A/wZi2Jv6T++dYQyI0X2
P52lmh6Wcuk/eSR0dvlP9j/P+JtF/XjpP9b7a5hkVfY/aKIc2TB86T8002O6
z1r2PwJMnWxkf+k/kqpb3Dpg9j+b9R0AmILpP6WaPO4sYfY/BF6FBieD6T9M
4iOz
                "]], 
               LineBox[{{1.4012755102040815`, 0.7978815603050673}, {
                1.4024622524621388`, 0.7981094428656987}, {
                1.4051079980981398`, 0.7986174885565113}, {
                1.4064308709161404`, 0.7988715114019176}, {1.407753743734141, 
                0.7991255342473239}, {1.410399489370142, 
                0.7996335799381366}, {1.415690980642144, 
                0.8006496713197617}, {1.426273963186148, 
                0.8026818540830122}, {1.4275968360041484`, 
                0.8029358769284184}, {1.428919708822149, 
                0.8031898997738247}, {1.4315654544581502`, 
                0.8036979454646374}, {1.436856945730152, 
                0.8047140368462625}, {1.4474399282741564`, 
                0.806746219609513}, {1.4686058933621644`, 
                0.8108105851360138}, {1.547629076117258, 
                0.8259849038334468}, {1.5987244897959185`, 
                0.8357964308323034}}], 
               LineBox[{{1.6012755102040817`, 0.8362486057938685}, {
                1.717324837408056, 0.8551044787516782}, {1.7185502699170643`, 
                0.8553035889082379}, {1.7197757024260723`, 
                0.8555026990647975}, {1.7222265674440886`, 
                0.8559009193779169}, {1.7271282974801212`, 
                0.8566973600041555}, {1.7369317575521863`, 
                0.8582902412566329}, {1.7565386776963166`, 
                0.8614760037615876}, {1.7577641102053247`, 
                0.8616751139181472}, {1.7589895427143327`, 
                0.8618742240747069}, {1.7614404077323491`, 
                0.8622724443878262}, {1.7663421377683817`, 
                0.863068885014065}, {1.7761455978404468`, 
                0.8646617662665422}, {1.795752517984577, 0.867847528771497}, {
                1.7970811414367454`, 0.8680634055510221}, {
                1.7984097648889135`, 0.8682792823305472}, {
                1.7987244897959185`, 0.8683304193169143}}], 
               LineBox[{{1.8012755102040816`, 0.8687072317848853}, {
                1.8063815056019226`, 0.8693860199470799}, {
                1.8170104932192683`, 0.8707990315948806}, {
                1.8382684684539596`, 0.8736250548904821}, {
                1.8807844189233422`, 0.8792771014816851}, {
                1.9601756422651684`, 0.8898313261504656}, {
                1.9987244897959184`, 0.894955988303741}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDnT9YxLqbsPxMP8AjE
+gBAHLJ5mc4i7T/SvYqHSf0AQCFH6MYSJO0/kmwlBs//AEAm3Fb0ViXtPxLK
WgPaBAFAMQY0T98n7T8ShcX97w4BQEZa7gTwLO0/EPua8hsjAUBvAmNwETft
PwznRdxzSwFAwlJMR1RL7T/MleBa+U0BQMfnunSYTO0/jER72X5QAUDNfCmi
3E3tPwuisNaJVQFA16YG/WRQ7T8KXRvRn18BQOv6wLJ1Ve0/CNPwxctzAUAV
ozUel1/tP8iBi0RRdgFAGjikS9tg7T+IMCbD1ngBQB/NEnkfYu0/B45bwOF9
AUAp9+/Tp2TtPwZJxrr3hwFAPkuqibhp7T/G92A5fYoBQEPgGLf8au0/hqb7
twKNAUBJdYfkQGztPwUEMbUNkgFAU59kP8lu7T/Essszk5QBQFg002wNcO0/
ubOE3fyWAUDHpwegQ3HtP75Romc=
                "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAe3+uVTacAUBhGMVMlHPtP9o8REjf
ngFAI93h0Jl07T+vuuzgmqEBQMHldn6mde0/WrY9EhKnAUAA96DZv3ftP7Gt
33QAsgFAfRn1j/J77T9enCM63ccBQHZenfxXhO0/uHmrxJbzAUBp6O3VIpXt
P2s0u9kJSwJAT/yOiLi27T/A0NWsuE0CQK0yek7At+0/FW3wf2dQAkAKaWUU
yLjtP7+lJSbFVQJAxtU7oNe67T8TF5BygGACQD6v6Lf2vu0/u/lkC/d1AkAt
YkLnNMftPwu/Dj3koAJADMj1RbHX7T9gWykQk6MCQGn+4Au52O0/tfdD40Gm
AkDHNMzRwNntP18weYmfqwJAg6GiXdDb7T+zoePVWrYCQPt6T3Xv3+0/W4S4
btHLAkDqLamkLejtP6tJYqC+9gJAyJNcA6r47T80LCE+P/kCQBVpPwqg+e0/
vg7g27/7AkBiPiIRlvrtP9DTXRfBAANA++jnHoL87T/0XVmOwwoDQCw+czpa
AO4/PnJQfMgeA0CR6IlxCgjuP8dUDxpJIQNA3b1seAAJ7j9QN863ySMDQCqT
T3/2Ce4/YvxL88ooA0DCPRWN4gvuP+veCpFLKwNADxP4k9gM7j90wckuzC0D
QFvo2prODe4//qOIzEwwA0Covb2hxA7uP1JNHneWMANAdT1U7OAO7j/RePlT

                "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAFBlI7881A0DmbSONkxDuP6wQQ+HP
PANAU6zg/W8S7j/Qmj5Y0kYDQLEOBkwZFe4/WX399VJJA0BIZ4+fwxXuP+Jf
vJPTSwNA4L8Y820W7j/0JDrP1FADQA5xK5rCF+4/Ga81RtdaA0Bs01Doaxru
P2LDLDTcbgNAKJibhL4f7j/16xoQ5pYDQJ4hMb1jKu4/tVNHA5REBEB0tXs7
kVjuP4hLuIUcRwRAQbBHqD1Z7j9cQykIpUkEQA6rExXqWe4/AjMLDbZOBECo
oKvuQlvuP04SzxbYWARA3YvbofRd7j/o0FYqHG0EQEZiOwhYY+4/Gk5mUaSV
BEAYD/vUHm7uP+1F19MsmARA5QnHQctu7j/APUhWtZoEQLIEk653b+4/Zi0q
W8afBEBM+iqI0HDuP7MM7mToqQRAgeVaO4Jz7j+GBF/ncKwEQE7gJqgudO4/
WvzPafmuBEAb2/IU23TuPwDssW4KtARAtdCK7jN27j9My3V4LL4EQOq7uqHl
eO4/H8Pm+rTABEC3toYOknnuP/K6V309wwRAhLFSez567j/Gssj/xcUEQFGs
Hujqeu4/mao5gk7IBEAep+pUl3vuP+zmtxAwygRAL2AQXhd87j+oGdVc
                "]], LineBox[CompressedData["
1:eJwVzX8s1HEcx3H0/X70R90WVs6MDGOoFebMj73f3SbKmn6ZMq5chI5U5kom
zq/dpFwc/VFHlxWV+8Z1WV0/LrIVq/mxOFu5MN0q9V76S2qrb3+89tzjr1eA
smR/npuLi0uQuP8VzPPawjEOK71LLFBJ8FhzUvLrHYdz1d7uCRcImso/6jR2
Dj1DU1cF0ZGFg20tHzg8r+6b01cRVKXUd1qcHCZ7VpiOaggmFQVZ275waEsK
yp4QHVSWKu1d4lB27u06eQ3BqHFDa9cPDkNm/YsCawm8fhsaWlY5ZN3DYc46
gh7TQPEpCY/DcZIelZZg3ONzfEQMj6g03lQ3EwTM7p7pqucxtv/V1SYDQeNQ
/P10LY9hPscdrIPgZ3dEg/tFHn1ruWCN6KEzkmiVjkfX9B3msk6C3LWTzZHX
eBxdsb5RGMW/qMPJg308KlBw3X6LYGtj/oDjPY+1Y3rVVC9Be8mhSzoHj+rY
KHOaieDvwV258nkeC4wTKyOix/3DPW47edxTKml4LhCcfkjFxcs8btykvdHd
R2CZKwv+wxjeUVRMlVsI4mR1emkkw7HvOeD3lGBaKY0xRDM80SRL14kuvSzY
N8sYsvD1KrdnBL2fZnxCExgmFjxqd4r2028xxuxkeG9BQoKNwGobkltTGCZr
FtcEvCDIWMpYTExluOBvlbaK1slrQpL2MpRm5yWdHSRwW542HchkqLU/uQ4v
CTp8i9LsWQwD1VfM/aLjU1yXM48wtHnlvw4cJpgpbW9x5DDMfJDgaBNdX73v
7sgxhkKu8us30f8A2AsMfA==
                "]], LineBox[CompressedData["
1:eJwVz30s1HEcB3BP+35THuaplh6ubOXIqEXLxO/Tg2e1Vqycy4nSnZJLiEgP
OtZkk9LS00ylduhUJEQIlzycu3M9LDZZzon9PNVJ6eHTH++99/rv/V4dnbDn
sJGBgYEr5n/7h6Q7GIsIKPtV7qfaWEa781yd+DiB+gXG24rRF9Ls+N/EBJzv
lfo+Q3MeSH+fOkmgyDsosB29f74PzqYSSE28snsc3Sl1kuddIODRzxFsbmcZ
4btGoZWEwP2U19HBaBOj0IWFOQRsrI7ERqJ9wjN33r5MYNr3cfxFdCVVq6XX
CchkWzJ60dcOZQzKpQScssKLhHKW4a9UzBmqCaxwvqq+8YZlLJYmVtdrCOhL
BOIKdLON3YnkDwQUy1zMW9BrTSN0ugEC583b/MbQEzPadwodgeFJfa13B/7r
+PPszh8CFTW84iH0oyTX457OFHx8HeJdOlmGl6B0mnGhsKSRNd2KNo9LGi53
ozC5qb40DJ0oqOOv8qBQwg0dzER7BfkFU6BAzLL3KtE9nEiuJoxCj2rUM6WL
Zb6/zRsSn6cgiHpCmrpZpn+RRjifRaHPjPqp0S0hyydysikE1vIlWnR+j/TX
3VwK7tYLTMx7WMZZJbftLqRg2hppyENHfjT0d5JSeOpoNj+D3mEf2F1VToHb
d9CLKlhmXUT+XpBRuHOu5rQ9+kf/yqh9VRRyPkbPAbpg0CtN0kiBn1urz0O3
jySXfVbh/onYKcdelinnNmyI11BIv/VyvRf6qsjkxY/3+N/fWrwLHTVW0Go5
QOFTcQObhP7Jyga8RyhU7rEdb0YPus3GdIxSWPNXtE6Dlot9voaOU7hZ9ipO
h7423aU/OkVBYnJ01ELJMukbbc/MzlD4WdnEdUBHJ0UYZ+kpJBxYLPRAB1SX
XLKYo/DF9NjDALSbftTy5i8KvOfN2gg0x35se8xvChdF6UIR+h/27Wsq
                "]], LineBox[CompressedData["
1:eJwVzWtIE1AYBuC1NM/R1iAVYaGk0zILZ+VYGnm+ymKIl6kRUiG6zDAtb6Oy
tcZyKmpZmVMxzZCSQsxMy5QuP1reEK95KXJiFM20s7zMW7l1+vHx8vDC+7nL
U6POcDkcjhe7/zn53el1JRfB/cjfop4BSp4FhjdEIwQLb3r4WYOUlCl14gl7
BF2pQl47c8Ka8NAiH0HmUL9d3BAlIUHJnZrNCKQ5223rmXern4fznBG4Sq5x
V5ktnIMnPQUI2it2rt39SEm5TawiyhOBQJ471zHM+tMu4oFtCDrSNOcdR9j+
+35zxA4ECvVVYyyz3/XDl8J8EfRVZhjMzJ1W7yvSfQiyR2O7hWOULK3Oq4NC
EcyESmrUnyk5Pptf6KNA8FZijJRMUOJoeFHD1SOQ80Iaa42UFG1UqVraEbzU
GW8vM9vvD45J6ULg4JaXFjJFCbd8kDfSi6DJVy+izHORpstPPiGwkQU9FU9T
0v/BO0JmQlBbvKdO/4uSG/X3/lQJMEy5bHn0dY4S9EU+EuWK4cCDVq3/PCVa
e59Gu60Y7njHJOQyK8++Skz3whAYoBP6LFByzn14INgPQ+EJfk26mRKpbtPj
6SMYdlWtr+YsU2Kr0hwLSMeQ6jFT7rZGSfPszMq7TAz+WQ3cZOaExJjqoxcx
rPRlpLQw6yNEP6OVGLJVK0RmYf89xtUXcjCUjW34obFS4l8m9TLnYTgl6pb1
Mn9zaO5WFmBwz73ZJuCYSLC5wDn/Foa6vU5FTcwLSYtt/GIMaQWjS1bmh4b4
uNISDOLJivjQdSbS2qQd/1uKIUlbbClh/gdf1hoX
                "]], LineBox[CompressedData["
1:eJwVx30s1HEcwPFzbez3/cUWeTquUrKruJhGf9Dnc47IU06R4i4Ty8rDaBRa
keWmB6ZQu4gU5rkZwsZynpcMFdVmNaaaVR8TqZzW9cd7773sYpJD44QCgUCi
7/+zrjaHuZVx+Mj2T3CSkGBA8wl7H3P4enZxQ7eJIDexePptE4funl5zZoYE
QrMlAxMthxvrS/UyRtCqjqwtHuBw+pVh7LDeMbqhQJthDpsbbMVBPIF2ofye
ZIzD6Ei/wojNBNc6A5zk0xz2d1dcSDYhMFDVRlxa5DA/I9ij3JRAUKdqmTNl
aL7W8PKXiGDo60xShTnDqfkPHfk2BLecFdIoK4aFE2aVIlsCy0550xsxQ64+
K9VDTCAdljSMSBj+jQqwzN5OELWwXNN8iOFn7WK0kT1Bl536YeY5hl0Fe1bM
nQiuxAlU7okM07OUszV6e9dliFeSGbrGFw25SwkmnBPKEtMYNst+3z+5n+AL
KDTR2QyrVkY8y10ILFQ2pYdLGd48Fa+2dyNI1bTcNtUyVDrUilyB4JlOo9YO
MCxp7z7dp7dOlZeTOsxwzHv8yVEkUO9Spk2NMfQ4sypNkBGUNTLlnRmGokq5
vFpOMNgb52j6jeG09cfzln4EzE7hoCWGxnU/nlbrHZLrsSN1maHPQaOfrkcI
3vuabZ1aY9gWLs0O8Sf4PvF8vUjI4527l4vzAwms5m1ebLHiMdjYumc9hEDp
YzTYJ+Ixr8xReENBUFW73Jsi5rFnH/pahRI4Joy2Tu7k0dH/7OSBYwQp422N
Obt5jH2XadGvd4dzZY2LhMcH8QWRiuMEstV0TZETj0zdvpAYRpB3IqZY5syj
l8XoXp3eoUHbLpbqfX21pNM4nOAfM+0dmg==
                "]], LineBox[CompressedData["
1:eJwVz30s1HEcB/DTlbTvd3TcPP2RXW5m5yHtduYO+30whTwMy1NYnGfnPPVA
Hcp6uDIbeRpaDCNFTqwH65jI0C7CNKswq7hJv7QUmdWnPz777LV9ts/7LUjM
Dkvex+FwRDj/N9/Kj52SEHi8Z3BjKIJlIoqFpaFuBOw9RcrP6MZlE5WBO4HJ
2WN840iWWfbePd/rSUCRIRlwRWccnEnn+RDorQNDNbonXSsf9iUQ7nyiS4P+
+fp+XK4fga3RU2EL6JKKktC3QQSkPyLuiaJYptrKSVoZReBlYJarDq11UBvx
lARmDRpSTGNYxnXOQncnh0D3395QN7RG1VHJzyeg3pvwiEe36MasLQsIeO7s
mD5Aq7MPONmUEuj4Hj3kdYZlwvpKQ51qCaiWrCxzY1lmVVbU4D9IQKitn5iK
ZxleQJ5jqTGFCwX1juVylmkeNiEyHgWhmBvwBO0i7dZvmlGY2VCkLqGD7dfa
E6woOMuh5XgSy9w2jBd4CSmsBq1azKP3j/ibc2QUIm0lXJsUlvnlLuAUJ1OQ
vple0KSxzPW+wUVJGt6rZb8X0HyHWO1GBoUanzY+N51lxNZ1l+JyKGw+uxhy
Gp2zTbc8LlPobD3yaget79/W71ZQsC5UaLwzWabAsXa8r4rCuHhel4k2ahN3
ZNZin2/MejXarkqZ9L4R88vN7FbRibmfFgfaKZQFDzSWKVhmc+2qNq8T8x0S
Pu9HXzlrc1fUhflGyuc/optCYqIbein4SBN4Llks88FperbwBYVdW6Obc+im
dV4Rd4jCiu81/R90Yme4Xfkw5knlBAqU+D+1Zsp8lELPLdWjk2i98F1B8xj2
fbh9WInuWrE8KpqgoNKdy69Gf/3y9LDLJAVLi/CNVvQ/HZ0ttw==
                "]], LineBox[CompressedData["
1:eJwV0HlI02EYB/Dpynn83tezAzFFiZmZaTWM0vY+kRPFDuzANI82z0LanDJD
1JZph0VC3pLrH8OS8piS5spkHcOE0vBIZUmmszx4C8E8pvb2x8OXzz9f+D6e
MvnpZEsejydk9z8btd9vX/rMwUGDROUqpySvUqoYHeRgKDTrlJF5k/OUfn6U
A8WnpBGVghJH27lUlykO6oyS+acZlAwY/Bw10xxkeIq1i8xVRfJO7xkOxMmB
2ceUlLhbLHBBlIOvc0ILI/OepeUW6TIHnFmwxSGLklCTwNyIEGS6fgxWqShp
1pCdk/EInMq+jGE1JQs5CwKpFEG7SO4ewxwYVT9rTEQQN2gnfcyss7dvHU5D
UL9VYgq6TskH9bejvUoEwdXtv9MKKBmT5SVobyJI1jzc/LaQEitvXY26EUHH
kxT/7DuUhPPl+WvNrC+cr9Qz3xv3kuW0IuDPPGpDxWxvVbFPVgeCE74jh+qY
3WxiOlL1CCaeR4T036Vk/+zS4MkhBHatAdG+9ymJawp03LGOIP71SsH4A0pe
xCzhPh6GhuHDu/eVUoKtOrkbfAx//+T0FzB3xx6x/mWNoUS46iEso8TLNmSj
zRlDd8nqq/RySkxJkfPHfTB4ycyLy5WUiB2cZzd8MchzgzURVZRU6gZ+avdi
0FXkSmqZw5zOT24XYTjTay6Fakoa3sSPTYoxFIrWAm7VUHLFNb0n9ywGk9X6
ZZda9q/3fgb/KAwHPMVOKcweGfTdRDSGa0H5L9uZr7q16MtjMfSe67poo6Gk
z6DsDkvAsE2xLrjAvCtT1LUqxZBULG56xlykjmzoScRguTId8oP5H9z4HNk=

                "]], LineBox[CompressedData["
1:eJwV0X8s1HEcx/Hzoync5yMjP9LK6XBa0axLs/m+l5K5U0c1jYr065h2kxIu
i+ZkVC5Rkbhv16Hzo/zaqZ3yRwvrl5+TZRLLj5Z9U3EtSe/+eO25x98v93hF
5ElzHo/nhfvfPVKlwCKBwNrxw7YhlRyTvyGwtTOJQKrd9oJ49MSrP00ZCgKr
nKzmU9HFgqyGsXMEfDdWd1WiTe9ydXWXCCiDphRzaJkyVBt7mQDZbRheoeGY
Gk9r1l5FgJVcCXZFR2deK0/LJ9B5yMspGG30Kb65q4SAQ8rpZ8XoLBWbPaIn
UFc9ZRvAcgz/glXYsXoCHz6BiwRdJj9jP/mIgI1bmfAoulmyQ8u1EEhQS4Ny
0JOre1+YPyfgmd6o6EFLKngrRf0ENGHKPvl9jlljiL1+fpFAySy5U6rlmPrp
dXeJlEKmv9hjUccxefdUcaN7KTi7NZyyq+KYE5GzwoYICk2Wnnoh2s1ofBwe
RWF60HGrDJ1fGPPyajyF/WnzQTq0XFw6Z51OQdTeEr2vmmMEOQ6hVlUUBkL8
i7Q1HPM34CJ/qIaCwrd2sA09PDvRV1VLwdrZw+UtWh3VfCSkkQIzY6/5hV72
iUxRGSnoC77Xhz/kmJHewgqLfgpZPY3dJnRbrul4/yAF1yciPl+P/wTGirTv
KbSyrEyAlui2tOwcpfDl7I0hKfpp2pvu7BkKBx2TP7PoW5u3FUZ8pfBtadrb
gE4eLz/gzlEomIxLeo32liZ97PhJocMg+7GAtjQbeKA2UYjRdIltazlmrDUw
Me43hYU8yHBHGxO1vn5LFNTJbe1i9O31NvPLyxQ2RfuZSdH/AAKFKBM=
                "]]},
              
              Annotation[#, 
               "Charting`Private`Tag$317522#2"]& ], {}}, {{}, {}, {}, {}, \
{}}, {{}, {}, {}, {}, {}}}, {}}, InsetBox[
           
           TemplateBox[{
            StyleBox["\"WT\"", 20, StripOnInput -> False],StyleBox[
             "\"KO\"", 20, StripOnInput -> False]},
            "LineLegend",
            DisplayFunction->(FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    GrayLevel[0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[1, 0, 0], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ),
            Editable->True,
            InterpretationFunction:>(RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& )], Scaled[{0.9, 0.2}], ImageScaled[{0.5, 0.5}],
           BaseStyle->{FontSize -> Larger},
           FormatType->StandardForm]},
         AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
         Axes->{True, True},
         AxesLabel->{None, None},
         AxesOrigin->{0, 0},
         DisplayFunction->Identity,
         Frame->{{True, False}, {True, False}},
         FrameLabel->{{
            FormBox[
             StyleBox["\"Cumulative distribution\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}, {
            FormBox[
             StyleBox["\"Cav2.1 intensity (A.U.)\"", 20, 
              GrayLevel[0], StripOnInput -> False], TraditionalForm], None}},
         FrameStyle->Directive[
           GrayLevel[0], FontSize -> 20, 
           AbsoluteThickness[2]],
         FrameTicks->FrontEndValueCache[{{Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
             Charting`ScaledFrameTicks[{Identity, Identity}]}}, {{
            Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.25, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.3, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.35, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.45, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.5, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.55, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.65, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.7, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.75, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.85, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.9, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.95, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.05, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.1, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.15, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}, {Automatic, {{0., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.01, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-1., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {-0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {0.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {1.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {2.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {3.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.2, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.4, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.6, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {4.8, 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}, {5., 
               FormBox[
                TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
               0.}, {
                AbsoluteThickness[0.1]}}}}}],
         GridLines->{None, None},
         GridLinesStyle->Directive[
           GrayLevel[0.5, 0.4]],
         ImagePadding->All,
         Method->{
          "DefaultBoundaryStyle" -> Automatic, 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
           None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}},
         PlotRange->{{0., 3.999999918367347}, {0., 0.9902755247577152}},
         PlotRangeClipping->True,
         PlotRangePadding->{{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.05], 
            Scaled[0.05]}},
         Ticks->{Automatic, Automatic}],
        TraditionalForm],
       InterpretTemplate[Legended[
         Graphics[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                GrayLevel[0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT4FvXqHBY5aPwRDGnDf
GVQ/0Y37xV3cYD8zn5icsxlkPx+9Oci4cWQ/S83Xsp0ZdD+8G7bMbpxrP1dk
972SGYQ/fGzXau34dD/dL4dDjRmUP9sU6Lksp4E/oBVPhooZpD8W0uDCmPyP
P4EIsyeJGbQ/RSZparhTnj8qR5GIsnC0Px6/2AEJ0J4/0oVv6dvHtD/3V0iZ
WUyfPyQDLKsudrU/1cQTZH0ioD/G/aQu1NK2P4f28pIeG6E/DPOWNR+MuT/t
WbHwYAyjP5jdekO1/r4/uCAurOXupj9BHFmk3lW/PyXt5fcNLac/6lo3BQit
vz+SuZ1DNmunPx7seWOtLcA/bFIN24bnpz9vaTYlANzAPx6E7Ako4Kg/EmSv
qKU4wj+E56pnatGqP1hZoa/w8cQ/T64nI++zrj/v21QKohrFPzMhxPP47a4/
hl4IZVNDxT8XlGDEAiivP7Njbxq2lMU/3XmZZRacrz8Obj2FezfGP7aiBdQe
QrA/xYLZWgZ9xz9EbncWRiqxP1wFjbW3pcc/tqfF/kpHsT/yh0AQac7HPyjh
E+dPZLE/II2nxcsfyD8LVLC3WZ6xP7cPWyB9SMg/fY3+n167sT9Okg57LnHI
P+/GTIhj2LE/fJd1MJHCyD/TOelYbRKyPxMaKYtC68g/RXM3QXIvsj+qnNzl
8xPJP7eshSl3TLI/QB+QQKU8yT8o5tMRfGmyP9ehQ5tWZck/mh8i+oCGsj+Q
O0vYzW/JP7K7+p33jbI/3O4Weg==
                "]], 
               
               Line[{{0.20127551020408163`, 0.07388449707273509}, {
                0.2033724813112215, 0.07544787909750711}, {
                0.20461432671651483`, 0.07637372818411155}, {
                0.20585617212180818`, 0.07729957727071599}, {
                0.20833986293239484`, 0.07915127544392483}, {
                0.2133072445535682, 0.08285467179034257}, {0.2232420077959149,
                 0.09026146448317805}, {0.24311153428060836`, 
                0.10507504986884902`}, {0.2443290196086536, 
                0.10598273747160561`}, {0.24554650493669883`, 
                0.10689042507436217`}, {0.24798147559278932`, 
                0.10870580027987534`}, {0.2528514169049703, 
                0.11233655069090169`}, {0.2625912995293323, 
                0.11959805151295438`}, {0.28207106477805627`, 
                0.13412105315705977`}, {0.3210305952755042, 
                0.16316705644527058`}, {0.3987244897959184, 
                0.22109119174412067`}}], 
               Line[{{0.40127551020408164`, 0.22312746006019912`}, {
                0.48443648039284554`, 0.2938884152451279}, {
                0.5699233045152912, 0.36662841956325426`}, {
                0.5987244897959183, 0.3911351007177587}}], 
               
               Line[{{0.6012755102040817, 0.39305766877253334`}, {
                0.732138185275487, 0.4789561832035206}, {0.7987244897959184, 
                0.5226635629940792}}], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAHTHtiQyk6T+5goKDncbgPzb/YLZT
ruw/0qhQRreM4j9MTcCCRbjsPx2M46qEkuI/Y5sfTzfC7D9ob3YPUpjiP5A3
3uca1uw//jWc2Oyj4j/pb1sZ4v3sPynD52oiu+I/nOBVfHBN7T+A3X6Pjeni
PwHCSkKN7O0/LhKt2GNG4z8YEKoOf/btP3n1Pz0xTOM/Ll4J23AA7j/D2NKh
/lHjP1r6x3NUFO4/WZ/4apld4z+0MkWlGzzuP4QsRP3OdOM/ZqM/CKqL7j/b
RtshOqPjP8yENM7GKu8/iXsJaxAA5D86D8sCkTXvP0DF4hNcBuQ/qJlhN1tA
7z/4Dry8pwzkP4OujqDvVe8/ZaJuDj8Z5D862OhyGIHvP0LJ07FtMuQ/qGJ/
p+KL7z/5Eq1auTjkPxbtFdyslu8/sFyGAwU/5D/xAUNFQazvPx7wOFWcS+Q/
qCudF2rX7z/7Fp74ymTkPxa2M0w04u8/smB3oRZr5D+EQMqA/uzvP2mqUEpi
ceQ/fWisD4317z/Df2dpYHbkP6eDzMo=
                "]], 
               
               Line[{{1.0012755102040816`, 0.6406906360599344}, {
                1.0029484390136711`, 0.6413413701187699}, {
                1.0055826833813366`, 0.6423660356750741}, {
                1.0068998055651694`, 0.6428783684532263}, {1.008216927749002, 
                0.6433907012313783}, {1.0108511721166678`, 
                0.6444153667876826}, {1.0161196608519991`, 
                0.6464646979002913}, {1.017436783035832, 
                0.6469770306784435}, {1.0187539052196648`, 
                0.6474893634565956}, {1.0213881495873305`, 
                0.6485140290128999}, {1.0266566383226616`, 
                0.6505633601255085}, {1.0371936157933241`, 
                0.6546620223507257}, {1.0582675707346494`, 
                0.6628593468011601}, {1.1369227129030104`, 
                0.6934545398650283}, {1.1987244897959184`, 
                0.7174941289319617}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA9P5cq2w48z8E1fMkFP3mPw4dp+/k
5PQ/qH6dFekL6D9AVoPd4+n0P7m21XsRD+g/co9fy+Lu9D/L7g3iORLoP9YB
GKfg+PQ/7l5+rooY6D+e5ohe3Az1PzQ/X0csJeg/LrBqzdM09T/A/yB5bz7o
P01DLqvChPU/14Ck3PVw6D9+fAqZwYn1P+i43EIedOg/sLXmhsCO9T/58BSp
RnfoPxQon2K+mPU/HGGFdZd96D/cDBAauqz1P2JBZg45iug/bNbxiLHU9T/u
AShAfKPoP4xptWagJPY/BoOrowLW6D/qQK2ICyr2P5My325v2eg/RxilqnYv
9j8e4hI63NzoPwLHlO5MOvY/NkF60LXj6D95JHR2+U/2P2f/SP1o8eg/1vtr
mGRV9j/zrnzI1fToPzTTY7rPWvY/f16wk0L46D+SqlvcOmD2PwsO5F6v++g/
pZo87ixh9j/AiHphSPzoPwD0v14=
                "]], 
               
               Line[{{1.4012755102040815`, 0.7814680977739555}, {
                1.4024622524621388`, 0.7817181407132545}, {
                1.4051079980981398`, 0.7822755911714071}, {
                1.4064308709161404`, 0.7825543164004833}, {1.407753743734141, 
                0.7828330416295597}, {1.410399489370142, 
                0.7833904920877122}, {1.415690980642144, 
                0.7845053930040173}, {1.426273963186148, 
                0.7867351948366276}, {1.4686058933621644`, 
                0.7956544021670686}, {1.547629076117258, 
                0.8123043434282715}, {1.5987244897959185`, 
                0.8230699897463037}}], 
               Line[CompressedData["
1:eJwBkQFu/iFib1JlAgAAABgAAAACAAAAW2XDEdOe+T979gMMvVrqP/tq1Jsp
evs/4+pSUe4L6z9UNl2RLn/7P9K0U1DNDes/rAHmhjOE+z/BflRPrA/rP16Y
93E9jvs/oBJWTWoT6z/BxRpIUaL7P106WUnmGus/hyBh9HjK+z/YiV9B3inr
PxPW7UzIGvw/zChsMc5H6z9soXZCzR/8P7zybDCtSes/xGz/N9Ik/D+rvG0v
jEvrP3YDESPcLvw/ilBvLUpP6z/ZMDT570L8P0d4cinGVus/n4t6pRdr/D/B
x3ghvmXrP/hWA5sccPw/sZF5IJ1n6z9QIoyQIXX8P6Bbeh98aes/Armdeyt/
/D9+73sdOm3rP2XmwFE/k/w/PBd/GbZ06z++sUlHRJj8PyvhfxiVdus/Fn3S
PEmd/D8aq4AXdHjrP8gT5CdTp/w/+T6CFTJ86z8rQQf+Zrv8P7ZmhRGug+s/
sKqrJ9jA/D9dkVVmtYXrPzQUUFFJxvw/BLwlu7yH6z8MAaNUk8f8P8PjHsA3
iOs/4xm+yQ==
                "]], 
               
               Line[{{1.8012755102040816`, 0.860781265504581}, {
                1.8023956352454178`, 0.8609265005180444}, {
                1.8037242586975861`, 0.8610987693611133}, {
                1.8063815056019226`, 0.8614433070472509}, {
                1.8170104932192683`, 0.8628214577918014}, {
                1.8382684684539596`, 0.8655777592809023}, {
                1.8807844189233422`, 0.8710903622591043}, {
                1.9601756422651684`, 0.8813841999695518}, {
                1.9987244897959184`, 0.8863824297952568}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEAmvFRRs1/sPxMP8AjE
+gBAJIasVEXI7D/SvYqHSf0AQHdBk1ZVyew/kmwlBs//AEDK/HlYZcrsPxLK
WgPaBAFAcHNHXIXM7D8ShcX97w4BQLxg4mPF0Ow/EPua8hsjAUBTOxhzRdns
PwznRdxzSwFAgfCDkUXq7D/MleBa+U0BQNSrapNV6+w/jER72X5QAUAnZ1GV
ZezsPwuisNaJVQFAzN0emYXu7D8KXRvRn18BQBjLuaDF8uw/CNPwxctzAUCv
pe+vRfvsP8iBi0RRdgFAAmHWsVX87D+IMCbD1ngBQFUcvbNl/ew/B45bwOF9
AUD6koq3hf/sPwZJxrr3hwFARoAlv8UD7T/G92A5fYoBQJk7DMHVBO0/hqb7
twKNAUDs9vLC5QXtPwUEMbUNkgFAkW3AxgUI7T/Essszk5QBQOQop8gVCe0/
ubOE3fyWAUBkTSwQGgrtP03YqwU=
                "]], 
               
               Line[{{2.201275510204082, 0.9077208679257764}, {
                2.2025743146728987`, 0.9078261195034764}, {
                2.2039086887592343`, 0.9079342535461291}, {2.206577436931906, 
                0.9081505216314348}, {2.21191493327725, 0.9085830578020461}, {
                2.222589925967937, 0.9094481301432688}, {2.2439399113493117`, 
                0.911178274825714}, {2.2866398821120604`, 
                0.9146385641906045}, {2.3704807786936803`, 
                0.9214328021631831}, {2.398724489795918, 
                0.9237215956074487}}], 
               Line[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0Cf0kZ0vJDtP7VTRwOU
RARArNwbU7rf7T+IS7iFHEcEQLuYXYR34O0/XEMpCKVJBEDKVJ+1NOHtPwIz
Cw22TgRA6MwiGK/i7T9OEs8W2FgEQCS9Kd2j5e0/6NBWKhxtBECenTdnjevt
PxpOZlGklQRAkF5Te2D37T/tRdfTLJgEQJ8alawd+O0/wD1IVrWaBECu1tbd
2vjtP2YtKlvGnwRAzE5aQFX67T+zDO5k6KkEQAk/YQVK/e0/hgRf53CsBEAY
+6I2B/7tP1r8z2n5rgRAJ7fkZ8T+7T8A7LFuCrQEQEUvaMo+AO4/TMt1eCy+
BECCH2+PMwPuPx/D5vq0wARAkduwwPAD7j/yuld9PcMEQKCX8vGtBO4/xrLI
/8XFBECvUzQjawXuP5mqOYJOyARAvg92VCgG7j/s5rcQMMoEQEByA9G0Bu4/
HGGeuA==
                "]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEDojgtjpwjuP7mBbg75
1ARAOua7ZC0L7j+Med+QgdcEQMMKW7FTDO4/MmnBlZLcBEDWU5lKoA7uP39I
hZ+05gRA++UVfTkT7j/SXmhcMOkEQGVy9P1ZFO4/JHVLGazrBEDO/tJ+ehXu
P8qhEZOj8ARAoReQgLsX7j8U+52GkvoEQEdJCoQ9HO4/qK22bXAOBUCTrP6K
QSXuP9AS6DssNgVAK3PnmEk37j8h3UrYo4UFQFsAubRZW+4/isI7r1WIBUCv
IN7CklzuP/KnLIYHiwVAA0ED0ctd7j/Ccg40a5AFQKqBTe09YO4/ZAjSjzKb
BUD6AuIlImXuP6gzWUfBsAVAmgULl+pu7j8uime23tsFQNgKXXl7gu4/lm9Y
jZDeBUArK4KHtIPuP/9USWRC4QVAgEunle2E7j/QHysSpuYFQCeM8bFfh+4/
cbXubW3xBUB3DYbqQ4zuP7TgdSX8BgZAFhCvWwyW7j86N4SUGTIGQFQVAT6d
qe4/1mIZNp00BkCDB+JTwaruP3OOrtcgNwZAsvnCaeWr7j+s5dgaKDwGQBDe
hJUtru4/HpQtoTZGBkDMpgjtvbLuP7q/wkK6SAZA+pjpAuKz7j9X61fkPUsG
QCmLyhgGte4/kEKCJ0VQBkCHb4xETrfuPwLx1q1TWgZAQzgQnN677j+eHGxP
11wGQHIq8bECve4/O0gB8VpfBkChHNLHJr7uP9hzlpLeYQZA0A6z3Uq/7j+F
gFGqyWMGQI7cabopwO4/Y/8KZA==
                "]], 
               Line[CompressedData["
1:eJwVz30s1HEcB/A78f1KzmnVWiYPrdQpFHqQ8vlMjZWHIkqdyehELSexmIfE
xIQkslms2mztmLNFK5Ut5EphkYcKU4o7176/5XTOc7/+eO+913/vt32UPFhm
JBAInPj8b1//tC2r4gjaOeUd/faGwURAVnNCPMHSWnmeppVBduqG8JkEgtnh
UU0xbQxsaxRL168RTBSFjo/zDlv8jDdSCAbJD8JoO4MPComqKJug2M1ktreD
QexAS+zaXIIr47NbT6oYGBuFmJXnEWRlU8FdvL3OZgY8KCTYre+pV71j0ED7
+hT3CRY2V8a86mRQdiF9TKUgaOq9e6Cmm0G4Tc+csI+gMEjalDLAwGJTYtPL
foKpBcuxgkEGb9ZtuJo8RHC67ZF1Pm+H1VK1eoTg+D51TsUQA043MdCjJthh
nRz87Cv/7/3y06plggXqYk43yuBJknO8hyPFdVmtEvkkg3PyTxLdLoqFL2Qj
et6iS0m/6lwomuhM72aqGSSebw6320tRLzthKNIw8Dzu40eR4pDfcEedlkG3
bcSO/lCKVRv10VMcg7+dRT8SblJ0UEqqZQYGw2v6YxdzKNpf3Bz6k3ervzWX
d4uite1a8+g5BiXdioXq2/yeO4bUyHkGjr2q9V3lFFfiVaHSRQYRX4S+EgXF
QWeZKEjAwVGrY12NdRR7J8Lae3jvlJacQiXFrmr/tEAhB4Zhm8gzjRTbLNw1
fkYclI55pua2UFQyo7c+xhx0TCbXfu+lmF//MP2QKQd1O17vudJPMSemzO0l
73txxs8NgxQzbfKnPFZzEKktbRePUEwqloftN+NgnilHDk9SjIz3cnc152DM
ZTb6vYai1MFV28BbleA1FfKb4unRbY9dRByUTX/UX/5D0T9QZOlkwUGa2/qM
WR1FXyJU1fKOSpKuytFT9G6ZyXAUc+Ci14grFygecB7WbrfkwNZKeyR6ieLt
CuVgFu9/BeJccw==
                "]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGBQBWIQ/fCpyJ45TBwO+4ovT5EQfG+/wcpvfTAHh4Oc3BYG
DyB/evVU0/tcHA6yQkbysUB+yl9lp2/8HA7Sv3Rj2oF8L7vsE41CHA5S71ZX
zQHyDes3+fGKAvmPNGduBPL/MThGq0hxOEicUr12G8ifwRJXEqTC4SA6SzbA
QAgonyxuelGNw6FedAGLK5CfcvjCV39NDodXE5R2RgL5Bk3O5b56HA7729WV
moH8E/81qjwsOByySg2/XAXyv//6XG/nA5QPcJ1RLfzePuxjZ7dWCYdDBnvu
g2Mi7+2F721dxHSEw2FPyZ6CWPH39n08tbXbj3E4TN5o+KwYyOeydonIOQk0
792y6C4gn2nGJd5r5zgcxDMmum0H8j8Fvq9YeZPDoSg6TUZQ4r39haMa/gHv
ORw0nQROHAHye9bO/j1XitNhKn+KvI7Ue3uOO0nXgmQ5HXJ8bk5xAvJbuLQ2
sitwOjh3+nFFAvnV6TvSClU5HT4yWX5tBfKzFK9edDHgdPD5xnv6PpDvMZVv
xWtXTgemu9vLJku/t2etbQyxLOR0yF/Ffe6XzHv7LR/f/NxfzOmwIZDvCL8s
MLzSIua7lXE6fPohsEsFyD/ir/8quJrTocxdbJkfkN+idLc+r5XTofaJQt0i
IN9kuofq13ZOh/3dyiXbgfwn3FtOVXdxOjAaq2WdAfJdvnaJdvZzOrQ2aod9
A/K/ZH7bxT+J0+G4hp4Pt9x7+yX3EhOmTeF04Lxg4KQA5O/c3HL3zzROBzWD
KF0TIB8AYDX2MA==
                "]], 
               Line[CompressedData["
1:eJwVx28s1HEcwPFztdnv+5MtIWV3ukLXOA6T2eL7+UWsTpdTh83dZeweZLi5
5U/ZSDa3tWppnO1G+VPs5jCSztaunOOEmlOHelIYyw1fjmrNPejXg/feewkK
NFlqLofDEbL9f3Vtv/x8KwWyqeikET7BNsM6WLooEH/tGN4OIbi+pGlhqY8C
uWths1FAMPfYjpevlYJ2H0a5FErwkC6vp8lGwUamNIIJI7jAM5kRbKcgtjnv
r5G1da2tRThLwQSvork6nOD7ZokoZYECV1TvR76QYC9VT26Vi4J4WUCyOoJg
jlE1sOKHYLp5g++OIXhyc7H0eQACccfwYGEswQ/FsihFEIIWU22qk/Vxc0qf
k4egcDygyBxHcJRd2DslRODZYV7XxBOsWHN39ycjEGUYJHQiwaMC3bO7RQie
cCVVoUBwjZqjSihB8PtIIK1nnWq8w9vXIFCcWG7zZgieExe3lpQjOCeuHHex
/ollhvx7CMaUXb6DKQQHqoL1aXoEe+aDF0npBGsNA4/8rAjkGpMjW0rwG49B
Z7UhcIY8zppk7VE11GntCG7MaT7HXyNYd0ZZPj+L4HpMnNM/k+BWE1I+XUQg
2xtdmpcRPGFRR/ptIciotH+XyglGAlm4lSCYOWvMt7DOrL9wSutGIFl6sCzK
Jvhb+jH/+T8ILidKV31yCN6ee3/QyKUh/eDL+nQuwUGrwTNHg2i4WLuylaYg
WHnJe2LsJA1j0bbSEdadPW5LGY8G5sdLEqYkOLL4w5DjNA2YubV7WEVw2adh
U10YDe92r2hvsx4Rt3fHCGlI7ozcW2XN/KowNIpoSDq0s2+9SXBDTkETI6bh
7StHeWw+wVlX+ZV61tkVjgRg/Q9PviOU
                "]], 
               Line[CompressedData["
1:eJwVymtIE1AYxvGpZcY5aWvmjSIXY5puayCWU+u8pUEGWmppmZbOW7PYZiot
rzDQLPLWzEI/JBIuwVI3K4imzczSJa5aGJQXRLRVdjKcmEZ1+vDw5wcPX65K
yHbmcDgBbP/r6XuYjoUiuJrgWBpPpySpXKCND0PwUmK57pRBScu0R6lTBIJV
936hhHn64FpRzz4EYmp4lsKct+GtghuFQNfVvGRk7lKYMs2HEAzV1dZOMy9Z
7qXlH0bwS6UN3CSnpKK+Iv5NLIKz0rzUHOZGX7Gs4SSCoB7ZoE8mJabgajeu
EsGA4YOuLIuSPTbv0RtqBJbceYmeubtU3+BZgMC2bXnYytw2OuTno0EwV8Xj
CLIpqVatF+/QIkCn4y6MMCcYtfHiJgTHXQajvXMpmQ8va47pY//ELke3ghLu
kYsirTuGjY7K5FklJa1mDxTOxfBFVFzIVVEild23L/IwvM5SNuxnjgv83J7h
i6HOlmS5zXzN9Qz/gADD1t4AEqumZN3zGC9OOAb/gmHho3xKliP4nPJsDHsX
8fKVQkoqjX2Toecw+O5y4j1k9gxONS3kYVhNd+yeYQ7xu1WcpsZgsk4oIoso
Ua9gR2QJhqjuBxM/mO29K/a1egxHVcdenLpEiUbU9MqowyDVR89UMbvdDdGf
b8KwZSrsr5FZqFNmfWzBYIvjy9w1lMjzZyeftGNIkfzsHGD+JLa+u/wUQ86C
rjG4mJI7X7llLv0Ytq+2GU4wyzsShTVmDO9dDdYKZmHuzTGvQQw1PPP3Dma7
YFzTOoQh2t+KbcydMz47g4Yx/BZNBf1h/jb3eLN0BEOyxVnoUULJP0OwGzY=

                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPFD4fT7fsVFXaNQm6xOaiKR3+e2UtdMhYXiuPOULuSpeabs
sGrr4VanlGrLRM1zzbJkNzHFqJzGhWpHD9ivda2Io09/vPfey1meGhxvyuPx
3LH/r2/+VJ40wECyelZ0JI9jC9SyM6NaBhYn9PeU6BWCSc3sKAOtM4aOBrSN
1UzimkkGNpnbLpjlc+xQj8im6gsDRZeEVkJ0hTL1met3BnS2zkJ39AYTA+PL
MXBto4d3OHrb3HyTbJ4BE5+gjMfogCmLxXpC4KPiwnRoAcfyH0iqd68m4Pfz
6t8kdJ/sYpDGloA6+ya/CB0yRu9r1xI4rHzoWouOGbILWHQm0FHVHWtE52k2
XZF4EbjzxvRDdSHHNlaxm/VSAhHeeX2/izjWkGuwkMkIOO8vS1tVzLFeYTXT
Y7EEvgar7J3Q7dbWLe9PEjib8ihGgu4uHhe/Tiegqtb9qkTr5AXRzaUE+gV+
juJzHGvu2n6ruJ6A+Mdi8sXzHCsxSy00NhLgL1kK7qEvTbjIc1sIDK6ya2tF
21RccMtsIyB1FZmOox34x9sSNQTypFE3PEo4duf0nDZomMCTvucdWnRUg5eN
4xIBt9pCayclxz49PkcHeRSisguyvNDU/BlTYkbhyoF8XSC6M3Kv5TdLCn8m
c2py0C5W+5ZbBRS6XLLYd+ipuKOzgW4UYm4rUktLOdZ/tWB6eSsFleKU9jZa
3T70tdmdQs+eJN8W9EHbcP06TwqikQSLj+i6F1Kd3p/Cgp38rk8Zx5oqnEbU
YgrukzErj6BP2H8ePrSPgrw1WpGAZpLj3zZKKPQGR3mr0CnrT/fmh1K4cTl8
YAbd/VLUsz2Mwitp2C6zco7dmMZ1fY6gYBQdqxSisx2aNNcjKewwhpp4oAd7
0jsPRlOI6wtJDEBvyfDsWJBRUFcG90eilcVH63pjKWhDMrsV6H+oYlFU
                "]], 
               Line[CompressedData["
1:eJwV0XlI02EcBvDpREPx99qwQFLUYdYEDyynZvZ+CcnhttRhnpjHTJxYIRnq
VDxyYkuboSmeofOY6ea8KmJgdkzKLMwOJVFRE43spctFh+vtj4eHDzz/Pe7p
FyXnLFks1iGa/x0uKuKyZQx8lWqLHlYTrHQLGZ/KYaAgIUPgdpXgtek/I/KL
DHCmUuVS6gZumW4lj4HwroSlLWrTy6qewVIG9PHC3h0lwVFFAnVKBQMRxvD5
4GsEazxtOzkKBtaPhNmWUCeW1LYVKBlwQqEX2DUEG7wa6sNuMlDxxIfvUEtw
maKzfPE2AzH+HCNPRbB9vk1EmpYB3+U7hVnULVnnORtDDNjVJHn3UY8Kg9Vk
jIHJD90NHnUEb+ydfWw5QffNgVLXGwQLO1h7eHN0z0pm7asneP/dlOuXfzPw
aKbvGKuJYO2mSysjQuAvCx1620Fwdbsidek0AqdVvdb5FsEZku2DumgE5kSP
wXRqZ4NBL45D8Fxk1/+ZWqlKMtakI8j0W+iy7iQ4i9/8xbYQQYspr5GvJphb
6Siw6UVgUTVY0thH8G5Qsf07DYLNXdfiReqF7bVXvQMIXuTXy7kaguviRpNP
DSNolcnzddRmL8klhQFBgFiQa+wneHFW1cGeQyBzXM/YGSD4XpVJOvcGQWRt
nPT4IP0nJIWnnkfAt55Oq6AW9viMnVxCwP45fJbREny/YOZp+RaC9vel8Z46
ghu9A1TRnxBcifkWm0Odu9oW404QZM9knhmhPizKWX7wHUHghFhyYohgK4vX
3XUmBC5Bk1GV1CvjIdmpvxBYDR+NfEZtyFb7+v1F8JGnETvoCW5ytfthNiOY
7TogiqX+B+RbJCo=
                "]]}, "Charting`Private`Tag$317522#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[1, 0, 0], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAASmXo0cDpdT6pfRWucBFkPgRDGnDf
GVQ/wGqAvJ1oQj8zn5icsxlkP5UOn5l1aFI/S83Xsp0ZdD+AYC6IYWhiP1dk
972SGYQ/dQl2f1docj/dL4dDjRmUP/DdGXtSaII/oBVPhooZpD8tyOv4T2iS
P4EIsyeJGbQ/S73Ut05ooj8qR5GIsnC0P++NDWwhuKI/0oVv6dvHtD+SXkYg
9AejPyQDLKsudrU/2v+3iJmnoz/G/aQu1NK2P2dCm1nk5qQ/DPOWNR+MuT+E
x2H7eWWnP5jdekO1/r4/vtHuPqVirD9BHFmk3lW/P2KiJ/N3sqw/6lo3BQit
vz8Gc2CnSgKtPx7seWOtLcA/ThTSD/ChrT9vaTYlANzAP9tWteA64a4/EmSv
qKU4wj/87T1B6K+wP1hZoa/w8cQ/GXME430usz/v21QKohrFPw7a9CbCU7M/
hl4IZVNDxT8DQeVqBnmzP7Njbxq2lMU/7A7G8o7Dsz8Obj2FezfGP7+qhwKg
WLQ/xYLZWgZ9xz9l4goiwoK1P1wFjbW3pcc/Wkn7ZQaotT/yh0AQac7HP06w
66lKzbU/II2nxcsfyD84fswx0xe2P7cPWyB9SMg/LeW8dRc9tj9Okg57LnHI
PyJMrblbYrY/fJd1MJHCyD8LGo5B5Ky2PxMaKYtC68g/AIF+hSjStj+qnNzl
8xPJP/Xnbsls97Y/QB+QQKU8yT/pTl8NsRy3P9ehQ5tWZck/3rVPUfVBtz+Q
O0vYzW/JP2YkRPqKS7c/8PAT6w==
                "]], 
               
               Line[{{0.20127551020408163`, 0.09262615681427668}, {
                0.2033724813112215, 0.0943452394796572}, {
                0.20461432671651483`, 0.09536329590497154}, {
                0.20585617212180818`, 0.09638135233028587}, {
                0.20833986293239484`, 0.09841746518091453}, {
                0.2133072445535682, 0.10248969088217186`}, {
                0.2232420077959149, 0.11063414228468652`}, {
                0.24311153428060836`, 0.12692304508971586`}, {
                0.2443290196086536, 0.1279211312892212}, {
                0.24554650493669883`, 0.1289192174887265}, {
                0.24798147559278932`, 0.13091538988773718`}, {
                0.2528514169049703, 0.13490773468575853`}, {
                0.2625912995293323, 0.1428924242818012}, {
                0.28207106477805627`, 0.1588618034738866}, {
                0.3210305952755042, 0.19080056185805735`}, {
                0.3987244897959184, 0.2544934886805535}}], 
               Line[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAn8hAen+u2T9i7LXCbW3QPxe0Ed4B
Ad8/moeweQgv1T9cjPtU5BbfPwLD6xuXQtU/omTly8Ys3z9s/ia+JVbVPywV
ubmLWN8/PHWdAkN91T9CdmCVFbDfP+Biiot9y9U/NpxXppQv4D8kPmSd8mfW
P2Fepl2o3uA/sPQXwdyg1z+EShuZmengPxowU2NrtNc/pjaQ1Ir04D+Ba44F
+sfXP+wOekttCuE/VOIEShfv1z92v005MjbhP/XP8dJRPdg/jCD1FLyN4T88
q8vkxtnYP7biQ8zPPOI/xmF/CLES2j/WSIHxjUfiP0iOElzkJdo/9q6+FkxS
4j/KuqWvFznaPzd7OWHIZ+I/zxPMVn5f2j+4Ey/2wJLiP9jFGKVLrNo/uUQa
ILLo4j/oKbJB5kXbP7Cb30LAKOM/bO0KmGK42z+X56Ve
                "]], 
               Line[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAtsqGI6Y94z/VFWcKzNjbP9wMLplS
n+M/ApacfDNZ3D/8cmu+EKrjP8HtZeRSZ9w/PT/mCI2/4z8/nfizkYPcP77X
252F6uM/O/wdUw+83D+/CMfHdkDkPzK6aJEKLd0/wmqdG1ns5D8hNv4NAQ/e
P/UmPQ+tbec/Xmbm7A2t4D8+4kLHinjnP1FWs2EytOA/hp1If2iD5z9ERoDW
VrvgPxYUVO8jmec/KCYawJ/J4D82AWvPmsTnP/LlTZMx5uA/eNuYj4gb6D+H
ZbU5VR/hP/yP9A9kyeg/sWSEhpyR4T9ES/rHQdToP6NUUfvAmOE/jAYAgB/f
6D+WRB5w5Z/hPx19C/Da9Og/eyS4WS6u4T8+aiLQUSDpP0bk6yzAyuE/hiUo
iC8r6T841Lih5NHhP87gLUANNuk/KsSFFgnZ4T9eVzmwyEvpPxCkHwBS5+E/
f0RQkD936T/aY1PT4wPiP8j/VUgdguk/zVMgSAgL4j8Qu1sA+4zpP79D7bws
EuI/FwJGqSaP6T8Vdcz6mRPiPwNRyC8=
                "]], 
               
               Line[{{0.8012755102040817, 0.5662775449914086}, {
                0.8024388112602567, 0.5667758571129607}, {0.8037652381656297, 
                0.5673440458907424}, {0.8064180919763757, 
                0.5684804234463056}, {0.8077445188817487, 
                0.5690486122240872}, {0.8090709457871217, 
                0.5696168010018688}, {0.8117237995978678, 
                0.5707531785574322}, {0.8170295072193599, 
                0.5730259336685588}, {0.8182677985372807, 
                0.5735563686496475}, {0.8195060898552016, 
                0.5740868036307362}, {0.8219826724910432, 
                0.5751476735929135}, {0.8269358377627265, 
                0.5772694135172682}, {0.8368421683060933, 
                0.5815128933659778}, {0.8566548293928267, 
                0.5899998530633969}, {0.8962801515662935, 
                0.6069737724582349}, {0.9739717509693491, 
                0.6402537781109471}, {0.9987244897959183, 
                0.6508568715521659}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D/hmrI42dzkP+v3397V
MPI/ms7vFg/B5j+2Z4/CSjbyP1SupHfQxeY/gNc+pr878j8NjlnYkcrmPxa3
nW2pRvI/gE3DmRTU5j9Cdlv8fFzyP2bMlhwa5+Y/mvTWGSSI8j8zyj0iJQ3n
P2Vkhv2YjfI/7anyguYR5z8w1DXhDZPyP6aJp+OnFuc/xrOUqPed8j8aSRGl
KiDnP/FyUjfLs/I//8fkJzAz5z9I8c1Uct/yP8vFiy07Wec/E2F9OOfk8j+F
pUCO/F3nP97QLBxc6vI/PoX17r1i5z90sIvjRfXyP7JEX7BAbOc/n29JchkL
8z+XwzIzRn/nP2rf+FWOEPM/UaPnkweE5z80T6g5AxbzPwqDnPTIiOc/yi4H
Ae0g8z99Qga2S5LnP5WetuRhJvM/NiK7Fg2X5z9gDmbI1ivzP/ABcHfOm+c/
cmcJu/kt8z8YCIsgq53nPzxVuO8=
                "]], 
               Line[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAA9P5cq2w48z8TYi/0TqXnP8FddHM1
PPM/cPHEWYun5z+MzSNXqkHzP6gpB7HEquc/Iq2CHpRM8z8ZmotfN7HnP01s
QK1nYvM/+nqUvBy+5z+k6rvKDo7zP708pnbn1+c/bpdPI2qT8z9nFVS2Edvn
PzdE43vFmPM/Eu4B9jve5z/KnQotfKPzP2efXXWQ5Oc/8VBZj+m48z8RAhV0
OfHnPz639lPE4/M/ZceDcYsK6D/ZgzHdeTn0Pw9SYWwvPeg/Dh2n7+Tk9D9h
Zxxid6LoP0BWg93j6fQ/dFA6B2ul6D9yj1/L4u70P4Y5WKxeqOg/1gEYp+D4
9D+sC5T2Ra7oP57miF7cDPU/9q8LixS66D8usGrN0zT1P4v4+rOx0eg/TUMu
q8KE9T+zidkF7ADpP358CpnBifU/xXL3qt8D6T+wteaGwI71P9hbFVDTBuk/
FCifYr6Y9T/9LVGaugzpP9wMEBq6rPU/R9LILokY6T9s1vGIsdT1P9wauFcm
MOk/jGm1ZqAk9j8FrJapYF/pP+pArYgLKvY/n1UXPZRi6T9HGKWqdi/2Pzf/
l9DHZek/AseU7kw69j9qUpn3LmzpP2CejBC4P/Y/A/wZi2Jv6T++dYQyI0X2
P52lmh6Wcuk/eSR0dvlP9j/P+JtF/XjpP9b7a5hkVfY/aKIc2TB86T8002O6
z1r2PwJMnWxkf+k/kqpb3Dpg9j+b9R0AmILpP6WaPO4sYfY/BF6FBieD6T9M
4iOz
                "]], 
               
               Line[{{1.4012755102040815`, 0.7978815603050673}, {
                1.4024622524621388`, 0.7981094428656987}, {
                1.4051079980981398`, 0.7986174885565113}, {
                1.4064308709161404`, 0.7988715114019176}, {1.407753743734141, 
                0.7991255342473239}, {1.410399489370142, 
                0.7996335799381366}, {1.415690980642144, 
                0.8006496713197617}, {1.426273963186148, 
                0.8026818540830122}, {1.4275968360041484`, 
                0.8029358769284184}, {1.428919708822149, 
                0.8031898997738247}, {1.4315654544581502`, 
                0.8036979454646374}, {1.436856945730152, 
                0.8047140368462625}, {1.4474399282741564`, 
                0.806746219609513}, {1.4686058933621644`, 
                0.8108105851360138}, {1.547629076117258, 
                0.8259849038334468}, {1.5987244897959185`, 
                0.8357964308323034}}], 
               
               Line[{{1.6012755102040817`, 0.8362486057938685}, {
                1.717324837408056, 0.8551044787516782}, {1.7185502699170643`, 
                0.8553035889082379}, {1.7197757024260723`, 
                0.8555026990647975}, {1.7222265674440886`, 
                0.8559009193779169}, {1.7271282974801212`, 
                0.8566973600041555}, {1.7369317575521863`, 
                0.8582902412566329}, {1.7565386776963166`, 
                0.8614760037615876}, {1.7577641102053247`, 
                0.8616751139181472}, {1.7589895427143327`, 
                0.8618742240747069}, {1.7614404077323491`, 
                0.8622724443878262}, {1.7663421377683817`, 
                0.863068885014065}, {1.7761455978404468`, 
                0.8646617662665422}, {1.795752517984577, 0.867847528771497}, {
                1.7970811414367454`, 0.8680634055510221}, {
                1.7984097648889135`, 0.8682792823305472}, {
                1.7987244897959185`, 0.8683304193169143}}], 
               
               Line[{{1.8012755102040816`, 0.8687072317848853}, {
                1.8063815056019226`, 0.8693860199470799}, {
                1.8170104932192683`, 0.8707990315948806}, {
                1.8382684684539596`, 0.8736250548904821}, {
                1.8807844189233422`, 0.8792771014816851}, {
                1.9601756422651684`, 0.8898313261504656}, {
                1.9987244897959184`, 0.894955988303741}}], 
               Line[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEDnT9YxLqbsPxMP8AjE
+gBAHLJ5mc4i7T/SvYqHSf0AQCFH6MYSJO0/kmwlBs//AEAm3Fb0ViXtPxLK
WgPaBAFAMQY0T98n7T8ShcX97w4BQEZa7gTwLO0/EPua8hsjAUBvAmNwETft
PwznRdxzSwFAwlJMR1RL7T/MleBa+U0BQMfnunSYTO0/jER72X5QAUDNfCmi
3E3tPwuisNaJVQFA16YG/WRQ7T8KXRvRn18BQOv6wLJ1Ve0/CNPwxctzAUAV
ozUel1/tP8iBi0RRdgFAGjikS9tg7T+IMCbD1ngBQB/NEnkfYu0/B45bwOF9
AUAp9+/Tp2TtPwZJxrr3hwFAPkuqibhp7T/G92A5fYoBQEPgGLf8au0/hqb7
twKNAUBJdYfkQGztPwUEMbUNkgFAU59kP8lu7T/Essszk5QBQFg002wNcO0/
ubOE3fyWAUDHpwegQ3HtP75Romc=
                "]], 
               Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAe3+uVTacAUBhGMVMlHPtP9o8REjf
ngFAI93h0Jl07T+vuuzgmqEBQMHldn6mde0/WrY9EhKnAUAA96DZv3ftP7Gt
33QAsgFAfRn1j/J77T9enCM63ccBQHZenfxXhO0/uHmrxJbzAUBp6O3VIpXt
P2s0u9kJSwJAT/yOiLi27T/A0NWsuE0CQK0yek7At+0/FW3wf2dQAkAKaWUU
yLjtP7+lJSbFVQJAxtU7oNe67T8TF5BygGACQD6v6Lf2vu0/u/lkC/d1AkAt
YkLnNMftPwu/Dj3koAJADMj1RbHX7T9gWykQk6MCQGn+4Au52O0/tfdD40Gm
AkDHNMzRwNntP18weYmfqwJAg6GiXdDb7T+zoePVWrYCQPt6T3Xv3+0/W4S4
btHLAkDqLamkLejtP6tJYqC+9gJAyJNcA6r47T80LCE+P/kCQBVpPwqg+e0/
vg7g27/7AkBiPiIRlvrtP9DTXRfBAANA++jnHoL87T/0XVmOwwoDQCw+czpa
AO4/PnJQfMgeA0CR6IlxCgjuP8dUDxpJIQNA3b1seAAJ7j9QN863ySMDQCqT
T3/2Ce4/YvxL88ooA0DCPRWN4gvuP+veCpFLKwNADxP4k9gM7j90wckuzC0D
QFvo2prODe4//qOIzEwwA0Covb2hxA7uP1JNHneWMANAdT1U7OAO7j/RePlT

                "]], 
               Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAFBlI7881A0DmbSONkxDuP6wQQ+HP
PANAU6zg/W8S7j/Qmj5Y0kYDQLEOBkwZFe4/WX399VJJA0BIZ4+fwxXuP+Jf
vJPTSwNA4L8Y820W7j/0JDrP1FADQA5xK5rCF+4/Ga81RtdaA0Bs01Doaxru
P2LDLDTcbgNAKJibhL4f7j/16xoQ5pYDQJ4hMb1jKu4/tVNHA5REBEB0tXs7
kVjuP4hLuIUcRwRAQbBHqD1Z7j9cQykIpUkEQA6rExXqWe4/AjMLDbZOBECo
oKvuQlvuP04SzxbYWARA3YvbofRd7j/o0FYqHG0EQEZiOwhYY+4/Gk5mUaSV
BEAYD/vUHm7uP+1F19MsmARA5QnHQctu7j/APUhWtZoEQLIEk653b+4/Zi0q
W8afBEBM+iqI0HDuP7MM7mToqQRAgeVaO4Jz7j+GBF/ncKwEQE7gJqgudO4/
WvzPafmuBEAb2/IU23TuPwDssW4KtARAtdCK7jN27j9My3V4LL4EQOq7uqHl
eO4/H8Pm+rTABEC3toYOknnuP/K6V309wwRAhLFSez567j/Gssj/xcUEQFGs
Hujqeu4/mao5gk7IBEAep+pUl3vuP+zmtxAwygRAL2AQXhd87j+oGdVc
                "]], 
               Line[CompressedData["
1:eJwVzX8s1HEcx3H0/X70R90WVs6MDGOoFebMj73f3SbKmn6ZMq5chI5U5kom
zq/dpFwc/VFHlxWV+8Z1WV0/LrIVq/mxOFu5MN0q9V76S2qrb3+89tzjr1eA
smR/npuLi0uQuP8VzPPawjEOK71LLFBJ8FhzUvLrHYdz1d7uCRcImso/6jR2
Dj1DU1cF0ZGFg20tHzg8r+6b01cRVKXUd1qcHCZ7VpiOaggmFQVZ275waEsK
yp4QHVSWKu1d4lB27u06eQ3BqHFDa9cPDkNm/YsCawm8fhsaWlY5ZN3DYc46
gh7TQPEpCY/DcZIelZZg3ONzfEQMj6g03lQ3EwTM7p7pqucxtv/V1SYDQeNQ
/P10LY9hPscdrIPgZ3dEg/tFHn1ruWCN6KEzkmiVjkfX9B3msk6C3LWTzZHX
eBxdsb5RGMW/qMPJg308KlBw3X6LYGtj/oDjPY+1Y3rVVC9Be8mhSzoHj+rY
KHOaieDvwV258nkeC4wTKyOix/3DPW47edxTKml4LhCcfkjFxcs8btykvdHd
R2CZKwv+wxjeUVRMlVsI4mR1emkkw7HvOeD3lGBaKY0xRDM80SRL14kuvSzY
N8sYsvD1KrdnBL2fZnxCExgmFjxqd4r2028xxuxkeG9BQoKNwGobkltTGCZr
FtcEvCDIWMpYTExluOBvlbaK1slrQpL2MpRm5yWdHSRwW542HchkqLU/uQ4v
CTp8i9LsWQwD1VfM/aLjU1yXM48wtHnlvw4cJpgpbW9x5DDMfJDgaBNdX73v
7sgxhkKu8us30f8A2AsMfA==
                "]], 
               Line[CompressedData["
1:eJwVz30s1HEcB3BP+35THuaplh6ubOXIqEXLxO/Tg2e1Vqycy4nSnZJLiEgP
OtZkk9LS00ylduhUJEQIlzycu3M9LDZZzon9PNVJ6eHTH++99/rv/V4dnbDn
sJGBgYEr5n/7h6Q7GIsIKPtV7qfaWEa781yd+DiB+gXG24rRF9Ls+N/EBJzv
lfo+Q3MeSH+fOkmgyDsosB29f74PzqYSSE28snsc3Sl1kuddIODRzxFsbmcZ
4btGoZWEwP2U19HBaBOj0IWFOQRsrI7ERqJ9wjN33r5MYNr3cfxFdCVVq6XX
CchkWzJ60dcOZQzKpQScssKLhHKW4a9UzBmqCaxwvqq+8YZlLJYmVtdrCOhL
BOIKdLON3YnkDwQUy1zMW9BrTSN0ugEC583b/MbQEzPadwodgeFJfa13B/7r
+PPszh8CFTW84iH0oyTX457OFHx8HeJdOlmGl6B0mnGhsKSRNd2KNo9LGi53
ozC5qb40DJ0oqOOv8qBQwg0dzER7BfkFU6BAzLL3KtE9nEiuJoxCj2rUM6WL
Zb6/zRsSn6cgiHpCmrpZpn+RRjifRaHPjPqp0S0hyydysikE1vIlWnR+j/TX
3VwK7tYLTMx7WMZZJbftLqRg2hppyENHfjT0d5JSeOpoNj+D3mEf2F1VToHb
d9CLKlhmXUT+XpBRuHOu5rQ9+kf/yqh9VRRyPkbPAbpg0CtN0kiBn1urz0O3
jySXfVbh/onYKcdelinnNmyI11BIv/VyvRf6qsjkxY/3+N/fWrwLHTVW0Go5
QOFTcQObhP7Jyga8RyhU7rEdb0YPus3GdIxSWPNXtE6Dlot9voaOU7hZ9ipO
h7423aU/OkVBYnJ01ELJMukbbc/MzlD4WdnEdUBHJ0UYZ+kpJBxYLPRAB1SX
XLKYo/DF9NjDALSbftTy5i8KvOfN2gg0x35se8xvChdF6UIR+h/27Wsq
                "]], 
               Line[CompressedData["
1:eJwVzWtIE1AYBuC1NM/R1iAVYaGk0zILZ+VYGnm+ymKIl6kRUiG6zDAtb6Oy
tcZyKmpZmVMxzZCSQsxMy5QuP1reEK95KXJiFM20s7zMW7l1+vHx8vDC+7nL
U6POcDkcjhe7/zn53el1JRfB/cjfop4BSp4FhjdEIwQLb3r4WYOUlCl14gl7
BF2pQl47c8Ka8NAiH0HmUL9d3BAlIUHJnZrNCKQ5223rmXern4fznBG4Sq5x
V5ktnIMnPQUI2it2rt39SEm5TawiyhOBQJ471zHM+tMu4oFtCDrSNOcdR9j+
+35zxA4ECvVVYyyz3/XDl8J8EfRVZhjMzJ1W7yvSfQiyR2O7hWOULK3Oq4NC
EcyESmrUnyk5Pptf6KNA8FZijJRMUOJoeFHD1SOQ80Iaa42UFG1UqVraEbzU
GW8vM9vvD45J6ULg4JaXFjJFCbd8kDfSi6DJVy+izHORpstPPiGwkQU9FU9T
0v/BO0JmQlBbvKdO/4uSG/X3/lQJMEy5bHn0dY4S9EU+EuWK4cCDVq3/PCVa
e59Gu60Y7njHJOQyK8++Skz3whAYoBP6LFByzn14INgPQ+EJfk26mRKpbtPj
6SMYdlWtr+YsU2Kr0hwLSMeQ6jFT7rZGSfPszMq7TAz+WQ3cZOaExJjqoxcx
rPRlpLQw6yNEP6OVGLJVK0RmYf89xtUXcjCUjW34obFS4l8m9TLnYTgl6pb1
Mn9zaO5WFmBwz73ZJuCYSLC5wDn/Foa6vU5FTcwLSYtt/GIMaQWjS1bmh4b4
uNISDOLJivjQdSbS2qQd/1uKIUlbbClh/gdf1hoX
                "]], 
               Line[CompressedData["
1:eJwVx30s1HEcwPFzbez3/cUWeTquUrKruJhGf9Dnc47IU06R4i4Ty8rDaBRa
keWmB6ZQu4gU5rkZwsZynpcMFdVmNaaaVR8TqZzW9cd7773sYpJD44QCgUCi
7/+zrjaHuZVx+Mj2T3CSkGBA8wl7H3P4enZxQ7eJIDexePptE4funl5zZoYE
QrMlAxMthxvrS/UyRtCqjqwtHuBw+pVh7LDeMbqhQJthDpsbbMVBPIF2ofye
ZIzD6Ei/wojNBNc6A5zk0xz2d1dcSDYhMFDVRlxa5DA/I9ij3JRAUKdqmTNl
aL7W8PKXiGDo60xShTnDqfkPHfk2BLecFdIoK4aFE2aVIlsCy0550xsxQ64+
K9VDTCAdljSMSBj+jQqwzN5OELWwXNN8iOFn7WK0kT1Bl536YeY5hl0Fe1bM
nQiuxAlU7okM07OUszV6e9dliFeSGbrGFw25SwkmnBPKEtMYNst+3z+5n+AL
KDTR2QyrVkY8y10ILFQ2pYdLGd48Fa+2dyNI1bTcNtUyVDrUilyB4JlOo9YO
MCxp7z7dp7dOlZeTOsxwzHv8yVEkUO9Spk2NMfQ4sypNkBGUNTLlnRmGokq5
vFpOMNgb52j6jeG09cfzln4EzE7hoCWGxnU/nlbrHZLrsSN1maHPQaOfrkcI
3vuabZ1aY9gWLs0O8Sf4PvF8vUjI4527l4vzAwms5m1ebLHiMdjYumc9hEDp
YzTYJ+Ixr8xReENBUFW73Jsi5rFnH/pahRI4Joy2Tu7k0dH/7OSBYwQp422N
Obt5jH2XadGvd4dzZY2LhMcH8QWRiuMEstV0TZETj0zdvpAYRpB3IqZY5syj
l8XoXp3eoUHbLpbqfX21pNM4nOAfM+0dmg==
                "]], 
               Line[CompressedData["
1:eJwVz30s1HEcB/DTlbTvd3TcPP2RXW5m5yHtduYO+30whTwMy1NYnGfnPPVA
Hcp6uDIbeRpaDCNFTqwH65jI0C7CNKswq7hJv7QUmdWnPz777LV9ts/7LUjM
Dkvex+FwRDj/N9/Kj52SEHi8Z3BjKIJlIoqFpaFuBOw9RcrP6MZlE5WBO4HJ
2WN840iWWfbePd/rSUCRIRlwRWccnEnn+RDorQNDNbonXSsf9iUQ7nyiS4P+
+fp+XK4fga3RU2EL6JKKktC3QQSkPyLuiaJYptrKSVoZReBlYJarDq11UBvx
lARmDRpSTGNYxnXOQncnh0D3395QN7RG1VHJzyeg3pvwiEe36MasLQsIeO7s
mD5Aq7MPONmUEuj4Hj3kdYZlwvpKQ51qCaiWrCxzY1lmVVbU4D9IQKitn5iK
ZxleQJ5jqTGFCwX1juVylmkeNiEyHgWhmBvwBO0i7dZvmlGY2VCkLqGD7dfa
E6woOMuh5XgSy9w2jBd4CSmsBq1azKP3j/ibc2QUIm0lXJsUlvnlLuAUJ1OQ
vple0KSxzPW+wUVJGt6rZb8X0HyHWO1GBoUanzY+N51lxNZ1l+JyKGw+uxhy
Gp2zTbc8LlPobD3yaget79/W71ZQsC5UaLwzWabAsXa8r4rCuHhel4k2ahN3
ZNZin2/MejXarkqZ9L4R88vN7FbRibmfFgfaKZQFDzSWKVhmc+2qNq8T8x0S
Pu9HXzlrc1fUhflGyuc/optCYqIbein4SBN4Llks88FperbwBYVdW6Obc+im
dV4Rd4jCiu81/R90Yme4Xfkw5knlBAqU+D+1Zsp8lELPLdWjk2i98F1B8xj2
fbh9WInuWrE8KpqgoNKdy69Gf/3y9LDLJAVLi/CNVvQ/HZ0ttw==
                "]], 
               Line[CompressedData["
1:eJwV0HlI02EYB/Dpynn83tezAzFFiZmZaTWM0vY+kRPFDuzANI82z0LanDJD
1JZph0VC3pLrH8OS8piS5spkHcOE0vBIZUmmszx4C8E8pvb2x8OXzz9f+D6e
MvnpZEsejydk9z8btd9vX/rMwUGDROUqpySvUqoYHeRgKDTrlJF5k/OUfn6U
A8WnpBGVghJH27lUlykO6oyS+acZlAwY/Bw10xxkeIq1i8xVRfJO7xkOxMmB
2ceUlLhbLHBBlIOvc0ILI/OepeUW6TIHnFmwxSGLklCTwNyIEGS6fgxWqShp
1pCdk/EInMq+jGE1JQs5CwKpFEG7SO4ewxwYVT9rTEQQN2gnfcyss7dvHU5D
UL9VYgq6TskH9bejvUoEwdXtv9MKKBmT5SVobyJI1jzc/LaQEitvXY26EUHH
kxT/7DuUhPPl+WvNrC+cr9Qz3xv3kuW0IuDPPGpDxWxvVbFPVgeCE74jh+qY
3WxiOlL1CCaeR4T036Vk/+zS4MkhBHatAdG+9ymJawp03LGOIP71SsH4A0pe
xCzhPh6GhuHDu/eVUoKtOrkbfAx//+T0FzB3xx6x/mWNoUS46iEso8TLNmSj
zRlDd8nqq/RySkxJkfPHfTB4ycyLy5WUiB2cZzd8MchzgzURVZRU6gZ+avdi
0FXkSmqZw5zOT24XYTjTay6Fakoa3sSPTYoxFIrWAm7VUHLFNb0n9ywGk9X6
ZZda9q/3fgb/KAwHPMVOKcweGfTdRDSGa0H5L9uZr7q16MtjMfSe67poo6Gk
z6DsDkvAsE2xLrjAvCtT1LUqxZBULG56xlykjmzoScRguTId8oP5H9z4HNk=

                "]], 
               Line[CompressedData["
1:eJwV0X8s1HEcx/Hzoync5yMjP9LK6XBa0axLs/m+l5K5U0c1jYr065h2kxIu
i+ZkVC5Rkbhv16Hzo/zaqZ3yRwvrl5+TZRLLj5Z9U3EtSe/+eO25x98v93hF
5ElzHo/nhfvfPVKlwCKBwNrxw7YhlRyTvyGwtTOJQKrd9oJ49MSrP00ZCgKr
nKzmU9HFgqyGsXMEfDdWd1WiTe9ydXWXCCiDphRzaJkyVBt7mQDZbRheoeGY
Gk9r1l5FgJVcCXZFR2deK0/LJ9B5yMspGG30Kb65q4SAQ8rpZ8XoLBWbPaIn
UFc9ZRvAcgz/glXYsXoCHz6BiwRdJj9jP/mIgI1bmfAoulmyQ8u1EEhQS4Ny
0JOre1+YPyfgmd6o6EFLKngrRf0ENGHKPvl9jlljiL1+fpFAySy5U6rlmPrp
dXeJlEKmv9hjUccxefdUcaN7KTi7NZyyq+KYE5GzwoYICk2Wnnoh2s1ofBwe
RWF60HGrDJ1fGPPyajyF/WnzQTq0XFw6Z51OQdTeEr2vmmMEOQ6hVlUUBkL8
i7Q1HPM34CJ/qIaCwrd2sA09PDvRV1VLwdrZw+UtWh3VfCSkkQIzY6/5hV72
iUxRGSnoC77Xhz/kmJHewgqLfgpZPY3dJnRbrul4/yAF1yciPl+P/wTGirTv
KbSyrEyAlui2tOwcpfDl7I0hKfpp2pvu7BkKBx2TP7PoW5u3FUZ8pfBtadrb
gE4eLz/gzlEomIxLeo32liZ97PhJocMg+7GAtjQbeKA2UYjRdIltazlmrDUw
Me43hYU8yHBHGxO1vn5LFNTJbe1i9O31NvPLyxQ2RfuZSdH/AAKFKBM=
                "]]}, 
              "Charting`Private`Tag$317522#2"], {}}, {{}, {}, {}, {}, {}}, \
{{}, {}, {}, {}, {}}}, {}}, {
          DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
           AxesOrigin -> {0, 0}, FrameTicks -> {{Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
              Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
           GridLines -> {None, None}, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
           DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
           Axes -> {True, True}, AxesLabel -> {None, None}, 
           AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, False}, {True, False}}, FrameLabel -> {{
              Style["Cumulative distribution", 20, 
               GrayLevel[0]], None}, {
              Style["Cav2.1 intensity (A.U.)", 20, 
               GrayLevel[0]], None}}, FrameStyle -> Directive[
             GrayLevel[0], FontSize -> 20, 
             AbsoluteThickness[2]], 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {
            "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
             None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, 
           PlotRange -> {{0., 3.999999918367347}, {0., 0.9902755247577152}}, 
           PlotRangeClipping -> True, PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         Placed[
          Unevaluated[
           LineLegend[{
             Directive[
              Opacity[1.], 
              GrayLevel[0], 
              AbsoluteThickness[2]], 
             Directive[
              Opacity[1.], 
              RGBColor[1, 0, 0], 
              AbsoluteThickness[2]]}, {
             Style["WT", 20], 
             Style["KO", 20]}, LegendMarkers -> None, LabelStyle -> {}, 
            LegendLayout -> "Column"]], {0.9, 0.2}, Identity]]& ],
       AutoDelete->True,
       Editable->True,
       SelectWithContents->False,
       Selectable->True],
      TraditionalForm], {576., -189.}, {Center, Center}, {360., 360.}]}, {}},
  AspectRatio->0.6,
  ContentSelectable->True,
  ImageSize->1000,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.852254226812677*^9, 3.8522551110382366`*^9, 
  3.8550446657122884`*^9},
 CellLabel->
  "Out[1062]=",ExpressionUUID->"5da63d6a-8945-4de0-b212-13996f9436b3"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     FormBox[
      TagBox[
       FormBox[
        GraphicsBox[{{{{{}, {}, 
             TagBox[
              {GrayLevel[0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6wnYn7klRLPgRDGnDf
GVQ/nEc13AMSKT8zn5icsxlkP4lQDzPNETk/S83Xsp0ZdD8AVXzesRFJP1dk
972SGYQ/O9cyNKQRWT/dL4dDjRmUP1kYDl+dEWk/oBVPhooZpD/ouHv0mRF5
P4EIsyeJGbQ/L4kyP5gRiT8qR5GIsnC0P2vwptlNfok/0oVv6dvHtD+nVxt0
A+uJPyQDLKsudrU/ISYEqW7Eij/G/aQu1NK2PxHD1RJFd4w/DPOWNR+MuT/2
/Hjm8dyPP5jdekO1/r4/X7jfxiVUkz9BHFmk3lW/P/3rGZSAipM/6lo3BQit
vz+cH1Rh28CTPx7seWOtLcA/2YbI+5AtlD9vaTYlANzAP1FVsTD8BpU/EmSv
qKU4wj9D8oKa0rmWP1hZoa/w8cQ/Jywmbn8fmj/v21QKohrFP4htIR9AUpo/
hl4IZVNDxT/orhzQAIWaP7Njbxq2lMU/qDETMoLqmj8Obj2FezfGPyk3APaE
tZs/pfDw3yxgxj+KePumReibPzxzpDreiMY/6rn2VwYbnD9qeAvwQNrGP6s8
7bmHgJw/xYLZWgZ9xz8sQtp9ikudP1wFjbW3pcc/jYPVLkt+nT/yh0AQac7H
P+zE0N8LsZ0/II2nxcsfyD+tR8dBjRaeP7cPWyB9SMg/DonC8k1Jnj9Okg57
LnHIP27KvaMOfJ4/fJd1MJHCyD8vTbQFkOGePxMaKYtC68g/kI6vtlAUnz+q
nNzl8xPJP/DPqmcRR58/QB+QQKU8yT9QEaYY0nmfP9ehQ5tWZck/sFKhyZKs
nz+QO0vYzW/JP44TcGCguZ8/N/clDg==
                "]], 
               LineBox[{{0.20127551020408163`, 0.032336598336439246`}, {
                0.2033724813112215, 0.03423741624424753}, {
                0.20461432671651483`, 0.03536309793679629}, {
                0.20585617212180818`, 0.03648877962934505}, {
                0.20833986293239484`, 0.038740143014442535`}, {
                0.2133072445535682, 0.04324286978463753}, {0.2232420077959149,
                 0.05224832332502754}, {0.24311153428060836`, 
                0.07025923040580756}, {0.2443290196086536, 
                0.07136283069203121}, {0.24554650493669883`, 
                0.07246643097825484}, {0.24798147559278932`, 
                0.07467363155070211}, {0.2528514169049703, 
                0.0790880326955967}, {0.2625912995293323, 
                0.08791683498538584}, {0.28207106477805627`, 
                0.10557443956496414`}, {0.3210305952755042, 
                0.14088964872412074`}, {0.3987244897959184, 
                0.2113159629107768}}], LineBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAn8hAen+u2T8H1229hVfLPxe0Ed4B
Ad8/bb4195Np0j9cjPtU5BbfPzXNfQYTfdI/omTly8Ys3z/928UVkpDSPywV
ubmLWN8/jPlVNJC30j9CdmCVFbDfP6w0dnGMBdM/NpxXppQv4D/pqrbrhKHT
P2Fepl2o3uA/Zpc34HXZ1D+EShuZmengPy6mf+/07NQ/pjaQ1Ir04D/0tMf+
cwDVP+wOekttCuE/hdJXHXIn1T92v005MjbhP6MNeFpuddU/jCD1FLyN4T/i
g7jUZhHWP7biQ8zPPOI/XXA5yVdJ1z/WSIHxjUfiP5R1j9J7XNc/9q6+FkxS
4j/KeuXbn2/XPzd7OWHIZ+I/OIWR7ueV1z+4Ey/2wJLiPxKa6RN44tc/2Hls
G3+d4j9Inz8dnPXXP/jfqUA9qOI/fqSVJsAI2D84rCSLub3iP+uuQTkIL9g/
uUQaILLo4j/Fw5lemHvYP9qqV0Vw8+I//cjvZ7yO2D/6EJVqLv7iPzTORXHg
odg/Ot0PtaoT4z+g2PGDKMjYP1pDTdpoHuM/1t1HjUzb2D+wm99CwCjjP4rv
vIm57dg/UGjmiQ==
                "]], 
               LineBox[{{0.6012755102040817, 0.3914498204627063}, {
                0.602707593256919, 0.3923524474202853}, {0.6040189648065841, 
                0.39317899118098737`}, {0.6066417079059144, 
                0.39483207870239156`}, {0.6118871941045749, 
                0.39813825374519984`}, {0.61319856565424, 
                0.39896479750590186`}, {0.6145099372039051, 
                0.39979134126660393`}, {0.6171326803032354, 
                0.4014444287880081}, {0.6223781665018959, 
                0.4047506038308164}, {0.6328691388992168, 
                0.4113629539164329}, {0.6538510836938587, 
                0.42458765408766597`}, {0.732138185275487, 
                0.47393119472820233`}, {0.7987244897959184, 
                0.51589984546157}}], 
               LineBox[{{0.8012755102040817, 0.5174111404027091}, {
                0.8962801515662935, 0.5700974559911071}, {0.9739717509693491, 
                0.613182552319305}, {0.9987244897959183, 
                0.6269095722921686}}], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAwcspeDkF8D+lQnctUxrkP+v3397V
MPI/+19k0Qwi5j+2Z4/CSjbyP14cLnwnJ+Y/gNc+pr878j/A2PcmQizmPxa3
nW2pRvI/hVGLfHc25j9Cdlv8fFzyPxBDsifiSuY/mvTWGSSI8j8lJgB+t3Pm
P2Vkhv2YjfI/iOLJKNJ45j8w1DXhDZPyP+qek9PsfeY/xrOUqPed8j+wFycp
IojmP/FyUjfLs/I/OQlO1Iyc5j9I8c1Uct/yP07smypixeY/E2F9OOfk8j+w
qGXVfMrmP97QLBxc6vI/E2UvgJfP5j90sIvjRfXyP9jdwtXM2eY/n29JchkL
8z9iz+mAN+7mP2rf+FWOEPM/xYuzK1Lz5j80T6g5AxbzPyZIfdZs+OY/yi4H
Ae0g8z/swBAsogLnP5WetuRhJvM/Tn3a1rwH5z9gDmbI1ivzP7E5pIHXDOc/
cmcJu/kt8z+AcMIg1w7nPyoVuMk=
                "]], 
               LineBox[{{1.2012755102040815`, 0.7215274305713377}, {
                1.2021994123405053`, 0.7217949300763156}, {1.203531589880046, 
                0.7221806384953363}, {1.2061959449591275`, 
                0.7229520553333777}, {1.2115246551172902`, 
                0.7244948890094605}, {1.222182075433616, 0.727580556361626}, {
                1.2234898928959086`, 0.7279592117515994}, {1.224797710358201, 
                0.7283378671415728}, {1.2274133452827862`, 
                0.7290951779215195}, {1.2326446151319568`, 
                0.7306097994814129}, {1.2431071548302977`, 
                0.7336390426011998}, {1.2640322342269796`, 
                0.7396975288407737}, {1.3058823930203434`, 
                0.7518145013199213}, {1.3839420330101317`, 
                0.7744152879539358}, {1.3987244897959183`, 
                0.7786952865778829}}], 
               LineBox[{{1.4012755102040815`, 0.7793685514294805}, {
                1.547629076117258, 0.8142456818364067}, {1.5987244897959185`, 
                0.8264220944502523}}], 
               LineBox[{{1.6012755102040817`, 0.8269845688832326}, {
                1.717324837408056, 0.8505045884279133}, {1.795752517984577, 
                0.8663997308164733}, {1.7987244897959185`, 
                0.8670020680878142}}], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAjpj2RAbS/D9jiVTyacLrPyCO++Ta
If4/VkURKxg37D/6edViBCz+P0Gj+AagOuw/rVGJXldA/j8WX8e+r0HsPxMB
8VX9aP4/wNZkLs9P7D/fX8BESbr+PxbGnw0ObOw/zFWtA16//j8LdZP70W3s
P7hLmsJyxP4/ACSH6ZVv7D+SN3RAnM7+P+uBbsUdc+w/RQ8oPO/i/j/APT19
LXrsP6u+jzOVC/8/a7Xa7EyI7D93HV8i4Vz/P8CkFcyLpOw/YlAwVtxh/z+y
xBjaRqbsP06DAYrXZv8/pOQb6AGo7D8m6aPxzXD/P4gkIgR4q+w/1LTowLqE
/z9RpC48ZLLsPzBMcl+UrP8/4aNHrDzA7D8cf0OTj7H/P9PDSrr3wew/B7IU
x4q2/z/F403IssPsP94Xty6BwP8/qSNU5CjH7D+M4/v9bdT/P3GjYBwVzuw/
eBbNMWnZ/z9jw2Mq0M/sP2NJnmVk3v8/VeNmOIvR7D86r0DNWuj/PzkjbVQB
1ew/JuIRAVbt/z8sQ3BivNbsPxEV4zRR8v8/HWNzcHfY7D/8R7RoTPf/Pw+D
dn4y2uw/PzTWh8b6/z9smrnBZ9vsPyxW7Uk=
                "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA4eUUvJwCAEBPxj1zUN7sP0sj5TUa
CABA0L0575zg7D8iiYedEBIAQIeHW8/I5Ow/0FTMbP0lAED1Gp+PIO3sPyzs
VQvXTQBA0UEmEND97D+4VEy/ilAAQHNsUK/x/uw/Q71Ccz5TAEAVl3pOEwDt
P1qOL9ulWABAWuzOjFYC7T+JMAmrdGMAQOOWdwndBu0/5nS8ShJ5AED168gC
6g/tP6D9IopNpABAGJZr9QMi7T8TD/AIxPoAQF/qsNo3Ru0/0r2Kh0n9AEAu
Vc4gRkftP5JsJQbP/wBA/b/rZlRI7T8SyloD2gQBQJuVJvNwSu0/EoXF/e8O
AUDXQJwLqk7tPxD7mvIbIwFATpeHPBxX7T8M50Xcc0sBQDtEXp4AaO0/zJXg
WvlNAUAKr3vkDmntP4xEe9l+UAFA2RmZKh1q7T8LorDWiVUBQHfv07Y5bO0/
Cl0b0Z9fAUCymknPcnDtPwjT8MXLcwFAKfE0AOV47T/IgYtEUXYBQPhbUkbz
ee0/iDAmw9Z4AUDHxm+MAXvtPweOW8DhfQFAZJyqGB597T8GSca694cBQKBH
IDFXge0/ubOE3fyWAUDnpZEuoYftPyEzzgw=
                "]], 
               LineBox[{{2.201275510204082, 0.9230506567883279}, {
                2.2025743146728987`, 0.9231634705395169}, {
                2.2039086887592343`, 0.9232793738565928}, {2.206577436931906, 
                0.9235111804907447}, {2.21191493327725, 0.9239747937590485}, {
                2.222589925967937, 0.924902020295656}, {2.2439399113493117`, 
                0.9267564733688711}, {2.2866398821120604`, 
                0.9304653795153015}, {2.3704807786936803`, 
                0.9377477736504534}, {2.398724489795918, 
                0.9402010135902914}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAFBlI7881A0DCwwJsxxfuP7VTRwOU
RARAM85N6Pdk7j+IS7iFHEcEQFJBgMiwZe4/XEMpCKVJBEBxtLKoaWbuPwIz
Cw22TgRAr5oXadtn7j9OEs8W2FgEQCxn4em+au4/6NBWKhxtBEAlAHXrhXDu
PxpOZlGklQRAFzKc7hN87j/tRdfTLJgEQDalzs7MfO4/wD1IVrWaBEBVGAGv
hX3uP2YtKlvGnwRAk/5lb/d+7j+zDO5k6KkEQA/LL/Dage4/hgRf53CsBEAv
PmLQk4LuP1r8z2n5rgRATrGUsEyD7j8A7LFuCrQEQIyX+XC+hO4/TMt1eCy+
BEAIZMPxoYfuPx/D5vq0wARAJ9f10VqI7j/yuld9PcMEQEZKKLITie4/xrLI
/8XFBEBmvVqSzInuP5mqOYJOyARAhTCNcoWK7j/s5rcQMMoEQBQgiLoOi+4/
GcqeJg==
                "]], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAArrLhiGnPBEADsqpvUIzuP7mBbg75
1ARAEEgLb2eN7j+Med+QgdcEQDX3LYnmje4/MmnBlZLcBECAVXO95I7uP39I
hZ+05gRAFRL+JeGQ7j/SXmhcMOkEQAwPU79dke4/JHVLGazrBEACDKhY2pHu
P8qhEZOj8ARA8AVSi9OS7j8U+52GkvoEQMr5pfDFlO4/qK22bXAOBUB+4U27
qpjuP9AS6DssNgVA5rCdUHSg7j8h3UrYo4UFQLdPPXsHsO4/isI7r1WIBUDx
BA+vjrDuP/KnLIYHiwVALLrg4hWx7j/Ccg40a5AFQKEkhEoksu4/ZAjSjzKb
BUCM+coZQbTuP6gzWUfBsAVAYaNYuHq47j8uime23tsFQAz3c/XtwO4/lm9Y
jZDeBUBGrEUpdcHuP/9USWRC4QVAgWEXXfzB7j/QHysSpuYFQPfLusQKw+4/
cbXubW3xBUDhoAGUJ8XuP7TgdSX8BgZAtkqPMmHJ7j86N4SUGTIGQGGeqm/U
0e4/1mIZNp00BkAzbAmVUtLuP3OOrtcgNwZABTpoutDS7j+s5dgaKDwGQKrV
JQXN0+4/HpQtoTZGBkDzDKGaxdXuP7q/wkK6SAZAxdr/v0PW7j9X61fkPUsG
QJioXuXB1u4/kEKCJ0VQBkA8RBwwvtfuPwLx1q1TWgZAhXuXxbbZ7j+eHGxP
11wGQFdJ9uo02u4/O0gB8VpfBkAqF1UQs9ruP9hzlpLeYQZA/OSzNTHb7j+F
gFGqyWMGQHxhpnWR2+4/2RsWNw==
                "]], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAR0x7IgNpBkBn64njbdzuP+ZNgLpw
bgZAyGKllCfd7j+CeRVc9HAGQHtj2pZ93e4/H6Wq/XdzBkAtZA+Z093uP1j8
1EB/eAZAkWV5nX/e7j/LqinHjYIGQFtoTabX3+4/aNa+aBGFBkANaYKoLeDu
PwQCVAqVhwZAv2m3qoPg7j8+WX5NnIwGQCRrIa8v4e4/sAfT06qWBkDtbfW3
h+LuP5RkfODHqgZAf3OdyTfl7j9cHs/5AdMGQKR+7eyX6u4/9cqN4nCBB0B2
Qocs5wHvP9wL1Wj8gwdAePTCPD4C7z/CTBzvh4YHQHum/kyVAu8/kM6q+56L
B0B/CnZtQwPvPyrSxxTNlQdAiNJkrp8E7z9e2QFHKaoHQJtiQjBYB+8/xud1
q+HSB0DAgv0zyQzvP6wovTFt1QdAwjQ5RCAN7z+TaQS4+NcHQMTmdFR3De8/
YOuSxA/dB0DJSux0JQ7vP/rur9095wdA0hLbtYEP7z/gL/djyekHQNTEFsbY
D+8/x3A+6lTsB0DWdlLWLxDvP5TyzPZr8QdA29rJ9t0Q7z97MxR99/MHQN2M
BQc1Ee8/YnRbA4P2B0DgPkEXjBHvPy/26Q+a+wdA5KK4NzoS7z8fGutDY/0H
QK5uWFB3Eu8/bg7q3A==
                "]], 
               LineBox[{{3.001275510204082, 0.9710751784009818}, {
                3.0040658660648987`, 0.9711373244112449}, {3.00530855047641, 
                0.9711650011241961}, {3.0077939192994325`, 
                0.9712203545500987}, {3.017735394591522, 
                0.9714417682537086}, {3.0189537189257853`, 
                0.971468902425964}, {3.0201720432600485`, 
                0.9714960365982193}, {3.022608691928575, 
                0.9715503049427299}, {3.0274819892656275`, 
                0.9716588416317511}, {3.0372285839397324`, 
                0.9718759150097935}, {3.0567217732879426`, 
                0.9723100617658784}, {3.0957081519843626`, 
                0.9731783552780481}, {3.1802851297394477`, 
                0.9750620296155779}, {3.1987244897959184`, 
                0.9754727057861006}}], 
               LineBox[{{3.201275510204082, 0.9755323621653561}, {
                3.3447619504179835`, 0.9790476201661421}, {3.398724489795918, 
                0.9803696422889868}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLSLp8f68KbcDl8Mu57Xx7+0FvYp0mvh4HN5IB3r9
Lnpvv+AgP7eVII+D6tJqD8vi9/YGlmtffhTmcYjXW+ZWDuT7abxYlijJ43DZ
4bfTZyC/iy1O0VGFx2FX6lLr1yXv7VkOe4oxWPE4dKz/qXO77L39N2tFhrpU
oHnOi/h3V723b928755pBtC8M2d4fwL5Itoxe99m8TjMDP3ObV793t5YanpV
bAGPA0+GD8dmIL/gB89Xm2oeh8893xhW17y3f7nlx8vfE3gcDl3z+jSr7r19
hc60E5sn8zj8iS/9cAPI51hivDx7Go+D6cv578Tq39urTc5LuT2bx2Hl7y+v
JgH5SYVP7u1axuMwQWH+466G9/Z3dC9crtwDdE/W5ytVTe/t578WrGXez+Ng
dcFt6xYgP2llsFrvQR4HMbNZU98B+WrpU8+LHeFx+DT7balGM9A9KtcrFhzj
cTjH6BiWBOSveSShpHWSx2FV+hSzOUD+m2fbBQxO8Tg8fuPcsxnIBwCaQrVF

                "]], 
               LineBox[{{3.601275510204082, 0.9848694377528294}, {
                3.6044205455572738`, 0.9849044604182324}, {
                3.6068988062055514`, 0.9849320579755629}, {3.611855327502106, 
                0.9849872530902238}, {3.6130944578262447`, 
                0.9850010518688891}, {3.6143335881503837`, 
                0.9850148506475543}, {3.616811848798661, 
                0.9850424482048848}, {3.621768370095216, 
                0.9850976433195459}, {3.6316814126883257`, 
                0.9852080335488678}, {3.6329205430124643`, 
                0.985221832327533}, {3.634159673336603, 0.9852356311061983}, {
                3.6366379339848804`, 0.9852632286635287}, {3.641594455281435, 
                0.9853184237781897}, {3.651507497874545, 
                0.9854288140075116}, {3.6713335830607647`, 
                0.9856495944661555}, {3.749078878861765, 
                0.9865153549984607}, {3.798724489795918, 
                0.9870682014453889}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7e5TrcScyefwx+LH1MBp7+3XvpCdzefD7zBpTkdG
yaL39h1zWxPu+fE7KAtvejgLyE8Jequ6LpDfYUvn7aiDQL7Mnj0bfMP5Ha6X
6fnyLX5v39Uffawnid9BOvCK4QogP8Ns5keuSn6HpawKv28veW+v1CLiwb6M
32F73vZe5+Xv7f9Z1PBeX8Hv4PH0AVsWkH/z7eNLy1bzO9yM5mqYAORPCN8c
67aR3+GPR2zRXSD/v1ZQcesefgcHZebw8hXv7e9c7J/HfJnf4dR1P4XVK9/b
72j7nnz5Kr9DtF/FzItA/hTreM3FN/gd3hxZKPQDyPdeqrfF6R6/A9+mLyyu
q97b76o4e7LxJb9DcM+sl/eA/Gm6pv2Bb/gdnjAdSWJd/d6+8NGcEMX3/A6l
lW9vawP5Gj459w984XeYnuZwrgLIZ2G8smTCd34HzbuZ7vOB/AdbrbMSfvE7
7AqefOAokL8na7G+wV9+B+9TeyzfAPnT5bm//v/P73DH4dkmoTXv7QHOi77C

                "]]},
              Annotation[#, "Charting`Private`Tag$317723#1"]& ], 
             TagBox[
              {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[1.], 
               LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAASmXo0cDpdT6YaKK1Wp4xPgRDGnDf
GVQ/nE90mmIpED8zn5icsxlkP1fkvl0/KSA/S83Xsp0ZdD+1LmS/LSkwP1dk
972SGYQ/5NM28CQpQD/dL4dDjRmUP3smoIggKVA/oBVPhooZpD/Hz9RUHilg
P4EIsyeJGbQ/bCTvOh0pcD8qR5GIsnC0P1L2i6Ixb3A/0oVv6dvHtD83yCgK
RrVwPyQDLKsudrU/A2xi2W5BcT/G/aQu1NK2P5iz1XfAWXI/DPOWNR+MuT/F
Qry0Y4p0P5jdekO1/r4/HmGJLqrreD9BHFmk3lW/PwQzJpa+MXk/6lo3BQit
vz/qBMP90nd5Px7seWOtLcA/taj8zPsDej9vaTYlANzAP0vwb2tNHHs/EmSv
qKU4wj94f1ao8Ex9P1hZoa/w8cQ/6M4RkRvXgD/v21QKohrFP4/KNFTT94A/
hl4IZVNDxT81xlcXixiBP7Njbxq2lMU/gb2dnfpZgT8Obj2FezfGPxqsKarZ
3IE/pfDw3yxgxj/Bp0xtkf2BPzxzpDreiMY/Z6NvMEkegj9qeAvwQNrGP7Sa
tba4X4I/xYLZWgZ9xz9NiUHDl+KCP1wFjbW3pcc/84Rkhk8Dgz/yh0AQac7H
P5mAh0kHJIM/II2nxcsfyD/md83PdmWDP7cPWyB9SMg/jHPwki6Ggz9Okg57
LnHIPzNvE1bmpoM/fJd1MJHCyD+AZlncVeiDPxMaKYtC68g/JmJ8nw0JhD+q
nNzl8xPJP8xdn2LFKYQ/QB+QQKU8yT9yWcIlfUqEP9ehQ5tWZck/GFXl6DRr
hD+QO0vYzW/JP7oPPxKfc4Q/+3chYg==
                "]], 
               LineBox[{{0.20127551020408163`, 0.011011691108604237`}, {
                0.2033724813112215, 0.012592322596398097`}, {
                0.20461432671651483`, 0.013528386972247352`}, {
                0.20585617212180818`, 0.014464451348096609`}, {
                0.20833986293239484`, 0.0163365800997951}, {
                0.2133072445535682, 0.020080837603192098`}, {
                0.2232420077959149, 0.0275693526099861}, {
                0.24311153428060836`, 0.04254638262357413}, {
                0.2443290196086536, 0.04346408513215095}, {
                0.24554650493669883`, 0.04438178764072775}, {
                0.24798147559278932`, 0.04621719265788139}, {
                0.2528514169049703, 0.04988800269218867}, {0.2625912995293323,
                 0.057229622760803234`}, {0.28207106477805627`, 
                0.07191286289803235}, {0.3210305952755042, 
                0.10127934317249059`}, {0.3987244897959184, 
                0.15984258024817966`}}], 
               LineBox[{{0.40127551020408164`, 0.16182421461046725`}, {
                0.48443648039284554`, 0.2283390609507265}, {
                0.5699233045152912, 0.2967142008476575}, {0.5987244897959183, 
                0.3197503247530167}}], 
               LineBox[{{0.6012755102040817, 0.321617120466277}, {
                0.732138185275487, 0.40847530304089064`}, {0.7987244897959184,
                 0.45267098673640305`}}], 
               LineBox[{{0.8012755102040817, 0.45420661983386323`}, {
                0.8962801515662935, 0.5055282225797816}, {0.9739717509693491, 
                0.5474973026593217}, {0.9987244897959183, 
                0.5608687570505588}}], 
               LineBox[{{1.0012755102040816`, 0.5621373235223738}, {
                1.1369227129030104`, 0.623769323073604}, {1.1382548904425511`,
                 0.6243746047446265}, {1.1395870679820916`, 
                0.6249798864156488}, {1.142251423061173, 
                0.6261904497576938}, {1.147580133219336, 
                0.6286115764417838}, {1.158237553535662, 
                0.6334538298099637}, {1.1795523941683133`, 
                0.6431383365463232}, {1.1987244897959184`, 
                0.6518492761426179}}], LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAA9P5cq2w48z8hCYlRX+TkP26XTyNq
k/M/wfPsrmIk5T83RON7xZjzP32oB3MnKOU/yp0KLXyj8z/1ET37sC/lP/FQ
WY/puPM/5uSnC8Q+5T8+t/ZTxOPzP8eKfSzqXOU/2YMx3Xk59D+L1ihuNpnl
Pw4dp+/k5PQ/EG5/8c4R5j9AVoPd4+n0P9hiR7FSFeY/co9fy+Lu9D+gVw9x
1hjmP9YBGKfg+PQ/MEGf8N0f5j+e5ohe3Az1P08Uv+/sLeY/LrBqzdM09T+O
uv7tCkrmP01DLqvChPU/Cgd+6kaC5j9+fAqZwYn1P9L7RarKheY/sLXmhsCO
9T+a8A1qTonmPxQon2K+mPU/Kdqd6VWQ5j/cDBAauqz1P0mtvehknuY/bNbx
iLHU9T+HU/3mgrrmP4xptWagJPY/BaB8477y5j/qQK2ICyr2PzXux8KO9uY/
RxilqnYv9j9kPBOiXvrmPwLHlO5MOvY/xNipYP4B5z95JHR2+U/2P4QR1909
Eec/pZo87ixh9j/GRZ/IVx3nP/JD2aY=
                "]], 
               LineBox[{{1.4012755102040815`, 0.7231197441288073}, {
                1.4064308709161404`, 0.7244906210350709}, {1.407753743734141, 
                0.724842389979556}, {1.410399489370142, 0.725545927868526}, {
                1.415690980642144, 0.7269530036464663}, {1.426273963186148, 
                0.7297671552023468}, {1.4686058933621644`, 
                0.7410237614258687}, {1.547629076117258, 
                0.7620370449474283}, {1.5987244897959185`, 
                0.7756239744641575}}], LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW2XDEdOe+T8MzxEpL9foP/tq1Jsp
evs/L/xzuRq66T9UNl2RLn/7Pwa2qSWAvOk/rAHmhjOE+z/cb9+R5b7pP16Y
93E9jvs/iuNKarDD6T/BxRpIUaL7P+XKIRtGzek/hyBh9HjK+z+bmc98ceDp
PxPW7UzIGvw/BzcrQMgG6j9soXZCzR/8P97wYKwtCeo/xGz/N9Ik/D+0qpYY
kwvqP3YDESPcLvw/Yh4C8V0Q6j/ZMDT570L8P70F2aHzGeo/n4t6pRdr/D9z
1IYDHy3qP/hWA5sccPw/So68b4Qv6j9QIoyQIXX8PyBI8tvpMeo/Armdeyt/
/D/Ou120tDbqP2XmwFE/k/w/KaM0ZUpA6j8rQQf+Zrv8P99x4sZ1U+o/sKqr
J9jA/D8YlsPaDlbqPzQUUFFJxvw/Ubqk7qdY6j8MAaNUk8f8P+rl4HlFWeo/
jg6tEA==
                "]], 
               LineBox[{{1.8012755102040816`, 0.8239448731754009}, {
                1.8023956352454178`, 0.8241582973352869}, {
                1.8037242586975861`, 0.8244114479511733}, {
                1.8063815056019226`, 0.8249177491829459}, {
                1.8170104932192683`, 0.8269429541100365}, {
                1.8382684684539596`, 0.8309933639642176}, {
                1.8807844189233422`, 0.8390941836725799}, {
                1.9601756422651684`, 0.8542210708671071}, {
                1.9987244897959184`, 0.8615660145967936}}], 
               LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAA4eUUvJwCAEBOCYUGq5XrPxMP8AjE
+gBAkz+HU9s57D/SvYqHSf0AQO3Si2mGO+w/kmwlBs//AEBIZpB/MT3sPxLK
WgPaBAFA/YyZq4dA7D8ShcX97w4BQGfaqwM0R+w/EPua8hsjAUA7ddCzjFTs
PwznRdxzSwFA4aoZFD5v7D/MleBa+U0BQDw+HirpcOw/jER72X5QAUCW0SJA
lHLsPwuisNaJVQFAS/grbOp17D8KXRvRn18BQLVFPsSWfOw/CNPwxctzAUCI
4GJ074nsP8iBi0RRdgFA43NnipqL7D+IMCbD1ngBQD0HbKBFjew/B45bwOF9
AUDyLXXMm5DsPwZJxrr3hwFAW3uHJEiX7D/G92A5fYoBQLYOjDrzmOw/hqb7
twKNAUAQopBQnprsPwUEMbUNkgFAxciZfPSd7D/Essszk5QBQB9cnpKfn+w/
ubOE3fyWAUCJ04Q+OKHsP2B1pcs=
                "]], LineBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAe3+uVTacAUAkzSPBQqTsP9o8REjf
ngFA0MJt8Jil7D+vuuzgmqEBQHTbv374puw/WrY9EhKnAUC8DGSbt6nsP7Gt
33QAsgFATG+s1DWv7D9enCM63ccBQGw0PUcyuuw/uHmrxJbzAUCrvl4sK9Ds
P2s0u9kJSwJAKdOh9hz87D/A0NWsuE0CQGjz9Rl2/ew/FW3wf2dQAkCoE0o9
z/7sP7+lJSbFVQJAJlTyg4EB7T8TF5BygGACQCPVQhHmBu0/u/lkC/d1AkAe
1+MrrxHtPwu/Dj3koAJAEtslYUEn7T9gWykQk6MCQFL7eYSaKO0/tfdD40Gm
AkCRG86n8yntP18weYmfqwJAEFx27qUs7T+zoePVWrYCQA3dxnsKMu0/W4S4
btHLAkAH32eW0zztP6tJYqC+9gJA/OKpy2VS7T80LCE+P/kCQPZQl7anU+0/
vg7g27/7AkDxvoSh6VTtP9DTXRfBAANA5Zpfd21X7T/0XVmOwwoDQM5SFSN1
XO0/fUAYLEQNA0DJwAIOt13tPwYj18nEDwNAwy7w+Phe7T8Z6FQFxhQDQLgK
y858Ye0/PnJQfMgeA0ChwoB6hGbtP8dUDxpJIQNAnDBuZcZn7T9QN863ySMD
QJaeW1AIae0/YvxL88ooA0CKejYmjGvtP+veCpFLKwNAhOgjEc5s7T90wcku
zC0DQH9WEfwPbu0//qOIzEwwA0B5xP7mUW/tP1JNHneWMANAOr6r63Zv7T8f
FwY5
                "]], 
               LineBox[{{2.4012755102040817`, 0.92010755307148}, {
                2.4046933744994785`, 0.9203508683688909}, {2.409580888186021, 
                0.9206988069479161}, {2.4108027666076564`, 
                0.9207857915926724}, {2.412024645029292, 
                0.9208727762374287}, {2.414468401872563, 
                0.9210467455269413}, {2.419355915559106, 
                0.9213946841059666}, {2.429130942932191, 0.922090561264017}, {
                2.4486809976783612`, 0.923482315580118}, {2.450006067043157, 
                0.9235766463137927}, {2.4513311364079526`, 
                0.9236709770474674}, {2.453981275137544, 
                0.9238596385148169}, {2.459281552596727, 
                0.9242369614495158}, {2.4698821075150925`, 
                0.9249916073189137}, {2.491083217351824, 
                0.9265008990577095}, {2.5334854370252864`, 
                0.929519482535301}, {2.5987244897959183`, 
                0.9341638037124398}}], LineBox[CompressedData["
1:eJwBsQFO/iFib1JlAgAAABoAAAACAAAArrLhiGnPBEDMe6bwEebtPyHdStij
hQVAaiyeH9sT7j+KwjuvVYgFQG8JNnOIFO4/8qcshgeLBUBz5s3GNRXuP8Jy
DjRrkAVAe6D9bZAW7j9kCNKPMpsFQI0UXbxFGe4/qDNZR8GwBUCw/BtZsB7u
Py6KZ7be2wVA9syZkoUp7j+Wb1iNkN4FQPqpMeYyKu4//1RJZELhBUD/hsk5
4CruP9AfKxKm5gVAB0H54Dos7j9xte5tbfEFQBm1WC/wLu4/tOB1JfwGBkA7
nRfMWjTuPzo3hJQZMgZAgW2VBTA/7j/WYhk2nTQGQGPx+bzRP+4/c46u1yA3
BkBFdV50c0DuP6zl2BooPAZACX0n47ZB7j8elC2hNkYGQJCMucA9RO4/ur/C
QrpIBkByEB5430TuP1frV+Q9SwZAVJSCL4FF7j+QQoInRVAGQBecS57ERu4/
AvHWrVNaBkCfq917S0nuP54cbE/XXAZAgS9CM+1J7j87SAHxWl8GQGOzpuqO
Su4/2HOWkt5hBkBFNwuiMEvuP4WAUarJYwZAWHTqBaxL7j+XlLsO
                "]], LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAAR0x7IgNpBkCIX6xDz0zuP+ZNgLpw
bgZAIHCsTc9N7j+CeRVc9HAGQHBqOuVFTu4/H6Wq/XdzBkDBZMh8vE7uP1j8
1EB/eAZAYVnkq6lP7j/LqinHjYIGQKNCHAqEUe4/aNa+aBGFBkDzPKqh+lHu
PwQCVAqVhwZAQzc4OXFS7j8+WX5NnIwGQOQrVGheU+4/sAfT06qWBkAlFYzG
OFXuP5RkfODHqgZAqOf7gu1Y7j9cHs/5AdMGQKyM2/tWYO4/9cqN4nCBB0CV
b0XbeoDuP9wL1Wj8gwdA5vcl5/KA7j/CTBzvh4YHQDaABvNqge4/kM6q+56L
B0DWkMcKW4LuPyrSxxTNlQdAF7JJOjuE7j9e2QFHKaoHQJn0TZn7h+4/xud1
q+HSB0CceVZXfI/uPx8a60Nj/QdAVZ5EU1GX7j/KHJlA
                "]], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAA4eUUvJwCCEC5DpbBK5juP2TD0PVP
KQhABHIrVa6d7j8wgkN3TS4IQGko3Dhknu4/yP8oekg4CEAzlT0A0J/uP/f6
838+TAhAx24Aj6ei7j9W8YmLKnQIQPAhhqxWqO4/E961ogLECEBBiJHntLPu
P44MfX23xghAZ0ZdjRe07j8KO0RYbMkIQI0EKTN6tO4/ApjSDdbOCEDZgMB+
P7XuP/JR73ip2QhAcnnvFcq27j/QxShPUO8IQKRqTUTfue4/jK2b+50aCUAH
TQmhCcDuPwjcYtZSHQlALQvVRmzA7j+ECiqxByAJQFTJoOzOwO4/e2e4ZnEl
CUCgRTg4lMHuP2oh1dFEMAlAOT5nzx7D7j9IlQ6o60UJQGovxf0zxu4/BX2B
VDlxCUDOEYFaXszuP7Tx7Pm/cwlA6ZQNbLrM7j9kZlifRnYJQAQYmn0Wze4/
xE8v6lN7CUA6HrOgzs3uP4Qi3X9uhQlApyrl5j7P7j80l0gl9YcJQMKtcfia
z+4/5Au0ynuKCUDeMP4J98/uP0T1ihWJjwlAFDcXLa/Q7j/0afa6D5IJQC+6
oz4L0e4/pN5hYJaUCUBKPTBQZ9HuP7mzhN38lglAb/mizb7R7j9xN9tQ
                "]], 
               LineBox[{{3.201275510204082, 0.9631837973883022}, {
                3.2049527235388684`, 0.9632838890410498}, {3.209886242298752, 
                0.9634181766119846}, {3.21975327981852, 0.9636867517538543}, {
                3.2592214298975932`, 0.9647610523213332}, {
                3.3447619504179835`, 0.967089416573354}, {3.398724489795918, 
                0.9685582461627869}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQLSLp8f68KbfDAvtL1f//vbMX9CrSaeLjcXhysixl
uth7+wUH+bmtBHkcjj221HgM5BtYrn35UZjHYfnfP6/1xN/b+2m8WJYoyeOQ
bdhcfAzI72KLU3RU4XH4NKO/6avEe3uWw55iDFY8Dv/TVywIln5v/81akaEu
lcdBmu3WHX6F9/atm/fdM83gcfgjP3dBNJAvoh2z920Wj8M9y4SU5UC+sdT0
qtgCHoeFuc9e2ym+ty/4wfPVpprHQePqp1+5Su/tX2758fL3BB4HsyXckmdU
3ttX6Ew7sXkyj4PEvnN3xFXf23MsMV6ePY3H4ef1iQuSgXy1yXkpt2fzOOzl
ltD4DeQnFT65t2sZj4NzsYq5lvp7+zu6Fy5X7uFxCHSyDe3QfG8//7VgLfN+
oHvteATPA/lJK4PVeg/yODyzvH1GVAtoXvrU82JHeBw2mK7qiAHyX6pcr1hw
jMehyrDSZTGQv+aRhJLWSR4HF10PhldA/ptn2wUMTvE4lPlytrJpv7cHAM1b
qNE=
                "]], LineBox[CompressedData["
1:eJwV0GtI01EcxvGZpbb+5+iakNUs08imLqW20cV5fpoNhYoM8ZZNpsUKasv7
pYxBqGXRq0yNMgQhMzHdMnUjp7IUMZjQVFLSDKfWlENItmllpxcPXz5vn33Z
uvOXN/F4vANs/9tmmL171cbBGVvAvaJwSspr1Tcmxzi431QinWDeLHQMLE9y
MCWOUodEUCLgL2n8HRzclD43mZntQxJBwwIHIb/WRmeZ6yp0ptDvHIz0pCx4
SyjZ47HCnaAc7CbYP5k5wuXuULs5MCWWX19iVs57/25DCNZUF4ICIylpbyD7
51QI3MaPzpkjlKyUrXir1QiSrPq4LVJK5KkvnJ9zELy0S+rDmM2+vsaJKwjS
f1YpC5kH9dOxI3kIeuTRjXwZJVPZ5VmGSgQlPU0pMjklXqHmJ/o2BK7ewv7q
o5Qkeupu/2lHcM4WHNDO/GAmOLvMiKB5xqYdYxbUVYsLuhGk8cJEQccoEW3N
6NYMIOiKnS7qZD7sdI2dHUdQbFVGfDlOycXXckHgXwSrwztqZQpK3ma48CgP
g7HZslPFjL1M3B1PDLoqzdNK5r5Mhc83HwyL8V2NE8zB/PiNN0IMnywpraUx
lMxfSlo+LcZg7qzpf0coifETOjfCMRQ/UsTPM9ea7YuGQxik+Y5BDJQkbE+b
C5BiaI2SfchibrGopuZiMDx7ZR/3iKVEu+va8K1kDPpG4dKpOPbXe8lQZCqG
aL1Zq2Xem0utX9MxuFQ5Px4zl4g6BmoyMXQqthVYmEeH8voSsjDkioyrC8wH
86W962oMkvWMUr+TlFTok1qGczDYBb4Pw5n/AWDcFbA=
                "]], LineBox[CompressedData["
1:eJwV0HlIE2AYBvB5lJb4vSlWdqFbRRodYijVou/FDo85YSPSLp1r5oEnNbQU
2tCJibVBh5RHynRJpWZqC5vZpVZWw7Y8QEwyJEP7kBIrrfX1x8PD78/nESqz
5EnOAoFgPc//Do/OF7mkElyZURhv2Mdoqb+4vTed4C/rZfEk93jfwv1zWQSF
ufLPAfsZvSLSNI2dIZjTbQ1p4J6zFtffPU/QS/l6yHSAUY2uVjtym6De3qaq
jWTUM9ctKrGR4Kqpur4R7hspGd4TzQSNLleDfaMYbZXsMrI2guZgtUDPPeHV
/8K5i+CYIaSyQMKopFrgHmgjGCx9YIuVMrrCnHBJPU/Q3m0OIzJGG7+sqyDR
gKvNHf75cYyWVOkUozGAwsN7sju5VfLpjU0ywIDZzi4H91qL5Z40FjB0x9P4
oiN